/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.jnlp.DownloadOptions;
import net.sourceforge.jnlp.cache.Resource;

public class ResourceUrlCreator {
    protected final Resource resource;
    protected final DownloadOptions downloadOptions;

    public ResourceUrlCreator(Resource resource, DownloadOptions downloadOptions) {
        this.resource = resource;
        this.downloadOptions = downloadOptions;
    }

    public List<URL> getUrls() {
        LinkedList<URL> urls = new LinkedList<URL>();
        URL url = null;
        if (this.downloadOptions.useExplicitPack() && this.downloadOptions.useExplicitVersion()) {
            url = this.getUrl(this.resource, true, true);
            if (url != null) {
                urls.add(url);
            }
            if ((url = this.getUrl(this.resource, false, true)) != null) {
                urls.add(url);
            }
            if ((url = this.getUrl(this.resource, true, false)) != null) {
                urls.add(url);
            }
        } else if (this.downloadOptions.useExplicitPack()) {
            url = this.getUrl(this.resource, true, false);
            if (url != null) {
                urls.add(url);
            }
        } else if (this.downloadOptions.useExplicitVersion() && (url = this.getUrl(this.resource, false, true)) != null) {
            urls.add(url);
        }
        url = this.getVersionedUrlUsingQuery(this.resource);
        urls.add(url);
        urls.add(this.resource.getLocation());
        return urls;
    }

    protected URL getUrl(Resource resource, boolean usePack, boolean useVersion) {
        if (!usePack && !useVersion) {
            throw new IllegalArgumentException("either pack200 or version required");
        }
        String location = resource.getLocation().toString();
        int lastSlash = resource.getLocation().toString().lastIndexOf(47);
        if (lastSlash == -1) {
            return resource.getLocation();
        }
        String filename = location.substring(lastSlash + 1);
        if (useVersion && resource.requestVersion != null) {
            String[] parts = filename.split("\\.", 2);
            String name = parts[0];
            String extension = parts[1];
            filename = name + "__V" + resource.requestVersion + "." + extension;
        }
        if (usePack) {
            filename = filename + ".pack.gz";
        }
        location = location.substring(0, lastSlash + 1) + filename;
        try {
            URL newUrl = new URL(location);
            return newUrl;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    protected URL getVersionedUrlUsingQuery(Resource resource) {
        URL versionedURL;
        String actualLocation = resource.getLocation().getProtocol() + "://" + resource.getLocation().getHost();
        if (resource.getLocation().getPort() != -1) {
            actualLocation = actualLocation + ":" + resource.getLocation().getPort();
        }
        actualLocation = actualLocation + resource.getLocation().getPath();
        if (resource.requestVersion != null && resource.requestVersion.isVersionId()) {
            actualLocation = actualLocation + "?version-id=" + resource.requestVersion;
        }
        try {
            versionedURL = new URL(actualLocation);
        }
        catch (MalformedURLException e) {
            return resource.getLocation();
        }
        return versionedURL;
    }
}

