/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.io.PrintStream;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.LaunchHandler;
import net.sourceforge.jnlp.runtime.JNLPRuntime;

public abstract class AbstractLaunchHandler
implements LaunchHandler {
    protected final PrintStream outputStream;

    public AbstractLaunchHandler(PrintStream outputStream) {
        this.outputStream = outputStream;
    }

    protected void printMessage(LaunchException ex) {
        StringBuilder result = new StringBuilder();
        result.append("netx: ");
        result.append(ex.getCategory());
        if (ex.getSummary() != null) {
            result.append(": ");
            result.append(ex.getSummary());
        }
        if (ex.getCause() != null) {
            result.append(this.recursiveDescription(ex.getCause()));
        }
        this.outputStream.println(result);
        if (JNLPRuntime.isDebug()) {
            ex.printStackTrace(this.outputStream);
        }
    }

    private String recursiveDescription(Throwable throwable) {
        StringBuilder builder = new StringBuilder();
        builder.append(" (");
        builder.append(throwable.getMessage() == null ? "" : throwable.getMessage());
        if (throwable.getCause() != null) {
            builder.append(this.recursiveDescription(throwable.getCause()));
        }
        builder.append(")");
        return builder.toString();
    }
}

