#!/bin/sh
echo 'name: syntactic
version: 1.4
id: syntactic-1.4-a622bff1ad4c4484ac8fb2c10bbf9ef3

license: BSD3
copyright: Copyright (c) 2011-2012, Emil Axelsson
maintainer: emax@chalmers.se
stability:
homepage: http://projects.haskell.org/syntactic/
package-url:
synopsis: Generic abstract syntax, and utilities for embedded languages
description: This library provides:
             .
             * Generic representation and manipulation of abstract syntax
             .
             * Composable AST representations (partly based on Data Types à
             la Carte [1])
             .
             * A collection of common syntactic constructs, including
             variable binding constructs
             .
             * Utilities for analyzing and transforming generic abstract
             syntax
             .
             * Utilities for building extensible embedded languages based
             on generic syntax
             .
             For more information about the core functionality, see
             \"A Generic Abstract Syntax Model for Embedded Languages\"
             (ICFP 2012):
             .
             * Paper:
             <http://www.cse.chalmers.se/~emax/documents/axelsson2012generic.pdf>
             .
             * Slides:
             <http://www.cse.chalmers.se/~emax/documents/axelsson2012generic-slides.pdf>
             .
             For a practical example of how to use the library, see the
             proof-of-concept implementation Feldspar EDSL in the @examples@
             directory. (The real Feldspar [2] is also implemented using
             Syntactic.)
             .
             The maturity of this library varies between different modules.
             The core part ("Language.Syntactic") is rather stable, but many
             of the other modules are in a much more experimental state.
             .
             \[1\] W. Swierstra. Data Types à la Carte.
             /Journal of Functional Programming/, 18(4):423-436, 2008,
             <http://dx.doi.org/10.1017/S0956796808006758>.
             .
             \[2\] <http://hackage.haskell.org/package/feldspar-language>
category: Language
author: Emil Axelsson
pkgpath: lang/hs-syntactic
exposed: True
exposed-modules: Data.PolyProxy Data.DynamicAlt Language.Syntactic
                 Language.Syntactic.Syntax Language.Syntactic.Traversal
                 Language.Syntactic.Constraint Language.Syntactic.Sugar
                 Language.Syntactic.Interpretation.Equality
                 Language.Syntactic.Interpretation.Evaluation
                 Language.Syntactic.Interpretation.Render
                 Language.Syntactic.Interpretation.Semantics
                 Language.Syntactic.Constructs.Binding
                 Language.Syntactic.Constructs.Binding.HigherOrder
                 Language.Syntactic.Constructs.Binding.Optimize
                 Language.Syntactic.Constructs.Condition
                 Language.Syntactic.Constructs.Construct
                 Language.Syntactic.Constructs.Decoration
                 Language.Syntactic.Constructs.Identity
                 Language.Syntactic.Constructs.Literal
                 Language.Syntactic.Constructs.Monad
                 Language.Syntactic.Constructs.Tuple
                 Language.Syntactic.Frontend.Monad Language.Syntactic.Frontend.Tuple
                 Language.Syntactic.Frontend.TupleConstrained
                 Language.Syntactic.Sharing.SimpleCodeMotion
                 Language.Syntactic.Sharing.Utils Language.Syntactic.Sharing.Graph
                 Language.Syntactic.Sharing.StableName
                 Language.Syntactic.Sharing.Reify Language.Syntactic.Sharing.ReifyHO
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/syntactic-1.4
library-dirs: /usr/local/lib/ghc/syntactic-1.4
hs-libraries: HSsyntactic-1.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.4.0.1-3b78425c10ff2dad7acf7e8c8ae014c3
         base-4.6.0.1-03845c6da2a0b3b4d0d49cc26c0cd3c0
         constraints-0.3.2-182bd4b781a745016312e55108121dbd
         containers-0.5.0.0-ab1dae9a94cd3cc84e7b2805636ebfa2
         data-hash-0.1.0.0-263d820f301a41acd3318a0931fb78a7
         ghc-prim-0.3.0.0-d5221a8c8a269b66ab9a07bdc23317dd
         mtl-2.1.2-94c72af955e94b8d7b2f359dadd0cb62
         transformers-0.3.0.0-ff2bb6ac67241ebb987351a3db564af0
         tuple-0.2.0.1-09cbd406ad634e846023a6c018fbda8e
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-syntactic-1.4/html/syntactic.haddock
haddock-html: /usr/local/share/doc/hs-syntactic-1.4/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
