#!/bin/sh
echo 'name: skein
version: 0.1.0.9
id: skein-0.1.0.9-abb037eac2f1b11b999d73196e060a88

license: BSD3
copyright:
maintainer: Felipe Lessa <felipe.lessa@gmail.com>
stability:
homepage: https://github.com/meteficha/skein
package-url:
synopsis: Skein, a family of cryptographic hash functions.  Includes Skein-MAC as well.
description: Skein (<http://www.skein-hash.info/>) is a family of fast
             secure cryptographic hash functions designed by Niels
             Ferguson, Stefan Lucks, Bruce Schneier, Doug Whiting, Mihir
             Bellare, Tadayoshi Kohno, Jon Callas and Jesse Walker.
             .
             This package uses bindings to the optimized C implementation
             of Skein.  We provide a high-level interface (see module
             "Crypto.Skein") to some of the Skein use cases.  We also
             provide a low-level interface (see module
             "Crypto.Skein.Internal") should you need to use Skein in a
             different way.
             .
             Currently we have support for Skein as cryptographic hash
             function as Skein as a message authentication code
             (Skein-MAC).  For examples of how to use this package, see
             "Crypto.Skein" module documentation.
category: Cryptography
author: Felipe Lessa <felipe.lessa@gmail.com>, Doug Whiting
pkgpath: security/hs-skein
exposed: True
exposed-modules: Crypto.Skein Crypto.Skein.Internal
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/skein-0.1.0.9
library-dirs: /usr/local/lib/ghc/skein-0.1.0.9
hs-libraries: HSskein-0.1.0.9
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes: skein.h
depends: base-4.6.0.1-03845c6da2a0b3b4d0d49cc26c0cd3c0
         bytestring-0.10.0.2-9e8b487747800a4255d6ff7915c5210f
         cereal-0.3.5.2-a9ff0516a3b8fef3d6dca329fe564618
         crypto-api-0.10.2-83fe1c648ebc87e2da143b149727f764
         tagged-0.4.4-1d79540bc7ac025035db56fca97243b1
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-skein-0.1.0.9/html/skein.haddock
haddock-html: /usr/local/share/doc/hs-skein-0.1.0.9/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
