#!/bin/sh
echo 'name: cryptohash
version: 0.7.0
id: cryptohash-0.7.0-05377038510116cae3648d206212651d

license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability:
homepage: http://github.com/vincenthz/hs-cryptohash
package-url:
synopsis: collection of crypto hashes, fast, pure and practical
description: A collection of crypto hashes, with a practical incremental and one-pass, pure APIs,
             with performance close to the fastest implementations available in others languages.
             .
             The implementations are made in C with a haskell FFI wrapper that hide the C implementation.
category: Data, Cryptography
author: Vincent Hanquez <vincent@snarc.org>
pkgpath: security/hs-cryptohash
exposed: True
exposed-modules: Crypto.Hash.SHA1 Crypto.Hash.SHA224
                 Crypto.Hash.SHA256 Crypto.Hash.SHA384 Crypto.Hash.SHA512
                 Crypto.Hash.SHA512t Crypto.Hash.MD2 Crypto.Hash.MD4 Crypto.Hash.MD5
                 Crypto.Hash.RIPEMD160 Crypto.Hash.Skein256 Crypto.Hash.Skein512
                 Crypto.Hash.Tiger
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/cryptohash-0.7.0
library-dirs: /usr/local/lib/ghc/cryptohash-0.7.0
hs-libraries: HScryptohash-0.7.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-03845c6da2a0b3b4d0d49cc26c0cd3c0
         bytestring-0.10.0.2-9e8b487747800a4255d6ff7915c5210f
         cereal-0.3.5.2-a9ff0516a3b8fef3d6dca329fe564618
         crypto-api-0.10.2-83fe1c648ebc87e2da143b149727f764
         tagged-0.4.4-1d79540bc7ac025035db56fca97243b1
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-cryptohash-0.7.0/html/cryptohash.haddock
haddock-html: /usr/local/share/doc/hs-cryptohash-0.7.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
