#!/bin/sh
echo 'name: crypto-api
version: 0.10.2
id: crypto-api-0.10.2-83fe1c648ebc87e2da143b149727f764

license: BSD3
copyright: Thomas DuBuisson <thomas.dubuisson@gmail.com>, Francisco Blas Izquierdo Riera (klondike) (see AUTHORS)
maintainer: Thomas DuBuisson <thomas.dubuisson@gmail.com>
stability: stable
homepage: http://trac.haskell.org/crypto-api/wiki
package-url:
synopsis: A generic interface for cryptographic operations
description: A generic interface for cryptographic operations (hashes, ciphers, randomness).
             Maintainers of hash and cipher implementations are
             encouraged to add instances for the classes defined
             in Crypto.Classes.  Crypto users are similarly
             encouraged to use the interfaces defined in the Classes
             module.
             Any concepts or functions of general use to more than
             one cryptographic algorithm (ex: padding) is within
             scope of this package.
category: Data, Cryptography
author: Thomas DuBuisson <thomas.dubuisson@gmail.com>, Francisco Blas Izquierdo Riera (klondike)
pkgpath: security/hs-crypto-api
exposed: True
exposed-modules: Crypto.Classes Crypto.Types Crypto.HMAC
                 Crypto.Modes Crypto.Random Crypto.Padding
hidden-modules: Crypto.Util Crypto.CPoly
trusted: False
import-dirs: /usr/local/lib/ghc/crypto-api-0.10.2
library-dirs: /usr/local/lib/ghc/crypto-api-0.10.2
hs-libraries: HScrypto-api-0.10.2
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.4.0.1-3b78425c10ff2dad7acf7e8c8ae014c3
         base-4.6.0.1-03845c6da2a0b3b4d0d49cc26c0cd3c0
         bytestring-0.10.0.2-9e8b487747800a4255d6ff7915c5210f
         cereal-0.3.5.2-a9ff0516a3b8fef3d6dca329fe564618
         entropy-0.2.1-e04df750e6744c28057fbb36cf2ffb3c
         largeword-1.0.5-82dd481b5726c3ef76953d4efb7e64af
         tagged-0.4.4-1d79540bc7ac025035db56fca97243b1
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-crypto-api-0.10.2/html/crypto-api.haddock
haddock-html: /usr/local/share/doc/hs-crypto-api-0.10.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
