#!/bin/sh
echo 'name: cprng-aes
version: 0.2.3
id: cprng-aes-0.2.3-bf53f2f7edee0a758ee0abe767f6a3e2

license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability: experimental
homepage: http://github.com/vincenthz/hs-cprng-aes
package-url:
synopsis: Crypto Pseudo Random Number Generator using AES in counter mode.
description: Simple crypto pseudo-random-number-generator with really good randomness property.
             .
             Using ent, a randomness property maker on one 1Mb sample:
             Entropy = 7.999837 bits per byte.
             Optimum compression would reduce the size of this 1048576 byte file by 0 percent.
             Chi square distribution for 1048576 samples is 237.02
             Arithmetic mean value of data bytes is 127.3422 (127.5 = random)
             Monte Carlo value for Pi is 3.143589568 (error 0.06 percent)
             .
             Compared to urandom with the same sampling:
             Entropy = 7.999831 bits per byte.
             Optimum compression would reduce the size of this 1048576 byte file by 0 percent.
             Chi square distribution for 1048576 samples is 246.63
             Arithmetic mean value of data bytes is 127.6347 (127.5 = random).
             Monte Carlo value for Pi is 3.132465868 (error 0.29 percent).
category: Cryptography
author: Vincent Hanquez <vincent@snarc.org>
pkgpath: security/hs-cprng-aes
exposed: True
exposed-modules: Crypto.Random.AESCtr
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/cprng-aes-0.2.3
library-dirs: /usr/local/lib/ghc/cprng-aes-0.2.3
hs-libraries: HScprng-aes-0.2.3
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-03845c6da2a0b3b4d0d49cc26c0cd3c0
         bytestring-0.10.0.2-9e8b487747800a4255d6ff7915c5210f
         cereal-0.3.5.2-a9ff0516a3b8fef3d6dca329fe564618
         crypto-api-0.10.2-83fe1c648ebc87e2da143b149727f764
         cryptocipher-0.2.8-979c0a72e3007a99d08f2eef7758b565
         entropy-0.2.1-e04df750e6744c28057fbb36cf2ffb3c
         random-1.0.1.1-023a342365721422ffd5a919bc8708bb
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-cprng-aes-0.2.3/html/cprng-aes.haddock
haddock-html: /usr/local/share/doc/hs-cprng-aes-0.2.3/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
