#!/bin/sh
echo 'name: cpphs
version: 1.13.3
id: cpphs-1.13.3-7402b0002a60f35ee0c31667e8bb7ad4

license: LGPL
copyright: 2004-2012, Malcolm Wallace
maintainer: Malcolm Wallace <Malcolm.Wallace@me.com>
stability:
homepage: http://haskell.org/cpphs/
package-url:
synopsis: A liberalised re-implementation of cpp, the C pre-processor.
description: Cpphs is a re-implementation of the C pre-processor that is both
             more compatible with Haskell, and itself written in Haskell so
             that it can be distributed with compilers.
             .
             This version of the C pre-processor is pretty-much
             feature-complete and compatible with traditional (K&R)
             pre-processors.  Additional features include: a plain-text mode;
             an option to unlit literate code files; and an option to turn
             off macro-expansion.
category: Development
author: Malcolm Wallace <Malcolm.Wallace@me.com>
pkgpath: devel/cpphs
exposed: True
exposed-modules: Language.Preprocessor.Cpphs
                 Language.Preprocessor.Unlit
hidden-modules: Language.Preprocessor.Cpphs.CppIfdef
                Language.Preprocessor.Cpphs.HashDefine
                Language.Preprocessor.Cpphs.MacroPass
                Language.Preprocessor.Cpphs.Options
                Language.Preprocessor.Cpphs.Position
                Language.Preprocessor.Cpphs.ReadFirst
                Language.Preprocessor.Cpphs.RunCpphs
                Language.Preprocessor.Cpphs.SymTab
                Language.Preprocessor.Cpphs.Tokenise
                Text.ParserCombinators.HuttonMeijer
trusted: False
import-dirs: /usr/local/lib/ghc/cpphs-1.13.3
library-dirs: /usr/local/lib/ghc/cpphs-1.13.3
hs-libraries: HScpphs-1.13.3
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-03845c6da2a0b3b4d0d49cc26c0cd3c0
         directory-1.2.0.1-ee04c884b72040489d2e2ca6dd62e6ac
         old-locale-1.0.0.5-6729cb9d9cc62d150655de8fc5401b91
         old-time-1.1.0.1-029c40e673a46f6084b935f654a6fa28
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-cpphs-1.13.3/html/cpphs.haddock
haddock-html: /usr/local/share/doc/hs-cpphs-1.13.3/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
