#!/bin/sh
echo 'name: aeson
version: 0.6.0.2
id: aeson-0.6.0.2-57b0d605c39e15cb98cf7d86e3d2ef6b

license: BSD3
copyright: (c) 2011 Bryan O'\''Sullivan
           (c) 2011 MailRank, Inc.
maintainer: Bryan O'\''Sullivan <bos@serpentine.com>
stability: experimental
homepage: https://github.com/bos/aeson
package-url:
synopsis: Fast JSON parsing and encoding
description: A JSON parsing and encoding library optimized for ease of use
             and high performance.
             .
             To get started, see the documentation for the @Data.Aeson@ module
             below.
             .
             For release notes, see
             <https://github.com/bos/aeson/blob/master/release-notes.markdown>
             .
             /Note/: if you use GHCi or Template Haskell, please see the
             @README@ file for important details about building this package,
             and other packages that depend on it:
             <https://github.com/bos/aeson#readme>
             .
             Parsing performance on a late 2010 MacBook Pro (2.66GHz Core i7),
             for mostly-English tweets from Twitter'\''s JSON search API:
             .
             * 0.8 KB, 32-bit GHC 6.12.3: 30538 msg\/sec (24.9 MB\/sec)
             .
             * 0.8 KB, 64-bit GHC 7.0.3: 31204 msg\/sec (25.4 MB\/sec)
             .
             * 6.4 KB, 32-bit GHC 6.12.3: 6731 msg\/sec (42.3 MB\/sec)
             .
             * 6.4 KB, 64-bit GHC 7.0.3: 6627 msg\/sec (41.7 MB\/sec)
             .
             * 11.8 KB, 32-bit GHC 6.12.3: 3751 msg\/sec (43.2 MB\/sec)
             .
             * 11.8 KB, 64-bit GHC 7.0.3: 3381 msg\/sec (38.9 MB\/sec)
             .
             * 31.2 KB, 32-bit GHC 6.12.3: 1306 msg\/sec (39.8 MB\/sec)
             .
             * 31.2 KB, 64-bit GHC 7.0.3: 1132 msg\/sec (34.5 MB\/sec)
             .
             * 61.5 KB, 32-bit GHC 6.12.3: 616 msg\/sec (37.0 MB\/sec)
             .
             * 61.5 KB, 64-bit GHC 7.0.3: 534 msg\/sec (32.1 MB\/sec)
             .
             Handling heavily-escaped text is a little more work.  Here is
             parsing performance with Japanese tweets, where much of the text
             is entirely Unicode-escaped.
             .
             * 14.6 KB, 32-bit GHC 6.12.3: 2315 msg\/sec (33.1 MB\/sec)
             .
             * 14.6 KB, 64-bit GHC 7.0.3: 1986 msg\/sec (28.4 MB\/sec)
             .
             * 44.1 KB, 32-bit GHC 6.12.3: 712 msg\/sec (30.7 MB\/sec)
             .
             * 44.1 KB, 64-bit GHC 7.0.3: 634 msg\/sec (27.3 MB\/sec)
             .
             * 82.9 KB, 32-bit GHC 6.12.3: 377 msg\/sec (30.5 MB\/sec)
             .
             * 82.9 KB, 64-bit GHC 7.0.3: 332 msg\/sec (26.9 MB\/sec)
             .
             Encoding performance on the same machine and data:
             .
             * English, 854 bytes: 43439 msg\/sec (35.4 MB/sec)
             .
             * English, 6.4 KB: 7127 msg\/sec (44.8 MB/sec)
             .
             * Engish, 61.5 KB: 765 msg\/sec (46.0 MB/sec)
             .
             * Japanese, 14.6 KB: 4727 msg\/sec (67.5 MB/sec)
             .
             * Japanese, 44.1 KB: 1505 msg\/sec (64.8 MB/sec)
             .
             (A note on naming: in Greek mythology, Aeson was the father of Jason.)
category: Text, Web, JSON
author: Bryan O'\''Sullivan <bos@serpentine.com>
pkgpath: devel/hs-aeson
exposed: True
exposed-modules: Data.Aeson Data.Aeson.Encode Data.Aeson.Generic
                 Data.Aeson.Parser Data.Aeson.Types Data.Aeson.TH
hidden-modules: Data.Aeson.Types.Generic Data.Aeson.Functions
                Data.Aeson.Parser.Internal Data.Aeson.Types.Class
                Data.Aeson.Types.Internal
trusted: False
import-dirs: /usr/local/lib/ghc/aeson-0.6.0.2
library-dirs: /usr/local/lib/ghc/aeson-0.6.0.2
hs-libraries: HSaeson-0.6.0.2
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: attoparsec-0.10.4.0-d9fd97cfc1a1748b3cde35adf7fd233b
         base-4.6.0.1-03845c6da2a0b3b4d0d49cc26c0cd3c0
         blaze-builder-0.3.1.1-71a2ae53eb5daf9e6673db8b47b3b6b5
         bytestring-0.10.0.2-9e8b487747800a4255d6ff7915c5210f
         containers-0.5.0.0-ab1dae9a94cd3cc84e7b2805636ebfa2
         deepseq-1.3.0.1-5cc4cd89bdc2e8f6db1833d95ec36926
         dlist-0.5-6480552fbf191185cc86167748682e90
         ghc-prim-0.3.0.0-d5221a8c8a269b66ab9a07bdc23317dd
         hashable-1.1.2.5-e0f2541518f84d3123a819112b4ffe20
         mtl-2.1.2-94c72af955e94b8d7b2f359dadd0cb62
         old-locale-1.0.0.5-6729cb9d9cc62d150655de8fc5401b91
         syb-0.4.0-c48d52f3188b986ddaa9dd9ae40072f8
         template-haskell-2.8.0.0-fea87269e8939065140c93e716ec3dfc
         text-0.11.3.1-06d227f06409a354e0c77a385328bada
         time-1.4.0.1-10dc4804a19dc0000fab79908f1a9f50
         unordered-containers-0.2.3.0-c7952fe8bed178bdf8ed4d090730c9da
         vector-0.10.0.1-869166d5d49db46ce6c328ea5f8defbf
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-aeson-0.6.0.2/html/aeson.haddock
haddock-html: /usr/local/share/doc/hs-aeson-0.6.0.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
