/* gcp.vapi generated by valac 0.19.0, do not modify. */

namespace Gcp {
	[CCode (cheader_filename = "gcp.h")]
	public abstract class BackendImplementation : GLib.Object, Gcp.Backend {
		public BackendImplementation ();
		public abstract Gcp.Document create_document (Gedit.Document document);
		protected virtual void destroy_document (Gcp.Document document);
		protected virtual void on_document_changed (Gcp.Document doc);
	}
	[CCode (cheader_filename = "gcp.h")]
	public class Diagnostic : GLib.Object, Gcp.SourceRangeSupport {
		public struct Fixit {
			public Gcp.SourceRange range;
			public string replacement;
		}
		public enum Severity {
			NONE,
			INFO,
			WARNING,
			ERROR,
			FATAL,
			NUM;
			public string to_string ();
		}
		public Diagnostic (Gcp.Diagnostic.Severity severity, Gcp.SourceLocation location, Gcp.SourceRange[] ranges, Gcp.Diagnostic.Fixit[] fixits, string message);
		public string to_markup (bool include_severity = true);
		public string to_string ();
		public Gcp.Diagnostic.Fixit[] fixits { get; }
		public Gcp.SourceLocation location { get; }
		public string message { get; }
		public Gcp.Diagnostic.Severity severity { get; }
	}
	[CCode (cheader_filename = "gcp.h")]
	public class DiagnosticColors {
		public DiagnosticColors (Gtk.StyleContext context);
		public Gdk.RGBA? @get (Gcp.Diagnostic.Severity severity);
		public void mix_in_color (Gtk.Widget widget, Gdk.RGBA dest);
		public void mix_in_widget (Gtk.Widget widget);
		public Gdk.RGBA error_color { get; }
		public Gdk.RGBA info_color { get; }
		public Gdk.RGBA warning_color { get; }
	}
	[CCode (cheader_filename = "gcp.h")]
	public class DiagnosticMessage : Gtk.EventBox {
		public DiagnosticMessage (GtkSource.View view, Gcp.Diagnostic[] diagnostics);
		protected override void destroy ();
		protected override bool draw (Cairo.Context context);
		protected override void get_preferred_height_for_width (int width, out int minimum_height, out int natural_height);
		protected override void get_preferred_width (out int minimum_width, out int natural_width);
		protected override Gtk.SizeRequestMode get_request_mode ();
		public void reposition ();
		protected override void style_updated ();
		public Gcp.Diagnostic[] diagnostics { get; set; }
	}
	[CCode (cheader_filename = "gcp.h")]
	public class DiagnosticTags : GLib.Object {
		public DiagnosticTags (Gtk.TextView view);
		public new Gtk.TextTag? @get (Gcp.Diagnostic.Severity severity);
		public Gtk.TextTag? error_tag { get; }
		public Gtk.TextTag? fixit_tag { get; }
		public Gtk.TextTag? info_tag { get; }
		public Gtk.TextTag? location_tag { get; }
		public Gtk.TextTag? warning_tag { get; }
	}
	[CCode (cheader_filename = "gcp.h")]
	public class Document : GLib.Object {
		public Document ();
		public override void dispose ();
		protected void emit_changed ();
		public static string? mark_category_for_severity (Gcp.Diagnostic.Severity severity);
		public bool source_range (Gcp.SourceRange range, out Gtk.TextIter start, out Gtk.TextIter end);
		public Gedit.Document document { get; construct; }
		public static string error_mark_category { get; }
		public static string info_mark_category { get; }
		public bool is_modified { get; }
		public GLib.File? location { get; }
		public virtual bool tainted { get; set; }
		public string text { get; }
		public static string warning_mark_category { get; }
		public signal void changed ();
		public signal void location_changed (GLib.File? previous_location);
	}
	[CCode (cheader_filename = "gcp.h")]
	public class Log {
		public Log ();
		[Diagnostics]
		[PrintfFormat]
		public static void critical (string format, ...);
		[Diagnostics]
		[PrintfFormat]
		public static void debug (string format, ...);
		[Diagnostics]
		[PrintfFormat]
		public static void error (string format, ...);
		[Diagnostics]
		[PrintfFormat]
		public static void info (string format, ...);
		[Diagnostics]
		[PrintfFormat]
		public static void message (string format, ...);
		[Diagnostics]
		[PrintfFormat]
		public static void warning (string format, ...);
	}
	[CCode (cheader_filename = "gcp.h")]
	public class ScrollbarMarker {
		public class Marker {
			public Marker (Gcp.SourceRange range, Gdk.RGBA color);
			public Gdk.RGBA color { get; }
			public Gcp.SourceRange range { get; }
		}
		public ScrollbarMarker (Gtk.Scrollbar scrollbar);
		public uint add (Gcp.SourceRange range, Gdk.RGBA color);
		public void add_with_id (uint id, Gcp.SourceRange range, Gdk.RGBA color);
		public void clear ();
		public uint new_merge_id ();
		public void remove (uint id);
		public int max_line { get; set; }
		public Gtk.Scrollbar? scrollbar { get; }
	}
	[CCode (cheader_filename = "gcp.h")]
	public abstract class SemanticValue : GLib.Object, Gcp.SourceRangeSupport {
		public enum Kind {
			NONE,
			STRUCT,
			UNION,
			CLASS,
			ENUM,
			FIELD,
			ENUM_VALUE,
			FUNCTION,
			MEMBER_FUNCTION,
			CONSTRUCTOR,
			DESTRUCTOR,
			VARIABLE,
			PARAMETER,
			TYPEDEF,
			NAMESPACE,
			BLOCK
		}
		[Flags]
		public enum ReferenceType {
			NONE,
			DECLARATION,
			REFERENCE,
			DEFINITION
		}
		public SemanticValue (Gcp.SourceRange range, Gcp.SemanticValue.Kind kind, Gcp.SemanticValue.ReferenceType rtype);
		public Gcp.SemanticValue? find_child (Gcp.SemanticValue.Kind kind);
		public abstract Gcp.SemanticValue reference (int idx);
		public abstract Gcp.SemanticValue? declaration { owned get; }
		public abstract Gcp.SemanticValue? definition { owned get; }
		public abstract Gcp.SemanticValue? down { get; }
		public Gcp.SemanticValue.Kind kind { get; }
		public abstract Gcp.SemanticValue? next { get; }
		public abstract int num_references { get; }
		public abstract Gcp.SemanticValue? previous { get; }
		public Gcp.SemanticValue.ReferenceType reference_type { get; }
		public abstract Gcp.SemanticValue? up { get; }
	}
	[CCode (cheader_filename = "gcp.h")]
	public class SourceIndex : GLib.Object {
		public class Iterator : GLib.Object {
			public Iterator (GLib.SequenceIter<Gcp.SourceIndex.Wrapper> iter);
			public new GLib.Object @get ();
			public bool next ();
		}
		public class Wrapper : GLib.Object {
			public bool encapsulated;
			public int idx;
			public Gcp.SourceRangeSupport obj;
			public Gcp.SourceRange range;
			public Wrapper (Gcp.SourceRangeSupport obj, Gcp.SourceRange range, int idx);
		}
		public SourceIndex ();
		public void add (Gcp.SourceRangeSupport range);
		public void clear ();
		public GLib.Object[] find_at (Gcp.SourceLocation location);
		public GLib.Object[] find_at_line (int line);
		public GLib.Object? find_inner_at (Gcp.SourceLocation location);
		public new GLib.Object? @get (int idx);
		public Gcp.SourceIndex.Iterator iterator ();
		public void remove (Gcp.SourceRangeSupport range);
		public int length { get; }
	}
	[CCode (cheader_filename = "gcp.h")]
	public class SourceLocation : GLib.Object, Gcp.SourceRangeSupport {
		public SourceLocation (GLib.File? file, int line, int column);
		public bool buffer_coordinates (Gtk.TextView view, out Gdk.Rectangle rect);
		public int compare_to (Gcp.SourceLocation other);
		public Gcp.SourceLocation copy ();
		public bool get_iter (Gtk.TextBuffer buffer, out Gtk.TextIter iter);
		public SourceLocation.iter (Gtk.TextIter iter);
		public string to_string ();
		public int column { get; }
		public GLib.File? file { get; }
		public int line { get; set; }
	}
	[CCode (cheader_filename = "gcp.h")]
	public class SourceRange : GLib.Object, Gcp.SourceRangeSupport {
		public SourceRange (Gcp.SourceLocation start, Gcp.SourceLocation end);
		public int compare_to (Gcp.SourceRange other);
		public bool contains (int line, int column);
		public bool contains_line (int line);
		public bool contains_location (Gcp.SourceLocation location);
		public bool contains_range (Gcp.SourceRange range);
		public bool get_iters (Gtk.TextBuffer buffer, out Gtk.TextIter start, out Gtk.TextIter end);
		public string to_string ();
		public Gcp.SourceLocation end { get; }
		public Gcp.SourceLocation start { get; }
	}
	[CCode (cheader_filename = "gcp.h")]
	public class SymbolBrowser : Gtk.TreeStore {
		public SymbolBrowser ();
		public void begin_update ();
		public void end_update ();
		public bool tainted { get; set; }
	}
	[CCode (cheader_filename = "gcp.h")]
	public interface Backend : GLib.Object {
		public abstract new Gcp.Document @get (int idx);
		public abstract Gcp.Document? register_document (Gedit.Document? document);
		public abstract void unregister_document (Gcp.Document? document);
		public abstract int size { get; }
	}
	[CCode (cheader_filename = "gcp.h")]
	public interface DiagnosticSupport : Gcp.Document {
		public abstract Gcp.SourceIndex begin_diagnostics ();
		public abstract void end_diagnostics ();
		public Gcp.Diagnostic[] find_at (Gcp.SourceLocation location);
		public Gcp.Diagnostic[] find_at_line (int line);
		public abstract Gcp.DiagnosticTags get_diagnostic_tags ();
		public abstract void set_diagnostic_tags (Gcp.DiagnosticTags tags);
		public void with_diagnostics (Gcp.WithDiagnosticsCallback callback);
		public signal void diagnostics_updated ();
	}
	[CCode (cheader_filename = "gcp.h")]
	public interface SemanticValueSupport : Gcp.Document {
		public abstract Gcp.SourceIndex begin_semantics ();
		public abstract void end_semantics ();
		public void with_semantics (Gcp.WithSemanticValueCallback callback);
		public signal void semantic_values_updated ();
	}
	[CCode (cheader_filename = "gcp.h")]
	public interface SourceRangeSupport : GLib.Object {
		public abstract Gcp.SourceRange? range { owned get; }
		public abstract Gcp.SourceRange[] ranges { owned get; }
	}
	[CCode (cheader_filename = "gcp.h")]
	public interface SymbolBrowserSupport : Gcp.Document {
		public abstract Gcp.SymbolBrowser symbol_browser { get; }
	}
	[CCode (cheader_filename = "gcp.h")]
	public struct UnsavedFile {
		public string filename;
		public string contents;
		public ulong length;
		public UnsavedFile (string f, string c);
	}
	[CCode (cheader_filename = "gcp.h")]
	public delegate void AsyncInThreadCallback ();
	[CCode (cheader_filename = "gcp.h")]
	public delegate void WithDiagnosticsCallback (Gcp.SourceIndex diagnostics);
	[CCode (cheader_filename = "gcp.h")]
	public delegate void WithSemanticValueCallback (Gcp.SourceIndex diagnostics);
	[CCode (cheader_filename = "gcp.h")]
	public static async bool async_in_thread (Gcp.AsyncInThreadCallback cb);
}
