/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;
import javax.swing.plaf.metal.OceanTheme;

public class MetalToolBarUI
extends BasicToolBarUI {
    protected ContainerListener contListener;
    protected PropertyChangeListener rolloverListener;

    public static ComponentUI createUI(JComponent component) {
        return new MetalToolBarUI();
    }

    protected PropertyChangeListener createRolloverListener() {
        return null;
    }

    protected ContainerListener createContainerListener() {
        return null;
    }

    protected Border createNonRolloverBorder() {
        return MetalBorders.getToolbarButtonBorder();
    }

    protected void setDragOffset(Point p) {
        if (this.dragWindow != null) {
            this.dragWindow.setOffset(p);
        }
    }

    protected MouseInputListener createDockingListener() {
        return new MetalDockingListener(this.toolBar);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JToolBar) {
            JToolBar tb = (JToolBar)c;
            tb.setRollover(UIManager.getBoolean("ToolBar.isRollover"));
        }
    }

    public void uninstallUI(JComponent c) {
        if (c instanceof JToolBar) {
            JToolBar tb = (JToolBar)c;
            tb.setRollover(false);
        }
        super.uninstallUI(c);
    }

    public void update(Graphics g, JComponent c) {
        if (MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme && UIManager.get("MenuBar.gradient") != null) {
            if (c.isOpaque()) {
                MetalUtils.paintGradient(g, 0, 0, c.getWidth(), c.getHeight(), 1, "MenuBar.gradient");
            }
            this.paint(g, c);
        } else {
            super.update(g, c);
        }
    }

    protected class MetalContainerListener
    extends BasicToolBarUI.ToolBarContListener {
        protected MetalContainerListener() {
        }
    }

    protected class MetalDockingListener
    extends BasicToolBarUI.DockingListener {
        public MetalDockingListener(JToolBar t) {
            super(t);
        }

        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            MetalToolBarUI.this.setDragOffset(new Point(e.getX(), e.getY()));
        }

        public void mouseDragged(MouseEvent e) {
            super.mouseDragged(e);
        }
    }

    protected class MetalRolloverListener
    extends BasicToolBarUI.PropertyListener {
        protected MetalRolloverListener() {
        }
    }
}

