/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.KeyStroke;

public class InputMap
implements Serializable {
    private static final long serialVersionUID = -5429059542008604257L;
    private Map inputMap;
    private InputMap parent;

    public Object get(KeyStroke keystroke) {
        Object result = null;
        if (this.inputMap != null) {
            result = this.inputMap.get(keystroke);
        }
        if (result == null && this.parent != null) {
            result = this.parent.get(keystroke);
        }
        return result;
    }

    public void put(KeyStroke keystroke, Object actionMapKey) {
        if (keystroke == null) {
            return;
        }
        if (this.inputMap == null) {
            this.inputMap = new HashMap();
        }
        if (actionMapKey == null) {
            this.inputMap.remove(keystroke);
        } else {
            this.inputMap.put(keystroke, actionMapKey);
        }
    }

    public void remove(KeyStroke keystroke) {
        if (this.inputMap != null) {
            this.inputMap.remove(keystroke);
        }
    }

    public InputMap getParent() {
        return this.parent;
    }

    public void setParent(InputMap parentMap) {
        this.parent = parentMap;
    }

    public int size() {
        int result = 0;
        if (this.inputMap != null) {
            result = this.inputMap.size();
        }
        return result;
    }

    public void clear() {
        if (this.inputMap != null) {
            this.inputMap.clear();
        }
    }

    public KeyStroke[] keys() {
        if (this.inputMap != null) {
            KeyStroke[] array = new KeyStroke[this.size()];
            return this.inputMap.keySet().toArray(array);
        }
        return null;
    }

    public KeyStroke[] allKeys() {
        KeyStroke[] parentKeys;
        HashSet<KeyStroke> set = new HashSet<KeyStroke>();
        if (this.parent != null && (parentKeys = this.parent.allKeys()) != null) {
            set.addAll(Arrays.asList(parentKeys));
        }
        if (this.inputMap != null) {
            set.addAll(this.inputMap.keySet());
        }
        if (set.size() == 0) {
            return null;
        }
        KeyStroke[] array = new KeyStroke[set.size()];
        return set.toArray(array);
    }
}

