/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class AnyURIType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{1, 2, 3, 4, 5, 6};

    AnyURIType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "anyURI"), TypeLibrary.ANY_SIMPLE_TYPE);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String value, ValidationContext context) throws DatatypeException {
        super.checkValid(value, context);
        try {
            new URI(value);
        }
        catch (URISyntaxException e) {
            DatatypeException e2 = new DatatypeException(e.getIndex(), e.getReason());
            e2.initCause(e);
            throw e2;
        }
    }
}

