/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.pad;

import gnu.java.security.util.PRNG;
import gnu.javax.crypto.pad.BasePad;
import gnu.javax.crypto.pad.WrongPaddingException;

public final class ISO10126
extends BasePad {
    private PRNG prng = PRNG.getInstance();

    ISO10126() {
        super("iso10126");
    }

    public void setup() {
    }

    public byte[] pad(byte[] in, int offset, int length) {
        int padLength = this.blockSize - length % this.blockSize;
        byte[] pad = new byte[padLength];
        this.prng.nextBytes(pad, 0, padLength - 1);
        pad[padLength - 1] = (byte)padLength;
        return pad;
    }

    public int unpad(byte[] in, int offset, int length) throws WrongPaddingException {
        int padLength = in[offset + length - 1] & 0xFF;
        if (padLength > length) {
            throw new WrongPaddingException();
        }
        return padLength;
    }

    public boolean selfTest() {
        return this.test1BlockSize(16, new byte[1024]);
    }
}

