/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.ProtocolConstants;
import gnu.java.rmi.server.RMIIncomingThread;
import gnu.java.rmi.server.TripleKey;
import gnu.java.rmi.server.UnicastConnection;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Hashtable;
import java.util.Iterator;

public class UnicastConnectionManager
implements Runnable,
ProtocolConstants {
    private static String localhost;
    private static Hashtable servers;
    static Hashtable clients;
    ArrayList connections;
    private volatile Thread serverThread;
    private ServerSocket ssock;
    String serverName;
    int serverPort;
    static Thread scavenger;
    Object serverobj;
    private static RMISocketFactory defaultSocketFactory;
    private RMIServerSocketFactory serverFactory;
    private RMIClientSocketFactory clientFactory;
    private static int ncsock;
    private static int nssock;
    private static int ncmanager;
    private static int nsmanager;
    private static final boolean debug = false;
    private static final Object GLOBAL_LOCK;

    static {
        servers = new Hashtable();
        clients = new Hashtable();
        defaultSocketFactory = RMISocketFactory.getSocketFactory();
        ncsock = 0;
        nssock = 0;
        ncmanager = 0;
        nsmanager = 0;
        GLOBAL_LOCK = new Object();
        try {
            localhost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            localhost = "localhost";
        }
    }

    private static void startScavenger() {
        scavenger = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean liveon = true;
                while (liveon) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    liveon = false;
                    Iterator iter = clients.values().iterator();
                    long l = System.currentTimeMillis();
                    try {
                        while (iter.hasNext()) {
                            ArrayList conns;
                            UnicastConnectionManager man = (UnicastConnectionManager)iter.next();
                            ArrayList arrayList = conns = man.connections;
                            synchronized (arrayList) {
                                int last = conns.size() - 1;
                                while (last >= 0) {
                                    UnicastConnection conn = (UnicastConnection)conns.get(last);
                                    if (UnicastConnection.isExpired(conn, l)) {
                                        conns.remove(last);
                                        conn.disconnect();
                                        conn = null;
                                    } else {
                                        liveon = true;
                                    }
                                    --last;
                                }
                            }
                        }
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        liveon = true;
                    }
                }
                scavenger = null;
            }
        });
        scavenger.setDaemon(true);
        scavenger.start();
    }

    private UnicastConnectionManager(String host, int port, RMIClientSocketFactory csf) {
        this.ssock = null;
        this.serverName = host;
        this.serverPort = port;
        this.serverFactory = null;
        this.clientFactory = csf;
        this.connections = new ArrayList();
    }

    private UnicastConnectionManager(int port, RMIServerSocketFactory ssf) throws RemoteException {
        try {
            this.ssock = ssf.createServerSocket(port);
            this.serverPort = this.ssock.getLocalPort();
        }
        catch (IOException ioex) {
            this.ssock = null;
            this.serverPort = 0;
            throw new ExportException("can not create Server Socket on port " + port, ioex);
        }
        this.serverName = "localhost";
        this.serverFactory = ssf;
        this.clientFactory = null;
    }

    public static synchronized UnicastConnectionManager getInstance(String host, int port, RMIClientSocketFactory csf) {
        if (csf == null) {
            csf = defaultSocketFactory;
        }
        try {
            host = InetAddress.getByName(host).getHostAddress();
        }
        catch (Exception exception) {}
        TripleKey key = new TripleKey(host, port, csf);
        UnicastConnectionManager man = (UnicastConnectionManager)clients.get(key);
        if (man == null) {
            man = new UnicastConnectionManager(host, port, csf);
            clients.put(key, man);
            UnicastConnectionManager svrman = (UnicastConnectionManager)servers.get(key);
            if (svrman != null) {
                man.serverobj = svrman.serverobj;
            }
        }
        return man;
    }

    public static synchronized UnicastConnectionManager getInstance(int port, RMIServerSocketFactory ssf) throws RemoteException {
        TripleKey key;
        UnicastConnectionManager man;
        if (ssf == null) {
            ssf = defaultSocketFactory;
        }
        if ((man = (UnicastConnectionManager)servers.get(key = new TripleKey(localhost, port, ssf))) == null) {
            man = new UnicastConnectionManager(port, ssf);
            key.port = man.serverPort;
            servers.put(key, man);
        }
        return man;
    }

    public UnicastConnection getConnection() throws IOException {
        if (this.ssock == null) {
            return this.getClientConnection();
        }
        return this.getServerConnection();
    }

    private UnicastConnection getServerConnection() throws IOException {
        Socket sock = this.ssock.accept();
        sock.setTcpNoDelay(true);
        UnicastConnection conn = new UnicastConnection(this, sock);
        conn.acceptConnection();
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnicastConnection getClientConnection() throws IOException {
        UnicastConnection conn;
        ArrayList conns;
        ArrayList arrayList = conns = this.connections;
        synchronized (arrayList) {
            int nconn = conns.size() - 1;
            if (nconn >= 0) {
                conn = (UnicastConnection)conns.get(nconn);
                conns.remove(nconn);
                long l = System.currentTimeMillis();
                if (!UnicastConnection.isExpired(conn, l)) {
                    return conn;
                }
                conn.disconnect();
                conn = null;
            }
        }
        Socket sock = this.clientFactory.createSocket(this.serverName, this.serverPort);
        conn = new UnicastConnection(this, sock);
        conn.makeConnection(75);
        return conn;
    }

    public String toString() {
        return String.valueOf(this.serverName) + ":" + this.serverPort + " (" + this.serverobj + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardConnection(UnicastConnection conn) {
        if (this.ssock != null) {
            conn.disconnect();
        } else {
            UnicastConnection.resetTime(conn);
            Object object = GLOBAL_LOCK;
            synchronized (object) {
                this.connections.add(conn);
                if (scavenger == null) {
                    UnicastConnectionManager.startScavenger();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServer() {
        UnicastConnectionManager unicastConnectionManager = this;
        synchronized (unicastConnectionManager) {
            if (this.ssock == null || this.serverThread != null) {
                return;
            }
            this.serverThread = new Thread(this);
        }
        this.serverThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() {
        UnicastConnectionManager unicastConnectionManager = this;
        synchronized (unicastConnectionManager) {
            if (this.serverThread != null) {
                this.serverThread = null;
                try {
                    this.ssock.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void run() {
        while (this.serverThread != null) {
            try {
                UnicastConnection conn = this.getServerConnection();
                String remoteHost = null;
                if (conn.sock != null) {
                    remoteHost = conn.sock.getInetAddress().getHostAddress();
                }
                new RMIIncomingThread(conn, remoteHost).start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void write(ObjectOutput out) throws IOException {
        out.writeUTF(this.serverName);
        out.writeInt(this.serverPort);
    }

    static UnicastConnectionManager read(ObjectInput in) throws IOException {
        String host = in.readUTF();
        int port = in.readInt();
        return UnicastConnectionManager.getInstance(host, port, null);
    }
}

