/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.CairoGraphics2D;
import gnu.java.awt.peer.gtk.CairoSurface;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.RenderedImage;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.WeakHashMap;

public class BufferedImageGraphics
extends CairoGraphics2D {
    private BufferedImage image;
    private BufferedImage buffer;
    private int imageWidth;
    private int imageHeight;
    CairoSurface surface;
    static WeakHashMap<BufferedImage, CairoSurface> bufferedImages = new WeakHashMap();
    private long cairo_t;
    private boolean hasFastCM;
    private boolean hasAlpha;

    public BufferedImageGraphics(BufferedImage bi) {
        this.image = bi;
        this.imageWidth = bi.getWidth();
        this.imageHeight = bi.getHeight();
        if (!(this.image.getSampleModel() instanceof SinglePixelPackedSampleModel)) {
            this.hasFastCM = false;
        } else if (bi.getColorModel().equals(CairoSurface.cairoCM_opaque)) {
            this.hasFastCM = true;
            this.hasAlpha = false;
        } else if (bi.getColorModel().equals(CairoSurface.cairoColorModel) || bi.getColorModel().equals(CairoSurface.cairoCM_pre)) {
            this.hasFastCM = true;
            this.hasAlpha = true;
        } else {
            this.hasFastCM = false;
        }
        if (bufferedImages.get(bi) != null) {
            this.surface = bufferedImages.get(bi);
        } else {
            this.surface = new CairoSurface(this.imageWidth, this.imageHeight);
            bufferedImages.put(bi, this.surface);
        }
        this.cairo_t = this.surface.newCairoContext();
        WritableRaster raster = bi.getRaster();
        if (this.hasFastCM) {
            SinglePixelPackedSampleModel sm = (SinglePixelPackedSampleModel)this.image.getSampleModel();
            int minX = this.image.getRaster().getSampleModelTranslateX();
            int minY = this.image.getRaster().getSampleModelTranslateY();
            int[] pixels = ((DataBufferInt)raster.getDataBuffer()).getData();
            if (sm.getScanlineStride() != this.imageWidth || minX != 0 || minY != 0) {
                int[] pixels2 = new int[this.imageWidth * this.imageHeight];
                int scanline = sm.getScanlineStride();
                int i = 0;
                while (i < this.imageHeight) {
                    System.arraycopy(pixels, (i - minY) * scanline - minX, pixels2, i * this.imageWidth, this.imageWidth);
                    ++i;
                }
                pixels = pixels2;
            }
            if (!this.hasAlpha) {
                int i = 0;
                while (i < pixels.length) {
                    int n = i++;
                    pixels[n] = pixels[n] & 0xFFFFFFFF;
                }
            }
        } else {
            int[] pixels = CairoGraphics2D.findSimpleIntegerArray(this.image.getColorModel(), this.image.getData());
            if (pixels != null) {
                System.arraycopy(pixels, 0, this.surface.getData(), 0, pixels.length);
            }
        }
        this.setup(this.cairo_t);
        this.setClip(0, 0, this.imageWidth, this.imageHeight);
    }

    BufferedImageGraphics(BufferedImageGraphics copyFrom) {
        this.image = copyFrom.image;
        this.surface = copyFrom.surface;
        this.cairo_t = this.surface.newCairoContext();
        this.imageWidth = copyFrom.imageWidth;
        this.imageHeight = copyFrom.imageHeight;
        this.hasFastCM = copyFrom.hasFastCM;
        this.hasAlpha = copyFrom.hasAlpha;
        this.copy(copyFrom, this.cairo_t);
    }

    private void updateBufferedImage(int x, int y, int width, int height) {
        Rectangle bounds = new Rectangle(x, y, width, height);
        bounds = BufferedImageGraphics.getTransformedBounds(bounds, this.transform).getBounds();
        x = bounds.x;
        y = bounds.y;
        width = bounds.width;
        height = bounds.height;
        int[] pixels = this.surface.getData();
        if (x > this.imageWidth || y > this.imageHeight) {
            return;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x + width > this.imageWidth) {
            width = this.imageWidth - x;
        }
        if (y + height > this.imageHeight) {
            height = this.imageHeight - y;
        }
        if (!this.hasFastCM) {
            this.image.setRGB(x, y, width, height, pixels, x + y * this.imageWidth, this.imageWidth);
        } else {
            int[] db = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
            SinglePixelPackedSampleModel sm = (SinglePixelPackedSampleModel)this.image.getSampleModel();
            int minX = this.image.getRaster().getSampleModelTranslateX();
            int minY = this.image.getRaster().getSampleModelTranslateY();
            if (sm.getScanlineStride() == this.imageWidth && minX == 0) {
                System.arraycopy(pixels, y * this.imageWidth, db, (y - minY) * this.imageWidth, height * this.imageWidth);
            } else {
                int scanline = sm.getScanlineStride();
                int i = y;
                while (i < height + y) {
                    System.arraycopy(pixels, i * this.imageWidth + x, db, (i - minY) * scanline + x - minX, width);
                    ++i;
                }
            }
        }
    }

    public Graphics create() {
        return new BufferedImageGraphics(this);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    protected Rectangle2D getRealBounds() {
        return new Rectangle2D.Double(0.0, 0.0, this.imageWidth, this.imageHeight);
    }

    public void copyAreaImpl(int x, int y, int width, int height, int dx, int dy) {
        this.surface.copyAreaNative(x, y, width, height, dx, dy, this.surface.width);
        this.updateBufferedImage(x + dx, y + dy, width, height);
    }

    public void draw(Shape s) {
        Rectangle r = this.findStrokedBounds(s);
        if (this.shiftDrawCalls) {
            ++r.width;
            ++r.height;
        }
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.draw(s);
            this.updateBufferedImage(r.x, r.y, r.width, r.height);
        } else {
            this.createBuffer();
            Graphics2D g2d = (Graphics2D)this.buffer.getGraphics();
            g2d.setStroke(this.getStroke());
            g2d.setColor(this.getColor());
            g2d.setTransform(this.transform);
            g2d.draw(s);
            this.drawComposite(r.getBounds2D(), null);
        }
    }

    public void fill(Shape s) {
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.fill(s);
            Rectangle r = s.getBounds();
            this.updateBufferedImage(r.x, r.y, r.width, r.height);
        } else {
            this.createBuffer();
            Graphics2D g2d = (Graphics2D)this.buffer.getGraphics();
            g2d.setPaint(this.getPaint());
            g2d.setColor(this.getColor());
            g2d.setTransform(this.transform);
            g2d.fill(s);
            this.drawComposite(s.getBounds2D(), null);
        }
    }

    public void drawRenderedImage(RenderedImage image, AffineTransform xform) {
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.drawRenderedImage(image, xform);
            this.updateBufferedImage(0, 0, this.imageWidth, this.imageHeight);
        } else {
            this.createBuffer();
            Graphics2D g2d = (Graphics2D)this.buffer.getGraphics();
            g2d.setRenderingHints(this.getRenderingHints());
            g2d.setTransform(this.transform);
            g2d.drawRenderedImage(image, xform);
            this.drawComposite(this.buffer.getRaster().getBounds(), null);
        }
    }

    protected boolean drawImage(Image img, AffineTransform xform, Color bgcolor, ImageObserver obs) {
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            boolean rv = super.drawImage(img, xform, bgcolor, obs);
            this.updateBufferedImage(0, 0, this.imageWidth, this.imageHeight);
            return rv;
        }
        if (!(img instanceof BufferedImage)) {
            ImageProducer source = img.getSource();
            if (source == null) {
                return false;
            }
            img = Toolkit.getDefaultToolkit().createImage(source);
        }
        BufferedImage bImg = (BufferedImage)img;
        Rectangle2D bounds = new Rectangle(bImg.getMinX(), bImg.getMinY(), bImg.getWidth(), bImg.getHeight());
        if (xform != null) {
            bounds = BufferedImageGraphics.getTransformedBounds(bounds, xform);
        }
        this.createBuffer();
        Graphics2D g2d = (Graphics2D)this.buffer.getGraphics();
        g2d.setRenderingHints(this.getRenderingHints());
        g2d.drawImage(img, xform, obs);
        return this.drawComposite(bounds, obs);
    }

    public void drawGlyphVector(GlyphVector gv, float x, float y) {
        Rectangle2D bounds = gv.getLogicalBounds();
        bounds = new Rectangle2D.Double((double)x + bounds.getX(), (double)y + bounds.getY(), bounds.getWidth(), bounds.getHeight());
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.drawGlyphVector(gv, x, y);
            bounds = bounds.getBounds();
            this.updateBufferedImage((int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth(), (int)bounds.getHeight());
        } else {
            this.createBuffer();
            Graphics2D g2d = (Graphics2D)this.buffer.getGraphics();
            g2d.setPaint(this.getPaint());
            g2d.setStroke(this.getStroke());
            g2d.setTransform(this.transform);
            g2d.drawGlyphVector(gv, x, y);
            this.drawComposite(bounds, null);
        }
    }

    private boolean drawComposite(Rectangle2D bounds, ImageObserver observer) {
        bounds = BufferedImageGraphics.getTransformedBounds(bounds, this.transform);
        Rectangle2D devClip = this.getClipInDevSpace();
        Rectangle2D.intersect(bounds, devClip, bounds);
        devClip = new Rectangle(this.buffer.getMinX(), this.buffer.getMinY(), this.buffer.getWidth(), this.buffer.getHeight());
        Rectangle2D.intersect(bounds, devClip, bounds);
        double x = bounds.getX();
        double y = bounds.getY();
        double maxX = x + bounds.getWidth();
        double maxY = y + bounds.getHeight();
        x = Math.round(x);
        y = Math.round(y);
        bounds.setRect(x, y, Math.round(maxX - x), Math.round(maxY - y));
        BufferedImage buffer2 = this.buffer;
        if (!bounds.equals(buffer2.getRaster().getBounds())) {
            buffer2 = buffer2.getSubimage((int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth(), (int)bounds.getHeight());
        }
        BufferedImage current = this.image;
        current = current.getSubimage((int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth(), (int)bounds.getHeight());
        this.compCtx.compose(buffer2.getRaster(), current.getRaster(), current.getRaster());
        Composite oldcomp = this.comp;
        this.setComposite(AlphaComposite.Src);
        boolean rv = super.drawImage((Image)current, AffineTransform.getTranslateInstance(bounds.getX(), bounds.getY()), null, null);
        this.setComposite(oldcomp);
        this.updateColor();
        return rv;
    }

    private void createBuffer() {
        if (this.buffer == null) {
            this.buffer = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 2);
        } else {
            Graphics2D g2d = (Graphics2D)this.buffer.getGraphics();
            g2d.setBackground(new Color(0, 0, 0, 0));
            g2d.clearRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
        }
    }

    protected ColorModel getNativeCM() {
        return this.image.getColorModel();
    }

    protected ColorModel getBufferCM() {
        return ColorModel.getRGBdefault();
    }
}

