/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.security.auth.AuthPermission;
import javax.security.auth.SubjectDomainCombiner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Subject
implements Serializable {
    private static final long serialVersionUID = -8308522755600156056L;
    private final Set principals;
    private boolean readOnly;
    private final transient SecureSet pubCred;
    private final transient SecureSet privCred;

    public Subject() {
        this.principals = new SecureSet(this, 0);
        this.pubCred = new SecureSet(this, 1);
        this.privCred = new SecureSet(this, 2);
        this.readOnly = false;
    }

    public Subject(boolean readOnly, Set<? extends Principal> principals, Set<?> pubCred, Set<?> privCred) {
        if (principals == null || pubCred == null || privCred == null) {
            throw new NullPointerException();
        }
        this.principals = new SecureSet(this, 0, principals);
        this.pubCred = new SecureSet(this, 1, pubCred);
        this.privCred = new SecureSet(this, 2, privCred);
        this.readOnly = readOnly;
    }

    public static Subject getSubject(AccessControlContext context) {
        DomainCombiner dc;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("getSubject"));
        }
        if (!((dc = context.getDomainCombiner()) instanceof SubjectDomainCombiner)) {
            return null;
        }
        return ((SubjectDomainCombiner)dc).getSubject();
    }

    public static Object doAs(Subject subject, PrivilegedAction action) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("doAs"));
        }
        AccessControlContext context = new AccessControlContext(AccessController.getContext(), new SubjectDomainCombiner(subject));
        return AccessController.doPrivileged(action, context);
    }

    public static Object doAs(Subject subject, PrivilegedExceptionAction action) throws PrivilegedActionException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("doAs"));
        }
        AccessControlContext context = new AccessControlContext(AccessController.getContext(), new SubjectDomainCombiner(subject));
        return AccessController.doPrivileged(action, context);
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedAction action, AccessControlContext acc) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("doAsPrivileged"));
        }
        AccessControlContext context = new AccessControlContext(acc, new SubjectDomainCombiner(subject));
        return AccessController.doPrivileged(action, context);
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedExceptionAction action, AccessControlContext acc) throws PrivilegedActionException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("doAsPrivileged"));
        }
        if (acc == null) {
            acc = new AccessControlContext(new ProtectionDomain[0]);
        }
        AccessControlContext context = new AccessControlContext(acc, new SubjectDomainCombiner(subject));
        return AccessController.doPrivileged(action, context);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Subject)) {
            return false;
        }
        Subject that = (Subject)o;
        return this.principals.containsAll(that.getPrincipals()) && this.pubCred.containsAll(that.getPublicCredentials()) && this.privCred.containsAll(that.getPrivateCredentials());
    }

    public Set<Principal> getPrincipals() {
        return this.principals;
    }

    public <T extends Principal> Set<T> getPrincipals(Class<T> clazz) {
        HashSet result = new HashSet(this.principals.size());
        for (Object o : this.principals) {
            if (o == null || !clazz.isAssignableFrom(o.getClass())) continue;
            result.add(o);
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<Object> getPrivateCredentials() {
        return this.privCred;
    }

    public <T> Set<T> getPrivateCredentials(Class<T> clazz) {
        HashSet result = new HashSet(this.privCred.size());
        for (Object o : this.privCred) {
            if (o == null || !clazz.isAssignableFrom(o.getClass())) continue;
            result.add(o);
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<Object> getPublicCredentials() {
        return this.pubCred;
    }

    public <T> Set<T> getPublicCredentials(Class<T> clazz) {
        HashSet result = new HashSet(this.pubCred.size());
        for (Object o : this.pubCred) {
            if (o == null || !clazz.isAssignableFrom(o.getClass())) continue;
            result.add(o);
        }
        return Collections.unmodifiableSet(result);
    }

    public int hashCode() {
        return this.principals.hashCode() + this.privCred.hashCode() + this.pubCred.hashCode();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("setReadOnly"));
        }
        this.readOnly = true;
    }

    public String toString() {
        return String.valueOf(Subject.class.getName()) + " [ principals=" + this.principals + ", private credentials=" + this.privCred + ", public credentials=" + this.pubCred + ", read-only=" + this.readOnly + " ]";
    }

    private static class SecureSet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 7911754171111800359L;
        static final int PRINCIPALS = 0;
        static final int PUBLIC_CREDENTIALS = 1;
        static final int PRIVATE_CREDENTIALS = 2;
        private final Subject subject;
        private final LinkedList elements;
        private final transient int type;

        SecureSet(Subject subject, int type, Collection inElements) {
            this(subject, type);
            for (Object o : inElements) {
                if (type == 0 && !(o instanceof Principal)) {
                    throw new IllegalArgumentException(o + " is not a Principal");
                }
                if (this.elements.contains(o)) continue;
                this.elements.add(o);
            }
        }

        SecureSet(Subject subject, int type) {
            this.subject = subject;
            this.type = type;
            this.elements = new LinkedList();
        }

        public synchronized int size() {
            return this.elements.size();
        }

        public Iterator iterator() {
            return this.elements.iterator();
        }

        public synchronized boolean add(Object element) {
            if (this.subject.isReadOnly()) {
                throw new IllegalStateException("subject is read-only");
            }
            SecurityManager sm = System.getSecurityManager();
            switch (this.type) {
                case 0: {
                    if (sm != null) {
                        sm.checkPermission(new AuthPermission("modifyPrincipals"));
                    }
                    if (element instanceof Principal) break;
                    throw new IllegalArgumentException("element is not a Principal");
                }
                case 1: {
                    if (sm == null) break;
                    sm.checkPermission(new AuthPermission("modifyPublicCredentials"));
                    break;
                }
                case 2: {
                    if (sm == null) break;
                    sm.checkPermission(new AuthPermission("modifyPrivateCredentials"));
                    break;
                }
                default: {
                    throw new Error("this statement should be unreachable");
                }
            }
            if (this.elements.contains(element)) {
                return false;
            }
            return this.elements.add(element);
        }

        public synchronized boolean remove(Object element) {
            if (this.subject.isReadOnly()) {
                throw new IllegalStateException("subject is read-only");
            }
            SecurityManager sm = System.getSecurityManager();
            switch (this.type) {
                case 0: {
                    if (sm != null) {
                        sm.checkPermission(new AuthPermission("modifyPrincipals"));
                    }
                    if (element instanceof Principal) break;
                    throw new IllegalArgumentException("element is not a Principal");
                }
                case 1: {
                    if (sm == null) break;
                    sm.checkPermission(new AuthPermission("modifyPublicCredentials"));
                    break;
                }
                case 2: {
                    if (sm == null) break;
                    sm.checkPermission(new AuthPermission("modifyPrivateCredentials"));
                    break;
                }
                default: {
                    throw new Error("this statement should be unreachable");
                }
            }
            return this.elements.remove(element);
        }

        public synchronized boolean contains(Object element) {
            return this.elements.contains(element);
        }

        public boolean removeAll(Collection c) {
            if (this.subject.isReadOnly()) {
                throw new IllegalStateException("subject is read-only");
            }
            return super.removeAll(c);
        }

        public boolean retainAll(Collection c) {
            if (this.subject.isReadOnly()) {
                throw new IllegalStateException("subject is read-only");
            }
            return super.retainAll(c);
        }

        public void clear() {
            if (this.subject.isReadOnly()) {
                throw new IllegalStateException("subject is read-only");
            }
            this.elements.clear();
        }

        private synchronized void writeObject(ObjectOutputStream out) throws IOException {
            throw new UnsupportedOperationException("FIXME: determine serialization");
        }

        private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
            throw new UnsupportedOperationException("FIXME: determine serialization");
        }
    }
}

