/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import gnu.java.util.EmptyEnumeration;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFile
implements ZipConstants {
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    static final int ENDNRD = 4;
    private final String name;
    private final RandomAccessFile raf;
    private LinkedHashMap<String, ZipEntry> entries;
    private boolean closed = false;

    private RandomAccessFile openFile(String name, File file) throws ZipException, IOException {
        try {
            return name != null ? new RandomAccessFile(name, "r") : new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException f) {
            ZipException ze = new ZipException(f.getMessage());
            ze.initCause(f);
            throw ze;
        }
    }

    public ZipFile(String name) throws ZipException, IOException {
        this.raf = this.openFile(name, null);
        this.name = name;
        this.checkZipFile();
    }

    public ZipFile(File file) throws ZipException, IOException {
        this.raf = this.openFile(null, file);
        this.name = file.getPath();
        this.checkZipFile();
    }

    public ZipFile(File file, int mode) throws ZipException, IOException {
        if (mode != 1 && mode != 5) {
            throw new IllegalArgumentException("invalid mode");
        }
        if ((mode & 4) != 0) {
            file.deleteOnExit();
        }
        this.raf = this.openFile(null, file);
        this.name = file.getPath();
        this.checkZipFile();
    }

    private void checkZipFile() throws ZipException {
        boolean valid = false;
        try {
            byte[] buf = new byte[4];
            this.raf.readFully(buf);
            int sig = buf[0] & 0xFF | (buf[1] & 0xFF) << 8 | (buf[2] & 0xFF) << 16 | (buf[3] & 0xFF) << 24;
            valid = (long)sig == 67324752L;
        }
        catch (IOException iOException) {}
        if (!valid) {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {}
            throw new ZipException("Not a valid zip file");
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("ZipFile has closed: " + this.name);
        }
    }

    private void readEntries() throws ZipException, IOException {
        PartialInputStream inp = new PartialInputStream(this.raf, 4096);
        long pos = this.raf.length() - 22L;
        long top = Math.max(0L, pos - 65536L);
        do {
            if (pos < top) {
                throw new ZipException("central directory not found, probably not a zip file: " + this.name);
            }
            inp.seek(pos--);
        } while ((long)inp.readLeInt() != 101010256L);
        if (inp.skip(6L) != 6L) {
            throw new EOFException(this.name);
        }
        int count = inp.readLeShort();
        if (inp.skip(4L) != 4L) {
            throw new EOFException(this.name);
        }
        int centralOffset = inp.readLeInt();
        this.entries = new LinkedHashMap(count + count / 2);
        inp.seek(centralOffset);
        int i = 0;
        while (i < count) {
            if ((long)inp.readLeInt() != 33639248L) {
                throw new ZipException("Wrong Central Directory signature: " + this.name);
            }
            inp.skip(6L);
            int method = inp.readLeShort();
            int dostime = inp.readLeInt();
            int crc = inp.readLeInt();
            int csize = inp.readLeInt();
            int size = inp.readLeInt();
            int nameLen = inp.readLeShort();
            int extraLen = inp.readLeShort();
            int commentLen = inp.readLeShort();
            inp.skip(8L);
            int offset = inp.readLeInt();
            String name = inp.readString(nameLen);
            ZipEntry entry = new ZipEntry(name);
            entry.setMethod(method);
            entry.setCrc((long)crc & 0xFFFFFFFFL);
            entry.setSize((long)size & 0xFFFFFFFFL);
            entry.setCompressedSize((long)csize & 0xFFFFFFFFL);
            entry.setDOSTime(dostime);
            if (extraLen > 0) {
                byte[] extra = new byte[extraLen];
                inp.readFully(extra);
                entry.setExtra(extra);
            }
            if (commentLen > 0) {
                entry.setComment(inp.readString(commentLen));
            }
            entry.offset = offset;
            this.entries.put(name, entry);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        RandomAccessFile raf = this.raf;
        if (raf == null) {
            return;
        }
        RandomAccessFile randomAccessFile = raf;
        synchronized (randomAccessFile) {
            this.closed = true;
            this.entries = null;
            raf.close();
        }
    }

    protected void finalize() throws IOException {
        if (!this.closed && this.raf != null) {
            this.close();
        }
    }

    public Enumeration<? extends ZipEntry> entries() {
        this.checkClosed();
        try {
            return new ZipEntryEnumeration(this.getEntries().values().iterator());
        }
        catch (IOException iOException) {
            return new EmptyEnumeration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedHashMap<String, ZipEntry> getEntries() throws IOException {
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.checkClosed();
            if (this.entries == null) {
                this.readEntries();
            }
            return this.entries;
        }
    }

    public ZipEntry getEntry(String name) {
        this.checkClosed();
        try {
            LinkedHashMap<String, ZipEntry> entries = this.getEntries();
            ZipEntry entry = entries.get(name);
            if (entry == null && !name.endsWith("/")) {
                entry = entries.get(String.valueOf(name) + '/');
            }
            return entry != null ? new ZipEntry(entry, name) : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public InputStream getInputStream(ZipEntry entry) throws IOException {
        this.checkClosed();
        LinkedHashMap<String, ZipEntry> entries = this.getEntries();
        String name = entry.getName();
        ZipEntry zipEntry = entries.get(name);
        if (zipEntry == null) {
            return null;
        }
        PartialInputStream inp = new PartialInputStream(this.raf, 1024);
        inp.seek(zipEntry.offset);
        if ((long)inp.readLeInt() != 67324752L) {
            throw new ZipException("Wrong Local header signature: " + name);
        }
        inp.skip(4L);
        if (zipEntry.getMethod() != inp.readLeShort()) {
            throw new ZipException("Compression method mismatch: " + name);
        }
        inp.skip(16L);
        int nameLen = inp.readLeShort();
        int extraLen = inp.readLeShort();
        inp.skip(nameLen + extraLen);
        inp.setLength(zipEntry.getCompressedSize());
        int method = zipEntry.getMethod();
        switch (method) {
            case 0: {
                return inp;
            }
            case 8: {
                inp.addDummyByte();
                Inflater inf = new Inflater(true);
                final int sz = (int)entry.getSize();
                return new InflaterInputStream(inp, inf){

                    public int available() throws IOException {
                        if (sz == -1) {
                            return super.available();
                        }
                        if (super.available() != 0) {
                            return sz - this.inf.getTotalOut();
                        }
                        return 0;
                    }
                };
            }
        }
        throw new ZipException("Unknown compression method " + method);
    }

    public String getName() {
        return this.name;
    }

    public int size() {
        this.checkClosed();
        try {
            return this.getEntries().size();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    private static final class PartialInputStream
    extends InputStream {
        private static final Charset UTF8CHARSET = Charset.forName("UTF-8");
        private CharsetDecoder utf8Decoder;
        private final RandomAccessFile raf;
        private final byte[] buffer;
        private long bufferOffset;
        private int pos;
        private long end;
        private int dummyByteCount;

        public PartialInputStream(RandomAccessFile raf, int bufferSize) throws IOException {
            this.raf = raf;
            this.buffer = new byte[bufferSize];
            this.bufferOffset = -this.buffer.length;
            this.pos = this.buffer.length;
            this.end = raf.length();
        }

        void setLength(long length) {
            this.end = this.bufferOffset + (long)this.pos + length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fillBuffer() throws IOException {
            RandomAccessFile randomAccessFile = this.raf;
            synchronized (randomAccessFile) {
                long len = this.end - this.bufferOffset;
                if (len == 0L && this.dummyByteCount > 0) {
                    this.buffer[0] = 0;
                    this.dummyByteCount = 0;
                } else {
                    this.raf.seek(this.bufferOffset);
                    this.raf.readFully(this.buffer, 0, (int)Math.min((long)this.buffer.length, len));
                }
            }
        }

        public int available() {
            long amount = this.end - (this.bufferOffset + (long)this.pos);
            if (amount > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)amount;
        }

        public int read() throws IOException {
            if (this.bufferOffset + (long)this.pos >= this.end + (long)this.dummyByteCount) {
                return -1;
            }
            if (this.pos == this.buffer.length) {
                this.bufferOffset += (long)this.buffer.length;
                this.pos = 0;
                this.fillBuffer();
            }
            return this.buffer[this.pos++] & 0xFF;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if ((long)len > this.end + (long)this.dummyByteCount - (this.bufferOffset + (long)this.pos) && (len = (int)(this.end + (long)this.dummyByteCount - (this.bufferOffset + (long)this.pos))) == 0) {
                return -1;
            }
            int totalBytesRead = Math.min(this.buffer.length - this.pos, len);
            System.arraycopy(this.buffer, this.pos, b, off, totalBytesRead);
            this.pos += totalBytesRead;
            off += totalBytesRead;
            len -= totalBytesRead;
            while (len > 0) {
                this.bufferOffset += (long)this.buffer.length;
                this.pos = 0;
                this.fillBuffer();
                int remain = Math.min(this.buffer.length, len);
                System.arraycopy(this.buffer, this.pos, b, off, remain);
                this.pos += remain;
                off += remain;
                len -= remain;
                totalBytesRead += remain;
            }
            return totalBytesRead;
        }

        public long skip(long amount) throws IOException {
            if (amount < 0L) {
                return 0L;
            }
            if (amount > this.end - (this.bufferOffset + (long)this.pos)) {
                amount = this.end - (this.bufferOffset + (long)this.pos);
            }
            this.seek(this.bufferOffset + (long)this.pos + amount);
            return amount;
        }

        void seek(long newpos) throws IOException {
            long offset = newpos - this.bufferOffset;
            if (offset >= 0L && offset <= (long)this.buffer.length) {
                this.pos = (int)offset;
            } else {
                this.bufferOffset = newpos;
                this.pos = 0;
                this.fillBuffer();
            }
        }

        void readFully(byte[] buf) throws IOException {
            if (this.read(buf, 0, buf.length) != buf.length) {
                throw new EOFException();
            }
        }

        void readFully(byte[] buf, int off, int len) throws IOException {
            if (this.read(buf, off, len) != len) {
                throw new EOFException();
            }
        }

        int readLeShort() throws IOException {
            int result;
            if (this.pos + 1 < this.buffer.length) {
                result = this.buffer[this.pos + 0] & 0xFF | (this.buffer[this.pos + 1] & 0xFF) << 8;
                this.pos += 2;
            } else {
                int b0 = this.read();
                int b1 = this.read();
                if (b1 == -1) {
                    throw new EOFException();
                }
                result = b0 & 0xFF | (b1 & 0xFF) << 8;
            }
            return result;
        }

        int readLeInt() throws IOException {
            int result;
            if (this.pos + 3 < this.buffer.length) {
                result = this.buffer[this.pos + 0] & 0xFF | (this.buffer[this.pos + 1] & 0xFF) << 8 | (this.buffer[this.pos + 2] & 0xFF | (this.buffer[this.pos + 3] & 0xFF) << 8) << 16;
                this.pos += 4;
            } else {
                int b0 = this.read();
                int b1 = this.read();
                int b2 = this.read();
                int b3 = this.read();
                if (b3 == -1) {
                    throw new EOFException();
                }
                result = b0 & 0xFF | (b1 & 0xFF) << 8 | (b2 & 0xFF | (b3 & 0xFF) << 8) << 16;
            }
            return result;
        }

        private String decodeChars(byte[] buffer, int pos, int length) throws IOException {
            String result;
            int i = length - 1;
            while (i >= 0 && buffer[i] <= 127) {
                --i;
            }
            if (i < 0) {
                result = new String(buffer, 0, pos, length);
            } else {
                ByteBuffer bufferBuffer = ByteBuffer.wrap(buffer, pos, length);
                if (this.utf8Decoder == null) {
                    this.utf8Decoder = UTF8CHARSET.newDecoder();
                }
                this.utf8Decoder.reset();
                char[] characters = this.utf8Decoder.decode(bufferBuffer).array();
                result = String.valueOf(characters);
            }
            return result;
        }

        String readString(int length) throws IOException {
            if ((long)length > this.end - (this.bufferOffset + (long)this.pos)) {
                throw new EOFException();
            }
            String result = null;
            try {
                if (this.buffer.length - this.pos >= length) {
                    result = this.decodeChars(this.buffer, this.pos, length);
                    this.pos += length;
                } else {
                    byte[] b = new byte[length];
                    this.readFully(b);
                    result = this.decodeChars(b, 0, length);
                }
            }
            catch (UnsupportedEncodingException uee) {
                throw new AssertionError((Object)uee);
            }
            return result;
        }

        public void addDummyByte() {
            this.dummyByteCount = 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ZipEntryEnumeration
    implements Enumeration<ZipEntry> {
        private final Iterator<ZipEntry> elements;

        public ZipEntryEnumeration(Iterator<ZipEntry> elements) {
            this.elements = elements;
        }

        @Override
        public boolean hasMoreElements() {
            return this.elements.hasNext();
        }

        @Override
        public ZipEntry nextElement() {
            return (ZipEntry)this.elements.next().clone();
        }
    }
}

