/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.security.auth.login;

import gnu.javax.security.auth.login.ConfigFileTokenizer;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.security.auth.login.AppConfigurationEntry;

public final class ConfigFileParser {
    private static final Logger log = Logger.getLogger(ConfigFileParser.class.getName());
    private ConfigFileTokenizer cft;
    private Map map = new HashMap();

    public Map getLoginModulesMap() {
        return this.map;
    }

    public void parse(Reader r) throws IOException {
        this.initParser(r);
        while (this.parseAppOrOtherEntry()) {
        }
    }

    private void initParser(Reader r) throws IOException {
        this.map.clear();
        this.cft = new ConfigFileTokenizer(r);
    }

    private boolean parseAppOrOtherEntry() throws IOException {
        ArrayList listOfACEs;
        int c = this.cft.nextToken();
        if (c == -1) {
            return false;
        }
        if (c != -3) {
            this.cft.pushBack();
            return false;
        }
        String appName = this.cft.sval;
        if (this.cft.nextToken() != 123) {
            this.abort("Missing '{' after APP_NAME_OR_OTHER");
        }
        ArrayList lmis = new ArrayList();
        while (this.parseACE(lmis)) {
        }
        c = this.cft.nextToken();
        if (c != 125) {
            this.abort("Was expecting '}' but found " + (char)c);
        }
        if ((c = this.cft.nextToken()) != 59) {
            this.abort("Was expecting ';' but found " + (char)c);
        }
        if ((listOfACEs = (ArrayList)this.map.get(appName)) == null) {
            listOfACEs = new ArrayList();
            this.map.put(appName, listOfACEs);
        }
        listOfACEs.addAll(lmis);
        return !appName.equalsIgnoreCase("other");
    }

    private boolean parseACE(List listOfACEs) throws IOException {
        int c = this.cft.nextToken();
        if (c != -3) {
            this.cft.pushBack();
            return false;
        }
        String clazz = this.validateClassName(this.cft.sval);
        if (this.cft.nextToken() != -3) {
            this.abort("Was expecting FLAG but found none");
        }
        String flag = this.cft.sval;
        AppConfigurationEntry.LoginModuleControlFlag f = null;
        if (flag.equalsIgnoreCase("required")) {
            f = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        } else if (flag.equalsIgnoreCase("requisite")) {
            f = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        } else if (flag.equalsIgnoreCase("sufficient")) {
            f = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        } else if (flag.equalsIgnoreCase("optional")) {
            f = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        } else {
            this.abort("Unknown Flag: " + flag);
        }
        HashMap<String, String> options = new HashMap<String, String>();
        c = this.cft.nextToken();
        while (c != 59) {
            if (c != -3) {
                this.abort("Was expecting PARAM_NAME but got '" + (char)c + "'");
            }
            String paramName = this.cft.sval;
            if (this.cft.nextToken() != 61) {
                this.abort("Missing '=' after PARAM_NAME");
            }
            if ((c = this.cft.nextToken()) == 34 || c != 39) {
                // empty if block
            }
            String paramValue = this.expandParamValue(this.cft.sval);
            options.put(paramName, paramValue);
            c = this.cft.nextToken();
        }
        AppConfigurationEntry ace = new AppConfigurationEntry(clazz, f, options);
        listOfACEs.add(ace);
        return true;
    }

    private void abort(String m) throws IOException {
        throw new IOException(m);
    }

    private String validateClassName(String cn) throws IOException {
        if (cn.startsWith(".") || cn.endsWith(".")) {
            this.abort("MODULE_CLASS MUST NOT start or end with a '.'");
        }
        String[] tokens = cn.split("\\.");
        int i = 0;
        while (i < tokens.length) {
            String t = tokens[i];
            if (!Character.isJavaIdentifierStart(t.charAt(0))) {
                this.abort("Class name [" + cn + "] contains an invalid sub-package identifier: " + t);
            }
            ++i;
        }
        return cn;
    }

    private String expandParamValue(String s) {
        String result = s;
        try {
            int searchNdx = 0;
            while (searchNdx < result.length()) {
                int j;
                int i = s.indexOf("${", searchNdx);
                if (i != -1 && (j = s.indexOf("}", i + 2)) != -1) {
                    String sysPropName = s.substring(i + 2, j);
                    String sysPropValue = System.getProperty(sysPropName);
                    if (sysPropValue != null) {
                        result = String.valueOf(s.substring(0, i)) + sysPropValue + s.substring(j + 1);
                        searchNdx = i + sysPropValue.length();
                        continue;
                    }
                    searchNdx = j + 1;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {}
        return result;
    }
}

