/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Constructed;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;

public final class Alert
implements Constructed {
    private final ByteBuffer buffer;

    public Alert(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public Alert(Level level, Description description) {
        ((Object)((Object)level)).getClass();
        ((Object)((Object)description)).getClass();
        ByteBuffer b = ByteBuffer.allocate(2);
        b.put(0, (byte)level.getValue());
        b.put(1, (byte)description.getValue());
        this.buffer = b.asReadOnlyBuffer();
    }

    public int length() {
        return 2;
    }

    byte[] getEncoded() {
        byte[] buf = new byte[2];
        this.buffer.position(0);
        this.buffer.get(buf);
        return buf;
    }

    public Level level() {
        return Level.forInteger(this.buffer.get(0) & 0xFF);
    }

    public Description description() {
        return Description.forInteger(this.buffer.get(1) & 0xFF);
    }

    public void setLevel(Level level) {
        this.buffer.put(0, (byte)level.getValue());
    }

    public void setDescription(Description description) {
        this.buffer.put(1, (byte)description.getValue());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Alert)) {
            return false;
        }
        Alert that = (Alert)o;
        return that.buffer.position(0).equals(this.buffer.position(0));
    }

    public int hashCode() {
        return this.buffer.getShort(0) & 0xFFFF;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("struct {");
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("  level:       ");
        out.print((Object)this.level());
        out.println(";");
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("  description: ");
        out.print((Object)this.description());
        out.println(";");
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("} Alert;");
        return str.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Description {
        CLOSE_NOTIFY(0),
        UNEXPECTED_MESSAGE(10),
        BAD_RECORD_MAC(20),
        DECRYPTION_FAILED(21),
        RECORD_OVERFLOW(22),
        DECOMPRESSION_FAILURE(30),
        HANDSHAKE_FAILURE(40),
        NO_CERTIFICATE(41),
        BAD_CERTIFICATE(42),
        UNSUPPORTED_CERTIFICATE(43),
        CERTIFICATE_REVOKED(44),
        CERTIFICATE_EXPIRED(45),
        CERTIFICATE_UNKNOWN(46),
        ILLEGAL_PARAMETER(47),
        UNKNOWN_CA(48),
        ACCESS_DENIED(49),
        DECODE_ERROR(50),
        DECRYPT_ERROR(51),
        EXPORT_RESTRICTION(60),
        PROTOCOL_VERSION(70),
        INSUFFICIENT_SECURITY(71),
        INTERNAL_ERROR(80),
        USER_CANCELED(90),
        NO_RENEGOTIATION(100),
        UNSUPPORTED_EXTENSION(110),
        CERTIFICATE_UNOBTAINABLE(111),
        UNRECOGNIZED_NAME(112),
        BAD_CERTIFICATE_STATUS_RESPONSE(113),
        BAD_CERTIFICATE_HASH_VALUE(114),
        UNKNOWN_SRP_USERNAME(120),
        MISSING_SRP_USERNAME(121);

        private final int value;

        private Description(int value) {
            this.value = value;
        }

        public static Description forInteger(int value) {
            switch (value & 0xFF) {
                case 0: {
                    return CLOSE_NOTIFY;
                }
                case 10: {
                    return UNEXPECTED_MESSAGE;
                }
                case 20: {
                    return BAD_RECORD_MAC;
                }
                case 21: {
                    return DECRYPTION_FAILED;
                }
                case 22: {
                    return RECORD_OVERFLOW;
                }
                case 30: {
                    return DECOMPRESSION_FAILURE;
                }
                case 40: {
                    return HANDSHAKE_FAILURE;
                }
                case 41: {
                    return NO_CERTIFICATE;
                }
                case 42: {
                    return BAD_CERTIFICATE;
                }
                case 43: {
                    return UNSUPPORTED_CERTIFICATE;
                }
                case 44: {
                    return CERTIFICATE_REVOKED;
                }
                case 45: {
                    return CERTIFICATE_EXPIRED;
                }
                case 46: {
                    return CERTIFICATE_UNKNOWN;
                }
                case 47: {
                    return ILLEGAL_PARAMETER;
                }
                case 48: {
                    return UNKNOWN_CA;
                }
                case 49: {
                    return ACCESS_DENIED;
                }
                case 50: {
                    return DECODE_ERROR;
                }
                case 51: {
                    return DECRYPT_ERROR;
                }
                case 60: {
                    return EXPORT_RESTRICTION;
                }
                case 70: {
                    return PROTOCOL_VERSION;
                }
                case 71: {
                    return INSUFFICIENT_SECURITY;
                }
                case 80: {
                    return INTERNAL_ERROR;
                }
                case 90: {
                    return USER_CANCELED;
                }
                case 100: {
                    return NO_RENEGOTIATION;
                }
                case 120: {
                    return UNKNOWN_SRP_USERNAME;
                }
                case 121: {
                    return MISSING_SRP_USERNAME;
                }
            }
            throw new IllegalArgumentException("unknown alert description: " + value);
        }

        public int getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        WARNING(1),
        FATAL(2);

        private final int value;

        private Level(int value) {
            this.value = value;
        }

        public static Level forInteger(int value) {
            switch (value & 0xFF) {
                case 1: {
                    return WARNING;
                }
                case 2: {
                    return FATAL;
                }
            }
            throw new IllegalArgumentException("invalid alert level: " + value);
        }

        public int getValue() {
            return this.value;
        }
    }
}

