/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.sig;

import gnu.java.security.jce.sig.KeyPairGeneratorAdapter;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public class DHKeyPairGeneratorSpi
extends KeyPairGeneratorAdapter {
    public DHKeyPairGeneratorSpi() {
        super("dh");
    }

    public void initialize(int keysize, SecureRandom random) {
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        attributes.put("gnu.crypto.dh.L", Integer.valueOf(keysize));
        if (random != null) {
            attributes.put("gnu.crypto.dh.prng", random);
        }
        attributes.put("gnu.crypto.dh.encoding", Integer.valueOf(4));
        this.adaptee.setup(attributes);
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (params != null) {
            if (!(params instanceof DHGenParameterSpec) && !(params instanceof DHParameterSpec)) {
                throw new InvalidAlgorithmParameterException("params");
            }
            attributes.put("gnu.crypto.dh.params", params);
        }
        if (random != null) {
            attributes.put("gnu.crypto.dh.prng", random);
        }
        attributes.put("gnu.crypto.dh.encoding", 4);
        this.adaptee.setup(attributes);
    }
}

