#!/bin/sh
echo 'name: feldspar-language
version: 0.6.0.2
id: feldspar-language-0.6.0.2-5be76375bd35b02395eef9ebb2b980cc

license: BSD3
copyright: Copyright (c) 2012 Emil Axelsson, Gergely Dévai,
           Anders Persson, Josef Svenningsson
           Copyright (c) 2009-2011, ERICSSON AB
maintainer: Emil Axelsson <emax@chalmers.se>
            Anders Persson <anders.cj.persson@gmail.com>
stability: experimental
homepage: https://feldspar.github.com
package-url:
synopsis: A functional embedded language for DSP and parallelism
description: Feldspar (Functional Embedded Language for DSP and PARallelism)
             is an embedded DSL for describing digital signal processing
             algorithms. This package contains the language front-end and an
             interpreter.
category: Language
author: Functional programming group at Chalmers University of Technology
pkgpath: lang/feldspar/language
exposed: True
exposed-modules: Feldspar.Prelude Feldspar.Lattice Feldspar.Range
                 Feldspar.Algorithm.CRC Feldspar.Algorithm.FFT Feldspar.Core.Types
                 Feldspar.Core.Interpretation Feldspar.Core.Interpretation.Typed
                 Feldspar.Core.Constructs.Array Feldspar.Core.Constructs.Binding
                 Feldspar.Core.Constructs.Bits Feldspar.Core.Constructs.Complex
                 Feldspar.Core.Constructs.Condition
                 Feldspar.Core.Constructs.ConditionM
                 Feldspar.Core.Constructs.Conversion Feldspar.Core.Constructs.Eq
                 Feldspar.Core.Constructs.Error Feldspar.Core.Constructs.Floating
                 Feldspar.Core.Constructs.Fractional Feldspar.Core.Constructs.Future
                 Feldspar.Core.Constructs.Integral Feldspar.Core.Constructs.Literal
                 Feldspar.Core.Constructs.Logic Feldspar.Core.Constructs.Loop
                 Feldspar.Core.Constructs.Mutable
                 Feldspar.Core.Constructs.MutableArray
                 Feldspar.Core.Constructs.MutableReference
                 Feldspar.Core.Constructs.MutableToPure
                 Feldspar.Core.Constructs.NoInline Feldspar.Core.Constructs.Par
                 Feldspar.Core.Constructs.Num Feldspar.Core.Constructs.Ord
                 Feldspar.Core.Constructs.SizeProp
                 Feldspar.Core.Constructs.SourceInfo Feldspar.Core.Constructs.Trace
                 Feldspar.Core.Constructs.Tuple Feldspar.Core.Constructs.FFI
                 Feldspar.Core.Constructs.Save Feldspar.Core.Constructs
                 Feldspar.Core.Frontend.Array Feldspar.Core.Frontend.Binding
                 Feldspar.Core.Frontend.Bits Feldspar.Core.Frontend.Complex
                 Feldspar.Core.Frontend.Condition Feldspar.Core.Frontend.ConditionM
                 Feldspar.Core.Frontend.Conversion Feldspar.Core.Frontend.Eq
                 Feldspar.Core.Frontend.Error Feldspar.Core.Frontend.Floating
                 Feldspar.Core.Frontend.Fractional Feldspar.Core.Frontend.Future
                 Feldspar.Core.Frontend.Integral Feldspar.Core.Frontend.Literal
                 Feldspar.Core.Frontend.Logic Feldspar.Core.Frontend.Loop
                 Feldspar.Core.Frontend.Mutable Feldspar.Core.Frontend.MutableArray
                 Feldspar.Core.Frontend.MutableReference
                 Feldspar.Core.Frontend.MutableToPure
                 Feldspar.Core.Frontend.NoInline Feldspar.Core.Frontend.Par
                 Feldspar.Core.Frontend.Num Feldspar.Core.Frontend.Ord
                 Feldspar.Core.Frontend.Select Feldspar.Core.Frontend.SizeProp
                 Feldspar.Core.Frontend.SourceInfo Feldspar.Core.Frontend.Trace
                 Feldspar.Core.Frontend.Tuple Feldspar.Core.Frontend.FFI
                 Feldspar.Core.Frontend.Save Feldspar.Core.Frontend
                 Feldspar.Core.Collection Feldspar.Core Feldspar.BitVector
                 Feldspar.FixedPoint Feldspar.Future Feldspar.Matrix Feldspar.Option
                 Feldspar.Repa Feldspar.Stream Feldspar.Vector.Internal
                 Feldspar.Vector Feldspar.Vector.Push Feldspar.Wrap Feldspar.Par
                 Feldspar
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/feldspar-language-0.6.0.2
library-dirs: /usr/local/lib/ghc/feldspar-language-0.6.0.2
hs-libraries: HSfeldspar-language-0.6.0.2
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: QuickAnnotate-0.6-6581406ce17d9b4d3eb7bd9b9b2ed5b4
         QuickCheck-2.6-b2c516c95dc721ca4b3874375f2395ba
         array-0.4.0.1-3b78425c10ff2dad7acf7e8c8ae014c3
         base-4.6.0.1-03845c6da2a0b3b4d0d49cc26c0cd3c0
         containers-0.5.0.0-ab1dae9a94cd3cc84e7b2805636ebfa2
         data-hash-0.1.0.0-263d820f301a41acd3318a0931fb78a7
         data-lens-2.10.2-fff2a655936224234f43e34f6f508f81
         monad-par-0.3-5e852fb6c67aad619b5d08fd2956ee33
         mtl-2.1.2-94c72af955e94b8d7b2f359dadd0cb62
         patch-combinators-0.1-442b0af76ee834b9505aef46a7b84d7a
         syntactic-1.4-a622bff1ad4c4484ac8fb2c10bbf9ef3
         tagged-0.4.4-1d79540bc7ac025035db56fca97243b1
         tuple-0.2.0.1-09cbd406ad634e846023a6c018fbda8e
         type-level-0.2.4-49f226fdebb116d6efb9891a70c64125
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-feldspar-language-0.6.0.2/html/feldspar-language.haddock
haddock-html: /usr/local/share/doc/hs-feldspar-language-0.6.0.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
