/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.wizards.CommentCommitWizardPage;
import org.tigris.subversion.subclipse.ui.wizards.NewRemoteFolderWizardMainPage;

public class NewRemoteFolderWizard
extends Wizard {
    private NewRemoteFolderWizardMainPage mainPage;
    private CommentCommitWizardPage commitCommentPage;
    private ISVNRemoteFolder selection;
    private Dialog parentDialog;

    public NewRemoteFolderWizard(ISVNRemoteFolder selection) {
        this.setWindowTitle(Policy.bind("NewRemoteFolderWizard.title"));
        this.selection = selection;
    }

    public void addPages() {
        this.mainPage = new NewRemoteFolderWizardMainPage("newRemoteFolderPage1", Policy.bind("NewRemoteFolderWizard.heading"), SVNUIPlugin.getPlugin().getImageDescriptor("wizban/newfolder_wizban.gif"));
        this.mainPage.setParentFolder(this.selection);
        this.addPage((IWizardPage)this.mainPage);
        String pageTitle = Policy.bind("CommentCommitWizardPage.pageTitle");
        String pageDescription = Policy.bind("CommentCommitWizardPage.pageDescription");
        ImageDescriptor image = SVNUIPlugin.getPlugin().getImageDescriptor("wizban/newfolder_wizban.gif");
        this.commitCommentPage = new CommentCommitWizardPage(this.parentDialog, pageTitle, pageTitle, image, pageDescription);
        this.addPage((IWizardPage)this.commitCommentPage);
    }

    public boolean performFinish() {
        try {
            final String folderName = this.mainPage.getFolderName();
            final String comment = this.commitCommentPage.getComment();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        ISVNRemoteFolder parentFolder = NewRemoteFolderWizard.this.mainPage.getParentFolder();
                        parentFolder.createRemoteFolder(folderName, comment, monitor);
                    }
                    catch (SVNException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            new ProgressMonitorDialog(this.getShell()).run(true, false, runnable);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            SVNUIPlugin.openError(this.getContainer().getShell(), Policy.bind("exception"), null, e.getCause(), 1);
            return false;
        }
        return true;
    }

    public void setParentDialog(Dialog dialog) {
        this.parentDialog = dialog;
    }
}

