/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.ISubscriberChangeListener;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.quickdiff.IQuickDiffReferenceProvider;
import org.tigris.subversion.subclipse.core.ISVNLocalFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.sync.SVNWorkspaceSubscriber;
import org.tigris.subversion.subclipse.ui.Policy;

public class SVNPristineCopyQuickDiffProvider
implements IQuickDiffReferenceProvider {
    private ITextEditor editor = null;
    private IDocument referenceDocument = null;
    private boolean isReferenceInitialized = false;
    private IDocumentProvider documentProvider = null;
    private String id;
    private SyncInfo fLastSyncState;
    private Job fUpdateJob;
    private boolean DEBUG = false;
    private ISubscriberChangeListener teamChangeListener = new ISubscriberChangeListener(){

        public void subscriberResourceChanged(ISubscriberChangeEvent[] deltas) {
            if (SVNPristineCopyQuickDiffProvider.this.isReferenceInitialized) {
                int i = 0;
                while (i < deltas.length) {
                    ISubscriberChangeEvent delta = deltas[i];
                    IResource resource = delta.getResource();
                    if (resource.getType() == 1 && SVNPristineCopyQuickDiffProvider.this.fLastSyncState != null && resource.equals((Object)SVNPristineCopyQuickDiffProvider.this.fLastSyncState.getLocal()) && delta.getFlags() == 1) {
                        SVNPristineCopyQuickDiffProvider.this.fetchContentsInJob();
                    }
                    ++i;
                }
            }
        }
    };
    private IElementStateListener documentListener = new IElementStateListener(){

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
        }

        public void elementContentAboutToBeReplaced(Object element) {
        }

        public void elementContentReplaced(Object element) {
            if (SVNPristineCopyQuickDiffProvider.this.editor != null && SVNPristineCopyQuickDiffProvider.this.editor.getEditorInput() == element) {
                SVNPristineCopyQuickDiffProvider.this.fetchContentsInJob();
            }
        }

        public void elementDeleted(Object element) {
        }

        public void elementMoved(Object originalElement, Object movedElement) {
        }
    };

    public IDocument getReference(IProgressMonitor monitor) throws CoreException {
        if (!this.isReferenceInitialized) {
            return null;
        }
        if (this.referenceDocument == null) {
            this.readDocument(monitor);
        }
        return this.referenceDocument;
    }

    public void setActiveEditor(ITextEditor targetEditor) {
        if (!(targetEditor.getEditorInput() instanceof IFileEditorInput)) {
            return;
        }
        this.editor = targetEditor;
        this.documentProvider = this.editor.getDocumentProvider();
        if (this.documentProvider != null) {
            SVNWorkspaceSubscriber.getInstance().addListener(this.teamChangeListener);
            this.documentProvider.addElementStateListener(this.documentListener);
        }
        this.isReferenceInitialized = true;
    }

    public boolean isEnabled() {
        if (!this.isReferenceInitialized) {
            return false;
        }
        try {
            return this.getManagedSVNFile() != null;
        }
        catch (SVNException sVNException) {
            return false;
        }
    }

    public void dispose() {
        this.isReferenceInitialized = false;
        if (this.fUpdateJob != null && this.fUpdateJob.getState() != 0) {
            this.fUpdateJob.cancel();
        }
        if (this.documentProvider != null) {
            this.documentProvider.removeElementStateListener(this.documentListener);
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    private boolean computeChange(IProgressMonitor monitor) throws TeamException {
        boolean needToUpdateReferenceDocument = false;
        if (this.isReferenceInitialized) {
            SyncInfo info = this.getSyncState((IResource)this.getFileFromEditor());
            if (info == null && this.fLastSyncState != null) {
                return true;
            }
            if (info == null) {
                return false;
            }
            if (this.fLastSyncState == null) {
                needToUpdateReferenceDocument = true;
            } else if (!this.fLastSyncState.equals((Object)info)) {
                needToUpdateReferenceDocument = true;
            }
            if (this.DEBUG) {
                this.debug(this.fLastSyncState, info);
            }
            this.fLastSyncState = info;
        }
        return needToUpdateReferenceDocument;
    }

    private void debug(SyncInfo lastSyncState, SyncInfo info) {
        String last = "[none]";
        if (lastSyncState != null) {
            last = lastSyncState.toString();
        }
        System.out.println("+ SVNQuickDiff: was " + last + " is " + info.toString());
    }

    private SyncInfo getSyncState(IResource resource) throws TeamException {
        if (resource == null) {
            return null;
        }
        return SVNWorkspaceSubscriber.getInstance().getSyncInfo(resource);
    }

    private void readDocument(IProgressMonitor monitor) throws CoreException {
        if (!this.isReferenceInitialized) {
            return;
        }
        if (this.referenceDocument == null) {
            this.referenceDocument = new Document();
        }
        if (this.computeChange(monitor)) {
            ISVNRemoteFile remoteFile = (ISVNRemoteFile)this.fLastSyncState.getBase();
            if (remoteFile != null && this.documentProvider instanceof IStorageDocumentProvider) {
                IStorageDocumentProvider provider = (IStorageDocumentProvider)this.documentProvider;
                String encoding = provider.getEncoding((Object)this.editor.getEditorInput());
                if (encoding == null) {
                    encoding = provider.getDefaultEncoding();
                }
                if (monitor.isCanceled()) {
                    return;
                }
                InputStream stream = remoteFile.getStorage(monitor).getContents();
                if (stream == null || monitor.isCanceled() || !this.isReferenceInitialized) {
                    return;
                }
                SVNPristineCopyQuickDiffProvider.setDocumentContent(this.referenceDocument, stream, encoding);
            } else {
                if (monitor.isCanceled()) {
                    return;
                }
                this.referenceDocument.set("");
            }
            if (this.DEBUG) {
                System.out.println("+ SVNQuickDiff: updating document " + (this.referenceDocument != null ? "remote found" : "remote empty"));
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static void setDocumentContent(IDocument document, InputStream contentStream, String encoding) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 148->152)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ISVNLocalFile getManagedSVNFile() throws SVNException {
        IFile file;
        if (this.editor != null && (file = this.getFileFromEditor()) != null) {
            ISVNLocalFile svnFile = SVNWorkspaceRoot.getSVNFileFor((IFile)file);
            if (svnFile.exists() && svnFile.isManaged()) {
                return svnFile;
            }
            return null;
        }
        return null;
    }

    private IFile getFileFromEditor() {
        IEditorInput input;
        if (this.editor != null && (input = this.editor.getEditorInput()) instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }

    private void fetchContentsInJob() {
        if (!this.isReferenceInitialized) {
            return;
        }
        if (this.fUpdateJob != null && this.fUpdateJob.getState() != 0) {
            this.fUpdateJob.cancel();
        }
        this.fUpdateJob = new Job(Policy.bind("RemoteRevisionQuickDiffProvider.fetchingFile")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    SVNPristineCopyQuickDiffProvider.this.readDocument(monitor);
                }
                catch (CoreException coreException) {}
                return Status.OK_STATUS;
            }
        };
        this.fUpdateJob.schedule();
    }
}

