/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.ISVNResource;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNStatus;
import org.tigris.subversion.subclipse.core.resources.RemoteFile;
import org.tigris.subversion.subclipse.core.resources.RemoteResource;
import org.tigris.subversion.subclipse.core.resources.RemoteResourceStatus;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RemoteFolder
extends RemoteResource
implements ISVNRemoteFolder,
ISVNFolder {
    protected ISVNRemoteResource[] children;

    public RemoteFolder(RemoteFolder parent, ISVNRepositoryLocation repository, SVNUrl url, SVNRevision revision, SVNRevision.Number lastChangedRevision, Date date, String author) {
        super(parent, repository, url, revision, lastChangedRevision, date, author);
    }

    public RemoteFolder(ISVNRepositoryLocation repository, SVNUrl url, SVNRevision revision) {
        super(repository, url, revision);
    }

    public RemoteFolder(IResource resource, byte[] bytes) {
        super(resource, bytes);
    }

    public RemoteFolder(RemoteResourceStatus remoteStatusInfo) {
        this(null, remoteStatusInfo.getRepository(), remoteStatusInfo.getUrl(), (SVNRevision)remoteStatusInfo.getRepositoryRevision(), remoteStatusInfo.getLastChangedRevision(), remoteStatusInfo.getLastChangedDate(), remoteStatusInfo.getLastCommitAuthor());
    }

    public boolean exists(IProgressMonitor monitor) throws TeamException {
        try {
            this.getMembers(monitor);
            return true;
        }
        catch (SVNException e) {
            if (e.getStatus().getCode() == -17) {
                return false;
            }
            throw e;
        }
    }

    protected boolean exists(ISVNRemoteResource child, IProgressMonitor monitor) throws SVNException {
        ISVNRemoteResource[] members;
        try {
            members = this.getMembers(monitor);
        }
        catch (SVNException e) {
            if (e.getStatus().getCode() == -17) {
                return false;
            }
            throw e;
        }
        int i = 0;
        while (i < members.length) {
            if (members[i].equals(child)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void refresh() {
        this.children = null;
    }

    protected ISVNRemoteResource[] getMembers(IProgressMonitor monitor) throws SVNException {
        ISVNRemoteResource[] iSVNRemoteResourceArray;
        IProgressMonitor progress = Policy.monitorFor(monitor);
        progress.beginTask(Policy.bind("RemoteFolder.getMembers"), 100);
        if (this.children != null) {
            progress.done();
            return this.children;
        }
        try {
            ISVNDirEntry entry;
            ISVNClientAdapter client = this.getRepository().getSVNClient();
            ISVNDirEntry[] list = client.getList(this.url, this.getRevision(), false);
            ArrayList<RemoteResource> result = new ArrayList<RemoteResource>(list.length);
            int i = 0;
            while (i < list.length) {
                entry = list[i];
                if (entry.getNodeKind() == SVNNodeKind.DIR) {
                    result.add(new RemoteFolder(this, this.getRepository(), this.url.appendPath(entry.getPath()), this.getRevision(), entry.getLastChangedRevision(), entry.getLastChangedDate(), entry.getLastCommitAuthor()));
                }
                ++i;
            }
            i = 0;
            while (i < list.length) {
                entry = list[i];
                if (entry.getNodeKind() == SVNNodeKind.FILE) {
                    result.add(new RemoteFile(this, this.getRepository(), this.url.appendPath(entry.getPath()), this.getRevision(), entry.getLastChangedRevision(), entry.getLastChangedDate(), entry.getLastCommitAuthor()));
                }
                ++i;
            }
            this.children = result.toArray(new ISVNRemoteResource[result.size()]);
            iSVNRemoteResourceArray = this.children;
            Object var8_9 = null;
        }
        catch (SVNClientException sVNClientException) {
            try {
                throw new SVNException((IStatus)new SVNStatus(4, -17, Policy.bind("RemoteFolder.doesNotExist", this.getRepositoryRelativePath())));
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                progress.done();
                throw throwable;
            }
        }
        progress.done();
        return iSVNRemoteResourceArray;
    }

    public ISVNResource[] members(IProgressMonitor monitor, int flags) throws SVNException {
        ArrayList<ISVNRemoteResource> result = new ArrayList<ISVNRemoteResource>();
        ISVNRemoteResource[] resources = this.getMembers(monitor);
        if ((flags & 0x20) == 0 && (flags & 0x40) == 1) {
            return new ISVNResource[0];
        }
        boolean includeFiles = (flags & 1) != 0 || (flags & 3) == 0;
        boolean includeFolders = (flags & 2) != 0 || (flags & 3) == 0;
        boolean includeManaged = (flags & 0x10) != 0 || (flags & 0x1C) == 0;
        int i = 0;
        while (i < resources.length) {
            ISVNRemoteResource svnResource = resources[i];
            if ((includeFiles && !svnResource.isFolder() || includeFolders && svnResource.isFolder()) && includeManaged) {
                result.add(svnResource);
            }
            ++i;
        }
        return result.toArray(new ISVNResource[result.size()]);
    }

    public boolean isFolder() {
        return true;
    }

    public boolean isContainer() {
        return true;
    }

    public ISVNRemoteResource[] members(IProgressMonitor progress) throws TeamException {
        return this.getMembers(progress);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createRemoteFolder(String folderName, String message, IProgressMonitor monitor) throws SVNException {
        IProgressMonitor progress = Policy.monitorFor(monitor);
        progress.beginTask(Policy.bind("RemoteFolder.createRemoteFolder"), 100);
        try {
            try {
                ISVNClientAdapter svnClient = this.getRepository().getSVNClient();
                svnClient.mkdir(this.getUrl().appendPath(folderName), message);
                this.refresh();
                SVNProviderPlugin.getPlugin().getRepositoryResourcesManager().remoteResourceCreated(this, folderName);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            progress.done();
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        progress.done();
    }

    protected void fetchContents(IProgressMonitor monitor) {
    }
}

