/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ObjectTypeFactory;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ObjectType;

public class StaticCalendarDetector
extends BytecodeScanningDetector {
    private static final boolean DEBUG = Boolean.getBoolean("debug.staticcal");
    private BugReporter reporter;
    private String currentClass;
    private final ObjectType calendarType = ObjectTypeFactory.getInstance((String)"java.util.Calendar");
    private final ObjectType dateFormatType = ObjectTypeFactory.getInstance((String)"java.text.DateFormat");
    private int seenStaticGetCalendarAt;
    private int seenStaticGetDateFormatAt;
    private Map<Integer, Integer> registerStaticStoreCalendarAt = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> registerStaticStoreDateFormatAt = new HashMap<Integer, Integer>();

    public void visit(JavaClass someObj) {
        this.currentClass = someObj.getClassName();
        super.visit(someObj);
    }

    public void visit(Field aField) {
        boolean tIsStatic;
        super.visit(aField);
        int tTyp = 0;
        String tFieldSig = aField.getSignature();
        if (aField.getType() instanceof ObjectType) {
            ObjectType tType = (ObjectType)aField.getType();
            try {
                if (tType.subclassOf(this.calendarType)) {
                    tTyp = 1;
                } else if (tType.subclassOf(this.dateFormatType)) {
                    tTyp = 2;
                }
            }
            catch (ClassNotFoundException e) {}
        } else {
            return;
        }
        if (tIsStatic = aField.isStatic()) {
            String tType = null;
            switch (tTyp) {
                case 1: {
                    tType = "STCAL_STATIC_CALENDAR_INSTANCE";
                    break;
                }
                case 2: {
                    tType = "STCAL_STATIC_SIMPLE_DATA_FORMAT_INSTANCE";
                    break;
                }
            }
            if (tType != null) {
                this.reporter.reportBug(new BugInstance((Detector)this, tType, 2).addClass(this.currentClass).addField(this.currentClass, aField.getName(), tFieldSig, tIsStatic));
            }
        }
    }

    public void visit(Code obj) {
        this.seenStaticGetCalendarAt = Integer.MIN_VALUE;
        this.seenStaticGetDateFormatAt = Integer.MIN_VALUE;
        this.registerStaticStoreCalendarAt.clear();
        this.registerStaticStoreDateFormatAt.clear();
        super.visit(obj);
    }

    public void sawOpcode(int seen) {
        if (this.simpleCase(seen)) {
            return;
        }
        if (seen == 58 || seen == 75 || seen == 76 || seen == 77 || seen == 78) {
            int tRegister = this.getRegisterOperand();
            int tPC = this.getPC();
            if (tPC >= this.seenStaticGetCalendarAt + 3 && tPC < this.seenStaticGetCalendarAt + 4) {
                this.registerStaticStoreCalendarAt.put(new Integer(tRegister), new Integer(tPC));
                if (DEBUG) {
                    System.out.println("STCAL: astore: reg " + tRegister + " at " + tPC);
                }
            } else if (tPC >= this.seenStaticGetDateFormatAt + 3 && tPC < this.seenStaticGetDateFormatAt + 4) {
                this.registerStaticStoreDateFormatAt.put(new Integer(tRegister), new Integer(tPC));
                if (DEBUG) {
                    System.out.println("STCAL: astore: reg " + tRegister + " at " + tPC);
                }
            } else {
                this.registerStaticStoreCalendarAt.remove(new Integer(tRegister));
                this.registerStaticStoreDateFormatAt.remove(new Integer(tRegister));
                if (DEBUG) {
                    System.out.println("STCAL: astore: clear reg " + tRegister + " at " + tPC);
                }
            }
        }
        if (seen == 25 || seen == 42 || seen == 43 || seen == 44 || seen == 45) {
            int tPC = this.getPC();
            int tRegister = this.getRegisterOperand();
            Integer tPCOfStore = this.registerStaticStoreCalendarAt.get(new Integer(tRegister));
            if (tPCOfStore != null) {
                if (DEBUG) {
                    System.out.println("STCAL: aload: reg " + tRegister + " at " + tPC);
                }
                this.reporter.reportBug(new BugInstance((Detector)this, "STCAL_INVOKE_ON_STATIC_CALENDAR_INSTANCE", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, tPCOfStore.intValue()).addSourceLine((BytecodeScanningDetector)this, tPC));
                return;
            }
            tPCOfStore = this.registerStaticStoreDateFormatAt.get(new Integer(tRegister));
            if (tPCOfStore != null) {
                if (DEBUG) {
                    System.out.println("STCAL: aload: reg " + tRegister + " at " + tPC);
                }
                this.reporter.reportBug(new BugInstance((Detector)this, "STCAL_INVOKE_ON_STATIC_DATE_FORMAT_INSTANCE", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, tPCOfStore.intValue()).addSourceLine((BytecodeScanningDetector)this, tPC));
                return;
            }
        }
    }

    private boolean simpleCase(int seen) {
        if (seen == 178) {
            String tClassName = this.getSigConstantOperand();
            if (tClassName != null && tClassName.startsWith("L") && tClassName.endsWith(";")) {
                tClassName = tClassName.substring(1, tClassName.length() - 1);
                ObjectType tType = ObjectTypeFactory.getInstance((String)tClassName);
                try {
                    if (tType.subclassOf(this.calendarType)) {
                        this.seenStaticGetCalendarAt = this.getPC();
                        return true;
                    }
                    if (tType.subclassOf(this.dateFormatType)) {
                        this.seenStaticGetDateFormatAt = this.getPC();
                        return true;
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            return false;
        }
        if (seen == 182) {
            int tPC = this.getPC();
            if (tPC >= this.seenStaticGetCalendarAt + 3 && tPC < this.seenStaticGetCalendarAt + 4) {
                this.reporter.reportBug(new BugInstance((Detector)this, "STCAL_INVOKE_ON_STATIC_CALENDAR_INSTANCE", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, tPC));
                return true;
            }
            if (tPC >= this.seenStaticGetDateFormatAt + 3 && tPC < this.seenStaticGetDateFormatAt + 4) {
                this.reporter.reportBug(new BugInstance((Detector)this, "STCAL_INVOKE_ON_STATIC_DATE_FORMAT_INSTANCE", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, tPC));
                return true;
            }
        }
        return false;
    }

    public StaticCalendarDetector(BugReporter aReporter) {
        this.reporter = aReporter;
    }
}

