/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine;

import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.ClassNameMismatchException;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.IClassAnalysisEngine;
import edu.umd.cs.findbugs.classfile.analysis.ClassData;
import edu.umd.cs.findbugs.classfile.analysis.ClassInfo;
import edu.umd.cs.findbugs.classfile.engine.ClassParser;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class ClassInfoAnalysisEngine
implements IClassAnalysisEngine {
    public Object analyze(IAnalysisCache analysisCache, ClassDescriptor descriptor) throws CheckedAnalysisException {
        ClassData classData = (ClassData)analysisCache.getClassAnalysis(ClassData.class, descriptor);
        DataInputStream classDataIn = new DataInputStream(new ByteArrayInputStream(classData.getData()));
        ClassParser parser = new ClassParser(classDataIn, descriptor, classData.getCodeBaseEntry());
        ClassInfo classInfo = new ClassInfo();
        parser.parse(classInfo);
        if (!classInfo.getClassDescriptor().equals(descriptor)) {
            throw new ClassNameMismatchException(descriptor, classInfo.getClassDescriptor(), classData.getCodeBaseEntry());
        }
        return classInfo;
    }

    public void registerWith(IAnalysisCache analysisCache) {
        analysisCache.registerClassAnalysisEngine(ClassInfo.class, this);
    }

    public boolean retainAnalysisResults() {
        return false;
    }

    public /* synthetic */ Object analyze(IAnalysisCache x0, Object x1) throws CheckedAnalysisException {
        return this.analyze(x0, (ClassDescriptor)x1);
    }
}

