/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.interproc;

import edu.umd.cs.findbugs.ba.ClassMember;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.interproc.PropertyDatabase;
import edu.umd.cs.findbugs.ba.interproc.PropertyDatabaseFormatException;
import java.io.IOException;
import java.io.Writer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MethodPropertyDatabase<Property>
extends PropertyDatabase<XMethod, Property> {
    @Override
    protected XMethod parseKey(String methodStr) throws PropertyDatabaseFormatException {
        String[] tuple = methodStr.split(",");
        if (tuple.length != 4) {
            throw new PropertyDatabaseFormatException(new StringBuffer().append("Invalid method tuple: ").append(methodStr).toString());
        }
        try {
            int accessFlags = Integer.parseInt(tuple[3]);
            return XFactory.createXMethod(XFactory.canonicalizeString(tuple[0]), XFactory.canonicalizeString(tuple[1]), XFactory.canonicalizeString(tuple[2]), accessFlags);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    protected void writeKey(Writer writer, XMethod method) throws IOException {
        writer.write(method.getClassName());
        writer.write(",");
        writer.write(method.getName());
        writer.write(",");
        writer.write(method.getSignature());
        writer.write(",");
        writer.write(String.valueOf(method.getAccessFlags()));
    }

    @Override
    protected /* synthetic */ void writeKey(Writer x0, ClassMember x1) throws IOException {
        this.writeKey(x0, (XMethod)x1);
    }

    @Override
    protected /* synthetic */ ClassMember parseKey(String x0) throws PropertyDatabaseFormatException {
        return this.parseKey(x0);
    }
}

