/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.MarkerUtil;
import de.tobject.findbugs.view.BugTreeView;
import de.tobject.findbugs.view.UserAnnotationsView;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;

public class DetailsView
extends ViewPart {
    private static DetailsView detailsView;
    private String description = "";
    private String title = "";
    private List annotationList;
    private Text priorityTypeArea;
    private String priorityTypeString = "";
    private BugInstance theBug;
    private ISelectionListener selectionListener;
    private SashForm sash;
    @CheckForNull
    private StyledText control;
    private DefaultInformationControl.IInformationPresenter presenter;
    private TextPresentation presentation = new TextPresentation();
    @CheckForNull
    private Browser browser;

    public void createPartControl(Composite parent) {
        this.sash = new SashForm(parent, 512);
        this.priorityTypeArea = new Text((Composite)this.sash, 512);
        this.priorityTypeArea.setEditable(false);
        this.annotationList = new List((Composite)this.sash, 512);
        this.annotationList.setToolTipText("Additional information about the selected bug");
        this.annotationList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DetailsView.this.theBug == null) {
                    return;
                }
                int index = DetailsView.this.annotationList.getSelectionIndex();
                Iterator theIterator = DetailsView.this.theBug.annotationIterator();
                BugAnnotation theAnnotation = (BugAnnotation)theIterator.next();
                for (int i = 0; i < index; ++i) {
                    theAnnotation = (BugAnnotation)theIterator.next();
                }
                if (theAnnotation instanceof SourceLineAnnotation) {
                    SourceLineAnnotation sla = (SourceLineAnnotation)theAnnotation;
                    IFile file = null;
                    try {
                        IProject project = MarkerUtil.findProjectForWarning(DetailsView.this.theBug);
                        if (project == null) {
                            return;
                        }
                        file = (IFile)MarkerUtil.getUnderlyingResource(DetailsView.this.theBug, project, sla);
                    }
                    catch (JavaModelException ex) {
                        FindbugsPlugin.getDefault().logException((Exception)((Object)ex), "Could not find file for " + DetailsView.this.theBug.getMessage());
                        return;
                    }
                    if (file == null) {
                        FindbugsPlugin.getDefault().logError("Could not find file for " + DetailsView.this.theBug.getMessage());
                        return;
                    }
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    map.put("lineNumber", new Integer(sla.getStartLine()));
                    try {
                        IMarker marker = file.createMarker("org.eclipse.core.resources.textmarker");
                        marker.setAttributes(map);
                        IDE.openEditor((IWorkbenchPage)DetailsView.this.getSite().getPage(), (IMarker)marker);
                        marker.delete();
                    }
                    catch (PartInitException x) {
                        FindbugsPlugin.getDefault().logException((Exception)((Object)x), "Could not create marker for " + DetailsView.this.theBug.getMessage());
                    }
                    catch (CoreException y) {
                        FindbugsPlugin.getDefault().logException((Exception)((Object)y), "Could not create marker for " + DetailsView.this.theBug.getMessage());
                    }
                }
            }
        });
        try {
            this.browser = new Browser((Composite)this.sash, 0);
            this.browser.setToolTipText("Description of the selected bug");
        }
        catch (SWTError e) {
            this.control = new StyledText((Composite)this.sash, 776);
            this.control.setEditable(false);
            this.control.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    DetailsView.this.updateDisplay();
                }
            });
            try {
                Class<?> presenterClass = Class.forName("org.eclipse.jdt.internal.ui.text.HTMLTextPresenter.HTMLTextPresenter");
                this.presenter = (DefaultInformationControl.IInformationPresenter)presenterClass.getConstructor(Boolean.TYPE).newInstance(new Boolean(false));
            }
            catch (Exception e2) {
                FindbugsPlugin.getDefault().logException(e2, "Could not create HTMLTextPresenter");
            }
        }
        this.sash.setWeights(new int[]{1, 4, 8});
        ISelectionService theService = this.getSite().getWorkbenchWindow().getSelectionService();
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
                if (theSelection instanceof IStructuredSelection) {
                    IMarker theMarker;
                    Object elt = ((IStructuredSelection)theSelection).getFirstElement();
                    if (elt instanceof IMarker) {
                        DetailsView.showMarker((IMarker)elt, false);
                    }
                    if (elt instanceof TreeItem && (theMarker = BugTreeView.getMarkerForTreeItem((TreeItem)elt)) != null) {
                        DetailsView.showMarker(theMarker, false);
                    }
                }
            }
        };
        theService.addSelectionListener(this.selectionListener);
        detailsView = this;
    }

    public void setFocus() {
        this.annotationList.setFocus();
    }

    public void dispose() {
        if (this.selectionListener != null) {
            this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.selectionListener);
            this.selectionListener = null;
        }
        this.sash.dispose();
        detailsView = null;
        super.dispose();
    }

    private void updateDisplay() {
        String html = "<b>" + this.title + "</b><br/>" + this.description;
        this.setHTMLText(html);
        this.priorityTypeArea.setText(this.priorityTypeString);
    }

    private void setHTMLText(String html) {
        if (this.browser != null && !this.browser.isDisposed()) {
            this.browser.setText(html);
        } else {
            StyledText control = this.control;
            if (control != null && !control.isDisposed() && this.presenter != null) {
                Rectangle size = this.control.getClientArea();
                html = this.presenter.updatePresentation(this.getSite().getShell().getDisplay(), html, this.presentation, size.width, size.height);
                control.setText(html);
                TextPresentation.applyTextPresentation((TextPresentation)this.presentation, (StyledText)control);
            }
        }
    }

    public void setContent(String title, String description, BugInstance theBug, String priorityTypeString) {
        this.title = title == null ? "" : title.trim();
        this.description = description == null ? "" : description.trim();
        this.theBug = theBug;
        this.priorityTypeString = priorityTypeString;
        this.updateDisplay();
    }

    public static void showMarker(IMarker marker, boolean focus) {
        IWorkbenchPage[] pages = FindbugsPlugin.getActiveWorkbenchWindow().getPages();
        if (pages.length > 0) {
            try {
                if (focus && !UserAnnotationsView.isVisible()) {
                    pages[0].showView("de.tobject.findbugs.view.detailsview");
                }
                if (detailsView == null) {
                    return;
                }
                String bugType = marker.getAttribute("BUGTYPE", "");
                String priorityTypeString = marker.getAttribute("PRIORITY_TYPE", "");
                DetectorFactoryCollection.instance().ensureLoaded();
                BugPattern pattern = I18N.instance().lookupBugPattern(bugType);
                BugInstance bug = MarkerUtil.findBugInstanceForMarker(marker);
                if (pattern != null) {
                    String shortDescription = pattern.getShortDescription();
                    String detailText = pattern.getDetailText();
                    if (DetailsView.getDetailsView() != null) {
                        DetailsView.getDetailsView().setContent(shortDescription, detailText, bug, priorityTypeString);
                    }
                }
                List anList = DetailsView.getDetailsView().annotationList;
                anList.removeAll();
                if (bug != null) {
                    Iterator it = bug.annotationIterator();
                    while (it.hasNext()) {
                        BugAnnotation ba = (BugAnnotation)it.next();
                        anList.add(ba.toString());
                    }
                }
            }
            catch (PartInitException e) {
                FindbugsPlugin.getDefault().logException((Exception)((Object)e), "Could not update bug details view");
            }
        }
    }

    public static DetailsView getDetailsView() {
        return detailsView;
    }

    public static void setDetailsView(DetailsView view) {
        detailsView = view;
    }
}

