/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.epic.core.parser.PerlToken;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.editors.PartitionTypes;
import org.epic.perleditor.editors.PerlEditor;
import org.epic.perleditor.editors.PerlPartitioner;
import org.epic.perleditor.editors.util.MarkerUtil;
import org.epic.perleditor.preferences.TaskTagPreferences;

public class TasksReconciler {
    private static final String EPIC_AUTOGENERATED = "epic.autogenerated";
    private final PerlEditor editor;
    private Pattern[] TODO_PATTERNS;
    private boolean allowWhiteSpace;
    private MarkerUtil markerUtil;

    public TasksReconciler(PerlEditor editor) {
        this.editor = editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcile() {
        IEditorInput input = this.editor.getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            return;
        }
        IDocumentProvider docProvider = this.editor.getDocumentProvider();
        if (docProvider == null) {
            return;
        }
        IDocument doc = docProvider.getDocument((Object)input);
        if (doc == null) {
            return;
        }
        PerlPartitioner partitioner = (PerlPartitioner)PartitionTypes.getPerlPartitioner(doc);
        if (partitioner == null) {
            return;
        }
        this.markerUtil = new MarkerUtil((IResource)((IFileEditorInput)input).getFile());
        this.markerUtil.clearAllUsedFlags("org.eclipse.core.resources.taskmarker", EPIC_AUTOGENERATED);
        IPreferenceStore store = PerlEditorPlugin.getDefault().getPreferenceStore();
        this.allowWhiteSpace = store.getBoolean("TaskTags.AllowWhiteSpace");
        this.initSearchPatterns(store);
        Object object = partitioner.getTokensLock();
        synchronized (object) {
            List tokens = partitioner.getTokens();
            Iterator i = tokens.iterator();
            while (i.hasNext()) {
                PerlToken t = (PerlToken)((Object)i.next());
                if (t.getType() != 23) continue;
                this.parseComment(t);
            }
        }
        this.markerUtil.removeUnusedMarkers("org.eclipse.core.resources.taskmarker", EPIC_AUTOGENERATED);
    }

    private void addTaskMarker(int start, int stop, int lineNumber, String text) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(11);
        attributes.put("charStart", new Integer(start));
        attributes.put("charEnd", new Integer(stop));
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("message", text);
        attributes.put(EPIC_AUTOGENERATED, new Integer(42));
        this.markerUtil.addMarker(attributes, "org.eclipse.core.resources.taskmarker");
    }

    private void initSearchPatterns(IPreferenceStore store) {
        int flags = store.getBoolean("TaskTags.IgnoreCase") ? 2 : 0;
        String taskTagList = store.getString("TaskTags.List");
        String[] TODO_STRINGS = TaskTagPreferences.parseStringList(taskTagList);
        this.TODO_PATTERNS = new Pattern[TODO_STRINGS.length];
        int i = 0;
        while (i < TODO_STRINGS.length) {
            StringBuffer buffy = new StringBuffer();
            buffy.append("#");
            if (this.allowWhiteSpace) {
                buffy.append("\\s*");
            }
            buffy.append("\\Q");
            buffy.append(TODO_STRINGS[i]);
            buffy.append("\\E");
            this.TODO_PATTERNS[i] = Pattern.compile(buffy.toString(), flags);
            ++i;
        }
    }

    private void parseComment(PerlToken t) {
        int i = 0;
        while (i < this.TODO_PATTERNS.length) {
            this.parseComment(t, this.TODO_PATTERNS[i]);
            ++i;
        }
    }

    private void parseComment(PerlToken t, Pattern todoPattern) {
        Matcher m = todoPattern.matcher(t.getText());
        if (!m.find()) {
            return;
        }
        String todoText = t.getText().substring(m.end()).trim();
        if (todoText.length() > 0 && !this.markerUtil.isMarkerPresent("org.eclipse.core.resources.taskmarker", t.getLine(), todoText, EPIC_AUTOGENERATED, true)) {
            this.addTaskMarker(t.getOffset() + m.start(), t.getOffset() + m.start() + m.group().length() + todoText.length(), t.getLine(), todoText);
        }
    }
}

