/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.util.concurrent.ThreadFactory;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.util.concurrent.CamelThreadFactory;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

public class DefaultJmsMessageListenerContainer
extends DefaultMessageListenerContainer {
    private final JmsEndpoint endpoint;

    public DefaultJmsMessageListenerContainer(JmsEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    protected boolean runningAllowed() {
        return this.endpoint.isRunning();
    }

    protected TaskExecutor createDefaultTaskExecutor() {
        String pattern = this.endpoint.getCamelContext().getExecutorServiceManager().getThreadNamePattern();
        String beanName = this.getBeanName();
        SimpleAsyncTaskExecutor answer = new SimpleAsyncTaskExecutor(beanName);
        answer.setThreadFactory((ThreadFactory)new CamelThreadFactory(pattern, beanName, true));
        return answer;
    }
}

