/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementRef;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.model.ExpressionNodeHelper;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.spi.Required;
import org.apache.camel.spi.RouteContext;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class ExpressionNode
extends ProcessorDefinition<ExpressionNode> {
    @XmlElementRef
    private ExpressionDefinition expression;
    @XmlElementRef
    private List<ProcessorDefinition<?>> outputs = new ArrayList();

    public ExpressionNode() {
    }

    public ExpressionNode(ExpressionDefinition expression) {
        this.expression = expression;
    }

    public ExpressionNode(Expression expression) {
        if (expression != null) {
            this.setExpression(ExpressionNodeHelper.toExpressionDefinition(expression));
        }
    }

    public ExpressionNode(Predicate predicate) {
        if (predicate != null) {
            this.setExpression(ExpressionNodeHelper.toExpressionDefinition(predicate));
        }
    }

    @Override
    public String getShortName() {
        return "exp";
    }

    public ExpressionDefinition getExpression() {
        return this.expression;
    }

    @Required
    public void setExpression(ExpressionDefinition expression) {
        this.expression = expression;
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        this.outputs = outputs;
    }

    @Override
    public boolean isOutputSupported() {
        return true;
    }

    @Override
    public String getLabel() {
        if (this.getExpression() == null) {
            return "";
        }
        return this.getExpression().getLabel();
    }

    protected FilterProcessor createFilterProcessor(RouteContext routeContext) throws Exception {
        Processor childProcessor = this.createChildProcessor(routeContext, false);
        return new FilterProcessor(this.createPredicate(routeContext), childProcessor);
    }

    protected Predicate createPredicate(RouteContext routeContext) {
        return this.getExpression().createPredicate(routeContext);
    }

    @Override
    protected void configureChild(ProcessorDefinition<?> output) {
        this.preCreateProcessor();
    }

    @Override
    protected void preCreateProcessor() {
        ExpressionClause clause;
        Expression exp = this.expression;
        if (this.expression != null && this.expression.getExpressionValue() != null) {
            exp = this.expression.getExpressionValue();
        }
        if (exp instanceof ExpressionClause && (clause = (ExpressionClause)exp).getExpressionType() != null) {
            this.expression = clause.getExpressionType();
        }
    }
}

