/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.apache.qpid.proton.amqp.transport.Open;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.engine.impl.DeliveryImpl;
import org.apache.qpid.proton.engine.impl.EndpointImpl;
import org.apache.qpid.proton.engine.impl.EndpointImplQuery;
import org.apache.qpid.proton.engine.impl.LinkImpl;
import org.apache.qpid.proton.engine.impl.LinkNode;
import org.apache.qpid.proton.engine.impl.SessionImpl;

public class ConnectionImpl
extends EndpointImpl
implements Connection {
    public static final int MAX_CHANNELS = 255;
    private List<SessionImpl> _sessions = new ArrayList<SessionImpl>();
    private EndpointImpl _transportTail;
    private EndpointImpl _transportHead;
    private int _maxChannels = 255;
    private LinkNode<SessionImpl> _sessionHead;
    private LinkNode<SessionImpl> _sessionTail;
    private LinkNode<LinkImpl> _linkHead;
    private LinkNode<LinkImpl> _linkTail;
    private DeliveryImpl _workHead;
    private DeliveryImpl _workTail;
    private DeliveryImpl _transportWorkHead;
    private DeliveryImpl _transportWorkTail;
    private String _localContainerId = "";
    private String _localHostname = "";
    private boolean _bound;
    private String _remoteContainer;
    private String _remoteHostname;

    public SessionImpl session() {
        SessionImpl session = new SessionImpl(this);
        this._sessions.add(session);
        return session;
    }

    protected LinkNode<SessionImpl> addSessionEndpoint(SessionImpl endpoint) {
        LinkNode<SessionImpl> node;
        if (this._sessionHead == null) {
            this._sessionTail = LinkNode.newList(endpoint);
            this._sessionHead = this._sessionTail;
            node = this._sessionTail;
        } else {
            this._sessionTail = this._sessionTail.addAtTail(endpoint);
            node = this._sessionTail;
        }
        return node;
    }

    void removeSessionEndpoint(LinkNode<SessionImpl> node) {
        LinkNode<SessionImpl> prev = node.getPrev();
        LinkNode<SessionImpl> next = node.getNext();
        if (this._sessionHead == node) {
            this._sessionHead = next;
        }
        if (this._sessionTail == node) {
            this._sessionTail = prev;
        }
        node.remove();
    }

    protected LinkNode<LinkImpl> addLinkEndpoint(LinkImpl endpoint) {
        LinkNode<LinkImpl> node;
        if (this._linkHead == null) {
            this._linkTail = LinkNode.newList(endpoint);
            this._linkHead = this._linkTail;
            node = this._linkTail;
        } else {
            this._linkTail = this._linkTail.addAtTail(endpoint);
            node = this._linkTail;
        }
        return node;
    }

    void removeLinkEndpoint(LinkNode<LinkImpl> node) {
        LinkNode<LinkImpl> prev = node.getPrev();
        LinkNode<LinkImpl> next = node.getNext();
        if (this._linkHead == node) {
            this._linkHead = next;
        }
        if (this._linkTail == node) {
            this._linkTail = prev;
        }
        node.remove();
    }

    public Session sessionHead(EnumSet<EndpointState> local, EnumSet<EndpointState> remote) {
        if (this._sessionHead == null) {
            return null;
        }
        EndpointImplQuery<SessionImpl> query = new EndpointImplQuery<SessionImpl>(local, remote);
        LinkNode<SessionImpl> node = query.matches(this._sessionHead) ? this._sessionHead : this._sessionHead.next(query);
        return node == null ? null : node.getValue();
    }

    public Link linkHead(EnumSet<EndpointState> local, EnumSet<EndpointState> remote) {
        if (this._linkHead == null) {
            return null;
        }
        EndpointImplQuery<LinkImpl> query = new EndpointImplQuery<LinkImpl>(local, remote);
        LinkNode<LinkImpl> node = query.matches(this._linkHead) ? this._linkHead : this._linkHead.next(query);
        return node == null ? null : node.getValue();
    }

    @Override
    protected ConnectionImpl getConnectionImpl() {
        return this;
    }

    @Override
    public void free() {
        super.free();
        for (Session session : this._sessions) {
            session.free();
        }
        this._sessions = null;
    }

    public void handleOpen(Open open) {
        this.setRemoteState(EndpointState.ACTIVE);
        this.setRemoteHostname(open.getHostname());
        this.setRemoteContainer(open.getContainerId());
    }

    EndpointImpl getTransportHead() {
        return this._transportHead;
    }

    EndpointImpl getTransportTail() {
        return this._transportTail;
    }

    void addModified(EndpointImpl endpoint) {
        if (this._transportTail == null) {
            endpoint.setTransportNext(null);
            endpoint.setTransportPrev(null);
            this._transportHead = this._transportTail = endpoint;
        } else {
            this._transportTail.setTransportNext(endpoint);
            endpoint.setTransportPrev(this._transportTail);
            this._transportTail = endpoint;
            this._transportTail.setTransportNext(null);
        }
    }

    void removeModified(EndpointImpl endpoint) {
        if (this._transportHead == endpoint) {
            this._transportHead = endpoint.transportNext();
        } else {
            endpoint.transportPrev().setTransportNext(endpoint.transportNext());
        }
        if (this._transportTail == endpoint) {
            this._transportTail = endpoint.transportPrev();
        } else {
            endpoint.transportNext().setTransportPrev(endpoint.transportPrev());
        }
    }

    public int getMaxChannels() {
        return this._maxChannels;
    }

    public String getLocalContainerId() {
        return this._localContainerId;
    }

    public void setLocalContainerId(String localContainerId) {
        this._localContainerId = localContainerId;
    }

    public DeliveryImpl getWorkHead() {
        return this._workHead;
    }

    public void setContainer(String container) {
        this._localContainerId = container;
    }

    public void setHostname(String hostname) {
        this._localHostname = hostname;
    }

    public String getRemoteContainer() {
        return this._remoteContainer;
    }

    public String getRemoteHostname() {
        return this._remoteHostname;
    }

    public String getHostname() {
        return this._localHostname;
    }

    void setRemoteContainer(String remoteContainerId) {
        this._remoteContainer = remoteContainerId;
    }

    void setRemoteHostname(String remoteHostname) {
        this._remoteHostname = remoteHostname;
    }

    DeliveryImpl getWorkTail() {
        return this._workTail;
    }

    void removeWork(DeliveryImpl delivery) {
        if (this._workHead == delivery) {
            this._workHead = delivery.getWorkNext();
        }
        if (this._workTail == delivery) {
            this._workTail = delivery.getWorkPrev();
        }
    }

    void addWork(DeliveryImpl delivery) {
        if (this._workHead != delivery && delivery.getWorkNext() == null && delivery.getWorkPrev() == null) {
            if (this._workTail == null) {
                delivery.setWorkNext(null);
                delivery.setWorkPrev(null);
                this._workHead = this._workTail = delivery;
            } else {
                this._workTail.setWorkNext(delivery);
                delivery.setWorkPrev(this._workTail);
                this._workTail = delivery;
                delivery.setWorkNext(null);
            }
        }
    }

    public Iterator<DeliveryImpl> getWorkSequence() {
        return new WorkSequence(this._workHead);
    }

    public void setBound(boolean bound) {
        this._bound = true;
    }

    public boolean isBound() {
        return this._bound;
    }

    DeliveryImpl getTransportWorkHead() {
        return this._transportWorkHead;
    }

    public void removeTransportWork(DeliveryImpl delivery) {
        DeliveryImpl oldHead = this._transportWorkHead;
        DeliveryImpl oldTail = this._transportWorkTail;
        if (this._transportWorkHead == delivery) {
            this._transportWorkHead = delivery.getTransportWorkNext();
        }
        if (this._transportWorkTail == delivery) {
            this._transportWorkTail = delivery.getTransportWorkPrev();
        }
    }

    void addTransportWork(DeliveryImpl delivery) {
        if (this._transportWorkTail == null) {
            delivery.setTransportWorkNext(null);
            delivery.setTransportWorkPrev(null);
            this._transportWorkHead = this._transportWorkTail = delivery;
        } else {
            this._transportWorkTail.setTransportWorkNext(delivery);
            delivery.setTransportWorkPrev(this._transportWorkTail);
            this._transportWorkTail = delivery;
            delivery.setTransportWorkNext(null);
        }
    }

    void workUpdate(DeliveryImpl delivery) {
        if (delivery != null) {
            LinkImpl link = delivery.getLink();
            if (link.workUpdate(delivery)) {
                this.addWork(delivery);
            } else {
                delivery.clearWork();
            }
        }
    }

    private class WorkSequence
    implements Iterator<DeliveryImpl> {
        private DeliveryImpl _next;

        public WorkSequence(DeliveryImpl workHead) {
            this._next = workHead;
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DeliveryImpl next() {
            DeliveryImpl next = this._next;
            if (next != null) {
                this._next = next.getWorkNext();
            }
            return next;
        }
    }
}

