/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.console.filter.QueryFilter;

public class PropertiesViewFilter
implements QueryFilter {
    protected QueryFilter next;
    protected Set viewFilter;

    public PropertiesViewFilter(QueryFilter next) {
        this(null, next);
    }

    public PropertiesViewFilter(Set viewFilter, QueryFilter next) {
        this.next = next;
        this.viewFilter = viewFilter;
    }

    @Override
    public List<Map<Object, Object>> query(String query) throws Exception {
        return this.filterViewCollection(this.next.query(query), this.viewFilter);
    }

    @Override
    public List<Map<Object, Object>> query(List queries) throws Exception {
        return this.filterViewCollection(this.next.query(queries), this.viewFilter);
    }

    protected List<Map<Object, Object>> filterViewCollection(Collection<Map<Object, Object>> result, Set viewFilter) {
        ArrayList<Map<Object, Object>> newCollection = new ArrayList<Map<Object, Object>>();
        Iterator<Map<Object, Object>> i = result.iterator();
        while (i.hasNext()) {
            newCollection.add(this.filterView(i.next()));
        }
        return newCollection;
    }

    protected Map<Object, Object> filterView(Map<Object, Object> data) {
        HashMap<Object, Object> newData;
        if (this.viewFilter == null || this.viewFilter.isEmpty()) {
            return data;
        }
        try {
            newData = (HashMap<Object, Object>)data.getClass().newInstance();
        }
        catch (Exception e) {
            newData = new HashMap<Object, Object>();
        }
        for (Object key : this.viewFilter) {
            Object val = data.get(key);
            if (val == null) continue;
            newData.put(key, val);
        }
        return newData;
    }
}

