/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.websocket.WebSocketFactory;

public abstract class WebSocketHandler
extends HandlerWrapper
implements WebSocketFactory.Acceptor {
    private final WebSocketFactory _webSocketFactory = new WebSocketFactory(this, 32768);

    public WebSocketFactory getWebSocketFactory() {
        return this._webSocketFactory;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this._webSocketFactory.acceptWebSocket(request, response) || response.isCommitted()) {
            baseRequest.setHandled(true);
            return;
        }
        super.handle(target, baseRequest, request, response);
    }

    public boolean checkOrigin(HttpServletRequest request, String origin) {
        return true;
    }
}

