/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class AsyncHttpConnection
extends AbstractHttpConnection
implements AsyncConnection {
    private static final int NO_PROGRESS_INFO = Integer.getInteger("org.mortbay.jetty.NO_PROGRESS_INFO", 100);
    private static final int NO_PROGRESS_CLOSE = Integer.getInteger("org.mortbay.jetty.NO_PROGRESS_CLOSE", 200);
    private static final Logger LOG = Log.getLogger(AsyncHttpConnection.class);
    private int _total_no_progress;
    private final AsyncEndPoint _asyncEndp;
    private boolean _readInterested = true;

    public AsyncHttpConnection(Connector connector, EndPoint endpoint, Server server) {
        super(connector, endpoint, server);
        this._asyncEndp = (AsyncEndPoint)endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection handle() throws IOException {
        Connection connection = this;
        boolean some_progress = false;
        boolean progress = true;
        try {
            AsyncHttpConnection.setCurrentConnection(this);
            this._asyncEndp.setCheckForIdle(false);
            while (progress && connection == this) {
                boolean bl;
                Connection switched;
                boolean complete;
                boolean generatorComplete;
                boolean parserComplete;
                Object var6_5;
                progress = false;
                try {
                    block34: {
                        try {
                            if (this._request._async.isAsync()) {
                                if (this._request._async.isDispatchable()) {
                                    this.handleRequest();
                                }
                            } else if (!this._parser.isComplete() && this._parser.parseAvailable()) {
                                progress = true;
                            }
                            if (this._generator.isCommitted() && !this._generator.isComplete() && !this._endp.isOutputShutdown() && !this._request.getAsyncContinuation().isAsyncStarted() && this._generator.flushBuffer() > 0) {
                                progress = true;
                            }
                            this._endp.flush();
                            if (!this._asyncEndp.hasProgressed()) break block34;
                            progress = true;
                        }
                        catch (HttpException e) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("uri=" + this._uri, new Object[0]);
                                LOG.debug("fields=" + this._requestFields, new Object[0]);
                                LOG.debug(e);
                            }
                            progress = true;
                            this._generator.sendError(e.getStatus(), e.getReason(), null, true);
                            var6_5 = null;
                            some_progress |= progress;
                            parserComplete = this._parser.isComplete();
                            generatorComplete = this._generator.isComplete();
                            boolean bl2 = complete = parserComplete && generatorComplete;
                            if (parserComplete) {
                                if (generatorComplete) {
                                    progress = true;
                                    if (this._response.getStatus() == 101 && (switched = (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection")) != null) {
                                        connection = switched;
                                    }
                                    this.reset();
                                    if (!this._generator.isPersistent() && !this._endp.isOutputShutdown()) {
                                        LOG.warn("Safety net oshut!!!  IF YOU SEE THIS, PLEASE RAISE BUGZILLA", new Object[0]);
                                        this._endp.shutdownOutput();
                                    }
                                } else {
                                    this._readInterested = false;
                                    LOG.debug("Disabled read interest while writing response {}", this._endp);
                                }
                            }
                            if (complete || !this._request.getAsyncContinuation().isAsyncStarted()) continue;
                            LOG.debug("suspended {}", this);
                            progress = false;
                            continue;
                        }
                    }
                    var6_5 = null;
                    some_progress |= progress;
                    parserComplete = this._parser.isComplete();
                    generatorComplete = this._generator.isComplete();
                    bl = parserComplete && generatorComplete;
                }
                catch (Throwable throwable) {
                    var6_5 = null;
                    some_progress |= progress;
                    parserComplete = this._parser.isComplete();
                    generatorComplete = this._generator.isComplete();
                    boolean bl3 = complete = parserComplete && generatorComplete;
                    if (parserComplete) {
                        if (generatorComplete) {
                            progress = true;
                            if (this._response.getStatus() == 101 && (switched = (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection")) != null) {
                                connection = switched;
                            }
                            this.reset();
                            if (!this._generator.isPersistent() && !this._endp.isOutputShutdown()) {
                                LOG.warn("Safety net oshut!!!  IF YOU SEE THIS, PLEASE RAISE BUGZILLA", new Object[0]);
                                this._endp.shutdownOutput();
                            }
                        } else {
                            this._readInterested = false;
                            LOG.debug("Disabled read interest while writing response {}", this._endp);
                        }
                    }
                    if (complete) throw throwable;
                    if (!this._request.getAsyncContinuation().isAsyncStarted()) throw throwable;
                    LOG.debug("suspended {}", this);
                    progress = false;
                    throw throwable;
                }
                complete = bl;
                if (parserComplete) {
                    if (generatorComplete) {
                        progress = true;
                        if (this._response.getStatus() == 101 && (switched = (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection")) != null) {
                            connection = switched;
                        }
                        this.reset();
                        if (!this._generator.isPersistent() && !this._endp.isOutputShutdown()) {
                            LOG.warn("Safety net oshut!!!  IF YOU SEE THIS, PLEASE RAISE BUGZILLA", new Object[0]);
                            this._endp.shutdownOutput();
                        }
                    } else {
                        this._readInterested = false;
                        LOG.debug("Disabled read interest while writing response {}", this._endp);
                    }
                }
                if (complete || !this._request.getAsyncContinuation().isAsyncStarted()) continue;
                LOG.debug("suspended {}", this);
                progress = false;
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            AsyncHttpConnection.setCurrentConnection(null);
            if (!this._request.getAsyncContinuation().isAsyncStarted()) {
                this._parser.returnBuffers();
                this._generator.returnBuffers();
                this._asyncEndp.setCheckForIdle(true);
            }
            if (some_progress) {
                this._total_no_progress = 0;
                throw throwable;
            }
            ++this._total_no_progress;
            if (NO_PROGRESS_INFO > 0 && this._total_no_progress % NO_PROGRESS_INFO == 0 && (NO_PROGRESS_CLOSE <= 0 || this._total_no_progress < NO_PROGRESS_CLOSE)) {
                LOG.info("EndPoint making no progress: " + this._total_no_progress + " " + this._endp + " " + this, new Object[0]);
            }
            if (NO_PROGRESS_CLOSE <= 0) throw throwable;
            if (this._total_no_progress != NO_PROGRESS_CLOSE) throw throwable;
            LOG.warn("Closing EndPoint making no progress: " + this._total_no_progress + " " + this._endp + " " + this, new Object[0]);
            if (!(this._endp instanceof SelectChannelEndPoint)) throw throwable;
            ((SelectChannelEndPoint)this._endp).getChannel().close();
            throw throwable;
        }
        AsyncHttpConnection.setCurrentConnection(null);
        if (!this._request.getAsyncContinuation().isAsyncStarted()) {
            this._parser.returnBuffers();
            this._generator.returnBuffers();
            this._asyncEndp.setCheckForIdle(true);
        }
        if (some_progress) {
            this._total_no_progress = 0;
            return connection;
        }
        ++this._total_no_progress;
        if (NO_PROGRESS_INFO > 0 && this._total_no_progress % NO_PROGRESS_INFO == 0 && (NO_PROGRESS_CLOSE <= 0 || this._total_no_progress < NO_PROGRESS_CLOSE)) {
            LOG.info("EndPoint making no progress: " + this._total_no_progress + " " + this._endp + " " + this, new Object[0]);
        }
        if (NO_PROGRESS_CLOSE <= 0) return connection;
        if (this._total_no_progress != NO_PROGRESS_CLOSE) return connection;
        LOG.warn("Closing EndPoint making no progress: " + this._total_no_progress + " " + this._endp + " " + this, new Object[0]);
        if (!(this._endp instanceof SelectChannelEndPoint)) return connection;
        ((SelectChannelEndPoint)this._endp).getChannel().close();
        return connection;
    }

    public void onInputShutdown() throws IOException {
        if (this._generator.isIdle() && !this._request.getAsyncContinuation().isSuspended()) {
            this._endp.close();
        }
        if (this._parser.isIdle()) {
            this._parser.setPersistent(false);
        }
    }

    public void reset() {
        this._readInterested = true;
        LOG.debug("Enabled read interest {}", this._endp);
        super.reset();
    }

    public boolean isSuspended() {
        return !this._readInterested || super.isSuspended();
    }
}

