require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_IXGBE_TYPE_H_)) {
    eval 'sub _IXGBE_TYPE_H_ () {1;}' unless defined(&_IXGBE_TYPE_H_);
    eval 'sub IXGBE_INTEL_VENDOR_ID () {0x8086;}' unless defined(&IXGBE_INTEL_VENDOR_ID);
    eval 'sub IXGBE_DEV_ID_82598 () {0x10b6;}' unless defined(&IXGBE_DEV_ID_82598);
    eval 'sub IXGBE_DEV_ID_82598_BX () {0x1508;}' unless defined(&IXGBE_DEV_ID_82598_BX);
    eval 'sub IXGBE_DEV_ID_82598AF_DUAL_PORT () {0x10c6;}' unless defined(&IXGBE_DEV_ID_82598AF_DUAL_PORT);
    eval 'sub IXGBE_DEV_ID_82598AF_SINGLE_PORT () {0x10c7;}' unless defined(&IXGBE_DEV_ID_82598AF_SINGLE_PORT);
    eval 'sub IXGBE_DEV_ID_82598AT () {0x10c8;}' unless defined(&IXGBE_DEV_ID_82598AT);
    eval 'sub IXGBE_DEV_ID_82598AT2 () {0x150b;}' unless defined(&IXGBE_DEV_ID_82598AT2);
    eval 'sub IXGBE_DEV_ID_82598EB_SFP_LOM () {0x10db;}' unless defined(&IXGBE_DEV_ID_82598EB_SFP_LOM);
    eval 'sub IXGBE_DEV_ID_82598EB_CX4 () {0x10dd;}' unless defined(&IXGBE_DEV_ID_82598EB_CX4);
    eval 'sub IXGBE_DEV_ID_82598_CX4_DUAL_PORT () {0x10ec;}' unless defined(&IXGBE_DEV_ID_82598_CX4_DUAL_PORT);
    eval 'sub IXGBE_DEV_ID_82598_DA_DUAL_PORT () {0x10f1;}' unless defined(&IXGBE_DEV_ID_82598_DA_DUAL_PORT);
    eval 'sub IXGBE_DEV_ID_82598_SR_DUAL_PORT_EM () {0x10e1;}' unless defined(&IXGBE_DEV_ID_82598_SR_DUAL_PORT_EM);
    eval 'sub IXGBE_DEV_ID_82598EB_XF_LR () {0x10f4;}' unless defined(&IXGBE_DEV_ID_82598EB_XF_LR);
    eval 'sub IXGBE_DEV_ID_82599_KX4 () {0x10f7;}' unless defined(&IXGBE_DEV_ID_82599_KX4);
    eval 'sub IXGBE_DEV_ID_82599_KX4_MEZZ () {0x1514;}' unless defined(&IXGBE_DEV_ID_82599_KX4_MEZZ);
    eval 'sub IXGBE_DEV_ID_82599_KR () {0x1517;}' unless defined(&IXGBE_DEV_ID_82599_KR);
    eval 'sub IXGBE_DEV_ID_82599_COMBO_BACKPLANE () {0x10f8;}' unless defined(&IXGBE_DEV_ID_82599_COMBO_BACKPLANE);
    eval 'sub IXGBE_SUBDEV_ID_82599_KX4_KR_MEZZ () {0xc;}' unless defined(&IXGBE_SUBDEV_ID_82599_KX4_KR_MEZZ);
    eval 'sub IXGBE_DEV_ID_82599_CX4 () {0x10f9;}' unless defined(&IXGBE_DEV_ID_82599_CX4);
    eval 'sub IXGBE_DEV_ID_82599_SFP () {0x10fb;}' unless defined(&IXGBE_DEV_ID_82599_SFP);
    eval 'sub IXGBE_SUBDEV_ID_82599_SFP () {0x11a9;}' unless defined(&IXGBE_SUBDEV_ID_82599_SFP);
    eval 'sub IXGBE_SUBDEV_ID_82599_560FLR () {0x17d0;}' unless defined(&IXGBE_SUBDEV_ID_82599_560FLR);
    eval 'sub IXGBE_DEV_ID_82599_BACKPLANE_FCOE () {0x152a;}' unless defined(&IXGBE_DEV_ID_82599_BACKPLANE_FCOE);
    eval 'sub IXGBE_DEV_ID_82599_SFP_FCOE () {0x1529;}' unless defined(&IXGBE_DEV_ID_82599_SFP_FCOE);
    eval 'sub IXGBE_DEV_ID_82599_SFP_EM () {0x1507;}' unless defined(&IXGBE_DEV_ID_82599_SFP_EM);
    eval 'sub IXGBE_DEV_ID_82599_SFP_SF2 () {0x154d;}' unless defined(&IXGBE_DEV_ID_82599_SFP_SF2);
    eval 'sub IXGBE_DEV_ID_82599EN_SFP () {0x1557;}' unless defined(&IXGBE_DEV_ID_82599EN_SFP);
    eval 'sub IXGBE_DEV_ID_82599_XAUI_LOM () {0x10fc;}' unless defined(&IXGBE_DEV_ID_82599_XAUI_LOM);
    eval 'sub IXGBE_DEV_ID_82599_T3_LOM () {0x151c;}' unless defined(&IXGBE_DEV_ID_82599_T3_LOM);
    eval 'sub IXGBE_DEV_ID_82599_VF () {0x10ed;}' unless defined(&IXGBE_DEV_ID_82599_VF);
    eval 'sub IXGBE_DEV_ID_X540_VF () {0x1515;}' unless defined(&IXGBE_DEV_ID_X540_VF);
    eval 'sub IXGBE_DEV_ID_X540T () {0x1528;}' unless defined(&IXGBE_DEV_ID_X540T);
    eval 'sub IXGBE_DEV_ID_X540T1 () {0x1560;}' unless defined(&IXGBE_DEV_ID_X540T1);
    eval 'sub IXGBE_CTRL () {0x;}' unless defined(&IXGBE_CTRL);
    eval 'sub IXGBE_STATUS () {0x8;}' unless defined(&IXGBE_STATUS);
    eval 'sub IXGBE_CTRL_EXT () {0x18;}' unless defined(&IXGBE_CTRL_EXT);
    eval 'sub IXGBE_ESDP () {0x20;}' unless defined(&IXGBE_ESDP);
    eval 'sub IXGBE_EODSDP () {0x28;}' unless defined(&IXGBE_EODSDP);
    eval 'sub IXGBE_I2CCTL () {0x28;}' unless defined(&IXGBE_I2CCTL);
    eval 'sub IXGBE_LEDCTL () {0x200;}' unless defined(&IXGBE_LEDCTL);
    eval 'sub IXGBE_FRTIMER () {0x48;}' unless defined(&IXGBE_FRTIMER);
    eval 'sub IXGBE_TCPTIMER () {0x4c;}' unless defined(&IXGBE_TCPTIMER);
    eval 'sub IXGBE_CORESPARE () {0x600;}' unless defined(&IXGBE_CORESPARE);
    eval 'sub IXGBE_EXVET () {0x5078;}' unless defined(&IXGBE_EXVET);
    eval 'sub IXGBE_EEC () {0x10010;}' unless defined(&IXGBE_EEC);
    eval 'sub IXGBE_EERD () {0x10014;}' unless defined(&IXGBE_EERD);
    eval 'sub IXGBE_EEWR () {0x10018;}' unless defined(&IXGBE_EEWR);
    eval 'sub IXGBE_FLA () {0x1001c;}' unless defined(&IXGBE_FLA);
    eval 'sub IXGBE_EEMNGCTL () {0x10110;}' unless defined(&IXGBE_EEMNGCTL);
    eval 'sub IXGBE_EEMNGDATA () {0x10114;}' unless defined(&IXGBE_EEMNGDATA);
    eval 'sub IXGBE_FLMNGCTL () {0x10118;}' unless defined(&IXGBE_FLMNGCTL);
    eval 'sub IXGBE_FLMNGDATA () {0x1011c;}' unless defined(&IXGBE_FLMNGDATA);
    eval 'sub IXGBE_FLMNGCNT () {0x10120;}' unless defined(&IXGBE_FLMNGCNT);
    eval 'sub IXGBE_FLOP () {0x1013c;}' unless defined(&IXGBE_FLOP);
    eval 'sub IXGBE_GRC () {0x10200;}' unless defined(&IXGBE_GRC);
    eval 'sub IXGBE_GRC_MNG () {0x1;}' unless defined(&IXGBE_GRC_MNG);
    eval 'sub IXGBE_GRC_APME () {0x2;}' unless defined(&IXGBE_GRC_APME);
    eval 'sub IXGBE_VPDDIAG0 () {0x10204;}' unless defined(&IXGBE_VPDDIAG0);
    eval 'sub IXGBE_VPDDIAG1 () {0x10208;}' unless defined(&IXGBE_VPDDIAG1);
    eval 'sub IXGBE_I2C_CLK_IN () {0x1;}' unless defined(&IXGBE_I2C_CLK_IN);
    eval 'sub IXGBE_I2C_CLK_OUT () {0x2;}' unless defined(&IXGBE_I2C_CLK_OUT);
    eval 'sub IXGBE_I2C_DATA_IN () {0x4;}' unless defined(&IXGBE_I2C_DATA_IN);
    eval 'sub IXGBE_I2C_DATA_OUT () {0x8;}' unless defined(&IXGBE_I2C_DATA_OUT);
    eval 'sub IXGBE_I2C_CLOCK_STRETCHING_TIMEOUT () {500;}' unless defined(&IXGBE_I2C_CLOCK_STRETCHING_TIMEOUT);
    eval 'sub IXGBE_EICR () {0x800;}' unless defined(&IXGBE_EICR);
    eval 'sub IXGBE_EICS () {0x808;}' unless defined(&IXGBE_EICS);
    eval 'sub IXGBE_EIMS () {0x880;}' unless defined(&IXGBE_EIMS);
    eval 'sub IXGBE_EIMC () {0x888;}' unless defined(&IXGBE_EIMC);
    eval 'sub IXGBE_EIAC () {0x810;}' unless defined(&IXGBE_EIAC);
    eval 'sub IXGBE_EIAM () {0x890;}' unless defined(&IXGBE_EIAM);
    eval 'sub IXGBE_EICS_EX {
        my($_i) = @_;
	    eval q((0xa90 + ($_i) * 4));
    }' unless defined(&IXGBE_EICS_EX);
    eval 'sub IXGBE_EIMS_EX {
        my($_i) = @_;
	    eval q((0xaa0 + ($_i) * 4));
    }' unless defined(&IXGBE_EIMS_EX);
    eval 'sub IXGBE_EIMC_EX {
        my($_i) = @_;
	    eval q((0xab0 + ($_i) * 4));
    }' unless defined(&IXGBE_EIMC_EX);
    eval 'sub IXGBE_EIAM_EX {
        my($_i) = @_;
	    eval q((0xad0 + ($_i) * 4));
    }' unless defined(&IXGBE_EIAM_EX);
    eval 'sub IXGBE_MAX_INT_RATE () {488281;}' unless defined(&IXGBE_MAX_INT_RATE);
    eval 'sub IXGBE_MIN_INT_RATE () {956;}' unless defined(&IXGBE_MIN_INT_RATE);
    eval 'sub IXGBE_MAX_EITR () {0xff8;}' unless defined(&IXGBE_MAX_EITR);
    eval 'sub IXGBE_MIN_EITR () {8;}' unless defined(&IXGBE_MIN_EITR);
    eval 'sub IXGBE_EITR {
        my($_i) = @_;
	    eval q(((($_i) <= 23) ? (0x820 + (($_i) * 4)) : (0x12300 + ((($_i) - 24) * 4))));
    }' unless defined(&IXGBE_EITR);
    eval 'sub IXGBE_EITR_ITR_INT_MASK () {0xff8;}' unless defined(&IXGBE_EITR_ITR_INT_MASK);
    eval 'sub IXGBE_EITR_LLI_MOD () {0x8000;}' unless defined(&IXGBE_EITR_LLI_MOD);
    eval 'sub IXGBE_EITR_CNT_WDIS () {0x80000000;}' unless defined(&IXGBE_EITR_CNT_WDIS);
    eval 'sub IXGBE_IVAR {
        my($_i) = @_;
	    eval q((0x900 + (($_i) * 4)));
    }' unless defined(&IXGBE_IVAR);
    eval 'sub IXGBE_IVAR_MISC () {0xa00;}' unless defined(&IXGBE_IVAR_MISC);
    eval 'sub IXGBE_EITRSEL () {0x894;}' unless defined(&IXGBE_EITRSEL);
    eval 'sub IXGBE_MSIXT () {0x;}' unless defined(&IXGBE_MSIXT);
    eval 'sub IXGBE_MSIXPBA () {0x2000;}' unless defined(&IXGBE_MSIXPBA);
    eval 'sub IXGBE_PBACL {
        my($_i) = @_;
	    eval q(((($_i) == 0) ? (0x11068) : (0x110c0 + (($_i) * 4))));
    }' unless defined(&IXGBE_PBACL);
    eval 'sub IXGBE_GPIE () {0x898;}' unless defined(&IXGBE_GPIE);
    eval 'sub IXGBE_FCADBUL () {0x3210;}' unless defined(&IXGBE_FCADBUL);
    eval 'sub IXGBE_FCADBUH () {0x3214;}' unless defined(&IXGBE_FCADBUH);
    eval 'sub IXGBE_FCAMACL () {0x4328;}' unless defined(&IXGBE_FCAMACL);
    eval 'sub IXGBE_FCAMACH () {0x432c;}' unless defined(&IXGBE_FCAMACH);
    eval 'sub IXGBE_FCRTH_82599 {
        my($_i) = @_;
	    eval q((0x3260 + (($_i) * 4)));
    }' unless defined(&IXGBE_FCRTH_82599);
    eval 'sub IXGBE_FCRTL_82599 {
        my($_i) = @_;
	    eval q((0x3220 + (($_i) * 4)));
    }' unless defined(&IXGBE_FCRTL_82599);
    eval 'sub IXGBE_PFCTOP () {0x3008;}' unless defined(&IXGBE_PFCTOP);
    eval 'sub IXGBE_FCTTV {
        my($_i) = @_;
	    eval q((0x3200 + (($_i) * 4)));
    }' unless defined(&IXGBE_FCTTV);
    eval 'sub IXGBE_FCRTL {
        my($_i) = @_;
	    eval q((0x3220 + (($_i) * 8)));
    }' unless defined(&IXGBE_FCRTL);
    eval 'sub IXGBE_FCRTH {
        my($_i) = @_;
	    eval q((0x3260 + (($_i) * 8)));
    }' unless defined(&IXGBE_FCRTH);
    eval 'sub IXGBE_FCRTV () {0x32a0;}' unless defined(&IXGBE_FCRTV);
    eval 'sub IXGBE_FCCFG () {0x3d00;}' unless defined(&IXGBE_FCCFG);
    eval 'sub IXGBE_TFCS () {0xce00;}' unless defined(&IXGBE_TFCS);
    eval 'sub IXGBE_RDBAL {
        my($_i) = @_;
	    eval q(((($_i) < 64) ? (0x1000 + (($_i) * 0x40)) : (0xd000 + ((($_i) - 64) * 0x40))));
    }' unless defined(&IXGBE_RDBAL);
    eval 'sub IXGBE_RDBAH {
        my($_i) = @_;
	    eval q(((($_i) < 64) ? (0x1004 + (($_i) * 0x40)) : (0xd004 + ((($_i) - 64) * 0x40))));
    }' unless defined(&IXGBE_RDBAH);
    eval 'sub IXGBE_RDLEN {
        my($_i) = @_;
	    eval q(((($_i) < 64) ? (0x1008 + (($_i) * 0x40)) : (0xd008 + ((($_i) - 64) * 0x40))));
    }' unless defined(&IXGBE_RDLEN);
    eval 'sub IXGBE_RDH {
        my($_i) = @_;
	    eval q(((($_i) < 64) ? (0x1010 + (($_i) * 0x40)) : (0xd010 + ((($_i) - 64) * 0x40))));
    }' unless defined(&IXGBE_RDH);
    eval 'sub IXGBE_RDT {
        my($_i) = @_;
	    eval q(((($_i) < 64) ? (0x1018 + (($_i) * 0x40)) : (0xd018 + ((($_i) - 64) * 0x40))));
    }' unless defined(&IXGBE_RDT);
    eval 'sub IXGBE_RXDCTL {
        my($_i) = @_;
	    eval q(((($_i) < 64) ? (0x1028 + (($_i) * 0x40)) : (0xd028 + ((($_i) - 64) * 0x40))));
    }' unless defined(&IXGBE_RXDCTL);
    eval 'sub IXGBE_RSCCTL {
        my($_i) = @_;
	    eval q(((($_i) < 64) ? (0x102c + (($_i) * 0x40)) : (0xd02c + ((($_i) - 64) * 0x40))));
    }' unless defined(&IXGBE_RSCCTL);
    eval 'sub IXGBE_RSCDBU () {0x3028;}' unless defined(&IXGBE_RSCDBU);
    eval 'sub IXGBE_RDDCC () {0x2f20;}' unless defined(&IXGBE_RDDCC);
    eval 'sub IXGBE_RXMEMWRAP () {0x3190;}' unless defined(&IXGBE_RXMEMWRAP);
    eval 'sub IXGBE_STARCTRL () {0x3024;}' unless defined(&IXGBE_STARCTRL);
    eval 'sub IXGBE_SRRCTL {
        my($_i) = @_;
	    eval q(((($_i) <= 15) ? (0x2100 + (($_i) * 4)) : ((($_i) < 64) ? (0x1014 + (($_i) * 0x40)) : (0xd014 + ((($_i) - 64) * 0x40)))));
    }' unless defined(&IXGBE_SRRCTL);
    eval 'sub IXGBE_DCA_RXCTRL {
        my($_i) = @_;
	    eval q(((($_i) <= 15) ? (0x2200 + (($_i) * 4)) : ((($_i) < 64) ? (0x100c + (($_i) * 0x40)) : (0xd00c + ((($_i) - 64) * 0x40)))));
    }' unless defined(&IXGBE_DCA_RXCTRL);
    eval 'sub IXGBE_RDRXCTL () {0x2f00;}' unless defined(&IXGBE_RDRXCTL);
    eval 'sub IXGBE_RDRXCTL_RSC_PUSH () {0x80;}' unless defined(&IXGBE_RDRXCTL_RSC_PUSH);
    eval 'sub IXGBE_RXPBSIZE {
        my($_i) = @_;
	    eval q((0x3c00 + (($_i) * 4)));
    }' unless defined(&IXGBE_RXPBSIZE);
    eval 'sub IXGBE_RXCTRL () {0x3000;}' unless defined(&IXGBE_RXCTRL);
    eval 'sub IXGBE_DROPEN () {0x3d04;}' unless defined(&IXGBE_DROPEN);
    eval 'sub IXGBE_RXPBSIZE_SHIFT () {10;}' unless defined(&IXGBE_RXPBSIZE_SHIFT);
    eval 'sub IXGBE_RXCSUM () {0x5000;}' unless defined(&IXGBE_RXCSUM);
    eval 'sub IXGBE_RFCTL () {0x5008;}' unless defined(&IXGBE_RFCTL);
    eval 'sub IXGBE_DRECCCTL () {0x2f08;}' unless defined(&IXGBE_DRECCCTL);
    eval 'sub IXGBE_DRECCCTL_DISABLE () {0;}' unless defined(&IXGBE_DRECCCTL_DISABLE);
    eval 'sub IXGBE_MTA {
        my($_i) = @_;
	    eval q((0x5200 + (($_i) * 4)));
    }' unless defined(&IXGBE_MTA);
    eval 'sub IXGBE_RAL {
        my($_i) = @_;
	    eval q(((($_i) <= 15) ? (0x5400 + (($_i) * 8)) : (0xa200 + (($_i) * 8))));
    }' unless defined(&IXGBE_RAL);
    eval 'sub IXGBE_RAH {
        my($_i) = @_;
	    eval q(((($_i) <= 15) ? (0x5404 + (($_i) * 8)) : (0xa204 + (($_i) * 8))));
    }' unless defined(&IXGBE_RAH);
    eval 'sub IXGBE_MPSAR_LO {
        my($_i) = @_;
	    eval q((0xa600 + (($_i) * 8)));
    }' unless defined(&IXGBE_MPSAR_LO);
    eval 'sub IXGBE_MPSAR_HI {
        my($_i) = @_;
	    eval q((0xa604 + (($_i) * 8)));
    }' unless defined(&IXGBE_MPSAR_HI);
    eval 'sub IXGBE_PSRTYPE {
        my($_i) = @_;
	    eval q(((($_i) <= 15) ? (0x5480 + (($_i) * 4)) : (0xea00 + (($_i) * 4))));
    }' unless defined(&IXGBE_PSRTYPE);
    eval 'sub IXGBE_VFTA {
        my($_i) = @_;
	    eval q((0xa000 + (($_i) * 4)));
    }' unless defined(&IXGBE_VFTA);
    eval 'sub IXGBE_VFTAVIND {
        my($_j, $_i) = @_;
	    eval q((0xa200 + (($_j) * 0x200) + (($_i) * 4)));
    }' unless defined(&IXGBE_VFTAVIND);
    eval 'sub IXGBE_FCTRL () {0x5080;}' unless defined(&IXGBE_FCTRL);
    eval 'sub IXGBE_VLNCTRL () {0x5088;}' unless defined(&IXGBE_VLNCTRL);
    eval 'sub IXGBE_MCSTCTRL () {0x5090;}' unless defined(&IXGBE_MCSTCTRL);
    eval 'sub IXGBE_MRQC () {0x5818;}' unless defined(&IXGBE_MRQC);
    eval 'sub IXGBE_SAQF {
        my($_i) = @_;
	    eval q((0xe000 + (($_i) * 4)));
    }' unless defined(&IXGBE_SAQF);
    eval 'sub IXGBE_DAQF {
        my($_i) = @_;
	    eval q((0xe200 + (($_i) * 4)));
    }' unless defined(&IXGBE_DAQF);
    eval 'sub IXGBE_SDPQF {
        my($_i) = @_;
	    eval q((0xe400 + (($_i) * 4)));
    }' unless defined(&IXGBE_SDPQF);
    eval 'sub IXGBE_FTQF {
        my($_i) = @_;
	    eval q((0xe600 + (($_i) * 4)));
    }' unless defined(&IXGBE_FTQF);
    eval 'sub IXGBE_ETQF {
        my($_i) = @_;
	    eval q((0x5128 + (($_i) * 4)));
    }' unless defined(&IXGBE_ETQF);
    eval 'sub IXGBE_ETQS {
        my($_i) = @_;
	    eval q((0xec00 + (($_i) * 4)));
    }' unless defined(&IXGBE_ETQS);
    eval 'sub IXGBE_SYNQF () {0xec30;}' unless defined(&IXGBE_SYNQF);
    eval 'sub IXGBE_RQTC () {0xec70;}' unless defined(&IXGBE_RQTC);
    eval 'sub IXGBE_MTQC () {0x8120;}' unless defined(&IXGBE_MTQC);
    eval 'sub IXGBE_VLVF {
        my($_i) = @_;
	    eval q((0xf100 + (($_i) * 4)));
    }' unless defined(&IXGBE_VLVF);
    eval 'sub IXGBE_VLVFB {
        my($_i) = @_;
	    eval q((0xf200 + (($_i) * 4)));
    }' unless defined(&IXGBE_VLVFB);
    eval 'sub IXGBE_VMVIR {
        my($_i) = @_;
	    eval q((0x8000 + (($_i) * 4)));
    }' unless defined(&IXGBE_VMVIR);
    eval 'sub IXGBE_VT_CTL () {0x51b0;}' unless defined(&IXGBE_VT_CTL);
    eval 'sub IXGBE_VFRE {
        my($_i) = @_;
	    eval q((0x51e0 + (($_i) * 4)));
    }' unless defined(&IXGBE_VFRE);
    eval 'sub IXGBE_VFTE {
        my($_i) = @_;
	    eval q((0x8110 + (($_i) * 4)));
    }' unless defined(&IXGBE_VFTE);
    eval 'sub IXGBE_VMECM {
        my($_i) = @_;
	    eval q((0x8790 + (($_i) * 4)));
    }' unless defined(&IXGBE_VMECM);
    eval 'sub IXGBE_QDE () {0x2f04;}' unless defined(&IXGBE_QDE);
    eval 'sub IXGBE_VMOLR {
        my($_i) = @_;
	    eval q((0xf000 + (($_i) * 4)));
    }' unless defined(&IXGBE_VMOLR);
    eval 'sub IXGBE_UTA {
        my($_i) = @_;
	    eval q((0xf400 + (($_i) * 4)));
    }' unless defined(&IXGBE_UTA);
    eval 'sub IXGBE_VMRCTL {
        my($_i) = @_;
	    eval q((0xf600 + (($_i) * 4)));
    }' unless defined(&IXGBE_VMRCTL);
    eval 'sub IXGBE_VMRVLAN {
        my($_i) = @_;
	    eval q((0xf610 + (($_i) * 4)));
    }' unless defined(&IXGBE_VMRVLAN);
    eval 'sub IXGBE_VMRVM {
        my($_i) = @_;
	    eval q((0xf630 + (($_i) * 4)));
    }' unless defined(&IXGBE_VMRVM);
    eval 'sub IXGBE_L34T_IMIR {
        my($_i) = @_;
	    eval q((0xe800 + (($_i) * 4)));
    }' unless defined(&IXGBE_L34T_IMIR);
    eval 'sub IXGBE_LLITHRESH () {0xec90;}' unless defined(&IXGBE_LLITHRESH);
    eval 'sub IXGBE_IMIR {
        my($_i) = @_;
	    eval q((0x5a80 + (($_i) * 4)));
    }' unless defined(&IXGBE_IMIR);
    eval 'sub IXGBE_IMIREXT {
        my($_i) = @_;
	    eval q((0x5aa0 + (($_i) * 4)));
    }' unless defined(&IXGBE_IMIREXT);
    eval 'sub IXGBE_IMIRVP () {0x5ac0;}' unless defined(&IXGBE_IMIRVP);
    eval 'sub IXGBE_VMD_CTL () {0x581c;}' unless defined(&IXGBE_VMD_CTL);
    eval 'sub IXGBE_RETA {
        my($_i) = @_;
	    eval q((0x5c00 + (($_i) * 4)));
    }' unless defined(&IXGBE_RETA);
    eval 'sub IXGBE_RSSRK {
        my($_i) = @_;
	    eval q((0x5c80 + (($_i) * 4)));
    }' unless defined(&IXGBE_RSSRK);
    eval 'sub IXGBE_FDIRCTRL () {0xee00;}' unless defined(&IXGBE_FDIRCTRL);
    eval 'sub IXGBE_FDIRHKEY () {0xee68;}' unless defined(&IXGBE_FDIRHKEY);
    eval 'sub IXGBE_FDIRSKEY () {0xee6c;}' unless defined(&IXGBE_FDIRSKEY);
    eval 'sub IXGBE_FDIRDIP4M () {0xee3c;}' unless defined(&IXGBE_FDIRDIP4M);
    eval 'sub IXGBE_FDIRSIP4M () {0xee40;}' unless defined(&IXGBE_FDIRSIP4M);
    eval 'sub IXGBE_FDIRTCPM () {0xee44;}' unless defined(&IXGBE_FDIRTCPM);
    eval 'sub IXGBE_FDIRUDPM () {0xee48;}' unless defined(&IXGBE_FDIRUDPM);
    eval 'sub IXGBE_FDIRIP6M () {0xee74;}' unless defined(&IXGBE_FDIRIP6M);
    eval 'sub IXGBE_FDIRM () {0xee70;}' unless defined(&IXGBE_FDIRM);
    eval 'sub IXGBE_FDIRFREE () {0xee38;}' unless defined(&IXGBE_FDIRFREE);
    eval 'sub IXGBE_FDIRLEN () {0xee4c;}' unless defined(&IXGBE_FDIRLEN);
    eval 'sub IXGBE_FDIRUSTAT () {0xee50;}' unless defined(&IXGBE_FDIRUSTAT);
    eval 'sub IXGBE_FDIRFSTAT () {0xee54;}' unless defined(&IXGBE_FDIRFSTAT);
    eval 'sub IXGBE_FDIRMATCH () {0xee58;}' unless defined(&IXGBE_FDIRMATCH);
    eval 'sub IXGBE_FDIRMISS () {0xee5c;}' unless defined(&IXGBE_FDIRMISS);
    eval 'sub IXGBE_FDIRSIPv6 {
        my($_i) = @_;
	    eval q((0xee0c + (($_i) * 4)));
    }' unless defined(&IXGBE_FDIRSIPv6);
    eval 'sub IXGBE_FDIRIPSA () {0xee18;}' unless defined(&IXGBE_FDIRIPSA);
    eval 'sub IXGBE_FDIRIPDA () {0xee1c;}' unless defined(&IXGBE_FDIRIPDA);
    eval 'sub IXGBE_FDIRPORT () {0xee20;}' unless defined(&IXGBE_FDIRPORT);
    eval 'sub IXGBE_FDIRVLAN () {0xee24;}' unless defined(&IXGBE_FDIRVLAN);
    eval 'sub IXGBE_FDIRHASH () {0xee28;}' unless defined(&IXGBE_FDIRHASH);
    eval 'sub IXGBE_FDIRCMD () {0xee2c;}' unless defined(&IXGBE_FDIRCMD);
    eval 'sub IXGBE_TDBAL {
        my($_i) = @_;
	    eval q((0x6000 + (($_i) * 0x40)));
    }' unless defined(&IXGBE_TDBAL);
    eval 'sub IXGBE_TDBAH {
        my($_i) = @_;
	    eval q((0x6004 + (($_i) * 0x40)));
    }' unless defined(&IXGBE_TDBAH);
    eval 'sub IXGBE_TDLEN {
        my($_i) = @_;
	    eval q((0x6008 + (($_i) * 0x40)));
    }' unless defined(&IXGBE_TDLEN);
    eval 'sub IXGBE_TDH {
        my($_i) = @_;
	    eval q((0x6010 + (($_i) * 0x40)));
    }' unless defined(&IXGBE_TDH);
    eval 'sub IXGBE_TDT {
        my($_i) = @_;
	    eval q((0x6018 + (($_i) * 0x40)));
    }' unless defined(&IXGBE_TDT);
    eval 'sub IXGBE_TXDCTL {
        my($_i) = @_;
	    eval q((0x6028 + (($_i) * 0x40)));
    }' unless defined(&IXGBE_TXDCTL);
    eval 'sub IXGBE_TDWBAL {
        my($_i) = @_;
	    eval q((0x6038 + (($_i) * 0x40)));
    }' unless defined(&IXGBE_TDWBAL);
    eval 'sub IXGBE_TDWBAH {
        my($_i) = @_;
	    eval q((0x603c + (($_i) * 0x40)));
    }' unless defined(&IXGBE_TDWBAH);
    eval 'sub IXGBE_DTXCTL () {0x7e00;}' unless defined(&IXGBE_DTXCTL);
    eval 'sub IXGBE_DMATXCTL () {0x4a80;}' unless defined(&IXGBE_DMATXCTL);
    eval 'sub IXGBE_PFVFSPOOF {
        my($_i) = @_;
	    eval q((0x8200 + (($_i) * 4)));
    }' unless defined(&IXGBE_PFVFSPOOF);
    eval 'sub IXGBE_PFDTXGSWC () {0x8220;}' unless defined(&IXGBE_PFDTXGSWC);
    eval 'sub IXGBE_DTXMXSZRQ () {0x8100;}' unless defined(&IXGBE_DTXMXSZRQ);
    eval 'sub IXGBE_DTXTCPFLGL () {0x4a88;}' unless defined(&IXGBE_DTXTCPFLGL);
    eval 'sub IXGBE_DTXTCPFLGH () {0x4a8c;}' unless defined(&IXGBE_DTXTCPFLGH);
    eval 'sub IXGBE_LBDRPEN () {0xca00;}' unless defined(&IXGBE_LBDRPEN);
    eval 'sub IXGBE_TXPBTHRESH {
        my($_i) = @_;
	    eval q((0x4950 + (($_i) * 4)));
    }' unless defined(&IXGBE_TXPBTHRESH);
    eval 'sub IXGBE_DMATXCTL_TE () {0x1;}' unless defined(&IXGBE_DMATXCTL_TE);
    eval 'sub IXGBE_DMATXCTL_NS () {0x2;}' unless defined(&IXGBE_DMATXCTL_NS);
    eval 'sub IXGBE_DMATXCTL_GDV () {0x8;}' unless defined(&IXGBE_DMATXCTL_GDV);
    eval 'sub IXGBE_DMATXCTL_VT_SHIFT () {16;}' unless defined(&IXGBE_DMATXCTL_VT_SHIFT);
    eval 'sub IXGBE_PFDTXGSWC_VT_LBEN () {0x1;}' unless defined(&IXGBE_PFDTXGSWC_VT_LBEN);
    eval 'sub IXGBE_SPOOF_MACAS_MASK () {0xff;}' unless defined(&IXGBE_SPOOF_MACAS_MASK);
    eval 'sub IXGBE_SPOOF_VLANAS_MASK () {0xff00;}' unless defined(&IXGBE_SPOOF_VLANAS_MASK);
    eval 'sub IXGBE_SPOOF_VLANAS_SHIFT () {8;}' unless defined(&IXGBE_SPOOF_VLANAS_SHIFT);
    eval 'sub IXGBE_PFVFSPOOF_REG_COUNT () {8;}' unless defined(&IXGBE_PFVFSPOOF_REG_COUNT);
    eval 'sub IXGBE_DCA_TXCTRL {
        my($_i) = @_;
	    eval q((0x7200 + (($_i) * 4)));
    }' unless defined(&IXGBE_DCA_TXCTRL);
    eval 'sub IXGBE_DCA_TXCTRL_82599 {
        my($_i) = @_;
	    eval q((0x600c + (($_i) * 0x40)));
    }' unless defined(&IXGBE_DCA_TXCTRL_82599);
    eval 'sub IXGBE_TIPG () {0xcb00;}' unless defined(&IXGBE_TIPG);
    eval 'sub IXGBE_TXPBSIZE {
        my($_i) = @_;
	    eval q((0xcc00 + (($_i) * 4)));
    }' unless defined(&IXGBE_TXPBSIZE);
    eval 'sub IXGBE_MNGTXMAP () {0xcd10;}' unless defined(&IXGBE_MNGTXMAP);
    eval 'sub IXGBE_TIPG_FIBER_DEFAULT () {3;}' unless defined(&IXGBE_TIPG_FIBER_DEFAULT);
    eval 'sub IXGBE_TXPBSIZE_SHIFT () {10;}' unless defined(&IXGBE_TXPBSIZE_SHIFT);
    eval 'sub IXGBE_WUC () {0x5800;}' unless defined(&IXGBE_WUC);
    eval 'sub IXGBE_WUFC () {0x5808;}' unless defined(&IXGBE_WUFC);
    eval 'sub IXGBE_WUS () {0x5810;}' unless defined(&IXGBE_WUS);
    eval 'sub IXGBE_IPAV () {0x5838;}' unless defined(&IXGBE_IPAV);
    eval 'sub IXGBE_IP4AT () {0x5840;}' unless defined(&IXGBE_IP4AT);
    eval 'sub IXGBE_IP6AT () {0x5880;}' unless defined(&IXGBE_IP6AT);
    eval 'sub IXGBE_WUPL () {0x5900;}' unless defined(&IXGBE_WUPL);
    eval 'sub IXGBE_WUPM () {0x5a00;}' unless defined(&IXGBE_WUPM);
    eval 'sub IXGBE_FHFT {
        my($_n) = @_;
	    eval q((0x9000 + ($_n * 0x100)));
    }' unless defined(&IXGBE_FHFT);
    eval 'sub IXGBE_FHFT_EXT {
        my($_n) = @_;
	    eval q((0x9800 + ($_n * 0x100)));
    }' unless defined(&IXGBE_FHFT_EXT);
    eval 'sub IXGBE_FLEXIBLE_FILTER_COUNT_MAX () {4;}' unless defined(&IXGBE_FLEXIBLE_FILTER_COUNT_MAX);
    eval 'sub IXGBE_EXT_FLEXIBLE_FILTER_COUNT_MAX () {2;}' unless defined(&IXGBE_EXT_FLEXIBLE_FILTER_COUNT_MAX);
    eval 'sub IXGBE_FLEXIBLE_FILTER_SIZE_MAX () {128;}' unless defined(&IXGBE_FLEXIBLE_FILTER_SIZE_MAX);
    eval 'sub IXGBE_FHFT_LENGTH_OFFSET () {0xfc;}' unless defined(&IXGBE_FHFT_LENGTH_OFFSET);
    eval 'sub IXGBE_FHFT_LENGTH_MASK () {0xff;}' unless defined(&IXGBE_FHFT_LENGTH_MASK);
    eval 'sub IXGBE_WUC_PME_EN () {0x2;}' unless defined(&IXGBE_WUC_PME_EN);
    eval 'sub IXGBE_WUC_PME_STATUS () {0x4;}' unless defined(&IXGBE_WUC_PME_STATUS);
    eval 'sub IXGBE_WUC_WKEN () {0x10;}' unless defined(&IXGBE_WUC_WKEN);
    eval 'sub IXGBE_WUFC_LNKC () {0x1;}' unless defined(&IXGBE_WUFC_LNKC);
    eval 'sub IXGBE_WUFC_MAG () {0x2;}' unless defined(&IXGBE_WUFC_MAG);
    eval 'sub IXGBE_WUFC_EX () {0x4;}' unless defined(&IXGBE_WUFC_EX);
    eval 'sub IXGBE_WUFC_MC () {0x8;}' unless defined(&IXGBE_WUFC_MC);
    eval 'sub IXGBE_WUFC_BC () {0x10;}' unless defined(&IXGBE_WUFC_BC);
    eval 'sub IXGBE_WUFC_ARP () {0x20;}' unless defined(&IXGBE_WUFC_ARP);
    eval 'sub IXGBE_WUFC_IPV4 () {0x40;}' unless defined(&IXGBE_WUFC_IPV4);
    eval 'sub IXGBE_WUFC_IPV6 () {0x80;}' unless defined(&IXGBE_WUFC_IPV6);
    eval 'sub IXGBE_WUFC_MNG () {0x100;}' unless defined(&IXGBE_WUFC_MNG);
    eval 'sub IXGBE_WUFC_IGNORE_TCO () {0x8000;}' unless defined(&IXGBE_WUFC_IGNORE_TCO);
    eval 'sub IXGBE_WUFC_FLX0 () {0x10000;}' unless defined(&IXGBE_WUFC_FLX0);
    eval 'sub IXGBE_WUFC_FLX1 () {0x20000;}' unless defined(&IXGBE_WUFC_FLX1);
    eval 'sub IXGBE_WUFC_FLX2 () {0x40000;}' unless defined(&IXGBE_WUFC_FLX2);
    eval 'sub IXGBE_WUFC_FLX3 () {0x80000;}' unless defined(&IXGBE_WUFC_FLX3);
    eval 'sub IXGBE_WUFC_FLX4 () {0x100000;}' unless defined(&IXGBE_WUFC_FLX4);
    eval 'sub IXGBE_WUFC_FLX5 () {0x200000;}' unless defined(&IXGBE_WUFC_FLX5);
    eval 'sub IXGBE_WUFC_FLX_FILTERS () {0xf0000;}' unless defined(&IXGBE_WUFC_FLX_FILTERS);
    eval 'sub IXGBE_WUFC_EXT_FLX_FILTERS () {0x300000;}' unless defined(&IXGBE_WUFC_EXT_FLX_FILTERS);
    eval 'sub IXGBE_WUFC_ALL_FILTERS () {0x3f00ff;}' unless defined(&IXGBE_WUFC_ALL_FILTERS);
    eval 'sub IXGBE_WUFC_FLX_OFFSET () {16;}' unless defined(&IXGBE_WUFC_FLX_OFFSET);
    eval 'sub IXGBE_WUS_LNKC () { &IXGBE_WUFC_LNKC;}' unless defined(&IXGBE_WUS_LNKC);
    eval 'sub IXGBE_WUS_MAG () { &IXGBE_WUFC_MAG;}' unless defined(&IXGBE_WUS_MAG);
    eval 'sub IXGBE_WUS_EX () { &IXGBE_WUFC_EX;}' unless defined(&IXGBE_WUS_EX);
    eval 'sub IXGBE_WUS_MC () { &IXGBE_WUFC_MC;}' unless defined(&IXGBE_WUS_MC);
    eval 'sub IXGBE_WUS_BC () { &IXGBE_WUFC_BC;}' unless defined(&IXGBE_WUS_BC);
    eval 'sub IXGBE_WUS_ARP () { &IXGBE_WUFC_ARP;}' unless defined(&IXGBE_WUS_ARP);
    eval 'sub IXGBE_WUS_IPV4 () { &IXGBE_WUFC_IPV4;}' unless defined(&IXGBE_WUS_IPV4);
    eval 'sub IXGBE_WUS_IPV6 () { &IXGBE_WUFC_IPV6;}' unless defined(&IXGBE_WUS_IPV6);
    eval 'sub IXGBE_WUS_MNG () { &IXGBE_WUFC_MNG;}' unless defined(&IXGBE_WUS_MNG);
    eval 'sub IXGBE_WUS_FLX0 () { &IXGBE_WUFC_FLX0;}' unless defined(&IXGBE_WUS_FLX0);
    eval 'sub IXGBE_WUS_FLX1 () { &IXGBE_WUFC_FLX1;}' unless defined(&IXGBE_WUS_FLX1);
    eval 'sub IXGBE_WUS_FLX2 () { &IXGBE_WUFC_FLX2;}' unless defined(&IXGBE_WUS_FLX2);
    eval 'sub IXGBE_WUS_FLX3 () { &IXGBE_WUFC_FLX3;}' unless defined(&IXGBE_WUS_FLX3);
    eval 'sub IXGBE_WUS_FLX4 () { &IXGBE_WUFC_FLX4;}' unless defined(&IXGBE_WUS_FLX4);
    eval 'sub IXGBE_WUS_FLX5 () { &IXGBE_WUFC_FLX5;}' unless defined(&IXGBE_WUS_FLX5);
    eval 'sub IXGBE_WUS_FLX_FILTERS () { &IXGBE_WUFC_FLX_FILTERS;}' unless defined(&IXGBE_WUS_FLX_FILTERS);
    eval 'sub IXGBE_WUPL_LENGTH_MASK () {0xffff;}' unless defined(&IXGBE_WUPL_LENGTH_MASK);
    eval 'sub IXGBE_DCB_MAX_TRAFFIC_CLASS () {8;}' unless defined(&IXGBE_DCB_MAX_TRAFFIC_CLASS);
    eval 'sub IXGBE_RMCS () {0x3d00;}' unless defined(&IXGBE_RMCS);
    eval 'sub IXGBE_DPMCS () {0x7f40;}' unless defined(&IXGBE_DPMCS);
    eval 'sub IXGBE_PDPMCS () {0xcd00;}' unless defined(&IXGBE_PDPMCS);
    eval 'sub IXGBE_RUPPBMR () {0x50a0;}' unless defined(&IXGBE_RUPPBMR);
    eval 'sub IXGBE_RT2CR {
        my($_i) = @_;
	    eval q((0x3c20 + (($_i) * 4)));
    }' unless defined(&IXGBE_RT2CR);
    eval 'sub IXGBE_RT2SR {
        my($_i) = @_;
	    eval q((0x3c40 + (($_i) * 4)));
    }' unless defined(&IXGBE_RT2SR);
    eval 'sub IXGBE_TDTQ2TCCR {
        my($_i) = @_;
	    eval q((0x602c + (($_i) * 0x40)));
    }' unless defined(&IXGBE_TDTQ2TCCR);
    eval 'sub IXGBE_TDTQ2TCSR {
        my($_i) = @_;
	    eval q((0x622c + (($_i) * 0x40)));
    }' unless defined(&IXGBE_TDTQ2TCSR);
    eval 'sub IXGBE_TDPT2TCCR {
        my($_i) = @_;
	    eval q((0xcd20 + (($_i) * 4)));
    }' unless defined(&IXGBE_TDPT2TCCR);
    eval 'sub IXGBE_TDPT2TCSR {
        my($_i) = @_;
	    eval q((0xcd40 + (($_i) * 4)));
    }' unless defined(&IXGBE_TDPT2TCSR);
    eval 'sub IXGBE_SECTXCTRL () {0x8800;}' unless defined(&IXGBE_SECTXCTRL);
    eval 'sub IXGBE_SECTXSTAT () {0x8804;}' unless defined(&IXGBE_SECTXSTAT);
    eval 'sub IXGBE_SECTXBUFFAF () {0x8808;}' unless defined(&IXGBE_SECTXBUFFAF);
    eval 'sub IXGBE_SECTXMINIFG () {0x8810;}' unless defined(&IXGBE_SECTXMINIFG);
    eval 'sub IXGBE_SECRXCTRL () {0x8d00;}' unless defined(&IXGBE_SECRXCTRL);
    eval 'sub IXGBE_SECRXSTAT () {0x8d04;}' unless defined(&IXGBE_SECRXSTAT);
    eval 'sub IXGBE_SECTXCTRL_SECTX_DIS () {0x1;}' unless defined(&IXGBE_SECTXCTRL_SECTX_DIS);
    eval 'sub IXGBE_SECTXCTRL_TX_DIS () {0x2;}' unless defined(&IXGBE_SECTXCTRL_TX_DIS);
    eval 'sub IXGBE_SECTXCTRL_STORE_FORWARD () {0x4;}' unless defined(&IXGBE_SECTXCTRL_STORE_FORWARD);
    eval 'sub IXGBE_SECTXSTAT_SECTX_RDY () {0x1;}' unless defined(&IXGBE_SECTXSTAT_SECTX_RDY);
    eval 'sub IXGBE_SECTXSTAT_ECC_TXERR () {0x2;}' unless defined(&IXGBE_SECTXSTAT_ECC_TXERR);
    eval 'sub IXGBE_SECRXCTRL_SECRX_DIS () {0x1;}' unless defined(&IXGBE_SECRXCTRL_SECRX_DIS);
    eval 'sub IXGBE_SECRXCTRL_RX_DIS () {0x2;}' unless defined(&IXGBE_SECRXCTRL_RX_DIS);
    eval 'sub IXGBE_SECRXSTAT_SECRX_RDY () {0x1;}' unless defined(&IXGBE_SECRXSTAT_SECRX_RDY);
    eval 'sub IXGBE_SECRXSTAT_ECC_RXERR () {0x2;}' unless defined(&IXGBE_SECRXSTAT_ECC_RXERR);
    eval 'sub IXGBE_LSECTXCAP () {0x8a00;}' unless defined(&IXGBE_LSECTXCAP);
    eval 'sub IXGBE_LSECRXCAP () {0x8f00;}' unless defined(&IXGBE_LSECRXCAP);
    eval 'sub IXGBE_LSECTXCTRL () {0x8a04;}' unless defined(&IXGBE_LSECTXCTRL);
    eval 'sub IXGBE_LSECTXSCL () {0x8a08;}' unless defined(&IXGBE_LSECTXSCL);
    eval 'sub IXGBE_LSECTXSCH () {0x8a0c;}' unless defined(&IXGBE_LSECTXSCH);
    eval 'sub IXGBE_LSECTXSA () {0x8a10;}' unless defined(&IXGBE_LSECTXSA);
    eval 'sub IXGBE_LSECTXPN0 () {0x8a14;}' unless defined(&IXGBE_LSECTXPN0);
    eval 'sub IXGBE_LSECTXPN1 () {0x8a18;}' unless defined(&IXGBE_LSECTXPN1);
    eval 'sub IXGBE_LSECTXKEY0 {
        my($_n) = @_;
	    eval q((0x8a1c + (4* ($_n))));
    }' unless defined(&IXGBE_LSECTXKEY0);
    eval 'sub IXGBE_LSECTXKEY1 {
        my($_n) = @_;
	    eval q((0x8a2c + (4* ($_n))));
    }' unless defined(&IXGBE_LSECTXKEY1);
    eval 'sub IXGBE_LSECRXCTRL () {0x8f04;}' unless defined(&IXGBE_LSECRXCTRL);
    eval 'sub IXGBE_LSECRXSCL () {0x8f08;}' unless defined(&IXGBE_LSECRXSCL);
    eval 'sub IXGBE_LSECRXSCH () {0x8f0c;}' unless defined(&IXGBE_LSECRXSCH);
    eval 'sub IXGBE_LSECRXSA {
        my($_i) = @_;
	    eval q((0x8f10 + (4* ($_i))));
    }' unless defined(&IXGBE_LSECRXSA);
    eval 'sub IXGBE_LSECRXPN {
        my($_i) = @_;
	    eval q((0x8f18 + (4* ($_i))));
    }' unless defined(&IXGBE_LSECRXPN);
    eval 'sub IXGBE_LSECRXKEY {
        my($_n, $_m) = @_;
	    eval q((0x8f20 + ((0x10 * ($_n)) + (4* ($_m)))));
    }' unless defined(&IXGBE_LSECRXKEY);
    eval 'sub IXGBE_LSECTXUT () {0x8a3c;}' unless defined(&IXGBE_LSECTXUT);
    eval 'sub IXGBE_LSECTXPKTE () {0x8a40;}' unless defined(&IXGBE_LSECTXPKTE);
    eval 'sub IXGBE_LSECTXPKTP () {0x8a44;}' unless defined(&IXGBE_LSECTXPKTP);
    eval 'sub IXGBE_LSECTXOCTE () {0x8a48;}' unless defined(&IXGBE_LSECTXOCTE);
    eval 'sub IXGBE_LSECTXOCTP () {0x8a4c;}' unless defined(&IXGBE_LSECTXOCTP);
    eval 'sub IXGBE_LSECRXUT () {0x8f40;}' unless defined(&IXGBE_LSECRXUT);
    eval 'sub IXGBE_LSECRXOCTD () {0x8f44;}' unless defined(&IXGBE_LSECRXOCTD);
    eval 'sub IXGBE_LSECRXOCTV () {0x8f48;}' unless defined(&IXGBE_LSECRXOCTV);
    eval 'sub IXGBE_LSECRXBAD () {0x8f4c;}' unless defined(&IXGBE_LSECRXBAD);
    eval 'sub IXGBE_LSECRXNOSCI () {0x8f50;}' unless defined(&IXGBE_LSECRXNOSCI);
    eval 'sub IXGBE_LSECRXUNSCI () {0x8f54;}' unless defined(&IXGBE_LSECRXUNSCI);
    eval 'sub IXGBE_LSECRXUNCH () {0x8f58;}' unless defined(&IXGBE_LSECRXUNCH);
    eval 'sub IXGBE_LSECRXDELAY () {0x8f5c;}' unless defined(&IXGBE_LSECRXDELAY);
    eval 'sub IXGBE_LSECRXLATE () {0x8f60;}' unless defined(&IXGBE_LSECRXLATE);
    eval 'sub IXGBE_LSECRXOK {
        my($_n) = @_;
	    eval q((0x8f64 + (0x4 * ($_n))));
    }' unless defined(&IXGBE_LSECRXOK);
    eval 'sub IXGBE_LSECRXINV {
        my($_n) = @_;
	    eval q((0x8f6c + (0x4 * ($_n))));
    }' unless defined(&IXGBE_LSECRXINV);
    eval 'sub IXGBE_LSECRXNV {
        my($_n) = @_;
	    eval q((0x8f74 + (0x4 * ($_n))));
    }' unless defined(&IXGBE_LSECRXNV);
    eval 'sub IXGBE_LSECRXUNSA () {0x8f7c;}' unless defined(&IXGBE_LSECRXUNSA);
    eval 'sub IXGBE_LSECRXNUSA () {0x8f80;}' unless defined(&IXGBE_LSECRXNUSA);
    eval 'sub IXGBE_LSECTXCAP_SUM_MASK () {0xff0000;}' unless defined(&IXGBE_LSECTXCAP_SUM_MASK);
    eval 'sub IXGBE_LSECTXCAP_SUM_SHIFT () {16;}' unless defined(&IXGBE_LSECTXCAP_SUM_SHIFT);
    eval 'sub IXGBE_LSECRXCAP_SUM_MASK () {0xff0000;}' unless defined(&IXGBE_LSECRXCAP_SUM_MASK);
    eval 'sub IXGBE_LSECRXCAP_SUM_SHIFT () {16;}' unless defined(&IXGBE_LSECRXCAP_SUM_SHIFT);
    eval 'sub IXGBE_LSECTXCTRL_EN_MASK () {0x3;}' unless defined(&IXGBE_LSECTXCTRL_EN_MASK);
    eval 'sub IXGBE_LSECTXCTRL_DISABLE () {0x;}' unless defined(&IXGBE_LSECTXCTRL_DISABLE);
    eval 'sub IXGBE_LSECTXCTRL_AUTH () {0x1;}' unless defined(&IXGBE_LSECTXCTRL_AUTH);
    eval 'sub IXGBE_LSECTXCTRL_AUTH_ENCRYPT () {0x2;}' unless defined(&IXGBE_LSECTXCTRL_AUTH_ENCRYPT);
    eval 'sub IXGBE_LSECTXCTRL_AISCI () {0x20;}' unless defined(&IXGBE_LSECTXCTRL_AISCI);
    eval 'sub IXGBE_LSECTXCTRL_PNTHRSH_MASK () {0xffffff00;}' unless defined(&IXGBE_LSECTXCTRL_PNTHRSH_MASK);
    eval 'sub IXGBE_LSECTXCTRL_RSV_MASK () {0xd8;}' unless defined(&IXGBE_LSECTXCTRL_RSV_MASK);
    eval 'sub IXGBE_LSECRXCTRL_EN_MASK () {0xc;}' unless defined(&IXGBE_LSECRXCTRL_EN_MASK);
    eval 'sub IXGBE_LSECRXCTRL_EN_SHIFT () {2;}' unless defined(&IXGBE_LSECRXCTRL_EN_SHIFT);
    eval 'sub IXGBE_LSECRXCTRL_DISABLE () {0x;}' unless defined(&IXGBE_LSECRXCTRL_DISABLE);
    eval 'sub IXGBE_LSECRXCTRL_CHECK () {0x1;}' unless defined(&IXGBE_LSECRXCTRL_CHECK);
    eval 'sub IXGBE_LSECRXCTRL_STRICT () {0x2;}' unless defined(&IXGBE_LSECRXCTRL_STRICT);
    eval 'sub IXGBE_LSECRXCTRL_DROP () {0x3;}' unless defined(&IXGBE_LSECRXCTRL_DROP);
    eval 'sub IXGBE_LSECRXCTRL_PLSH () {0x40;}' unless defined(&IXGBE_LSECRXCTRL_PLSH);
    eval 'sub IXGBE_LSECRXCTRL_RP () {0x80;}' unless defined(&IXGBE_LSECRXCTRL_RP);
    eval 'sub IXGBE_LSECRXCTRL_RSV_MASK () {0xffffff33;}' unless defined(&IXGBE_LSECRXCTRL_RSV_MASK);
    eval 'sub IXGBE_IPSTXIDX () {0x8900;}' unless defined(&IXGBE_IPSTXIDX);
    eval 'sub IXGBE_IPSTXSALT () {0x8904;}' unless defined(&IXGBE_IPSTXSALT);
    eval 'sub IXGBE_IPSTXKEY {
        my($_i) = @_;
	    eval q((0x8908 + (4* ($_i))));
    }' unless defined(&IXGBE_IPSTXKEY);
    eval 'sub IXGBE_IPSRXIDX () {0x8e00;}' unless defined(&IXGBE_IPSRXIDX);
    eval 'sub IXGBE_IPSRXIPADDR {
        my($_i) = @_;
	    eval q((0x8e04 + (4* ($_i))));
    }' unless defined(&IXGBE_IPSRXIPADDR);
    eval 'sub IXGBE_IPSRXSPI () {0x8e14;}' unless defined(&IXGBE_IPSRXSPI);
    eval 'sub IXGBE_IPSRXIPIDX () {0x8e18;}' unless defined(&IXGBE_IPSRXIPIDX);
    eval 'sub IXGBE_IPSRXKEY {
        my($_i) = @_;
	    eval q((0x8e1c + (4* ($_i))));
    }' unless defined(&IXGBE_IPSRXKEY);
    eval 'sub IXGBE_IPSRXSALT () {0x8e2c;}' unless defined(&IXGBE_IPSRXSALT);
    eval 'sub IXGBE_IPSRXMOD () {0x8e30;}' unless defined(&IXGBE_IPSRXMOD);
    eval 'sub IXGBE_SECTXCTRL_STORE_FORWARD_ENABLE () {0x4;}' unless defined(&IXGBE_SECTXCTRL_STORE_FORWARD_ENABLE);
    eval 'sub IXGBE_RTRPCS () {0x2430;}' unless defined(&IXGBE_RTRPCS);
    eval 'sub IXGBE_RTTDCS () {0x4900;}' unless defined(&IXGBE_RTTDCS);
    eval 'sub IXGBE_RTTDCS_ARBDIS () {0x40;}' unless defined(&IXGBE_RTTDCS_ARBDIS);
    eval 'sub IXGBE_RTTPCS () {0xcd00;}' unless defined(&IXGBE_RTTPCS);
    eval 'sub IXGBE_RTRUP2TC () {0x3020;}' unless defined(&IXGBE_RTRUP2TC);
    eval 'sub IXGBE_RTTUP2TC () {0xc800;}' unless defined(&IXGBE_RTTUP2TC);
    eval 'sub IXGBE_RTRPT4C {
        my($_i) = @_;
	    eval q((0x2140 + (($_i) * 4)));
    }' unless defined(&IXGBE_RTRPT4C);
    eval 'sub IXGBE_RTRPT4S {
        my($_i) = @_;
	    eval q((0x2160 + (($_i) * 4)));
    }' unless defined(&IXGBE_RTRPT4S);
    eval 'sub IXGBE_RTTDT2C {
        my($_i) = @_;
	    eval q((0x4910 + (($_i) * 4)));
    }' unless defined(&IXGBE_RTTDT2C);
    eval 'sub IXGBE_RTTDT2S {
        my($_i) = @_;
	    eval q((0x4930 + (($_i) * 4)));
    }' unless defined(&IXGBE_RTTDT2S);
    eval 'sub IXGBE_RTTPT2C {
        my($_i) = @_;
	    eval q((0xcd20 + (($_i) * 4)));
    }' unless defined(&IXGBE_RTTPT2C);
    eval 'sub IXGBE_RTTPT2S {
        my($_i) = @_;
	    eval q((0xcd40 + (($_i) * 4)));
    }' unless defined(&IXGBE_RTTPT2S);
    eval 'sub IXGBE_RTTDQSEL () {0x4904;}' unless defined(&IXGBE_RTTDQSEL);
    eval 'sub IXGBE_RTTDT1C () {0x4908;}' unless defined(&IXGBE_RTTDT1C);
    eval 'sub IXGBE_RTTDT1S () {0x490c;}' unless defined(&IXGBE_RTTDT1S);
    eval 'sub IXGBE_RTTDTECC () {0x4990;}' unless defined(&IXGBE_RTTDTECC);
    eval 'sub IXGBE_RTTDTECC_NO_BCN () {0x100;}' unless defined(&IXGBE_RTTDTECC_NO_BCN);
    eval 'sub IXGBE_RTTBCNRC () {0x4984;}' unless defined(&IXGBE_RTTBCNRC);
    eval 'sub IXGBE_RTTBCNRC_RS_ENA () {0x80000000;}' unless defined(&IXGBE_RTTBCNRC_RS_ENA);
    eval 'sub IXGBE_RTTBCNRC_RF_DEC_MASK () {0x3fff;}' unless defined(&IXGBE_RTTBCNRC_RF_DEC_MASK);
    eval 'sub IXGBE_RTTBCNRC_RF_INT_SHIFT () {14;}' unless defined(&IXGBE_RTTBCNRC_RF_INT_SHIFT);
    eval 'sub IXGBE_RTTBCNRC_RF_INT_MASK () {( &IXGBE_RTTBCNRC_RF_DEC_MASK <<  &IXGBE_RTTBCNRC_RF_INT_SHIFT);}' unless defined(&IXGBE_RTTBCNRC_RF_INT_MASK);
    eval 'sub IXGBE_RTTBCNRM () {0x4980;}' unless defined(&IXGBE_RTTBCNRM);
    eval 'sub IXGBE_RTTBCNRS () {0x4988;}' unless defined(&IXGBE_RTTBCNRS);
    eval 'sub IXGBE_RTTBCNCR () {0x8b00;}' unless defined(&IXGBE_RTTBCNCR);
    eval 'sub IXGBE_RTTBCNACH () {0x8b04;}' unless defined(&IXGBE_RTTBCNACH);
    eval 'sub IXGBE_RTTBCNACL () {0x8b08;}' unless defined(&IXGBE_RTTBCNACL);
    eval 'sub IXGBE_RTTBCNTG () {0x4a90;}' unless defined(&IXGBE_RTTBCNTG);
    eval 'sub IXGBE_RTTBCNIDX () {0x8b0c;}' unless defined(&IXGBE_RTTBCNIDX);
    eval 'sub IXGBE_RTTBCNCP () {0x8b10;}' unless defined(&IXGBE_RTTBCNCP);
    eval 'sub IXGBE_RTFRTIMER () {0x8b14;}' unless defined(&IXGBE_RTFRTIMER);
    eval 'sub IXGBE_RTTBCNRTT () {0x5150;}' unless defined(&IXGBE_RTTBCNRTT);
    eval 'sub IXGBE_RTTBCNRD () {0x498c;}' unless defined(&IXGBE_RTTBCNRD);
    eval 'sub IXGBE_FCPTRL () {0x2410;}' unless defined(&IXGBE_FCPTRL);
    eval 'sub IXGBE_FCPTRH () {0x2414;}' unless defined(&IXGBE_FCPTRH);
    eval 'sub IXGBE_FCBUFF () {0x2418;}' unless defined(&IXGBE_FCBUFF);
    eval 'sub IXGBE_FCDMARW () {0x2420;}' unless defined(&IXGBE_FCDMARW);
    eval 'sub IXGBE_FCINVST0 () {0x3fc0;}' unless defined(&IXGBE_FCINVST0);
    eval 'sub IXGBE_FCINVST {
        my($_i) = @_;
	    eval q(( &IXGBE_FCINVST0 + (($_i) * 4)));
    }' unless defined(&IXGBE_FCINVST);
    eval 'sub IXGBE_FCBUFF_VALID () {(1<< 0);}' unless defined(&IXGBE_FCBUFF_VALID);
    eval 'sub IXGBE_FCBUFF_BUFFSIZE () {(3<< 3);}' unless defined(&IXGBE_FCBUFF_BUFFSIZE);
    eval 'sub IXGBE_FCBUFF_WRCONTX () {(1<< 7);}' unless defined(&IXGBE_FCBUFF_WRCONTX);
    eval 'sub IXGBE_FCBUFF_BUFFCNT () {0xff00;}' unless defined(&IXGBE_FCBUFF_BUFFCNT);
    eval 'sub IXGBE_FCBUFF_OFFSET () {0xffff0000;}' unless defined(&IXGBE_FCBUFF_OFFSET);
    eval 'sub IXGBE_FCBUFF_BUFFSIZE_SHIFT () {3;}' unless defined(&IXGBE_FCBUFF_BUFFSIZE_SHIFT);
    eval 'sub IXGBE_FCBUFF_BUFFCNT_SHIFT () {8;}' unless defined(&IXGBE_FCBUFF_BUFFCNT_SHIFT);
    eval 'sub IXGBE_FCBUFF_OFFSET_SHIFT () {16;}' unless defined(&IXGBE_FCBUFF_OFFSET_SHIFT);
    eval 'sub IXGBE_FCDMARW_WE () {(1<< 14);}' unless defined(&IXGBE_FCDMARW_WE);
    eval 'sub IXGBE_FCDMARW_RE () {(1<< 15);}' unless defined(&IXGBE_FCDMARW_RE);
    eval 'sub IXGBE_FCDMARW_FCOESEL () {0x1ff;}' unless defined(&IXGBE_FCDMARW_FCOESEL);
    eval 'sub IXGBE_FCDMARW_LASTSIZE () {0xffff0000;}' unless defined(&IXGBE_FCDMARW_LASTSIZE);
    eval 'sub IXGBE_FCDMARW_LASTSIZE_SHIFT () {16;}' unless defined(&IXGBE_FCDMARW_LASTSIZE_SHIFT);
    eval 'sub IXGBE_TEOFF () {0x4a94;}' unless defined(&IXGBE_TEOFF);
    eval 'sub IXGBE_TSOFF () {0x4a98;}' unless defined(&IXGBE_TSOFF);
    eval 'sub IXGBE_REOFF () {0x5158;}' unless defined(&IXGBE_REOFF);
    eval 'sub IXGBE_RSOFF () {0x51f8;}' unless defined(&IXGBE_RSOFF);
    eval 'sub IXGBE_FCFLT () {0x5108;}' unless defined(&IXGBE_FCFLT);
    eval 'sub IXGBE_FCFLTRW () {0x5110;}' unless defined(&IXGBE_FCFLTRW);
    eval 'sub IXGBE_FCPARAM () {0x51d8;}' unless defined(&IXGBE_FCPARAM);
    eval 'sub IXGBE_FCFLT_VALID () {(1<< 0);}' unless defined(&IXGBE_FCFLT_VALID);
    eval 'sub IXGBE_FCFLT_FIRST () {(1<< 1);}' unless defined(&IXGBE_FCFLT_FIRST);
    eval 'sub IXGBE_FCFLT_SEQID () {0xff0000;}' unless defined(&IXGBE_FCFLT_SEQID);
    eval 'sub IXGBE_FCFLT_SEQCNT () {0xff000000;}' unless defined(&IXGBE_FCFLT_SEQCNT);
    eval 'sub IXGBE_FCFLTRW_RVALDT () {(1<< 13);}' unless defined(&IXGBE_FCFLTRW_RVALDT);
    eval 'sub IXGBE_FCFLTRW_WE () {(1<< 14);}' unless defined(&IXGBE_FCFLTRW_WE);
    eval 'sub IXGBE_FCFLTRW_RE () {(1<< 15);}' unless defined(&IXGBE_FCFLTRW_RE);
    eval 'sub IXGBE_FCRXCTRL () {0x5100;}' unless defined(&IXGBE_FCRXCTRL);
    eval 'sub IXGBE_FCRXCTRL_FCOELLI () {(1<< 0);}' unless defined(&IXGBE_FCRXCTRL_FCOELLI);
    eval 'sub IXGBE_FCRXCTRL_SAVBAD () {(1<< 1);}' unless defined(&IXGBE_FCRXCTRL_SAVBAD);
    eval 'sub IXGBE_FCRXCTRL_FRSTRDH () {(1<< 2);}' unless defined(&IXGBE_FCRXCTRL_FRSTRDH);
    eval 'sub IXGBE_FCRXCTRL_LASTSEQH () {(1<< 3);}' unless defined(&IXGBE_FCRXCTRL_LASTSEQH);
    eval 'sub IXGBE_FCRXCTRL_ALLH () {(1<< 4);}' unless defined(&IXGBE_FCRXCTRL_ALLH);
    eval 'sub IXGBE_FCRXCTRL_FRSTSEQH () {(1<< 5);}' unless defined(&IXGBE_FCRXCTRL_FRSTSEQH);
    eval 'sub IXGBE_FCRXCTRL_ICRC () {(1<< 6);}' unless defined(&IXGBE_FCRXCTRL_ICRC);
    eval 'sub IXGBE_FCRXCTRL_FCCRCBO () {(1<< 7);}' unless defined(&IXGBE_FCRXCTRL_FCCRCBO);
    eval 'sub IXGBE_FCRXCTRL_FCOEVER () {0xf00;}' unless defined(&IXGBE_FCRXCTRL_FCOEVER);
    eval 'sub IXGBE_FCRXCTRL_FCOEVER_SHIFT () {8;}' unless defined(&IXGBE_FCRXCTRL_FCOEVER_SHIFT);
    eval 'sub IXGBE_FCRECTL () {0xed00;}' unless defined(&IXGBE_FCRECTL);
    eval 'sub IXGBE_FCRETA0 () {0xed10;}' unless defined(&IXGBE_FCRETA0);
    eval 'sub IXGBE_FCRETA {
        my($_i) = @_;
	    eval q(( &IXGBE_FCRETA0 + (($_i) * 4)));
    }' unless defined(&IXGBE_FCRETA);
    eval 'sub IXGBE_FCRECTL_ENA () {0x1;}' unless defined(&IXGBE_FCRECTL_ENA);
    eval 'sub IXGBE_FCRETA_SIZE () {8;}' unless defined(&IXGBE_FCRETA_SIZE);
    eval 'sub IXGBE_FCRETA_ENTRY_MASK () {0x7f;}' unless defined(&IXGBE_FCRETA_ENTRY_MASK);
    eval 'sub IXGBE_CRCERRS () {0x4000;}' unless defined(&IXGBE_CRCERRS);
    eval 'sub IXGBE_ILLERRC () {0x4004;}' unless defined(&IXGBE_ILLERRC);
    eval 'sub IXGBE_ERRBC () {0x4008;}' unless defined(&IXGBE_ERRBC);
    eval 'sub IXGBE_MSPDC () {0x4010;}' unless defined(&IXGBE_MSPDC);
    eval 'sub IXGBE_MPC {
        my($_i) = @_;
	    eval q((0x3fa0 + (($_i) * 4)));
    }' unless defined(&IXGBE_MPC);
    eval 'sub IXGBE_MLFC () {0x4034;}' unless defined(&IXGBE_MLFC);
    eval 'sub IXGBE_MRFC () {0x4038;}' unless defined(&IXGBE_MRFC);
    eval 'sub IXGBE_RLEC () {0x4040;}' unless defined(&IXGBE_RLEC);
    eval 'sub IXGBE_LXONTXC () {0x3f60;}' unless defined(&IXGBE_LXONTXC);
    eval 'sub IXGBE_LXONRXC () {0xcf60;}' unless defined(&IXGBE_LXONRXC);
    eval 'sub IXGBE_LXOFFTXC () {0x3f68;}' unless defined(&IXGBE_LXOFFTXC);
    eval 'sub IXGBE_LXOFFRXC () {0xcf68;}' unless defined(&IXGBE_LXOFFRXC);
    eval 'sub IXGBE_LXONRXCNT () {0x41a4;}' unless defined(&IXGBE_LXONRXCNT);
    eval 'sub IXGBE_LXOFFRXCNT () {0x41a8;}' unless defined(&IXGBE_LXOFFRXCNT);
    eval 'sub IXGBE_PXONRXCNT {
        my($_i) = @_;
	    eval q((0x4140 + (($_i) * 4)));
    }' unless defined(&IXGBE_PXONRXCNT);
    eval 'sub IXGBE_PXOFFRXCNT {
        my($_i) = @_;
	    eval q((0x4160 + (($_i) * 4)));
    }' unless defined(&IXGBE_PXOFFRXCNT);
    eval 'sub IXGBE_PXON2OFFCNT {
        my($_i) = @_;
	    eval q((0x3240 + (($_i) * 4)));
    }' unless defined(&IXGBE_PXON2OFFCNT);
    eval 'sub IXGBE_PXONTXC {
        my($_i) = @_;
	    eval q((0x3f00 + (($_i) * 4)));
    }' unless defined(&IXGBE_PXONTXC);
    eval 'sub IXGBE_PXONRXC {
        my($_i) = @_;
	    eval q((0xcf00 + (($_i) * 4)));
    }' unless defined(&IXGBE_PXONRXC);
    eval 'sub IXGBE_PXOFFTXC {
        my($_i) = @_;
	    eval q((0x3f20 + (($_i) * 4)));
    }' unless defined(&IXGBE_PXOFFTXC);
    eval 'sub IXGBE_PXOFFRXC {
        my($_i) = @_;
	    eval q((0xcf20 + (($_i) * 4)));
    }' unless defined(&IXGBE_PXOFFRXC);
    eval 'sub IXGBE_PRC64 () {0x405c;}' unless defined(&IXGBE_PRC64);
    eval 'sub IXGBE_PRC127 () {0x4060;}' unless defined(&IXGBE_PRC127);
    eval 'sub IXGBE_PRC255 () {0x4064;}' unless defined(&IXGBE_PRC255);
    eval 'sub IXGBE_PRC511 () {0x4068;}' unless defined(&IXGBE_PRC511);
    eval 'sub IXGBE_PRC1023 () {0x406c;}' unless defined(&IXGBE_PRC1023);
    eval 'sub IXGBE_PRC1522 () {0x4070;}' unless defined(&IXGBE_PRC1522);
    eval 'sub IXGBE_GPRC () {0x4074;}' unless defined(&IXGBE_GPRC);
    eval 'sub IXGBE_BPRC () {0x4078;}' unless defined(&IXGBE_BPRC);
    eval 'sub IXGBE_MPRC () {0x407c;}' unless defined(&IXGBE_MPRC);
    eval 'sub IXGBE_GPTC () {0x4080;}' unless defined(&IXGBE_GPTC);
    eval 'sub IXGBE_GORCL () {0x4088;}' unless defined(&IXGBE_GORCL);
    eval 'sub IXGBE_GORCH () {0x408c;}' unless defined(&IXGBE_GORCH);
    eval 'sub IXGBE_GOTCL () {0x4090;}' unless defined(&IXGBE_GOTCL);
    eval 'sub IXGBE_GOTCH () {0x4094;}' unless defined(&IXGBE_GOTCH);
    eval 'sub IXGBE_RNBC {
        my($_i) = @_;
	    eval q((0x3fc0 + (($_i) * 4)));
    }' unless defined(&IXGBE_RNBC);
    eval 'sub IXGBE_RUC () {0x40a4;}' unless defined(&IXGBE_RUC);
    eval 'sub IXGBE_RFC () {0x40a8;}' unless defined(&IXGBE_RFC);
    eval 'sub IXGBE_ROC () {0x40ac;}' unless defined(&IXGBE_ROC);
    eval 'sub IXGBE_RJC () {0x40b0;}' unless defined(&IXGBE_RJC);
    eval 'sub IXGBE_MNGPRC () {0x40b4;}' unless defined(&IXGBE_MNGPRC);
    eval 'sub IXGBE_MNGPDC () {0x40b8;}' unless defined(&IXGBE_MNGPDC);
    eval 'sub IXGBE_MNGPTC () {0xcf90;}' unless defined(&IXGBE_MNGPTC);
    eval 'sub IXGBE_TORL () {0x40c0;}' unless defined(&IXGBE_TORL);
    eval 'sub IXGBE_TORH () {0x40c4;}' unless defined(&IXGBE_TORH);
    eval 'sub IXGBE_TPR () {0x40d0;}' unless defined(&IXGBE_TPR);
    eval 'sub IXGBE_TPT () {0x40d4;}' unless defined(&IXGBE_TPT);
    eval 'sub IXGBE_PTC64 () {0x40d8;}' unless defined(&IXGBE_PTC64);
    eval 'sub IXGBE_PTC127 () {0x40dc;}' unless defined(&IXGBE_PTC127);
    eval 'sub IXGBE_PTC255 () {0x40e0;}' unless defined(&IXGBE_PTC255);
    eval 'sub IXGBE_PTC511 () {0x40e4;}' unless defined(&IXGBE_PTC511);
    eval 'sub IXGBE_PTC1023 () {0x40e8;}' unless defined(&IXGBE_PTC1023);
    eval 'sub IXGBE_PTC1522 () {0x40ec;}' unless defined(&IXGBE_PTC1522);
    eval 'sub IXGBE_MPTC () {0x40f0;}' unless defined(&IXGBE_MPTC);
    eval 'sub IXGBE_BPTC () {0x40f4;}' unless defined(&IXGBE_BPTC);
    eval 'sub IXGBE_XEC () {0x4120;}' unless defined(&IXGBE_XEC);
    eval 'sub IXGBE_SSVPC () {0x8780;}' unless defined(&IXGBE_SSVPC);
    eval 'sub IXGBE_RQSMR {
        my($_i) = @_;
	    eval q((0x2300 + (($_i) * 4)));
    }' unless defined(&IXGBE_RQSMR);
    eval 'sub IXGBE_TQSMR {
        my($_i) = @_;
	    eval q(((($_i) <= 7) ? (0x7300 + (($_i) * 4)) : (0x8600 + (($_i) * 4))));
    }' unless defined(&IXGBE_TQSMR);
    eval 'sub IXGBE_TQSM {
        my($_i) = @_;
	    eval q((0x8600 + (($_i) * 4)));
    }' unless defined(&IXGBE_TQSM);
    eval 'sub IXGBE_QPRC {
        my($_i) = @_;
	    eval q((0x1030 + (($_i) * 0x40)));
    }' unless defined(&IXGBE_QPRC);
    eval 'sub IXGBE_QPTC {
        my($_i) = @_;
	    eval q((0x6030 + (($_i) * 0x40)));
    }' unless defined(&IXGBE_QPTC);
    eval 'sub IXGBE_QBRC {
        my($_i) = @_;
	    eval q((0x1034 + (($_i) * 0x40)));
    }' unless defined(&IXGBE_QBRC);
    eval 'sub IXGBE_QBTC {
        my($_i) = @_;
	    eval q((0x6034 + (($_i) * 0x40)));
    }' unless defined(&IXGBE_QBTC);
    eval 'sub IXGBE_QBRC_L {
        my($_i) = @_;
	    eval q((0x1034 + (($_i) * 0x40)));
    }' unless defined(&IXGBE_QBRC_L);
    eval 'sub IXGBE_QBRC_H {
        my($_i) = @_;
	    eval q((0x1038 + (($_i) * 0x40)));
    }' unless defined(&IXGBE_QBRC_H);
    eval 'sub IXGBE_QPRDC {
        my($_i) = @_;
	    eval q((0x1430 + (($_i) * 0x40)));
    }' unless defined(&IXGBE_QPRDC);
    eval 'sub IXGBE_QBTC_L {
        my($_i) = @_;
	    eval q((0x8700 + (($_i) * 0x8)));
    }' unless defined(&IXGBE_QBTC_L);
    eval 'sub IXGBE_QBTC_H {
        my($_i) = @_;
	    eval q((0x8704 + (($_i) * 0x8)));
    }' unless defined(&IXGBE_QBTC_H);
    eval 'sub IXGBE_FCCRC () {0x5118;}' unless defined(&IXGBE_FCCRC);
    eval 'sub IXGBE_FCOERPDC () {0x241c;}' unless defined(&IXGBE_FCOERPDC);
    eval 'sub IXGBE_FCLAST () {0x2424;}' unless defined(&IXGBE_FCLAST);
    eval 'sub IXGBE_FCOEPRC () {0x2428;}' unless defined(&IXGBE_FCOEPRC);
    eval 'sub IXGBE_FCOEDWRC () {0x242c;}' unless defined(&IXGBE_FCOEDWRC);
    eval 'sub IXGBE_FCOEPTC () {0x8784;}' unless defined(&IXGBE_FCOEPTC);
    eval 'sub IXGBE_FCOEDWTC () {0x8788;}' unless defined(&IXGBE_FCOEDWTC);
    eval 'sub IXGBE_FCCRC_CNT_MASK () {0xffff;}' unless defined(&IXGBE_FCCRC_CNT_MASK);
    eval 'sub IXGBE_FCLAST_CNT_MASK () {0xffff;}' unless defined(&IXGBE_FCLAST_CNT_MASK);
    eval 'sub IXGBE_O2BGPTC () {0x41c4;}' unless defined(&IXGBE_O2BGPTC);
    eval 'sub IXGBE_O2BSPC () {0x87b0;}' unless defined(&IXGBE_O2BSPC);
    eval 'sub IXGBE_B2OSPC () {0x41c0;}' unless defined(&IXGBE_B2OSPC);
    eval 'sub IXGBE_B2OGPRC () {0x2f90;}' unless defined(&IXGBE_B2OGPRC);
    eval 'sub IXGBE_BUPRC () {0x4180;}' unless defined(&IXGBE_BUPRC);
    eval 'sub IXGBE_BMPRC () {0x4184;}' unless defined(&IXGBE_BMPRC);
    eval 'sub IXGBE_BBPRC () {0x4188;}' unless defined(&IXGBE_BBPRC);
    eval 'sub IXGBE_BUPTC () {0x418c;}' unless defined(&IXGBE_BUPTC);
    eval 'sub IXGBE_BMPTC () {0x4190;}' unless defined(&IXGBE_BMPTC);
    eval 'sub IXGBE_BBPTC () {0x4194;}' unless defined(&IXGBE_BBPTC);
    eval 'sub IXGBE_BCRCERRS () {0x4198;}' unless defined(&IXGBE_BCRCERRS);
    eval 'sub IXGBE_BXONRXC () {0x419c;}' unless defined(&IXGBE_BXONRXC);
    eval 'sub IXGBE_BXOFFRXC () {0x41e0;}' unless defined(&IXGBE_BXOFFRXC);
    eval 'sub IXGBE_BXONTXC () {0x41e4;}' unless defined(&IXGBE_BXONTXC);
    eval 'sub IXGBE_BXOFFTXC () {0x41e8;}' unless defined(&IXGBE_BXOFFTXC);
    eval 'sub IXGBE_PCRC8ECL () {0xe810;}' unless defined(&IXGBE_PCRC8ECL);
    eval 'sub IXGBE_PCRC8ECH () {0xe811;}' unless defined(&IXGBE_PCRC8ECH);
    eval 'sub IXGBE_PCRC8ECH_MASK () {0x1f;}' unless defined(&IXGBE_PCRC8ECH_MASK);
    eval 'sub IXGBE_LDPCECL () {0xe820;}' unless defined(&IXGBE_LDPCECL);
    eval 'sub IXGBE_LDPCECH () {0xe821;}' unless defined(&IXGBE_LDPCECH);
    eval 'sub IXGBE_MAVTV {
        my($_i) = @_;
	    eval q((0x5010 + (($_i) * 4)));
    }' unless defined(&IXGBE_MAVTV);
    eval 'sub IXGBE_MFUTP {
        my($_i) = @_;
	    eval q((0x5030 + (($_i) * 4)));
    }' unless defined(&IXGBE_MFUTP);
    eval 'sub IXGBE_MANC () {0x5820;}' unless defined(&IXGBE_MANC);
    eval 'sub IXGBE_MFVAL () {0x5824;}' unless defined(&IXGBE_MFVAL);
    eval 'sub IXGBE_MANC2H () {0x5860;}' unless defined(&IXGBE_MANC2H);
    eval 'sub IXGBE_MDEF {
        my($_i) = @_;
	    eval q((0x5890 + (($_i) * 4)));
    }' unless defined(&IXGBE_MDEF);
    eval 'sub IXGBE_MIPAF () {0x58b0;}' unless defined(&IXGBE_MIPAF);
    eval 'sub IXGBE_MMAL {
        my($_i) = @_;
	    eval q((0x5910 + (($_i) * 8)));
    }' unless defined(&IXGBE_MMAL);
    eval 'sub IXGBE_MMAH {
        my($_i) = @_;
	    eval q((0x5914 + (($_i) * 8)));
    }' unless defined(&IXGBE_MMAH);
    eval 'sub IXGBE_FTFT () {0x9400;}' unless defined(&IXGBE_FTFT);
    eval 'sub IXGBE_METF {
        my($_i) = @_;
	    eval q((0x5190 + (($_i) * 4)));
    }' unless defined(&IXGBE_METF);
    eval 'sub IXGBE_MDEF_EXT {
        my($_i) = @_;
	    eval q((0x5160 + (($_i) * 4)));
    }' unless defined(&IXGBE_MDEF_EXT);
    eval 'sub IXGBE_LSWFW () {0x15014;}' unless defined(&IXGBE_LSWFW);
    eval 'sub IXGBE_HICR () {0x15f00;}' unless defined(&IXGBE_HICR);
    eval 'sub IXGBE_FWSTS () {0x15f0c;}' unless defined(&IXGBE_FWSTS);
    eval 'sub IXGBE_HSMC0R () {0x15f04;}' unless defined(&IXGBE_HSMC0R);
    eval 'sub IXGBE_HSMC1R () {0x15f08;}' unless defined(&IXGBE_HSMC1R);
    eval 'sub IXGBE_SWSR () {0x15f10;}' unless defined(&IXGBE_SWSR);
    eval 'sub IXGBE_HFDR () {0x15fe8;}' unless defined(&IXGBE_HFDR);
    eval 'sub IXGBE_FLEX_MNG () {0x15800;}' unless defined(&IXGBE_FLEX_MNG);
    eval 'sub IXGBE_GCR () {0x11000;}' unless defined(&IXGBE_GCR);
    eval 'sub IXGBE_GTV () {0x11004;}' unless defined(&IXGBE_GTV);
    eval 'sub IXGBE_FUNCTAG () {0x11008;}' unless defined(&IXGBE_FUNCTAG);
    eval 'sub IXGBE_GLT () {0x1100c;}' unless defined(&IXGBE_GLT);
    eval 'sub IXGBE_GSCL_1 () {0x11010;}' unless defined(&IXGBE_GSCL_1);
    eval 'sub IXGBE_GSCL_2 () {0x11014;}' unless defined(&IXGBE_GSCL_2);
    eval 'sub IXGBE_GSCL_3 () {0x11018;}' unless defined(&IXGBE_GSCL_3);
    eval 'sub IXGBE_GSCL_4 () {0x1101c;}' unless defined(&IXGBE_GSCL_4);
    eval 'sub IXGBE_GSCN_0 () {0x11020;}' unless defined(&IXGBE_GSCN_0);
    eval 'sub IXGBE_GSCN_1 () {0x11024;}' unless defined(&IXGBE_GSCN_1);
    eval 'sub IXGBE_GSCN_2 () {0x11028;}' unless defined(&IXGBE_GSCN_2);
    eval 'sub IXGBE_GSCN_3 () {0x1102c;}' unless defined(&IXGBE_GSCN_3);
    eval 'sub IXGBE_FACTPS () {0x10150;}' unless defined(&IXGBE_FACTPS);
    eval 'sub IXGBE_PCIEANACTL () {0x11040;}' unless defined(&IXGBE_PCIEANACTL);
    eval 'sub IXGBE_SWSM () {0x10140;}' unless defined(&IXGBE_SWSM);
    eval 'sub IXGBE_FWSM () {0x10148;}' unless defined(&IXGBE_FWSM);
    eval 'sub IXGBE_GSSR () {0x10160;}' unless defined(&IXGBE_GSSR);
    eval 'sub IXGBE_MREVID () {0x11064;}' unless defined(&IXGBE_MREVID);
    eval 'sub IXGBE_DCA_ID () {0x11070;}' unless defined(&IXGBE_DCA_ID);
    eval 'sub IXGBE_DCA_CTRL () {0x11074;}' unless defined(&IXGBE_DCA_CTRL);
    eval 'sub IXGBE_SWFW_SYNC () { &IXGBE_GSSR;}' unless defined(&IXGBE_SWFW_SYNC);
    eval 'sub IXGBE_GCR_EXT () {0x11050;}' unless defined(&IXGBE_GCR_EXT);
    eval 'sub IXGBE_GSCL_5_82599 () {0x11030;}' unless defined(&IXGBE_GSCL_5_82599);
    eval 'sub IXGBE_GSCL_6_82599 () {0x11034;}' unless defined(&IXGBE_GSCL_6_82599);
    eval 'sub IXGBE_GSCL_7_82599 () {0x11038;}' unless defined(&IXGBE_GSCL_7_82599);
    eval 'sub IXGBE_GSCL_8_82599 () {0x1103c;}' unless defined(&IXGBE_GSCL_8_82599);
    eval 'sub IXGBE_PHYADR_82599 () {0x11040;}' unless defined(&IXGBE_PHYADR_82599);
    eval 'sub IXGBE_PHYDAT_82599 () {0x11044;}' unless defined(&IXGBE_PHYDAT_82599);
    eval 'sub IXGBE_PHYCTL_82599 () {0x11048;}' unless defined(&IXGBE_PHYCTL_82599);
    eval 'sub IXGBE_PBACLR_82599 () {0x11068;}' unless defined(&IXGBE_PBACLR_82599);
    eval 'sub IXGBE_CIAA_82599 () {0x11088;}' unless defined(&IXGBE_CIAA_82599);
    eval 'sub IXGBE_CIAD_82599 () {0x1108c;}' unless defined(&IXGBE_CIAD_82599);
    eval 'sub IXGBE_INTRPT_CSR_82599 () {0x110b0;}' unless defined(&IXGBE_INTRPT_CSR_82599);
    eval 'sub IXGBE_INTRPT_MASK_82599 () {0x110b8;}' unless defined(&IXGBE_INTRPT_MASK_82599);
    eval 'sub IXGBE_CDQ_MBR_82599 () {0x110b4;}' unless defined(&IXGBE_CDQ_MBR_82599);
    eval 'sub IXGBE_MISC_REG_82599 () {0x110f0;}' unless defined(&IXGBE_MISC_REG_82599);
    eval 'sub IXGBE_ECC_CTRL_0_82599 () {0x11100;}' unless defined(&IXGBE_ECC_CTRL_0_82599);
    eval 'sub IXGBE_ECC_CTRL_1_82599 () {0x11104;}' unless defined(&IXGBE_ECC_CTRL_1_82599);
    eval 'sub IXGBE_ECC_STATUS_82599 () {0x110e0;}' unless defined(&IXGBE_ECC_STATUS_82599);
    eval 'sub IXGBE_BAR_CTRL_82599 () {0x110f4;}' unless defined(&IXGBE_BAR_CTRL_82599);
    eval 'sub IXGBE_GCR_CMPL_TMOUT_MASK () {0xf000;}' unless defined(&IXGBE_GCR_CMPL_TMOUT_MASK);
    eval 'sub IXGBE_GCR_CMPL_TMOUT_10ms () {0x1000;}' unless defined(&IXGBE_GCR_CMPL_TMOUT_10ms);
    eval 'sub IXGBE_GCR_CMPL_TMOUT_RESEND () {0x10000;}' unless defined(&IXGBE_GCR_CMPL_TMOUT_RESEND);
    eval 'sub IXGBE_GCR_CAP_VER2 () {0x40000;}' unless defined(&IXGBE_GCR_CAP_VER2);
    eval 'sub IXGBE_GCR_EXT_MSIX_EN () {0x80000000;}' unless defined(&IXGBE_GCR_EXT_MSIX_EN);
    eval 'sub IXGBE_GCR_EXT_VT_MODE_16 () {0x1;}' unless defined(&IXGBE_GCR_EXT_VT_MODE_16);
    eval 'sub IXGBE_GCR_EXT_VT_MODE_32 () {0x2;}' unless defined(&IXGBE_GCR_EXT_VT_MODE_32);
    eval 'sub IXGBE_GCR_EXT_VT_MODE_64 () {0x3;}' unless defined(&IXGBE_GCR_EXT_VT_MODE_64);
    eval 'sub IXGBE_GCR_EXT_SRIOV () {( &IXGBE_GCR_EXT_MSIX_EN |  &IXGBE_GCR_EXT_VT_MODE_64);}' unless defined(&IXGBE_GCR_EXT_SRIOV);
    eval 'sub IXGBE_TSYNCRXCTL () {0x5188;}' unless defined(&IXGBE_TSYNCRXCTL);
    eval 'sub IXGBE_TSYNCTXCTL () {0x8c00;}' unless defined(&IXGBE_TSYNCTXCTL);
    eval 'sub IXGBE_RXSTMPL () {0x51e8;}' unless defined(&IXGBE_RXSTMPL);
    eval 'sub IXGBE_RXSTMPH () {0x51a4;}' unless defined(&IXGBE_RXSTMPH);
    eval 'sub IXGBE_RXSATRL () {0x51a0;}' unless defined(&IXGBE_RXSATRL);
    eval 'sub IXGBE_RXSATRH () {0x51a8;}' unless defined(&IXGBE_RXSATRH);
    eval 'sub IXGBE_RXMTRL () {0x5120;}' unless defined(&IXGBE_RXMTRL);
    eval 'sub IXGBE_TXSTMPL () {0x8c04;}' unless defined(&IXGBE_TXSTMPL);
    eval 'sub IXGBE_TXSTMPH () {0x8c08;}' unless defined(&IXGBE_TXSTMPH);
    eval 'sub IXGBE_SYSTIML () {0x8c0c;}' unless defined(&IXGBE_SYSTIML);
    eval 'sub IXGBE_SYSTIMH () {0x8c10;}' unless defined(&IXGBE_SYSTIMH);
    eval 'sub IXGBE_TIMINCA () {0x8c14;}' unless defined(&IXGBE_TIMINCA);
    eval 'sub IXGBE_RXUDP () {0x8c1c;}' unless defined(&IXGBE_RXUDP);
    eval 'sub IXGBE_RDSTATCTL () {0x2c20;}' unless defined(&IXGBE_RDSTATCTL);
    eval 'sub IXGBE_RDSTAT {
        my($_i) = @_;
	    eval q((0x2c00 + (($_i) * 4)));
    }' unless defined(&IXGBE_RDSTAT);
    eval 'sub IXGBE_RDHMPN () {0x2f08;}' unless defined(&IXGBE_RDHMPN);
    eval 'sub IXGBE_RIC_DW {
        my($_i) = @_;
	    eval q((0x2f10 + (($_i) * 4)));
    }' unless defined(&IXGBE_RIC_DW);
    eval 'sub IXGBE_RDPROBE () {0x2f20;}' unless defined(&IXGBE_RDPROBE);
    eval 'sub IXGBE_RDMAM () {0x2f30;}' unless defined(&IXGBE_RDMAM);
    eval 'sub IXGBE_RDMAD () {0x2f34;}' unless defined(&IXGBE_RDMAD);
    eval 'sub IXGBE_TDSTATCTL () {0x7c20;}' unless defined(&IXGBE_TDSTATCTL);
    eval 'sub IXGBE_TDSTAT {
        my($_i) = @_;
	    eval q((0x7c00 + (($_i) * 4)));
    }' unless defined(&IXGBE_TDSTAT);
    eval 'sub IXGBE_TDHMPN () {0x7f08;}' unless defined(&IXGBE_TDHMPN);
    eval 'sub IXGBE_TDHMPN2 () {0x82fc;}' unless defined(&IXGBE_TDHMPN2);
    eval 'sub IXGBE_TXDESCIC () {0x82cc;}' unless defined(&IXGBE_TXDESCIC);
    eval 'sub IXGBE_TIC_DW {
        my($_i) = @_;
	    eval q((0x7f10 + (($_i) * 4)));
    }' unless defined(&IXGBE_TIC_DW);
    eval 'sub IXGBE_TIC_DW2 {
        my($_i) = @_;
	    eval q((0x82b0 + (($_i) * 4)));
    }' unless defined(&IXGBE_TIC_DW2);
    eval 'sub IXGBE_TDPROBE () {0x7f20;}' unless defined(&IXGBE_TDPROBE);
    eval 'sub IXGBE_TXBUFCTRL () {0xc600;}' unless defined(&IXGBE_TXBUFCTRL);
    eval 'sub IXGBE_TXBUFDATA0 () {0xc610;}' unless defined(&IXGBE_TXBUFDATA0);
    eval 'sub IXGBE_TXBUFDATA1 () {0xc614;}' unless defined(&IXGBE_TXBUFDATA1);
    eval 'sub IXGBE_TXBUFDATA2 () {0xc618;}' unless defined(&IXGBE_TXBUFDATA2);
    eval 'sub IXGBE_TXBUFDATA3 () {0xc61c;}' unless defined(&IXGBE_TXBUFDATA3);
    eval 'sub IXGBE_RXBUFCTRL () {0x3600;}' unless defined(&IXGBE_RXBUFCTRL);
    eval 'sub IXGBE_RXBUFDATA0 () {0x3610;}' unless defined(&IXGBE_RXBUFDATA0);
    eval 'sub IXGBE_RXBUFDATA1 () {0x3614;}' unless defined(&IXGBE_RXBUFDATA1);
    eval 'sub IXGBE_RXBUFDATA2 () {0x3618;}' unless defined(&IXGBE_RXBUFDATA2);
    eval 'sub IXGBE_RXBUFDATA3 () {0x361c;}' unless defined(&IXGBE_RXBUFDATA3);
    eval 'sub IXGBE_PCIE_DIAG {
        my($_i) = @_;
	    eval q((0x11090 + (($_i) * 4)));
    }' unless defined(&IXGBE_PCIE_DIAG);
    eval 'sub IXGBE_RFVAL () {0x50a4;}' unless defined(&IXGBE_RFVAL);
    eval 'sub IXGBE_MDFTC1 () {0x42b8;}' unless defined(&IXGBE_MDFTC1);
    eval 'sub IXGBE_MDFTC2 () {0x42c0;}' unless defined(&IXGBE_MDFTC2);
    eval 'sub IXGBE_MDFTFIFO1 () {0x42c4;}' unless defined(&IXGBE_MDFTFIFO1);
    eval 'sub IXGBE_MDFTFIFO2 () {0x42c8;}' unless defined(&IXGBE_MDFTFIFO2);
    eval 'sub IXGBE_MDFTS () {0x42cc;}' unless defined(&IXGBE_MDFTS);
    eval 'sub IXGBE_RXDATAWRPTR {
        my($_i) = @_;
	    eval q((0x3700 + (($_i) * 4)));
    }' unless defined(&IXGBE_RXDATAWRPTR);
    eval 'sub IXGBE_RXDESCWRPTR {
        my($_i) = @_;
	    eval q((0x3710 + (($_i) * 4)));
    }' unless defined(&IXGBE_RXDESCWRPTR);
    eval 'sub IXGBE_RXDATARDPTR {
        my($_i) = @_;
	    eval q((0x3720 + (($_i) * 4)));
    }' unless defined(&IXGBE_RXDATARDPTR);
    eval 'sub IXGBE_RXDESCRDPTR {
        my($_i) = @_;
	    eval q((0x3730 + (($_i) * 4)));
    }' unless defined(&IXGBE_RXDESCRDPTR);
    eval 'sub IXGBE_TXDATAWRPTR {
        my($_i) = @_;
	    eval q((0xc700 + (($_i) * 4)));
    }' unless defined(&IXGBE_TXDATAWRPTR);
    eval 'sub IXGBE_TXDESCWRPTR {
        my($_i) = @_;
	    eval q((0xc710 + (($_i) * 4)));
    }' unless defined(&IXGBE_TXDESCWRPTR);
    eval 'sub IXGBE_TXDATARDPTR {
        my($_i) = @_;
	    eval q((0xc720 + (($_i) * 4)));
    }' unless defined(&IXGBE_TXDATARDPTR);
    eval 'sub IXGBE_TXDESCRDPTR {
        my($_i) = @_;
	    eval q((0xc730 + (($_i) * 4)));
    }' unless defined(&IXGBE_TXDESCRDPTR);
    eval 'sub IXGBE_PCIEECCCTL () {0x1106c;}' unless defined(&IXGBE_PCIEECCCTL);
    eval 'sub IXGBE_RXWRPTR {
        my($_i) = @_;
	    eval q((0x3100 + (($_i) * 4)));
    }' unless defined(&IXGBE_RXWRPTR);
    eval 'sub IXGBE_RXUSED {
        my($_i) = @_;
	    eval q((0x3120 + (($_i) * 4)));
    }' unless defined(&IXGBE_RXUSED);
    eval 'sub IXGBE_RXRDPTR {
        my($_i) = @_;
	    eval q((0x3140 + (($_i) * 4)));
    }' unless defined(&IXGBE_RXRDPTR);
    eval 'sub IXGBE_RXRDWRPTR {
        my($_i) = @_;
	    eval q((0x3160 + (($_i) * 4)));
    }' unless defined(&IXGBE_RXRDWRPTR);
    eval 'sub IXGBE_TXWRPTR {
        my($_i) = @_;
	    eval q((0xc100 + (($_i) * 4)));
    }' unless defined(&IXGBE_TXWRPTR);
    eval 'sub IXGBE_TXUSED {
        my($_i) = @_;
	    eval q((0xc120 + (($_i) * 4)));
    }' unless defined(&IXGBE_TXUSED);
    eval 'sub IXGBE_TXRDPTR {
        my($_i) = @_;
	    eval q((0xc140 + (($_i) * 4)));
    }' unless defined(&IXGBE_TXRDPTR);
    eval 'sub IXGBE_TXRDWRPTR {
        my($_i) = @_;
	    eval q((0xc160 + (($_i) * 4)));
    }' unless defined(&IXGBE_TXRDWRPTR);
    eval 'sub IXGBE_PCIEECCCTL0 () {0x11100;}' unless defined(&IXGBE_PCIEECCCTL0);
    eval 'sub IXGBE_PCIEECCCTL1 () {0x11104;}' unless defined(&IXGBE_PCIEECCCTL1);
    eval 'sub IXGBE_RXDBUECC () {0x3f70;}' unless defined(&IXGBE_RXDBUECC);
    eval 'sub IXGBE_TXDBUECC () {0xcf70;}' unless defined(&IXGBE_TXDBUECC);
    eval 'sub IXGBE_RXDBUEST () {0x3f74;}' unless defined(&IXGBE_RXDBUEST);
    eval 'sub IXGBE_TXDBUEST () {0xcf74;}' unless defined(&IXGBE_TXDBUEST);
    eval 'sub IXGBE_PBTXECC () {0xc300;}' unless defined(&IXGBE_PBTXECC);
    eval 'sub IXGBE_PBRXECC () {0x3300;}' unless defined(&IXGBE_PBRXECC);
    eval 'sub IXGBE_GHECCR () {0x110b0;}' unless defined(&IXGBE_GHECCR);
    eval 'sub IXGBE_PCS1GCFIG () {0x4200;}' unless defined(&IXGBE_PCS1GCFIG);
    eval 'sub IXGBE_PCS1GLCTL () {0x4208;}' unless defined(&IXGBE_PCS1GLCTL);
    eval 'sub IXGBE_PCS1GLSTA () {0x420c;}' unless defined(&IXGBE_PCS1GLSTA);
    eval 'sub IXGBE_PCS1GDBG0 () {0x4210;}' unless defined(&IXGBE_PCS1GDBG0);
    eval 'sub IXGBE_PCS1GDBG1 () {0x4214;}' unless defined(&IXGBE_PCS1GDBG1);
    eval 'sub IXGBE_PCS1GANA () {0x4218;}' unless defined(&IXGBE_PCS1GANA);
    eval 'sub IXGBE_PCS1GANLP () {0x421c;}' unless defined(&IXGBE_PCS1GANLP);
    eval 'sub IXGBE_PCS1GANNP () {0x4220;}' unless defined(&IXGBE_PCS1GANNP);
    eval 'sub IXGBE_PCS1GANLPNP () {0x4224;}' unless defined(&IXGBE_PCS1GANLPNP);
    eval 'sub IXGBE_HLREG0 () {0x4240;}' unless defined(&IXGBE_HLREG0);
    eval 'sub IXGBE_HLREG1 () {0x4244;}' unless defined(&IXGBE_HLREG1);
    eval 'sub IXGBE_PAP () {0x4248;}' unless defined(&IXGBE_PAP);
    eval 'sub IXGBE_MACA () {0x424c;}' unless defined(&IXGBE_MACA);
    eval 'sub IXGBE_APAE () {0x4250;}' unless defined(&IXGBE_APAE);
    eval 'sub IXGBE_ARD () {0x4254;}' unless defined(&IXGBE_ARD);
    eval 'sub IXGBE_AIS () {0x4258;}' unless defined(&IXGBE_AIS);
    eval 'sub IXGBE_MSCA () {0x425c;}' unless defined(&IXGBE_MSCA);
    eval 'sub IXGBE_MSRWD () {0x4260;}' unless defined(&IXGBE_MSRWD);
    eval 'sub IXGBE_MLADD () {0x4264;}' unless defined(&IXGBE_MLADD);
    eval 'sub IXGBE_MHADD () {0x4268;}' unless defined(&IXGBE_MHADD);
    eval 'sub IXGBE_MAXFRS () {0x4268;}' unless defined(&IXGBE_MAXFRS);
    eval 'sub IXGBE_TREG () {0x426c;}' unless defined(&IXGBE_TREG);
    eval 'sub IXGBE_PCSS1 () {0x4288;}' unless defined(&IXGBE_PCSS1);
    eval 'sub IXGBE_PCSS2 () {0x428c;}' unless defined(&IXGBE_PCSS2);
    eval 'sub IXGBE_XPCSS () {0x4290;}' unless defined(&IXGBE_XPCSS);
    eval 'sub IXGBE_MFLCN () {0x4294;}' unless defined(&IXGBE_MFLCN);
    eval 'sub IXGBE_SERDESC () {0x4298;}' unless defined(&IXGBE_SERDESC);
    eval 'sub IXGBE_MACS () {0x429c;}' unless defined(&IXGBE_MACS);
    eval 'sub IXGBE_AUTOC () {0x42a0;}' unless defined(&IXGBE_AUTOC);
    eval 'sub IXGBE_LINKS () {0x42a4;}' unless defined(&IXGBE_LINKS);
    eval 'sub IXGBE_LINKS2 () {0x4324;}' unless defined(&IXGBE_LINKS2);
    eval 'sub IXGBE_AUTOC2 () {0x42a8;}' unless defined(&IXGBE_AUTOC2);
    eval 'sub IXGBE_AUTOC3 () {0x42ac;}' unless defined(&IXGBE_AUTOC3);
    eval 'sub IXGBE_ANLP1 () {0x42b0;}' unless defined(&IXGBE_ANLP1);
    eval 'sub IXGBE_ANLP2 () {0x42b4;}' unless defined(&IXGBE_ANLP2);
    eval 'sub IXGBE_MACC () {0x4330;}' unless defined(&IXGBE_MACC);
    eval 'sub IXGBE_ATLASCTL () {0x4800;}' unless defined(&IXGBE_ATLASCTL);
    eval 'sub IXGBE_MMNGC () {0x42d0;}' unless defined(&IXGBE_MMNGC);
    eval 'sub IXGBE_ANLPNP1 () {0x42d4;}' unless defined(&IXGBE_ANLPNP1);
    eval 'sub IXGBE_ANLPNP2 () {0x42d8;}' unless defined(&IXGBE_ANLPNP2);
    eval 'sub IXGBE_KRPCSFC () {0x42e0;}' unless defined(&IXGBE_KRPCSFC);
    eval 'sub IXGBE_KRPCSS () {0x42e4;}' unless defined(&IXGBE_KRPCSS);
    eval 'sub IXGBE_FECS1 () {0x42e8;}' unless defined(&IXGBE_FECS1);
    eval 'sub IXGBE_FECS2 () {0x42ec;}' unless defined(&IXGBE_FECS2);
    eval 'sub IXGBE_SMADARCTL () {0x14f10;}' unless defined(&IXGBE_SMADARCTL);
    eval 'sub IXGBE_MPVC () {0x4318;}' unless defined(&IXGBE_MPVC);
    eval 'sub IXGBE_SGMIIC () {0x4314;}' unless defined(&IXGBE_SGMIIC);
    eval 'sub IXGBE_VALIDATE_LINK_READY_TIMEOUT () {50;}' unless defined(&IXGBE_VALIDATE_LINK_READY_TIMEOUT);
    eval 'sub IXGBE_CORECTL () {0x14f00;}' unless defined(&IXGBE_CORECTL);
    eval 'sub IXGBE_BARCTRL () {0x110f4;}' unless defined(&IXGBE_BARCTRL);
    eval 'sub IXGBE_BARCTRL_FLSIZE () {0x700;}' unless defined(&IXGBE_BARCTRL_FLSIZE);
    eval 'sub IXGBE_BARCTRL_FLSIZE_SHIFT () {8;}' unless defined(&IXGBE_BARCTRL_FLSIZE_SHIFT);
    eval 'sub IXGBE_BARCTRL_CSRSIZE () {0x2000;}' unless defined(&IXGBE_BARCTRL_CSRSIZE);
    eval 'sub IXGBE_RSCCTL_RSCEN () {0x1;}' unless defined(&IXGBE_RSCCTL_RSCEN);
    eval 'sub IXGBE_RSCCTL_MAXDESC_1 () {0x;}' unless defined(&IXGBE_RSCCTL_MAXDESC_1);
    eval 'sub IXGBE_RSCCTL_MAXDESC_4 () {0x4;}' unless defined(&IXGBE_RSCCTL_MAXDESC_4);
    eval 'sub IXGBE_RSCCTL_MAXDESC_8 () {0x8;}' unless defined(&IXGBE_RSCCTL_MAXDESC_8);
    eval 'sub IXGBE_RSCCTL_MAXDESC_16 () {0xc;}' unless defined(&IXGBE_RSCCTL_MAXDESC_16);
    eval 'sub IXGBE_RSCDBU_RSCSMALDIS_MASK () {0x7f;}' unless defined(&IXGBE_RSCDBU_RSCSMALDIS_MASK);
    eval 'sub IXGBE_RSCDBU_RSCACKDIS () {0x80;}' unless defined(&IXGBE_RSCDBU_RSCACKDIS);
    eval 'sub IXGBE_RDRXCTL_RDMTS_1_2 () {0x;}' unless defined(&IXGBE_RDRXCTL_RDMTS_1_2);
    eval 'sub IXGBE_RDRXCTL_CRCSTRIP () {0x2;}' unless defined(&IXGBE_RDRXCTL_CRCSTRIP);
    eval 'sub IXGBE_RDRXCTL_MVMEN () {0x20;}' unless defined(&IXGBE_RDRXCTL_MVMEN);
    eval 'sub IXGBE_RDRXCTL_DMAIDONE () {0x8;}' unless defined(&IXGBE_RDRXCTL_DMAIDONE);
    eval 'sub IXGBE_RDRXCTL_AGGDIS () {0x10000;}' unless defined(&IXGBE_RDRXCTL_AGGDIS);
    eval 'sub IXGBE_RDRXCTL_RSCFRSTSIZE () {0x3e0000;}' unless defined(&IXGBE_RDRXCTL_RSCFRSTSIZE);
    eval 'sub IXGBE_RDRXCTL_RSCLLIDIS () {0x800000;}' unless defined(&IXGBE_RDRXCTL_RSCLLIDIS);
    eval 'sub IXGBE_RDRXCTL_RSCACKC () {0x2000000;}' unless defined(&IXGBE_RDRXCTL_RSCACKC);
    eval 'sub IXGBE_RDRXCTL_FCOE_WRFIX () {0x4000000;}' unless defined(&IXGBE_RDRXCTL_FCOE_WRFIX);
    eval 'sub IXGBE_RQTC_SHIFT_TC {
        my($_i) = @_;
	    eval q((($_i) * 4));
    }' unless defined(&IXGBE_RQTC_SHIFT_TC);
    eval 'sub IXGBE_RQTC_TC0_MASK () {(0x7 << 0);}' unless defined(&IXGBE_RQTC_TC0_MASK);
    eval 'sub IXGBE_RQTC_TC1_MASK () {(0x7 << 4);}' unless defined(&IXGBE_RQTC_TC1_MASK);
    eval 'sub IXGBE_RQTC_TC2_MASK () {(0x7 << 8);}' unless defined(&IXGBE_RQTC_TC2_MASK);
    eval 'sub IXGBE_RQTC_TC3_MASK () {(0x7 << 12);}' unless defined(&IXGBE_RQTC_TC3_MASK);
    eval 'sub IXGBE_RQTC_TC4_MASK () {(0x7 << 16);}' unless defined(&IXGBE_RQTC_TC4_MASK);
    eval 'sub IXGBE_RQTC_TC5_MASK () {(0x7 << 20);}' unless defined(&IXGBE_RQTC_TC5_MASK);
    eval 'sub IXGBE_RQTC_TC6_MASK () {(0x7 << 24);}' unless defined(&IXGBE_RQTC_TC6_MASK);
    eval 'sub IXGBE_RQTC_TC7_MASK () {(0x7 << 28);}' unless defined(&IXGBE_RQTC_TC7_MASK);
    eval 'sub IXGBE_PSRTYPE_RQPL_MASK () {0x7;}' unless defined(&IXGBE_PSRTYPE_RQPL_MASK);
    eval 'sub IXGBE_PSRTYPE_RQPL_SHIFT () {29;}' unless defined(&IXGBE_PSRTYPE_RQPL_SHIFT);
    eval 'sub IXGBE_CTRL_GIO_DIS () {0x4;}' unless defined(&IXGBE_CTRL_GIO_DIS);
    eval 'sub IXGBE_CTRL_LNK_RST () {0x8;}' unless defined(&IXGBE_CTRL_LNK_RST);
    eval 'sub IXGBE_CTRL_RST () {0x4000000;}' unless defined(&IXGBE_CTRL_RST);
    eval 'sub IXGBE_CTRL_RST_MASK () {( &IXGBE_CTRL_LNK_RST |  &IXGBE_CTRL_RST);}' unless defined(&IXGBE_CTRL_RST_MASK);
    eval 'sub IXGBE_FACTPS_LFS () {0x40000000;}' unless defined(&IXGBE_FACTPS_LFS);
    eval 'sub IXGBE_MHADD_MFS_MASK () {0xffff0000;}' unless defined(&IXGBE_MHADD_MFS_MASK);
    eval 'sub IXGBE_MHADD_MFS_SHIFT () {16;}' unless defined(&IXGBE_MHADD_MFS_SHIFT);
    eval 'sub IXGBE_CTRL_EXT_PFRSTD () {0x4000;}' unless defined(&IXGBE_CTRL_EXT_PFRSTD);
    eval 'sub IXGBE_CTRL_EXT_NS_DIS () {0x10000;}' unless defined(&IXGBE_CTRL_EXT_NS_DIS);
    eval 'sub IXGBE_CTRL_EXT_RO_DIS () {0x20000;}' unless defined(&IXGBE_CTRL_EXT_RO_DIS);
    eval 'sub IXGBE_CTRL_EXT_DRV_LOAD () {0x10000000;}' unless defined(&IXGBE_CTRL_EXT_DRV_LOAD);
    eval 'sub IXGBE_DCA_CTRL_DCA_ENABLE () {0x;}' unless defined(&IXGBE_DCA_CTRL_DCA_ENABLE);
    eval 'sub IXGBE_DCA_CTRL_DCA_DISABLE () {0x1;}' unless defined(&IXGBE_DCA_CTRL_DCA_DISABLE);
    eval 'sub IXGBE_DCA_CTRL_DCA_MODE_CB1 () {0x;}' unless defined(&IXGBE_DCA_CTRL_DCA_MODE_CB1);
    eval 'sub IXGBE_DCA_CTRL_DCA_MODE_CB2 () {0x2;}' unless defined(&IXGBE_DCA_CTRL_DCA_MODE_CB2);
    eval 'sub IXGBE_DCA_RXCTRL_CPUID_MASK () {0x1f;}' unless defined(&IXGBE_DCA_RXCTRL_CPUID_MASK);
    eval 'sub IXGBE_DCA_RXCTRL_CPUID_MASK_82599 () {0xff000000;}' unless defined(&IXGBE_DCA_RXCTRL_CPUID_MASK_82599);
    eval 'sub IXGBE_DCA_RXCTRL_CPUID_SHIFT_82599 () {24;}' unless defined(&IXGBE_DCA_RXCTRL_CPUID_SHIFT_82599);
    eval 'sub IXGBE_DCA_RXCTRL_DESC_DCA_EN () {(1<< 5);}' unless defined(&IXGBE_DCA_RXCTRL_DESC_DCA_EN);
    eval 'sub IXGBE_DCA_RXCTRL_HEAD_DCA_EN () {(1<< 6);}' unless defined(&IXGBE_DCA_RXCTRL_HEAD_DCA_EN);
    eval 'sub IXGBE_DCA_RXCTRL_DATA_DCA_EN () {(1<< 7);}' unless defined(&IXGBE_DCA_RXCTRL_DATA_DCA_EN);
    eval 'sub IXGBE_DCA_RXCTRL_DESC_RRO_EN () {(1<< 9);}' unless defined(&IXGBE_DCA_RXCTRL_DESC_RRO_EN);
    eval 'sub IXGBE_DCA_RXCTRL_DESC_WRO_EN () {(1<< 13);}' unless defined(&IXGBE_DCA_RXCTRL_DESC_WRO_EN);
    eval 'sub IXGBE_DCA_RXCTRL_DESC_HSRO_EN () {(1<< 15);}' unless defined(&IXGBE_DCA_RXCTRL_DESC_HSRO_EN);
    eval 'sub IXGBE_DCA_TXCTRL_CPUID_MASK () {0x1f;}' unless defined(&IXGBE_DCA_TXCTRL_CPUID_MASK);
    eval 'sub IXGBE_DCA_TXCTRL_CPUID_MASK_82599 () {0xff000000;}' unless defined(&IXGBE_DCA_TXCTRL_CPUID_MASK_82599);
    eval 'sub IXGBE_DCA_TXCTRL_CPUID_SHIFT_82599 () {24;}' unless defined(&IXGBE_DCA_TXCTRL_CPUID_SHIFT_82599);
    eval 'sub IXGBE_DCA_TXCTRL_DESC_DCA_EN () {(1<< 5);}' unless defined(&IXGBE_DCA_TXCTRL_DESC_DCA_EN);
    eval 'sub IXGBE_DCA_TXCTRL_TX_WB_RO_EN () {(1<< 11);}' unless defined(&IXGBE_DCA_TXCTRL_TX_WB_RO_EN);
    eval 'sub IXGBE_DCA_MAX_QUEUES_82598 () {16;}' unless defined(&IXGBE_DCA_MAX_QUEUES_82598);
    eval 'sub IXGBE_MSCA_NP_ADDR_MASK () {0xffff;}' unless defined(&IXGBE_MSCA_NP_ADDR_MASK);
    eval 'sub IXGBE_MSCA_NP_ADDR_SHIFT () {0;}' unless defined(&IXGBE_MSCA_NP_ADDR_SHIFT);
    eval 'sub IXGBE_MSCA_DEV_TYPE_MASK () {0x1f0000;}' unless defined(&IXGBE_MSCA_DEV_TYPE_MASK);
    eval 'sub IXGBE_MSCA_DEV_TYPE_SHIFT () {16;}' unless defined(&IXGBE_MSCA_DEV_TYPE_SHIFT);
    eval 'sub IXGBE_MSCA_PHY_ADDR_MASK () {0x3e00000;}' unless defined(&IXGBE_MSCA_PHY_ADDR_MASK);
    eval 'sub IXGBE_MSCA_PHY_ADDR_SHIFT () {21;}' unless defined(&IXGBE_MSCA_PHY_ADDR_SHIFT);
    eval 'sub IXGBE_MSCA_OP_CODE_MASK () {0xc000000;}' unless defined(&IXGBE_MSCA_OP_CODE_MASK);
    eval 'sub IXGBE_MSCA_OP_CODE_SHIFT () {26;}' unless defined(&IXGBE_MSCA_OP_CODE_SHIFT);
    eval 'sub IXGBE_MSCA_ADDR_CYCLE () {0x;}' unless defined(&IXGBE_MSCA_ADDR_CYCLE);
    eval 'sub IXGBE_MSCA_WRITE () {0x4000000;}' unless defined(&IXGBE_MSCA_WRITE);
    eval 'sub IXGBE_MSCA_READ () {0xc000000;}' unless defined(&IXGBE_MSCA_READ);
    eval 'sub IXGBE_MSCA_READ_AUTOINC () {0x8000000;}' unless defined(&IXGBE_MSCA_READ_AUTOINC);
    eval 'sub IXGBE_MSCA_ST_CODE_MASK () {0x30000000;}' unless defined(&IXGBE_MSCA_ST_CODE_MASK);
    eval 'sub IXGBE_MSCA_ST_CODE_SHIFT () {28;}' unless defined(&IXGBE_MSCA_ST_CODE_SHIFT);
    eval 'sub IXGBE_MSCA_NEW_PROTOCOL () {0x;}' unless defined(&IXGBE_MSCA_NEW_PROTOCOL);
    eval 'sub IXGBE_MSCA_OLD_PROTOCOL () {0x10000000;}' unless defined(&IXGBE_MSCA_OLD_PROTOCOL);
    eval 'sub IXGBE_MSCA_MDI_COMMAND () {0x40000000;}' unless defined(&IXGBE_MSCA_MDI_COMMAND);
    eval 'sub IXGBE_MSCA_MDI_IN_PROG_EN () {0x80000000;}' unless defined(&IXGBE_MSCA_MDI_IN_PROG_EN);
    eval 'sub IXGBE_MSRWD_WRITE_DATA_MASK () {0xffff;}' unless defined(&IXGBE_MSRWD_WRITE_DATA_MASK);
    eval 'sub IXGBE_MSRWD_WRITE_DATA_SHIFT () {0;}' unless defined(&IXGBE_MSRWD_WRITE_DATA_SHIFT);
    eval 'sub IXGBE_MSRWD_READ_DATA_MASK () {0xffff0000;}' unless defined(&IXGBE_MSRWD_READ_DATA_MASK);
    eval 'sub IXGBE_MSRWD_READ_DATA_SHIFT () {16;}' unless defined(&IXGBE_MSRWD_READ_DATA_SHIFT);
    eval 'sub IXGBE_ATLAS_PDN_LPBK () {0x24;}' unless defined(&IXGBE_ATLAS_PDN_LPBK);
    eval 'sub IXGBE_ATLAS_PDN_10G () {0xb;}' unless defined(&IXGBE_ATLAS_PDN_10G);
    eval 'sub IXGBE_ATLAS_PDN_1G () {0xc;}' unless defined(&IXGBE_ATLAS_PDN_1G);
    eval 'sub IXGBE_ATLAS_PDN_AN () {0xd;}' unless defined(&IXGBE_ATLAS_PDN_AN);
    eval 'sub IXGBE_ATLASCTL_WRITE_CMD () {0x10000;}' unless defined(&IXGBE_ATLASCTL_WRITE_CMD);
    eval 'sub IXGBE_ATLAS_PDN_TX_REG_EN () {0x10;}' unless defined(&IXGBE_ATLAS_PDN_TX_REG_EN);
    eval 'sub IXGBE_ATLAS_PDN_TX_10G_QL_ALL () {0xf0;}' unless defined(&IXGBE_ATLAS_PDN_TX_10G_QL_ALL);
    eval 'sub IXGBE_ATLAS_PDN_TX_1G_QL_ALL () {0xf0;}' unless defined(&IXGBE_ATLAS_PDN_TX_1G_QL_ALL);
    eval 'sub IXGBE_ATLAS_PDN_TX_AN_QL_ALL () {0xf0;}' unless defined(&IXGBE_ATLAS_PDN_TX_AN_QL_ALL);
    eval 'sub IXGBE_CORECTL_WRITE_CMD () {0x10000;}' unless defined(&IXGBE_CORECTL_WRITE_CMD);
    eval 'sub IXGBE_MDIO_PMA_PMD_DEV_TYPE () {0x1;}' unless defined(&IXGBE_MDIO_PMA_PMD_DEV_TYPE);
    eval 'sub IXGBE_MDIO_PCS_DEV_TYPE () {0x3;}' unless defined(&IXGBE_MDIO_PCS_DEV_TYPE);
    eval 'sub IXGBE_MDIO_PHY_XS_DEV_TYPE () {0x4;}' unless defined(&IXGBE_MDIO_PHY_XS_DEV_TYPE);
    eval 'sub IXGBE_MDIO_AUTO_NEG_DEV_TYPE () {0x7;}' unless defined(&IXGBE_MDIO_AUTO_NEG_DEV_TYPE);
    eval 'sub IXGBE_MDIO_VENDOR_SPECIFIC_1_DEV_TYPE () {0x1e;}' unless defined(&IXGBE_MDIO_VENDOR_SPECIFIC_1_DEV_TYPE);
    eval 'sub IXGBE_TWINAX_DEV () {1;}' unless defined(&IXGBE_TWINAX_DEV);
    eval 'sub IXGBE_MDIO_COMMAND_TIMEOUT () {100;}' unless defined(&IXGBE_MDIO_COMMAND_TIMEOUT);
    eval 'sub IXGBE_MDIO_VENDOR_SPECIFIC_1_CONTROL () {0x;}' unless defined(&IXGBE_MDIO_VENDOR_SPECIFIC_1_CONTROL);
    eval 'sub IXGBE_MDIO_VENDOR_SPECIFIC_1_STATUS () {0x1;}' unless defined(&IXGBE_MDIO_VENDOR_SPECIFIC_1_STATUS);
    eval 'sub IXGBE_MDIO_VENDOR_SPECIFIC_1_LINK_STATUS () {0x8;}' unless defined(&IXGBE_MDIO_VENDOR_SPECIFIC_1_LINK_STATUS);
    eval 'sub IXGBE_MDIO_VENDOR_SPECIFIC_1_SPEED_STATUS () {0x10;}' unless defined(&IXGBE_MDIO_VENDOR_SPECIFIC_1_SPEED_STATUS);
    eval 'sub IXGBE_MDIO_VENDOR_SPECIFIC_1_10G_SPEED () {0x18;}' unless defined(&IXGBE_MDIO_VENDOR_SPECIFIC_1_10G_SPEED);
    eval 'sub IXGBE_MDIO_VENDOR_SPECIFIC_1_1G_SPEED () {0x10;}' unless defined(&IXGBE_MDIO_VENDOR_SPECIFIC_1_1G_SPEED);
    eval 'sub IXGBE_MDIO_AUTO_NEG_CONTROL () {0x;}' unless defined(&IXGBE_MDIO_AUTO_NEG_CONTROL);
    eval 'sub IXGBE_MDIO_AUTO_NEG_STATUS () {0x1;}' unless defined(&IXGBE_MDIO_AUTO_NEG_STATUS);
    eval 'sub IXGBE_MDIO_AUTO_NEG_ADVT () {0x10;}' unless defined(&IXGBE_MDIO_AUTO_NEG_ADVT);
    eval 'sub IXGBE_MDIO_AUTO_NEG_LP () {0x13;}' unless defined(&IXGBE_MDIO_AUTO_NEG_LP);
    eval 'sub IXGBE_MDIO_PHY_XS_CONTROL () {0x;}' unless defined(&IXGBE_MDIO_PHY_XS_CONTROL);
    eval 'sub IXGBE_MDIO_PHY_XS_RESET () {0x8000;}' unless defined(&IXGBE_MDIO_PHY_XS_RESET);
    eval 'sub IXGBE_MDIO_PHY_ID_HIGH () {0x2;}' unless defined(&IXGBE_MDIO_PHY_ID_HIGH);
    eval 'sub IXGBE_MDIO_PHY_ID_LOW () {0x3;}' unless defined(&IXGBE_MDIO_PHY_ID_LOW);
    eval 'sub IXGBE_MDIO_PHY_SPEED_ABILITY () {0x4;}' unless defined(&IXGBE_MDIO_PHY_SPEED_ABILITY);
    eval 'sub IXGBE_MDIO_PHY_SPEED_10G () {0x1;}' unless defined(&IXGBE_MDIO_PHY_SPEED_10G);
    eval 'sub IXGBE_MDIO_PHY_SPEED_1G () {0x10;}' unless defined(&IXGBE_MDIO_PHY_SPEED_1G);
    eval 'sub IXGBE_MDIO_PHY_SPEED_100M () {0x20;}' unless defined(&IXGBE_MDIO_PHY_SPEED_100M);
    eval 'sub IXGBE_MDIO_PHY_EXT_ABILITY () {0xb;}' unless defined(&IXGBE_MDIO_PHY_EXT_ABILITY);
    eval 'sub IXGBE_MDIO_PHY_10GBASET_ABILITY () {0x4;}' unless defined(&IXGBE_MDIO_PHY_10GBASET_ABILITY);
    eval 'sub IXGBE_MDIO_PHY_1000BASET_ABILITY () {0x20;}' unless defined(&IXGBE_MDIO_PHY_1000BASET_ABILITY);
    eval 'sub IXGBE_MDIO_PHY_100BASETX_ABILITY () {0x80;}' unless defined(&IXGBE_MDIO_PHY_100BASETX_ABILITY);
    eval 'sub IXGBE_MDIO_PHY_SET_LOW_POWER_MODE () {0x800;}' unless defined(&IXGBE_MDIO_PHY_SET_LOW_POWER_MODE);
    eval 'sub IXGBE_MDIO_PMA_PMD_CONTROL_ADDR () {0x;}' unless defined(&IXGBE_MDIO_PMA_PMD_CONTROL_ADDR);
    eval 'sub IXGBE_MDIO_PMA_PMD_SDA_SCL_ADDR () {0xc30a;}' unless defined(&IXGBE_MDIO_PMA_PMD_SDA_SCL_ADDR);
    eval 'sub IXGBE_MDIO_PMA_PMD_SDA_SCL_DATA () {0xc30b;}' unless defined(&IXGBE_MDIO_PMA_PMD_SDA_SCL_DATA);
    eval 'sub IXGBE_MDIO_PMA_PMD_SDA_SCL_STAT () {0xc30c;}' unless defined(&IXGBE_MDIO_PMA_PMD_SDA_SCL_STAT);
    eval 'sub IXGBE_MDIO_PHY_LOW_POWER_MODE () {0x800;}' unless defined(&IXGBE_MDIO_PHY_LOW_POWER_MODE);
    eval 'sub IXGBE_MII_10GBASE_T_AUTONEG_CTRL_REG () {0x20;}' unless defined(&IXGBE_MII_10GBASE_T_AUTONEG_CTRL_REG);
    eval 'sub IXGBE_MII_AUTONEG_VENDOR_PROVISION_1_REG () {0xc400;}' unless defined(&IXGBE_MII_AUTONEG_VENDOR_PROVISION_1_REG);
    eval 'sub IXGBE_MII_AUTONEG_XNP_TX_REG () {0x17;}' unless defined(&IXGBE_MII_AUTONEG_XNP_TX_REG);
    eval 'sub IXGBE_MII_AUTONEG_ADVERTISE_REG () {0x10;}' unless defined(&IXGBE_MII_AUTONEG_ADVERTISE_REG);
    eval 'sub IXGBE_MII_10GBASE_T_ADVERTISE () {0x1000;}' unless defined(&IXGBE_MII_10GBASE_T_ADVERTISE);
    eval 'sub IXGBE_MII_1GBASE_T_ADVERTISE_XNP_TX () {0x4000;}' unless defined(&IXGBE_MII_1GBASE_T_ADVERTISE_XNP_TX);
    eval 'sub IXGBE_MII_1GBASE_T_ADVERTISE () {0x8000;}' unless defined(&IXGBE_MII_1GBASE_T_ADVERTISE);
    eval 'sub IXGBE_MII_100BASE_T_ADVERTISE () {0x100;}' unless defined(&IXGBE_MII_100BASE_T_ADVERTISE);
    eval 'sub IXGBE_MII_100BASE_T_ADVERTISE_HALF () {0x80;}' unless defined(&IXGBE_MII_100BASE_T_ADVERTISE_HALF);
    eval 'sub IXGBE_MII_RESTART () {0x200;}' unless defined(&IXGBE_MII_RESTART);
    eval 'sub IXGBE_MII_AUTONEG_COMPLETE () {0x20;}' unless defined(&IXGBE_MII_AUTONEG_COMPLETE);
    eval 'sub IXGBE_MII_AUTONEG_LINK_UP () {0x4;}' unless defined(&IXGBE_MII_AUTONEG_LINK_UP);
    eval 'sub IXGBE_MII_AUTONEG_REG () {0x;}' unless defined(&IXGBE_MII_AUTONEG_REG);
    eval 'sub IXGBE_PHY_REVISION_MASK () {0xfffffff0;}' unless defined(&IXGBE_PHY_REVISION_MASK);
    eval 'sub IXGBE_MAX_PHY_ADDR () {32;}' unless defined(&IXGBE_MAX_PHY_ADDR);
    eval 'sub TN1010_PHY_ID () {0xa19410;}' unless defined(&TN1010_PHY_ID);
    eval 'sub TNX_FW_REV () {0xb;}' unless defined(&TNX_FW_REV);
    eval 'sub X540_PHY_ID () {0x1540200;}' unless defined(&X540_PHY_ID);
    eval 'sub AQ_FW_REV () {0x20;}' unless defined(&AQ_FW_REV);
    eval 'sub QT2022_PHY_ID () {0x43a400;}' unless defined(&QT2022_PHY_ID);
    eval 'sub ATH_PHY_ID () {0x3429050;}' unless defined(&ATH_PHY_ID);
    eval 'sub IXGBE_M88E1145_E_PHY_ID () {0x1410cd0;}' unless defined(&IXGBE_M88E1145_E_PHY_ID);
    eval 'sub IXGBE_PHY_INIT_OFFSET_NL () {0x2b;}' unless defined(&IXGBE_PHY_INIT_OFFSET_NL);
    eval 'sub IXGBE_PHY_INIT_END_NL () {0xffff;}' unless defined(&IXGBE_PHY_INIT_END_NL);
    eval 'sub IXGBE_CONTROL_MASK_NL () {0xf000;}' unless defined(&IXGBE_CONTROL_MASK_NL);
    eval 'sub IXGBE_DATA_MASK_NL () {0xfff;}' unless defined(&IXGBE_DATA_MASK_NL);
    eval 'sub IXGBE_CONTROL_SHIFT_NL () {12;}' unless defined(&IXGBE_CONTROL_SHIFT_NL);
    eval 'sub IXGBE_DELAY_NL () {0;}' unless defined(&IXGBE_DELAY_NL);
    eval 'sub IXGBE_DATA_NL () {1;}' unless defined(&IXGBE_DATA_NL);
    eval 'sub IXGBE_CONTROL_NL () {0xf;}' unless defined(&IXGBE_CONTROL_NL);
    eval 'sub IXGBE_CONTROL_EOL_NL () {0xfff;}' unless defined(&IXGBE_CONTROL_EOL_NL);
    eval 'sub IXGBE_CONTROL_SOL_NL () {0x;}' unless defined(&IXGBE_CONTROL_SOL_NL);
    eval 'sub IXGBE_SDP0_GPIEN () {0x1;}' unless defined(&IXGBE_SDP0_GPIEN);
    eval 'sub IXGBE_SDP1_GPIEN () {0x2;}' unless defined(&IXGBE_SDP1_GPIEN);
    eval 'sub IXGBE_SDP2_GPIEN () {0x4;}' unless defined(&IXGBE_SDP2_GPIEN);
    eval 'sub IXGBE_GPIE_MSIX_MODE () {0x10;}' unless defined(&IXGBE_GPIE_MSIX_MODE);
    eval 'sub IXGBE_GPIE_OCD () {0x20;}' unless defined(&IXGBE_GPIE_OCD);
    eval 'sub IXGBE_GPIE_EIMEN () {0x40;}' unless defined(&IXGBE_GPIE_EIMEN);
    eval 'sub IXGBE_GPIE_EIAME () {0x40000000;}' unless defined(&IXGBE_GPIE_EIAME);
    eval 'sub IXGBE_GPIE_PBA_SUPPORT () {0x80000000;}' unless defined(&IXGBE_GPIE_PBA_SUPPORT);
    eval 'sub IXGBE_GPIE_RSC_DELAY_SHIFT () {11;}' unless defined(&IXGBE_GPIE_RSC_DELAY_SHIFT);
    eval 'sub IXGBE_GPIE_LLI_DELAY_SHIFT () {7;}' unless defined(&IXGBE_GPIE_LLI_DELAY_SHIFT);
    eval 'sub IXGBE_GPIE_VTMODE_MASK () {0xc000;}' unless defined(&IXGBE_GPIE_VTMODE_MASK);
    eval 'sub IXGBE_GPIE_VTMODE_16 () {0x4000;}' unless defined(&IXGBE_GPIE_VTMODE_16);
    eval 'sub IXGBE_GPIE_VTMODE_32 () {0x8000;}' unless defined(&IXGBE_GPIE_VTMODE_32);
    eval 'sub IXGBE_GPIE_VTMODE_64 () {0xc000;}' unless defined(&IXGBE_GPIE_VTMODE_64);
    eval 'sub IXGBE_TFCS_TXOFF () {0x1;}' unless defined(&IXGBE_TFCS_TXOFF);
    eval 'sub IXGBE_TFCS_TXOFF0 () {0x100;}' unless defined(&IXGBE_TFCS_TXOFF0);
    eval 'sub IXGBE_TFCS_TXOFF1 () {0x200;}' unless defined(&IXGBE_TFCS_TXOFF1);
    eval 'sub IXGBE_TFCS_TXOFF2 () {0x400;}' unless defined(&IXGBE_TFCS_TXOFF2);
    eval 'sub IXGBE_TFCS_TXOFF3 () {0x800;}' unless defined(&IXGBE_TFCS_TXOFF3);
    eval 'sub IXGBE_TFCS_TXOFF4 () {0x1000;}' unless defined(&IXGBE_TFCS_TXOFF4);
    eval 'sub IXGBE_TFCS_TXOFF5 () {0x2000;}' unless defined(&IXGBE_TFCS_TXOFF5);
    eval 'sub IXGBE_TFCS_TXOFF6 () {0x4000;}' unless defined(&IXGBE_TFCS_TXOFF6);
    eval 'sub IXGBE_TFCS_TXOFF7 () {0x8000;}' unless defined(&IXGBE_TFCS_TXOFF7);
    eval 'sub IXGBE_TCPTIMER_KS () {0x100;}' unless defined(&IXGBE_TCPTIMER_KS);
    eval 'sub IXGBE_TCPTIMER_COUNT_ENABLE () {0x200;}' unless defined(&IXGBE_TCPTIMER_COUNT_ENABLE);
    eval 'sub IXGBE_TCPTIMER_COUNT_FINISH () {0x400;}' unless defined(&IXGBE_TCPTIMER_COUNT_FINISH);
    eval 'sub IXGBE_TCPTIMER_LOOP () {0x800;}' unless defined(&IXGBE_TCPTIMER_LOOP);
    eval 'sub IXGBE_TCPTIMER_DURATION_MASK () {0xff;}' unless defined(&IXGBE_TCPTIMER_DURATION_MASK);
    eval 'sub IXGBE_HLREG0_TXCRCEN () {0x1;}' unless defined(&IXGBE_HLREG0_TXCRCEN);
    eval 'sub IXGBE_HLREG0_RXCRCSTRP () {0x2;}' unless defined(&IXGBE_HLREG0_RXCRCSTRP);
    eval 'sub IXGBE_HLREG0_JUMBOEN () {0x4;}' unless defined(&IXGBE_HLREG0_JUMBOEN);
    eval 'sub IXGBE_HLREG0_TXPADEN () {0x400;}' unless defined(&IXGBE_HLREG0_TXPADEN);
    eval 'sub IXGBE_HLREG0_TXPAUSEEN () {0x1000;}' unless defined(&IXGBE_HLREG0_TXPAUSEEN);
    eval 'sub IXGBE_HLREG0_RXPAUSEEN () {0x4000;}' unless defined(&IXGBE_HLREG0_RXPAUSEEN);
    eval 'sub IXGBE_HLREG0_LPBK () {0x8000;}' unless defined(&IXGBE_HLREG0_LPBK);
    eval 'sub IXGBE_HLREG0_MDCSPD () {0x10000;}' unless defined(&IXGBE_HLREG0_MDCSPD);
    eval 'sub IXGBE_HLREG0_CONTMDC () {0x20000;}' unless defined(&IXGBE_HLREG0_CONTMDC);
    eval 'sub IXGBE_HLREG0_CTRLFLTR () {0x40000;}' unless defined(&IXGBE_HLREG0_CTRLFLTR);
    eval 'sub IXGBE_HLREG0_PREPEND () {0xf00000;}' unless defined(&IXGBE_HLREG0_PREPEND);
    eval 'sub IXGBE_HLREG0_PRIPAUSEEN () {0x1000000;}' unless defined(&IXGBE_HLREG0_PRIPAUSEEN);
    eval 'sub IXGBE_HLREG0_RXPAUSERECDA () {0x6000000;}' unless defined(&IXGBE_HLREG0_RXPAUSERECDA);
    eval 'sub IXGBE_HLREG0_RXLNGTHERREN () {0x8000000;}' unless defined(&IXGBE_HLREG0_RXLNGTHERREN);
    eval 'sub IXGBE_HLREG0_RXPADSTRIPEN () {0x10000000;}' unless defined(&IXGBE_HLREG0_RXPADSTRIPEN);
    eval 'sub IXGBE_VMD_CTL_VMDQ_EN () {0x1;}' unless defined(&IXGBE_VMD_CTL_VMDQ_EN);
    eval 'sub IXGBE_VMD_CTL_VMDQ_FILTER () {0x2;}' unless defined(&IXGBE_VMD_CTL_VMDQ_FILTER);
    eval 'sub IXGBE_VT_CTL_DIS_DEFPL () {0x20000000;}' unless defined(&IXGBE_VT_CTL_DIS_DEFPL);
    eval 'sub IXGBE_VT_CTL_REPLEN () {0x40000000;}' unless defined(&IXGBE_VT_CTL_REPLEN);
    eval 'sub IXGBE_VT_CTL_VT_ENABLE () {0x1;}' unless defined(&IXGBE_VT_CTL_VT_ENABLE);
    eval 'sub IXGBE_VT_CTL_POOL_SHIFT () {7;}' unless defined(&IXGBE_VT_CTL_POOL_SHIFT);
    eval 'sub IXGBE_VT_CTL_POOL_MASK () {(0x3f <<  &IXGBE_VT_CTL_POOL_SHIFT);}' unless defined(&IXGBE_VT_CTL_POOL_MASK);
    eval 'sub IXGBE_VMOLR_AUPE () {0x1000000;}' unless defined(&IXGBE_VMOLR_AUPE);
    eval 'sub IXGBE_VMOLR_ROMPE () {0x2000000;}' unless defined(&IXGBE_VMOLR_ROMPE);
    eval 'sub IXGBE_VMOLR_ROPE () {0x4000000;}' unless defined(&IXGBE_VMOLR_ROPE);
    eval 'sub IXGBE_VMOLR_BAM () {0x8000000;}' unless defined(&IXGBE_VMOLR_BAM);
    eval 'sub IXGBE_VMOLR_MPE () {0x10000000;}' unless defined(&IXGBE_VMOLR_MPE);
    eval 'sub IXGBE_VFRE_ENABLE_ALL () {0xffffffff;}' unless defined(&IXGBE_VFRE_ENABLE_ALL);
    eval 'sub IXGBE_VF_INIT_TIMEOUT () {200;}' unless defined(&IXGBE_VF_INIT_TIMEOUT);
    eval 'sub IXGBE_RDHMPN_RDICADDR () {0x7ff800;}' unless defined(&IXGBE_RDHMPN_RDICADDR);
    eval 'sub IXGBE_RDHMPN_RDICRDREQ () {0x800000;}' unless defined(&IXGBE_RDHMPN_RDICRDREQ);
    eval 'sub IXGBE_RDHMPN_RDICADDR_SHIFT () {11;}' unless defined(&IXGBE_RDHMPN_RDICADDR_SHIFT);
    eval 'sub IXGBE_TDHMPN_TDICADDR () {0x3ff800;}' unless defined(&IXGBE_TDHMPN_TDICADDR);
    eval 'sub IXGBE_TDHMPN_TDICRDREQ () {0x800000;}' unless defined(&IXGBE_TDHMPN_TDICRDREQ);
    eval 'sub IXGBE_TDHMPN_TDICADDR_SHIFT () {11;}' unless defined(&IXGBE_TDHMPN_TDICADDR_SHIFT);
    eval 'sub IXGBE_RDMAM_MEM_SEL_SHIFT () {13;}' unless defined(&IXGBE_RDMAM_MEM_SEL_SHIFT);
    eval 'sub IXGBE_RDMAM_DWORD_SHIFT () {9;}' unless defined(&IXGBE_RDMAM_DWORD_SHIFT);
    eval 'sub IXGBE_RDMAM_DESC_COMP_FIFO () {1;}' unless defined(&IXGBE_RDMAM_DESC_COMP_FIFO);
    eval 'sub IXGBE_RDMAM_DFC_CMD_FIFO () {2;}' unless defined(&IXGBE_RDMAM_DFC_CMD_FIFO);
    eval 'sub IXGBE_RDMAM_RSC_HEADER_ADDR () {3;}' unless defined(&IXGBE_RDMAM_RSC_HEADER_ADDR);
    eval 'sub IXGBE_RDMAM_TCN_STATUS_RAM () {4;}' unless defined(&IXGBE_RDMAM_TCN_STATUS_RAM);
    eval 'sub IXGBE_RDMAM_WB_COLL_FIFO () {5;}' unless defined(&IXGBE_RDMAM_WB_COLL_FIFO);
    eval 'sub IXGBE_RDMAM_QSC_CNT_RAM () {6;}' unless defined(&IXGBE_RDMAM_QSC_CNT_RAM);
    eval 'sub IXGBE_RDMAM_QSC_FCOE_RAM () {7;}' unless defined(&IXGBE_RDMAM_QSC_FCOE_RAM);
    eval 'sub IXGBE_RDMAM_QSC_QUEUE_CNT () {8;}' unless defined(&IXGBE_RDMAM_QSC_QUEUE_CNT);
    eval 'sub IXGBE_RDMAM_QSC_QUEUE_RAM () {0xa;}' unless defined(&IXGBE_RDMAM_QSC_QUEUE_RAM);
    eval 'sub IXGBE_RDMAM_QSC_RSC_RAM () {0xb;}' unless defined(&IXGBE_RDMAM_QSC_RSC_RAM);
    eval 'sub IXGBE_RDMAM_DESC_COM_FIFO_RANGE () {135;}' unless defined(&IXGBE_RDMAM_DESC_COM_FIFO_RANGE);
    eval 'sub IXGBE_RDMAM_DESC_COM_FIFO_COUNT () {4;}' unless defined(&IXGBE_RDMAM_DESC_COM_FIFO_COUNT);
    eval 'sub IXGBE_RDMAM_DFC_CMD_FIFO_RANGE () {48;}' unless defined(&IXGBE_RDMAM_DFC_CMD_FIFO_RANGE);
    eval 'sub IXGBE_RDMAM_DFC_CMD_FIFO_COUNT () {7;}' unless defined(&IXGBE_RDMAM_DFC_CMD_FIFO_COUNT);
    eval 'sub IXGBE_RDMAM_RSC_HEADER_ADDR_RANGE () {32;}' unless defined(&IXGBE_RDMAM_RSC_HEADER_ADDR_RANGE);
    eval 'sub IXGBE_RDMAM_RSC_HEADER_ADDR_COUNT () {4;}' unless defined(&IXGBE_RDMAM_RSC_HEADER_ADDR_COUNT);
    eval 'sub IXGBE_RDMAM_TCN_STATUS_RAM_RANGE () {256;}' unless defined(&IXGBE_RDMAM_TCN_STATUS_RAM_RANGE);
    eval 'sub IXGBE_RDMAM_TCN_STATUS_RAM_COUNT () {9;}' unless defined(&IXGBE_RDMAM_TCN_STATUS_RAM_COUNT);
    eval 'sub IXGBE_RDMAM_WB_COLL_FIFO_RANGE () {8;}' unless defined(&IXGBE_RDMAM_WB_COLL_FIFO_RANGE);
    eval 'sub IXGBE_RDMAM_WB_COLL_FIFO_COUNT () {4;}' unless defined(&IXGBE_RDMAM_WB_COLL_FIFO_COUNT);
    eval 'sub IXGBE_RDMAM_QSC_CNT_RAM_RANGE () {64;}' unless defined(&IXGBE_RDMAM_QSC_CNT_RAM_RANGE);
    eval 'sub IXGBE_RDMAM_QSC_CNT_RAM_COUNT () {4;}' unless defined(&IXGBE_RDMAM_QSC_CNT_RAM_COUNT);
    eval 'sub IXGBE_RDMAM_QSC_FCOE_RAM_RANGE () {512;}' unless defined(&IXGBE_RDMAM_QSC_FCOE_RAM_RANGE);
    eval 'sub IXGBE_RDMAM_QSC_FCOE_RAM_COUNT () {5;}' unless defined(&IXGBE_RDMAM_QSC_FCOE_RAM_COUNT);
    eval 'sub IXGBE_RDMAM_QSC_QUEUE_CNT_RANGE () {32;}' unless defined(&IXGBE_RDMAM_QSC_QUEUE_CNT_RANGE);
    eval 'sub IXGBE_RDMAM_QSC_QUEUE_CNT_COUNT () {4;}' unless defined(&IXGBE_RDMAM_QSC_QUEUE_CNT_COUNT);
    eval 'sub IXGBE_RDMAM_QSC_QUEUE_RAM_RANGE () {128;}' unless defined(&IXGBE_RDMAM_QSC_QUEUE_RAM_RANGE);
    eval 'sub IXGBE_RDMAM_QSC_QUEUE_RAM_COUNT () {8;}' unless defined(&IXGBE_RDMAM_QSC_QUEUE_RAM_COUNT);
    eval 'sub IXGBE_RDMAM_QSC_RSC_RAM_RANGE () {32;}' unless defined(&IXGBE_RDMAM_QSC_RSC_RAM_RANGE);
    eval 'sub IXGBE_RDMAM_QSC_RSC_RAM_COUNT () {8;}' unless defined(&IXGBE_RDMAM_QSC_RSC_RAM_COUNT);
    eval 'sub IXGBE_TXDESCIC_READY () {0x80000000;}' unless defined(&IXGBE_TXDESCIC_READY);
    eval 'sub IXGBE_RXCSUM_IPPCSE () {0x1000;}' unless defined(&IXGBE_RXCSUM_IPPCSE);
    eval 'sub IXGBE_RXCSUM_PCSD () {0x2000;}' unless defined(&IXGBE_RXCSUM_PCSD);
    eval 'sub IXGBE_FCRTL_XONE () {0x80000000;}' unless defined(&IXGBE_FCRTL_XONE);
    eval 'sub IXGBE_FCRTH_FCEN () {0x80000000;}' unless defined(&IXGBE_FCRTH_FCEN);
    eval 'sub IXGBE_PAP_TXPAUSECNT_MASK () {0xffff;}' unless defined(&IXGBE_PAP_TXPAUSECNT_MASK);
    eval 'sub IXGBE_RMCS_RRM () {0x2;}' unless defined(&IXGBE_RMCS_RRM);
    eval 'sub IXGBE_RMCS_RAC () {0x4;}' unless defined(&IXGBE_RMCS_RAC);
    eval 'sub IXGBE_RMCS_DFP () { &IXGBE_RMCS_RAC;}' unless defined(&IXGBE_RMCS_DFP);
    eval 'sub IXGBE_RMCS_TFCE_802_3X () {0x8;}' unless defined(&IXGBE_RMCS_TFCE_802_3X);
    eval 'sub IXGBE_RMCS_TFCE_PRIORITY () {0x10;}' unless defined(&IXGBE_RMCS_TFCE_PRIORITY);
    eval 'sub IXGBE_RMCS_ARBDIS () {0x40;}' unless defined(&IXGBE_RMCS_ARBDIS);
    eval 'sub IXGBE_FCCFG_TFCE_802_3X () {0x8;}' unless defined(&IXGBE_FCCFG_TFCE_802_3X);
    eval 'sub IXGBE_FCCFG_TFCE_PRIORITY () {0x10;}' unless defined(&IXGBE_FCCFG_TFCE_PRIORITY);
    eval 'sub IXGBE_EICR_RTX_QUEUE () {0xffff;}' unless defined(&IXGBE_EICR_RTX_QUEUE);
    eval 'sub IXGBE_EICR_FLOW_DIR () {0x10000;}' unless defined(&IXGBE_EICR_FLOW_DIR);
    eval 'sub IXGBE_EICR_RX_MISS () {0x20000;}' unless defined(&IXGBE_EICR_RX_MISS);
    eval 'sub IXGBE_EICR_PCI () {0x40000;}' unless defined(&IXGBE_EICR_PCI);
    eval 'sub IXGBE_EICR_MAILBOX () {0x80000;}' unless defined(&IXGBE_EICR_MAILBOX);
    eval 'sub IXGBE_EICR_LSC () {0x100000;}' unless defined(&IXGBE_EICR_LSC);
    eval 'sub IXGBE_EICR_LINKSEC () {0x200000;}' unless defined(&IXGBE_EICR_LINKSEC);
    eval 'sub IXGBE_EICR_MNG () {0x400000;}' unless defined(&IXGBE_EICR_MNG);
    eval 'sub IXGBE_EICR_GPI_SDP0 () {0x1000000;}' unless defined(&IXGBE_EICR_GPI_SDP0);
    eval 'sub IXGBE_EICR_GPI_SDP1 () {0x2000000;}' unless defined(&IXGBE_EICR_GPI_SDP1);
    eval 'sub IXGBE_EICR_GPI_SDP2 () {0x4000000;}' unless defined(&IXGBE_EICR_GPI_SDP2);
    eval 'sub IXGBE_EICR_ECC () {0x10000000;}' unless defined(&IXGBE_EICR_ECC);
    eval 'sub IXGBE_EICR_PBUR () {0x10000000;}' unless defined(&IXGBE_EICR_PBUR);
    eval 'sub IXGBE_EICR_DHER () {0x20000000;}' unless defined(&IXGBE_EICR_DHER);
    eval 'sub IXGBE_EICR_TCP_TIMER () {0x40000000;}' unless defined(&IXGBE_EICR_TCP_TIMER);
    eval 'sub IXGBE_EICR_OTHER () {0x80000000;}' unless defined(&IXGBE_EICR_OTHER);
    eval 'sub IXGBE_EICS_RTX_QUEUE () { &IXGBE_EICR_RTX_QUEUE;}' unless defined(&IXGBE_EICS_RTX_QUEUE);
    eval 'sub IXGBE_EICS_FLOW_DIR () { &IXGBE_EICR_FLOW_DIR;}' unless defined(&IXGBE_EICS_FLOW_DIR);
    eval 'sub IXGBE_EICS_RX_MISS () { &IXGBE_EICR_RX_MISS;}' unless defined(&IXGBE_EICS_RX_MISS);
    eval 'sub IXGBE_EICS_PCI () { &IXGBE_EICR_PCI;}' unless defined(&IXGBE_EICS_PCI);
    eval 'sub IXGBE_EICS_MAILBOX () { &IXGBE_EICR_MAILBOX;}' unless defined(&IXGBE_EICS_MAILBOX);
    eval 'sub IXGBE_EICS_LSC () { &IXGBE_EICR_LSC;}' unless defined(&IXGBE_EICS_LSC);
    eval 'sub IXGBE_EICS_MNG () { &IXGBE_EICR_MNG;}' unless defined(&IXGBE_EICS_MNG);
    eval 'sub IXGBE_EICS_GPI_SDP0 () { &IXGBE_EICR_GPI_SDP0;}' unless defined(&IXGBE_EICS_GPI_SDP0);
    eval 'sub IXGBE_EICS_GPI_SDP1 () { &IXGBE_EICR_GPI_SDP1;}' unless defined(&IXGBE_EICS_GPI_SDP1);
    eval 'sub IXGBE_EICS_GPI_SDP2 () { &IXGBE_EICR_GPI_SDP2;}' unless defined(&IXGBE_EICS_GPI_SDP2);
    eval 'sub IXGBE_EICS_ECC () { &IXGBE_EICR_ECC;}' unless defined(&IXGBE_EICS_ECC);
    eval 'sub IXGBE_EICS_PBUR () { &IXGBE_EICR_PBUR;}' unless defined(&IXGBE_EICS_PBUR);
    eval 'sub IXGBE_EICS_DHER () { &IXGBE_EICR_DHER;}' unless defined(&IXGBE_EICS_DHER);
    eval 'sub IXGBE_EICS_TCP_TIMER () { &IXGBE_EICR_TCP_TIMER;}' unless defined(&IXGBE_EICS_TCP_TIMER);
    eval 'sub IXGBE_EICS_OTHER () { &IXGBE_EICR_OTHER;}' unless defined(&IXGBE_EICS_OTHER);
    eval 'sub IXGBE_EIMS_RTX_QUEUE () { &IXGBE_EICR_RTX_QUEUE;}' unless defined(&IXGBE_EIMS_RTX_QUEUE);
    eval 'sub IXGBE_EIMS_FLOW_DIR () { &IXGBE_EICR_FLOW_DIR;}' unless defined(&IXGBE_EIMS_FLOW_DIR);
    eval 'sub IXGBE_EIMS_RX_MISS () { &IXGBE_EICR_RX_MISS;}' unless defined(&IXGBE_EIMS_RX_MISS);
    eval 'sub IXGBE_EIMS_PCI () { &IXGBE_EICR_PCI;}' unless defined(&IXGBE_EIMS_PCI);
    eval 'sub IXGBE_EIMS_MAILBOX () { &IXGBE_EICR_MAILBOX;}' unless defined(&IXGBE_EIMS_MAILBOX);
    eval 'sub IXGBE_EIMS_LSC () { &IXGBE_EICR_LSC;}' unless defined(&IXGBE_EIMS_LSC);
    eval 'sub IXGBE_EIMS_MNG () { &IXGBE_EICR_MNG;}' unless defined(&IXGBE_EIMS_MNG);
    eval 'sub IXGBE_EIMS_GPI_SDP0 () { &IXGBE_EICR_GPI_SDP0;}' unless defined(&IXGBE_EIMS_GPI_SDP0);
    eval 'sub IXGBE_EIMS_GPI_SDP1 () { &IXGBE_EICR_GPI_SDP1;}' unless defined(&IXGBE_EIMS_GPI_SDP1);
    eval 'sub IXGBE_EIMS_GPI_SDP2 () { &IXGBE_EICR_GPI_SDP2;}' unless defined(&IXGBE_EIMS_GPI_SDP2);
    eval 'sub IXGBE_EIMS_ECC () { &IXGBE_EICR_ECC;}' unless defined(&IXGBE_EIMS_ECC);
    eval 'sub IXGBE_EIMS_PBUR () { &IXGBE_EICR_PBUR;}' unless defined(&IXGBE_EIMS_PBUR);
    eval 'sub IXGBE_EIMS_DHER () { &IXGBE_EICR_DHER;}' unless defined(&IXGBE_EIMS_DHER);
    eval 'sub IXGBE_EIMS_TCP_TIMER () { &IXGBE_EICR_TCP_TIMER;}' unless defined(&IXGBE_EIMS_TCP_TIMER);
    eval 'sub IXGBE_EIMS_OTHER () { &IXGBE_EICR_OTHER;}' unless defined(&IXGBE_EIMS_OTHER);
    eval 'sub IXGBE_EIMC_RTX_QUEUE () { &IXGBE_EICR_RTX_QUEUE;}' unless defined(&IXGBE_EIMC_RTX_QUEUE);
    eval 'sub IXGBE_EIMC_FLOW_DIR () { &IXGBE_EICR_FLOW_DIR;}' unless defined(&IXGBE_EIMC_FLOW_DIR);
    eval 'sub IXGBE_EIMC_RX_MISS () { &IXGBE_EICR_RX_MISS;}' unless defined(&IXGBE_EIMC_RX_MISS);
    eval 'sub IXGBE_EIMC_PCI () { &IXGBE_EICR_PCI;}' unless defined(&IXGBE_EIMC_PCI);
    eval 'sub IXGBE_EIMC_MAILBOX () { &IXGBE_EICR_MAILBOX;}' unless defined(&IXGBE_EIMC_MAILBOX);
    eval 'sub IXGBE_EIMC_LSC () { &IXGBE_EICR_LSC;}' unless defined(&IXGBE_EIMC_LSC);
    eval 'sub IXGBE_EIMC_MNG () { &IXGBE_EICR_MNG;}' unless defined(&IXGBE_EIMC_MNG);
    eval 'sub IXGBE_EIMC_GPI_SDP0 () { &IXGBE_EICR_GPI_SDP0;}' unless defined(&IXGBE_EIMC_GPI_SDP0);
    eval 'sub IXGBE_EIMC_GPI_SDP1 () { &IXGBE_EICR_GPI_SDP1;}' unless defined(&IXGBE_EIMC_GPI_SDP1);
    eval 'sub IXGBE_EIMC_GPI_SDP2 () { &IXGBE_EICR_GPI_SDP2;}' unless defined(&IXGBE_EIMC_GPI_SDP2);
    eval 'sub IXGBE_EIMC_ECC () { &IXGBE_EICR_ECC;}' unless defined(&IXGBE_EIMC_ECC);
    eval 'sub IXGBE_EIMC_PBUR () { &IXGBE_EICR_PBUR;}' unless defined(&IXGBE_EIMC_PBUR);
    eval 'sub IXGBE_EIMC_DHER () { &IXGBE_EICR_DHER;}' unless defined(&IXGBE_EIMC_DHER);
    eval 'sub IXGBE_EIMC_TCP_TIMER () { &IXGBE_EICR_TCP_TIMER;}' unless defined(&IXGBE_EIMC_TCP_TIMER);
    eval 'sub IXGBE_EIMC_OTHER () { &IXGBE_EICR_OTHER;}' unless defined(&IXGBE_EIMC_OTHER);
    eval 'sub IXGBE_EIMS_ENABLE_MASK () {(  &IXGBE_EIMS_RTX_QUEUE |  &IXGBE_EIMS_LSC |  &IXGBE_EIMS_OTHER);}' unless defined(&IXGBE_EIMS_ENABLE_MASK);
    eval 'sub IXGBE_IMIR_PORT_IM_EN () {0x10000;}' unless defined(&IXGBE_IMIR_PORT_IM_EN);
    eval 'sub IXGBE_IMIR_PORT_BP () {0x20000;}' unless defined(&IXGBE_IMIR_PORT_BP);
    eval 'sub IXGBE_IMIREXT_SIZE_BP () {0x1000;}' unless defined(&IXGBE_IMIREXT_SIZE_BP);
    eval 'sub IXGBE_IMIREXT_CTRL_URG () {0x2000;}' unless defined(&IXGBE_IMIREXT_CTRL_URG);
    eval 'sub IXGBE_IMIREXT_CTRL_ACK () {0x4000;}' unless defined(&IXGBE_IMIREXT_CTRL_ACK);
    eval 'sub IXGBE_IMIREXT_CTRL_PSH () {0x8000;}' unless defined(&IXGBE_IMIREXT_CTRL_PSH);
    eval 'sub IXGBE_IMIREXT_CTRL_RST () {0x10000;}' unless defined(&IXGBE_IMIREXT_CTRL_RST);
    eval 'sub IXGBE_IMIREXT_CTRL_SYN () {0x20000;}' unless defined(&IXGBE_IMIREXT_CTRL_SYN);
    eval 'sub IXGBE_IMIREXT_CTRL_FIN () {0x40000;}' unless defined(&IXGBE_IMIREXT_CTRL_FIN);
    eval 'sub IXGBE_IMIREXT_CTRL_BP () {0x80000;}' unless defined(&IXGBE_IMIREXT_CTRL_BP);
    eval 'sub IXGBE_IMIR_SIZE_BP_82599 () {0x1000;}' unless defined(&IXGBE_IMIR_SIZE_BP_82599);
    eval 'sub IXGBE_IMIR_CTRL_URG_82599 () {0x2000;}' unless defined(&IXGBE_IMIR_CTRL_URG_82599);
    eval 'sub IXGBE_IMIR_CTRL_ACK_82599 () {0x4000;}' unless defined(&IXGBE_IMIR_CTRL_ACK_82599);
    eval 'sub IXGBE_IMIR_CTRL_PSH_82599 () {0x8000;}' unless defined(&IXGBE_IMIR_CTRL_PSH_82599);
    eval 'sub IXGBE_IMIR_CTRL_RST_82599 () {0x10000;}' unless defined(&IXGBE_IMIR_CTRL_RST_82599);
    eval 'sub IXGBE_IMIR_CTRL_SYN_82599 () {0x20000;}' unless defined(&IXGBE_IMIR_CTRL_SYN_82599);
    eval 'sub IXGBE_IMIR_CTRL_FIN_82599 () {0x40000;}' unless defined(&IXGBE_IMIR_CTRL_FIN_82599);
    eval 'sub IXGBE_IMIR_CTRL_BP_82599 () {0x80000;}' unless defined(&IXGBE_IMIR_CTRL_BP_82599);
    eval 'sub IXGBE_IMIR_LLI_EN_82599 () {0x100000;}' unless defined(&IXGBE_IMIR_LLI_EN_82599);
    eval 'sub IXGBE_IMIR_RX_QUEUE_MASK_82599 () {0x7f;}' unless defined(&IXGBE_IMIR_RX_QUEUE_MASK_82599);
    eval 'sub IXGBE_IMIR_RX_QUEUE_SHIFT_82599 () {21;}' unless defined(&IXGBE_IMIR_RX_QUEUE_SHIFT_82599);
    eval 'sub IXGBE_IMIRVP_PRIORITY_MASK () {0x7;}' unless defined(&IXGBE_IMIRVP_PRIORITY_MASK);
    eval 'sub IXGBE_IMIRVP_PRIORITY_EN () {0x8;}' unless defined(&IXGBE_IMIRVP_PRIORITY_EN);
    eval 'sub IXGBE_MAX_FTQF_FILTERS () {128;}' unless defined(&IXGBE_MAX_FTQF_FILTERS);
    eval 'sub IXGBE_FTQF_PROTOCOL_MASK () {0x3;}' unless defined(&IXGBE_FTQF_PROTOCOL_MASK);
    eval 'sub IXGBE_FTQF_PROTOCOL_TCP () {0x;}' unless defined(&IXGBE_FTQF_PROTOCOL_TCP);
    eval 'sub IXGBE_FTQF_PROTOCOL_UDP () {0x1;}' unless defined(&IXGBE_FTQF_PROTOCOL_UDP);
    eval 'sub IXGBE_FTQF_PROTOCOL_SCTP () {2;}' unless defined(&IXGBE_FTQF_PROTOCOL_SCTP);
    eval 'sub IXGBE_FTQF_PRIORITY_MASK () {0x7;}' unless defined(&IXGBE_FTQF_PRIORITY_MASK);
    eval 'sub IXGBE_FTQF_PRIORITY_SHIFT () {2;}' unless defined(&IXGBE_FTQF_PRIORITY_SHIFT);
    eval 'sub IXGBE_FTQF_POOL_MASK () {0x3f;}' unless defined(&IXGBE_FTQF_POOL_MASK);
    eval 'sub IXGBE_FTQF_POOL_SHIFT () {8;}' unless defined(&IXGBE_FTQF_POOL_SHIFT);
    eval 'sub IXGBE_FTQF_5TUPLE_MASK_MASK () {0x1f;}' unless defined(&IXGBE_FTQF_5TUPLE_MASK_MASK);
    eval 'sub IXGBE_FTQF_5TUPLE_MASK_SHIFT () {25;}' unless defined(&IXGBE_FTQF_5TUPLE_MASK_SHIFT);
    eval 'sub IXGBE_FTQF_SOURCE_ADDR_MASK () {0x1e;}' unless defined(&IXGBE_FTQF_SOURCE_ADDR_MASK);
    eval 'sub IXGBE_FTQF_DEST_ADDR_MASK () {0x1d;}' unless defined(&IXGBE_FTQF_DEST_ADDR_MASK);
    eval 'sub IXGBE_FTQF_SOURCE_PORT_MASK () {0x1b;}' unless defined(&IXGBE_FTQF_SOURCE_PORT_MASK);
    eval 'sub IXGBE_FTQF_DEST_PORT_MASK () {0x17;}' unless defined(&IXGBE_FTQF_DEST_PORT_MASK);
    eval 'sub IXGBE_FTQF_PROTOCOL_COMP_MASK () {0xf;}' unless defined(&IXGBE_FTQF_PROTOCOL_COMP_MASK);
    eval 'sub IXGBE_FTQF_POOL_MASK_EN () {0x40000000;}' unless defined(&IXGBE_FTQF_POOL_MASK_EN);
    eval 'sub IXGBE_FTQF_QUEUE_ENABLE () {0x80000000;}' unless defined(&IXGBE_FTQF_QUEUE_ENABLE);
    eval 'sub IXGBE_IRQ_CLEAR_MASK () {0xffffffff;}' unless defined(&IXGBE_IRQ_CLEAR_MASK);
    eval 'sub IXGBE_IVAR_REG_NUM () {25;}' unless defined(&IXGBE_IVAR_REG_NUM);
    eval 'sub IXGBE_IVAR_REG_NUM_82599 () {64;}' unless defined(&IXGBE_IVAR_REG_NUM_82599);
    eval 'sub IXGBE_IVAR_TXRX_ENTRY () {96;}' unless defined(&IXGBE_IVAR_TXRX_ENTRY);
    eval 'sub IXGBE_IVAR_RX_ENTRY () {64;}' unless defined(&IXGBE_IVAR_RX_ENTRY);
    eval 'sub IXGBE_IVAR_RX_QUEUE {
        my($_i) = @_;
	    eval q((0+ ($_i)));
    }' unless defined(&IXGBE_IVAR_RX_QUEUE);
    eval 'sub IXGBE_IVAR_TX_QUEUE {
        my($_i) = @_;
	    eval q((64+ ($_i)));
    }' unless defined(&IXGBE_IVAR_TX_QUEUE);
    eval 'sub IXGBE_IVAR_TX_ENTRY () {32;}' unless defined(&IXGBE_IVAR_TX_ENTRY);
    eval 'sub IXGBE_IVAR_TCP_TIMER_INDEX () {96;}' unless defined(&IXGBE_IVAR_TCP_TIMER_INDEX);
    eval 'sub IXGBE_IVAR_OTHER_CAUSES_INDEX () {97;}' unless defined(&IXGBE_IVAR_OTHER_CAUSES_INDEX);
    eval 'sub IXGBE_MSIX_VECTOR {
        my($_i) = @_;
	    eval q((0+ ($_i)));
    }' unless defined(&IXGBE_MSIX_VECTOR);
    eval 'sub IXGBE_IVAR_ALLOC_VAL () {0x80;}' unless defined(&IXGBE_IVAR_ALLOC_VAL);
    eval 'sub IXGBE_MAX_ETQF_FILTERS () {8;}' unless defined(&IXGBE_MAX_ETQF_FILTERS);
    eval 'sub IXGBE_ETQF_FCOE () {0x8000000;}' unless defined(&IXGBE_ETQF_FCOE);
    eval 'sub IXGBE_ETQF_BCN () {0x10000000;}' unless defined(&IXGBE_ETQF_BCN);
    eval 'sub IXGBE_ETQF_1588 () {0x40000000;}' unless defined(&IXGBE_ETQF_1588);
    eval 'sub IXGBE_ETQF_FILTER_EN () {0x80000000;}' unless defined(&IXGBE_ETQF_FILTER_EN);
    eval 'sub IXGBE_ETQF_POOL_ENABLE () {(1<< 26);}' unless defined(&IXGBE_ETQF_POOL_ENABLE);
    eval 'sub IXGBE_ETQS_RX_QUEUE () {0x7f0000;}' unless defined(&IXGBE_ETQS_RX_QUEUE);
    eval 'sub IXGBE_ETQS_RX_QUEUE_SHIFT () {16;}' unless defined(&IXGBE_ETQS_RX_QUEUE_SHIFT);
    eval 'sub IXGBE_ETQS_LLI () {0x20000000;}' unless defined(&IXGBE_ETQS_LLI);
    eval 'sub IXGBE_ETQS_QUEUE_EN () {0x80000000;}' unless defined(&IXGBE_ETQS_QUEUE_EN);
    eval 'sub IXGBE_ETQF_FILTER_EAPOL () {0;}' unless defined(&IXGBE_ETQF_FILTER_EAPOL);
    eval 'sub IXGBE_ETQF_FILTER_FCOE () {2;}' unless defined(&IXGBE_ETQF_FILTER_FCOE);
    eval 'sub IXGBE_ETQF_FILTER_1588 () {3;}' unless defined(&IXGBE_ETQF_FILTER_1588);
    eval 'sub IXGBE_ETQF_FILTER_FIP () {4;}' unless defined(&IXGBE_ETQF_FILTER_FIP);
    eval 'sub IXGBE_VLNCTRL_VET () {0xffff;}' unless defined(&IXGBE_VLNCTRL_VET);
    eval 'sub IXGBE_VLNCTRL_CFI () {0x10000000;}' unless defined(&IXGBE_VLNCTRL_CFI);
    eval 'sub IXGBE_VLNCTRL_CFIEN () {0x20000000;}' unless defined(&IXGBE_VLNCTRL_CFIEN);
    eval 'sub IXGBE_VLNCTRL_VFE () {0x40000000;}' unless defined(&IXGBE_VLNCTRL_VFE);
    eval 'sub IXGBE_VLNCTRL_VME () {0x80000000;}' unless defined(&IXGBE_VLNCTRL_VME);
    eval 'sub IXGBE_VLVF_VIEN () {0x80000000;}' unless defined(&IXGBE_VLVF_VIEN);
    eval 'sub IXGBE_VLVF_ENTRIES () {64;}' unless defined(&IXGBE_VLVF_ENTRIES);
    eval 'sub IXGBE_VLVF_VLANID_MASK () {0xfff;}' unless defined(&IXGBE_VLVF_VLANID_MASK);
    eval 'sub IXGBE_VMVIR_VLANA_DEFAULT () {0x40000000;}' unless defined(&IXGBE_VMVIR_VLANA_DEFAULT);
    eval 'sub IXGBE_VMVIR_VLANA_NEVER () {0x80000000;}' unless defined(&IXGBE_VMVIR_VLANA_NEVER);
    eval 'sub IXGBE_ETHERNET_IEEE_VLAN_TYPE () {0x8100;}' unless defined(&IXGBE_ETHERNET_IEEE_VLAN_TYPE);
    eval 'sub IXGBE_STATUS_LAN_ID () {0xc;}' unless defined(&IXGBE_STATUS_LAN_ID);
    eval 'sub IXGBE_STATUS_LAN_ID_SHIFT () {2;}' unless defined(&IXGBE_STATUS_LAN_ID_SHIFT);
    eval 'sub IXGBE_STATUS_GIO () {0x80000;}' unless defined(&IXGBE_STATUS_GIO);
    eval 'sub IXGBE_STATUS_LAN_ID_0 () {0x;}' unless defined(&IXGBE_STATUS_LAN_ID_0);
    eval 'sub IXGBE_STATUS_LAN_ID_1 () {0x4;}' unless defined(&IXGBE_STATUS_LAN_ID_1);
    eval 'sub IXGBE_ESDP_SDP0 () {0x1;}' unless defined(&IXGBE_ESDP_SDP0);
    eval 'sub IXGBE_ESDP_SDP1 () {0x2;}' unless defined(&IXGBE_ESDP_SDP1);
    eval 'sub IXGBE_ESDP_SDP2 () {0x4;}' unless defined(&IXGBE_ESDP_SDP2);
    eval 'sub IXGBE_ESDP_SDP3 () {0x8;}' unless defined(&IXGBE_ESDP_SDP3);
    eval 'sub IXGBE_ESDP_SDP4 () {0x10;}' unless defined(&IXGBE_ESDP_SDP4);
    eval 'sub IXGBE_ESDP_SDP5 () {0x20;}' unless defined(&IXGBE_ESDP_SDP5);
    eval 'sub IXGBE_ESDP_SDP6 () {0x40;}' unless defined(&IXGBE_ESDP_SDP6);
    eval 'sub IXGBE_ESDP_SDP4_DIR () {0x4;}' unless defined(&IXGBE_ESDP_SDP4_DIR);
    eval 'sub IXGBE_ESDP_SDP5_DIR () {0x2000;}' unless defined(&IXGBE_ESDP_SDP5_DIR);
    eval 'sub IXGBE_LED_IVRT_BASE () {0x40;}' unless defined(&IXGBE_LED_IVRT_BASE);
    eval 'sub IXGBE_LED_BLINK_BASE () {0x80;}' unless defined(&IXGBE_LED_BLINK_BASE);
    eval 'sub IXGBE_LED_MODE_MASK_BASE () {0xf;}' unless defined(&IXGBE_LED_MODE_MASK_BASE);
    eval 'sub IXGBE_LED_OFFSET {
        my($_base, $_i) = @_;
	    eval q(($_base << (8* ($_i))));
    }' unless defined(&IXGBE_LED_OFFSET);
    eval 'sub IXGBE_LED_MODE_SHIFT {
        my($_i) = @_;
	    eval q((8*($_i)));
    }' unless defined(&IXGBE_LED_MODE_SHIFT);
    eval 'sub IXGBE_LED_IVRT {
        my($_i) = @_;
	    eval q( &IXGBE_LED_OFFSET( &IXGBE_LED_IVRT_BASE, $_i));
    }' unless defined(&IXGBE_LED_IVRT);
    eval 'sub IXGBE_LED_BLINK {
        my($_i) = @_;
	    eval q( &IXGBE_LED_OFFSET( &IXGBE_LED_BLINK_BASE, $_i));
    }' unless defined(&IXGBE_LED_BLINK);
    eval 'sub IXGBE_LED_MODE_MASK {
        my($_i) = @_;
	    eval q( &IXGBE_LED_OFFSET( &IXGBE_LED_MODE_MASK_BASE, $_i));
    }' unless defined(&IXGBE_LED_MODE_MASK);
    eval 'sub IXGBE_LED_LINK_UP () {0x;}' unless defined(&IXGBE_LED_LINK_UP);
    eval 'sub IXGBE_LED_LINK_10G () {0x1;}' unless defined(&IXGBE_LED_LINK_10G);
    eval 'sub IXGBE_LED_MAC () {0x2;}' unless defined(&IXGBE_LED_MAC);
    eval 'sub IXGBE_LED_FILTER () {0x3;}' unless defined(&IXGBE_LED_FILTER);
    eval 'sub IXGBE_LED_LINK_ACTIVE () {0x4;}' unless defined(&IXGBE_LED_LINK_ACTIVE);
    eval 'sub IXGBE_LED_LINK_1G () {0x5;}' unless defined(&IXGBE_LED_LINK_1G);
    eval 'sub IXGBE_LED_ON () {0xe;}' unless defined(&IXGBE_LED_ON);
    eval 'sub IXGBE_LED_OFF () {0xf;}' unless defined(&IXGBE_LED_OFF);
    eval 'sub IXGBE_AUTOC_KX4_KX_SUPP_MASK () {0xc0000000;}' unless defined(&IXGBE_AUTOC_KX4_KX_SUPP_MASK);
    eval 'sub IXGBE_AUTOC_KX4_SUPP () {0x80000000;}' unless defined(&IXGBE_AUTOC_KX4_SUPP);
    eval 'sub IXGBE_AUTOC_KX_SUPP () {0x40000000;}' unless defined(&IXGBE_AUTOC_KX_SUPP);
    eval 'sub IXGBE_AUTOC_PAUSE () {0x30000000;}' unless defined(&IXGBE_AUTOC_PAUSE);
    eval 'sub IXGBE_AUTOC_ASM_PAUSE () {0x20000000;}' unless defined(&IXGBE_AUTOC_ASM_PAUSE);
    eval 'sub IXGBE_AUTOC_SYM_PAUSE () {0x10000000;}' unless defined(&IXGBE_AUTOC_SYM_PAUSE);
    eval 'sub IXGBE_AUTOC_RF () {0x8000000;}' unless defined(&IXGBE_AUTOC_RF);
    eval 'sub IXGBE_AUTOC_PD_TMR () {0x6000000;}' unless defined(&IXGBE_AUTOC_PD_TMR);
    eval 'sub IXGBE_AUTOC_AN_RX_LOOSE () {0x1000000;}' unless defined(&IXGBE_AUTOC_AN_RX_LOOSE);
    eval 'sub IXGBE_AUTOC_AN_RX_DRIFT () {0x800000;}' unless defined(&IXGBE_AUTOC_AN_RX_DRIFT);
    eval 'sub IXGBE_AUTOC_AN_RX_ALIGN () {0x7c0000;}' unless defined(&IXGBE_AUTOC_AN_RX_ALIGN);
    eval 'sub IXGBE_AUTOC_FECA () {0x40000;}' unless defined(&IXGBE_AUTOC_FECA);
    eval 'sub IXGBE_AUTOC_FECR () {0x20000;}' unless defined(&IXGBE_AUTOC_FECR);
    eval 'sub IXGBE_AUTOC_KR_SUPP () {0x10000;}' unless defined(&IXGBE_AUTOC_KR_SUPP);
    eval 'sub IXGBE_AUTOC_AN_RESTART () {0x1000;}' unless defined(&IXGBE_AUTOC_AN_RESTART);
    eval 'sub IXGBE_AUTOC_FLU () {0x1;}' unless defined(&IXGBE_AUTOC_FLU);
    eval 'sub IXGBE_AUTOC_LMS_SHIFT () {13;}' unless defined(&IXGBE_AUTOC_LMS_SHIFT);
    eval 'sub IXGBE_AUTOC_LMS_10G_SERIAL () {(0x3 <<  &IXGBE_AUTOC_LMS_SHIFT);}' unless defined(&IXGBE_AUTOC_LMS_10G_SERIAL);
    eval 'sub IXGBE_AUTOC_LMS_KX4_KX_KR () {(0x4 <<  &IXGBE_AUTOC_LMS_SHIFT);}' unless defined(&IXGBE_AUTOC_LMS_KX4_KX_KR);
    eval 'sub IXGBE_AUTOC_LMS_SGMII_1G_100M () {(0x5 <<  &IXGBE_AUTOC_LMS_SHIFT);}' unless defined(&IXGBE_AUTOC_LMS_SGMII_1G_100M);
    eval 'sub IXGBE_AUTOC_LMS_KX4_KX_KR_1G_AN () {(0x6 <<  &IXGBE_AUTOC_LMS_SHIFT);}' unless defined(&IXGBE_AUTOC_LMS_KX4_KX_KR_1G_AN);
    eval 'sub IXGBE_AUTOC_LMS_KX4_KX_KR_SGMII () {(0x7 <<  &IXGBE_AUTOC_LMS_SHIFT);}' unless defined(&IXGBE_AUTOC_LMS_KX4_KX_KR_SGMII);
    eval 'sub IXGBE_AUTOC_LMS_MASK () {(0x7 <<  &IXGBE_AUTOC_LMS_SHIFT);}' unless defined(&IXGBE_AUTOC_LMS_MASK);
    eval 'sub IXGBE_AUTOC_LMS_1G_LINK_NO_AN () {(0x <<  &IXGBE_AUTOC_LMS_SHIFT);}' unless defined(&IXGBE_AUTOC_LMS_1G_LINK_NO_AN);
    eval 'sub IXGBE_AUTOC_LMS_10G_LINK_NO_AN () {(0x1 <<  &IXGBE_AUTOC_LMS_SHIFT);}' unless defined(&IXGBE_AUTOC_LMS_10G_LINK_NO_AN);
    eval 'sub IXGBE_AUTOC_LMS_1G_AN () {(0x2 <<  &IXGBE_AUTOC_LMS_SHIFT);}' unless defined(&IXGBE_AUTOC_LMS_1G_AN);
    eval 'sub IXGBE_AUTOC_LMS_KX4_AN () {(0x4 <<  &IXGBE_AUTOC_LMS_SHIFT);}' unless defined(&IXGBE_AUTOC_LMS_KX4_AN);
    eval 'sub IXGBE_AUTOC_LMS_KX4_AN_1G_AN () {(0x6 <<  &IXGBE_AUTOC_LMS_SHIFT);}' unless defined(&IXGBE_AUTOC_LMS_KX4_AN_1G_AN);
    eval 'sub IXGBE_AUTOC_LMS_ATTACH_TYPE () {(0x7 <<  &IXGBE_AUTOC_10G_PMA_PMD_SHIFT);}' unless defined(&IXGBE_AUTOC_LMS_ATTACH_TYPE);
    eval 'sub IXGBE_AUTOC_1G_PMA_PMD_MASK () {0x200;}' unless defined(&IXGBE_AUTOC_1G_PMA_PMD_MASK);
    eval 'sub IXGBE_AUTOC_1G_PMA_PMD_SHIFT () {9;}' unless defined(&IXGBE_AUTOC_1G_PMA_PMD_SHIFT);
    eval 'sub IXGBE_AUTOC_10G_PMA_PMD_MASK () {0x180;}' unless defined(&IXGBE_AUTOC_10G_PMA_PMD_MASK);
    eval 'sub IXGBE_AUTOC_10G_PMA_PMD_SHIFT () {7;}' unless defined(&IXGBE_AUTOC_10G_PMA_PMD_SHIFT);
    eval 'sub IXGBE_AUTOC_10G_XAUI () {(0x <<  &IXGBE_AUTOC_10G_PMA_PMD_SHIFT);}' unless defined(&IXGBE_AUTOC_10G_XAUI);
    eval 'sub IXGBE_AUTOC_10G_KX4 () {(0x1 <<  &IXGBE_AUTOC_10G_PMA_PMD_SHIFT);}' unless defined(&IXGBE_AUTOC_10G_KX4);
    eval 'sub IXGBE_AUTOC_10G_CX4 () {(0x2 <<  &IXGBE_AUTOC_10G_PMA_PMD_SHIFT);}' unless defined(&IXGBE_AUTOC_10G_CX4);
    eval 'sub IXGBE_AUTOC_1G_BX () {(0x <<  &IXGBE_AUTOC_1G_PMA_PMD_SHIFT);}' unless defined(&IXGBE_AUTOC_1G_BX);
    eval 'sub IXGBE_AUTOC_1G_KX () {(0x1 <<  &IXGBE_AUTOC_1G_PMA_PMD_SHIFT);}' unless defined(&IXGBE_AUTOC_1G_KX);
    eval 'sub IXGBE_AUTOC_1G_SFI () {(0x <<  &IXGBE_AUTOC_1G_PMA_PMD_SHIFT);}' unless defined(&IXGBE_AUTOC_1G_SFI);
    eval 'sub IXGBE_AUTOC_1G_KX_BX () {(0x1 <<  &IXGBE_AUTOC_1G_PMA_PMD_SHIFT);}' unless defined(&IXGBE_AUTOC_1G_KX_BX);
    eval 'sub IXGBE_AUTOC2_UPPER_MASK () {0xffff0000;}' unless defined(&IXGBE_AUTOC2_UPPER_MASK);
    eval 'sub IXGBE_AUTOC2_10G_SERIAL_PMA_PMD_MASK () {0x30000;}' unless defined(&IXGBE_AUTOC2_10G_SERIAL_PMA_PMD_MASK);
    eval 'sub IXGBE_AUTOC2_10G_SERIAL_PMA_PMD_SHIFT () {16;}' unless defined(&IXGBE_AUTOC2_10G_SERIAL_PMA_PMD_SHIFT);
    eval 'sub IXGBE_AUTOC2_10G_KR () {(0x <<  &IXGBE_AUTOC2_10G_SERIAL_PMA_PMD_SHIFT);}' unless defined(&IXGBE_AUTOC2_10G_KR);
    eval 'sub IXGBE_AUTOC2_10G_XFI () {(0x1 <<  &IXGBE_AUTOC2_10G_SERIAL_PMA_PMD_SHIFT);}' unless defined(&IXGBE_AUTOC2_10G_XFI);
    eval 'sub IXGBE_AUTOC2_10G_SFI () {(0x2 <<  &IXGBE_AUTOC2_10G_SERIAL_PMA_PMD_SHIFT);}' unless defined(&IXGBE_AUTOC2_10G_SFI);
    eval 'sub IXGBE_MACC_FLU () {0x1;}' unless defined(&IXGBE_MACC_FLU);
    eval 'sub IXGBE_MACC_FSV_10G () {0x30000;}' unless defined(&IXGBE_MACC_FSV_10G);
    eval 'sub IXGBE_MACC_FS () {0x40000;}' unless defined(&IXGBE_MACC_FS);
    eval 'sub IXGBE_MAC_RX2TX_LPBK () {0x2;}' unless defined(&IXGBE_MAC_RX2TX_LPBK);
    eval 'sub IXGBE_LINKS_KX_AN_COMP () {0x80000000;}' unless defined(&IXGBE_LINKS_KX_AN_COMP);
    eval 'sub IXGBE_LINKS_UP () {0x40000000;}' unless defined(&IXGBE_LINKS_UP);
    eval 'sub IXGBE_LINKS_SPEED () {0x20000000;}' unless defined(&IXGBE_LINKS_SPEED);
    eval 'sub IXGBE_LINKS_MODE () {0x18000000;}' unless defined(&IXGBE_LINKS_MODE);
    eval 'sub IXGBE_LINKS_RX_MODE () {0x6000000;}' unless defined(&IXGBE_LINKS_RX_MODE);
    eval 'sub IXGBE_LINKS_TX_MODE () {0x1800000;}' unless defined(&IXGBE_LINKS_TX_MODE);
    eval 'sub IXGBE_LINKS_XGXS_EN () {0x400000;}' unless defined(&IXGBE_LINKS_XGXS_EN);
    eval 'sub IXGBE_LINKS_SGMII_EN () {0x2000000;}' unless defined(&IXGBE_LINKS_SGMII_EN);
    eval 'sub IXGBE_LINKS_PCS_1G_EN () {0x200000;}' unless defined(&IXGBE_LINKS_PCS_1G_EN);
    eval 'sub IXGBE_LINKS_1G_AN_EN () {0x100000;}' unless defined(&IXGBE_LINKS_1G_AN_EN);
    eval 'sub IXGBE_LINKS_KX_AN_IDLE () {0x80000;}' unless defined(&IXGBE_LINKS_KX_AN_IDLE);
    eval 'sub IXGBE_LINKS_1G_SYNC () {0x40000;}' unless defined(&IXGBE_LINKS_1G_SYNC);
    eval 'sub IXGBE_LINKS_10G_ALIGN () {0x20000;}' unless defined(&IXGBE_LINKS_10G_ALIGN);
    eval 'sub IXGBE_LINKS_10G_LANE_SYNC () {0x17000;}' unless defined(&IXGBE_LINKS_10G_LANE_SYNC);
    eval 'sub IXGBE_LINKS_TL_FAULT () {0x1000;}' unless defined(&IXGBE_LINKS_TL_FAULT);
    eval 'sub IXGBE_LINKS_SIGNAL () {0xf00;}' unless defined(&IXGBE_LINKS_SIGNAL);
    eval 'sub IXGBE_LINKS_SPEED_82599 () {0x30000000;}' unless defined(&IXGBE_LINKS_SPEED_82599);
    eval 'sub IXGBE_LINKS_SPEED_10G_82599 () {0x30000000;}' unless defined(&IXGBE_LINKS_SPEED_10G_82599);
    eval 'sub IXGBE_LINKS_SPEED_1G_82599 () {0x20000000;}' unless defined(&IXGBE_LINKS_SPEED_1G_82599);
    eval 'sub IXGBE_LINKS_SPEED_100_82599 () {0x10000000;}' unless defined(&IXGBE_LINKS_SPEED_100_82599);
    eval 'sub IXGBE_LINK_UP_TIME () {90;}' unless defined(&IXGBE_LINK_UP_TIME);
    eval 'sub IXGBE_AUTO_NEG_TIME () {45;}' unless defined(&IXGBE_AUTO_NEG_TIME);
    eval 'sub IXGBE_LINKS2_AN_SUPPORTED () {0x40;}' unless defined(&IXGBE_LINKS2_AN_SUPPORTED);
    eval 'sub IXGBE_PCS1GLSTA_LINK_OK () {1;}' unless defined(&IXGBE_PCS1GLSTA_LINK_OK);
    eval 'sub IXGBE_PCS1GLSTA_SYNK_OK () {0x10;}' unless defined(&IXGBE_PCS1GLSTA_SYNK_OK);
    eval 'sub IXGBE_PCS1GLSTA_AN_COMPLETE () {0x10000;}' unless defined(&IXGBE_PCS1GLSTA_AN_COMPLETE);
    eval 'sub IXGBE_PCS1GLSTA_AN_PAGE_RX () {0x20000;}' unless defined(&IXGBE_PCS1GLSTA_AN_PAGE_RX);
    eval 'sub IXGBE_PCS1GLSTA_AN_TIMED_OUT () {0x40000;}' unless defined(&IXGBE_PCS1GLSTA_AN_TIMED_OUT);
    eval 'sub IXGBE_PCS1GLSTA_AN_REMOTE_FAULT () {0x80000;}' unless defined(&IXGBE_PCS1GLSTA_AN_REMOTE_FAULT);
    eval 'sub IXGBE_PCS1GLSTA_AN_ERROR_RWS () {0x100000;}' unless defined(&IXGBE_PCS1GLSTA_AN_ERROR_RWS);
    eval 'sub IXGBE_PCS1GANA_SYM_PAUSE () {0x80;}' unless defined(&IXGBE_PCS1GANA_SYM_PAUSE);
    eval 'sub IXGBE_PCS1GANA_ASM_PAUSE () {0x100;}' unless defined(&IXGBE_PCS1GANA_ASM_PAUSE);
    eval 'sub IXGBE_PCS1GLCTL_AN_1G_TIMEOUT_EN () {0x40000;}' unless defined(&IXGBE_PCS1GLCTL_AN_1G_TIMEOUT_EN);
    eval 'sub IXGBE_PCS1GLCTL_FLV_LINK_UP () {1;}' unless defined(&IXGBE_PCS1GLCTL_FLV_LINK_UP);
    eval 'sub IXGBE_PCS1GLCTL_FORCE_LINK () {0x20;}' unless defined(&IXGBE_PCS1GLCTL_FORCE_LINK);
    eval 'sub IXGBE_PCS1GLCTL_LOW_LINK_LATCH () {0x40;}' unless defined(&IXGBE_PCS1GLCTL_LOW_LINK_LATCH);
    eval 'sub IXGBE_PCS1GLCTL_AN_ENABLE () {0x10000;}' unless defined(&IXGBE_PCS1GLCTL_AN_ENABLE);
    eval 'sub IXGBE_PCS1GLCTL_AN_RESTART () {0x20000;}' unless defined(&IXGBE_PCS1GLCTL_AN_RESTART);
    eval 'sub IXGBE_ANLP1_PAUSE () {0xc00;}' unless defined(&IXGBE_ANLP1_PAUSE);
    eval 'sub IXGBE_ANLP1_SYM_PAUSE () {0x400;}' unless defined(&IXGBE_ANLP1_SYM_PAUSE);
    eval 'sub IXGBE_ANLP1_ASM_PAUSE () {0x800;}' unless defined(&IXGBE_ANLP1_ASM_PAUSE);
    eval 'sub IXGBE_ANLP1_AN_STATE_MASK () {0xf0000;}' unless defined(&IXGBE_ANLP1_AN_STATE_MASK);
    eval 'sub IXGBE_SWSM_SMBI () {0x1;}' unless defined(&IXGBE_SWSM_SMBI);
    eval 'sub IXGBE_SWSM_SWESMBI () {0x2;}' unless defined(&IXGBE_SWSM_SWESMBI);
    eval 'sub IXGBE_SWSM_WMNG () {0x4;}' unless defined(&IXGBE_SWSM_WMNG);
    eval 'sub IXGBE_SWFW_REGSMP () {0x80000000;}' unless defined(&IXGBE_SWFW_REGSMP);
    eval 'sub IXGBE_GSSR_EEP_SM () {0x1;}' unless defined(&IXGBE_GSSR_EEP_SM);
    eval 'sub IXGBE_GSSR_PHY0_SM () {0x2;}' unless defined(&IXGBE_GSSR_PHY0_SM);
    eval 'sub IXGBE_GSSR_PHY1_SM () {0x4;}' unless defined(&IXGBE_GSSR_PHY1_SM);
    eval 'sub IXGBE_GSSR_MAC_CSR_SM () {0x8;}' unless defined(&IXGBE_GSSR_MAC_CSR_SM);
    eval 'sub IXGBE_GSSR_FLASH_SM () {0x10;}' unless defined(&IXGBE_GSSR_FLASH_SM);
    eval 'sub IXGBE_GSSR_SW_MNG_SM () {0x400;}' unless defined(&IXGBE_GSSR_SW_MNG_SM);
    eval 'sub IXGBE_EEC_SK () {0x1;}' unless defined(&IXGBE_EEC_SK);
    eval 'sub IXGBE_EEC_CS () {0x2;}' unless defined(&IXGBE_EEC_CS);
    eval 'sub IXGBE_EEC_DI () {0x4;}' unless defined(&IXGBE_EEC_DI);
    eval 'sub IXGBE_EEC_DO () {0x8;}' unless defined(&IXGBE_EEC_DO);
    eval 'sub IXGBE_EEC_FWE_MASK () {0x30;}' unless defined(&IXGBE_EEC_FWE_MASK);
    eval 'sub IXGBE_EEC_FWE_DIS () {0x10;}' unless defined(&IXGBE_EEC_FWE_DIS);
    eval 'sub IXGBE_EEC_FWE_EN () {0x20;}' unless defined(&IXGBE_EEC_FWE_EN);
    eval 'sub IXGBE_EEC_FWE_SHIFT () {4;}' unless defined(&IXGBE_EEC_FWE_SHIFT);
    eval 'sub IXGBE_EEC_REQ () {0x40;}' unless defined(&IXGBE_EEC_REQ);
    eval 'sub IXGBE_EEC_GNT () {0x80;}' unless defined(&IXGBE_EEC_GNT);
    eval 'sub IXGBE_EEC_PRES () {0x100;}' unless defined(&IXGBE_EEC_PRES);
    eval 'sub IXGBE_EEC_ARD () {0x200;}' unless defined(&IXGBE_EEC_ARD);
    eval 'sub IXGBE_EEC_FLUP () {0x800000;}' unless defined(&IXGBE_EEC_FLUP);
    eval 'sub IXGBE_EEC_SEC1VAL () {0x2000000;}' unless defined(&IXGBE_EEC_SEC1VAL);
    eval 'sub IXGBE_EEC_FLUDONE () {0x4000000;}' unless defined(&IXGBE_EEC_FLUDONE);
    eval 'sub IXGBE_EEC_ADDR_SIZE () {0x400;}' unless defined(&IXGBE_EEC_ADDR_SIZE);
    eval 'sub IXGBE_EEC_SIZE () {0x7800;}' unless defined(&IXGBE_EEC_SIZE);
    eval 'sub IXGBE_EEC_SIZE_SHIFT () {11;}' unless defined(&IXGBE_EEC_SIZE_SHIFT);
    eval 'sub IXGBE_EEPROM_WORD_SIZE_BASE_SHIFT () {6;}' unless defined(&IXGBE_EEPROM_WORD_SIZE_BASE_SHIFT);
    eval 'sub IXGBE_EEPROM_OPCODE_BITS () {8;}' unless defined(&IXGBE_EEPROM_OPCODE_BITS);
    eval 'sub IXGBE_PBANUM_LENGTH () {11;}' unless defined(&IXGBE_PBANUM_LENGTH);
    eval 'sub IXGBE_PBANUM_PTR_GUARD () {0xfafa;}' unless defined(&IXGBE_PBANUM_PTR_GUARD);
    eval 'sub IXGBE_EEPROM_CHECKSUM () {0x3f;}' unless defined(&IXGBE_EEPROM_CHECKSUM);
    eval 'sub IXGBE_EEPROM_SUM () {0xbaba;}' unless defined(&IXGBE_EEPROM_SUM);
    eval 'sub IXGBE_PCIE_ANALOG_PTR () {0x3;}' unless defined(&IXGBE_PCIE_ANALOG_PTR);
    eval 'sub IXGBE_ATLAS0_CONFIG_PTR () {0x4;}' unless defined(&IXGBE_ATLAS0_CONFIG_PTR);
    eval 'sub IXGBE_PHY_PTR () {0x4;}' unless defined(&IXGBE_PHY_PTR);
    eval 'sub IXGBE_ATLAS1_CONFIG_PTR () {0x5;}' unless defined(&IXGBE_ATLAS1_CONFIG_PTR);
    eval 'sub IXGBE_OPTION_ROM_PTR () {0x5;}' unless defined(&IXGBE_OPTION_ROM_PTR);
    eval 'sub IXGBE_PCIE_GENERAL_PTR () {0x6;}' unless defined(&IXGBE_PCIE_GENERAL_PTR);
    eval 'sub IXGBE_PCIE_CONFIG0_PTR () {0x7;}' unless defined(&IXGBE_PCIE_CONFIG0_PTR);
    eval 'sub IXGBE_PCIE_CONFIG1_PTR () {0x8;}' unless defined(&IXGBE_PCIE_CONFIG1_PTR);
    eval 'sub IXGBE_CORE0_PTR () {0x9;}' unless defined(&IXGBE_CORE0_PTR);
    eval 'sub IXGBE_CORE1_PTR () {0xa;}' unless defined(&IXGBE_CORE1_PTR);
    eval 'sub IXGBE_MAC0_PTR () {0xb;}' unless defined(&IXGBE_MAC0_PTR);
    eval 'sub IXGBE_MAC1_PTR () {0xc;}' unless defined(&IXGBE_MAC1_PTR);
    eval 'sub IXGBE_CSR0_CONFIG_PTR () {0xd;}' unless defined(&IXGBE_CSR0_CONFIG_PTR);
    eval 'sub IXGBE_CSR1_CONFIG_PTR () {0xe;}' unless defined(&IXGBE_CSR1_CONFIG_PTR);
    eval 'sub IXGBE_FW_PTR () {0xf;}' unless defined(&IXGBE_FW_PTR);
    eval 'sub IXGBE_PBANUM0_PTR () {0x15;}' unless defined(&IXGBE_PBANUM0_PTR);
    eval 'sub IXGBE_PBANUM1_PTR () {0x16;}' unless defined(&IXGBE_PBANUM1_PTR);
    eval 'sub IXGBE_SAN_MAC_ADDR_PTR () {0x28;}' unless defined(&IXGBE_SAN_MAC_ADDR_PTR);
    eval 'sub IXGBE_DEVICE_CAPS () {0x2c;}' unless defined(&IXGBE_DEVICE_CAPS);
    eval 'sub IXGBE_SERIAL_NUMBER_MAC_ADDR () {0x11;}' unless defined(&IXGBE_SERIAL_NUMBER_MAC_ADDR);
    eval 'sub IXGBE_PCIE_MSIX_82599_CAPS () {0x72;}' unless defined(&IXGBE_PCIE_MSIX_82599_CAPS);
    eval 'sub IXGBE_PCIE_MSIX_82598_CAPS () {0x62;}' unless defined(&IXGBE_PCIE_MSIX_82598_CAPS);
    eval 'sub IXGBE_PCIE_MSIX_TBL_SZ_MASK () {0x7ff;}' unless defined(&IXGBE_PCIE_MSIX_TBL_SZ_MASK);
    eval 'sub IXGBE_ISCSI_BOOT_CAPS () {0x33;}' unless defined(&IXGBE_ISCSI_BOOT_CAPS);
    eval 'sub IXGBE_ISCSI_SETUP_PORT_0 () {0x30;}' unless defined(&IXGBE_ISCSI_SETUP_PORT_0);
    eval 'sub IXGBE_ISCSI_SETUP_PORT_1 () {0x34;}' unless defined(&IXGBE_ISCSI_SETUP_PORT_1);
    eval 'sub IXGBE_EEPROM_MAX_RETRY_SPI () {5000;}' unless defined(&IXGBE_EEPROM_MAX_RETRY_SPI);
    eval 'sub IXGBE_EEPROM_STATUS_RDY_SPI () {0x1;}' unless defined(&IXGBE_EEPROM_STATUS_RDY_SPI);
    eval 'sub IXGBE_EEPROM_READ_OPCODE_SPI () {0x3;}' unless defined(&IXGBE_EEPROM_READ_OPCODE_SPI);
    eval 'sub IXGBE_EEPROM_WRITE_OPCODE_SPI () {0x2;}' unless defined(&IXGBE_EEPROM_WRITE_OPCODE_SPI);
    eval 'sub IXGBE_EEPROM_A8_OPCODE_SPI () {0x8;}' unless defined(&IXGBE_EEPROM_A8_OPCODE_SPI);
    eval 'sub IXGBE_EEPROM_WREN_OPCODE_SPI () {0x6;}' unless defined(&IXGBE_EEPROM_WREN_OPCODE_SPI);
    eval 'sub IXGBE_EEPROM_WRDI_OPCODE_SPI () {0x4;}' unless defined(&IXGBE_EEPROM_WRDI_OPCODE_SPI);
    eval 'sub IXGBE_EEPROM_RDSR_OPCODE_SPI () {0x5;}' unless defined(&IXGBE_EEPROM_RDSR_OPCODE_SPI);
    eval 'sub IXGBE_EEPROM_WRSR_OPCODE_SPI () {0x1;}' unless defined(&IXGBE_EEPROM_WRSR_OPCODE_SPI);
    eval 'sub IXGBE_EEPROM_ERASE4K_OPCODE_SPI () {0x20;}' unless defined(&IXGBE_EEPROM_ERASE4K_OPCODE_SPI);
    eval 'sub IXGBE_EEPROM_ERASE64K_OPCODE_SPI () {0xd8;}' unless defined(&IXGBE_EEPROM_ERASE64K_OPCODE_SPI);
    eval 'sub IXGBE_EEPROM_ERASE256_OPCODE_SPI () {0xdb;}' unless defined(&IXGBE_EEPROM_ERASE256_OPCODE_SPI);
    eval 'sub IXGBE_EEPROM_RW_REG_DATA () {16;}' unless defined(&IXGBE_EEPROM_RW_REG_DATA);
    eval 'sub IXGBE_EEPROM_RW_REG_DONE () {2;}' unless defined(&IXGBE_EEPROM_RW_REG_DONE);
    eval 'sub IXGBE_EEPROM_RW_REG_START () {1;}' unless defined(&IXGBE_EEPROM_RW_REG_START);
    eval 'sub IXGBE_EEPROM_RW_ADDR_SHIFT () {2;}' unless defined(&IXGBE_EEPROM_RW_ADDR_SHIFT);
    eval 'sub IXGBE_NVM_POLL_WRITE () {1;}' unless defined(&IXGBE_NVM_POLL_WRITE);
    eval 'sub IXGBE_NVM_POLL_READ () {0;}' unless defined(&IXGBE_NVM_POLL_READ);
    eval 'sub IXGBE_ETH_LENGTH_OF_ADDRESS () {6;}' unless defined(&IXGBE_ETH_LENGTH_OF_ADDRESS);
    unless(defined(&IXGBE_EEPROM_GRANT_ATTEMPTS)) {
	eval 'sub IXGBE_EEPROM_GRANT_ATTEMPTS () {1000;}' unless defined(&IXGBE_EEPROM_GRANT_ATTEMPTS);
    }
    eval 'sub IXGBE_EERD_EEWR_ATTEMPTS () {100000;}' unless defined(&IXGBE_EERD_EEWR_ATTEMPTS);
    eval 'sub IXGBE_FLUDONE_ATTEMPTS () {20000;}' unless defined(&IXGBE_FLUDONE_ATTEMPTS);
    eval 'sub IXGBE_PCIE_CTRL2 () {0x5;}' unless defined(&IXGBE_PCIE_CTRL2);
    eval 'sub IXGBE_PCIE_CTRL2_DUMMY_ENABLE () {0x8;}' unless defined(&IXGBE_PCIE_CTRL2_DUMMY_ENABLE);
    eval 'sub IXGBE_PCIE_CTRL2_LAN_DISABLE () {0x2;}' unless defined(&IXGBE_PCIE_CTRL2_LAN_DISABLE);
    eval 'sub IXGBE_PCIE_CTRL2_DISABLE_SELECT () {0x1;}' unless defined(&IXGBE_PCIE_CTRL2_DISABLE_SELECT);
    eval 'sub IXGBE_SAN_MAC_ADDR_PORT0_OFFSET () {0x;}' unless defined(&IXGBE_SAN_MAC_ADDR_PORT0_OFFSET);
    eval 'sub IXGBE_SAN_MAC_ADDR_PORT1_OFFSET () {0x3;}' unless defined(&IXGBE_SAN_MAC_ADDR_PORT1_OFFSET);
    eval 'sub IXGBE_DEVICE_CAPS_ALLOW_ANY_SFP () {0x1;}' unless defined(&IXGBE_DEVICE_CAPS_ALLOW_ANY_SFP);
    eval 'sub IXGBE_DEVICE_CAPS_FCOE_OFFLOADS () {0x2;}' unless defined(&IXGBE_DEVICE_CAPS_FCOE_OFFLOADS);
    eval 'sub IXGBE_FW_LESM_PARAMETERS_PTR () {0x2;}' unless defined(&IXGBE_FW_LESM_PARAMETERS_PTR);
    eval 'sub IXGBE_FW_LESM_STATE_1 () {0x1;}' unless defined(&IXGBE_FW_LESM_STATE_1);
    eval 'sub IXGBE_FW_LESM_STATE_ENABLED () {0x8000;}' unless defined(&IXGBE_FW_LESM_STATE_ENABLED);
    eval 'sub IXGBE_FW_PASSTHROUGH_PATCH_CONFIG_PTR () {0x4;}' unless defined(&IXGBE_FW_PASSTHROUGH_PATCH_CONFIG_PTR);
    eval 'sub IXGBE_FW_PATCH_VERSION_4 () {0x7;}' unless defined(&IXGBE_FW_PATCH_VERSION_4);
    eval 'sub IXGBE_FCOE_IBA_CAPS_BLK_PTR () {0x33;}' unless defined(&IXGBE_FCOE_IBA_CAPS_BLK_PTR);
    eval 'sub IXGBE_FCOE_IBA_CAPS_FCOE () {0x20;}' unless defined(&IXGBE_FCOE_IBA_CAPS_FCOE);
    eval 'sub IXGBE_ISCSI_FCOE_BLK_PTR () {0x17;}' unless defined(&IXGBE_ISCSI_FCOE_BLK_PTR);
    eval 'sub IXGBE_ISCSI_FCOE_FLAGS_OFFSET () {0x;}' unless defined(&IXGBE_ISCSI_FCOE_FLAGS_OFFSET);
    eval 'sub IXGBE_ISCSI_FCOE_FLAGS_ENABLE () {0x1;}' unless defined(&IXGBE_ISCSI_FCOE_FLAGS_ENABLE);
    eval 'sub IXGBE_ALT_SAN_MAC_ADDR_BLK_PTR () {0x27;}' unless defined(&IXGBE_ALT_SAN_MAC_ADDR_BLK_PTR);
    eval 'sub IXGBE_ALT_SAN_MAC_ADDR_CAPS_OFFSET () {0x;}' unless defined(&IXGBE_ALT_SAN_MAC_ADDR_CAPS_OFFSET);
    eval 'sub IXGBE_ALT_SAN_MAC_ADDR_PORT0_OFFSET () {0x1;}' unless defined(&IXGBE_ALT_SAN_MAC_ADDR_PORT0_OFFSET);
    eval 'sub IXGBE_ALT_SAN_MAC_ADDR_PORT1_OFFSET () {0x4;}' unless defined(&IXGBE_ALT_SAN_MAC_ADDR_PORT1_OFFSET);
    eval 'sub IXGBE_ALT_SAN_MAC_ADDR_WWNN_OFFSET () {0x7;}' unless defined(&IXGBE_ALT_SAN_MAC_ADDR_WWNN_OFFSET);
    eval 'sub IXGBE_ALT_SAN_MAC_ADDR_WWPN_OFFSET () {0x8;}' unless defined(&IXGBE_ALT_SAN_MAC_ADDR_WWPN_OFFSET);
    eval 'sub IXGBE_ALT_SAN_MAC_ADDR_CAPS_SANMAC () {0x;}' unless defined(&IXGBE_ALT_SAN_MAC_ADDR_CAPS_SANMAC);
    eval 'sub IXGBE_ALT_SAN_MAC_ADDR_CAPS_ALTWWN () {0x1;}' unless defined(&IXGBE_ALT_SAN_MAC_ADDR_CAPS_ALTWWN);
    eval 'sub IXGBE_PCI_DEVICE_STATUS () {0xaa;}' unless defined(&IXGBE_PCI_DEVICE_STATUS);
    eval 'sub IXGBE_PCI_DEVICE_STATUS_TRANSACTION_PENDING () {0x20;}' unless defined(&IXGBE_PCI_DEVICE_STATUS_TRANSACTION_PENDING);
    eval 'sub IXGBE_PCI_LINK_STATUS () {0xb2;}' unless defined(&IXGBE_PCI_LINK_STATUS);
    eval 'sub IXGBE_PCI_DEVICE_CONTROL2 () {0xc8;}' unless defined(&IXGBE_PCI_DEVICE_CONTROL2);
    eval 'sub IXGBE_PCI_LINK_WIDTH () {0x3f0;}' unless defined(&IXGBE_PCI_LINK_WIDTH);
    eval 'sub IXGBE_PCI_LINK_WIDTH_1 () {0x10;}' unless defined(&IXGBE_PCI_LINK_WIDTH_1);
    eval 'sub IXGBE_PCI_LINK_WIDTH_2 () {0x20;}' unless defined(&IXGBE_PCI_LINK_WIDTH_2);
    eval 'sub IXGBE_PCI_LINK_WIDTH_4 () {0x40;}' unless defined(&IXGBE_PCI_LINK_WIDTH_4);
    eval 'sub IXGBE_PCI_LINK_WIDTH_8 () {0x80;}' unless defined(&IXGBE_PCI_LINK_WIDTH_8);
    eval 'sub IXGBE_PCI_LINK_SPEED () {0xf;}' unless defined(&IXGBE_PCI_LINK_SPEED);
    eval 'sub IXGBE_PCI_LINK_SPEED_2500 () {0x1;}' unless defined(&IXGBE_PCI_LINK_SPEED_2500);
    eval 'sub IXGBE_PCI_LINK_SPEED_5000 () {0x2;}' unless defined(&IXGBE_PCI_LINK_SPEED_5000);
    eval 'sub IXGBE_PCI_HEADER_TYPE_REGISTER () {0xe;}' unless defined(&IXGBE_PCI_HEADER_TYPE_REGISTER);
    eval 'sub IXGBE_PCI_HEADER_TYPE_MULTIFUNC () {0x80;}' unless defined(&IXGBE_PCI_HEADER_TYPE_MULTIFUNC);
    eval 'sub IXGBE_PCI_DEVICE_CONTROL2_16ms () {0x5;}' unless defined(&IXGBE_PCI_DEVICE_CONTROL2_16ms);
    eval 'sub IXGBE_PCI_MASTER_DISABLE_TIMEOUT () {800;}' unless defined(&IXGBE_PCI_MASTER_DISABLE_TIMEOUT);
    eval 'sub IXGBE_IS_MULTICAST {
        my($Address) = @_;
	    eval q(((( &uint8_t *)($Address))[0] & (( &uint8_t)0x1)));
    }' unless defined(&IXGBE_IS_MULTICAST);
    eval 'sub IXGBE_IS_BROADCAST {
        my($Address) = @_;
	    eval q((((( &uint8_t *)($Address))[0] == (( &uint8_t)0xff))  && ((( &uint8_t *)($Address))[1] == (( &uint8_t)0xff))));
    }' unless defined(&IXGBE_IS_BROADCAST);
    eval 'sub IXGBE_RAH_VIND_MASK () {0x3c0000;}' unless defined(&IXGBE_RAH_VIND_MASK);
    eval 'sub IXGBE_RAH_VIND_SHIFT () {18;}' unless defined(&IXGBE_RAH_VIND_SHIFT);
    eval 'sub IXGBE_RAH_AV () {0x80000000;}' unless defined(&IXGBE_RAH_AV);
    eval 'sub IXGBE_CLEAR_VMDQ_ALL () {0xffffffff;}' unless defined(&IXGBE_CLEAR_VMDQ_ALL);
    eval 'sub IXGBE_RFCTL_ISCSI_DIS () {0x1;}' unless defined(&IXGBE_RFCTL_ISCSI_DIS);
    eval 'sub IXGBE_RFCTL_ISCSI_DWC_MASK () {0x3e;}' unless defined(&IXGBE_RFCTL_ISCSI_DWC_MASK);
    eval 'sub IXGBE_RFCTL_ISCSI_DWC_SHIFT () {1;}' unless defined(&IXGBE_RFCTL_ISCSI_DWC_SHIFT);
    eval 'sub IXGBE_RFCTL_NFSW_DIS () {0x40;}' unless defined(&IXGBE_RFCTL_NFSW_DIS);
    eval 'sub IXGBE_RFCTL_NFSR_DIS () {0x80;}' unless defined(&IXGBE_RFCTL_NFSR_DIS);
    eval 'sub IXGBE_RFCTL_NFS_VER_MASK () {0x300;}' unless defined(&IXGBE_RFCTL_NFS_VER_MASK);
    eval 'sub IXGBE_RFCTL_NFS_VER_SHIFT () {8;}' unless defined(&IXGBE_RFCTL_NFS_VER_SHIFT);
    eval 'sub IXGBE_RFCTL_NFS_VER_2 () {0;}' unless defined(&IXGBE_RFCTL_NFS_VER_2);
    eval 'sub IXGBE_RFCTL_NFS_VER_3 () {1;}' unless defined(&IXGBE_RFCTL_NFS_VER_3);
    eval 'sub IXGBE_RFCTL_NFS_VER_4 () {2;}' unless defined(&IXGBE_RFCTL_NFS_VER_4);
    eval 'sub IXGBE_RFCTL_IPV6_DIS () {0x400;}' unless defined(&IXGBE_RFCTL_IPV6_DIS);
    eval 'sub IXGBE_RFCTL_IPV6_XSUM_DIS () {0x800;}' unless defined(&IXGBE_RFCTL_IPV6_XSUM_DIS);
    eval 'sub IXGBE_RFCTL_IPFRSP_DIS () {0x4000;}' unless defined(&IXGBE_RFCTL_IPFRSP_DIS);
    eval 'sub IXGBE_RFCTL_IPV6_EX_DIS () {0x10000;}' unless defined(&IXGBE_RFCTL_IPV6_EX_DIS);
    eval 'sub IXGBE_RFCTL_NEW_IPV6_EXT_DIS () {0x20000;}' unless defined(&IXGBE_RFCTL_NEW_IPV6_EXT_DIS);
    eval 'sub IXGBE_TXDCTL_ENABLE () {0x2000000;}' unless defined(&IXGBE_TXDCTL_ENABLE);
    eval 'sub IXGBE_TXDCTL_SWFLSH () {0x4000000;}' unless defined(&IXGBE_TXDCTL_SWFLSH);
    eval 'sub IXGBE_TXDCTL_WTHRESH_SHIFT () {16;}' unless defined(&IXGBE_TXDCTL_WTHRESH_SHIFT);
    eval 'sub IXGBE_TX_PAD_ENABLE () {0x400;}' unless defined(&IXGBE_TX_PAD_ENABLE);
    eval 'sub IXGBE_JUMBO_FRAME_ENABLE () {0x4;}' unless defined(&IXGBE_JUMBO_FRAME_ENABLE);
    eval 'sub IXGBE_MAX_FRAME_SZ () {0x40040000;}' unless defined(&IXGBE_MAX_FRAME_SZ);
    eval 'sub IXGBE_TDWBAL_HEAD_WB_ENABLE () {0x1;}' unless defined(&IXGBE_TDWBAL_HEAD_WB_ENABLE);
    eval 'sub IXGBE_TDWBAL_SEQNUM_WB_ENABLE () {0x2;}' unless defined(&IXGBE_TDWBAL_SEQNUM_WB_ENABLE);
    eval 'sub IXGBE_RXCTRL_RXEN () {0x1;}' unless defined(&IXGBE_RXCTRL_RXEN);
    eval 'sub IXGBE_RXCTRL_DMBYPS () {0x2;}' unless defined(&IXGBE_RXCTRL_DMBYPS);
    eval 'sub IXGBE_RXDCTL_ENABLE () {0x2000000;}' unless defined(&IXGBE_RXDCTL_ENABLE);
    eval 'sub IXGBE_RXDCTL_VME () {0x40000000;}' unless defined(&IXGBE_RXDCTL_VME);
    eval 'sub IXGBE_FCTRL_SBP () {0x2;}' unless defined(&IXGBE_FCTRL_SBP);
    eval 'sub IXGBE_FCTRL_MPE () {0x100;}' unless defined(&IXGBE_FCTRL_MPE);
    eval 'sub IXGBE_FCTRL_UPE () {0x200;}' unless defined(&IXGBE_FCTRL_UPE);
    eval 'sub IXGBE_FCTRL_BAM () {0x400;}' unless defined(&IXGBE_FCTRL_BAM);
    eval 'sub IXGBE_FCTRL_PMCF () {0x1000;}' unless defined(&IXGBE_FCTRL_PMCF);
    eval 'sub IXGBE_FCTRL_DPF () {0x2000;}' unless defined(&IXGBE_FCTRL_DPF);
    eval 'sub IXGBE_FCTRL_RPFCE () {0x4000;}' unless defined(&IXGBE_FCTRL_RPFCE);
    eval 'sub IXGBE_FCTRL_RFCE () {0x8000;}' unless defined(&IXGBE_FCTRL_RFCE);
    eval 'sub IXGBE_MFLCN_PMCF () {0x1;}' unless defined(&IXGBE_MFLCN_PMCF);
    eval 'sub IXGBE_MFLCN_DPF () {0x2;}' unless defined(&IXGBE_MFLCN_DPF);
    eval 'sub IXGBE_MFLCN_RPFCE () {0x4;}' unless defined(&IXGBE_MFLCN_RPFCE);
    eval 'sub IXGBE_MFLCN_RFCE () {0x8;}' unless defined(&IXGBE_MFLCN_RFCE);
    eval 'sub IXGBE_MFLCN_RPFCE_MASK () {0xff4;}' unless defined(&IXGBE_MFLCN_RPFCE_MASK);
    eval 'sub IXGBE_MRQC_RSSEN () {0x1;}' unless defined(&IXGBE_MRQC_RSSEN);
    eval 'sub IXGBE_MRQC_MRQE_MASK () {0xf;}' unless defined(&IXGBE_MRQC_MRQE_MASK);
    eval 'sub IXGBE_MRQC_RT8TCEN () {0x2;}' unless defined(&IXGBE_MRQC_RT8TCEN);
    eval 'sub IXGBE_MRQC_RT4TCEN () {0x3;}' unless defined(&IXGBE_MRQC_RT4TCEN);
    eval 'sub IXGBE_MRQC_RTRSS8TCEN () {0x4;}' unless defined(&IXGBE_MRQC_RTRSS8TCEN);
    eval 'sub IXGBE_MRQC_RTRSS4TCEN () {0x5;}' unless defined(&IXGBE_MRQC_RTRSS4TCEN);
    eval 'sub IXGBE_MRQC_VMDQEN () {0x8;}' unless defined(&IXGBE_MRQC_VMDQEN);
    eval 'sub IXGBE_MRQC_VMDQRSS32EN () {0xa;}' unless defined(&IXGBE_MRQC_VMDQRSS32EN);
    eval 'sub IXGBE_MRQC_VMDQRSS64EN () {0xb;}' unless defined(&IXGBE_MRQC_VMDQRSS64EN);
    eval 'sub IXGBE_MRQC_VMDQRT8TCEN () {0xc;}' unless defined(&IXGBE_MRQC_VMDQRT8TCEN);
    eval 'sub IXGBE_MRQC_VMDQRT4TCEN () {0xd;}' unless defined(&IXGBE_MRQC_VMDQRT4TCEN);
    eval 'sub IXGBE_MRQC_RSS_FIELD_MASK () {0xffff0000;}' unless defined(&IXGBE_MRQC_RSS_FIELD_MASK);
    eval 'sub IXGBE_MRQC_RSS_FIELD_IPV4_TCP () {0x10000;}' unless defined(&IXGBE_MRQC_RSS_FIELD_IPV4_TCP);
    eval 'sub IXGBE_MRQC_RSS_FIELD_IPV4 () {0x20000;}' unless defined(&IXGBE_MRQC_RSS_FIELD_IPV4);
    eval 'sub IXGBE_MRQC_RSS_FIELD_IPV6_EX_TCP () {0x40000;}' unless defined(&IXGBE_MRQC_RSS_FIELD_IPV6_EX_TCP);
    eval 'sub IXGBE_MRQC_RSS_FIELD_IPV6_EX () {0x80000;}' unless defined(&IXGBE_MRQC_RSS_FIELD_IPV6_EX);
    eval 'sub IXGBE_MRQC_RSS_FIELD_IPV6 () {0x100000;}' unless defined(&IXGBE_MRQC_RSS_FIELD_IPV6);
    eval 'sub IXGBE_MRQC_RSS_FIELD_IPV6_TCP () {0x200000;}' unless defined(&IXGBE_MRQC_RSS_FIELD_IPV6_TCP);
    eval 'sub IXGBE_MRQC_RSS_FIELD_IPV4_UDP () {0x400000;}' unless defined(&IXGBE_MRQC_RSS_FIELD_IPV4_UDP);
    eval 'sub IXGBE_MRQC_RSS_FIELD_IPV6_UDP () {0x800000;}' unless defined(&IXGBE_MRQC_RSS_FIELD_IPV6_UDP);
    eval 'sub IXGBE_MRQC_RSS_FIELD_IPV6_EX_UDP () {0x1000000;}' unless defined(&IXGBE_MRQC_RSS_FIELD_IPV6_EX_UDP);
    eval 'sub IXGBE_MRQC_L3L4TXSWEN () {0x8000;}' unless defined(&IXGBE_MRQC_L3L4TXSWEN);
    eval 'sub IXGBE_QDE_ENABLE () {0x1;}' unless defined(&IXGBE_QDE_ENABLE);
    eval 'sub IXGBE_QDE_IDX_MASK () {0x7f00;}' unless defined(&IXGBE_QDE_IDX_MASK);
    eval 'sub IXGBE_QDE_IDX_SHIFT () {8;}' unless defined(&IXGBE_QDE_IDX_SHIFT);
    eval 'sub IXGBE_TXD_POPTS_IXSM () {0x1;}' unless defined(&IXGBE_TXD_POPTS_IXSM);
    eval 'sub IXGBE_TXD_POPTS_TXSM () {0x2;}' unless defined(&IXGBE_TXD_POPTS_TXSM);
    eval 'sub IXGBE_TXD_CMD_EOP () {0x1000000;}' unless defined(&IXGBE_TXD_CMD_EOP);
    eval 'sub IXGBE_TXD_CMD_IFCS () {0x2000000;}' unless defined(&IXGBE_TXD_CMD_IFCS);
    eval 'sub IXGBE_TXD_CMD_IC () {0x4000000;}' unless defined(&IXGBE_TXD_CMD_IC);
    eval 'sub IXGBE_TXD_CMD_RS () {0x8000000;}' unless defined(&IXGBE_TXD_CMD_RS);
    eval 'sub IXGBE_TXD_CMD_DEXT () {0x20000000;}' unless defined(&IXGBE_TXD_CMD_DEXT);
    eval 'sub IXGBE_TXD_CMD_VLE () {0x40000000;}' unless defined(&IXGBE_TXD_CMD_VLE);
    eval 'sub IXGBE_TXD_STAT_DD () {0x1;}' unless defined(&IXGBE_TXD_STAT_DD);
    eval 'sub IXGBE_RXDADV_IPSEC_STATUS_SECP () {0x20000;}' unless defined(&IXGBE_RXDADV_IPSEC_STATUS_SECP);
    eval 'sub IXGBE_RXDADV_IPSEC_ERROR_INVALID_PROTOCOL () {0x8000000;}' unless defined(&IXGBE_RXDADV_IPSEC_ERROR_INVALID_PROTOCOL);
    eval 'sub IXGBE_RXDADV_IPSEC_ERROR_INVALID_LENGTH () {0x10000000;}' unless defined(&IXGBE_RXDADV_IPSEC_ERROR_INVALID_LENGTH);
    eval 'sub IXGBE_RXDADV_IPSEC_ERROR_AUTH_FAILED () {0x18000000;}' unless defined(&IXGBE_RXDADV_IPSEC_ERROR_AUTH_FAILED);
    eval 'sub IXGBE_RXDADV_IPSEC_ERROR_BIT_MASK () {0x18000000;}' unless defined(&IXGBE_RXDADV_IPSEC_ERROR_BIT_MASK);
    eval 'sub IXGBE_MTQC_RT_ENA () {0x1;}' unless defined(&IXGBE_MTQC_RT_ENA);
    eval 'sub IXGBE_MTQC_VT_ENA () {0x2;}' unless defined(&IXGBE_MTQC_VT_ENA);
    eval 'sub IXGBE_MTQC_64Q_1PB () {0x;}' unless defined(&IXGBE_MTQC_64Q_1PB);
    eval 'sub IXGBE_MTQC_32VF () {0x8;}' unless defined(&IXGBE_MTQC_32VF);
    eval 'sub IXGBE_MTQC_64VF () {0x4;}' unless defined(&IXGBE_MTQC_64VF);
    eval 'sub IXGBE_MTQC_4TC_4TQ () {0x8;}' unless defined(&IXGBE_MTQC_4TC_4TQ);
    eval 'sub IXGBE_MTQC_8TC_8TQ () {0xc;}' unless defined(&IXGBE_MTQC_8TC_8TQ);
    eval 'sub IXGBE_RXD_STAT_DD () {0x1;}' unless defined(&IXGBE_RXD_STAT_DD);
    eval 'sub IXGBE_RXD_STAT_EOP () {0x2;}' unless defined(&IXGBE_RXD_STAT_EOP);
    eval 'sub IXGBE_RXD_STAT_FLM () {0x4;}' unless defined(&IXGBE_RXD_STAT_FLM);
    eval 'sub IXGBE_RXD_STAT_VP () {0x8;}' unless defined(&IXGBE_RXD_STAT_VP);
    eval 'sub IXGBE_RXDADV_NEXTP_MASK () {0xffff0;}' unless defined(&IXGBE_RXDADV_NEXTP_MASK);
    eval 'sub IXGBE_RXDADV_NEXTP_SHIFT () {0x4;}' unless defined(&IXGBE_RXDADV_NEXTP_SHIFT);
    eval 'sub IXGBE_RXD_STAT_UDPCS () {0x10;}' unless defined(&IXGBE_RXD_STAT_UDPCS);
    eval 'sub IXGBE_RXD_STAT_L4CS () {0x20;}' unless defined(&IXGBE_RXD_STAT_L4CS);
    eval 'sub IXGBE_RXD_STAT_IPCS () {0x40;}' unless defined(&IXGBE_RXD_STAT_IPCS);
    eval 'sub IXGBE_RXD_STAT_PIF () {0x80;}' unless defined(&IXGBE_RXD_STAT_PIF);
    eval 'sub IXGBE_RXD_STAT_CRCV () {0x100;}' unless defined(&IXGBE_RXD_STAT_CRCV);
    eval 'sub IXGBE_RXD_STAT_VEXT () {0x200;}' unless defined(&IXGBE_RXD_STAT_VEXT);
    eval 'sub IXGBE_RXD_STAT_UDPV () {0x400;}' unless defined(&IXGBE_RXD_STAT_UDPV);
    eval 'sub IXGBE_RXD_STAT_DYNINT () {0x800;}' unless defined(&IXGBE_RXD_STAT_DYNINT);
    eval 'sub IXGBE_RXD_STAT_LLINT () {0x800;}' unless defined(&IXGBE_RXD_STAT_LLINT);
    eval 'sub IXGBE_RXD_STAT_TS () {0x10000;}' unless defined(&IXGBE_RXD_STAT_TS);
    eval 'sub IXGBE_RXD_STAT_SECP () {0x20000;}' unless defined(&IXGBE_RXD_STAT_SECP);
    eval 'sub IXGBE_RXD_STAT_LB () {0x40000;}' unless defined(&IXGBE_RXD_STAT_LB);
    eval 'sub IXGBE_RXD_STAT_ACK () {0x8000;}' unless defined(&IXGBE_RXD_STAT_ACK);
    eval 'sub IXGBE_RXD_ERR_CE () {0x1;}' unless defined(&IXGBE_RXD_ERR_CE);
    eval 'sub IXGBE_RXD_ERR_LE () {0x2;}' unless defined(&IXGBE_RXD_ERR_LE);
    eval 'sub IXGBE_RXD_ERR_PE () {0x8;}' unless defined(&IXGBE_RXD_ERR_PE);
    eval 'sub IXGBE_RXD_ERR_OSE () {0x10;}' unless defined(&IXGBE_RXD_ERR_OSE);
    eval 'sub IXGBE_RXD_ERR_USE () {0x20;}' unless defined(&IXGBE_RXD_ERR_USE);
    eval 'sub IXGBE_RXD_ERR_TCPE () {0x40;}' unless defined(&IXGBE_RXD_ERR_TCPE);
    eval 'sub IXGBE_RXD_ERR_IPE () {0x80;}' unless defined(&IXGBE_RXD_ERR_IPE);
    eval 'sub IXGBE_RXDADV_ERR_MASK () {0xfff00000;}' unless defined(&IXGBE_RXDADV_ERR_MASK);
    eval 'sub IXGBE_RXDADV_ERR_SHIFT () {20;}' unless defined(&IXGBE_RXDADV_ERR_SHIFT);
    eval 'sub IXGBE_RXDADV_ERR_FCEOFE () {0x80000000;}' unless defined(&IXGBE_RXDADV_ERR_FCEOFE);
    eval 'sub IXGBE_RXDADV_ERR_FCERR () {0x700000;}' unless defined(&IXGBE_RXDADV_ERR_FCERR);
    eval 'sub IXGBE_RXDADV_ERR_FDIR_LEN () {0x100000;}' unless defined(&IXGBE_RXDADV_ERR_FDIR_LEN);
    eval 'sub IXGBE_RXDADV_ERR_FDIR_DROP () {0x200000;}' unless defined(&IXGBE_RXDADV_ERR_FDIR_DROP);
    eval 'sub IXGBE_RXDADV_ERR_FDIR_COLL () {0x400000;}' unless defined(&IXGBE_RXDADV_ERR_FDIR_COLL);
    eval 'sub IXGBE_RXDADV_ERR_HBO () {0x800000;}' unless defined(&IXGBE_RXDADV_ERR_HBO);
    eval 'sub IXGBE_RXDADV_ERR_CE () {0x1000000;}' unless defined(&IXGBE_RXDADV_ERR_CE);
    eval 'sub IXGBE_RXDADV_ERR_LE () {0x2000000;}' unless defined(&IXGBE_RXDADV_ERR_LE);
    eval 'sub IXGBE_RXDADV_ERR_PE () {0x8000000;}' unless defined(&IXGBE_RXDADV_ERR_PE);
    eval 'sub IXGBE_RXDADV_ERR_OSE () {0x10000000;}' unless defined(&IXGBE_RXDADV_ERR_OSE);
    eval 'sub IXGBE_RXDADV_ERR_USE () {0x20000000;}' unless defined(&IXGBE_RXDADV_ERR_USE);
    eval 'sub IXGBE_RXDADV_ERR_TCPE () {0x40000000;}' unless defined(&IXGBE_RXDADV_ERR_TCPE);
    eval 'sub IXGBE_RXDADV_ERR_IPE () {0x80000000;}' unless defined(&IXGBE_RXDADV_ERR_IPE);
    eval 'sub IXGBE_RXD_VLAN_ID_MASK () {0xfff;}' unless defined(&IXGBE_RXD_VLAN_ID_MASK);
    eval 'sub IXGBE_RXD_PRI_MASK () {0xe000;}' unless defined(&IXGBE_RXD_PRI_MASK);
    eval 'sub IXGBE_RXD_PRI_SHIFT () {13;}' unless defined(&IXGBE_RXD_PRI_SHIFT);
    eval 'sub IXGBE_RXD_CFI_MASK () {0x1000;}' unless defined(&IXGBE_RXD_CFI_MASK);
    eval 'sub IXGBE_RXD_CFI_SHIFT () {12;}' unless defined(&IXGBE_RXD_CFI_SHIFT);
    eval 'sub IXGBE_RXDADV_STAT_DD () { &IXGBE_RXD_STAT_DD;}' unless defined(&IXGBE_RXDADV_STAT_DD);
    eval 'sub IXGBE_RXDADV_STAT_EOP () { &IXGBE_RXD_STAT_EOP;}' unless defined(&IXGBE_RXDADV_STAT_EOP);
    eval 'sub IXGBE_RXDADV_STAT_FLM () { &IXGBE_RXD_STAT_FLM;}' unless defined(&IXGBE_RXDADV_STAT_FLM);
    eval 'sub IXGBE_RXDADV_STAT_VP () { &IXGBE_RXD_STAT_VP;}' unless defined(&IXGBE_RXDADV_STAT_VP);
    eval 'sub IXGBE_RXDADV_STAT_MASK () {0xfffff;}' unless defined(&IXGBE_RXDADV_STAT_MASK);
    eval 'sub IXGBE_RXDADV_STAT_FCEOFS () {0x40;}' unless defined(&IXGBE_RXDADV_STAT_FCEOFS);
    eval 'sub IXGBE_RXDADV_STAT_FCSTAT () {0x30;}' unless defined(&IXGBE_RXDADV_STAT_FCSTAT);
    eval 'sub IXGBE_RXDADV_STAT_FCSTAT_NOMTCH () {0x;}' unless defined(&IXGBE_RXDADV_STAT_FCSTAT_NOMTCH);
    eval 'sub IXGBE_RXDADV_STAT_FCSTAT_NODDP () {0x10;}' unless defined(&IXGBE_RXDADV_STAT_FCSTAT_NODDP);
    eval 'sub IXGBE_RXDADV_STAT_FCSTAT_FCPRSP () {0x20;}' unless defined(&IXGBE_RXDADV_STAT_FCSTAT_FCPRSP);
    eval 'sub IXGBE_RXDADV_STAT_FCSTAT_DDP () {0x30;}' unless defined(&IXGBE_RXDADV_STAT_FCSTAT_DDP);
    eval 'sub IXGBE_PSRTYPE_TCPHDR () {0x10;}' unless defined(&IXGBE_PSRTYPE_TCPHDR);
    eval 'sub IXGBE_PSRTYPE_UDPHDR () {0x20;}' unless defined(&IXGBE_PSRTYPE_UDPHDR);
    eval 'sub IXGBE_PSRTYPE_IPV4HDR () {0x100;}' unless defined(&IXGBE_PSRTYPE_IPV4HDR);
    eval 'sub IXGBE_PSRTYPE_IPV6HDR () {0x200;}' unless defined(&IXGBE_PSRTYPE_IPV6HDR);
    eval 'sub IXGBE_PSRTYPE_L2HDR () {0x1000;}' unless defined(&IXGBE_PSRTYPE_L2HDR);
    eval 'sub IXGBE_SRRCTL_BSIZEPKT_SHIFT () {10;}' unless defined(&IXGBE_SRRCTL_BSIZEPKT_SHIFT);
    eval 'sub IXGBE_SRRCTL_RDMTS_SHIFT () {22;}' unless defined(&IXGBE_SRRCTL_RDMTS_SHIFT);
    eval 'sub IXGBE_SRRCTL_RDMTS_MASK () {0x1c00000;}' unless defined(&IXGBE_SRRCTL_RDMTS_MASK);
    eval 'sub IXGBE_SRRCTL_DROP_EN () {0x10000000;}' unless defined(&IXGBE_SRRCTL_DROP_EN);
    eval 'sub IXGBE_SRRCTL_BSIZEPKT_MASK () {0x7f;}' unless defined(&IXGBE_SRRCTL_BSIZEPKT_MASK);
    eval 'sub IXGBE_SRRCTL_BSIZEHDR_MASK () {0x3f00;}' unless defined(&IXGBE_SRRCTL_BSIZEHDR_MASK);
    eval 'sub IXGBE_SRRCTL_DESCTYPE_LEGACY () {0x;}' unless defined(&IXGBE_SRRCTL_DESCTYPE_LEGACY);
    eval 'sub IXGBE_SRRCTL_DESCTYPE_ADV_ONEBUF () {0x2000000;}' unless defined(&IXGBE_SRRCTL_DESCTYPE_ADV_ONEBUF);
    eval 'sub IXGBE_SRRCTL_DESCTYPE_HDR_SPLIT () {0x4000000;}' unless defined(&IXGBE_SRRCTL_DESCTYPE_HDR_SPLIT);
    eval 'sub IXGBE_SRRCTL_DESCTYPE_HDR_REPLICATION_LARGE_PKT () {0x8000000;}' unless defined(&IXGBE_SRRCTL_DESCTYPE_HDR_REPLICATION_LARGE_PKT);
    eval 'sub IXGBE_SRRCTL_DESCTYPE_HDR_SPLIT_ALWAYS () {0xa000000;}' unless defined(&IXGBE_SRRCTL_DESCTYPE_HDR_SPLIT_ALWAYS);
    eval 'sub IXGBE_SRRCTL_DESCTYPE_MASK () {0xe000000;}' unless defined(&IXGBE_SRRCTL_DESCTYPE_MASK);
    eval 'sub IXGBE_RXDPS_HDRSTAT_HDRSP () {0x8000;}' unless defined(&IXGBE_RXDPS_HDRSTAT_HDRSP);
    eval 'sub IXGBE_RXDPS_HDRSTAT_HDRLEN_MASK () {0x3ff;}' unless defined(&IXGBE_RXDPS_HDRSTAT_HDRLEN_MASK);
    eval 'sub IXGBE_RXDADV_RSSTYPE_MASK () {0xf;}' unless defined(&IXGBE_RXDADV_RSSTYPE_MASK);
    eval 'sub IXGBE_RXDADV_PKTTYPE_MASK () {0xfff0;}' unless defined(&IXGBE_RXDADV_PKTTYPE_MASK);
    eval 'sub IXGBE_RXDADV_PKTTYPE_MASK_EX () {0x1fff0;}' unless defined(&IXGBE_RXDADV_PKTTYPE_MASK_EX);
    eval 'sub IXGBE_RXDADV_HDRBUFLEN_MASK () {0x7fe0;}' unless defined(&IXGBE_RXDADV_HDRBUFLEN_MASK);
    eval 'sub IXGBE_RXDADV_RSCCNT_MASK () {0x1e0000;}' unless defined(&IXGBE_RXDADV_RSCCNT_MASK);
    eval 'sub IXGBE_RXDADV_RSCCNT_SHIFT () {17;}' unless defined(&IXGBE_RXDADV_RSCCNT_SHIFT);
    eval 'sub IXGBE_RXDADV_HDRBUFLEN_SHIFT () {5;}' unless defined(&IXGBE_RXDADV_HDRBUFLEN_SHIFT);
    eval 'sub IXGBE_RXDADV_SPLITHEADER_EN () {0x1000;}' unless defined(&IXGBE_RXDADV_SPLITHEADER_EN);
    eval 'sub IXGBE_RXDADV_SPH () {0x8000;}' unless defined(&IXGBE_RXDADV_SPH);
    eval 'sub IXGBE_RXDADV_RSSTYPE_NONE () {0x;}' unless defined(&IXGBE_RXDADV_RSSTYPE_NONE);
    eval 'sub IXGBE_RXDADV_RSSTYPE_IPV4_TCP () {0x1;}' unless defined(&IXGBE_RXDADV_RSSTYPE_IPV4_TCP);
    eval 'sub IXGBE_RXDADV_RSSTYPE_IPV4 () {0x2;}' unless defined(&IXGBE_RXDADV_RSSTYPE_IPV4);
    eval 'sub IXGBE_RXDADV_RSSTYPE_IPV6_TCP () {0x3;}' unless defined(&IXGBE_RXDADV_RSSTYPE_IPV6_TCP);
    eval 'sub IXGBE_RXDADV_RSSTYPE_IPV6_EX () {0x4;}' unless defined(&IXGBE_RXDADV_RSSTYPE_IPV6_EX);
    eval 'sub IXGBE_RXDADV_RSSTYPE_IPV6 () {0x5;}' unless defined(&IXGBE_RXDADV_RSSTYPE_IPV6);
    eval 'sub IXGBE_RXDADV_RSSTYPE_IPV6_TCP_EX () {0x6;}' unless defined(&IXGBE_RXDADV_RSSTYPE_IPV6_TCP_EX);
    eval 'sub IXGBE_RXDADV_RSSTYPE_IPV4_UDP () {0x7;}' unless defined(&IXGBE_RXDADV_RSSTYPE_IPV4_UDP);
    eval 'sub IXGBE_RXDADV_RSSTYPE_IPV6_UDP () {0x8;}' unless defined(&IXGBE_RXDADV_RSSTYPE_IPV6_UDP);
    eval 'sub IXGBE_RXDADV_RSSTYPE_IPV6_UDP_EX () {0x9;}' unless defined(&IXGBE_RXDADV_RSSTYPE_IPV6_UDP_EX);
    eval 'sub IXGBE_RXDADV_PKTTYPE_NONE () {0x;}' unless defined(&IXGBE_RXDADV_PKTTYPE_NONE);
    eval 'sub IXGBE_RXDADV_PKTTYPE_IPV4 () {0x10;}' unless defined(&IXGBE_RXDADV_PKTTYPE_IPV4);
    eval 'sub IXGBE_RXDADV_PKTTYPE_IPV4_EX () {0x20;}' unless defined(&IXGBE_RXDADV_PKTTYPE_IPV4_EX);
    eval 'sub IXGBE_RXDADV_PKTTYPE_IPV6 () {0x40;}' unless defined(&IXGBE_RXDADV_PKTTYPE_IPV6);
    eval 'sub IXGBE_RXDADV_PKTTYPE_IPV6_EX () {0x80;}' unless defined(&IXGBE_RXDADV_PKTTYPE_IPV6_EX);
    eval 'sub IXGBE_RXDADV_PKTTYPE_TCP () {0x100;}' unless defined(&IXGBE_RXDADV_PKTTYPE_TCP);
    eval 'sub IXGBE_RXDADV_PKTTYPE_UDP () {0x200;}' unless defined(&IXGBE_RXDADV_PKTTYPE_UDP);
    eval 'sub IXGBE_RXDADV_PKTTYPE_SCTP () {0x400;}' unless defined(&IXGBE_RXDADV_PKTTYPE_SCTP);
    eval 'sub IXGBE_RXDADV_PKTTYPE_NFS () {0x800;}' unless defined(&IXGBE_RXDADV_PKTTYPE_NFS);
    eval 'sub IXGBE_RXDADV_PKTTYPE_IPSEC_ESP () {0x1000;}' unless defined(&IXGBE_RXDADV_PKTTYPE_IPSEC_ESP);
    eval 'sub IXGBE_RXDADV_PKTTYPE_IPSEC_AH () {0x2000;}' unless defined(&IXGBE_RXDADV_PKTTYPE_IPSEC_AH);
    eval 'sub IXGBE_RXDADV_PKTTYPE_LINKSEC () {0x4000;}' unless defined(&IXGBE_RXDADV_PKTTYPE_LINKSEC);
    eval 'sub IXGBE_RXDADV_PKTTYPE_ETQF () {0x8000;}' unless defined(&IXGBE_RXDADV_PKTTYPE_ETQF);
    eval 'sub IXGBE_RXDADV_PKTTYPE_ETQF_MASK () {0x70;}' unless defined(&IXGBE_RXDADV_PKTTYPE_ETQF_MASK);
    eval 'sub IXGBE_RXDADV_PKTTYPE_ETQF_SHIFT () {4;}' unless defined(&IXGBE_RXDADV_PKTTYPE_ETQF_SHIFT);
    eval 'sub IXGBE_RXDADV_LNKSEC_STATUS_SECP () {0x20000;}' unless defined(&IXGBE_RXDADV_LNKSEC_STATUS_SECP);
    eval 'sub IXGBE_RXDADV_LNKSEC_ERROR_NO_SA_MATCH () {0x8000000;}' unless defined(&IXGBE_RXDADV_LNKSEC_ERROR_NO_SA_MATCH);
    eval 'sub IXGBE_RXDADV_LNKSEC_ERROR_REPLAY_ERROR () {0x10000000;}' unless defined(&IXGBE_RXDADV_LNKSEC_ERROR_REPLAY_ERROR);
    eval 'sub IXGBE_RXDADV_LNKSEC_ERROR_BIT_MASK () {0x18000000;}' unless defined(&IXGBE_RXDADV_LNKSEC_ERROR_BIT_MASK);
    eval 'sub IXGBE_RXDADV_LNKSEC_ERROR_BAD_SIG () {0x18000000;}' unless defined(&IXGBE_RXDADV_LNKSEC_ERROR_BAD_SIG);
    eval 'sub IXGBE_RXD_ERR_FRAME_ERR_MASK () {(  &IXGBE_RXD_ERR_CE |  &IXGBE_RXD_ERR_LE |  &IXGBE_RXD_ERR_PE |  &IXGBE_RXD_ERR_OSE |  &IXGBE_RXD_ERR_USE);}' unless defined(&IXGBE_RXD_ERR_FRAME_ERR_MASK);
    eval 'sub IXGBE_RXDADV_ERR_FRAME_ERR_MASK () {(  &IXGBE_RXDADV_ERR_CE |  &IXGBE_RXDADV_ERR_LE |  &IXGBE_RXDADV_ERR_PE |  &IXGBE_RXDADV_ERR_OSE |  &IXGBE_RXDADV_ERR_USE);}' unless defined(&IXGBE_RXDADV_ERR_FRAME_ERR_MASK);
    eval 'sub IXGBE_MCSTCTRL_MFE () {0x4;}' unless defined(&IXGBE_MCSTCTRL_MFE);
    eval 'sub IXGBE_REQ_TX_DESCRIPTOR_MULTIPLE () {8;}' unless defined(&IXGBE_REQ_TX_DESCRIPTOR_MULTIPLE);
    eval 'sub IXGBE_REQ_RX_DESCRIPTOR_MULTIPLE () {8;}' unless defined(&IXGBE_REQ_RX_DESCRIPTOR_MULTIPLE);
    eval 'sub IXGBE_REQ_TX_BUFFER_GRANULARITY () {1024;}' unless defined(&IXGBE_REQ_TX_BUFFER_GRANULARITY);
    eval 'sub IXGBE_RX_DESC_SPECIAL_VLAN_MASK () {0xfff;}' unless defined(&IXGBE_RX_DESC_SPECIAL_VLAN_MASK);
    eval 'sub IXGBE_RX_DESC_SPECIAL_PRI_MASK () {0xe000;}' unless defined(&IXGBE_RX_DESC_SPECIAL_PRI_MASK);
    eval 'sub IXGBE_RX_DESC_SPECIAL_PRI_SHIFT () {0xd;}' unless defined(&IXGBE_RX_DESC_SPECIAL_PRI_SHIFT);
    eval 'sub IXGBE_TX_DESC_SPECIAL_PRI_SHIFT () { &IXGBE_RX_DESC_SPECIAL_PRI_SHIFT;}' unless defined(&IXGBE_TX_DESC_SPECIAL_PRI_SHIFT);
    eval 'sub IXGBE_MBVFICR_INDEX {
        my($vf_number) = @_;
	    eval q(($vf_number >> 4));
    }' unless defined(&IXGBE_MBVFICR_INDEX);
    eval 'sub IXGBE_MBVFICR {
        my($_i) = @_;
	    eval q((0x710 + ($_i * 4)));
    }' unless defined(&IXGBE_MBVFICR);
    eval 'sub IXGBE_VFLRE {
        my($_i) = @_;
	    eval q(((($_i & 1) ? 0x1c0 : 0x600)));
    }' unless defined(&IXGBE_VFLRE);
    eval 'sub IXGBE_VFLREC {
        my($_i) = @_;
	    eval q((0x700 + ($_i * 4)));
    }' unless defined(&IXGBE_VFLREC);
    unless(defined(&__le16)) {
	eval 'sub __le16 () { &uint16_t;}' unless defined(&__le16);
    }
    unless(defined(&__le32)) {
	eval 'sub __le32 () { &uint32_t;}' unless defined(&__le32);
    }
    unless(defined(&__le64)) {
	eval 'sub __le64 () { &uint64_t;}' unless defined(&__le64);
    }
    unless(defined(&__be16)) {
	eval 'sub __be16 () { &uint16_t;}' unless defined(&__be16);
	eval 'sub __be32 () { &uint32_t;}' unless defined(&__be32);
	eval 'sub __be64 () { &uint64_t;}' unless defined(&__be64);
    }
    eval("sub IXGBE_FDIR_PBALLOC_64K () { 0; }") unless defined(&IXGBE_FDIR_PBALLOC_64K);
    eval("sub IXGBE_FDIR_PBALLOC_128K () { 1; }") unless defined(&IXGBE_FDIR_PBALLOC_128K);
    eval("sub IXGBE_FDIR_PBALLOC_256K () { 2; }") unless defined(&IXGBE_FDIR_PBALLOC_256K);
    eval 'sub IXGBE_FDIR_PBALLOC_SIZE_SHIFT () {16;}' unless defined(&IXGBE_FDIR_PBALLOC_SIZE_SHIFT);
    eval 'sub IXGBE_FDIRCTRL_PBALLOC_64K () {0x1;}' unless defined(&IXGBE_FDIRCTRL_PBALLOC_64K);
    eval 'sub IXGBE_FDIRCTRL_PBALLOC_128K () {0x2;}' unless defined(&IXGBE_FDIRCTRL_PBALLOC_128K);
    eval 'sub IXGBE_FDIRCTRL_PBALLOC_256K () {0x3;}' unless defined(&IXGBE_FDIRCTRL_PBALLOC_256K);
    eval 'sub IXGBE_FDIRCTRL_INIT_DONE () {0x8;}' unless defined(&IXGBE_FDIRCTRL_INIT_DONE);
    eval 'sub IXGBE_FDIRCTRL_PERFECT_MATCH () {0x10;}' unless defined(&IXGBE_FDIRCTRL_PERFECT_MATCH);
    eval 'sub IXGBE_FDIRCTRL_REPORT_STATUS () {0x20;}' unless defined(&IXGBE_FDIRCTRL_REPORT_STATUS);
    eval 'sub IXGBE_FDIRCTRL_REPORT_STATUS_ALWAYS () {0x80;}' unless defined(&IXGBE_FDIRCTRL_REPORT_STATUS_ALWAYS);
    eval 'sub IXGBE_FDIRCTRL_DROP_Q_SHIFT () {8;}' unless defined(&IXGBE_FDIRCTRL_DROP_Q_SHIFT);
    eval 'sub IXGBE_FDIRCTRL_FLEX_SHIFT () {16;}' unless defined(&IXGBE_FDIRCTRL_FLEX_SHIFT);
    eval 'sub IXGBE_FDIRCTRL_SEARCHLIM () {0x800000;}' unless defined(&IXGBE_FDIRCTRL_SEARCHLIM);
    eval 'sub IXGBE_FDIRCTRL_MAX_LENGTH_SHIFT () {24;}' unless defined(&IXGBE_FDIRCTRL_MAX_LENGTH_SHIFT);
    eval 'sub IXGBE_FDIRCTRL_FULL_THRESH_MASK () {0xf0000000;}' unless defined(&IXGBE_FDIRCTRL_FULL_THRESH_MASK);
    eval 'sub IXGBE_FDIRCTRL_FULL_THRESH_SHIFT () {28;}' unless defined(&IXGBE_FDIRCTRL_FULL_THRESH_SHIFT);
    eval 'sub IXGBE_FDIRTCPM_DPORTM_SHIFT () {16;}' unless defined(&IXGBE_FDIRTCPM_DPORTM_SHIFT);
    eval 'sub IXGBE_FDIRUDPM_DPORTM_SHIFT () {16;}' unless defined(&IXGBE_FDIRUDPM_DPORTM_SHIFT);
    eval 'sub IXGBE_FDIRIP6M_DIPM_SHIFT () {16;}' unless defined(&IXGBE_FDIRIP6M_DIPM_SHIFT);
    eval 'sub IXGBE_FDIRM_VLANID () {0x1;}' unless defined(&IXGBE_FDIRM_VLANID);
    eval 'sub IXGBE_FDIRM_VLANP () {0x2;}' unless defined(&IXGBE_FDIRM_VLANP);
    eval 'sub IXGBE_FDIRM_POOL () {0x4;}' unless defined(&IXGBE_FDIRM_POOL);
    eval 'sub IXGBE_FDIRM_L4P () {0x8;}' unless defined(&IXGBE_FDIRM_L4P);
    eval 'sub IXGBE_FDIRM_FLEX () {0x10;}' unless defined(&IXGBE_FDIRM_FLEX);
    eval 'sub IXGBE_FDIRM_DIPv6 () {0x20;}' unless defined(&IXGBE_FDIRM_DIPv6);
    eval 'sub IXGBE_FDIRFREE_FREE_MASK () {0xffff;}' unless defined(&IXGBE_FDIRFREE_FREE_MASK);
    eval 'sub IXGBE_FDIRFREE_FREE_SHIFT () {0;}' unless defined(&IXGBE_FDIRFREE_FREE_SHIFT);
    eval 'sub IXGBE_FDIRFREE_COLL_MASK () {0x7fff0000;}' unless defined(&IXGBE_FDIRFREE_COLL_MASK);
    eval 'sub IXGBE_FDIRFREE_COLL_SHIFT () {16;}' unless defined(&IXGBE_FDIRFREE_COLL_SHIFT);
    eval 'sub IXGBE_FDIRLEN_MAXLEN_MASK () {0x3f;}' unless defined(&IXGBE_FDIRLEN_MAXLEN_MASK);
    eval 'sub IXGBE_FDIRLEN_MAXLEN_SHIFT () {0;}' unless defined(&IXGBE_FDIRLEN_MAXLEN_SHIFT);
    eval 'sub IXGBE_FDIRLEN_MAXHASH_MASK () {0x7fff0000;}' unless defined(&IXGBE_FDIRLEN_MAXHASH_MASK);
    eval 'sub IXGBE_FDIRLEN_MAXHASH_SHIFT () {16;}' unless defined(&IXGBE_FDIRLEN_MAXHASH_SHIFT);
    eval 'sub IXGBE_FDIRUSTAT_ADD_MASK () {0xffff;}' unless defined(&IXGBE_FDIRUSTAT_ADD_MASK);
    eval 'sub IXGBE_FDIRUSTAT_ADD_SHIFT () {0;}' unless defined(&IXGBE_FDIRUSTAT_ADD_SHIFT);
    eval 'sub IXGBE_FDIRUSTAT_REMOVE_MASK () {0xffff0000;}' unless defined(&IXGBE_FDIRUSTAT_REMOVE_MASK);
    eval 'sub IXGBE_FDIRUSTAT_REMOVE_SHIFT () {16;}' unless defined(&IXGBE_FDIRUSTAT_REMOVE_SHIFT);
    eval 'sub IXGBE_FDIRFSTAT_FADD_MASK () {0xff;}' unless defined(&IXGBE_FDIRFSTAT_FADD_MASK);
    eval 'sub IXGBE_FDIRFSTAT_FADD_SHIFT () {0;}' unless defined(&IXGBE_FDIRFSTAT_FADD_SHIFT);
    eval 'sub IXGBE_FDIRFSTAT_FREMOVE_MASK () {0xff00;}' unless defined(&IXGBE_FDIRFSTAT_FREMOVE_MASK);
    eval 'sub IXGBE_FDIRFSTAT_FREMOVE_SHIFT () {8;}' unless defined(&IXGBE_FDIRFSTAT_FREMOVE_SHIFT);
    eval 'sub IXGBE_FDIRPORT_DESTINATION_SHIFT () {16;}' unless defined(&IXGBE_FDIRPORT_DESTINATION_SHIFT);
    eval 'sub IXGBE_FDIRVLAN_FLEX_SHIFT () {16;}' unless defined(&IXGBE_FDIRVLAN_FLEX_SHIFT);
    eval 'sub IXGBE_FDIRHASH_BUCKET_VALID_SHIFT () {15;}' unless defined(&IXGBE_FDIRHASH_BUCKET_VALID_SHIFT);
    eval 'sub IXGBE_FDIRHASH_SIG_SW_INDEX_SHIFT () {16;}' unless defined(&IXGBE_FDIRHASH_SIG_SW_INDEX_SHIFT);
    eval 'sub IXGBE_FDIRCMD_CMD_MASK () {0x3;}' unless defined(&IXGBE_FDIRCMD_CMD_MASK);
    eval 'sub IXGBE_FDIRCMD_CMD_ADD_FLOW () {0x1;}' unless defined(&IXGBE_FDIRCMD_CMD_ADD_FLOW);
    eval 'sub IXGBE_FDIRCMD_CMD_REMOVE_FLOW () {0x2;}' unless defined(&IXGBE_FDIRCMD_CMD_REMOVE_FLOW);
    eval 'sub IXGBE_FDIRCMD_CMD_QUERY_REM_FILT () {0x3;}' unless defined(&IXGBE_FDIRCMD_CMD_QUERY_REM_FILT);
    eval 'sub IXGBE_FDIRCMD_CMD_QUERY_REM_HASH () {0x7;}' unless defined(&IXGBE_FDIRCMD_CMD_QUERY_REM_HASH);
    eval 'sub IXGBE_FDIRCMD_FILTER_UPDATE () {0x8;}' unless defined(&IXGBE_FDIRCMD_FILTER_UPDATE);
    eval 'sub IXGBE_FDIRCMD_IPv6DMATCH () {0x10;}' unless defined(&IXGBE_FDIRCMD_IPv6DMATCH);
    eval 'sub IXGBE_FDIRCMD_L4TYPE_UDP () {0x20;}' unless defined(&IXGBE_FDIRCMD_L4TYPE_UDP);
    eval 'sub IXGBE_FDIRCMD_L4TYPE_TCP () {0x40;}' unless defined(&IXGBE_FDIRCMD_L4TYPE_TCP);
    eval 'sub IXGBE_FDIRCMD_L4TYPE_SCTP () {0x60;}' unless defined(&IXGBE_FDIRCMD_L4TYPE_SCTP);
    eval 'sub IXGBE_FDIRCMD_IPV6 () {0x80;}' unless defined(&IXGBE_FDIRCMD_IPV6);
    eval 'sub IXGBE_FDIRCMD_CLEARHT () {0x100;}' unless defined(&IXGBE_FDIRCMD_CLEARHT);
    eval 'sub IXGBE_FDIRCMD_DROP () {0x200;}' unless defined(&IXGBE_FDIRCMD_DROP);
    eval 'sub IXGBE_FDIRCMD_INT () {0x400;}' unless defined(&IXGBE_FDIRCMD_INT);
    eval 'sub IXGBE_FDIRCMD_LAST () {0x800;}' unless defined(&IXGBE_FDIRCMD_LAST);
    eval 'sub IXGBE_FDIRCMD_COLLISION () {0x1000;}' unless defined(&IXGBE_FDIRCMD_COLLISION);
    eval 'sub IXGBE_FDIRCMD_QUEUE_EN () {0x8000;}' unless defined(&IXGBE_FDIRCMD_QUEUE_EN);
    eval 'sub IXGBE_FDIRCMD_FLOW_TYPE_SHIFT () {5;}' unless defined(&IXGBE_FDIRCMD_FLOW_TYPE_SHIFT);
    eval 'sub IXGBE_FDIRCMD_RX_QUEUE_SHIFT () {16;}' unless defined(&IXGBE_FDIRCMD_RX_QUEUE_SHIFT);
    eval 'sub IXGBE_FDIRCMD_VT_POOL_SHIFT () {24;}' unless defined(&IXGBE_FDIRCMD_VT_POOL_SHIFT);
    eval 'sub IXGBE_FDIR_INIT_DONE_POLL () {10;}' unless defined(&IXGBE_FDIR_INIT_DONE_POLL);
    eval 'sub IXGBE_FDIRCMD_CMD_POLL () {10;}' unless defined(&IXGBE_FDIRCMD_CMD_POLL);
    eval 'sub IXGBE_ADVTXD_DTALEN_MASK () {0xffff;}' unless defined(&IXGBE_ADVTXD_DTALEN_MASK);
    eval 'sub IXGBE_ADVTXD_MAC_LINKSEC () {0x40000;}' unless defined(&IXGBE_ADVTXD_MAC_LINKSEC);
    eval 'sub IXGBE_ADVTXD_IPSEC_SA_INDEX_MASK () {0x3ff;}' unless defined(&IXGBE_ADVTXD_IPSEC_SA_INDEX_MASK);
    eval 'sub IXGBE_ADVTXD_IPSEC_ESP_LEN_MASK () {0x1ff;}' unless defined(&IXGBE_ADVTXD_IPSEC_ESP_LEN_MASK);
    eval 'sub IXGBE_ADVTXD_DTYP_MASK () {0xf00000;}' unless defined(&IXGBE_ADVTXD_DTYP_MASK);
    eval 'sub IXGBE_ADVTXD_DTYP_CTXT () {0x200000;}' unless defined(&IXGBE_ADVTXD_DTYP_CTXT);
    eval 'sub IXGBE_ADVTXD_DTYP_DATA () {0x300000;}' unless defined(&IXGBE_ADVTXD_DTYP_DATA);
    eval 'sub IXGBE_ADVTXD_DCMD_EOP () { &IXGBE_TXD_CMD_EOP;}' unless defined(&IXGBE_ADVTXD_DCMD_EOP);
    eval 'sub IXGBE_ADVTXD_DCMD_IFCS () { &IXGBE_TXD_CMD_IFCS;}' unless defined(&IXGBE_ADVTXD_DCMD_IFCS);
    eval 'sub IXGBE_ADVTXD_DCMD_RS () { &IXGBE_TXD_CMD_RS;}' unless defined(&IXGBE_ADVTXD_DCMD_RS);
    eval 'sub IXGBE_ADVTXD_DCMD_DDTYP_ISCSI () {0x10000000;}' unless defined(&IXGBE_ADVTXD_DCMD_DDTYP_ISCSI);
    eval 'sub IXGBE_ADVTXD_DCMD_DEXT () { &IXGBE_TXD_CMD_DEXT;}' unless defined(&IXGBE_ADVTXD_DCMD_DEXT);
    eval 'sub IXGBE_ADVTXD_DCMD_VLE () { &IXGBE_TXD_CMD_VLE;}' unless defined(&IXGBE_ADVTXD_DCMD_VLE);
    eval 'sub IXGBE_ADVTXD_DCMD_TSE () {0x80000000;}' unless defined(&IXGBE_ADVTXD_DCMD_TSE);
    eval 'sub IXGBE_ADVTXD_STAT_DD () { &IXGBE_TXD_STAT_DD;}' unless defined(&IXGBE_ADVTXD_STAT_DD);
    eval 'sub IXGBE_ADVTXD_STAT_SN_CRC () {0x2;}' unless defined(&IXGBE_ADVTXD_STAT_SN_CRC);
    eval 'sub IXGBE_ADVTXD_STAT_RSV () {0xc;}' unless defined(&IXGBE_ADVTXD_STAT_RSV);
    eval 'sub IXGBE_ADVTXD_IDX_SHIFT () {4;}' unless defined(&IXGBE_ADVTXD_IDX_SHIFT);
    eval 'sub IXGBE_ADVTXD_CC () {0x80;}' unless defined(&IXGBE_ADVTXD_CC);
    eval 'sub IXGBE_ADVTXD_POPTS_SHIFT () {8;}' unless defined(&IXGBE_ADVTXD_POPTS_SHIFT);
    eval 'sub IXGBE_ADVTXD_POPTS_IXSM () {( &IXGBE_TXD_POPTS_IXSM <<  &IXGBE_ADVTXD_POPTS_SHIFT);}' unless defined(&IXGBE_ADVTXD_POPTS_IXSM);
    eval 'sub IXGBE_ADVTXD_POPTS_TXSM () {( &IXGBE_TXD_POPTS_TXSM <<  &IXGBE_ADVTXD_POPTS_SHIFT);}' unless defined(&IXGBE_ADVTXD_POPTS_TXSM);
    eval 'sub IXGBE_ADVTXD_POPTS_ISCO_1ST () {0x;}' unless defined(&IXGBE_ADVTXD_POPTS_ISCO_1ST);
    eval 'sub IXGBE_ADVTXD_POPTS_ISCO_MDL () {0x800;}' unless defined(&IXGBE_ADVTXD_POPTS_ISCO_MDL);
    eval 'sub IXGBE_ADVTXD_POPTS_ISCO_LAST () {0x1000;}' unless defined(&IXGBE_ADVTXD_POPTS_ISCO_LAST);
    eval 'sub IXGBE_ADVTXD_POPTS_ISCO_FULL () {0x1800;}' unless defined(&IXGBE_ADVTXD_POPTS_ISCO_FULL);
    eval 'sub IXGBE_ADVTXD_POPTS_RSV () {0x2000;}' unless defined(&IXGBE_ADVTXD_POPTS_RSV);
    eval 'sub IXGBE_ADVTXD_PAYLEN_SHIFT () {14;}' unless defined(&IXGBE_ADVTXD_PAYLEN_SHIFT);
    eval 'sub IXGBE_ADVTXD_MACLEN_SHIFT () {9;}' unless defined(&IXGBE_ADVTXD_MACLEN_SHIFT);
    eval 'sub IXGBE_ADVTXD_VLAN_SHIFT () {16;}' unless defined(&IXGBE_ADVTXD_VLAN_SHIFT);
    eval 'sub IXGBE_ADVTXD_TUCMD_IPV4 () {0x400;}' unless defined(&IXGBE_ADVTXD_TUCMD_IPV4);
    eval 'sub IXGBE_ADVTXD_TUCMD_IPV6 () {0x;}' unless defined(&IXGBE_ADVTXD_TUCMD_IPV6);
    eval 'sub IXGBE_ADVTXD_TUCMD_L4T_UDP () {0x;}' unless defined(&IXGBE_ADVTXD_TUCMD_L4T_UDP);
    eval 'sub IXGBE_ADVTXD_TUCMD_L4T_TCP () {0x800;}' unless defined(&IXGBE_ADVTXD_TUCMD_L4T_TCP);
    eval 'sub IXGBE_ADVTXD_TUCMD_L4T_SCTP () {0x1000;}' unless defined(&IXGBE_ADVTXD_TUCMD_L4T_SCTP);
    eval 'sub IXGBE_ADVTXD_TUCMD_MKRREQ () {0x2000;}' unless defined(&IXGBE_ADVTXD_TUCMD_MKRREQ);
    eval 'sub IXGBE_ADVTXD_POPTS_IPSEC () {0x400;}' unless defined(&IXGBE_ADVTXD_POPTS_IPSEC);
    eval 'sub IXGBE_ADVTXD_TUCMD_IPSEC_TYPE_ESP () {0x2000;}' unless defined(&IXGBE_ADVTXD_TUCMD_IPSEC_TYPE_ESP);
    eval 'sub IXGBE_ADVTXD_TUCMD_IPSEC_ENCRYPT_EN () {0x4000;}' unless defined(&IXGBE_ADVTXD_TUCMD_IPSEC_ENCRYPT_EN);
    eval 'sub IXGBE_ADVTXT_TUCMD_FCOE () {0x8000;}' unless defined(&IXGBE_ADVTXT_TUCMD_FCOE);
    eval 'sub IXGBE_ADVTXD_FCOEF_EOF_MASK () {(0x3 << 10);}' unless defined(&IXGBE_ADVTXD_FCOEF_EOF_MASK);
    eval 'sub IXGBE_ADVTXD_FCOEF_SOF () {((1<< 2) << 10);}' unless defined(&IXGBE_ADVTXD_FCOEF_SOF);
    eval 'sub IXGBE_ADVTXD_FCOEF_PARINC () {((1<< 3) << 10);}' unless defined(&IXGBE_ADVTXD_FCOEF_PARINC);
    eval 'sub IXGBE_ADVTXD_FCOEF_ORIE () {((1<< 4) << 10);}' unless defined(&IXGBE_ADVTXD_FCOEF_ORIE);
    eval 'sub IXGBE_ADVTXD_FCOEF_ORIS () {((1<< 5) << 10);}' unless defined(&IXGBE_ADVTXD_FCOEF_ORIS);
    eval 'sub IXGBE_ADVTXD_FCOEF_EOF_N () {(0x << 10);}' unless defined(&IXGBE_ADVTXD_FCOEF_EOF_N);
    eval 'sub IXGBE_ADVTXD_FCOEF_EOF_T () {(0x1 << 10);}' unless defined(&IXGBE_ADVTXD_FCOEF_EOF_T);
    eval 'sub IXGBE_ADVTXD_FCOEF_EOF_NI () {(0x2 << 10);}' unless defined(&IXGBE_ADVTXD_FCOEF_EOF_NI);
    eval 'sub IXGBE_ADVTXD_FCOEF_EOF_A () {(0x3 << 10);}' unless defined(&IXGBE_ADVTXD_FCOEF_EOF_A);
    eval 'sub IXGBE_ADVTXD_L4LEN_SHIFT () {8;}' unless defined(&IXGBE_ADVTXD_L4LEN_SHIFT);
    eval 'sub IXGBE_ADVTXD_MSS_SHIFT () {16;}' unless defined(&IXGBE_ADVTXD_MSS_SHIFT);
    eval 'sub IXGBE_LINK_SPEED_UNKNOWN () {0;}' unless defined(&IXGBE_LINK_SPEED_UNKNOWN);
    eval 'sub IXGBE_LINK_SPEED_100_FULL () {0x8;}' unless defined(&IXGBE_LINK_SPEED_100_FULL);
    eval 'sub IXGBE_LINK_SPEED_1GB_FULL () {0x20;}' unless defined(&IXGBE_LINK_SPEED_1GB_FULL);
    eval 'sub IXGBE_LINK_SPEED_10GB_FULL () {0x80;}' unless defined(&IXGBE_LINK_SPEED_10GB_FULL);
    eval 'sub IXGBE_LINK_SPEED_82598_AUTONEG () {( &IXGBE_LINK_SPEED_1GB_FULL |  &IXGBE_LINK_SPEED_10GB_FULL);}' unless defined(&IXGBE_LINK_SPEED_82598_AUTONEG);
    eval 'sub IXGBE_LINK_SPEED_82599_AUTONEG () {( &IXGBE_LINK_SPEED_100_FULL |  &IXGBE_LINK_SPEED_1GB_FULL |  &IXGBE_LINK_SPEED_10GB_FULL);}' unless defined(&IXGBE_LINK_SPEED_82599_AUTONEG);
    eval 'sub IXGBE_PHYSICAL_LAYER_UNKNOWN () {0;}' unless defined(&IXGBE_PHYSICAL_LAYER_UNKNOWN);
    eval 'sub IXGBE_PHYSICAL_LAYER_10GBASE_T () {0x1;}' unless defined(&IXGBE_PHYSICAL_LAYER_10GBASE_T);
    eval 'sub IXGBE_PHYSICAL_LAYER_1000BASE_T () {0x2;}' unless defined(&IXGBE_PHYSICAL_LAYER_1000BASE_T);
    eval 'sub IXGBE_PHYSICAL_LAYER_100BASE_TX () {0x4;}' unless defined(&IXGBE_PHYSICAL_LAYER_100BASE_TX);
    eval 'sub IXGBE_PHYSICAL_LAYER_SFP_PLUS_CU () {0x8;}' unless defined(&IXGBE_PHYSICAL_LAYER_SFP_PLUS_CU);
    eval 'sub IXGBE_PHYSICAL_LAYER_10GBASE_LR () {0x10;}' unless defined(&IXGBE_PHYSICAL_LAYER_10GBASE_LR);
    eval 'sub IXGBE_PHYSICAL_LAYER_10GBASE_LRM () {0x20;}' unless defined(&IXGBE_PHYSICAL_LAYER_10GBASE_LRM);
    eval 'sub IXGBE_PHYSICAL_LAYER_10GBASE_SR () {0x40;}' unless defined(&IXGBE_PHYSICAL_LAYER_10GBASE_SR);
    eval 'sub IXGBE_PHYSICAL_LAYER_10GBASE_KX4 () {0x80;}' unless defined(&IXGBE_PHYSICAL_LAYER_10GBASE_KX4);
    eval 'sub IXGBE_PHYSICAL_LAYER_10GBASE_CX4 () {0x100;}' unless defined(&IXGBE_PHYSICAL_LAYER_10GBASE_CX4);
    eval 'sub IXGBE_PHYSICAL_LAYER_1000BASE_KX () {0x200;}' unless defined(&IXGBE_PHYSICAL_LAYER_1000BASE_KX);
    eval 'sub IXGBE_PHYSICAL_LAYER_1000BASE_BX () {0x400;}' unless defined(&IXGBE_PHYSICAL_LAYER_1000BASE_BX);
    eval 'sub IXGBE_PHYSICAL_LAYER_10GBASE_KR () {0x800;}' unless defined(&IXGBE_PHYSICAL_LAYER_10GBASE_KR);
    eval 'sub IXGBE_PHYSICAL_LAYER_10GBASE_XAUI () {0x1000;}' unless defined(&IXGBE_PHYSICAL_LAYER_10GBASE_XAUI);
    eval 'sub IXGBE_PHYSICAL_LAYER_SFP_ACTIVE_DA () {0x2000;}' unless defined(&IXGBE_PHYSICAL_LAYER_SFP_ACTIVE_DA);
    eval 'sub PAUSE_RTT () {8;}' unless defined(&PAUSE_RTT);
    eval 'sub PAUSE_MTU {
        my($MTU) = @_;
	    eval q((($MTU + 1024- 1) / 1024));
    }' unless defined(&PAUSE_MTU);
    eval 'sub FC_HIGH_WATER {
        my($MTU) = @_;
	    eval q((((( &PAUSE_RTT +  &PAUSE_MTU($MTU)) * 144) + 99) / 100+  &PAUSE_MTU($MTU)));
    }' unless defined(&FC_HIGH_WATER);
    eval 'sub FC_LOW_WATER {
        my($MTU) = @_;
	    eval q((2* (2*  &PAUSE_MTU($MTU) +  &PAUSE_RTT)));
    }' unless defined(&FC_LOW_WATER);
    eval 'sub IXGBE_ATR_BUCKET_HASH_KEY () {0x3dad14e2;}' unless defined(&IXGBE_ATR_BUCKET_HASH_KEY);
    eval 'sub IXGBE_ATR_SIGNATURE_HASH_KEY () {0x174d3614;}' unless defined(&IXGBE_ATR_SIGNATURE_HASH_KEY);
    eval 'sub IXGBE_ATR_HASH_MASK () {0x7fff;}' unless defined(&IXGBE_ATR_HASH_MASK);
    eval 'sub IXGBE_ATR_L4TYPE_MASK () {0x3;}' unless defined(&IXGBE_ATR_L4TYPE_MASK);
    eval 'sub IXGBE_ATR_L4TYPE_UDP () {0x1;}' unless defined(&IXGBE_ATR_L4TYPE_UDP);
    eval 'sub IXGBE_ATR_L4TYPE_TCP () {0x2;}' unless defined(&IXGBE_ATR_L4TYPE_TCP);
    eval 'sub IXGBE_ATR_L4TYPE_SCTP () {0x3;}' unless defined(&IXGBE_ATR_L4TYPE_SCTP);
    eval 'sub IXGBE_ATR_L4TYPE_IPV6_MASK () {0x4;}' unless defined(&IXGBE_ATR_L4TYPE_IPV6_MASK);
    eval("sub IXGBE_ATR_FLOW_TYPE_IPV4 () { 0x0; }") unless defined(&IXGBE_ATR_FLOW_TYPE_IPV4);
    eval("sub IXGBE_ATR_FLOW_TYPE_UDPV4 () { 0x1; }") unless defined(&IXGBE_ATR_FLOW_TYPE_UDPV4);
    eval("sub IXGBE_ATR_FLOW_TYPE_TCPV4 () { 0x2; }") unless defined(&IXGBE_ATR_FLOW_TYPE_TCPV4);
    eval("sub IXGBE_ATR_FLOW_TYPE_SCTPV4 () { 0x3; }") unless defined(&IXGBE_ATR_FLOW_TYPE_SCTPV4);
    eval("sub IXGBE_ATR_FLOW_TYPE_IPV6 () { 0x4; }") unless defined(&IXGBE_ATR_FLOW_TYPE_IPV6);
    eval("sub IXGBE_ATR_FLOW_TYPE_UDPV6 () { 0x5; }") unless defined(&IXGBE_ATR_FLOW_TYPE_UDPV6);
    eval("sub IXGBE_ATR_FLOW_TYPE_TCPV6 () { 0x6; }") unless defined(&IXGBE_ATR_FLOW_TYPE_TCPV6);
    eval("sub IXGBE_ATR_FLOW_TYPE_SCTPV6 () { 0x7; }") unless defined(&IXGBE_ATR_FLOW_TYPE_SCTPV6);
    eval("sub ixgbe_fcoe_bootstatus_disabled () { 0; }") unless defined(&ixgbe_fcoe_bootstatus_disabled);
    eval("sub ixgbe_fcoe_bootstatus_enabled () { 1; }") unless defined(&ixgbe_fcoe_bootstatus_enabled);
    eval("sub ixgbe_fcoe_bootstatus_unavailable () { 0xFFFF; }") unless defined(&ixgbe_fcoe_bootstatus_unavailable);
    eval("sub ixgbe_eeprom_uninitialized () { 0; }") unless defined(&ixgbe_eeprom_uninitialized);
    eval("sub ixgbe_eeprom_spi () { 1; }") unless defined(&ixgbe_eeprom_spi);
    eval("sub ixgbe_flash () { 2; }") unless defined(&ixgbe_flash);
    eval("sub ixgbe_eeprom_none () { 3; }") unless defined(&ixgbe_eeprom_none);
    eval("sub ixgbe_mac_unknown () { 0; }") unless defined(&ixgbe_mac_unknown);
    eval("sub ixgbe_mac_82598EB () { 1; }") unless defined(&ixgbe_mac_82598EB);
    eval("sub ixgbe_mac_82599EB () { 2; }") unless defined(&ixgbe_mac_82599EB);
    eval("sub ixgbe_mac_82599_vf () { 3; }") unless defined(&ixgbe_mac_82599_vf);
    eval("sub ixgbe_mac_X540 () { 4; }") unless defined(&ixgbe_mac_X540);
    eval("sub ixgbe_mac_X540_vf () { 5; }") unless defined(&ixgbe_mac_X540_vf);
    eval("sub ixgbe_num_macs () { 6; }") unless defined(&ixgbe_num_macs);
    eval("sub ixgbe_phy_unknown () { 0; }") unless defined(&ixgbe_phy_unknown);
    eval("sub ixgbe_phy_none () { 1; }") unless defined(&ixgbe_phy_none);
    eval("sub ixgbe_phy_tn () { 2; }") unless defined(&ixgbe_phy_tn);
    eval("sub ixgbe_phy_aq () { 3; }") unless defined(&ixgbe_phy_aq);
    eval("sub ixgbe_phy_cu_unknown () { 4; }") unless defined(&ixgbe_phy_cu_unknown);
    eval("sub ixgbe_phy_qt () { 5; }") unless defined(&ixgbe_phy_qt);
    eval("sub ixgbe_phy_xaui () { 6; }") unless defined(&ixgbe_phy_xaui);
    eval("sub ixgbe_phy_nl () { 7; }") unless defined(&ixgbe_phy_nl);
    eval("sub ixgbe_phy_sfp_passive_tyco () { 8; }") unless defined(&ixgbe_phy_sfp_passive_tyco);
    eval("sub ixgbe_phy_sfp_passive_unknown () { 9; }") unless defined(&ixgbe_phy_sfp_passive_unknown);
    eval("sub ixgbe_phy_sfp_active_unknown () { 10; }") unless defined(&ixgbe_phy_sfp_active_unknown);
    eval("sub ixgbe_phy_sfp_avago () { 11; }") unless defined(&ixgbe_phy_sfp_avago);
    eval("sub ixgbe_phy_sfp_ftl () { 12; }") unless defined(&ixgbe_phy_sfp_ftl);
    eval("sub ixgbe_phy_sfp_ftl_active () { 13; }") unless defined(&ixgbe_phy_sfp_ftl_active);
    eval("sub ixgbe_phy_sfp_unknown () { 14; }") unless defined(&ixgbe_phy_sfp_unknown);
    eval("sub ixgbe_phy_sfp_intel () { 15; }") unless defined(&ixgbe_phy_sfp_intel);
    eval("sub ixgbe_phy_sfp_unsupported () { 16; }") unless defined(&ixgbe_phy_sfp_unsupported);
    eval("sub ixgbe_phy_generic () { 17; }") unless defined(&ixgbe_phy_generic);
    eval("sub ixgbe_sfp_type_da_cu () { 0; }") unless defined(&ixgbe_sfp_type_da_cu);
    eval("sub ixgbe_sfp_type_sr () { 1; }") unless defined(&ixgbe_sfp_type_sr);
    eval("sub ixgbe_sfp_type_lr () { 2; }") unless defined(&ixgbe_sfp_type_lr);
    eval("sub ixgbe_sfp_type_da_cu_core0 () { 3; }") unless defined(&ixgbe_sfp_type_da_cu_core0);
    eval("sub ixgbe_sfp_type_da_cu_core1 () { 4; }") unless defined(&ixgbe_sfp_type_da_cu_core1);
    eval("sub ixgbe_sfp_type_srlr_core0 () { 5; }") unless defined(&ixgbe_sfp_type_srlr_core0);
    eval("sub ixgbe_sfp_type_srlr_core1 () { 6; }") unless defined(&ixgbe_sfp_type_srlr_core1);
    eval("sub ixgbe_sfp_type_da_act_lmt_core0 () { 7; }") unless defined(&ixgbe_sfp_type_da_act_lmt_core0);
    eval("sub ixgbe_sfp_type_da_act_lmt_core1 () { 8; }") unless defined(&ixgbe_sfp_type_da_act_lmt_core1);
    eval("sub ixgbe_sfp_type_1g_cu_core0 () { 9; }") unless defined(&ixgbe_sfp_type_1g_cu_core0);
    eval("sub ixgbe_sfp_type_1g_cu_core1 () { 10; }") unless defined(&ixgbe_sfp_type_1g_cu_core1);
    eval("sub ixgbe_sfp_type_not_present () { 0xFFFE; }") unless defined(&ixgbe_sfp_type_not_present);
    eval("sub ixgbe_sfp_type_unknown () { 0xFFFF; }") unless defined(&ixgbe_sfp_type_unknown);
    eval("sub ixgbe_media_type_unknown () { 0; }") unless defined(&ixgbe_media_type_unknown);
    eval("sub ixgbe_media_type_fiber () { 1; }") unless defined(&ixgbe_media_type_fiber);
    eval("sub ixgbe_media_type_copper () { 2; }") unless defined(&ixgbe_media_type_copper);
    eval("sub ixgbe_media_type_backplane () { 3; }") unless defined(&ixgbe_media_type_backplane);
    eval("sub ixgbe_media_type_cx4 () { 4; }") unless defined(&ixgbe_media_type_cx4);
    eval("sub ixgbe_media_type_virtual () { 5; }") unless defined(&ixgbe_media_type_virtual);
    eval("sub ixgbe_fc_none () { 0; }") unless defined(&ixgbe_fc_none);
    eval("sub ixgbe_fc_rx_pause () { 1; }") unless defined(&ixgbe_fc_rx_pause);
    eval("sub ixgbe_fc_tx_pause () { 2; }") unless defined(&ixgbe_fc_tx_pause);
    eval("sub ixgbe_fc_full () { 3; }") unless defined(&ixgbe_fc_full);
    eval("sub ixgbe_fc_default () { 4; }") unless defined(&ixgbe_fc_default);
    eval 'sub IXGBE_SMARTSPEED_MAX_RETRIES () {3;}' unless defined(&IXGBE_SMARTSPEED_MAX_RETRIES);
    eval("sub ixgbe_smart_speed_auto () { 0; }") unless defined(&ixgbe_smart_speed_auto);
    eval("sub ixgbe_smart_speed_on () { 1; }") unless defined(&ixgbe_smart_speed_on);
    eval("sub ixgbe_smart_speed_off () { 2; }") unless defined(&ixgbe_smart_speed_off);
    eval("sub ixgbe_bus_type_unknown () { 0; }") unless defined(&ixgbe_bus_type_unknown);
    eval("sub ixgbe_bus_type_pci () { 1; }") unless defined(&ixgbe_bus_type_pci);
    eval("sub ixgbe_bus_type_pcix () { 2; }") unless defined(&ixgbe_bus_type_pcix);
    eval("sub ixgbe_bus_type_pci_express () { 3; }") unless defined(&ixgbe_bus_type_pci_express);
    eval("sub ixgbe_bus_type_reserved () { 4; }") unless defined(&ixgbe_bus_type_reserved);
    eval("sub ixgbe_bus_speed_unknown () { 0; }") unless defined(&ixgbe_bus_speed_unknown);
    eval("sub ixgbe_bus_speed_33 () { 33; }") unless defined(&ixgbe_bus_speed_33);
    eval("sub ixgbe_bus_speed_66 () { 66; }") unless defined(&ixgbe_bus_speed_66);
    eval("sub ixgbe_bus_speed_100 () { 100; }") unless defined(&ixgbe_bus_speed_100);
    eval("sub ixgbe_bus_speed_120 () { 120; }") unless defined(&ixgbe_bus_speed_120);
    eval("sub ixgbe_bus_speed_133 () { 133; }") unless defined(&ixgbe_bus_speed_133);
    eval("sub ixgbe_bus_speed_2500 () { 2500; }") unless defined(&ixgbe_bus_speed_2500);
    eval("sub ixgbe_bus_speed_5000 () { 5000; }") unless defined(&ixgbe_bus_speed_5000);
    eval("sub ixgbe_bus_speed_8000 () { 8000; }") unless defined(&ixgbe_bus_speed_8000);
    eval("sub ixgbe_bus_speed_reserved () { 8001; }") unless defined(&ixgbe_bus_speed_reserved);
    eval("sub ixgbe_bus_width_unknown () { 0; }") unless defined(&ixgbe_bus_width_unknown);
    eval("sub ixgbe_bus_width_pcie_x1 () { 1; }") unless defined(&ixgbe_bus_width_pcie_x1);
    eval("sub ixgbe_bus_width_pcie_x2 () { 2; }") unless defined(&ixgbe_bus_width_pcie_x2);
    eval("sub ixgbe_bus_width_pcie_x4 () { 4; }") unless defined(&ixgbe_bus_width_pcie_x4);
    eval("sub ixgbe_bus_width_pcie_x8 () { 8; }") unless defined(&ixgbe_bus_width_pcie_x8);
    eval("sub ixgbe_bus_width_32 () { 32; }") unless defined(&ixgbe_bus_width_32);
    eval("sub ixgbe_bus_width_64 () { 64; }") unless defined(&ixgbe_bus_width_64);
    eval("sub ixgbe_bus_width_reserved () { 65; }") unless defined(&ixgbe_bus_width_reserved);
    eval 'sub IXGBE_FLAGS_DOUBLE_RESET_REQUIRED () {0x1;}' unless defined(&IXGBE_FLAGS_DOUBLE_RESET_REQUIRED);
    eval 'sub IXGBE_MAX_MTA () {128;}' unless defined(&IXGBE_MAX_MTA);
    eval 'sub IXGBE_VFMAILBOX_SIZE () {16;}' unless defined(&IXGBE_VFMAILBOX_SIZE);
    eval 'sub IXGBE_ERR_MBX () {-100;}' unless defined(&IXGBE_ERR_MBX);
    eval 'sub IXGBE_VFMAILBOX () {0x2fc;}' unless defined(&IXGBE_VFMAILBOX);
    eval 'sub IXGBE_VFMBMEM () {0x200;}' unless defined(&IXGBE_VFMBMEM);
    eval 'sub IXGBE_VFMAILBOX_REQ () {0x1;}' unless defined(&IXGBE_VFMAILBOX_REQ);
    eval 'sub IXGBE_VFMAILBOX_ACK () {0x2;}' unless defined(&IXGBE_VFMAILBOX_ACK);
    eval 'sub IXGBE_VFMAILBOX_VFU () {0x4;}' unless defined(&IXGBE_VFMAILBOX_VFU);
    eval 'sub IXGBE_VFMAILBOX_PFU () {0x8;}' unless defined(&IXGBE_VFMAILBOX_PFU);
    eval 'sub IXGBE_VFMAILBOX_PFSTS () {0x10;}' unless defined(&IXGBE_VFMAILBOX_PFSTS);
    eval 'sub IXGBE_VFMAILBOX_PFACK () {0x20;}' unless defined(&IXGBE_VFMAILBOX_PFACK);
    eval 'sub IXGBE_VFMAILBOX_RSTI () {0x40;}' unless defined(&IXGBE_VFMAILBOX_RSTI);
    eval 'sub IXGBE_VFMAILBOX_RSTD () {0x80;}' unless defined(&IXGBE_VFMAILBOX_RSTD);
    eval 'sub IXGBE_VFMAILBOX_R2C_BITS () {0xb0;}' unless defined(&IXGBE_VFMAILBOX_R2C_BITS);
    eval 'sub IXGBE_PFMAILBOX {
        my($x) = @_;
	    eval q((0x4b00 + (4* $x)));
    }' unless defined(&IXGBE_PFMAILBOX);
    eval 'sub IXGBE_PFMBMEM {
        my($vfn) = @_;
	    eval q((0x13000 + (64* $vfn)));
    }' unless defined(&IXGBE_PFMBMEM);
    eval 'sub IXGBE_PFMAILBOX_STS () {0x1;}' unless defined(&IXGBE_PFMAILBOX_STS);
    eval 'sub IXGBE_PFMAILBOX_ACK () {0x2;}' unless defined(&IXGBE_PFMAILBOX_ACK);
    eval 'sub IXGBE_PFMAILBOX_VFU () {0x4;}' unless defined(&IXGBE_PFMAILBOX_VFU);
    eval 'sub IXGBE_PFMAILBOX_PFU () {0x8;}' unless defined(&IXGBE_PFMAILBOX_PFU);
    eval 'sub IXGBE_PFMAILBOX_RVFU () {0x10;}' unless defined(&IXGBE_PFMAILBOX_RVFU);
    eval 'sub IXGBE_MBVFICR_VFREQ_MASK () {0xffff;}' unless defined(&IXGBE_MBVFICR_VFREQ_MASK);
    eval 'sub IXGBE_MBVFICR_VFREQ_VF1 () {0x1;}' unless defined(&IXGBE_MBVFICR_VFREQ_VF1);
    eval 'sub IXGBE_MBVFICR_VFACK_MASK () {0xffff0000;}' unless defined(&IXGBE_MBVFICR_VFACK_MASK);
    eval 'sub IXGBE_MBVFICR_VFACK_VF1 () {0x10000;}' unless defined(&IXGBE_MBVFICR_VFACK_VF1);
    eval 'sub IXGBE_VT_MSGTYPE_ACK () {0x80000000;}' unless defined(&IXGBE_VT_MSGTYPE_ACK);
    eval 'sub IXGBE_VT_MSGTYPE_NACK () {0x40000000;}' unless defined(&IXGBE_VT_MSGTYPE_NACK);
    eval 'sub IXGBE_VT_MSGTYPE_CTS () {0x20000000;}' unless defined(&IXGBE_VT_MSGTYPE_CTS);
    eval 'sub IXGBE_VT_MSGINFO_SHIFT () {16;}' unless defined(&IXGBE_VT_MSGINFO_SHIFT);
    eval 'sub IXGBE_VT_MSGINFO_MASK () {(0xff <<  &IXGBE_VT_MSGINFO_SHIFT);}' unless defined(&IXGBE_VT_MSGINFO_MASK);
    eval 'sub IXGBE_VF_RESET () {0x1;}' unless defined(&IXGBE_VF_RESET);
    eval 'sub IXGBE_VF_SET_MAC_ADDR () {0x2;}' unless defined(&IXGBE_VF_SET_MAC_ADDR);
    eval 'sub IXGBE_VF_SET_MULTICAST () {0x3;}' unless defined(&IXGBE_VF_SET_MULTICAST);
    eval 'sub IXGBE_VF_SET_VLAN () {0x4;}' unless defined(&IXGBE_VF_SET_VLAN);
    eval 'sub IXGBE_VF_SET_LPE () {0x5;}' unless defined(&IXGBE_VF_SET_LPE);
    eval 'sub IXGBE_VF_PERMADDR_MSG_LEN () {4;}' unless defined(&IXGBE_VF_PERMADDR_MSG_LEN);
    eval 'sub IXGBE_VF_MC_TYPE_WORD () {3;}' unless defined(&IXGBE_VF_MC_TYPE_WORD);
    eval 'sub IXGBE_PF_CONTROL_MSG () {0x100;}' unless defined(&IXGBE_PF_CONTROL_MSG);
    eval 'sub IXGBE_VF_MBX_INIT_TIMEOUT () {2000;}' unless defined(&IXGBE_VF_MBX_INIT_TIMEOUT);
    eval 'sub IXGBE_VF_MBX_INIT_DELAY () {500;}' unless defined(&IXGBE_VF_MBX_INIT_DELAY);
    eval 'sub ixgbe_hw () {( &hw,  &func, ...) (( &hw)-> ($mac->{ops}->{func}) !=  &NULL) ? ( &hw)-> ($mac->{ops}->{func})( &hw,  &__VA_ARGS__) :  &IXGBE_NOT_IMPLEMENTED;}' unless defined(&ixgbe_hw);
    eval 'sub ixgbe_hw0 () {( &hw,  &func, ...) (( &hw)-> ($mac->{ops}->{func}) !=  &NULL) ? ( &hw)-> ($mac->{ops}->{func})( &hw) :  &IXGBE_NOT_IMPLEMENTED;}' unless defined(&ixgbe_hw0);
    eval 'sub ixgbe_ee () {( &hw,  &func, ...) (( &hw)-> ($eeprom->{ops}->{func}) !=  &NULL) ? ( &hw)-> ($eeprom->{ops}->{func})( &hw,  &__VA_ARGS__) :  &IXGBE_NOT_IMPLEMENTED;}' unless defined(&ixgbe_ee);
    eval 'sub IXGBE_SUCCESS () {0;}' unless defined(&IXGBE_SUCCESS);
    eval 'sub IXGBE_ERR_EEPROM () {-1;}' unless defined(&IXGBE_ERR_EEPROM);
    eval 'sub IXGBE_ERR_EEPROM_CHECKSUM () {-2;}' unless defined(&IXGBE_ERR_EEPROM_CHECKSUM);
    eval 'sub IXGBE_ERR_PHY () {-3;}' unless defined(&IXGBE_ERR_PHY);
    eval 'sub IXGBE_ERR_CONFIG () {-4;}' unless defined(&IXGBE_ERR_CONFIG);
    eval 'sub IXGBE_ERR_PARAM () {-5;}' unless defined(&IXGBE_ERR_PARAM);
    eval 'sub IXGBE_ERR_MAC_TYPE () {-6;}' unless defined(&IXGBE_ERR_MAC_TYPE);
    eval 'sub IXGBE_ERR_UNKNOWN_PHY () {-7;}' unless defined(&IXGBE_ERR_UNKNOWN_PHY);
    eval 'sub IXGBE_ERR_LINK_SETUP () {-8;}' unless defined(&IXGBE_ERR_LINK_SETUP);
    eval 'sub IXGBE_ERR_ADAPTER_STOPPED () {-9;}' unless defined(&IXGBE_ERR_ADAPTER_STOPPED);
    eval 'sub IXGBE_ERR_INVALID_MAC_ADDR () {-10;}' unless defined(&IXGBE_ERR_INVALID_MAC_ADDR);
    eval 'sub IXGBE_ERR_DEVICE_NOT_SUPPORTED () {-11;}' unless defined(&IXGBE_ERR_DEVICE_NOT_SUPPORTED);
    eval 'sub IXGBE_ERR_MASTER_REQUESTS_PENDING () {-12;}' unless defined(&IXGBE_ERR_MASTER_REQUESTS_PENDING);
    eval 'sub IXGBE_ERR_INVALID_LINK_SETTINGS () {-13;}' unless defined(&IXGBE_ERR_INVALID_LINK_SETTINGS);
    eval 'sub IXGBE_ERR_AUTONEG_NOT_COMPLETE () {-14;}' unless defined(&IXGBE_ERR_AUTONEG_NOT_COMPLETE);
    eval 'sub IXGBE_ERR_RESET_FAILED () {-15;}' unless defined(&IXGBE_ERR_RESET_FAILED);
    eval 'sub IXGBE_ERR_SWFW_SYNC () {-16;}' unless defined(&IXGBE_ERR_SWFW_SYNC);
    eval 'sub IXGBE_ERR_PHY_ADDR_INVALID () {-17;}' unless defined(&IXGBE_ERR_PHY_ADDR_INVALID);
    eval 'sub IXGBE_ERR_I2C () {-18;}' unless defined(&IXGBE_ERR_I2C);
    eval 'sub IXGBE_ERR_SFP_NOT_SUPPORTED () {-19;}' unless defined(&IXGBE_ERR_SFP_NOT_SUPPORTED);
    eval 'sub IXGBE_ERR_SFP_NOT_PRESENT () {-20;}' unless defined(&IXGBE_ERR_SFP_NOT_PRESENT);
    eval 'sub IXGBE_ERR_SFP_NO_INIT_SEQ_PRESENT () {-21;}' unless defined(&IXGBE_ERR_SFP_NO_INIT_SEQ_PRESENT);
    eval 'sub IXGBE_ERR_NO_SAN_ADDR_PTR () {-22;}' unless defined(&IXGBE_ERR_NO_SAN_ADDR_PTR);
    eval 'sub IXGBE_ERR_FDIR_REINIT_FAILED () {-23;}' unless defined(&IXGBE_ERR_FDIR_REINIT_FAILED);
    eval 'sub IXGBE_ERR_EEPROM_VERSION () {-24;}' unless defined(&IXGBE_ERR_EEPROM_VERSION);
    eval 'sub IXGBE_ERR_NO_SPACE () {-25;}' unless defined(&IXGBE_ERR_NO_SPACE);
    eval 'sub IXGBE_ERR_OVERTEMP () {-26;}' unless defined(&IXGBE_ERR_OVERTEMP);
    eval 'sub IXGBE_ERR_FC_NOT_NEGOTIATED () {-27;}' unless defined(&IXGBE_ERR_FC_NOT_NEGOTIATED);
    eval 'sub IXGBE_ERR_FC_NOT_SUPPORTED () {-28;}' unless defined(&IXGBE_ERR_FC_NOT_SUPPORTED);
    eval 'sub IXGBE_ERR_FLOW_CONTROL () {-29;}' unless defined(&IXGBE_ERR_FLOW_CONTROL);
    eval 'sub IXGBE_ERR_SFP_SETUP_NOT_COMPLETE () {-30;}' unless defined(&IXGBE_ERR_SFP_SETUP_NOT_COMPLETE);
    eval 'sub IXGBE_ERR_PBA_SECTION () {-31;}' unless defined(&IXGBE_ERR_PBA_SECTION);
    eval 'sub IXGBE_ERR_INVALID_ARGUMENT () {-32;}' unless defined(&IXGBE_ERR_INVALID_ARGUMENT);
    eval 'sub IXGBE_NOT_IMPLEMENTED () {0x7fffffff;}' unless defined(&IXGBE_NOT_IMPLEMENTED);
    eval 'sub UNREFERENCED_PARAMETER {
        my($_p) = @_;
	    eval q();
    }' unless defined(&UNREFERENCED_PARAMETER);
    eval 'sub IXGBE_I2C_EEPROM_DEV_ADDR () {0xa0;}' unless defined(&IXGBE_I2C_EEPROM_DEV_ADDR);
    eval 'sub IXGBE_SFF_IDENTIFIER () {0x;}' unless defined(&IXGBE_SFF_IDENTIFIER);
    eval 'sub IXGBE_SFF_IDENTIFIER_SFP () {0x3;}' unless defined(&IXGBE_SFF_IDENTIFIER_SFP);
    eval 'sub IXGBE_SFF_VENDOR_OUI_BYTE0 () {0x25;}' unless defined(&IXGBE_SFF_VENDOR_OUI_BYTE0);
    eval 'sub IXGBE_SFF_VENDOR_OUI_BYTE1 () {0x26;}' unless defined(&IXGBE_SFF_VENDOR_OUI_BYTE1);
    eval 'sub IXGBE_SFF_VENDOR_OUI_BYTE2 () {0x27;}' unless defined(&IXGBE_SFF_VENDOR_OUI_BYTE2);
    eval 'sub IXGBE_SFF_1GBE_COMP_CODES () {0x6;}' unless defined(&IXGBE_SFF_1GBE_COMP_CODES);
    eval 'sub IXGBE_SFF_10GBE_COMP_CODES () {0x3;}' unless defined(&IXGBE_SFF_10GBE_COMP_CODES);
    eval 'sub IXGBE_SFF_CABLE_TECHNOLOGY () {0x8;}' unless defined(&IXGBE_SFF_CABLE_TECHNOLOGY);
    eval 'sub IXGBE_SFF_CABLE_SPEC_COMP () {0x3c;}' unless defined(&IXGBE_SFF_CABLE_SPEC_COMP);
    eval 'sub IXGBE_SFF_DA_PASSIVE_CABLE () {0x4;}' unless defined(&IXGBE_SFF_DA_PASSIVE_CABLE);
    eval 'sub IXGBE_SFF_DA_ACTIVE_CABLE () {0x8;}' unless defined(&IXGBE_SFF_DA_ACTIVE_CABLE);
    eval 'sub IXGBE_SFF_DA_SPEC_ACTIVE_LIMITING () {0x4;}' unless defined(&IXGBE_SFF_DA_SPEC_ACTIVE_LIMITING);
    eval 'sub IXGBE_SFF_1GBASESX_CAPABLE () {0x1;}' unless defined(&IXGBE_SFF_1GBASESX_CAPABLE);
    eval 'sub IXGBE_SFF_1GBASELX_CAPABLE () {0x2;}' unless defined(&IXGBE_SFF_1GBASELX_CAPABLE);
    eval 'sub IXGBE_SFF_1GBASET_CAPABLE () {0x8;}' unless defined(&IXGBE_SFF_1GBASET_CAPABLE);
    eval 'sub IXGBE_SFF_10GBASESR_CAPABLE () {0x10;}' unless defined(&IXGBE_SFF_10GBASESR_CAPABLE);
    eval 'sub IXGBE_SFF_10GBASELR_CAPABLE () {0x20;}' unless defined(&IXGBE_SFF_10GBASELR_CAPABLE);
    eval 'sub IXGBE_SFF_DA_BAD_HP_CABLE () {0x80;}' unless defined(&IXGBE_SFF_DA_BAD_HP_CABLE);
    eval 'sub IXGBE_I2C_EEPROM_READ_MASK () {0x100;}' unless defined(&IXGBE_I2C_EEPROM_READ_MASK);
    eval 'sub IXGBE_I2C_EEPROM_STATUS_MASK () {0x3;}' unless defined(&IXGBE_I2C_EEPROM_STATUS_MASK);
    eval 'sub IXGBE_I2C_EEPROM_STATUS_NO_OPERATION () {0x;}' unless defined(&IXGBE_I2C_EEPROM_STATUS_NO_OPERATION);
    eval 'sub IXGBE_I2C_EEPROM_STATUS_PASS () {0x1;}' unless defined(&IXGBE_I2C_EEPROM_STATUS_PASS);
    eval 'sub IXGBE_I2C_EEPROM_STATUS_FAIL () {0x2;}' unless defined(&IXGBE_I2C_EEPROM_STATUS_FAIL);
    eval 'sub IXGBE_I2C_EEPROM_STATUS_IN_PROGRESS () {0x3;}' unless defined(&IXGBE_I2C_EEPROM_STATUS_IN_PROGRESS);
    eval 'sub IXGBE_TAF_SYM_PAUSE () {0x400;}' unless defined(&IXGBE_TAF_SYM_PAUSE);
    eval 'sub IXGBE_TAF_ASM_PAUSE () {0x800;}' unless defined(&IXGBE_TAF_ASM_PAUSE);
    eval 'sub IXGBE_SFF_VENDOR_OUI_BYTE0_SHIFT () {24;}' unless defined(&IXGBE_SFF_VENDOR_OUI_BYTE0_SHIFT);
    eval 'sub IXGBE_SFF_VENDOR_OUI_BYTE1_SHIFT () {16;}' unless defined(&IXGBE_SFF_VENDOR_OUI_BYTE1_SHIFT);
    eval 'sub IXGBE_SFF_VENDOR_OUI_BYTE2_SHIFT () {8;}' unless defined(&IXGBE_SFF_VENDOR_OUI_BYTE2_SHIFT);
    eval 'sub IXGBE_SFF_VENDOR_OUI_TYCO () {0x407600;}' unless defined(&IXGBE_SFF_VENDOR_OUI_TYCO);
    eval 'sub IXGBE_SFF_VENDOR_OUI_FTL () {0x906500;}' unless defined(&IXGBE_SFF_VENDOR_OUI_FTL);
    eval 'sub IXGBE_SFF_VENDOR_OUI_AVAGO () {0x176a00;}' unless defined(&IXGBE_SFF_VENDOR_OUI_AVAGO);
    eval 'sub IXGBE_SFF_VENDOR_OUI_INTEL () {0x1b2100;}' unless defined(&IXGBE_SFF_VENDOR_OUI_INTEL);
    eval 'sub IXGBE_I2C_T_HD_STA () {4;}' unless defined(&IXGBE_I2C_T_HD_STA);
    eval 'sub IXGBE_I2C_T_LOW () {5;}' unless defined(&IXGBE_I2C_T_LOW);
    eval 'sub IXGBE_I2C_T_HIGH () {4;}' unless defined(&IXGBE_I2C_T_HIGH);
    eval 'sub IXGBE_I2C_T_SU_STA () {5;}' unless defined(&IXGBE_I2C_T_SU_STA);
    eval 'sub IXGBE_I2C_T_HD_DATA () {5;}' unless defined(&IXGBE_I2C_T_HD_DATA);
    eval 'sub IXGBE_I2C_T_SU_DATA () {1;}' unless defined(&IXGBE_I2C_T_SU_DATA);
    eval 'sub IXGBE_I2C_T_RISE () {1;}' unless defined(&IXGBE_I2C_T_RISE);
    eval 'sub IXGBE_I2C_T_FALL () {1;}' unless defined(&IXGBE_I2C_T_FALL);
    eval 'sub IXGBE_I2C_T_SU_STO () {4;}' unless defined(&IXGBE_I2C_T_SU_STO);
    eval 'sub IXGBE_I2C_T_BUF () {5;}' unless defined(&IXGBE_I2C_T_BUF);
    eval 'sub IXGBE_TN_LASI_STATUS_REG () {0x9005;}' unless defined(&IXGBE_TN_LASI_STATUS_REG);
    eval 'sub IXGBE_TN_LASI_STATUS_TEMP_ALARM () {0x8;}' unless defined(&IXGBE_TN_LASI_STATUS_TEMP_ALARM);
}
1;
