require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_LOCORE)) {
    eval 'sub NPTEPG () {( &PMAP_L2SIZE / $sizeof{ &pt_entry_t});}' unless defined(&NPTEPG);
}
unless(defined(&CPU_R8000)) {
    eval 'sub PG_HVPN () {(-2*  &PAGE_SIZE);}' unless defined(&PG_HVPN);
    eval 'sub PG_ODDPG () { &PAGE_SIZE;}' unless defined(&PG_ODDPG);
}
if(defined(&CPU_R8000)) {
    eval 'sub PG_ASID_MASK () {0xff0;}' unless defined(&PG_ASID_MASK);
    eval 'sub PG_ASID_SHIFT () {4;}' unless defined(&PG_ASID_SHIFT);
    eval 'sub ICACHE_ASID_SHIFT () {40;}' unless defined(&ICACHE_ASID_SHIFT);
    eval 'sub MIN_USER_ASID () {0;}' unless defined(&MIN_USER_ASID);
} else {
    eval 'sub PG_ASID_MASK () {0xff;}' unless defined(&PG_ASID_MASK);
    eval 'sub PG_ASID_SHIFT () {0;}' unless defined(&PG_ASID_SHIFT);
    eval 'sub MIN_USER_ASID () {1;}' unless defined(&MIN_USER_ASID);
}
eval 'sub PG_ASID_COUNT () {256;}' unless defined(&PG_ASID_COUNT);
if(defined(&CPU_R8000)) {
    eval 'sub PG_WIRED () {0x10;}' unless defined(&PG_WIRED);
    eval 'sub PG_RO () {0x20;}' unless defined(&PG_RO);
    eval 'sub PG_G () {0x;}' unless defined(&PG_G);
    eval 'sub PG_V () {0x80;}' unless defined(&PG_V);
    eval 'sub PG_M () {0x100;}' unless defined(&PG_M);
    eval 'sub PG_CCA_SHIFT () {9;}' unless defined(&PG_CCA_SHIFT);
} else {
    eval 'sub PG_WIRED () {0x80000000;}' unless defined(&PG_WIRED);
    eval 'sub PG_RO () {0x40000000;}' unless defined(&PG_RO);
    eval 'sub PG_G () {0x1;}' unless defined(&PG_G);
    eval 'sub PG_V () {0x2;}' unless defined(&PG_V);
    eval 'sub PG_M () {0x4;}' unless defined(&PG_M);
    eval 'sub PG_CCA_SHIFT () {3;}' unless defined(&PG_CCA_SHIFT);
}
eval 'sub PG_NV () {0x;}' unless defined(&PG_NV);
eval 'sub PG_UNCACHED () {( &CCA_NC <<  &PG_CCA_SHIFT);}' unless defined(&PG_UNCACHED);
eval 'sub PG_CACHED_NC () {( &CCA_NONCOHERENT <<  &PG_CCA_SHIFT);}' unless defined(&PG_CACHED_NC);
eval 'sub PG_CACHED_CE () {( &CCA_COHERENT_EXCL <<  &PG_CCA_SHIFT);}' unless defined(&PG_CACHED_CE);
eval 'sub PG_CACHED_CEW () {( &CCA_COHERENT_EXCLWRITE <<  &PG_CCA_SHIFT);}' unless defined(&PG_CACHED_CEW);
eval 'sub PG_CACHED () {( &CCA_CACHED <<  &PG_CCA_SHIFT);}' unless defined(&PG_CACHED);
eval 'sub PG_CACHEMODE () {(7<<  &PG_CCA_SHIFT);}' unless defined(&PG_CACHEMODE);
eval 'sub PG_ATTR () {( &PG_CACHEMODE |  &PG_M |  &PG_V |  &PG_G);}' unless defined(&PG_ATTR);
eval 'sub PG_ROPAGE () {( &PG_V |  &PG_RO |  &PG_CACHED);}' unless defined(&PG_ROPAGE);
eval 'sub PG_RWPAGE () {( &PG_V |  &PG_M |  &PG_CACHED);}' unless defined(&PG_RWPAGE);
eval 'sub PG_CWPAGE () {( &PG_V |  &PG_CACHED);}' unless defined(&PG_CWPAGE);
eval 'sub PG_IOPAGE () {( &PG_G |  &PG_V |  &PG_M |  &PG_UNCACHED);}' unless defined(&PG_IOPAGE);
if(defined(&CPU_R8000)) {
    eval 'sub PG_FRAME () {0xfffff000;}' unless defined(&PG_FRAME);
    eval 'sub PG_SHIFT () {0;}' unless defined(&PG_SHIFT);
} else {
    eval 'sub PG_FRAME () {0x3fffffc0;}' unless defined(&PG_FRAME);
    eval 'sub PG_FRAMEBITS () {30;}' unless defined(&PG_FRAMEBITS);
    eval 'sub PG_SHIFT () {6;}' unless defined(&PG_SHIFT);
}
unless(defined(&pfn_to_pad)) {
    sub pfn_to_pad {
	my($pa) = @_;
	eval q((((( &paddr_t)$pa) &  &PG_FRAME) <<  &PG_SHIFT));
    }
}
unless(defined(&vad_to_pfn)) {
    sub vad_to_pfn {
	my($va) = @_;
	eval q(((($va) >>  &PG_SHIFT) &  &PG_FRAME));
    }
}
unless(defined(&CPU_R8000)) {
    eval 'sub PG_SIZE_4K () {0x;}' unless defined(&PG_SIZE_4K);
    eval 'sub PG_SIZE_16K () {0x6000;}' unless defined(&PG_SIZE_16K);
    eval 'sub PG_SIZE_64K () {0x1e000;}' unless defined(&PG_SIZE_64K);
    eval 'sub PG_SIZE_256K () {0x7e000;}' unless defined(&PG_SIZE_256K);
    eval 'sub PG_SIZE_1M () {0x1fe000;}' unless defined(&PG_SIZE_1M);
    eval 'sub PG_SIZE_4M () {0x7fe000;}' unless defined(&PG_SIZE_4M);
    eval 'sub PG_SIZE_16M () {0x1ffe000;}' unless defined(&PG_SIZE_16M);
    if((defined(&PAGE_SHIFT) ? &PAGE_SHIFT : undef) == 12) {
	eval 'sub TLB_PAGE_MASK () { &PG_SIZE_4K;}' unless defined(&TLB_PAGE_MASK);
    }
 elsif((defined(&PAGE_SHIFT) ? &PAGE_SHIFT : undef) == 14) {
	eval 'sub TLB_PAGE_MASK () { &PG_SIZE_16K;}' unless defined(&TLB_PAGE_MASK);
    }
}
if(defined(&_KERNEL)  && !defined(&_LOCORE)) {
    eval 'sub kvtopte {
        my($va) = @_;
	    eval q(( &Sysmap + ((( &vaddr_t)($va) -  &VM_MIN_KERNEL_ADDRESS) >>  &PAGE_SHIFT)));
    }' unless defined(&kvtopte);
    eval 'sub uvtopte {
        my($adr) = @_;
	    eval q(((($adr) >>  &PAGE_SHIFT) & ( &NPTEPG -1)));
    }' unless defined(&uvtopte);
}
1;
