require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE_INTR_H_)) {
    eval 'sub _MACHINE_INTR_H_ () {1;}' unless defined(&_MACHINE_INTR_H_);
    require 'sys/evcount.ph';
    require 'sys/lock.ph';
    require 'sys/mutex.ph';
    require 'sys/queue.ph';
    require 'machine/atomic.ph';
    eval 'sub SCB_IOVECBASE () {0x800;}' unless defined(&SCB_IOVECBASE);
    eval 'sub SCB_VECSIZE () {0x10;}' unless defined(&SCB_VECSIZE);
    eval 'sub SCB_SIZE () {0x2000;}' unless defined(&SCB_SIZE);
    eval 'sub SCB_VECTOIDX {
        my($x) = @_;
	    eval q((($x) >> 4));
    }' unless defined(&SCB_VECTOIDX);
    eval 'sub SCB_IDXTOVEC {
        my($x) = @_;
	    eval q((($x) << 4));
    }' unless defined(&SCB_IDXTOVEC);
    eval 'sub SCB_NIOVECS () { &SCB_VECTOIDX( &SCB_SIZE -  &SCB_IOVECBASE);}' unless defined(&SCB_NIOVECS);
    eval 'sub IPL_NONE () { &ALPHA_PSL_IPL_0;}' unless defined(&IPL_NONE);
    eval 'sub IPL_SOFTINT () { &ALPHA_PSL_IPL_SOFT;}' unless defined(&IPL_SOFTINT);
    eval 'sub IPL_BIO () { &ALPHA_PSL_IPL_IO;}' unless defined(&IPL_BIO);
    eval 'sub IPL_NET () { &ALPHA_PSL_IPL_IO;}' unless defined(&IPL_NET);
    eval 'sub IPL_TTY () { &ALPHA_PSL_IPL_IO;}' unless defined(&IPL_TTY);
    eval 'sub IPL_SERIAL () { &ALPHA_PSL_IPL_IO;}' unless defined(&IPL_SERIAL);
    eval 'sub IPL_AUDIO () { &ALPHA_PSL_IPL_IO;}' unless defined(&IPL_AUDIO);
    eval 'sub IPL_VM () { &ALPHA_PSL_IPL_IO;}' unless defined(&IPL_VM);
    eval 'sub IPL_CLOCK () { &ALPHA_PSL_IPL_CLOCK;}' unless defined(&IPL_CLOCK);
    eval 'sub IPL_SCHED () { &ALPHA_PSL_IPL_HIGH;}' unless defined(&IPL_SCHED);
    eval 'sub IPL_HIGH () { &ALPHA_PSL_IPL_HIGH;}' unless defined(&IPL_HIGH);
    eval 'sub IPL_SOFTSERIAL () {0;}' unless defined(&IPL_SOFTSERIAL);
    eval 'sub IPL_SOFTCLOCK () {1;}' unless defined(&IPL_SOFTCLOCK);
    eval 'sub IPL_SOFTNET () {2;}' unless defined(&IPL_SOFTNET);
    eval 'sub IPL_SOFT () {3;}' unless defined(&IPL_SOFT);
    eval 'sub IPL_MPSAFE () {0;}' unless defined(&IPL_MPSAFE);
    eval 'sub IST_UNUSABLE () {-1;}' unless defined(&IST_UNUSABLE);
    eval 'sub IST_NONE () {0;}' unless defined(&IST_NONE);
    eval 'sub IST_PULSE () {1;}' unless defined(&IST_PULSE);
    eval 'sub IST_EDGE () {2;}' unless defined(&IST_EDGE);
    eval 'sub IST_LEVEL () {3;}' unless defined(&IST_LEVEL);
    eval 'sub SI_SOFT () {0;}' unless defined(&SI_SOFT);
    eval 'sub SI_SOFTCLOCK () {1;}' unless defined(&SI_SOFTCLOCK);
    eval 'sub SI_SOFTNET () {2;}' unless defined(&SI_SOFTNET);
    eval 'sub SI_SOFTSERIAL () {3;}' unless defined(&SI_SOFTSERIAL);
    eval 'sub SI_NSOFT () {4;}' unless defined(&SI_NSOFT);
    if(defined(&_KERNEL)) {
	if(defined(&DIAGNOSTIC)) {
	    eval 'sub splassert {
	        my($__wantipl) = @_;
    		eval q( &do {  &if ( &splassert_ctl > 0) {  &splassert_check($__wantipl,  &__func__); } }  &while (0));
	    }' unless defined(&splassert);
	    eval 'sub splsoftassert {
	        my($wantipl) = @_;
    		eval q( &splassert( &IPL_SOFTINT));
	    }' unless defined(&splsoftassert);
	} else {
	    eval 'sub splassert {
	        my($wantipl) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&splassert);
	    eval 'sub splsoftassert {
	        my($wantipl) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&splsoftassert);
	}
	eval 'sub splx {
	    my($s) = @_;
    	    eval q((($s) ==  &ALPHA_PSL_IPL_0 ?  &spl0() :  &alpha_pal_swpipl($s)));
	}' unless defined(&splx);
	eval 'sub splsoft () {
	    eval q( &_splraise( &IPL_SOFTINT));
	}' unless defined(&splsoft);
	eval 'sub splsoftserial () {
	    eval q( &splsoft());
	}' unless defined(&splsoftserial);
	eval 'sub splsoftclock () {
	    eval q( &splsoft());
	}' unless defined(&splsoftclock);
	eval 'sub splsoftnet () {
	    eval q( &splsoft());
	}' unless defined(&splsoftnet);
	eval 'sub splnet () {
	    eval q( &_splraise( &IPL_NET));
	}' unless defined(&splnet);
	eval 'sub splbio () {
	    eval q( &_splraise( &IPL_BIO));
	}' unless defined(&splbio);
	eval 'sub spltty () {
	    eval q( &_splraise( &IPL_TTY));
	}' unless defined(&spltty);
	eval 'sub splserial () {
	    eval q( &_splraise( &IPL_SERIAL));
	}' unless defined(&splserial);
	eval 'sub splaudio () {
	    eval q( &_splraise( &IPL_AUDIO));
	}' unless defined(&splaudio);
	eval 'sub splvm () {
	    eval q( &_splraise( &IPL_VM));
	}' unless defined(&splvm);
	eval 'sub splclock () {
	    eval q( &_splraise( &IPL_CLOCK));
	}' unless defined(&splclock);
	eval 'sub splstatclock () {
	    eval q( &_splraise( &IPL_CLOCK));
	}' unless defined(&splstatclock);
	eval 'sub splhigh () {
	    eval q( &_splraise( &IPL_HIGH));
	}' unless defined(&splhigh);
	eval 'sub spllock () {
	    eval q( &splhigh());
	}' unless defined(&spllock);
	eval 'sub splsched () {
	    eval q( &splhigh());
	}' unless defined(&splsched);
	eval 'sub ALPHA_IPI_HALT () {0x1;}' unless defined(&ALPHA_IPI_HALT);
	eval 'sub ALPHA_IPI_TBIA () {0x2;}' unless defined(&ALPHA_IPI_TBIA);
	eval 'sub ALPHA_IPI_TBIAP () {0x4;}' unless defined(&ALPHA_IPI_TBIAP);
	eval 'sub ALPHA_IPI_SHOOTDOWN () {0x8;}' unless defined(&ALPHA_IPI_SHOOTDOWN);
	eval 'sub ALPHA_IPI_IMB () {0x10;}' unless defined(&ALPHA_IPI_IMB);
	eval 'sub ALPHA_IPI_AST () {0x20;}' unless defined(&ALPHA_IPI_AST);
	eval 'sub ALPHA_IPI_SYNCH_FPU () {0x40;}' unless defined(&ALPHA_IPI_SYNCH_FPU);
	eval 'sub ALPHA_IPI_DISCARD_FPU () {0x80;}' unless defined(&ALPHA_IPI_DISCARD_FPU);
	eval 'sub ALPHA_IPI_PAUSE () {0x100;}' unless defined(&ALPHA_IPI_PAUSE);
	eval 'sub ALPHA_NIPIS () {6;}' unless defined(&ALPHA_NIPIS);
	eval 'sub ALPHA_SHARED_INTR_DISABLE {
	    my($asi, $num) = @_;
    	    eval q((($asi)[$num]. &intr_maxstrays != 0 && ($asi)[$num]. &intr_nstrays == ($asi)[$num]. &intr_maxstrays));
	}' unless defined(&ALPHA_SHARED_INTR_DISABLE);
	eval 'sub setsoft {
	    my($x) = @_;
    	    eval q( &atomic_setbits_ulong( &ssir, 1<< ($x)));
	}' unless defined(&setsoft);
	eval 'sub SCB_ALLOC_FAILED () {( -1);}' unless defined(&SCB_ALLOC_FAILED);
    }
}
1;
