require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE_CPU_H_)) {
    eval 'sub _MACHINE_CPU_H_ () {1;}' unless defined(&_MACHINE_CPU_H_);
    unless(defined(&NO_IEEE)) {
    }
    if(defined(&_KERNEL)) {
	require 'machine/alpha_cpu.ph';
	require 'machine/frame.ph';
	require 'machine/bus.ph';
	require 'machine/intr.ph';
	require 'sys/device.ph';
	require 'sys/sched.ph';
	if(defined(&DIAGNOSTIC)) {
	}
	if(defined(&MULTIPROCESSOR)) {
	}
	if(defined(&GPROF)) {
	}
	eval 'sub CPUF_PRIMARY () {0x1;}' unless defined(&CPUF_PRIMARY);
	eval 'sub CPUF_PRESENT () {0x2;}' unless defined(&CPUF_PRESENT);
	eval 'sub CPUF_RUNNING () {0x4;}' unless defined(&CPUF_RUNNING);
	eval 'sub CPUF_PAUSED () {0x8;}' unless defined(&CPUF_PAUSED);
	eval 'sub CPUF_FPUSAVE () {0x10;}' unless defined(&CPUF_FPUSAVE);
	eval 'sub CPU_INFO_UNIT {
	    my($ci) = @_;
    	    eval q((($ci)-> &ci_dev ? ($ci)-> ($ci_dev->{dv_unit}) : 0));
	}' unless defined(&CPU_INFO_UNIT);
	eval 'sub CPU_INFO_ITERATOR () {\'int\';}' unless defined(&CPU_INFO_ITERATOR);
	eval 'sub CPU_INFO_FOREACH {
	    my($cii, $ci) = @_;
    	    eval q( &for ($cii = 0, $ci =  &curcpu(); $ci !=  &NULL; $ci =  ($ci->{ci_next})));
	}' unless defined(&CPU_INFO_FOREACH);
	eval 'sub MAXCPUS () { &ALPHA_MAXPROCS;}' unless defined(&MAXCPUS);
	eval 'sub cpu_unidle {
	    my($ci) = @_;
    	    eval q();
	}' unless defined(&cpu_unidle);
	if(defined(&MULTIPROCESSOR)) {
	    eval 'sub curcpu () {
	        eval q(( &alpha_pal_rdval()));
	    }' unless defined(&curcpu);
	    eval 'sub CPU_IS_PRIMARY {
	        my($ci) = @_;
    		eval q((($ci)-> &ci_flags &  &CPUF_PRIMARY));
	    }' unless defined(&CPU_IS_PRIMARY);
	} else {
	    eval 'sub curcpu () {
	        eval q(( &cpu_info_store));
	    }' unless defined(&curcpu);
	    eval 'sub CPU_IS_PRIMARY {
	        my($ci) = @_;
    		eval q(1);
	    }' unless defined(&CPU_IS_PRIMARY);
	}
	eval 'sub curproc () { &curcpu()-> &ci_curproc;}' unless defined(&curproc);
	eval 'sub fpcurproc () { &curcpu()-> &ci_fpcurproc;}' unless defined(&fpcurproc);
	eval 'sub curpcb () { &curcpu()-> &ci_curpcb;}' unless defined(&curpcb);
	eval 'sub cpu_number () {
	    eval q( &alpha_pal_whami());
	}' unless defined(&cpu_number);
	eval 'sub CLKF_USERMODE {
	    my($framep) = @_;
    	    eval q(((($framep)-> ($cf_tf->{tf_regs[&FRAME_PS]}) &  &ALPHA_PSL_USERMODE) != 0));
	}' unless defined(&CLKF_USERMODE);
	eval 'sub CLKF_PC {
	    my($framep) = @_;
    	    eval q((($framep)-> ($cf_tf->{tf_regs[&FRAME_PC]})));
	}' unless defined(&CLKF_PC);
	eval 'sub CLKF_INTR {
	    my($framep) = @_;
    	    eval q(( &curcpu()-> &ci_intrdepth));
	}' unless defined(&CLKF_INTR);
	eval 'sub PROC_PC {
	    my($p) = @_;
    	    eval q((($p)-> ($p_md->{md_tf}->{tf_regs[&FRAME_PC]})));
	}' unless defined(&PROC_PC);
	eval 'sub PROC_STACK {
	    my($p) = @_;
    	    eval q(( &alpha_pal_rdusp()));
	}' unless defined(&PROC_STACK);
	eval 'sub need_resched {
	    my($ci) = @_;
    	    eval q( &do { ($ci)-> &ci_want_resched = 1;  &if (($ci)-> &ci_curproc !=  &NULL)  &aston(($ci)-> &ci_curproc); }  &while ( 0));
	}' unless defined(&need_resched);
	eval 'sub clear_resched {
	    my($ci) = @_;
    	    eval q(($ci)-> &ci_want_resched = 0);
	}' unless defined(&clear_resched);
	eval 'sub need_proftick {
	    my($p) = @_;
    	    eval q( &aston($p));
	}' unless defined(&need_proftick);
	if(defined(&MULTIPROCESSOR)) {
	    eval 'sub signotify {
	        my($p) = @_;
    		eval q( &do {  &aston($p);  &cpu_unidle(($p)-> &p_cpu); }  &while (0));
	    }' unless defined(&signotify);
	} else {
	    eval 'sub signotify {
	        my($p) = @_;
    		eval q( &aston($p));
	    }' unless defined(&signotify);
	}
	eval 'sub aston {
	    my($p) = @_;
    	    eval q(($p)-> ($p_md->{md_astpending}) = 1);
	}' unless defined(&aston);
    }
    eval 'sub CPU_CONSDEV () {1;}' unless defined(&CPU_CONSDEV);
    eval 'sub CPU_UNALIGNED_PRINT () {3;}' unless defined(&CPU_UNALIGNED_PRINT);
    eval 'sub CPU_UNALIGNED_FIX () {4;}' unless defined(&CPU_UNALIGNED_FIX);
    eval 'sub CPU_UNALIGNED_SIGBUS () {5;}' unless defined(&CPU_UNALIGNED_SIGBUS);
    eval 'sub CPU_BOOTED_KERNEL () {6;}' unless defined(&CPU_BOOTED_KERNEL);
    eval 'sub CPU_FP_SYNC_COMPLETE () {7;}' unless defined(&CPU_FP_SYNC_COMPLETE);
    eval 'sub CPU_CHIPSET () {8;}' unless defined(&CPU_CHIPSET);
    eval 'sub CPU_ALLOWAPERTURE () {9;}' unless defined(&CPU_ALLOWAPERTURE);
    eval 'sub CPU_LED_BLINK () {10;}' unless defined(&CPU_LED_BLINK);
    eval 'sub CPU_MAXID () {11;}' unless defined(&CPU_MAXID);
    eval 'sub CPU_CHIPSET_MEM () {1;}' unless defined(&CPU_CHIPSET_MEM);
    eval 'sub CPU_CHIPSET_BWX () {2;}' unless defined(&CPU_CHIPSET_BWX);
    eval 'sub CPU_CHIPSET_TYPE () {3;}' unless defined(&CPU_CHIPSET_TYPE);
    eval 'sub CPU_CHIPSET_DENSE () {4;}' unless defined(&CPU_CHIPSET_DENSE);
    eval 'sub CPU_CHIPSET_PORTS () {5;}' unless defined(&CPU_CHIPSET_PORTS);
    eval 'sub CPU_CHIPSET_HAE_MASK () {6;}' unless defined(&CPU_CHIPSET_HAE_MASK);
    eval 'sub CPU_CHIPSET_MAXID () {7;}' unless defined(&CPU_CHIPSET_MAXID);
    eval 'sub CTL_MACHDEP_NAMES () {{ { 0, 0}, { "console_device",  &CTLTYPE_STRUCT }, { 0, 0}, { "unaligned_print",  &CTLTYPE_INT }, { "unaligned_fix",  &CTLTYPE_INT }, { "unaligned_sigbus",  &CTLTYPE_INT }, { "booted_kernel",  &CTLTYPE_STRING }, { "fp_sync_complete",  &CTLTYPE_INT }, { "chipset",  &CTLTYPE_NODE }, { "allowaperture",  &CTLTYPE_INT }, { "led_blink",  &CTLTYPE_INT } };}' unless defined(&CTL_MACHDEP_NAMES);
    eval 'sub CTL_CHIPSET_NAMES () {{ { 0, 0}, { "memory",  &CTLTYPE_QUAD }, { "bwx",  &CTLTYPE_INT }, { "type",  &CTLTYPE_STRING }, { "dense_base",  &CTLTYPE_QUAD }, { "ports_base",  &CTLTYPE_QUAD }, { "hae_mask",  &CTLTYPE_QUAD }, };}' unless defined(&CTL_CHIPSET_NAMES);
    if(defined(&_KERNEL)) {
	unless(defined(&NO_IEEE)) {
	}
	if(defined(&MULTIPROCESSOR)) {
	    require 'sys/mplock.ph';
	}
    }
}
1;
