require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_I915_DRV_H_)) {
    eval 'sub _I915_DRV_H_ () {1;}' unless defined(&_I915_DRV_H_);
    require './dev/pci/drm/i915_reg.ph';
    eval 'sub DRIVER_AUTHOR () {"Tungsten Graphics, Inc.";}' unless defined(&DRIVER_AUTHOR);
    eval 'sub DRIVER_NAME () {"i915";}' unless defined(&DRIVER_NAME);
    eval 'sub DRIVER_DESC () {"Intel Graphics";}' unless defined(&DRIVER_DESC);
    eval 'sub DRIVER_DATE () {"20080730";}' unless defined(&DRIVER_DATE);
    eval("sub PIPE_A () { 0; }") unless defined(&PIPE_A);
    eval("sub PIPE_B () { 1; }") unless defined(&PIPE_B);
    eval 'sub DRIVER_MAJOR () {1;}' unless defined(&DRIVER_MAJOR);
    eval 'sub DRIVER_MINOR () {6;}' unless defined(&DRIVER_MINOR);
    eval 'sub DRIVER_PATCHLEVEL () {0;}' unless defined(&DRIVER_PATCHLEVEL);
    eval 'sub I915_FENCE_REG_NONE () {-1;}' unless defined(&I915_FENCE_REG_NONE);
    eval 'sub hws_obj () { ($hws->{obj});}' unless defined(&hws_obj);
    eval 'sub hws_dmamem () { ($hws->{dmamem});}' unless defined(&hws_dmamem);
    eval 'sub INTELDRM_QUIET () {0x1;}' unless defined(&INTELDRM_QUIET);
    eval 'sub INTELDRM_WEDGED () {0x2;}' unless defined(&INTELDRM_WEDGED);
    eval 'sub INTELDRM_SUSPENDED () {0x4;}' unless defined(&INTELDRM_SUSPENDED);
    eval 'sub CHIP_I830 () {0x1;}' unless defined(&CHIP_I830);
    eval 'sub CHIP_I845G () {0x2;}' unless defined(&CHIP_I845G);
    eval 'sub CHIP_I85X () {0x4;}' unless defined(&CHIP_I85X);
    eval 'sub CHIP_I865G () {0x8;}' unless defined(&CHIP_I865G);
    eval 'sub CHIP_I9XX () {0x10;}' unless defined(&CHIP_I9XX);
    eval 'sub CHIP_I915G () {0x20;}' unless defined(&CHIP_I915G);
    eval 'sub CHIP_I915GM () {0x40;}' unless defined(&CHIP_I915GM);
    eval 'sub CHIP_I945G () {0x80;}' unless defined(&CHIP_I945G);
    eval 'sub CHIP_I945GM () {0x100;}' unless defined(&CHIP_I945GM);
    eval 'sub CHIP_I965 () {0x200;}' unless defined(&CHIP_I965);
    eval 'sub CHIP_I965GM () {0x400;}' unless defined(&CHIP_I965GM);
    eval 'sub CHIP_G33 () {0x800;}' unless defined(&CHIP_G33);
    eval 'sub CHIP_GM45 () {0x1000;}' unless defined(&CHIP_GM45);
    eval 'sub CHIP_G4X () {0x2000;}' unless defined(&CHIP_G4X);
    eval 'sub CHIP_M () {0x4000;}' unless defined(&CHIP_M);
    eval 'sub CHIP_HWS () {0x8000;}' unless defined(&CHIP_HWS);
    eval 'sub CHIP_GEN2 () {0x10000;}' unless defined(&CHIP_GEN2);
    eval 'sub CHIP_GEN3 () {0x20000;}' unless defined(&CHIP_GEN3);
    eval 'sub CHIP_GEN4 () {0x40000;}' unless defined(&CHIP_GEN4);
    eval 'sub CHIP_GEN6 () {0x80000;}' unless defined(&CHIP_GEN6);
    eval 'sub CHIP_PINEVIEW () {0x100000;}' unless defined(&CHIP_PINEVIEW);
    eval 'sub CHIP_IRONLAKE () {0x200000;}' unless defined(&CHIP_IRONLAKE);
    eval 'sub CHIP_IRONLAKE_D () {0x400000;}' unless defined(&CHIP_IRONLAKE_D);
    eval 'sub CHIP_IRONLAKE_M () {0x800000;}' unless defined(&CHIP_IRONLAKE_M);
    eval 'sub CHIP_SANDYBRIDGE () {0x1000000;}' unless defined(&CHIP_SANDYBRIDGE);
    eval 'sub CHIP_IVYBRIDGE () {0x2000000;}' unless defined(&CHIP_IVYBRIDGE);
    eval 'sub CHIP_GEN7 () {0x4000000;}' unless defined(&CHIP_GEN7);
    eval 'sub I915_ACTIVE () {0x10;}' unless defined(&I915_ACTIVE);
    eval 'sub I915_IN_EXEC () {0x20;}' unless defined(&I915_IN_EXEC);
    eval 'sub I915_USER_PINNED () {0x40;}' unless defined(&I915_USER_PINNED);
    eval 'sub I915_GPU_WRITE () {0x80;}' unless defined(&I915_GPU_WRITE);
    eval 'sub I915_DONTNEED () {0x100;}' unless defined(&I915_DONTNEED);
    eval 'sub I915_PURGED () {0x200;}' unless defined(&I915_PURGED);
    eval 'sub I915_DIRTY () {0x400;}' unless defined(&I915_DIRTY);
    eval 'sub I915_EXEC_NEEDS_FENCE () {0x800;}' unless defined(&I915_EXEC_NEEDS_FENCE);
    eval 'sub I915_FENCED_EXEC () {0x1000;}' unless defined(&I915_FENCED_EXEC);
    eval 'sub I915_FENCE_INVALID () {0x2000;}' unless defined(&I915_FENCE_INVALID);
    eval 'sub read64 {
        my($dev_priv,$off) = @_;
	    eval q({  &u_int32_t  &low,  &high;  &low =  &bus_space_read_4( ($dev_priv->{regs}->{bst}),  ($dev_priv->{regs}->{bsh}), $off);  &high =  &bus_space_read_4( ($dev_priv->{regs}->{bst}),  ($dev_priv->{regs}->{bsh}), $off + 4); (( &u_int64_t) &low | (( &u_int64_t) &high << 32)); });
    }' unless defined(&read64);
    eval 'sub I915_READ64 {
        my($off) = @_;
	    eval q( &read64( &dev_priv, $off));
    }' unless defined(&I915_READ64);
    eval 'sub I915_WRITE64 {
        my($off, $reg) = @_;
	    eval q( &write64( &dev_priv, $off, $reg));
    }' unless defined(&I915_WRITE64);
    eval 'sub I915_READ {
        my($reg) = @_;
	    eval q( &bus_space_read_4( ($dev_priv->{regs}->{bst}),  ($dev_priv->{regs}->{bsh}), ($reg)));
    }' unless defined(&I915_READ);
    eval 'sub I915_WRITE {
        my($reg,$val) = @_;
	    eval q( &bus_space_write_4( ($dev_priv->{regs}->{bst}),  ($dev_priv->{regs}->{bsh}), ($reg), ($val)));
    }' unless defined(&I915_WRITE);
    eval 'sub I915_READ16 {
        my($reg) = @_;
	    eval q( &bus_space_read_2( ($dev_priv->{regs}->{bst}),  ($dev_priv->{regs}->{bsh}), ($reg)));
    }' unless defined(&I915_READ16);
    eval 'sub I915_WRITE16 {
        my($reg,$val) = @_;
	    eval q( &bus_space_write_2( ($dev_priv->{regs}->{bst}),  ($dev_priv->{regs}->{bsh}), ($reg), ($val)));
    }' unless defined(&I915_WRITE16);
    eval 'sub I915_READ8 {
        my($reg) = @_;
	    eval q( &bus_space_read_1( ($dev_priv->{regs}->{bst}),  ($dev_priv->{regs}->{bsh}), ($reg)));
    }' unless defined(&I915_READ8);
    eval 'sub I915_WRITE8 {
        my($reg,$val) = @_;
	    eval q( &bus_space_write_1( ($dev_priv->{regs}->{bst}),  ($dev_priv->{regs}->{bsh}), ($reg), ($val)));
    }' unless defined(&I915_WRITE8);
    eval 'sub POSTING_READ {
        my($reg) = @_;
	    eval q(( &void) &I915_READ($reg));
    }' unless defined(&POSTING_READ);
    eval 'sub POSTING_READ16 {
        my($reg) = @_;
	    eval q(( &void) &I915_READ16($reg));
    }' unless defined(&POSTING_READ16);
    eval 'sub INTELDRM_VERBOSE () {0;}' unless defined(&INTELDRM_VERBOSE);
    if((defined(&INTELDRM_VERBOSE) ? &INTELDRM_VERBOSE : undef) > 0) {
	eval 'sub INTELDRM_VPRINTF () {( &fmt,  &args...)  &DRM_INFO( &fmt,  &args);}' unless defined(&INTELDRM_VPRINTF);
    } else {
	eval 'sub INTELDRM_VPRINTF () {( &fmt,  &args...);}' unless defined(&INTELDRM_VPRINTF);
    }
    eval 'sub BEGIN_LP_RING {
        my($n) = @_;
	    eval q( &inteldrm_begin_ring( &dev_priv, $n));
    }' unless defined(&BEGIN_LP_RING);
    eval 'sub OUT_RING {
        my($n) = @_;
	    eval q( &inteldrm_out_ring( &dev_priv, $n));
    }' unless defined(&OUT_RING);
    eval 'sub ADVANCE_LP_RING () {
        eval q( &inteldrm_advance_ring( &dev_priv));
    }' unless defined(&ADVANCE_LP_RING);
    eval 'sub I915_IFPADDR () {0x60;}' unless defined(&I915_IFPADDR);
    eval 'sub I965_IFPADDR () {0x70;}' unless defined(&I965_IFPADDR);
    eval 'sub READ_HWSP {
        my($dev_priv, $reg) = @_;
	    eval q( &inteldrm_read_hws($dev_priv, $reg));
    }' unless defined(&READ_HWSP);
    eval 'sub I915_GEM_HWS_INDEX () {0x20;}' unless defined(&I915_GEM_HWS_INDEX);
    eval 'sub IS_I830 {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_I830));
    }' unless defined(&IS_I830);
    eval 'sub IS_845G {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_I845G));
    }' unless defined(&IS_845G);
    eval 'sub IS_I85X {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_I85X));
    }' unless defined(&IS_I85X);
    eval 'sub IS_I865G {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_I865G));
    }' unless defined(&IS_I865G);
    eval 'sub IS_I915G {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_I915G));
    }' unless defined(&IS_I915G);
    eval 'sub IS_I915GM {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_I915GM));
    }' unless defined(&IS_I915GM);
    eval 'sub IS_I945G {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_I945G));
    }' unless defined(&IS_I945G);
    eval 'sub IS_I945GM {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_I945GM));
    }' unless defined(&IS_I945GM);
    eval 'sub IS_I965G {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_I965));
    }' unless defined(&IS_I965G);
    eval 'sub IS_I965GM {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_I965GM));
    }' unless defined(&IS_I965GM);
    eval 'sub IS_GM45 {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_GM45));
    }' unless defined(&IS_GM45);
    eval 'sub IS_G4X {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_G4X));
    }' unless defined(&IS_G4X);
    eval 'sub IS_G33 {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_G33));
    }' unless defined(&IS_G33);
    eval 'sub IS_I9XX {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_I9XX));
    }' unless defined(&IS_I9XX);
    eval 'sub IS_IRONLAKE {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_IRONLAKE));
    }' unless defined(&IS_IRONLAKE);
    eval 'sub IS_IRONLAKE_D {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_IRONLAKE_D));
    }' unless defined(&IS_IRONLAKE_D);
    eval 'sub IS_IRONLAKE_M {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_IRONLAKE_M));
    }' unless defined(&IS_IRONLAKE_M);
    eval 'sub IS_SANDYBRIDGE {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_SANDYBRIDGE));
    }' unless defined(&IS_SANDYBRIDGE);
    eval 'sub IS_SANDYBRIDGE_D {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_SANDYBRIDGE_D));
    }' unless defined(&IS_SANDYBRIDGE_D);
    eval 'sub IS_SANDYBRIDGE_M {
        my($dev_priv) = @_;
	    eval q((($dev_priv)-> &flags &  &CHIP_SANDYBRIDGE_M));
    }' unless defined(&IS_SANDYBRIDGE_M);
    eval 'sub IS_MOBILE {
        my($dev_priv) = @_;
	    eval q(( ($dev_priv->{flags}) &  &CHIP_M));
    }' unless defined(&IS_MOBILE);
    eval 'sub I915_NEED_GFX_HWS {
        my($dev_priv) = @_;
	    eval q(( ($dev_priv->{flags}) &  &CHIP_HWS));
    }' unless defined(&I915_NEED_GFX_HWS);
    eval 'sub HAS_RESET {
        my($dev_priv) = @_;
	    eval q( &IS_I965G($dev_priv)  && (! &IS_GEN6($dev_priv))  && (! &IS_GEN7($dev_priv)));
    }' unless defined(&HAS_RESET);
    eval 'sub IS_GEN2 {
        my($dev_priv) = @_;
	    eval q(( ($dev_priv->{flags}) &  &CHIP_GEN2));
    }' unless defined(&IS_GEN2);
    eval 'sub IS_GEN3 {
        my($dev_priv) = @_;
	    eval q(( ($dev_priv->{flags}) &  &CHIP_GEN3));
    }' unless defined(&IS_GEN3);
    eval 'sub IS_GEN4 {
        my($dev_priv) = @_;
	    eval q(( ($dev_priv->{flags}) &  &CHIP_GEN4));
    }' unless defined(&IS_GEN4);
    eval 'sub IS_GEN6 {
        my($dev_priv) = @_;
	    eval q(( ($dev_priv->{flags}) &  &CHIP_GEN6));
    }' unless defined(&IS_GEN6);
    eval 'sub IS_GEN7 {
        my($dev_priv) = @_;
	    eval q(( ($dev_priv->{flags}) &  &CHIP_GEN7));
    }' unless defined(&IS_GEN7);
    eval 'sub I915_HAS_FBC {
        my($dev) = @_;
	    eval q(( &IS_I965GM($dev) ||  &IS_GM45($dev)));
    }' unless defined(&I915_HAS_FBC);
    eval 'sub HAS_PCH_SPLIT {
        my($dev) = @_;
	    eval q(( &IS_IRONLAKE($dev) ||  &IS_GEN6($dev) ||  &IS_GEN7($dev)));
    }' unless defined(&HAS_PCH_SPLIT);
    eval 'sub INTEL_INFO {
        my($dev) = @_;
	    eval q(($dev));
    }' unless defined(&INTEL_INFO);
    eval 'sub I915_INTERRUPT_ENABLE_FIX () {( &I915_DISPLAY_PIPE_A_EVENT_INTERRUPT |  &I915_DISPLAY_PIPE_B_EVENT_INTERRUPT |  &I915_RENDER_COMMAND_PARSER_ERROR_INTERRUPT);}' unless defined(&I915_INTERRUPT_ENABLE_FIX);
    eval 'sub I915_INTERRUPT_ENABLE_VAR () {( &I915_USER_INTERRUPT);}' unless defined(&I915_INTERRUPT_ENABLE_VAR);
    eval 'sub I915_INTERRUPT_ENABLE_MASK () {( &I915_INTERRUPT_ENABLE_FIX |  &I915_INTERRUPT_ENABLE_VAR);}' unless defined(&I915_INTERRUPT_ENABLE_MASK);
    eval 'sub PCH_SPLIT_DISPLAY_INTR_FIX () {( &DE_MASTER_IRQ_CONTROL);}' unless defined(&PCH_SPLIT_DISPLAY_INTR_FIX);
    eval 'sub PCH_SPLIT_DISPLAY_INTR_VAR () {( &DE_PIPEA_VBLANK |  &DE_PIPEB_VBLANK);}' unless defined(&PCH_SPLIT_DISPLAY_INTR_VAR);
    eval 'sub PCH_SPLIT_DISPLAY_ENABLE_MASK () {( &PCH_SPLIT_DISPLAY_INTR_FIX |  &PCH_SPLIT_DISPLAY_INTR_VAR);}' unless defined(&PCH_SPLIT_DISPLAY_ENABLE_MASK);
    eval 'sub PCH_SPLIT_RENDER_INTR_FIX () {(0);}' unless defined(&PCH_SPLIT_RENDER_INTR_FIX);
    eval 'sub PCH_SPLIT_RENDER_INTR_VAR () {( &GT_USER_INTERRUPT |  &GT_MASTER_ERROR);}' unless defined(&PCH_SPLIT_RENDER_INTR_VAR);
    eval 'sub PCH_SPLIT_RENDER_ENABLE_MASK () {( &PCH_SPLIT_RENDER_INTR_FIX |  &PCH_SPLIT_RENDER_INTR_VAR);}' unless defined(&PCH_SPLIT_RENDER_ENABLE_MASK);
    eval 'sub PCH_SPLIT_HOTPLUG_INTR_FIX () {(0);}' unless defined(&PCH_SPLIT_HOTPLUG_INTR_FIX);
    eval 'sub PCH_SPLIT_HOTPLUG_INTR_VAR () {(0);}' unless defined(&PCH_SPLIT_HOTPLUG_INTR_VAR);
    eval 'sub PCH_SPLIT_HOTPLUG_ENABLE_MASK () {( &PCH_SPLIT_HOTPLUG_INTR_FIX |  &PCH_SPLIT_HOTPLUG_INTR_VAR);}' unless defined(&PCH_SPLIT_HOTPLUG_ENABLE_MASK);
    eval 'sub printeir {
        my($val) = @_;
	    eval q( &printf(\\"%s: error reg: %b\\\\n\\",  &__func__, $val, \\"\\\\20\\\\x10PTEERR\\\\x2REFRESHERR\\\\x1INSTERR\\"));
    }' unless defined(&printeir);
    eval 'sub HAS_128_BYTE_Y_TILING {
        my($dev_priv) = @_;
	    eval q(( &IS_I9XX($dev_priv)  && !( &IS_I915G($dev_priv) ||  &IS_I915GM($dev_priv))));
    }' unless defined(&HAS_128_BYTE_Y_TILING);
    eval 'sub PRIMARY_RINGBUFFER_SIZE () {(128*1024);}' unless defined(&PRIMARY_RINGBUFFER_SIZE);
    eval 'sub i915_obj_purgeable {
        my($obj_priv) = @_;
	    eval q({ ( ($obj_priv->{obj}->{do_flags}) &  &I915_DONTNEED); });
    }' unless defined(&i915_obj_purgeable);
    eval 'sub i915_obj_purged {
        my($obj_priv) = @_;
	    eval q({ ( ($obj_priv->{obj}->{do_flags}) &  &I915_PURGED); });
    }' unless defined(&i915_obj_purged);
    eval 'sub inteldrm_is_active {
        my($obj_priv) = @_;
	    eval q({ ( ($obj_priv->{obj}->{do_flags}) &  &I915_ACTIVE); });
    }' unless defined(&inteldrm_is_active);
    eval 'sub inteldrm_is_dirty {
        my($obj_priv) = @_;
	    eval q({ ( ($obj_priv->{obj}->{do_flags}) &  &I915_DIRTY); });
    }' unless defined(&inteldrm_is_dirty);
    eval 'sub inteldrm_exec_needs_fence {
        my($obj_priv) = @_;
	    eval q({ ( ($obj_priv->{obj}->{do_flags}) &  &I915_EXEC_NEEDS_FENCE); });
    }' unless defined(&inteldrm_exec_needs_fence);
    eval 'sub inteldrm_needs_fence {
        my($obj_priv) = @_;
	    eval q({ ( ($obj_priv->{obj}->{do_flags}) &  &I915_FENCED_EXEC); });
    }' unless defined(&inteldrm_needs_fence);
}
1;
