/*	$OpenBSD: fmemopentest.c,v 1.1 2013/01/01 17:43:07 mpi Exp $ */
/*
 * Copyright (c) 2011 Martin Pieuchot <mpi@openbsd.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <err.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

int
main(void)
{
	FILE	*s1, *s2;
	char	 c, string[] = "fmemopen test string!";
	char	 buffer[1024], *buf = NULL;
	size_t	 len;
	int	 failures = 0;

	s1 = fmemopen(string, strlen(string), "r");
	if (s1 == NULL) {
		warn("unable to open a stream s1");
		return (1);
	}

	s2 = fmemopen(buf, 22, "w+");
	if (s2 == NULL) {
		warn("unable to create a stream s2");
		fclose(s1);
		return (1);
	}

	while ((c = fgetc(s1)) != EOF)
		fputc(c, s2);

	if (ftell(s2) != strlen(string)) {
		warnx("failed copy test (1)");
		failures++;
	}
	fclose(s1);

	fseek(s2, 0, SEEK_SET);
	if (ftell(s2) != 0) {
		warnx("failed seek test (2)");
		failures++;
	}

	len = fread(buffer, 1, sizeof(buffer) - 1, s2);
	if (len != strlen(string)) {
		warnx("failed read test (3)");
		failures++;
	}

	return (failures);
}
