/* rygel-server-1.0.vapi generated by valac 0.16.1, do not modify. */

namespace Rygel {
	[CCode (cheader_filename = "rygel-server.h")]
	public class AudioItem : Rygel.MediaItem {
		public int bitrate;
		public int bits_per_sample;
		public int channels;
		public long duration;
		public int sample_freq;
		public const string UPNP_CLASS;
		public AudioItem (string id, Rygel.MediaContainer parent, string title, string upnp_class = AudioItem.UPNP_CLASS);
		public override bool streamable ();
	}
	[CCode (cheader_filename = "rygel-server.h")]
	public class ImageItem : Rygel.MediaItem, Rygel.VisualItem {
		public const string UPNP_CLASS;
		public ImageItem (string id, Rygel.MediaContainer parent, string title, string upnp_class = ImageItem.UPNP_CLASS);
		public override void add_uri (string uri);
		protected override GUPnP.ProtocolInfo get_protocol_info (string? uri, string protocol);
		public override bool streamable ();
	}
	[CCode (cheader_filename = "rygel-server.h")]
	public class LogicalExpression : Rygel.SearchExpression<Rygel.LogicalOperator,Rygel.SearchExpression,Rygel.SearchExpression> {
		public LogicalExpression ();
		public override bool satisfied_by (Rygel.MediaObject media_object);
		public override string to_string ();
	}
	[CCode (cheader_filename = "rygel-server.h")]
	public class MediaArtStore : GLib.Object {
		public Rygel.Thumbnail? find_media_art (Rygel.MusicItem item, bool simple = false) throws GLib.Error;
		public Rygel.Thumbnail? find_media_art_any (Rygel.MusicItem item) throws GLib.Error;
		public static Rygel.MediaArtStore? get_default ();
		public GLib.File get_media_art_file (string type, Rygel.MusicItem item, bool simple = false);
	}
	[CCode (cheader_filename = "rygel-server.h")]
	public abstract class MediaContainer : Rygel.MediaObject {
		public int child_count;
		public int64 storage_used;
		public uint32 update_id;
		public const string ALBUM_SORT_CRITERIA;
		public const string MUSIC_ALBUM;
		public const string MUSIC_ARTIST;
		public const string MUSIC_GENRE;
		public const string STORAGE_FOLDER;
		public const string UPNP_CLASS;
		public MediaContainer (string id, Rygel.MediaContainer? parent, string title, int child_count);
		public abstract async Rygel.MediaObject? find_object (string id, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async Rygel.MediaObjects? get_children (uint offset, uint max_count, string sort_criteria, GLib.Cancellable? cancellable) throws GLib.Error;
		public MediaContainer.root (string title, int child_count);
		public void updated ();
		public string sort_criteria { get; set; }
		public signal void container_updated (Rygel.MediaContainer container);
	}
	[CCode (cheader_filename = "rygel-server.h")]
	public abstract class MediaItem : Rygel.MediaObject {
		protected GLib.Regex address_regex;
		public string date;
		public string dlna_profile;
		public string mime_type;
		public MediaItem (string id, Rygel.MediaContainer parent, string title, string upnp_class);
		protected virtual void add_resources (GUPnP.DIDLLiteItem didl_item, bool allow_internal) throws GLib.Error;
		public virtual void add_uri (string uri);
		public virtual Gst.Element? create_stream_source (string? host_ip = null);
		protected virtual GUPnP.ProtocolInfo get_protocol_info (string? uri, string protocol);
		public bool is_live_stream ();
		public abstract bool streamable ();
		public string description { get; set; }
		public bool place_holder { get; set; }
		public int64 size { get; set; }
	}
	[CCode (cheader_filename = "rygel-server.h")]
	public abstract class MediaObject : GLib.Object {
		public string id;
		public uint64 modified;
		public weak Rygel.MediaContainer parent;
		public string ref_id;
		public string upnp_class;
		public Gee.ArrayList<string> uris;
		public MediaObject ();
		protected int compare_int_props (int prop1, int prop2);
		protected int compare_string_props (string prop1, string prop2);
		public async GLib.File? get_writable (GLib.Cancellable? cancellable) throws GLib.Error;
		public async Gee.ArrayList<GLib.File> get_writables (GLib.Cancellable? cancellable) throws GLib.Error;
		public Rygel.MediaContainer parent_ref { get; set; }
		public string title { get; set; }
	}
	[CCode (cheader_filename = "rygel-server.h")]
	public class MediaObjects : Gee.ArrayList<Rygel.MediaObject> {
		public const string SORT_CAPS;
		public MediaObjects ();
		public override Gee.List<Rygel.MediaObject>? slice (int start, int stop);
		public void sort_by_criteria (string sort_criteria);
	}
	[CCode (cheader_filename = "rygel-server.h")]
	public class MediaServer : Rygel.MediaDevice {
		public MediaServer (string title, Rygel.MediaContainer root_container);
	}
	[CCode (cheader_filename = "rygel-server.h")]
	public abstract class MediaServerPlugin : Rygel.Plugin {
		public Rygel.MediaContainer root_container;
		public MediaServerPlugin (Rygel.MediaContainer root_container, string name, string? description = null);
		public override void apply_hacks (Rygel.RootDevice device, string description_path) throws GLib.Error;
	}
	[CCode (cheader_filename = "rygel-server.h")]
	public class MusicItem : Rygel.AudioItem {
		public string album;
		public Rygel.Thumbnail album_art;
		public string artist;
		public string genre;
		public int track_number;
		public const string UPNP_CLASS;
		public MusicItem (string id, Rygel.MediaContainer parent, string title, string upnp_class = MusicItem.UPNP_CLASS);
		public void lookup_album_art ();
	}
	[CCode (cheader_filename = "rygel-server.h")]
	public class PhotoItem : Rygel.ImageItem {
		public string creator;
		public const string UPNP_CLASS;
		public PhotoItem (string id, Rygel.MediaContainer parent, string title, string upnp_class = PhotoItem.UPNP_CLASS);
	}
	[CCode (cheader_filename = "rygel-server.h")]
	public class RelationalExpression : Rygel.SearchExpression<GUPnP.SearchCriteriaOp,string,string> {
		public RelationalExpression ();
		public bool compare_int (int integer);
		public bool compare_string (string? str);
		public override bool satisfied_by (Rygel.MediaObject media_object);
		public override string to_string ();
	}
	[CCode (cheader_filename = "rygel-server.h")]
	public abstract class SearchExpression<G,H,I> {
		public G op;
		public H operand1;
		public I operand2;
		public SearchExpression ();
		public abstract bool satisfied_by (Rygel.MediaObject media_object);
		public abstract string to_string ();
	}
	[CCode (cheader_filename = "rygel-server.h")]
	public class SimpleContainer : Rygel.MediaContainer, Rygel.SearchableContainer {
		public Rygel.MediaObjects children;
		public SimpleContainer (string id, Rygel.MediaContainer? parent, string title);
		public void add_child_container (Rygel.MediaContainer child);
		public void add_child_item (Rygel.MediaItem child);
		public void clear ();
		public override async Rygel.MediaObject? find_object (string id, GLib.Cancellable? cancellable) throws GLib.Error;
		public Rygel.MediaObjects get_all_children ();
		public override async Rygel.MediaObjects? get_children (uint offset, uint max_count, string sort_criteria, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool is_child_id_unique (string child_id);
		public void remove_child (Rygel.MediaObject child);
		public SimpleContainer.root (string title);
	}
	[CCode (cheader_filename = "rygel-server.h")]
	public class Subtitle {
		public string caption_type;
		public string mime_type;
		public int64 size;
		public string uri;
		public Subtitle (string mime_type = "text/plain", string caption_type = "srt");
	}
	[CCode (cheader_filename = "rygel-server.h")]
	public class Thumbnail : Rygel.IconInfo {
		public string dlna_profile;
		public Thumbnail (string mime_type = "image/jpeg", string dlna_profile = "JPEG_TN", string file_extension = "jpg");
	}
	[CCode (cheader_filename = "rygel-server.h")]
	public class VideoItem : Rygel.AudioItem, Rygel.VisualItem {
		public string author;
		public Gee.ArrayList<Rygel.Subtitle> subtitles;
		public const string UPNP_CLASS;
		public VideoItem (string id, Rygel.MediaContainer parent, string title, string upnp_class = VideoItem.UPNP_CLASS);
		public override void add_uri (string uri);
		public override bool streamable ();
	}
	[CCode (cheader_filename = "rygel-server.h")]
	public interface SearchableContainer : Rygel.MediaContainer {
		public async Rygel.MediaObject? find_object (string id, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async Rygel.MediaObjects? search (Rygel.SearchExpression? expression, uint offset, uint max_count, out uint total_matches, string sort_criteria, GLib.Cancellable? cancellable) throws GLib.Error;
		public async Rygel.MediaObjects? simple_search (Rygel.SearchExpression? expression, uint offset, uint max_count, out uint total_matches, string sort_criteria, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract Gee.ArrayList<string> search_classes { get; set; }
	}
	[CCode (cheader_filename = "rygel-server.h")]
	public interface VisualItem : Rygel.MediaItem {
		public abstract int color_depth { get; set; }
		public abstract int height { get; set; }
		public abstract int pixel_height { get; set; }
		public abstract int pixel_width { get; set; }
		public abstract Gee.ArrayList<Rygel.Thumbnail> thumbnails { get; protected set; }
		public abstract int width { get; set; }
	}
	[CCode (cheader_filename = "rygel-server.h")]
	public interface WritableContainer : Rygel.MediaContainer {
		public abstract async void add_item (Rygel.MediaItem item, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool can_create (string upnp_class);
		public abstract async void remove_item (string id, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract Gee.ArrayList<string> create_classes { get; set; }
	}
	[CCode (cheader_filename = "rygel-server.h")]
	public enum LogicalOperator {
		AND,
		OR
	}
	[CCode (cheader_filename = "rygel-server.h")]
	public errordomain ContentDirectoryError {
		NO_SUCH_OBJECT,
		INVALID_SORT_CRITERIA,
		RESTRICTED_OBJECT,
		BAD_METADATA,
		RESTRICTED_PARENT,
		NO_SUCH_DESTINATION_RESOURCE,
		CANT_PROCESS,
		INVALID_ARGS
	}
	[CCode (cheader_filename = "rygel-server.h")]
	public errordomain GstTranscoderError {
		CANT_TRANSCODE
	}
}
