#!/bin/sh
echo 'name: uniplate
version: 1.6.7
id: uniplate-1.6.7-77db7a6a2c08e2577d1fac19e3479237

license: BSD3
copyright: Neil Mitchell 2006-2012
maintainer: Neil Mitchell <ndmitchell@gmail.com>
stability:
homepage: http://community.haskell.org/~ndm/uniplate/
package-url:
synopsis: Help writing simple, concise and fast generic operations.
description: Uniplate is library for writing simple and concise generic operations.
             Uniplate has similar goals to the original Scrap Your Boilerplate work,
             but is substantially simpler and faster. The Uniplate manual is available at
             <http://community.haskell.org/~ndm/darcs/uniplate/uniplate.htm>.
             .
             To get started with Uniplate you should import one of the three following
             modules:
             .
             * "Data.Generics.Uniplate.Data" - to quickly start writing generic functions.
             Most users should start by importing this module.
             .
             * "Data.Generics.Uniplate.Direct" - a replacement for "Data.Generics.Uniplate.Data"
             with substantially higher performance (around 5 times), but requires writing
             instance declarations.
             .
             * "Data.Generics.Uniplate.Operations" - definitions of all the operations defined
             by Uniplate. Both the above two modules re-export this module.
             .
             In addition, some users may want to make use of the following modules:
             .
             * "Data.Generics.Uniplate.Zipper" - a zipper built on top of Uniplate instances.
             .
             * "Data.Generics.SYB" - users transitioning from the Scrap Your Boilerplate library.
             .
             * "Data.Generics.Compos" - users transitioning from the Compos library.
             .
             * "Data.Generics.Uniplate.DataOnly" - users making use of both @Data@ and @Direct@
             to avoid getting instance conflicts.
category: Generics
author: Neil Mitchell <ndmitchell@gmail.com>
pkgpath: devel/hs-uniplate
exposed: True
exposed-modules: Data.Generics.Str Data.Generics.Compos
                 Data.Generics.SYB Data.Generics.Uniplate.Data
                 Data.Generics.Uniplate.Data.Instances
                 Data.Generics.Uniplate.DataOnly Data.Generics.Uniplate.Direct
                 Data.Generics.Uniplate.Operations Data.Generics.Uniplate.Typeable
                 Data.Generics.Uniplate.Zipper Data.Generics.Uniplate
                 Data.Generics.UniplateOn Data.Generics.UniplateStr
                 Data.Generics.UniplateStrOn Data.Generics.Biplate
                 Data.Generics.PlateDirect Data.Generics.PlateTypeable
                 Data.Generics.PlateData
hidden-modules: Data.Generics.PlateInternal
                Data.Generics.Uniplate.Internal.Data
                Data.Generics.Uniplate.Internal.DataOnlyOperations
                Data.Generics.Uniplate.Internal.Utils
trusted: False
import-dirs: /usr/local/lib/ghc/uniplate-1.6.7
library-dirs: /usr/local/lib/ghc/uniplate-1.6.7
hs-libraries: HSuniplate-1.6.7
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         containers-0.4.2.1-75f143aa39a3e77a1ce2300025bdd8ce
         hashable-1.1.2.3-d030b9fe5b35dcb16975530055dde91a
         syb-0.3.7-60af41a2377e93620710d393692aff24
         unordered-containers-0.1.4.6-a7207f78d453daba3716dfc838a574ed
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-uniplate-1.6.7/html/uniplate.haddock
haddock-html: /usr/local/share/doc/hs-uniplate-1.6.7/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
