#!/bin/sh
echo 'name: cryptohash
version: 0.7.0
id: cryptohash-0.7.0-3ceda0c1674b60a9ad220df908950638

license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability:
homepage: http://github.com/vincenthz/hs-cryptohash
package-url:
synopsis: collection of crypto hashes, fast, pure and practical
description: A collection of crypto hashes, with a practical incremental and one-pass, pure APIs,
             with performance close to the fastest implementations available in others languages.
             .
             The implementations are made in C with a haskell FFI wrapper that hide the C implementation.
category: Data, Cryptography
author: Vincent Hanquez <vincent@snarc.org>
pkgpath: security/hs-cryptohash
exposed: True
exposed-modules: Crypto.Hash.SHA1 Crypto.Hash.SHA224
                 Crypto.Hash.SHA256 Crypto.Hash.SHA384 Crypto.Hash.SHA512
                 Crypto.Hash.SHA512t Crypto.Hash.MD2 Crypto.Hash.MD4 Crypto.Hash.MD5
                 Crypto.Hash.RIPEMD160 Crypto.Hash.Skein256 Crypto.Hash.Skein512
                 Crypto.Hash.Tiger
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/cryptohash-0.7.0
library-dirs: /usr/local/lib/ghc/cryptohash-0.7.0
hs-libraries: HScryptohash-0.7.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         bytestring-0.9.2.1-4f95f32adc23f1bc25c472a646e99581
         cereal-0.3.5.2-807bd944bfc86ac5df2f667be96ad9f0
         crypto-api-0.10.2-b894ddbcbc6462caabf9766373a4cdd1
         tagged-0.4.4-886769b727dcf06f0418d254f5119104
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-cryptohash-0.7.0/html/cryptohash.haddock
haddock-html: /usr/local/share/doc/hs-cryptohash-0.7.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
