#!/bin/sh
echo 'name: Crypto
version: 4.2.5
id: Crypto-4.2.5-99f49e9cc5efc5d1ea1975c7a351c2ad

license: OtherLicense
copyright: Dominic Steinitz 2003 - 2007
maintainer: Caylee Hogg <caylee.hogg@gmail.com>
stability: Alpha
homepage:
package-url:
synopsis: Collects together existing Haskell cryptographic functions into a package
description: DES, Blowfish, AES, TEA, SHA1, MD5, RSA, BubbleBabble,
             Hexdump, Support for Word128, Word192 and Word256 and Beyond, PKCS5
             Padding, Various Encryption Modes e.g. Cipher Block Chaining all in one package,
             with HUnit and QuickCheck tests, and examples.
category: Cryptography, Codec
author: Dominic Steinitz
pkgpath: security/hs-crypto
exposed: True
exposed-modules: Codec.Binary.BubbleBabble Codec.Encryption.RSA
                 Codec.Encryption.RSA.EMEOAEP Codec.Encryption.RSA.MGF
                 Codec.Encryption.RSA.NumberTheory Codec.Encryption.DES
                 Codec.Encryption.AES Codec.Encryption.TEA Codec.Encryption.Blowfish
                 Codec.Encryption.Modes Codec.Encryption.Padding Codec.Text.Raw
                 Codec.Utils Data.Digest.MD5 Data.Digest.SHA1 Data.Digest.SHA2
                 Data.Digest.SHA224 Data.Digest.SHA256 Data.Digest.SHA384
                 Data.Digest.SHA512 Data.LargeWord Data.HMAC
hidden-modules: Codec.Encryption.BlowfishAux
                Codec.Encryption.DESAux Codec.Encryption.AESAux Data.Digest.MD5Aux
trusted: False
import-dirs: /usr/local/lib/ghc/Crypto-4.2.5
library-dirs: /usr/local/lib/ghc/Crypto-4.2.5
hs-libraries: HSCrypto-4.2.5
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: HUnit-1.2.5.1-3a320959e06d702551395cbe60e9b4d5
         QuickCheck-2.5.1.1-4a9242f1b61a140fe486a54f5467ba42
         array-0.4.0.0-0b6c5ca7e879a14d110ca4c001dd9297
         base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         pretty-1.1.1.0-91ed62f0481a81d292d550eec35ee75b
         random-1.0.1.1-d8f82f84701874725b418c29860a58e0
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-Crypto-4.2.5/html/Crypto.haddock
haddock-html: /usr/local/share/doc/hs-Crypto-4.2.5/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
