require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&MFI_MGMT_VD)) {
    sub MFI_MGMT_VD () {	0x1;}
}
unless(defined(&MFI_MGMT_SD)) {
    sub MFI_MGMT_SD () {	0x2;}
}
unless(defined(&MFI_FRAME_SIZE)) {
    sub MFI_FRAME_SIZE () {	64;}
}
unless(defined(&MFI_SENSE_SIZE)) {
    sub MFI_SENSE_SIZE () {	128;}
}
unless(defined(&MFI_OSTS_INTR_VALID)) {
    sub MFI_OSTS_INTR_VALID () {	0x2;}
}
unless(defined(&MFI_OSTS_PPC_INTR_VALID)) {
    sub MFI_OSTS_PPC_INTR_VALID () {	0x80000000;}
}
unless(defined(&MFI_OSTS_GEN2_INTR_VALID)) {
    sub MFI_OSTS_GEN2_INTR_VALID () {	(0x1 | 0x4);}
}
unless(defined(&MFI_INVALID_CTX)) {
    sub MFI_INVALID_CTX () {	0xffffffff;}
}
unless(defined(&MFI_ENABLE_INTR)) {
    sub MFI_ENABLE_INTR () {	0x1;}
}
unless(defined(&MFI_MAXFER)) {
    sub MFI_MAXFER () {	 &MAXPHYS;}
}
unless(defined(&MFI_IMSG0)) {
    sub MFI_IMSG0 () {	0x10;}
}
unless(defined(&MFI_IMSG1)) {
    sub MFI_IMSG1 () {	0x14;}
}
unless(defined(&MFI_OMSG0)) {
    sub MFI_OMSG0 () {	0x18;}
}
unless(defined(&MFI_OMSG1)) {
    sub MFI_OMSG1 () {	0x1c;}
}
unless(defined(&MFI_IDB)) {
    sub MFI_IDB () {	0x20;}
}
unless(defined(&MFI_ISTS)) {
    sub MFI_ISTS () {	0x24;}
}
unless(defined(&MFI_IMSK)) {
    sub MFI_IMSK () {	0x28;}
}
unless(defined(&MFI_ODB)) {
    sub MFI_ODB () {	0x2c;}
}
unless(defined(&MFI_OSTS)) {
    sub MFI_OSTS () {	0x30;}
}
unless(defined(&MFI_OMSK)) {
    sub MFI_OMSK () {	0x34;}
}
unless(defined(&MFI_IQP)) {
    sub MFI_IQP () {	0x40;}
}
unless(defined(&MFI_OQP)) {
    sub MFI_OQP () {	0x44;}
}
unless(defined(&MFI_ODC)) {
    sub MFI_ODC () {	0xa0;}
}
unless(defined(&MFI_OSP)) {
    sub MFI_OSP () {	0xb0;}
}
unless(defined(&MFI_SKINNY_IDB)) {
    sub MFI_SKINNY_IDB () {	0x;}
}
unless(defined(&MFI_IQPL)) {
    sub MFI_IQPL () {	0xc0;}
}
unless(defined(&MFI_IQPH)) {
    sub MFI_IQPH () {	0xc4;}
}
unless(defined(&MFI_OSTS_SKINNY_INTR_VALID)) {
    sub MFI_OSTS_SKINNY_INTR_VALID () {	0x1;}
}
unless(defined(&MFI_STATE_MASK)) {
    sub MFI_STATE_MASK () {	0xf0000000;}
}
unless(defined(&MFI_STATE_UNDEFINED)) {
    sub MFI_STATE_UNDEFINED () {	0x;}
}
unless(defined(&MFI_STATE_BB_INIT)) {
    sub MFI_STATE_BB_INIT () {	0x10000000;}
}
unless(defined(&MFI_STATE_FW_INIT)) {
    sub MFI_STATE_FW_INIT () {	0x40000000;}
}
unless(defined(&MFI_STATE_WAIT_HANDSHAKE)) {
    sub MFI_STATE_WAIT_HANDSHAKE () {	0x60000000;}
}
unless(defined(&MFI_STATE_FW_INIT_2)) {
    sub MFI_STATE_FW_INIT_2 () {	0x70000000;}
}
unless(defined(&MFI_STATE_DEVICE_SCAN)) {
    sub MFI_STATE_DEVICE_SCAN () {	0x80000000;}
}
unless(defined(&MFI_STATE_FLUSH_CACHE)) {
    sub MFI_STATE_FLUSH_CACHE () {	0xa0000000;}
}
unless(defined(&MFI_STATE_READY)) {
    sub MFI_STATE_READY () {	0xb0000000;}
}
unless(defined(&MFI_STATE_OPERATIONAL)) {
    sub MFI_STATE_OPERATIONAL () {	0xc0000000;}
}
unless(defined(&MFI_STATE_FAULT)) {
    sub MFI_STATE_FAULT () {	0xf0000000;}
}
unless(defined(&MFI_STATE_MAXSGL_MASK)) {
    sub MFI_STATE_MAXSGL_MASK () {	0xff0000;}
}
unless(defined(&MFI_STATE_MAXCMD_MASK)) {
    sub MFI_STATE_MAXCMD_MASK () {	0xffff;}
}
unless(defined(&MFI_INIT_ABORT)) {
    sub MFI_INIT_ABORT () {	0x;}
}
unless(defined(&MFI_INIT_READY)) {
    sub MFI_INIT_READY () {	0x2;}
}
unless(defined(&MFI_INIT_MFIMODE)) {
    sub MFI_INIT_MFIMODE () {	0x4;}
}
unless(defined(&MFI_INIT_CLEAR_HANDSHAKE)) {
    sub MFI_INIT_CLEAR_HANDSHAKE () {	0x8;}
}
unless(defined(&MFI_RESET_FLAGS)) {
    sub MFI_RESET_FLAGS () {	 &MFI_INIT_READY| &MFI_INIT_MFIMODE;}
}
unless(defined(&MFI_FRAME_POST_IN_REPLY_QUEUE)) {
    sub MFI_FRAME_POST_IN_REPLY_QUEUE () {	0x;}
}
unless(defined(&MFI_FRAME_DONT_POST_IN_REPLY_QUEUE)) {
    sub MFI_FRAME_DONT_POST_IN_REPLY_QUEUE () {	0x1;}
}
unless(defined(&MFI_FRAME_SGL32)) {
    sub MFI_FRAME_SGL32 () {	0x;}
}
unless(defined(&MFI_FRAME_SGL64)) {
    sub MFI_FRAME_SGL64 () {	0x2;}
}
unless(defined(&MFI_FRAME_SENSE32)) {
    sub MFI_FRAME_SENSE32 () {	0x;}
}
unless(defined(&MFI_FRAME_SENSE64)) {
    sub MFI_FRAME_SENSE64 () {	0x4;}
}
unless(defined(&MFI_FRAME_DIR_NONE)) {
    sub MFI_FRAME_DIR_NONE () {	0x;}
}
unless(defined(&MFI_FRAME_DIR_WRITE)) {
    sub MFI_FRAME_DIR_WRITE () {	0x8;}
}
unless(defined(&MFI_FRAME_DIR_READ)) {
    sub MFI_FRAME_DIR_READ () {	0x10;}
}
unless(defined(&MFI_FRAME_DIR_BOTH)) {
    sub MFI_FRAME_DIR_BOTH () {	0x18;}
}
unless(defined(&MFI_CMD_INIT)) {
    sub MFI_CMD_INIT () {	0x;}
}
unless(defined(&MFI_CMD_LD_READ)) {
    sub MFI_CMD_LD_READ () {	0x1;}
}
unless(defined(&MFI_CMD_LD_WRITE)) {
    sub MFI_CMD_LD_WRITE () {	0x2;}
}
unless(defined(&MFI_CMD_LD_SCSI_IO)) {
    sub MFI_CMD_LD_SCSI_IO () {	0x3;}
}
unless(defined(&MFI_CMD_PD_SCSI_IO)) {
    sub MFI_CMD_PD_SCSI_IO () {	0x4;}
}
unless(defined(&MFI_CMD_DCMD)) {
    sub MFI_CMD_DCMD () {	0x5;}
}
unless(defined(&MFI_CMD_ABORT)) {
    sub MFI_CMD_ABORT () {	0x6;}
}
unless(defined(&MFI_CMD_SMP)) {
    sub MFI_CMD_SMP () {	0x7;}
}
unless(defined(&MFI_CMD_STP)) {
    sub MFI_CMD_STP () {	0x8;}
}
unless(defined(&MR_DCMD_CTRL_GET_INFO)) {
    sub MR_DCMD_CTRL_GET_INFO () {	0x1010000;}
}
unless(defined(&MR_DCMD_CTRL_CACHE_FLUSH)) {
    sub MR_DCMD_CTRL_CACHE_FLUSH () {	0x1101000;}
}
unless(defined(&MR_FLUSH_CTRL_CACHE)) {
    sub MR_FLUSH_CTRL_CACHE () {	0x1;}
}
unless(defined(&MR_FLUSH_DISK_CACHE)) {
    sub MR_FLUSH_DISK_CACHE () {	0x2;}
}
unless(defined(&MR_DCMD_CTRL_SHUTDOWN)) {
    sub MR_DCMD_CTRL_SHUTDOWN () {	0x1050000;}
}
unless(defined(&MR_ENABLE_DRIVE_SPINDOWN)) {
    sub MR_ENABLE_DRIVE_SPINDOWN () {	0x1;}
}
unless(defined(&MR_DCMD_CTRL_EVENT_GET_INFO)) {
    sub MR_DCMD_CTRL_EVENT_GET_INFO () {	0x1040100;}
}
unless(defined(&MR_DCMD_CTRL_EVENT_GET)) {
    sub MR_DCMD_CTRL_EVENT_GET () {	0x1040300;}
}
unless(defined(&MR_DCMD_CTRL_EVENT_WAIT)) {
    sub MR_DCMD_CTRL_EVENT_WAIT () {	0x1040500;}
}
unless(defined(&MR_DCMD_PD_GET_LIST)) {
    sub MR_DCMD_PD_GET_LIST () {	0x2010000;}
}
unless(defined(&MR_DCMD_PD_GET_INFO)) {
    sub MR_DCMD_PD_GET_INFO () {	0x2020000;}
}
unless(defined(&MD_DCMD_PD_SET_STATE)) {
    sub MD_DCMD_PD_SET_STATE () {	0x2030100;}
}
unless(defined(&MD_DCMD_PD_REBUILD)) {
    sub MD_DCMD_PD_REBUILD () {	0x2040100;}
}
unless(defined(&MR_DCMD_PD_BLINK)) {
    sub MR_DCMD_PD_BLINK () {	0x2070100;}
}
unless(defined(&MR_DCMD_PD_UNBLINK)) {
    sub MR_DCMD_PD_UNBLINK () {	0x2070200;}
}
unless(defined(&MR_DCMD_PD_GET_ALLOWED_OPS_LIST)) {
    sub MR_DCMD_PD_GET_ALLOWED_OPS_LIST () {	0x20a0100;}
}
unless(defined(&MR_DCMD_LD_GET_LIST)) {
    sub MR_DCMD_LD_GET_LIST () {	0x3010000;}
}
unless(defined(&MR_DCMD_LD_GET_INFO)) {
    sub MR_DCMD_LD_GET_INFO () {	0x3020000;}
}
unless(defined(&MR_DCMD_LD_GET_PROPERTIES)) {
    sub MR_DCMD_LD_GET_PROPERTIES () {	0x3030000;}
}
unless(defined(&MD_DCMD_CONF_GET)) {
    sub MD_DCMD_CONF_GET () {	0x4010000;}
}
unless(defined(&MR_DCMD_CLUSTER)) {
    sub MR_DCMD_CLUSTER () {	0x8000000;}
}
unless(defined(&MR_DCMD_CLUSTER_RESET_ALL)) {
    sub MR_DCMD_CLUSTER_RESET_ALL () {	0x8010100;}
}
unless(defined(&MR_DCMD_CLUSTER_RESET_LD)) {
    sub MR_DCMD_CLUSTER_RESET_LD () {	0x8010200;}
}
unless(defined(&MR_DCMD_SPEAKER_GET)) {
    sub MR_DCMD_SPEAKER_GET () {	0x1030100;}
}
unless(defined(&MR_DCMD_SPEAKER_ENABLE)) {
    sub MR_DCMD_SPEAKER_ENABLE () {	0x1030200;}
}
unless(defined(&MR_DCMD_SPEAKER_DISABLE)) {
    sub MR_DCMD_SPEAKER_DISABLE () {	0x1030300;}
}
unless(defined(&MR_DCMD_SPEAKER_SILENCE)) {
    sub MR_DCMD_SPEAKER_SILENCE () {	0x1030400;}
}
unless(defined(&MR_DCMD_SPEAKER_TEST)) {
    sub MR_DCMD_SPEAKER_TEST () {	0x1030500;}
}
unless(defined(&MFI_MBOX_SIZE)) {
    sub MFI_MBOX_SIZE () {	12;}
}
eval("sub MFI_STAT_OK () { 0x00; }") unless defined(&MFI_STAT_OK);
eval("sub MFI_STAT_INVALID_CMD () { 0x01; }") unless defined(&MFI_STAT_INVALID_CMD);
eval("sub MFI_STAT_INVALID_DCMD () { 0x02; }") unless defined(&MFI_STAT_INVALID_DCMD);
eval("sub MFI_STAT_INVALID_PARAMETER () { 0x03; }") unless defined(&MFI_STAT_INVALID_PARAMETER);
eval("sub MFI_STAT_INVALID_SEQUENCE_NUMBER () { 0x04; }") unless defined(&MFI_STAT_INVALID_SEQUENCE_NUMBER);
eval("sub MFI_STAT_ABORT_NOT_POSSIBLE () { 0x05; }") unless defined(&MFI_STAT_ABORT_NOT_POSSIBLE);
eval("sub MFI_STAT_APP_HOST_CODE_NOT_FOUND () { 0x06; }") unless defined(&MFI_STAT_APP_HOST_CODE_NOT_FOUND);
eval("sub MFI_STAT_APP_IN_USE () { 0x07; }") unless defined(&MFI_STAT_APP_IN_USE);
eval("sub MFI_STAT_APP_NOT_INITIALIZED () { 0x08; }") unless defined(&MFI_STAT_APP_NOT_INITIALIZED);
eval("sub MFI_STAT_ARRAY_INDEX_INVALID () { 0x09; }") unless defined(&MFI_STAT_ARRAY_INDEX_INVALID);
eval("sub MFI_STAT_ARRAY_ROW_NOT_EMPTY () { 0x0a; }") unless defined(&MFI_STAT_ARRAY_ROW_NOT_EMPTY);
eval("sub MFI_STAT_CONFIG_RESOURCE_CONFLICT () { 0x0b; }") unless defined(&MFI_STAT_CONFIG_RESOURCE_CONFLICT);
eval("sub MFI_STAT_DEVICE_NOT_FOUND () { 0x0c; }") unless defined(&MFI_STAT_DEVICE_NOT_FOUND);
eval("sub MFI_STAT_DRIVE_TOO_SMALL () { 0x0d; }") unless defined(&MFI_STAT_DRIVE_TOO_SMALL);
eval("sub MFI_STAT_FLASH_ALLOC_FAIL () { 0x0e; }") unless defined(&MFI_STAT_FLASH_ALLOC_FAIL);
eval("sub MFI_STAT_FLASH_BUSY () { 0x0f; }") unless defined(&MFI_STAT_FLASH_BUSY);
eval("sub MFI_STAT_FLASH_ERROR () { 0x10; }") unless defined(&MFI_STAT_FLASH_ERROR);
eval("sub MFI_STAT_FLASH_IMAGE_BAD () { 0x11; }") unless defined(&MFI_STAT_FLASH_IMAGE_BAD);
eval("sub MFI_STAT_FLASH_IMAGE_INCOMPLETE () { 0x12; }") unless defined(&MFI_STAT_FLASH_IMAGE_INCOMPLETE);
eval("sub MFI_STAT_FLASH_NOT_OPEN () { 0x13; }") unless defined(&MFI_STAT_FLASH_NOT_OPEN);
eval("sub MFI_STAT_FLASH_NOT_STARTED () { 0x14; }") unless defined(&MFI_STAT_FLASH_NOT_STARTED);
eval("sub MFI_STAT_FLUSH_FAILED () { 0x15; }") unless defined(&MFI_STAT_FLUSH_FAILED);
eval("sub MFI_STAT_HOST_CODE_NOT_FOUNT () { 0x16; }") unless defined(&MFI_STAT_HOST_CODE_NOT_FOUNT);
eval("sub MFI_STAT_LD_CC_IN_PROGRESS () { 0x17; }") unless defined(&MFI_STAT_LD_CC_IN_PROGRESS);
eval("sub MFI_STAT_LD_INIT_IN_PROGRESS () { 0x18; }") unless defined(&MFI_STAT_LD_INIT_IN_PROGRESS);
eval("sub MFI_STAT_LD_LBA_OUT_OF_RANGE () { 0x19; }") unless defined(&MFI_STAT_LD_LBA_OUT_OF_RANGE);
eval("sub MFI_STAT_LD_MAX_CONFIGURED () { 0x1a; }") unless defined(&MFI_STAT_LD_MAX_CONFIGURED);
eval("sub MFI_STAT_LD_NOT_OPTIMAL () { 0x1b; }") unless defined(&MFI_STAT_LD_NOT_OPTIMAL);
eval("sub MFI_STAT_LD_RBLD_IN_PROGRESS () { 0x1c; }") unless defined(&MFI_STAT_LD_RBLD_IN_PROGRESS);
eval("sub MFI_STAT_LD_RECON_IN_PROGRESS () { 0x1d; }") unless defined(&MFI_STAT_LD_RECON_IN_PROGRESS);
eval("sub MFI_STAT_LD_WRONG_RAID_LEVEL () { 0x1e; }") unless defined(&MFI_STAT_LD_WRONG_RAID_LEVEL);
eval("sub MFI_STAT_MAX_SPARES_EXCEEDED () { 0x1f; }") unless defined(&MFI_STAT_MAX_SPARES_EXCEEDED);
eval("sub MFI_STAT_MEMORY_NOT_AVAILABLE () { 0x20; }") unless defined(&MFI_STAT_MEMORY_NOT_AVAILABLE);
eval("sub MFI_STAT_MFC_HW_ERROR () { 0x21; }") unless defined(&MFI_STAT_MFC_HW_ERROR);
eval("sub MFI_STAT_NO_HW_PRESENT () { 0x22; }") unless defined(&MFI_STAT_NO_HW_PRESENT);
eval("sub MFI_STAT_NOT_FOUND () { 0x23; }") unless defined(&MFI_STAT_NOT_FOUND);
eval("sub MFI_STAT_NOT_IN_ENCL () { 0x24; }") unless defined(&MFI_STAT_NOT_IN_ENCL);
eval("sub MFI_STAT_PD_CLEAR_IN_PROGRESS () { 0x25; }") unless defined(&MFI_STAT_PD_CLEAR_IN_PROGRESS);
eval("sub MFI_STAT_PD_TYPE_WRONG () { 0x26; }") unless defined(&MFI_STAT_PD_TYPE_WRONG);
eval("sub MFI_STAT_PR_DISABLED () { 0x27; }") unless defined(&MFI_STAT_PR_DISABLED);
eval("sub MFI_STAT_ROW_INDEX_INVALID () { 0x28; }") unless defined(&MFI_STAT_ROW_INDEX_INVALID);
eval("sub MFI_STAT_SAS_CONFIG_INVALID_ACTION () { 0x29; }") unless defined(&MFI_STAT_SAS_CONFIG_INVALID_ACTION);
eval("sub MFI_STAT_SAS_CONFIG_INVALID_DATA () { 0x2a; }") unless defined(&MFI_STAT_SAS_CONFIG_INVALID_DATA);
eval("sub MFI_STAT_SAS_CONFIG_INVALID_PAGE () { 0x2b; }") unless defined(&MFI_STAT_SAS_CONFIG_INVALID_PAGE);
eval("sub MFI_STAT_SAS_CONFIG_INVALID_TYPE () { 0x2c; }") unless defined(&MFI_STAT_SAS_CONFIG_INVALID_TYPE);
eval("sub MFI_STAT_SCSI_DONE_WITH_ERROR () { 0x2d; }") unless defined(&MFI_STAT_SCSI_DONE_WITH_ERROR);
eval("sub MFI_STAT_SCSI_IO_FAILED () { 0x2e; }") unless defined(&MFI_STAT_SCSI_IO_FAILED);
eval("sub MFI_STAT_SCSI_RESERVATION_CONFLICT () { 0x2f; }") unless defined(&MFI_STAT_SCSI_RESERVATION_CONFLICT);
eval("sub MFI_STAT_SHUTDOWN_FAILED () { 0x30; }") unless defined(&MFI_STAT_SHUTDOWN_FAILED);
eval("sub MFI_STAT_TIME_NOT_SET () { 0x31; }") unless defined(&MFI_STAT_TIME_NOT_SET);
eval("sub MFI_STAT_WRONG_STATE () { 0x32; }") unless defined(&MFI_STAT_WRONG_STATE);
eval("sub MFI_STAT_LD_OFFLINE () { 0x33; }") unless defined(&MFI_STAT_LD_OFFLINE);
eval("sub MFI_STAT_PEER_NOTIFICATION_REJECTED () { 0x34; }") unless defined(&MFI_STAT_PEER_NOTIFICATION_REJECTED);
eval("sub MFI_STAT_PEER_NOTIFICATION_FAILED () { 0x35; }") unless defined(&MFI_STAT_PEER_NOTIFICATION_FAILED);
eval("sub MFI_STAT_RESERVATION_IN_PROGRESS () { 0x36; }") unless defined(&MFI_STAT_RESERVATION_IN_PROGRESS);
eval("sub MFI_STAT_I2C_ERRORS_DETECTED () { 0x37; }") unless defined(&MFI_STAT_I2C_ERRORS_DETECTED);
eval("sub MFI_STAT_PCI_ERRORS_DETECTED () { 0x38; }") unless defined(&MFI_STAT_PCI_ERRORS_DETECTED);
eval("sub MFI_STAT_INVALID_STATUS () { 0xff; }") unless defined(&MFI_STAT_INVALID_STATUS);
eval("sub MFI_EVT_CLASS_DEBUG () { -2; }") unless defined(&MFI_EVT_CLASS_DEBUG);
eval("sub MFI_EVT_CLASS_PROGRESS () { -1; }") unless defined(&MFI_EVT_CLASS_PROGRESS);
eval("sub MFI_EVT_CLASS_INFO () { 0; }") unless defined(&MFI_EVT_CLASS_INFO);
eval("sub MFI_EVT_CLASS_WARNING () { 1; }") unless defined(&MFI_EVT_CLASS_WARNING);
eval("sub MFI_EVT_CLASS_CRITICAL () { 2; }") unless defined(&MFI_EVT_CLASS_CRITICAL);
eval("sub MFI_EVT_CLASS_FATAL () { 3; }") unless defined(&MFI_EVT_CLASS_FATAL);
eval("sub MFI_EVT_CLASS_DEAD () { 4; }") unless defined(&MFI_EVT_CLASS_DEAD);
eval("sub MFI_EVT_LOCALE_LD () { 0x0001; }") unless defined(&MFI_EVT_LOCALE_LD);
eval("sub MFI_EVT_LOCALE_PD () { 0x0002; }") unless defined(&MFI_EVT_LOCALE_PD);
eval("sub MFI_EVT_LOCALE_ENCL () { 0x0004; }") unless defined(&MFI_EVT_LOCALE_ENCL);
eval("sub MFI_EVT_LOCALE_BBU () { 0x0008; }") unless defined(&MFI_EVT_LOCALE_BBU);
eval("sub MFI_EVT_LOCALE_SAS () { 0x0010; }") unless defined(&MFI_EVT_LOCALE_SAS);
eval("sub MFI_EVT_LOCALE_CTRL () { 0x0020; }") unless defined(&MFI_EVT_LOCALE_CTRL);
eval("sub MFI_EVT_LOCALE_CONFIG () { 0x0040; }") unless defined(&MFI_EVT_LOCALE_CONFIG);
eval("sub MFI_EVT_LOCALE_CLUSTER () { 0x0080; }") unless defined(&MFI_EVT_LOCALE_CLUSTER);
eval("sub MFI_EVT_LOCALE_ALL () { 0xffff; }") unless defined(&MFI_EVT_LOCALE_ALL);
eval("sub MR_EVT_ARGS_NONE () { 0x00; }") unless defined(&MR_EVT_ARGS_NONE);
eval("sub MR_EVT_ARGS_CDB_SENSE () { 1; }") unless defined(&MR_EVT_ARGS_CDB_SENSE);
eval("sub MR_EVT_ARGS_LD () { 2; }") unless defined(&MR_EVT_ARGS_LD);
eval("sub MR_EVT_ARGS_LD_COUNT () { 3; }") unless defined(&MR_EVT_ARGS_LD_COUNT);
eval("sub MR_EVT_ARGS_LD_LBA () { 4; }") unless defined(&MR_EVT_ARGS_LD_LBA);
eval("sub MR_EVT_ARGS_LD_OWNER () { 5; }") unless defined(&MR_EVT_ARGS_LD_OWNER);
eval("sub MR_EVT_ARGS_LD_LBA_PD_LBA () { 6; }") unless defined(&MR_EVT_ARGS_LD_LBA_PD_LBA);
eval("sub MR_EVT_ARGS_LD_PROG () { 7; }") unless defined(&MR_EVT_ARGS_LD_PROG);
eval("sub MR_EVT_ARGS_LD_STATE () { 8; }") unless defined(&MR_EVT_ARGS_LD_STATE);
eval("sub MR_EVT_ARGS_LD_STRIP () { 9; }") unless defined(&MR_EVT_ARGS_LD_STRIP);
eval("sub MR_EVT_ARGS_PD () { 10; }") unless defined(&MR_EVT_ARGS_PD);
eval("sub MR_EVT_ARGS_PD_ERR () { 11; }") unless defined(&MR_EVT_ARGS_PD_ERR);
eval("sub MR_EVT_ARGS_PD_LBA () { 12; }") unless defined(&MR_EVT_ARGS_PD_LBA);
eval("sub MR_EVT_ARGS_PD_LBA_LD () { 13; }") unless defined(&MR_EVT_ARGS_PD_LBA_LD);
eval("sub MR_EVT_ARGS_PD_PROG () { 14; }") unless defined(&MR_EVT_ARGS_PD_PROG);
eval("sub MR_EVT_ARGS_PD_STATE () { 15; }") unless defined(&MR_EVT_ARGS_PD_STATE);
eval("sub MR_EVT_ARGS_PCI () { 16; }") unless defined(&MR_EVT_ARGS_PCI);
eval("sub MR_EVT_ARGS_RATE () { 17; }") unless defined(&MR_EVT_ARGS_RATE);
eval("sub MR_EVT_ARGS_STR () { 18; }") unless defined(&MR_EVT_ARGS_STR);
eval("sub MR_EVT_ARGS_TIME () { 19; }") unless defined(&MR_EVT_ARGS_TIME);
eval("sub MR_EVT_ARGS_ECC () { 20; }") unless defined(&MR_EVT_ARGS_ECC);
unless(defined(&MFI_MAX_PD_CHANNELS)) {
    sub MFI_MAX_PD_CHANNELS () {	2;}
}
unless(defined(&MFI_MAX_PD_ARRAY)) {
    sub MFI_MAX_PD_ARRAY () {	32;}
}
unless(defined(&MFI_MAX_LD_CHANNELS)) {
    sub MFI_MAX_LD_CHANNELS () {	2;}
}
unless(defined(&MFI_MAX_CHANNELS)) {
    sub MFI_MAX_CHANNELS () {	( &MFI_MAX_PD_CHANNELS +  &MFI_MAX_LD_CHANNELS);}
}
unless(defined(&MFI_MAX_CHANNEL_DEVS)) {
    sub MFI_MAX_CHANNEL_DEVS () {	128;}
}
unless(defined(&MFI_DEFAULT_ID)) {
    sub MFI_DEFAULT_ID () {	-1;}
}
unless(defined(&MFI_MAX_LUN)) {
    sub MFI_MAX_LUN () {	8;}
}
unless(defined(&MFI_MAX_LD)) {
    sub MFI_MAX_LD () {	64;}
}
unless(defined(&MFI_MAX_SPAN)) {
    sub MFI_MAX_SPAN () {	8;}
}
unless(defined(&MFI_MAX_ARRAY_DEDICATED)) {
    sub MFI_MAX_ARRAY_DEDICATED () {	16;}
}
unless(defined(&MFI_MAX_PD)) {
    sub MFI_MAX_PD () {	256;}
}
unless(defined(&MFI_IO_FRAME_SIZE)) {
    sub MFI_IO_FRAME_SIZE () {	40;}
}
unless(defined(&MFI_PASS_FRAME_SIZE)) {
    sub MFI_PASS_FRAME_SIZE () {	48;}
}
unless(defined(&MFI_DCMD_FRAME_SIZE)) {
    sub MFI_DCMD_FRAME_SIZE () {	40;}
}
unless(defined(&MFI_INFO_HOST_PCIX)) {
    sub MFI_INFO_HOST_PCIX () {	0x1;}
}
unless(defined(&MFI_INFO_HOST_PCIE)) {
    sub MFI_INFO_HOST_PCIE () {	0x2;}
}
unless(defined(&MFI_INFO_HOST_ISCSI)) {
    sub MFI_INFO_HOST_ISCSI () {	0x4;}
}
unless(defined(&MFI_INFO_HOST_SAS3G)) {
    sub MFI_INFO_HOST_SAS3G () {	0x8;}
}
unless(defined(&MFI_INFO_DEV_SPI)) {
    sub MFI_INFO_DEV_SPI () {	0x1;}
}
unless(defined(&MFI_INFO_DEV_SAS3G)) {
    sub MFI_INFO_DEV_SAS3G () {	0x2;}
}
unless(defined(&MFI_INFO_DEV_SATA1)) {
    sub MFI_INFO_DEV_SATA1 () {	0x4;}
}
unless(defined(&MFI_INFO_DEV_SATA3G)) {
    sub MFI_INFO_DEV_SATA3G () {	0x8;}
}
unless(defined(&MFI_INFO_HW_BBU)) {
    sub MFI_INFO_HW_BBU () {	0x1;}
}
unless(defined(&MFI_INFO_HW_ALARM)) {
    sub MFI_INFO_HW_ALARM () {	0x2;}
}
unless(defined(&MFI_INFO_HW_NVRAM)) {
    sub MFI_INFO_HW_NVRAM () {	0x4;}
}
unless(defined(&MFI_INFO_HW_UART)) {
    sub MFI_INFO_HW_UART () {	0x8;}
}
unless(defined(&MFI_INFO_RAID_0)) {
    sub MFI_INFO_RAID_0 () {	0x1;}
}
unless(defined(&MFI_INFO_RAID_1)) {
    sub MFI_INFO_RAID_1 () {	0x2;}
}
unless(defined(&MFI_INFO_RAID_5)) {
    sub MFI_INFO_RAID_5 () {	0x4;}
}
unless(defined(&MFI_INFO_RAID_1E)) {
    sub MFI_INFO_RAID_1E () {	0x8;}
}
unless(defined(&MFI_INFO_RAID_6)) {
    sub MFI_INFO_RAID_6 () {	0x10;}
}
unless(defined(&MFI_INFO_AOPS_RBLD_RATE)) {
    sub MFI_INFO_AOPS_RBLD_RATE () {	0x1;}
}
unless(defined(&MFI_INFO_AOPS_CC_RATE)) {
    sub MFI_INFO_AOPS_CC_RATE () {	0x2;}
}
unless(defined(&MFI_INFO_AOPS_BGI_RATE)) {
    sub MFI_INFO_AOPS_BGI_RATE () {	0x4;}
}
unless(defined(&MFI_INFO_AOPS_RECON_RATE)) {
    sub MFI_INFO_AOPS_RECON_RATE () {	0x8;}
}
unless(defined(&MFI_INFO_AOPS_PATROL_RATE)) {
    sub MFI_INFO_AOPS_PATROL_RATE () {	0x10;}
}
unless(defined(&MFI_INFO_AOPS_ALARM_CONTROL)) {
    sub MFI_INFO_AOPS_ALARM_CONTROL () {	0x20;}
}
unless(defined(&MFI_INFO_AOPS_CLUSTER_SUPPORTED)) {
    sub MFI_INFO_AOPS_CLUSTER_SUPPORTED () {	0x40;}
}
unless(defined(&MFI_INFO_AOPS_BBU)) {
    sub MFI_INFO_AOPS_BBU () {	0x80;}
}
unless(defined(&MFI_INFO_AOPS_SPANNING_ALLOWED)) {
    sub MFI_INFO_AOPS_SPANNING_ALLOWED () {	0x100;}
}
unless(defined(&MFI_INFO_AOPS_DEDICATED_SPARES)) {
    sub MFI_INFO_AOPS_DEDICATED_SPARES () {	0x200;}
}
unless(defined(&MFI_INFO_AOPS_REVERTIBLE_SPARES)) {
    sub MFI_INFO_AOPS_REVERTIBLE_SPARES () {	0x400;}
}
unless(defined(&MFI_INFO_AOPS_FOREIGN_IMPORT)) {
    sub MFI_INFO_AOPS_FOREIGN_IMPORT () {	0x800;}
}
unless(defined(&MFI_INFO_AOPS_SELF_DIAGNOSTIC)) {
    sub MFI_INFO_AOPS_SELF_DIAGNOSTIC () {	0x1000;}
}
unless(defined(&MFI_INFO_AOPS_MIXED_ARRAY)) {
    sub MFI_INFO_AOPS_MIXED_ARRAY () {	0x2000;}
}
unless(defined(&MFI_INFO_AOPS_GLOBAL_SPARES)) {
    sub MFI_INFO_AOPS_GLOBAL_SPARES () {	0x4000;}
}
unless(defined(&MFI_INFO_LDOPS_READ_POLICY)) {
    sub MFI_INFO_LDOPS_READ_POLICY () {	0x1;}
}
unless(defined(&MFI_INFO_LDOPS_WRITE_POLICY)) {
    sub MFI_INFO_LDOPS_WRITE_POLICY () {	0x2;}
}
unless(defined(&MFI_INFO_LDOPS_IO_POLICY)) {
    sub MFI_INFO_LDOPS_IO_POLICY () {	0x4;}
}
unless(defined(&MFI_INFO_LDOPS_ACCESS_POLICY)) {
    sub MFI_INFO_LDOPS_ACCESS_POLICY () {	0x8;}
}
unless(defined(&MFI_INFO_LDOPS_DISK_CACHE_POLICY)) {
    sub MFI_INFO_LDOPS_DISK_CACHE_POLICY () {	0x10;}
}
unless(defined(&MFI_INFO_PDOPS_FORCE_ONLINE)) {
    sub MFI_INFO_PDOPS_FORCE_ONLINE () {	0x1;}
}
unless(defined(&MFI_INFO_PDOPS_FORCE_OFFLINE)) {
    sub MFI_INFO_PDOPS_FORCE_OFFLINE () {	0x2;}
}
unless(defined(&MFI_INFO_PDOPS_FORCE_REBUILD)) {
    sub MFI_INFO_PDOPS_FORCE_REBUILD () {	0x4;}
}
unless(defined(&MFI_INFO_PDMIX_SAS)) {
    sub MFI_INFO_PDMIX_SAS () {	0x1;}
}
unless(defined(&MFI_INFO_PDMIX_SATA)) {
    sub MFI_INFO_PDMIX_SATA () {	0x2;}
}
unless(defined(&MFI_INFO_PDMIX_ENCL)) {
    sub MFI_INFO_PDMIX_ENCL () {	0x4;}
}
unless(defined(&MFI_INFO_PDMIX_LD)) {
    sub MFI_INFO_PDMIX_LD () {	0x8;}
}
unless(defined(&MFI_INFO_PDMIX_SATA_CLUSTER)) {
    sub MFI_INFO_PDMIX_SATA_CLUSTER () {	0x10;}
}
unless(defined(&MFI_LD_OFFLINE)) {
    sub MFI_LD_OFFLINE () {	0x;}
}
unless(defined(&MFI_LD_PART_DEGRADED)) {
    sub MFI_LD_PART_DEGRADED () {	0x1;}
}
unless(defined(&MFI_LD_DEGRADED)) {
    sub MFI_LD_DEGRADED () {	0x2;}
}
unless(defined(&MFI_LD_ONLINE)) {
    sub MFI_LD_ONLINE () {	0x3;}
}
unless(defined(&MFI_DDF_PRL_RAID0)) {
    sub MFI_DDF_PRL_RAID0 () {	0x;}
}
unless(defined(&MFI_DDF_PRL_RAID1)) {
    sub MFI_DDF_PRL_RAID1 () {	0x1;}
}
unless(defined(&MFI_DDF_PRL_RAID3)) {
    sub MFI_DDF_PRL_RAID3 () {	0x3;}
}
unless(defined(&MFI_DDF_PRL_RAID4)) {
    sub MFI_DDF_PRL_RAID4 () {	0x4;}
}
unless(defined(&MFI_DDF_PRL_RAID5)) {
    sub MFI_DDF_PRL_RAID5 () {	0x5;}
}
unless(defined(&MFI_DDF_PRL_RAID1E)) {
    sub MFI_DDF_PRL_RAID1E () {	0x11;}
}
unless(defined(&MFI_DDF_PRL_JBOD)) {
    sub MFI_DDF_PRL_JBOD () {	0xf;}
}
unless(defined(&MFI_DDF_PRL_CONCAT)) {
    sub MFI_DDF_PRL_CONCAT () {	0x1f;}
}
unless(defined(&MFI_DDF_PRL_RAID5E)) {
    sub MFI_DDF_PRL_RAID5E () {	0x15;}
}
unless(defined(&MFI_DDF_PRL_RAID5EE)) {
    sub MFI_DDF_PRL_RAID5EE () {	0x25;}
}
unless(defined(&MFI_DDF_PRL_RAID6)) {
    sub MFI_DDF_PRL_RAID6 () {	0x16;}
}
unless(defined(&MFI_DDF_SRL_STRIPED)) {
    sub MFI_DDF_SRL_STRIPED () {	0x;}
}
unless(defined(&MFI_DDF_SRL_MIRRORED)) {
    sub MFI_DDF_SRL_MIRRORED () {	0x1;}
}
unless(defined(&MFI_DDF_SRL_CONCAT)) {
    sub MFI_DDF_SRL_CONCAT () {	0x2;}
}
unless(defined(&MFI_DDF_SRL_SPANNED)) {
    sub MFI_DDF_SRL_SPANNED () {	0x3;}
}
unless(defined(&MFI_LD_PROG_CC)) {
    sub MFI_LD_PROG_CC () {	0x1;}
}
unless(defined(&MFI_LD_PROG_BGI)) {
    sub MFI_LD_PROG_BGI () {	0x2;}
}
unless(defined(&MFI_LD_PROG_FGI)) {
    sub MFI_LD_PROG_FGI () {	0x4;}
}
unless(defined(&MFI_LD_PROG_RECONSTRUCT)) {
    sub MFI_LD_PROG_RECONSTRUCT () {	0x8;}
}
unless(defined(&MFI_PD_PROG_RBLD)) {
    sub MFI_PD_PROG_RBLD () {	0x1;}
}
unless(defined(&MFI_PD_PROG_PR)) {
    sub MFI_PD_PROG_PR () {	0x2;}
}
unless(defined(&MFI_PD_PROG_CLEAR)) {
    sub MFI_PD_PROG_CLEAR () {	0x4;}
}
unless(defined(&MFI_DDF_GUID_FORCED)) {
    sub MFI_DDF_GUID_FORCED () {	0x1;}
}
unless(defined(&MFI_DDF_PART_OF_VD)) {
    sub MFI_DDF_PART_OF_VD () {	0x2;}
}
unless(defined(&MFI_DDF_GLOB_HOTSPARE)) {
    sub MFI_DDF_GLOB_HOTSPARE () {	0x4;}
}
unless(defined(&MFI_DDF_HOTSPARE)) {
    sub MFI_DDF_HOTSPARE () {	0x8;}
}
unless(defined(&MFI_DDF_FOREIGN)) {
    sub MFI_DDF_FOREIGN () {	0x10;}
}
unless(defined(&MFI_DDF_TYPE_MASK)) {
    sub MFI_DDF_TYPE_MASK () {	0xf000;}
}
unless(defined(&MFI_DDF_TYPE_UNKNOWN)) {
    sub MFI_DDF_TYPE_UNKNOWN () {	0x;}
}
unless(defined(&MFI_DDF_TYPE_PAR_SCSI)) {
    sub MFI_DDF_TYPE_PAR_SCSI () {	0x1000;}
}
unless(defined(&MFI_DDF_TYPE_SAS)) {
    sub MFI_DDF_TYPE_SAS () {	0x2000;}
}
unless(defined(&MFI_DDF_TYPE_SATA)) {
    sub MFI_DDF_TYPE_SATA () {	0x3000;}
}
unless(defined(&MFI_DDF_TYPE_FC)) {
    sub MFI_DDF_TYPE_FC () {	0x4000;}
}
unless(defined(&MFI_PD_A_ONLINE)) {
    sub MFI_PD_A_ONLINE () {	(1<<0);}
}
unless(defined(&MFI_PD_A_OFFLINE)) {
    sub MFI_PD_A_OFFLINE () {	(1<<1);}
}
unless(defined(&MFI_PD_A_FAILED)) {
    sub MFI_PD_A_FAILED () {	(1<<2);}
}
unless(defined(&MFI_PD_A_BAD)) {
    sub MFI_PD_A_BAD () {	(1<<3);}
}
unless(defined(&MFI_PD_A_UNCONFIG)) {
    sub MFI_PD_A_UNCONFIG () {	(1<<4);}
}
unless(defined(&MFI_PD_A_HOTSPARE)) {
    sub MFI_PD_A_HOTSPARE () {	(1<<5);}
}
unless(defined(&MFI_PD_A_REMOVEHOTSPARE)) {
    sub MFI_PD_A_REMOVEHOTSPARE () {	(1<<6);}
}
unless(defined(&MFI_PD_A_REPLACEMISSING)) {
    sub MFI_PD_A_REPLACEMISSING () {	(1<<7);}
}
unless(defined(&MFI_PD_A_MARKMISSING)) {
    sub MFI_PD_A_MARKMISSING () {	(1<<8);}
}
unless(defined(&MFI_PD_A_STARTREBUILD)) {
    sub MFI_PD_A_STARTREBUILD () {	(1<<9);}
}
unless(defined(&MFI_PD_A_STOPREBUILD)) {
    sub MFI_PD_A_STOPREBUILD () {	(1<<10);}
}
unless(defined(&MFI_PD_A_BLINK)) {
    sub MFI_PD_A_BLINK () {	(1<<11);}
}
unless(defined(&MFI_PD_A_CLEAR)) {
    sub MFI_PD_A_CLEAR () {	(1<<12);}
}
unless(defined(&MFI_PD_A_FOREIGNIMPORNOTALLOWED)) {
    sub MFI_PD_A_FOREIGNIMPORNOTALLOWED () {	(1<<13);}
}
unless(defined(&MFI_PD_A_STARTCOPYBACK)) {
    sub MFI_PD_A_STARTCOPYBACK () {	(1<<14);}
}
unless(defined(&MFI_PD_A_STOPCOPYBACK)) {
    sub MFI_PD_A_STOPCOPYBACK () {	(1<<15);}
}
unless(defined(&MFI_PD_A_FWDOWNLOADDNOTALLOWED)) {
    sub MFI_PD_A_FWDOWNLOADDNOTALLOWED () {	(1<<16);}
}
unless(defined(&MFI_PD_A_REPROVISION)) {
    sub MFI_PD_A_REPROVISION () {	(1<<17);}
}
unless(defined(&MFI_PD_FDE_CAPABLE)) {
    sub MFI_PD_FDE_CAPABLE () {	(1<<0);}
}
unless(defined(&MFI_PD_FDE_ENABLED)) {
    sub MFI_PD_FDE_ENABLED () {	(1<<1);}
}
unless(defined(&MFI_PD_FDE_SECURED)) {
    sub MFI_PD_FDE_SECURED () {	(1<<2);}
}
unless(defined(&MFI_PD_FDE_LOCKED)) {
    sub MFI_PD_FDE_LOCKED () {	(1<<3);}
}
unless(defined(&MFI_PD_FDE_FOREIGNLOCK)) {
    sub MFI_PD_FDE_FOREIGNLOCK () {	(1<<4);}
}
unless(defined(&MFI_PD_UNCONFIG_GOOD)) {
    sub MFI_PD_UNCONFIG_GOOD () {	0x;}
}
unless(defined(&MFI_PD_UNCONFIG_BAD)) {
    sub MFI_PD_UNCONFIG_BAD () {	0x1;}
}
unless(defined(&MFI_PD_HOTSPARE)) {
    sub MFI_PD_HOTSPARE () {	0x2;}
}
unless(defined(&MFI_PD_OFFLINE)) {
    sub MFI_PD_OFFLINE () {	0x10;}
}
unless(defined(&MFI_PD_FAILED)) {
    sub MFI_PD_FAILED () {	0x11;}
}
unless(defined(&MFI_PD_REBUILD)) {
    sub MFI_PD_REBUILD () {	0x14;}
}
unless(defined(&MFI_PD_ONLINE)) {
    sub MFI_PD_ONLINE () {	0x18;}
}
unless(defined(&MFI_PD_COPYBACK)) {
    sub MFI_PD_COPYBACK () {	0x20;}
}
unless(defined(&MFI_PD_SYSTEM)) {
    sub MFI_PD_SYSTEM () {	0x40;}
}
unless(defined(&MFI_PD_HS_DEDICATED)) {
    sub MFI_PD_HS_DEDICATED () {	0x1;}
}
unless(defined(&MFI_PD_HS_REVERTIBLE)) {
    sub MFI_PD_HS_REVERTIBLE () {	0x2;}
}
unless(defined(&MFI_PD_HS_ENC_AFFINITY)) {
    sub MFI_PD_HS_ENC_AFFINITY () {	0x4;}
}
1;
