/*	$OpenBSD: s_logbl.S,v 1.1 2011/05/28 22:13:52 martynas Exp $ */
/*-
 * Copyright (c) 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * the Systems Programming Group of the University of Utah Computer
 * Science Department.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <machine/asm.h>

| logbl(x)
| returns the unbiased exponent of x, a signed integer in double precision,
| except that logbl(0) is -INF, logbl(INF) is +INF, and logbl(NAN) is that NAN.
.lcomm	_ASM_LABEL(__rv),12
ENTRY(logbl)
	movw	sp@(4),d0
	movw	#0x7FFF,d1	| exponent bits
	andw	d1,d0		| mask off all else
	cmpw	d1,d0		| max exponent?
	bne	Lfinite		| no, is finite
	fmovex	sp@(4),fp0	| yes, infinite or NaN
	fbun	Ldone		| NaN returns NaN
	fabsx	fp0		| +-inf returns inf
	jra	Ldone
Lfinite:
	fmovex	sp@(4),fp0	| get entire number
	fbne	Lnonz		| zero?
	flog2x	fp0		| yes, log(0) a convenient source of -inf
	jra	Ldone
Lnonz:
	fgetexpx	fp0	| get exponent
Ldone:
	fmovex	fp0,_ASM_LABEL(__rv)
	movel	#_ASM_LABEL(__rv),d0
	rts
