require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE_CPUFUNC_H_)) {
    eval 'sub _MACHINE_CPUFUNC_H_ () {1;}' unless defined(&_MACHINE_CPUFUNC_H_);
    require 'sys/cdefs.ph';
    require 'sys/types.ph';
    require 'machine/specialreg.ph';
    eval 'sub invlpg {
        my($addr) = @_;
	    eval q({  &__asm  &__volatile(\\"invlpg (%0)\\" : : \\"r\\" ($addr) : \\"memory\\"); } );
    }' unless defined(&invlpg);
    eval 'sub lidt {
        my($p) = @_;
	    eval q({  &__asm  &__volatile(\\"lidt (%0)\\" : : \\"r\\" ($p) : \\"memory\\"); });
    }' unless defined(&lidt);
    eval 'sub lldt {
        my($sel) = @_;
	    eval q({  &__asm  &__volatile(\\"lldt %0\\" : : \\"r\\" ($sel)); });
    }' unless defined(&lldt);
    eval 'sub ltr {
        my($sel) = @_;
	    eval q({  &__asm  &__volatile(\\"ltr %0\\" : : \\"r\\" ($sel)); });
    }' unless defined(&ltr);
    eval 'sub lcr8 {
        my($val) = @_;
	    eval q({  &u_int64_t  &val64 = $val;  &__asm  &__volatile(\\"movq %0,%%cr8\\" : : \\"r\\" ( &val64)); });
    }' unless defined(&lcr8);
    eval 'sub rcr0 {
        my($void) = @_;
	    eval q({  &u_int64_t  &val64; \'u_int\'  &val;  &__asm  &__volatile(\\"movq %%cr0,%0\\" : \\"=r\\" ( &val64));  &val =  &val64;  &val; });
    }' unless defined(&rcr0);
    eval 'sub rcr2 {
        my($void) = @_;
	    eval q({  &u_int64_t  &val;  &__asm  &__volatile(\\"movq %%cr2,%0\\" : \\"=r\\" ( &val));  &val; });
    }' unless defined(&rcr2);
    eval 'sub lcr3 {
        my($val) = @_;
	    eval q({  &__asm  &__volatile(\\"movq %0,%%cr3\\" : : \\"r\\" ($val)); });
    }' unless defined(&lcr3);
    eval 'sub rcr3 {
        my($void) = @_;
	    eval q({  &u_int64_t  &val;  &__asm  &__volatile(\\"movq %%cr3,%0\\" : \\"=r\\" ( &val));  &val; });
    }' unless defined(&rcr3);
    eval 'sub rcr4 {
        my($void) = @_;
	    eval q({ \'u_int\'  &val;  &u_int64_t  &val64;  &__asm  &__volatile(\\"movq %%cr4,%0\\" : \\"=r\\" ( &val64));  &val =  &val64;  &val; });
    }' unless defined(&rcr4);
    eval 'sub tlbflush {
        my($void) = @_;
	    eval q({  &u_int64_t  &val;  &__asm  &__volatile(\\"movq %%cr3,%0\\" : \\"=r\\" ( &val));  &__asm  &__volatile(\\"movq %0,%%cr3\\" : : \\"r\\" ( &val)); });
    }' unless defined(&tlbflush);
    eval 'sub tlbflushg {
        my($void) = @_;
	    eval q({  &if ( &cpu_feature &  &CPUID_PGE) { \'u_int\'  &cr4 =  &rcr4();  &lcr4( &cr4 & ~ &CR4_PGE);  &lcr4( &cr4); }  &else  &tlbflush(); });
    }' unless defined(&tlbflushg);
    if(defined(&notyet)) {
    }
    eval 'sub enable_intr {
        my($void) = @_;
	    eval q({  &__asm  &__volatile(\\"sti\\"); });
    }' unless defined(&enable_intr);
    eval 'sub read_rflags {
        my($void) = @_;
	    eval q({ my $ef;  &__asm  &__volatile(\\"pushfq; popq %0\\" : \\"=r\\" ( $ef)); ( $ef); });
    }' unless defined(&read_rflags);
    eval 'sub write_rflags {
        my($ef) = @_;
	    eval q({  &__asm  &__volatile(\\"pushq %0; popfq\\" : : \\"r\\" ($ef)); });
    }' unless defined(&write_rflags);
    eval 'sub rdmsr {
        my($msr) = @_;
	    eval q({  &uint32_t  &hi,  &lo;  &__asm  &__volatile(\\"rdmsr\\" : \\"=d\\" ( &hi), \\"=a\\" ( &lo) : \\"c\\" ($msr)); ((( &uint64_t) &hi << 32) | ( &uint64_t)  &lo); });
    }' unless defined(&rdmsr);
    eval 'sub wrmsr {
        my($msr,$newval) = @_;
	    eval q({  &__asm  &__volatile(\\"wrmsr\\" : : \\"a\\" ($newval & 0xffffffff), \\"d\\" ($newval >> 32), \\"c\\" ($msr)); });
    }' unless defined(&wrmsr);
    eval 'sub OPTERON_MSR_PASSCODE () {0x9c5a203a;}' unless defined(&OPTERON_MSR_PASSCODE);
    eval 'sub wrmsr_locked {
        my($msr,$code,$newval) = @_;
	    eval q({  &__asm  &__volatile(\\"wrmsr\\" : : \\"a\\" ($newval & 0xffffffff), \\"d\\" ($newval >> 32), \\"c\\" ($msr), \\"D\\" ($code)); });
    }' unless defined(&wrmsr_locked);
    eval 'sub wbinvd {
        my($void) = @_;
	    eval q({  &__asm  &__volatile(\\"wbinvd\\"); });
    }' unless defined(&wbinvd);
    eval 'sub clflush {
        my($addr) = @_;
	    eval q({  &__asm  &__volatile(\\"clflush %0\\" : \\"+m\\" ($addr)); });
    }' unless defined(&clflush);
    eval 'sub mfence {
        my($void) = @_;
	    eval q({  &__asm  &__volatile(\\"mfence\\" : : : \\"memory\\"); });
    }' unless defined(&mfence);
    eval 'sub rdtsc {
        my($void) = @_;
	    eval q({  &uint32_t  &hi,  &lo;  &__asm  &__volatile(\\"rdtsc\\" : \\"=d\\" ( &hi), \\"=a\\" ( &lo)); ((( &uint64_t) &hi << 32) | ( &uint64_t)  &lo); });
    }' unless defined(&rdtsc);
    eval 'sub rdpmc {
        my($pmc) = @_;
	    eval q({  &uint32_t  &hi,  &lo;  &__asm  &__volatile(\\"rdpmc\\" : \\"=d\\" ( &hi), \\"=a\\" ( &lo) : \\"c\\" ($pmc)); ((( &uint64_t) &hi << 32) | ( &uint64_t)  &lo); });
    }' unless defined(&rdpmc);
    eval 'sub read_psl () {
        eval q( &read_rflags());
    }' unless defined(&read_psl);
    eval 'sub write_psl {
        my($x) = @_;
	    eval q( &write_rflags($x));
    }' unless defined(&write_psl);
}
    }
1;
