require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&BGE_PAGE_ZERO)) {
    sub BGE_PAGE_ZERO () {	0x;}
}
unless(defined(&BGE_PAGE_ZERO_END)) {
    sub BGE_PAGE_ZERO_END () {	0xff;}
}
unless(defined(&BGE_SEND_RING_RCB)) {
    sub BGE_SEND_RING_RCB () {	0x100;}
}
unless(defined(&BGE_SEND_RING_RCB_END)) {
    sub BGE_SEND_RING_RCB_END () {	0x1ff;}
}
unless(defined(&BGE_RX_RETURN_RING_RCB)) {
    sub BGE_RX_RETURN_RING_RCB () {	0x200;}
}
unless(defined(&BGE_RX_RETURN_RING_RCB_END)) {
    sub BGE_RX_RETURN_RING_RCB_END () {	0x2ff;}
}
unless(defined(&BGE_STATS_BLOCK)) {
    sub BGE_STATS_BLOCK () {	0x300;}
}
unless(defined(&BGE_STATS_BLOCK_END)) {
    sub BGE_STATS_BLOCK_END () {	0xaff;}
}
unless(defined(&BGE_STATUS_BLOCK)) {
    sub BGE_STATUS_BLOCK () {	0xb00;}
}
unless(defined(&BGE_STATUS_BLOCK_END)) {
    sub BGE_STATUS_BLOCK_END () {	0xb4f;}
}
unless(defined(&BGE_SOFTWARE_GENCOMM)) {
    sub BGE_SOFTWARE_GENCOMM () {	0xb50;}
}
unless(defined(&BGE_SOFTWARE_GENCOMM_SIG)) {
    sub BGE_SOFTWARE_GENCOMM_SIG () {	0xb54;}
}
unless(defined(&BGE_SOFTWARE_GENCOMM_NICCFG)) {
    sub BGE_SOFTWARE_GENCOMM_NICCFG () {	0xb58;}
}
unless(defined(&BGE_SOFTWARE_GENCOMM_VER)) {
    sub BGE_SOFTWARE_GENCOMM_VER () {	0xb5c;}
}
unless(defined(&BGE_VER_SHIFT)) {
    sub BGE_VER_SHIFT () {	16;}
}
unless(defined(&BGE_SOFTWARE_GENCOMM_FW)) {
    sub BGE_SOFTWARE_GENCOMM_FW () {	0xb78;}
}
unless(defined(&BGE_FW_PAUSE)) {
    sub BGE_FW_PAUSE () {	0x2;}
}
unless(defined(&BGE_SOFTWARE_GENCOMM_NICCFG2)) {
    sub BGE_SOFTWARE_GENCOMM_NICCFG2 () {	0xd38;}
}
unless(defined(&BGE_SOFTWARE_GENCOMM_NICCFG3)) {
    sub BGE_SOFTWARE_GENCOMM_NICCFG3 () {	0xd3c;}
}
unless(defined(&BGE_SOFTWARE_GENCOMM_NICCFG4)) {
    sub BGE_SOFTWARE_GENCOMM_NICCFG4 () {	0xd60;}
}
unless(defined(&BGE_NICCFG4_GMII_MODE)) {
    sub BGE_NICCFG4_GMII_MODE () {	0x2;}
}
unless(defined(&BGE_NICCFG4_RGMII_STD_IBND_DISABLE)) {
    sub BGE_NICCFG4_RGMII_STD_IBND_DISABLE () {	0x4;}
}
unless(defined(&BGE_NICCFG4_RGMII_EXT_IBND_RX_EN)) {
    sub BGE_NICCFG4_RGMII_EXT_IBND_RX_EN () {	0x8;}
}
unless(defined(&BGE_NICCFG4_RGMII_EXT_IBND_TX_EN)) {
    sub BGE_NICCFG4_RGMII_EXT_IBND_TX_EN () {	0x10;}
}
unless(defined(&BGE_SOFTWARE_GENCOMM_END)) {
    sub BGE_SOFTWARE_GENCOMM_END () {	0xfff;}
}
unless(defined(&BGE_UNMAPPED)) {
    sub BGE_UNMAPPED () {	0x1000;}
}
unless(defined(&BGE_UNMAPPED_END)) {
    sub BGE_UNMAPPED_END () {	0x1fff;}
}
unless(defined(&BGE_DMA_DESCRIPTORS)) {
    sub BGE_DMA_DESCRIPTORS () {	0x2000;}
}
unless(defined(&BGE_DMA_DESCRIPTORS_END)) {
    sub BGE_DMA_DESCRIPTORS_END () {	0x3fff;}
}
unless(defined(&BGE_SEND_RING_1_TO_4)) {
    sub BGE_SEND_RING_1_TO_4 () {	0x4000;}
}
unless(defined(&BGE_SEND_RING_1_TO_4_END)) {
    sub BGE_SEND_RING_1_TO_4_END () {	0x5fff;}
}
unless(defined(&BGE_STD_RX_RINGS)) {
    sub BGE_STD_RX_RINGS () {	0x6000;}
}
unless(defined(&BGE_STD_RX_RINGS_END)) {
    sub BGE_STD_RX_RINGS_END () {	0x6fff;}
}
unless(defined(&BGE_JUMBO_RX_RINGS)) {
    sub BGE_JUMBO_RX_RINGS () {	0x7000;}
}
unless(defined(&BGE_JUMBO_RX_RINGS_END)) {
    sub BGE_JUMBO_RX_RINGS_END () {	0x7fff;}
}
unless(defined(&BGE_BUFFPOOL_1)) {
    sub BGE_BUFFPOOL_1 () {	0x8000;}
}
unless(defined(&BGE_BUFFPOOL_1_END)) {
    sub BGE_BUFFPOOL_1_END () {	0xffff;}
}
unless(defined(&BGE_BUFFPOOL_2)) {
    sub BGE_BUFFPOOL_2 () {	0x10000;}
}
unless(defined(&BGE_BUFFPOOL_2_END)) {
    sub BGE_BUFFPOOL_2_END () {	0x17fff;}
}
unless(defined(&BGE_BUFFPOOL_3)) {
    sub BGE_BUFFPOOL_3 () {	0x18000;}
}
unless(defined(&BGE_BUFFPOOL_3_END)) {
    sub BGE_BUFFPOOL_3_END () {	0x1ffff;}
}
unless(defined(&BGE_SEND_RING_5_TO_6)) {
    sub BGE_SEND_RING_5_TO_6 () {	0x6000;}
}
unless(defined(&BGE_SEND_RING_5_TO_6_END)) {
    sub BGE_SEND_RING_5_TO_6_END () {	0x6fff;}
}
unless(defined(&BGE_SEND_RING_7_TO_8)) {
    sub BGE_SEND_RING_7_TO_8 () {	0x7000;}
}
unless(defined(&BGE_SEND_RING_7_TO_8_END)) {
    sub BGE_SEND_RING_7_TO_8_END () {	0x7fff;}
}
unless(defined(&BGE_SEND_RING_9_TO_16)) {
    sub BGE_SEND_RING_9_TO_16 () {	0x8000;}
}
unless(defined(&BGE_SEND_RING_9_TO_16_END)) {
    sub BGE_SEND_RING_9_TO_16_END () {	0xbfff;}
}
unless(defined(&BGE_EXT_STD_RX_RINGS)) {
    sub BGE_EXT_STD_RX_RINGS () {	0xc000;}
}
unless(defined(&BGE_EXT_STD_RX_RINGS_END)) {
    sub BGE_EXT_STD_RX_RINGS_END () {	0xcfff;}
}
unless(defined(&BGE_EXT_JUMBO_RX_RINGS)) {
    sub BGE_EXT_JUMBO_RX_RINGS () {	0xd000;}
}
unless(defined(&BGE_EXT_JUMBO_RX_RINGS_END)) {
    sub BGE_EXT_JUMBO_RX_RINGS_END () {	0xdfff;}
}
unless(defined(&BGE_MINI_RX_RINGS)) {
    sub BGE_MINI_RX_RINGS () {	0xe000;}
}
unless(defined(&BGE_MINI_RX_RINGS_END)) {
    sub BGE_MINI_RX_RINGS_END () {	0xffff;}
}
unless(defined(&BGE_AVAIL_REGION1)) {
    sub BGE_AVAIL_REGION1 () {	0x10000;}
}
unless(defined(&BGE_AVAIL_REGION1_END)) {
    sub BGE_AVAIL_REGION1_END () {	0x17fff;}
}
unless(defined(&BGE_AVAIL_REGION2)) {
    sub BGE_AVAIL_REGION2 () {	0x18000;}
}
unless(defined(&BGE_AVAIL_REGION2_END)) {
    sub BGE_AVAIL_REGION2_END () {	0x1ffff;}
}
unless(defined(&BGE_EXT_SSRAM)) {
    sub BGE_EXT_SSRAM () {	0x20000;}
}
unless(defined(&BGE_EXT_SSRAM_END)) {
    sub BGE_EXT_SSRAM_END () {	0xfffff;}
}
unless(defined(&BGE_PCI_VID)) {
    sub BGE_PCI_VID () {	0x;}
}
unless(defined(&BGE_PCI_DID)) {
    sub BGE_PCI_DID () {	0x2;}
}
unless(defined(&BGE_PCI_CMD)) {
    sub BGE_PCI_CMD () {	0x4;}
}
unless(defined(&BGE_PCI_STS)) {
    sub BGE_PCI_STS () {	0x6;}
}
unless(defined(&BGE_PCI_REV)) {
    sub BGE_PCI_REV () {	0x8;}
}
unless(defined(&BGE_PCI_CLASS)) {
    sub BGE_PCI_CLASS () {	0x9;}
}
unless(defined(&BGE_PCI_CACHESZ)) {
    sub BGE_PCI_CACHESZ () {	0xc;}
}
unless(defined(&BGE_PCI_LATTIMER)) {
    sub BGE_PCI_LATTIMER () {	0xd;}
}
unless(defined(&BGE_PCI_HDRTYPE)) {
    sub BGE_PCI_HDRTYPE () {	0xe;}
}
unless(defined(&BGE_PCI_BIST)) {
    sub BGE_PCI_BIST () {	0xf;}
}
unless(defined(&BGE_PCI_BAR0)) {
    sub BGE_PCI_BAR0 () {	0x10;}
}
unless(defined(&BGE_PCI_BAR1)) {
    sub BGE_PCI_BAR1 () {	0x14;}
}
unless(defined(&BGE_PCI_SUBSYS)) {
    sub BGE_PCI_SUBSYS () {	0x2c;}
}
unless(defined(&BGE_PCI_SUBVID)) {
    sub BGE_PCI_SUBVID () {	0x2e;}
}
unless(defined(&BGE_PCI_ROMBASE)) {
    sub BGE_PCI_ROMBASE () {	0x30;}
}
unless(defined(&BGE_PCI_CAPPTR)) {
    sub BGE_PCI_CAPPTR () {	0x34;}
}
unless(defined(&BGE_PCI_INTLINE)) {
    sub BGE_PCI_INTLINE () {	0x3c;}
}
unless(defined(&BGE_PCI_INTPIN)) {
    sub BGE_PCI_INTPIN () {	0x3d;}
}
unless(defined(&BGE_PCI_MINGNT)) {
    sub BGE_PCI_MINGNT () {	0x3e;}
}
unless(defined(&BGE_PCI_MAXLAT)) {
    sub BGE_PCI_MAXLAT () {	0x3f;}
}
unless(defined(&BGE_PCI_PCIXCAP)) {
    sub BGE_PCI_PCIXCAP () {	0x40;}
}
unless(defined(&BGE_PCI_NEXTPTR_PM)) {
    sub BGE_PCI_NEXTPTR_PM () {	0x41;}
}
unless(defined(&BGE_PCI_PCIX_CMD)) {
    sub BGE_PCI_PCIX_CMD () {	0x42;}
}
unless(defined(&BGE_PCI_PCIX_STS)) {
    sub BGE_PCI_PCIX_STS () {	0x44;}
}
unless(defined(&BGE_PCI_PWRMGMT_CAPID)) {
    sub BGE_PCI_PWRMGMT_CAPID () {	0x48;}
}
unless(defined(&BGE_PCI_NEXTPTR_VPD)) {
    sub BGE_PCI_NEXTPTR_VPD () {	0x49;}
}
unless(defined(&BGE_PCI_PWRMGMT_CAPS)) {
    sub BGE_PCI_PWRMGMT_CAPS () {	0x4a;}
}
unless(defined(&BGE_PCI_PWRMGMT_CMD)) {
    sub BGE_PCI_PWRMGMT_CMD () {	0x4c;}
}
unless(defined(&BGE_PCI_PWRMGMT_STS)) {
    sub BGE_PCI_PWRMGMT_STS () {	0x4d;}
}
unless(defined(&BGE_PCI_PWRMGMT_DATA)) {
    sub BGE_PCI_PWRMGMT_DATA () {	0x4f;}
}
unless(defined(&BGE_PCI_VPD_CAPID)) {
    sub BGE_PCI_VPD_CAPID () {	0x50;}
}
unless(defined(&BGE_PCI_NEXTPTR_MSI)) {
    sub BGE_PCI_NEXTPTR_MSI () {	0x51;}
}
unless(defined(&BGE_PCI_VPD_ADDR)) {
    sub BGE_PCI_VPD_ADDR () {	0x52;}
}
unless(defined(&BGE_PCI_VPD_DATA)) {
    sub BGE_PCI_VPD_DATA () {	0x54;}
}
unless(defined(&BGE_PCI_MSI_CAPID)) {
    sub BGE_PCI_MSI_CAPID () {	0x58;}
}
unless(defined(&BGE_PCI_NEXTPTR_NONE)) {
    sub BGE_PCI_NEXTPTR_NONE () {	0x59;}
}
unless(defined(&BGE_PCI_MSI_CTL)) {
    sub BGE_PCI_MSI_CTL () {	0x5a;}
}
unless(defined(&BGE_PCI_MSI_ADDR_HI)) {
    sub BGE_PCI_MSI_ADDR_HI () {	0x5c;}
}
unless(defined(&BGE_PCI_MSI_ADDR_LO)) {
    sub BGE_PCI_MSI_ADDR_LO () {	0x60;}
}
unless(defined(&BGE_PCI_MSI_DATA)) {
    sub BGE_PCI_MSI_DATA () {	0x64;}
}
unless(defined(&BGE_PCIE_CAPID_REG)) {
    sub BGE_PCIE_CAPID_REG () {	0xd0;}
}
unless(defined(&BGE_PCIE_CAPID)) {
    sub BGE_PCIE_CAPID () {	0x10;}
}
unless(defined(&BGE_PCI_MISC_CTL)) {
    sub BGE_PCI_MISC_CTL () {	0x68;}
}
unless(defined(&BGE_PCI_DMA_RW_CTL)) {
    sub BGE_PCI_DMA_RW_CTL () {	0x6c;}
}
unless(defined(&BGE_PCI_PCISTATE)) {
    sub BGE_PCI_PCISTATE () {	0x70;}
}
unless(defined(&BGE_PCI_CLKCTL)) {
    sub BGE_PCI_CLKCTL () {	0x74;}
}
unless(defined(&BGE_PCI_REG_BASEADDR)) {
    sub BGE_PCI_REG_BASEADDR () {	0x78;}
}
unless(defined(&BGE_PCI_MEMWIN_BASEADDR)) {
    sub BGE_PCI_MEMWIN_BASEADDR () {	0x7c;}
}
unless(defined(&BGE_PCI_REG_DATA)) {
    sub BGE_PCI_REG_DATA () {	0x80;}
}
unless(defined(&BGE_PCI_MEMWIN_DATA)) {
    sub BGE_PCI_MEMWIN_DATA () {	0x84;}
}
unless(defined(&BGE_PCI_MODECTL)) {
    sub BGE_PCI_MODECTL () {	0x88;}
}
unless(defined(&BGE_PCI_MISC_CFG)) {
    sub BGE_PCI_MISC_CFG () {	0x8c;}
}
unless(defined(&BGE_PCI_MISC_LOCALCTL)) {
    sub BGE_PCI_MISC_LOCALCTL () {	0x90;}
}
unless(defined(&BGE_PCI_UNDI_RX_STD_PRODIDX_HI)) {
    sub BGE_PCI_UNDI_RX_STD_PRODIDX_HI () {	0x98;}
}
unless(defined(&BGE_PCI_UNDI_RX_STD_PRODIDX_LO)) {
    sub BGE_PCI_UNDI_RX_STD_PRODIDX_LO () {	0x9c;}
}
unless(defined(&BGE_PCI_UNDI_RX_RTN_CONSIDX_HI)) {
    sub BGE_PCI_UNDI_RX_RTN_CONSIDX_HI () {	0xa0;}
}
unless(defined(&BGE_PCI_UNDI_RX_RTN_CONSIDX_LO)) {
    sub BGE_PCI_UNDI_RX_RTN_CONSIDX_LO () {	0xa4;}
}
unless(defined(&BGE_PCI_UNDI_TX_BD_PRODIDX_HI)) {
    sub BGE_PCI_UNDI_TX_BD_PRODIDX_HI () {	0xa8;}
}
unless(defined(&BGE_PCI_UNDI_TX_BD_PRODIDX_LO)) {
    sub BGE_PCI_UNDI_TX_BD_PRODIDX_LO () {	0xac;}
}
unless(defined(&BGE_PCI_ISR_MBX_HI)) {
    sub BGE_PCI_ISR_MBX_HI () {	0xb0;}
}
unless(defined(&BGE_PCI_ISR_MBX_LO)) {
    sub BGE_PCI_ISR_MBX_LO () {	0xb4;}
}
unless(defined(&BGE_PCI_PRODID_ASICREV)) {
    sub BGE_PCI_PRODID_ASICREV () {	0xbc;}
}
unless(defined(&BGE_PCI_GEN2_PRODID_ASICREV)) {
    sub BGE_PCI_GEN2_PRODID_ASICREV () {	0xf4;}
}
unless(defined(&BGE_PCI_GEN15_PRODID_ASICREV)) {
    sub BGE_PCI_GEN15_PRODID_ASICREV () {	0xfc;}
}
unless(defined(&BGE_PCI_CONF_DEV_CTRL)) {
    sub BGE_PCI_CONF_DEV_CTRL () {	0xd8;}
}
unless(defined(&BGE_PCI_CONF_DEV_STUS)) {
    sub BGE_PCI_CONF_DEV_STUS () {	0xda;}
}
unless(defined(&BGE_PCIMISCCTL_CLEAR_INTA)) {
    sub BGE_PCIMISCCTL_CLEAR_INTA () {	0x1;}
}
unless(defined(&BGE_PCIMISCCTL_MASK_PCI_INTR)) {
    sub BGE_PCIMISCCTL_MASK_PCI_INTR () {	0x2;}
}
unless(defined(&BGE_PCIMISCCTL_ENDIAN_BYTESWAP)) {
    sub BGE_PCIMISCCTL_ENDIAN_BYTESWAP () {	0x4;}
}
unless(defined(&BGE_PCIMISCCTL_ENDIAN_WORDSWAP)) {
    sub BGE_PCIMISCCTL_ENDIAN_WORDSWAP () {	0x8;}
}
unless(defined(&BGE_PCIMISCCTL_PCISTATE_RW)) {
    sub BGE_PCIMISCCTL_PCISTATE_RW () {	0x10;}
}
unless(defined(&BGE_PCIMISCCTL_CLOCKCTL_RW)) {
    sub BGE_PCIMISCCTL_CLOCKCTL_RW () {	0x20;}
}
unless(defined(&BGE_PCIMISCCTL_REG_WORDSWAP)) {
    sub BGE_PCIMISCCTL_REG_WORDSWAP () {	0x40;}
}
unless(defined(&BGE_PCIMISCCTL_INDIRECT_ACCESS)) {
    sub BGE_PCIMISCCTL_INDIRECT_ACCESS () {	0x80;}
}
unless(defined(&BGE_PCIMISCCTL_ASICREV)) {
    sub BGE_PCIMISCCTL_ASICREV () {	0xffff0000;}
}
unless(defined(&BGE_PCIMISCCTL_ASICREV_SHIFT)) {
    sub BGE_PCIMISCCTL_ASICREV_SHIFT () {	16;}
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : undef)) {
    eval 'sub BGE_DMA_SWAP_OPTIONS () { &BGE_MODECTL_WORDSWAP_NONFRAME|  &BGE_MODECTL_BYTESWAP_DATA| &BGE_MODECTL_WORDSWAP_DATA;}' unless defined(&BGE_DMA_SWAP_OPTIONS);
} else {
    eval 'sub BGE_DMA_SWAP_OPTIONS () { &BGE_MODECTL_WORDSWAP_NONFRAME| &BGE_MODECTL_BYTESWAP_NONFRAME|  &BGE_MODECTL_BYTESWAP_DATA| &BGE_MODECTL_WORDSWAP_DATA;}' unless defined(&BGE_DMA_SWAP_OPTIONS);
}
unless(defined(&BGE_INIT)) {
    sub BGE_INIT () {	( &BGE_PCIMISCCTL_ENDIAN_WORDSWAP| &BGE_PCIMISCCTL_CLEAR_INTA|  &BGE_PCIMISCCTL_MASK_PCI_INTR| &BGE_PCIMISCCTL_INDIRECT_ACCESS);}
}
unless(defined(&BGE_CHIPID_BCM5700_A0)) {
    sub BGE_CHIPID_BCM5700_A0 () {	0x7000;}
}
unless(defined(&BGE_CHIPID_BCM5700_A1)) {
    sub BGE_CHIPID_BCM5700_A1 () {	0x7001;}
}
unless(defined(&BGE_CHIPID_BCM5700_B0)) {
    sub BGE_CHIPID_BCM5700_B0 () {	0x7100;}
}
unless(defined(&BGE_CHIPID_BCM5700_B1)) {
    sub BGE_CHIPID_BCM5700_B1 () {	0x7101;}
}
unless(defined(&BGE_CHIPID_BCM5700_B2)) {
    sub BGE_CHIPID_BCM5700_B2 () {	0x7102;}
}
unless(defined(&BGE_CHIPID_BCM5700_B3)) {
    sub BGE_CHIPID_BCM5700_B3 () {	0x7103;}
}
unless(defined(&BGE_CHIPID_BCM5700_ALTIMA)) {
    sub BGE_CHIPID_BCM5700_ALTIMA () {	0x7104;}
}
unless(defined(&BGE_CHIPID_BCM5700_C0)) {
    sub BGE_CHIPID_BCM5700_C0 () {	0x7200;}
}
unless(defined(&BGE_CHIPID_BCM5701_A0)) {
    sub BGE_CHIPID_BCM5701_A0 () {	0x;}
}
unless(defined(&BGE_CHIPID_BCM5701_B0)) {
    sub BGE_CHIPID_BCM5701_B0 () {	0x100;}
}
unless(defined(&BGE_CHIPID_BCM5701_B2)) {
    sub BGE_CHIPID_BCM5701_B2 () {	0x102;}
}
unless(defined(&BGE_CHIPID_BCM5701_B5)) {
    sub BGE_CHIPID_BCM5701_B5 () {	0x105;}
}
unless(defined(&BGE_CHIPID_BCM5703_A0)) {
    sub BGE_CHIPID_BCM5703_A0 () {	0x1000;}
}
unless(defined(&BGE_CHIPID_BCM5703_A1)) {
    sub BGE_CHIPID_BCM5703_A1 () {	0x1001;}
}
unless(defined(&BGE_CHIPID_BCM5703_A2)) {
    sub BGE_CHIPID_BCM5703_A2 () {	0x1002;}
}
unless(defined(&BGE_CHIPID_BCM5703_A3)) {
    sub BGE_CHIPID_BCM5703_A3 () {	0x1003;}
}
unless(defined(&BGE_CHIPID_BCM5703_B0)) {
    sub BGE_CHIPID_BCM5703_B0 () {	0x1100;}
}
unless(defined(&BGE_CHIPID_BCM5704_A0)) {
    sub BGE_CHIPID_BCM5704_A0 () {	0x2000;}
}
unless(defined(&BGE_CHIPID_BCM5704_A1)) {
    sub BGE_CHIPID_BCM5704_A1 () {	0x2001;}
}
unless(defined(&BGE_CHIPID_BCM5704_A2)) {
    sub BGE_CHIPID_BCM5704_A2 () {	0x2002;}
}
unless(defined(&BGE_CHIPID_BCM5704_A3)) {
    sub BGE_CHIPID_BCM5704_A3 () {	0x2003;}
}
unless(defined(&BGE_CHIPID_BCM5704_B0)) {
    sub BGE_CHIPID_BCM5704_B0 () {	0x2100;}
}
unless(defined(&BGE_CHIPID_BCM5705_A0)) {
    sub BGE_CHIPID_BCM5705_A0 () {	0x3000;}
}
unless(defined(&BGE_CHIPID_BCM5705_A1)) {
    sub BGE_CHIPID_BCM5705_A1 () {	0x3001;}
}
unless(defined(&BGE_CHIPID_BCM5705_A2)) {
    sub BGE_CHIPID_BCM5705_A2 () {	0x3002;}
}
unless(defined(&BGE_CHIPID_BCM5705_A3)) {
    sub BGE_CHIPID_BCM5705_A3 () {	0x3003;}
}
unless(defined(&BGE_CHIPID_BCM5750_A0)) {
    sub BGE_CHIPID_BCM5750_A0 () {	0x4000;}
}
unless(defined(&BGE_CHIPID_BCM5750_A1)) {
    sub BGE_CHIPID_BCM5750_A1 () {	0x4001;}
}
unless(defined(&BGE_CHIPID_BCM5750_A3)) {
    sub BGE_CHIPID_BCM5750_A3 () {	0x4003;}
}
unless(defined(&BGE_CHIPID_BCM5750_B0)) {
    sub BGE_CHIPID_BCM5750_B0 () {	0x4010;}
}
unless(defined(&BGE_CHIPID_BCM5750_B1)) {
    sub BGE_CHIPID_BCM5750_B1 () {	0x4101;}
}
unless(defined(&BGE_CHIPID_BCM5750_C0)) {
    sub BGE_CHIPID_BCM5750_C0 () {	0x4200;}
}
unless(defined(&BGE_CHIPID_BCM5750_C1)) {
    sub BGE_CHIPID_BCM5750_C1 () {	0x4201;}
}
unless(defined(&BGE_CHIPID_BCM5750_C2)) {
    sub BGE_CHIPID_BCM5750_C2 () {	0x4202;}
}
unless(defined(&BGE_CHIPID_BCM5714_A0)) {
    sub BGE_CHIPID_BCM5714_A0 () {	0x5000;}
}
unless(defined(&BGE_CHIPID_BCM5761_A0)) {
    sub BGE_CHIPID_BCM5761_A0 () {	0x5761000;}
}
unless(defined(&BGE_CHIPID_BCM5761_A1)) {
    sub BGE_CHIPID_BCM5761_A1 () {	0x5761100;}
}
unless(defined(&BGE_CHIPID_BCM5784_A0)) {
    sub BGE_CHIPID_BCM5784_A0 () {	0x5784000;}
}
unless(defined(&BGE_CHIPID_BCM5784_A1)) {
    sub BGE_CHIPID_BCM5784_A1 () {	0x5784100;}
}
unless(defined(&BGE_CHIPID_BCM5752_A0)) {
    sub BGE_CHIPID_BCM5752_A0 () {	0x6000;}
}
unless(defined(&BGE_CHIPID_BCM5752_A1)) {
    sub BGE_CHIPID_BCM5752_A1 () {	0x6001;}
}
unless(defined(&BGE_CHIPID_BCM5752_A2)) {
    sub BGE_CHIPID_BCM5752_A2 () {	0x6002;}
}
unless(defined(&BGE_CHIPID_BCM5714_B0)) {
    sub BGE_CHIPID_BCM5714_B0 () {	0x8000;}
}
unless(defined(&BGE_CHIPID_BCM5714_B3)) {
    sub BGE_CHIPID_BCM5714_B3 () {	0x8003;}
}
unless(defined(&BGE_CHIPID_BCM5715_A0)) {
    sub BGE_CHIPID_BCM5715_A0 () {	0x9000;}
}
unless(defined(&BGE_CHIPID_BCM5715_A1)) {
    sub BGE_CHIPID_BCM5715_A1 () {	0x9001;}
}
unless(defined(&BGE_CHIPID_BCM5715_A3)) {
    sub BGE_CHIPID_BCM5715_A3 () {	0x9003;}
}
unless(defined(&BGE_CHIPID_BCM5755_A0)) {
    sub BGE_CHIPID_BCM5755_A0 () {	0xa000;}
}
unless(defined(&BGE_CHIPID_BCM5755_A1)) {
    sub BGE_CHIPID_BCM5755_A1 () {	0xa001;}
}
unless(defined(&BGE_CHIPID_BCM5755_A2)) {
    sub BGE_CHIPID_BCM5755_A2 () {	0xa002;}
}
unless(defined(&BGE_CHIPID_BCM5755_C0)) {
    sub BGE_CHIPID_BCM5755_C0 () {	0xa200;}
}
unless(defined(&BGE_CHIPID_BCM5787_A0)) {
    sub BGE_CHIPID_BCM5787_A0 () {	0xb000;}
}
unless(defined(&BGE_CHIPID_BCM5787_A1)) {
    sub BGE_CHIPID_BCM5787_A1 () {	0xb001;}
}
unless(defined(&BGE_CHIPID_BCM5787_A2)) {
    sub BGE_CHIPID_BCM5787_A2 () {	0xb002;}
}
unless(defined(&BGE_CHIPID_BCM5906_A0)) {
    sub BGE_CHIPID_BCM5906_A0 () {	0xc000;}
}
unless(defined(&BGE_CHIPID_BCM5906_A1)) {
    sub BGE_CHIPID_BCM5906_A1 () {	0xc001;}
}
unless(defined(&BGE_CHIPID_BCM5906_A2)) {
    sub BGE_CHIPID_BCM5906_A2 () {	0xc002;}
}
unless(defined(&BGE_CHIPID_BCM57780_A0)) {
    sub BGE_CHIPID_BCM57780_A0 () {	0x57780000;}
}
unless(defined(&BGE_CHIPID_BCM57780_A1)) {
    sub BGE_CHIPID_BCM57780_A1 () {	0x57780001;}
}
unless(defined(&BGE_ASICREV)) {
    sub BGE_ASICREV {
	my($x) = @_;
	eval q((($x) >> 12));
    }
}
unless(defined(&BGE_ASICREV_BCM5700)) {
    sub BGE_ASICREV_BCM5700 () {	0x7;}
}
unless(defined(&BGE_ASICREV_BCM5701)) {
    sub BGE_ASICREV_BCM5701 () {	0x;}
}
unless(defined(&BGE_ASICREV_BCM5703)) {
    sub BGE_ASICREV_BCM5703 () {	0x1;}
}
unless(defined(&BGE_ASICREV_BCM5704)) {
    sub BGE_ASICREV_BCM5704 () {	0x2;}
}
unless(defined(&BGE_ASICREV_BCM5705)) {
    sub BGE_ASICREV_BCM5705 () {	0x3;}
}
unless(defined(&BGE_ASICREV_BCM5750)) {
    sub BGE_ASICREV_BCM5750 () {	0x4;}
}
unless(defined(&BGE_ASICREV_BCM5714_A0)) {
    sub BGE_ASICREV_BCM5714_A0 () {	0x5;}
}
unless(defined(&BGE_ASICREV_BCM5752)) {
    sub BGE_ASICREV_BCM5752 () {	0x6;}
}
unless(defined(&BGE_ASICREV_BCM5780)) {
    sub BGE_ASICREV_BCM5780 () {	0x8;}
}
unless(defined(&BGE_ASICREV_BCM5714)) {
    sub BGE_ASICREV_BCM5714 () {	0x9;}
}
unless(defined(&BGE_ASICREV_BCM5755)) {
    sub BGE_ASICREV_BCM5755 () {	0xa;}
}
unless(defined(&BGE_ASICREV_BCM5787)) {
    sub BGE_ASICREV_BCM5787 () {	0xb;}
}
unless(defined(&BGE_ASICREV_BCM5906)) {
    sub BGE_ASICREV_BCM5906 () {	0xc;}
}
unless(defined(&BGE_ASICREV_USE_PRODID_REG)) {
    sub BGE_ASICREV_USE_PRODID_REG () {	0xf;}
}
unless(defined(&BGE_ASICREV_BCM5761)) {
    sub BGE_ASICREV_BCM5761 () {	0x5761;}
}
unless(defined(&BGE_ASICREV_BCM5784)) {
    sub BGE_ASICREV_BCM5784 () {	0x5784;}
}
unless(defined(&BGE_ASICREV_BCM5785)) {
    sub BGE_ASICREV_BCM5785 () {	0x5785;}
}
unless(defined(&BGE_ASICREV_BCM57780)) {
    sub BGE_ASICREV_BCM57780 () {	0x57780;}
}
unless(defined(&BGE_ASICREV_BCM5717)) {
    sub BGE_ASICREV_BCM5717 () {	0x5717;}
}
unless(defined(&BGE_ASICREV_BCM57765)) {
    sub BGE_ASICREV_BCM57765 () {	0x57785;}
}
unless(defined(&BGE_CHIPREV)) {
    sub BGE_CHIPREV {
	my($x) = @_;
	eval q((($x) >> 8));
    }
}
unless(defined(&BGE_CHIPREV_5700_AX)) {
    sub BGE_CHIPREV_5700_AX () {	0x70;}
}
unless(defined(&BGE_CHIPREV_5700_BX)) {
    sub BGE_CHIPREV_5700_BX () {	0x71;}
}
unless(defined(&BGE_CHIPREV_5700_CX)) {
    sub BGE_CHIPREV_5700_CX () {	0x72;}
}
unless(defined(&BGE_CHIPREV_5701_AX)) {
    sub BGE_CHIPREV_5701_AX () {	0x;}
}
unless(defined(&BGE_CHIPREV_5703_AX)) {
    sub BGE_CHIPREV_5703_AX () {	0x10;}
}
unless(defined(&BGE_CHIPREV_5704_AX)) {
    sub BGE_CHIPREV_5704_AX () {	0x20;}
}
unless(defined(&BGE_CHIPREV_5704_BX)) {
    sub BGE_CHIPREV_5704_BX () {	0x21;}
}
unless(defined(&BGE_CHIPREV_5750_AX)) {
    sub BGE_CHIPREV_5750_AX () {	0x40;}
}
unless(defined(&BGE_CHIPREV_5750_BX)) {
    sub BGE_CHIPREV_5750_BX () {	0x41;}
}
unless(defined(&BGE_CHIPREV_5761_AX)) {
    sub BGE_CHIPREV_5761_AX () {	0x57611;}
}
unless(defined(&BGE_CHIPREV_5784_AX)) {
    sub BGE_CHIPREV_5784_AX () {	0x57841;}
}
unless(defined(&BGE_PCIDMARWCTL_MINDMA)) {
    sub BGE_PCIDMARWCTL_MINDMA () {	0xff;}
}
unless(defined(&BGE_PCIDMARWCTL_RDADRR_BNDRY)) {
    sub BGE_PCIDMARWCTL_RDADRR_BNDRY () {	0x700;}
}
unless(defined(&BGE_PCIDMARWCTL_WRADDR_BNDRY)) {
    sub BGE_PCIDMARWCTL_WRADDR_BNDRY () {	0x3800;}
}
unless(defined(&BGE_PCIDMARWCTL_ONEDMA_ATONCE)) {
    sub BGE_PCIDMARWCTL_ONEDMA_ATONCE () {	0xc000;}
}
unless(defined(&BGE_PCIDMARWCTL_ONEDMA_ATONCE_GLOBAL)) {
    sub BGE_PCIDMARWCTL_ONEDMA_ATONCE_GLOBAL () {	0x4000;}
}
unless(defined(&BGE_PCIDMARWCTL_ONEDMA_ATONCE_LOCAL)) {
    sub BGE_PCIDMARWCTL_ONEDMA_ATONCE_LOCAL () {	0x8000;}
}
unless(defined(&BGE_PCIDMARWCTL_RD_WAT)) {
    sub BGE_PCIDMARWCTL_RD_WAT () {	0x70000;}
}
unless(defined(&BGE_PCIDMARWCTL_WR_WAT)) {
    sub BGE_PCIDMARWCTL_WR_WAT () {	0x380000;}
}
unless(defined(&BGE_PCIDMARWCTL_USE_MRM)) {
    sub BGE_PCIDMARWCTL_USE_MRM () {	0x400000;}
}
unless(defined(&BGE_PCIDMARWCTL_ASRT_ALL_BE)) {
    sub BGE_PCIDMARWCTL_ASRT_ALL_BE () {	0x800000;}
}
unless(defined(&BGE_PCIDMARWCTL_DFLT_PCI_RD_CMD)) {
    sub BGE_PCIDMARWCTL_DFLT_PCI_RD_CMD () {	0xf000000;}
}
unless(defined(&BGE_PCIDMARWCTL_DFLT_PCI_WR_CMD)) {
    sub BGE_PCIDMARWCTL_DFLT_PCI_WR_CMD () {	0xf0000000;}
}
unless(defined(&BGE_PCIDMARWCTL_RD_WAT_SHIFT)) {
    sub BGE_PCIDMARWCTL_RD_WAT_SHIFT {
	my($x) = @_;
	eval q((($x) << 16));
    }
}
unless(defined(&BGE_PCIDMARWCTL_WR_WAT_SHIFT)) {
    sub BGE_PCIDMARWCTL_WR_WAT_SHIFT {
	my($x) = @_;
	eval q((($x) << 19));
    }
}
unless(defined(&BGE_PCIDMARWCTL_RD_CMD_SHIFT)) {
    sub BGE_PCIDMARWCTL_RD_CMD_SHIFT {
	my($x) = @_;
	eval q((($x) << 24));
    }
}
unless(defined(&BGE_PCIDMARWCTL_WR_CMD_SHIFT)) {
    sub BGE_PCIDMARWCTL_WR_CMD_SHIFT {
	my($x) = @_;
	eval q((($x) << 28));
    }
}
unless(defined(&BGE_PCI_READ_BNDRY_DISABLE)) {
    sub BGE_PCI_READ_BNDRY_DISABLE () {	0x;}
}
unless(defined(&BGE_PCI_READ_BNDRY_16BYTES)) {
    sub BGE_PCI_READ_BNDRY_16BYTES () {	0x100;}
}
unless(defined(&BGE_PCI_READ_BNDRY_32BYTES)) {
    sub BGE_PCI_READ_BNDRY_32BYTES () {	0x200;}
}
unless(defined(&BGE_PCI_READ_BNDRY_64BYTES)) {
    sub BGE_PCI_READ_BNDRY_64BYTES () {	0x300;}
}
unless(defined(&BGE_PCI_READ_BNDRY_128BYTES)) {
    sub BGE_PCI_READ_BNDRY_128BYTES () {	0x400;}
}
unless(defined(&BGE_PCI_READ_BNDRY_256BYTES)) {
    sub BGE_PCI_READ_BNDRY_256BYTES () {	0x500;}
}
unless(defined(&BGE_PCI_READ_BNDRY_512BYTES)) {
    sub BGE_PCI_READ_BNDRY_512BYTES () {	0x600;}
}
unless(defined(&BGE_PCI_READ_BNDRY_1024BYTES)) {
    sub BGE_PCI_READ_BNDRY_1024BYTES () {	0x700;}
}
unless(defined(&BGE_PCI_WRITE_BNDRY_DISABLE)) {
    sub BGE_PCI_WRITE_BNDRY_DISABLE () {	0x;}
}
unless(defined(&BGE_PCI_WRITE_BNDRY_16BYTES)) {
    sub BGE_PCI_WRITE_BNDRY_16BYTES () {	0x800;}
}
unless(defined(&BGE_PCI_WRITE_BNDRY_32BYTES)) {
    sub BGE_PCI_WRITE_BNDRY_32BYTES () {	0x1000;}
}
unless(defined(&BGE_PCI_WRITE_BNDRY_64BYTES)) {
    sub BGE_PCI_WRITE_BNDRY_64BYTES () {	0x1800;}
}
unless(defined(&BGE_PCI_WRITE_BNDRY_128BYTES)) {
    sub BGE_PCI_WRITE_BNDRY_128BYTES () {	0x2000;}
}
unless(defined(&BGE_PCI_WRITE_BNDRY_256BYTES)) {
    sub BGE_PCI_WRITE_BNDRY_256BYTES () {	0x2800;}
}
unless(defined(&BGE_PCI_WRITE_BNDRY_512BYTES)) {
    sub BGE_PCI_WRITE_BNDRY_512BYTES () {	0x3000;}
}
unless(defined(&BGE_PCI_WRITE_BNDRY_1024BYTES)) {
    sub BGE_PCI_WRITE_BNDRY_1024BYTES () {	0x3800;}
}
unless(defined(&BGE_PCISTATE_FORCE_RESET)) {
    sub BGE_PCISTATE_FORCE_RESET () {	0x1;}
}
unless(defined(&BGE_PCISTATE_INTR_NOT_ACTIVE)) {
    sub BGE_PCISTATE_INTR_NOT_ACTIVE () {	0x2;}
}
unless(defined(&BGE_PCISTATE_PCI_BUSMODE)) {
    sub BGE_PCISTATE_PCI_BUSMODE () {	0x4;}
}
unless(defined(&BGE_PCISTATE_PCI_BUSSPEED)) {
    sub BGE_PCISTATE_PCI_BUSSPEED () {	0x8;}
}
unless(defined(&BGE_PCISTATE_32BIT_BUS)) {
    sub BGE_PCISTATE_32BIT_BUS () {	0x10;}
}
unless(defined(&BGE_PCISTATE_WANT_EXPROM)) {
    sub BGE_PCISTATE_WANT_EXPROM () {	0x20;}
}
unless(defined(&BGE_PCISTATE_EXPROM_RETRY)) {
    sub BGE_PCISTATE_EXPROM_RETRY () {	0x40;}
}
unless(defined(&BGE_PCISTATE_FLATVIEW_MODE)) {
    sub BGE_PCISTATE_FLATVIEW_MODE () {	0x100;}
}
unless(defined(&BGE_PCISTATE_RETRY_SAME_DMA)) {
    sub BGE_PCISTATE_RETRY_SAME_DMA () {	0x2000;}
}
unless(defined(&BGE_PCISTATE_PCI_TGT_RETRY_MAX)) {
    sub BGE_PCISTATE_PCI_TGT_RETRY_MAX () {	0xe00;}
}
unless(defined(&BGE_PCISTATE_RESERVED)) {
    sub BGE_PCISTATE_RESERVED () {	((1<< 12) + (1<<7));}
}
unless(defined(&BGE_PCICLOCKCTL_DETECTED_SPEED)) {
    sub BGE_PCICLOCKCTL_DETECTED_SPEED () {	0xf;}
}
unless(defined(&BGE_PCICLOCKCTL_M66EN)) {
    sub BGE_PCICLOCKCTL_M66EN () {	0x80;}
}
unless(defined(&BGE_PCICLOCKCTL_LOWPWR_CLKMODE)) {
    sub BGE_PCICLOCKCTL_LOWPWR_CLKMODE () {	0x200;}
}
unless(defined(&BGE_PCICLOCKCTL_RXCPU_CLK_DIS)) {
    sub BGE_PCICLOCKCTL_RXCPU_CLK_DIS () {	0x400;}
}
unless(defined(&BGE_PCICLOCKCTL_TXCPU_CLK_DIS)) {
    sub BGE_PCICLOCKCTL_TXCPU_CLK_DIS () {	0x800;}
}
unless(defined(&BGE_PCICLOCKCTL_ALTCLK)) {
    sub BGE_PCICLOCKCTL_ALTCLK () {	0x1000;}
}
unless(defined(&BGE_PCICLOCKCTL_ALTCLK_SRC)) {
    sub BGE_PCICLOCKCTL_ALTCLK_SRC () {	0x2000;}
}
unless(defined(&BGE_PCICLOCKCTL_PCIPLL_DISABLE)) {
    sub BGE_PCICLOCKCTL_PCIPLL_DISABLE () {	0x4000;}
}
unless(defined(&BGE_PCICLOCKCTL_SYSPLL_DISABLE)) {
    sub BGE_PCICLOCKCTL_SYSPLL_DISABLE () {	0x8000;}
}
unless(defined(&BGE_PCICLOCKCTL_BIST_ENABLE)) {
    sub BGE_PCICLOCKCTL_BIST_ENABLE () {	0x10000;}
}
unless(defined(&BGE_MBX_IRQ0_HI)) {
    sub BGE_MBX_IRQ0_HI () {	0x200;}
}
unless(defined(&BGE_MBX_IRQ0_LO)) {
    sub BGE_MBX_IRQ0_LO () {	0x204;}
}
unless(defined(&BGE_MBX_IRQ1_HI)) {
    sub BGE_MBX_IRQ1_HI () {	0x208;}
}
unless(defined(&BGE_MBX_IRQ1_LO)) {
    sub BGE_MBX_IRQ1_LO () {	0x20c;}
}
unless(defined(&BGE_MBX_IRQ2_HI)) {
    sub BGE_MBX_IRQ2_HI () {	0x210;}
}
unless(defined(&BGE_MBX_IRQ2_LO)) {
    sub BGE_MBX_IRQ2_LO () {	0x214;}
}
unless(defined(&BGE_MBX_IRQ3_HI)) {
    sub BGE_MBX_IRQ3_HI () {	0x218;}
}
unless(defined(&BGE_MBX_IRQ3_LO)) {
    sub BGE_MBX_IRQ3_LO () {	0x21c;}
}
unless(defined(&BGE_MBX_GEN0_HI)) {
    sub BGE_MBX_GEN0_HI () {	0x220;}
}
unless(defined(&BGE_MBX_GEN0_LO)) {
    sub BGE_MBX_GEN0_LO () {	0x224;}
}
unless(defined(&BGE_MBX_GEN1_HI)) {
    sub BGE_MBX_GEN1_HI () {	0x228;}
}
unless(defined(&BGE_MBX_GEN1_LO)) {
    sub BGE_MBX_GEN1_LO () {	0x22c;}
}
unless(defined(&BGE_MBX_GEN2_HI)) {
    sub BGE_MBX_GEN2_HI () {	0x230;}
}
unless(defined(&BGE_MBX_GEN2_LO)) {
    sub BGE_MBX_GEN2_LO () {	0x234;}
}
unless(defined(&BGE_MBX_GEN3_HI)) {
    sub BGE_MBX_GEN3_HI () {	0x228;}
}
unless(defined(&BGE_MBX_GEN3_LO)) {
    sub BGE_MBX_GEN3_LO () {	0x22c;}
}
unless(defined(&BGE_MBX_GEN4_HI)) {
    sub BGE_MBX_GEN4_HI () {	0x240;}
}
unless(defined(&BGE_MBX_GEN4_LO)) {
    sub BGE_MBX_GEN4_LO () {	0x244;}
}
unless(defined(&BGE_MBX_GEN5_HI)) {
    sub BGE_MBX_GEN5_HI () {	0x248;}
}
unless(defined(&BGE_MBX_GEN5_LO)) {
    sub BGE_MBX_GEN5_LO () {	0x24c;}
}
unless(defined(&BGE_MBX_GEN6_HI)) {
    sub BGE_MBX_GEN6_HI () {	0x250;}
}
unless(defined(&BGE_MBX_GEN6_LO)) {
    sub BGE_MBX_GEN6_LO () {	0x254;}
}
unless(defined(&BGE_MBX_GEN7_HI)) {
    sub BGE_MBX_GEN7_HI () {	0x258;}
}
unless(defined(&BGE_MBX_GEN7_LO)) {
    sub BGE_MBX_GEN7_LO () {	0x25c;}
}
unless(defined(&BGE_MBX_RELOAD_STATS_HI)) {
    sub BGE_MBX_RELOAD_STATS_HI () {	0x260;}
}
unless(defined(&BGE_MBX_RELOAD_STATS_LO)) {
    sub BGE_MBX_RELOAD_STATS_LO () {	0x264;}
}
unless(defined(&BGE_MBX_RX_STD_PROD_HI)) {
    sub BGE_MBX_RX_STD_PROD_HI () {	0x268;}
}
unless(defined(&BGE_MBX_RX_STD_PROD_LO)) {
    sub BGE_MBX_RX_STD_PROD_LO () {	0x26c;}
}
unless(defined(&BGE_MBX_RX_JUMBO_PROD_HI)) {
    sub BGE_MBX_RX_JUMBO_PROD_HI () {	0x270;}
}
unless(defined(&BGE_MBX_RX_JUMBO_PROD_LO)) {
    sub BGE_MBX_RX_JUMBO_PROD_LO () {	0x274;}
}
unless(defined(&BGE_MBX_RX_MINI_PROD_HI)) {
    sub BGE_MBX_RX_MINI_PROD_HI () {	0x278;}
}
unless(defined(&BGE_MBX_RX_MINI_PROD_LO)) {
    sub BGE_MBX_RX_MINI_PROD_LO () {	0x27c;}
}
unless(defined(&BGE_MBX_RX_CONS0_HI)) {
    sub BGE_MBX_RX_CONS0_HI () {	0x280;}
}
unless(defined(&BGE_MBX_RX_CONS0_LO)) {
    sub BGE_MBX_RX_CONS0_LO () {	0x284;}
}
unless(defined(&BGE_MBX_RX_CONS1_HI)) {
    sub BGE_MBX_RX_CONS1_HI () {	0x288;}
}
unless(defined(&BGE_MBX_RX_CONS1_LO)) {
    sub BGE_MBX_RX_CONS1_LO () {	0x28c;}
}
unless(defined(&BGE_MBX_RX_CONS2_HI)) {
    sub BGE_MBX_RX_CONS2_HI () {	0x290;}
}
unless(defined(&BGE_MBX_RX_CONS2_LO)) {
    sub BGE_MBX_RX_CONS2_LO () {	0x294;}
}
unless(defined(&BGE_MBX_RX_CONS3_HI)) {
    sub BGE_MBX_RX_CONS3_HI () {	0x298;}
}
unless(defined(&BGE_MBX_RX_CONS3_LO)) {
    sub BGE_MBX_RX_CONS3_LO () {	0x29c;}
}
unless(defined(&BGE_MBX_RX_CONS4_HI)) {
    sub BGE_MBX_RX_CONS4_HI () {	0x2a0;}
}
unless(defined(&BGE_MBX_RX_CONS4_LO)) {
    sub BGE_MBX_RX_CONS4_LO () {	0x2a4;}
}
unless(defined(&BGE_MBX_RX_CONS5_HI)) {
    sub BGE_MBX_RX_CONS5_HI () {	0x2a8;}
}
unless(defined(&BGE_MBX_RX_CONS5_LO)) {
    sub BGE_MBX_RX_CONS5_LO () {	0x2ac;}
}
unless(defined(&BGE_MBX_RX_CONS6_HI)) {
    sub BGE_MBX_RX_CONS6_HI () {	0x2b0;}
}
unless(defined(&BGE_MBX_RX_CONS6_LO)) {
    sub BGE_MBX_RX_CONS6_LO () {	0x2b4;}
}
unless(defined(&BGE_MBX_RX_CONS7_HI)) {
    sub BGE_MBX_RX_CONS7_HI () {	0x2b8;}
}
unless(defined(&BGE_MBX_RX_CONS7_LO)) {
    sub BGE_MBX_RX_CONS7_LO () {	0x2bc;}
}
unless(defined(&BGE_MBX_RX_CONS8_HI)) {
    sub BGE_MBX_RX_CONS8_HI () {	0x2c0;}
}
unless(defined(&BGE_MBX_RX_CONS8_LO)) {
    sub BGE_MBX_RX_CONS8_LO () {	0x2c4;}
}
unless(defined(&BGE_MBX_RX_CONS9_HI)) {
    sub BGE_MBX_RX_CONS9_HI () {	0x2c8;}
}
unless(defined(&BGE_MBX_RX_CONS9_LO)) {
    sub BGE_MBX_RX_CONS9_LO () {	0x2cc;}
}
unless(defined(&BGE_MBX_RX_CONS10_HI)) {
    sub BGE_MBX_RX_CONS10_HI () {	0x2d0;}
}
unless(defined(&BGE_MBX_RX_CONS10_LO)) {
    sub BGE_MBX_RX_CONS10_LO () {	0x2d4;}
}
unless(defined(&BGE_MBX_RX_CONS11_HI)) {
    sub BGE_MBX_RX_CONS11_HI () {	0x2d8;}
}
unless(defined(&BGE_MBX_RX_CONS11_LO)) {
    sub BGE_MBX_RX_CONS11_LO () {	0x2dc;}
}
unless(defined(&BGE_MBX_RX_CONS12_HI)) {
    sub BGE_MBX_RX_CONS12_HI () {	0x2e0;}
}
unless(defined(&BGE_MBX_RX_CONS12_LO)) {
    sub BGE_MBX_RX_CONS12_LO () {	0x2e4;}
}
unless(defined(&BGE_MBX_RX_CONS13_HI)) {
    sub BGE_MBX_RX_CONS13_HI () {	0x2e8;}
}
unless(defined(&BGE_MBX_RX_CONS13_LO)) {
    sub BGE_MBX_RX_CONS13_LO () {	0x2ec;}
}
unless(defined(&BGE_MBX_RX_CONS14_HI)) {
    sub BGE_MBX_RX_CONS14_HI () {	0x2f0;}
}
unless(defined(&BGE_MBX_RX_CONS14_LO)) {
    sub BGE_MBX_RX_CONS14_LO () {	0x2f4;}
}
unless(defined(&BGE_MBX_RX_CONS15_HI)) {
    sub BGE_MBX_RX_CONS15_HI () {	0x2f8;}
}
unless(defined(&BGE_MBX_RX_CONS15_LO)) {
    sub BGE_MBX_RX_CONS15_LO () {	0x2fc;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD0_HI)) {
    sub BGE_MBX_TX_HOST_PROD0_HI () {	0x300;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD0_LO)) {
    sub BGE_MBX_TX_HOST_PROD0_LO () {	0x304;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD1_HI)) {
    sub BGE_MBX_TX_HOST_PROD1_HI () {	0x308;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD1_LO)) {
    sub BGE_MBX_TX_HOST_PROD1_LO () {	0x30c;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD2_HI)) {
    sub BGE_MBX_TX_HOST_PROD2_HI () {	0x310;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD2_LO)) {
    sub BGE_MBX_TX_HOST_PROD2_LO () {	0x314;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD3_HI)) {
    sub BGE_MBX_TX_HOST_PROD3_HI () {	0x318;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD3_LO)) {
    sub BGE_MBX_TX_HOST_PROD3_LO () {	0x31c;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD4_HI)) {
    sub BGE_MBX_TX_HOST_PROD4_HI () {	0x320;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD4_LO)) {
    sub BGE_MBX_TX_HOST_PROD4_LO () {	0x324;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD5_HI)) {
    sub BGE_MBX_TX_HOST_PROD5_HI () {	0x328;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD5_LO)) {
    sub BGE_MBX_TX_HOST_PROD5_LO () {	0x32c;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD6_HI)) {
    sub BGE_MBX_TX_HOST_PROD6_HI () {	0x330;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD6_LO)) {
    sub BGE_MBX_TX_HOST_PROD6_LO () {	0x334;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD7_HI)) {
    sub BGE_MBX_TX_HOST_PROD7_HI () {	0x338;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD7_LO)) {
    sub BGE_MBX_TX_HOST_PROD7_LO () {	0x33c;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD8_HI)) {
    sub BGE_MBX_TX_HOST_PROD8_HI () {	0x340;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD8_LO)) {
    sub BGE_MBX_TX_HOST_PROD8_LO () {	0x344;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD9_HI)) {
    sub BGE_MBX_TX_HOST_PROD9_HI () {	0x348;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD9_LO)) {
    sub BGE_MBX_TX_HOST_PROD9_LO () {	0x34c;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD10_HI)) {
    sub BGE_MBX_TX_HOST_PROD10_HI () {	0x350;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD10_LO)) {
    sub BGE_MBX_TX_HOST_PROD10_LO () {	0x354;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD11_HI)) {
    sub BGE_MBX_TX_HOST_PROD11_HI () {	0x358;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD11_LO)) {
    sub BGE_MBX_TX_HOST_PROD11_LO () {	0x35c;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD12_HI)) {
    sub BGE_MBX_TX_HOST_PROD12_HI () {	0x360;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD12_LO)) {
    sub BGE_MBX_TX_HOST_PROD12_LO () {	0x364;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD13_HI)) {
    sub BGE_MBX_TX_HOST_PROD13_HI () {	0x368;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD13_LO)) {
    sub BGE_MBX_TX_HOST_PROD13_LO () {	0x36c;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD14_HI)) {
    sub BGE_MBX_TX_HOST_PROD14_HI () {	0x370;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD14_LO)) {
    sub BGE_MBX_TX_HOST_PROD14_LO () {	0x374;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD15_HI)) {
    sub BGE_MBX_TX_HOST_PROD15_HI () {	0x378;}
}
unless(defined(&BGE_MBX_TX_HOST_PROD15_LO)) {
    sub BGE_MBX_TX_HOST_PROD15_LO () {	0x37c;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD0_HI)) {
    sub BGE_MBX_TX_NIC_PROD0_HI () {	0x380;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD0_LO)) {
    sub BGE_MBX_TX_NIC_PROD0_LO () {	0x384;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD1_HI)) {
    sub BGE_MBX_TX_NIC_PROD1_HI () {	0x388;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD1_LO)) {
    sub BGE_MBX_TX_NIC_PROD1_LO () {	0x38c;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD2_HI)) {
    sub BGE_MBX_TX_NIC_PROD2_HI () {	0x390;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD2_LO)) {
    sub BGE_MBX_TX_NIC_PROD2_LO () {	0x394;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD3_HI)) {
    sub BGE_MBX_TX_NIC_PROD3_HI () {	0x398;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD3_LO)) {
    sub BGE_MBX_TX_NIC_PROD3_LO () {	0x39c;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD4_HI)) {
    sub BGE_MBX_TX_NIC_PROD4_HI () {	0x3a0;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD4_LO)) {
    sub BGE_MBX_TX_NIC_PROD4_LO () {	0x3a4;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD5_HI)) {
    sub BGE_MBX_TX_NIC_PROD5_HI () {	0x3a8;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD5_LO)) {
    sub BGE_MBX_TX_NIC_PROD5_LO () {	0x3ac;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD6_HI)) {
    sub BGE_MBX_TX_NIC_PROD6_HI () {	0x3b0;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD6_LO)) {
    sub BGE_MBX_TX_NIC_PROD6_LO () {	0x3b4;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD7_HI)) {
    sub BGE_MBX_TX_NIC_PROD7_HI () {	0x3b8;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD7_LO)) {
    sub BGE_MBX_TX_NIC_PROD7_LO () {	0x3bc;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD8_HI)) {
    sub BGE_MBX_TX_NIC_PROD8_HI () {	0x3c0;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD8_LO)) {
    sub BGE_MBX_TX_NIC_PROD8_LO () {	0x3c4;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD9_HI)) {
    sub BGE_MBX_TX_NIC_PROD9_HI () {	0x3c8;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD9_LO)) {
    sub BGE_MBX_TX_NIC_PROD9_LO () {	0x3cc;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD10_HI)) {
    sub BGE_MBX_TX_NIC_PROD10_HI () {	0x3d0;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD10_LO)) {
    sub BGE_MBX_TX_NIC_PROD10_LO () {	0x3d4;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD11_HI)) {
    sub BGE_MBX_TX_NIC_PROD11_HI () {	0x3d8;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD11_LO)) {
    sub BGE_MBX_TX_NIC_PROD11_LO () {	0x3dc;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD12_HI)) {
    sub BGE_MBX_TX_NIC_PROD12_HI () {	0x3e0;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD12_LO)) {
    sub BGE_MBX_TX_NIC_PROD12_LO () {	0x3e4;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD13_HI)) {
    sub BGE_MBX_TX_NIC_PROD13_HI () {	0x3e8;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD13_LO)) {
    sub BGE_MBX_TX_NIC_PROD13_LO () {	0x3ec;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD14_HI)) {
    sub BGE_MBX_TX_NIC_PROD14_HI () {	0x3f0;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD14_LO)) {
    sub BGE_MBX_TX_NIC_PROD14_LO () {	0x3f4;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD15_HI)) {
    sub BGE_MBX_TX_NIC_PROD15_HI () {	0x3f8;}
}
unless(defined(&BGE_MBX_TX_NIC_PROD15_LO)) {
    sub BGE_MBX_TX_NIC_PROD15_LO () {	0x3fc;}
}
unless(defined(&BGE_TX_RINGS_MAX)) {
    sub BGE_TX_RINGS_MAX () {	4;}
}
unless(defined(&BGE_TX_RINGS_EXTSSRAM_MAX)) {
    sub BGE_TX_RINGS_EXTSSRAM_MAX () {	16;}
}
unless(defined(&BGE_RX_RINGS_MAX)) {
    sub BGE_RX_RINGS_MAX () {	16;}
}
unless(defined(&BGE_MAC_MODE)) {
    sub BGE_MAC_MODE () {	0x400;}
}
unless(defined(&BGE_MAC_STS)) {
    sub BGE_MAC_STS () {	0x404;}
}
unless(defined(&BGE_MAC_EVT_ENB)) {
    sub BGE_MAC_EVT_ENB () {	0x408;}
}
unless(defined(&BGE_MAC_LED_CTL)) {
    sub BGE_MAC_LED_CTL () {	0x40c;}
}
unless(defined(&BGE_MAC_ADDR1_LO)) {
    sub BGE_MAC_ADDR1_LO () {	0x410;}
}
unless(defined(&BGE_MAC_ADDR1_HI)) {
    sub BGE_MAC_ADDR1_HI () {	0x414;}
}
unless(defined(&BGE_MAC_ADDR2_LO)) {
    sub BGE_MAC_ADDR2_LO () {	0x418;}
}
unless(defined(&BGE_MAC_ADDR2_HI)) {
    sub BGE_MAC_ADDR2_HI () {	0x41c;}
}
unless(defined(&BGE_MAC_ADDR3_LO)) {
    sub BGE_MAC_ADDR3_LO () {	0x420;}
}
unless(defined(&BGE_MAC_ADDR3_HI)) {
    sub BGE_MAC_ADDR3_HI () {	0x424;}
}
unless(defined(&BGE_MAC_ADDR4_LO)) {
    sub BGE_MAC_ADDR4_LO () {	0x428;}
}
unless(defined(&BGE_MAC_ADDR4_HI)) {
    sub BGE_MAC_ADDR4_HI () {	0x42c;}
}
unless(defined(&BGE_WOL_PATPTR)) {
    sub BGE_WOL_PATPTR () {	0x430;}
}
unless(defined(&BGE_WOL_PATCFG)) {
    sub BGE_WOL_PATCFG () {	0x434;}
}
unless(defined(&BGE_TX_RANDOM_BACKOFF)) {
    sub BGE_TX_RANDOM_BACKOFF () {	0x438;}
}
unless(defined(&BGE_RX_MTU)) {
    sub BGE_RX_MTU () {	0x43c;}
}
unless(defined(&BGE_GBIT_PCS_TEST)) {
    sub BGE_GBIT_PCS_TEST () {	0x440;}
}
unless(defined(&BGE_TX_TBI_AUTONEG)) {
    sub BGE_TX_TBI_AUTONEG () {	0x444;}
}
unless(defined(&BGE_RX_TBI_AUTONEG)) {
    sub BGE_RX_TBI_AUTONEG () {	0x448;}
}
unless(defined(&BGE_MI_COMM)) {
    sub BGE_MI_COMM () {	0x44c;}
}
unless(defined(&BGE_MI_STS)) {
    sub BGE_MI_STS () {	0x450;}
}
unless(defined(&BGE_MI_MODE)) {
    sub BGE_MI_MODE () {	0x454;}
}
unless(defined(&BGE_AUTOPOLL_STS)) {
    sub BGE_AUTOPOLL_STS () {	0x458;}
}
unless(defined(&BGE_TX_MODE)) {
    sub BGE_TX_MODE () {	0x45c;}
}
unless(defined(&BGE_TX_STS)) {
    sub BGE_TX_STS () {	0x460;}
}
unless(defined(&BGE_TX_LENGTHS)) {
    sub BGE_TX_LENGTHS () {	0x464;}
}
unless(defined(&BGE_RX_MODE)) {
    sub BGE_RX_MODE () {	0x468;}
}
unless(defined(&BGE_RX_STS)) {
    sub BGE_RX_STS () {	0x46c;}
}
unless(defined(&BGE_MAR0)) {
    sub BGE_MAR0 () {	0x470;}
}
unless(defined(&BGE_MAR1)) {
    sub BGE_MAR1 () {	0x474;}
}
unless(defined(&BGE_MAR2)) {
    sub BGE_MAR2 () {	0x478;}
}
unless(defined(&BGE_MAR3)) {
    sub BGE_MAR3 () {	0x47c;}
}
unless(defined(&BGE_RX_BD_RULES_CTL0)) {
    sub BGE_RX_BD_RULES_CTL0 () {	0x480;}
}
unless(defined(&BGE_RX_BD_RULES_MASKVAL0)) {
    sub BGE_RX_BD_RULES_MASKVAL0 () {	0x484;}
}
unless(defined(&BGE_RX_BD_RULES_CTL1)) {
    sub BGE_RX_BD_RULES_CTL1 () {	0x488;}
}
unless(defined(&BGE_RX_BD_RULES_MASKVAL1)) {
    sub BGE_RX_BD_RULES_MASKVAL1 () {	0x48c;}
}
unless(defined(&BGE_RX_BD_RULES_CTL2)) {
    sub BGE_RX_BD_RULES_CTL2 () {	0x490;}
}
unless(defined(&BGE_RX_BD_RULES_MASKVAL2)) {
    sub BGE_RX_BD_RULES_MASKVAL2 () {	0x494;}
}
unless(defined(&BGE_RX_BD_RULES_CTL3)) {
    sub BGE_RX_BD_RULES_CTL3 () {	0x498;}
}
unless(defined(&BGE_RX_BD_RULES_MASKVAL3)) {
    sub BGE_RX_BD_RULES_MASKVAL3 () {	0x49c;}
}
unless(defined(&BGE_RX_BD_RULES_CTL4)) {
    sub BGE_RX_BD_RULES_CTL4 () {	0x4a0;}
}
unless(defined(&BGE_RX_BD_RULES_MASKVAL4)) {
    sub BGE_RX_BD_RULES_MASKVAL4 () {	0x4a4;}
}
unless(defined(&BGE_RX_BD_RULES_CTL5)) {
    sub BGE_RX_BD_RULES_CTL5 () {	0x4a8;}
}
unless(defined(&BGE_RX_BD_RULES_MASKVAL5)) {
    sub BGE_RX_BD_RULES_MASKVAL5 () {	0x4ac;}
}
unless(defined(&BGE_RX_BD_RULES_CTL6)) {
    sub BGE_RX_BD_RULES_CTL6 () {	0x4b0;}
}
unless(defined(&BGE_RX_BD_RULES_MASKVAL6)) {
    sub BGE_RX_BD_RULES_MASKVAL6 () {	0x4b4;}
}
unless(defined(&BGE_RX_BD_RULES_CTL7)) {
    sub BGE_RX_BD_RULES_CTL7 () {	0x4b8;}
}
unless(defined(&BGE_RX_BD_RULES_MASKVAL7)) {
    sub BGE_RX_BD_RULES_MASKVAL7 () {	0x4bc;}
}
unless(defined(&BGE_RX_BD_RULES_CTL8)) {
    sub BGE_RX_BD_RULES_CTL8 () {	0x4c0;}
}
unless(defined(&BGE_RX_BD_RULES_MASKVAL8)) {
    sub BGE_RX_BD_RULES_MASKVAL8 () {	0x4c4;}
}
unless(defined(&BGE_RX_BD_RULES_CTL9)) {
    sub BGE_RX_BD_RULES_CTL9 () {	0x4c8;}
}
unless(defined(&BGE_RX_BD_RULES_MASKVAL9)) {
    sub BGE_RX_BD_RULES_MASKVAL9 () {	0x4cc;}
}
unless(defined(&BGE_RX_BD_RULES_CTL10)) {
    sub BGE_RX_BD_RULES_CTL10 () {	0x4d0;}
}
unless(defined(&BGE_RX_BD_RULES_MASKVAL10)) {
    sub BGE_RX_BD_RULES_MASKVAL10 () {	0x4d4;}
}
unless(defined(&BGE_RX_BD_RULES_CTL11)) {
    sub BGE_RX_BD_RULES_CTL11 () {	0x4d8;}
}
unless(defined(&BGE_RX_BD_RULES_MASKVAL11)) {
    sub BGE_RX_BD_RULES_MASKVAL11 () {	0x4dc;}
}
unless(defined(&BGE_RX_BD_RULES_CTL12)) {
    sub BGE_RX_BD_RULES_CTL12 () {	0x4e0;}
}
unless(defined(&BGE_RX_BD_RULES_MASKVAL12)) {
    sub BGE_RX_BD_RULES_MASKVAL12 () {	0x4e4;}
}
unless(defined(&BGE_RX_BD_RULES_CTL13)) {
    sub BGE_RX_BD_RULES_CTL13 () {	0x4e8;}
}
unless(defined(&BGE_RX_BD_RULES_MASKVAL13)) {
    sub BGE_RX_BD_RULES_MASKVAL13 () {	0x4ec;}
}
unless(defined(&BGE_RX_BD_RULES_CTL14)) {
    sub BGE_RX_BD_RULES_CTL14 () {	0x4f0;}
}
unless(defined(&BGE_RX_BD_RULES_MASKVAL14)) {
    sub BGE_RX_BD_RULES_MASKVAL14 () {	0x4f4;}
}
unless(defined(&BGE_RX_BD_RULES_CTL15)) {
    sub BGE_RX_BD_RULES_CTL15 () {	0x4f8;}
}
unless(defined(&BGE_RX_BD_RULES_MASKVAL15)) {
    sub BGE_RX_BD_RULES_MASKVAL15 () {	0x4fc;}
}
unless(defined(&BGE_RX_RULES_CFG)) {
    sub BGE_RX_RULES_CFG () {	0x500;}
}
unless(defined(&BGE_MAX_RX_FRAME_LOWAT)) {
    sub BGE_MAX_RX_FRAME_LOWAT () {	0x504;}
}
unless(defined(&BGE_SERDES_CFG)) {
    sub BGE_SERDES_CFG () {	0x590;}
}
unless(defined(&BGE_SERDES_STS)) {
    sub BGE_SERDES_STS () {	0x594;}
}
unless(defined(&BGE_PHYCFG1)) {
    sub BGE_PHYCFG1 () {	0x5a0;}
}
unless(defined(&BGE_PHYCFG2)) {
    sub BGE_PHYCFG2 () {	0x5a4;}
}
unless(defined(&BGE_EXT_RGMII_MODE)) {
    sub BGE_EXT_RGMII_MODE () {	0x5a8;}
}
unless(defined(&BGE_SGDIG_CFG)) {
    sub BGE_SGDIG_CFG () {	0x5b0;}
}
unless(defined(&BGE_SGDIG_STS)) {
    sub BGE_SGDIG_STS () {	0x5b4;}
}
unless(defined(&BGE_MAC_STATS)) {
    sub BGE_MAC_STATS () {	0x800;}
}
unless(defined(&BGE_MACMODE_RESET)) {
    sub BGE_MACMODE_RESET () {	0x1;}
}
unless(defined(&BGE_MACMODE_HALF_DUPLEX)) {
    sub BGE_MACMODE_HALF_DUPLEX () {	0x2;}
}
unless(defined(&BGE_MACMODE_PORTMODE)) {
    sub BGE_MACMODE_PORTMODE () {	0xc;}
}
unless(defined(&BGE_MACMODE_LOOPBACK)) {
    sub BGE_MACMODE_LOOPBACK () {	0x10;}
}
unless(defined(&BGE_MACMODE_RX_TAGGEDPKT)) {
    sub BGE_MACMODE_RX_TAGGEDPKT () {	0x80;}
}
unless(defined(&BGE_MACMODE_TX_BURST_ENB)) {
    sub BGE_MACMODE_TX_BURST_ENB () {	0x100;}
}
unless(defined(&BGE_MACMODE_MAX_DEFER)) {
    sub BGE_MACMODE_MAX_DEFER () {	0x200;}
}
unless(defined(&BGE_MACMODE_LINK_POLARITY)) {
    sub BGE_MACMODE_LINK_POLARITY () {	0x400;}
}
unless(defined(&BGE_MACMODE_RX_STATS_ENB)) {
    sub BGE_MACMODE_RX_STATS_ENB () {	0x800;}
}
unless(defined(&BGE_MACMODE_RX_STATS_CLEAR)) {
    sub BGE_MACMODE_RX_STATS_CLEAR () {	0x1000;}
}
unless(defined(&BGE_MACMODE_RX_STATS_FLUSH)) {
    sub BGE_MACMODE_RX_STATS_FLUSH () {	0x2000;}
}
unless(defined(&BGE_MACMODE_TX_STATS_ENB)) {
    sub BGE_MACMODE_TX_STATS_ENB () {	0x4000;}
}
unless(defined(&BGE_MACMODE_TX_STATS_CLEAR)) {
    sub BGE_MACMODE_TX_STATS_CLEAR () {	0x8000;}
}
unless(defined(&BGE_MACMODE_TX_STATS_FLUSH)) {
    sub BGE_MACMODE_TX_STATS_FLUSH () {	0x10000;}
}
unless(defined(&BGE_MACMODE_TBI_SEND_CFGS)) {
    sub BGE_MACMODE_TBI_SEND_CFGS () {	0x20000;}
}
unless(defined(&BGE_MACMODE_MAGIC_PKT_ENB)) {
    sub BGE_MACMODE_MAGIC_PKT_ENB () {	0x40000;}
}
unless(defined(&BGE_MACMODE_ACPI_PWRON_ENB)) {
    sub BGE_MACMODE_ACPI_PWRON_ENB () {	0x80000;}
}
unless(defined(&BGE_MACMODE_MIP_ENB)) {
    sub BGE_MACMODE_MIP_ENB () {	0x100000;}
}
unless(defined(&BGE_MACMODE_TXDMA_ENB)) {
    sub BGE_MACMODE_TXDMA_ENB () {	0x200000;}
}
unless(defined(&BGE_MACMODE_RXDMA_ENB)) {
    sub BGE_MACMODE_RXDMA_ENB () {	0x400000;}
}
unless(defined(&BGE_MACMODE_FRMHDR_DMA_ENB)) {
    sub BGE_MACMODE_FRMHDR_DMA_ENB () {	0x800000;}
}
unless(defined(&BGE_PORTMODE_NONE)) {
    sub BGE_PORTMODE_NONE () {	0x;}
}
unless(defined(&BGE_PORTMODE_MII)) {
    sub BGE_PORTMODE_MII () {	0x4;}
}
unless(defined(&BGE_PORTMODE_GMII)) {
    sub BGE_PORTMODE_GMII () {	0x8;}
}
unless(defined(&BGE_PORTMODE_TBI)) {
    sub BGE_PORTMODE_TBI () {	0xc;}
}
unless(defined(&BGE_MACSTAT_TBI_PCS_SYNCHED)) {
    sub BGE_MACSTAT_TBI_PCS_SYNCHED () {	0x1;}
}
unless(defined(&BGE_MACSTAT_TBI_SIGNAL_DETECT)) {
    sub BGE_MACSTAT_TBI_SIGNAL_DETECT () {	0x2;}
}
unless(defined(&BGE_MACSTAT_RX_CFG)) {
    sub BGE_MACSTAT_RX_CFG () {	0x4;}
}
unless(defined(&BGE_MACSTAT_CFG_CHANGED)) {
    sub BGE_MACSTAT_CFG_CHANGED () {	0x8;}
}
unless(defined(&BGE_MACSTAT_SYNC_CHANGED)) {
    sub BGE_MACSTAT_SYNC_CHANGED () {	0x10;}
}
unless(defined(&BGE_MACSTAT_PORT_DECODE_ERROR)) {
    sub BGE_MACSTAT_PORT_DECODE_ERROR () {	0x400;}
}
unless(defined(&BGE_MACSTAT_LINK_CHANGED)) {
    sub BGE_MACSTAT_LINK_CHANGED () {	0x1000;}
}
unless(defined(&BGE_MACSTAT_MI_COMPLETE)) {
    sub BGE_MACSTAT_MI_COMPLETE () {	0x400000;}
}
unless(defined(&BGE_MACSTAT_MI_INTERRUPT)) {
    sub BGE_MACSTAT_MI_INTERRUPT () {	0x800000;}
}
unless(defined(&BGE_MACSTAT_AUTOPOLL_ERROR)) {
    sub BGE_MACSTAT_AUTOPOLL_ERROR () {	0x1000000;}
}
unless(defined(&BGE_MACSTAT_ODI_ERROR)) {
    sub BGE_MACSTAT_ODI_ERROR () {	0x2000000;}
}
unless(defined(&BGE_MACSTAT_RXSTAT_OFLOW)) {
    sub BGE_MACSTAT_RXSTAT_OFLOW () {	0x4000000;}
}
unless(defined(&BGE_MACSTAT_TXSTAT_OFLOW)) {
    sub BGE_MACSTAT_TXSTAT_OFLOW () {	0x8000000;}
}
unless(defined(&BGE_EVTENB_PORT_DECODE_ERROR)) {
    sub BGE_EVTENB_PORT_DECODE_ERROR () {	0x400;}
}
unless(defined(&BGE_EVTENB_LINK_CHANGED)) {
    sub BGE_EVTENB_LINK_CHANGED () {	0x1000;}
}
unless(defined(&BGE_EVTENB_MI_COMPLETE)) {
    sub BGE_EVTENB_MI_COMPLETE () {	0x400000;}
}
unless(defined(&BGE_EVTENB_MI_INTERRUPT)) {
    sub BGE_EVTENB_MI_INTERRUPT () {	0x800000;}
}
unless(defined(&BGE_EVTENB_AUTOPOLL_ERROR)) {
    sub BGE_EVTENB_AUTOPOLL_ERROR () {	0x1000000;}
}
unless(defined(&BGE_EVTENB_ODI_ERROR)) {
    sub BGE_EVTENB_ODI_ERROR () {	0x2000000;}
}
unless(defined(&BGE_EVTENB_RXSTAT_OFLOW)) {
    sub BGE_EVTENB_RXSTAT_OFLOW () {	0x4000000;}
}
unless(defined(&BGE_EVTENB_TXSTAT_OFLOW)) {
    sub BGE_EVTENB_TXSTAT_OFLOW () {	0x8000000;}
}
unless(defined(&BGE_LEDCTL_LINKLED_OVERRIDE)) {
    sub BGE_LEDCTL_LINKLED_OVERRIDE () {	0x1;}
}
unless(defined(&BGE_LEDCTL_1000MBPS_LED)) {
    sub BGE_LEDCTL_1000MBPS_LED () {	0x2;}
}
unless(defined(&BGE_LEDCTL_100MBPS_LED)) {
    sub BGE_LEDCTL_100MBPS_LED () {	0x4;}
}
unless(defined(&BGE_LEDCTL_10MBPS_LED)) {
    sub BGE_LEDCTL_10MBPS_LED () {	0x8;}
}
unless(defined(&BGE_LEDCTL_TRAFLED_OVERRIDE)) {
    sub BGE_LEDCTL_TRAFLED_OVERRIDE () {	0x10;}
}
unless(defined(&BGE_LEDCTL_TRAFLED_BLINK)) {
    sub BGE_LEDCTL_TRAFLED_BLINK () {	0x20;}
}
unless(defined(&BGE_LEDCTL_TREFLED_BLINK_2)) {
    sub BGE_LEDCTL_TREFLED_BLINK_2 () {	0x40;}
}
unless(defined(&BGE_LEDCTL_1000MBPS_STS)) {
    sub BGE_LEDCTL_1000MBPS_STS () {	0x80;}
}
unless(defined(&BGE_LEDCTL_100MBPS_STS)) {
    sub BGE_LEDCTL_100MBPS_STS () {	0x100;}
}
unless(defined(&BGE_LEDCTL_10MBPS_STS)) {
    sub BGE_LEDCTL_10MBPS_STS () {	0x200;}
}
unless(defined(&BGE_LEDCTL_TRADLED_STS)) {
    sub BGE_LEDCTL_TRADLED_STS () {	0x400;}
}
unless(defined(&BGE_LEDCTL_BLINKPERIOD)) {
    sub BGE_LEDCTL_BLINKPERIOD () {	0x7ff80000;}
}
unless(defined(&BGE_LEDCTL_BLINKPERIOD_OVERRIDE)) {
    sub BGE_LEDCTL_BLINKPERIOD_OVERRIDE () {	0x80000000;}
}
unless(defined(&BGE_TX_BACKOFF_SEED_MASK)) {
    sub BGE_TX_BACKOFF_SEED_MASK () {	0x3f;}
}
unless(defined(&BGE_AUTOPOLLSTS_ERROR)) {
    sub BGE_AUTOPOLLSTS_ERROR () {	0x1;}
}
unless(defined(&BGE_TXMODE_RESET)) {
    sub BGE_TXMODE_RESET () {	0x1;}
}
unless(defined(&BGE_TXMODE_ENABLE)) {
    sub BGE_TXMODE_ENABLE () {	0x2;}
}
unless(defined(&BGE_TXMODE_FLOWCTL_ENABLE)) {
    sub BGE_TXMODE_FLOWCTL_ENABLE () {	0x10;}
}
unless(defined(&BGE_TXMODE_BIGBACKOFF_ENABLE)) {
    sub BGE_TXMODE_BIGBACKOFF_ENABLE () {	0x20;}
}
unless(defined(&BGE_TXMODE_LONGPAUSE_ENABLE)) {
    sub BGE_TXMODE_LONGPAUSE_ENABLE () {	0x40;}
}
unless(defined(&BGE_TXSTAT_RX_XOFFED)) {
    sub BGE_TXSTAT_RX_XOFFED () {	0x1;}
}
unless(defined(&BGE_TXSTAT_SENT_XOFF)) {
    sub BGE_TXSTAT_SENT_XOFF () {	0x2;}
}
unless(defined(&BGE_TXSTAT_SENT_XON)) {
    sub BGE_TXSTAT_SENT_XON () {	0x4;}
}
unless(defined(&BGE_TXSTAT_LINK_UP)) {
    sub BGE_TXSTAT_LINK_UP () {	0x8;}
}
unless(defined(&BGE_TXSTAT_ODI_UFLOW)) {
    sub BGE_TXSTAT_ODI_UFLOW () {	0x10;}
}
unless(defined(&BGE_TXSTAT_ODI_OFLOW)) {
    sub BGE_TXSTAT_ODI_OFLOW () {	0x20;}
}
unless(defined(&BGE_TXLEN_SLOTTIME)) {
    sub BGE_TXLEN_SLOTTIME () {	0xff;}
}
unless(defined(&BGE_TXLEN_IPG)) {
    sub BGE_TXLEN_IPG () {	0xf00;}
}
unless(defined(&BGE_TXLEN_CRS)) {
    sub BGE_TXLEN_CRS () {	0x3000;}
}
unless(defined(&BGE_RXMODE_RESET)) {
    sub BGE_RXMODE_RESET () {	0x1;}
}
unless(defined(&BGE_RXMODE_ENABLE)) {
    sub BGE_RXMODE_ENABLE () {	0x2;}
}
unless(defined(&BGE_RXMODE_FLOWCTL_ENABLE)) {
    sub BGE_RXMODE_FLOWCTL_ENABLE () {	0x4;}
}
unless(defined(&BGE_RXMODE_RX_GIANTS)) {
    sub BGE_RXMODE_RX_GIANTS () {	0x20;}
}
unless(defined(&BGE_RXMODE_RX_RUNTS)) {
    sub BGE_RXMODE_RX_RUNTS () {	0x40;}
}
unless(defined(&BGE_RXMODE_8022_LENCHECK)) {
    sub BGE_RXMODE_8022_LENCHECK () {	0x80;}
}
unless(defined(&BGE_RXMODE_RX_PROMISC)) {
    sub BGE_RXMODE_RX_PROMISC () {	0x100;}
}
unless(defined(&BGE_RXMODE_RX_NO_CRC_CHECK)) {
    sub BGE_RXMODE_RX_NO_CRC_CHECK () {	0x200;}
}
unless(defined(&BGE_RXMODE_RX_KEEP_VLAN_DIAG)) {
    sub BGE_RXMODE_RX_KEEP_VLAN_DIAG () {	0x400;}
}
unless(defined(&BGE_RXMODE_RX_IPV6_CSUM_ENABLE)) {
    sub BGE_RXMODE_RX_IPV6_CSUM_ENABLE () {	0x1000000;}
}
unless(defined(&BGE_RXSTAT_REMOTE_XOFFED)) {
    sub BGE_RXSTAT_REMOTE_XOFFED () {	0x1;}
}
unless(defined(&BGE_RXSTAT_RCVD_XOFF)) {
    sub BGE_RXSTAT_RCVD_XOFF () {	0x2;}
}
unless(defined(&BGE_RXSTAT_RCVD_XON)) {
    sub BGE_RXSTAT_RCVD_XON () {	0x4;}
}
unless(defined(&BGE_RXRULECTL_OFFSET)) {
    sub BGE_RXRULECTL_OFFSET () {	0xff;}
}
unless(defined(&BGE_RXRULECTL_CLASS)) {
    sub BGE_RXRULECTL_CLASS () {	0x1f00;}
}
unless(defined(&BGE_RXRULECTL_HDRTYPE)) {
    sub BGE_RXRULECTL_HDRTYPE () {	0xe000;}
}
unless(defined(&BGE_RXRULECTL_COMPARE_OP)) {
    sub BGE_RXRULECTL_COMPARE_OP () {	0x30000;}
}
unless(defined(&BGE_RXRULECTL_MAP)) {
    sub BGE_RXRULECTL_MAP () {	0x1000000;}
}
unless(defined(&BGE_RXRULECTL_DISCARD)) {
    sub BGE_RXRULECTL_DISCARD () {	0x2000000;}
}
unless(defined(&BGE_RXRULECTL_MASK)) {
    sub BGE_RXRULECTL_MASK () {	0x4000000;}
}
unless(defined(&BGE_RXRULECTL_ACTIVATE_PROC3)) {
    sub BGE_RXRULECTL_ACTIVATE_PROC3 () {	0x8000000;}
}
unless(defined(&BGE_RXRULECTL_ACTIVATE_PROC2)) {
    sub BGE_RXRULECTL_ACTIVATE_PROC2 () {	0x10000000;}
}
unless(defined(&BGE_RXRULECTL_ACTIVATE_PROC1)) {
    sub BGE_RXRULECTL_ACTIVATE_PROC1 () {	0x20000000;}
}
unless(defined(&BGE_RXRULECTL_ANDWITHNEXT)) {
    sub BGE_RXRULECTL_ANDWITHNEXT () {	0x40000000;}
}
unless(defined(&BGE_RXRULEMASK_VALUE)) {
    sub BGE_RXRULEMASK_VALUE () {	0xffff;}
}
unless(defined(&BGE_RXRULEMASK_MASKVAL)) {
    sub BGE_RXRULEMASK_MASKVAL () {	0xffff0000;}
}
unless(defined(&BGE_SERDESCFG_RXR)) {
    sub BGE_SERDESCFG_RXR () {	0x7;}
}
unless(defined(&BGE_SERDESCFG_RXG)) {
    sub BGE_SERDESCFG_RXG () {	0x18;}
}
unless(defined(&BGE_SERDESCFG_RXEDGESEL)) {
    sub BGE_SERDESCFG_RXEDGESEL () {	0x40;}
}
unless(defined(&BGE_SERDESCFG_TX_BIAS)) {
    sub BGE_SERDESCFG_TX_BIAS () {	0x380;}
}
unless(defined(&BGE_SERDESCFG_IBMAX)) {
    sub BGE_SERDESCFG_IBMAX () {	0x400;}
}
unless(defined(&BGE_SERDESCFG_IBMIN)) {
    sub BGE_SERDESCFG_IBMIN () {	0x800;}
}
unless(defined(&BGE_SERDESCFG_TXMODE)) {
    sub BGE_SERDESCFG_TXMODE () {	0x1000;}
}
unless(defined(&BGE_SERDESCFG_TXEDGESEL)) {
    sub BGE_SERDESCFG_TXEDGESEL () {	0x2000;}
}
unless(defined(&BGE_SERDESCFG_MODE)) {
    sub BGE_SERDESCFG_MODE () {	0x4000;}
}
unless(defined(&BGE_SERDESCFG_PLLTEST)) {
    sub BGE_SERDESCFG_PLLTEST () {	0x8000;}
}
unless(defined(&BGE_SERDESCFG_CDET)) {
    sub BGE_SERDESCFG_CDET () {	0x10000;}
}
unless(defined(&BGE_SERDESCFG_TBILOOP)) {
    sub BGE_SERDESCFG_TBILOOP () {	0x20000;}
}
unless(defined(&BGE_SERDESCFG_REMLOOP)) {
    sub BGE_SERDESCFG_REMLOOP () {	0x40000;}
}
unless(defined(&BGE_SERDESCFG_INVPHASE)) {
    sub BGE_SERDESCFG_INVPHASE () {	0x80000;}
}
unless(defined(&BGE_SERDESCFG_12REGCTL)) {
    sub BGE_SERDESCFG_12REGCTL () {	0x300000;}
}
unless(defined(&BGE_SERDESCFG_REGCTL)) {
    sub BGE_SERDESCFG_REGCTL () {	0xc00000;}
}
unless(defined(&BGE_SERDESSTS_RXSTAT)) {
    sub BGE_SERDESSTS_RXSTAT () {	0xf;}
}
unless(defined(&BGE_SERDESSTS_CDET)) {
    sub BGE_SERDESSTS_CDET () {	0x10;}
}
unless(defined(&BGE_PHYCFG1_RGMII_INT)) {
    sub BGE_PHYCFG1_RGMII_INT () {	0x1;}
}
unless(defined(&BGE_PHYCFG1_RGMII_EXT_RX_DEC)) {
    sub BGE_PHYCFG1_RGMII_EXT_RX_DEC () {	0x2000000;}
}
unless(defined(&BGE_PHYCFG1_RGMII_SND_STAT_EN)) {
    sub BGE_PHYCFG1_RGMII_SND_STAT_EN () {	0x4000000;}
}
unless(defined(&BGE_PHYCFG1_TXC_DRV)) {
    sub BGE_PHYCFG1_TXC_DRV () {	0x20000000;}
}
unless(defined(&BGE_PHYCFG2_INBAND_ENABLE)) {
    sub BGE_PHYCFG2_INBAND_ENABLE () {	0x1;}
}
unless(defined(&BGE_PHYCFG2_EMODE_MASK_MASK)) {
    sub BGE_PHYCFG2_EMODE_MASK_MASK () {	0x1c0;}
}
unless(defined(&BGE_PHYCFG2_EMODE_MASK_AC131)) {
    sub BGE_PHYCFG2_EMODE_MASK_AC131 () {	0xc0;}
}
unless(defined(&BGE_PHYCFG2_EMODE_MASK_50610)) {
    sub BGE_PHYCFG2_EMODE_MASK_50610 () {	0x100;}
}
unless(defined(&BGE_PHYCFG2_EMODE_MASK_RT8211)) {
    sub BGE_PHYCFG2_EMODE_MASK_RT8211 () {	0x;}
}
unless(defined(&BGE_PHYCFG2_EMODE_MASK_RT8201)) {
    sub BGE_PHYCFG2_EMODE_MASK_RT8201 () {	0x1c0;}
}
unless(defined(&BGE_PHYCFG2_EMODE_COMP_MASK)) {
    sub BGE_PHYCFG2_EMODE_COMP_MASK () {	0xe00;}
}
unless(defined(&BGE_PHYCFG2_EMODE_COMP_AC131)) {
    sub BGE_PHYCFG2_EMODE_COMP_AC131 () {	0x600;}
}
unless(defined(&BGE_PHYCFG2_EMODE_COMP_50610)) {
    sub BGE_PHYCFG2_EMODE_COMP_50610 () {	0x400;}
}
unless(defined(&BGE_PHYCFG2_EMODE_COMP_RT8211)) {
    sub BGE_PHYCFG2_EMODE_COMP_RT8211 () {	0x800;}
}
unless(defined(&BGE_PHYCFG2_EMODE_COMP_RT8201)) {
    sub BGE_PHYCFG2_EMODE_COMP_RT8201 () {	0x;}
}
unless(defined(&BGE_PHYCFG2_FMODE_MASK_MASK)) {
    sub BGE_PHYCFG2_FMODE_MASK_MASK () {	0x7000;}
}
unless(defined(&BGE_PHYCFG2_FMODE_MASK_AC131)) {
    sub BGE_PHYCFG2_FMODE_MASK_AC131 () {	0x6000;}
}
unless(defined(&BGE_PHYCFG2_FMODE_MASK_50610)) {
    sub BGE_PHYCFG2_FMODE_MASK_50610 () {	0x4000;}
}
unless(defined(&BGE_PHYCFG2_FMODE_MASK_RT8211)) {
    sub BGE_PHYCFG2_FMODE_MASK_RT8211 () {	0x;}
}
unless(defined(&BGE_PHYCFG2_FMODE_MASK_RT8201)) {
    sub BGE_PHYCFG2_FMODE_MASK_RT8201 () {	0x7000;}
}
unless(defined(&BGE_PHYCFG2_FMODE_COMP_MASK)) {
    sub BGE_PHYCFG2_FMODE_COMP_MASK () {	0x38000;}
}
unless(defined(&BGE_PHYCFG2_FMODE_COMP_AC131)) {
    sub BGE_PHYCFG2_FMODE_COMP_AC131 () {	0x30000;}
}
unless(defined(&BGE_PHYCFG2_FMODE_COMP_50610)) {
    sub BGE_PHYCFG2_FMODE_COMP_50610 () {	0x8000;}
}
unless(defined(&BGE_PHYCFG2_FMODE_COMP_RT8211)) {
    sub BGE_PHYCFG2_FMODE_COMP_RT8211 () {	0x38000;}
}
unless(defined(&BGE_PHYCFG2_FMODE_COMP_RT8201)) {
    sub BGE_PHYCFG2_FMODE_COMP_RT8201 () {	0x;}
}
unless(defined(&BGE_PHYCFG2_GMODE_MASK_MASK)) {
    sub BGE_PHYCFG2_GMODE_MASK_MASK () {	0x1c0000;}
}
unless(defined(&BGE_PHYCFG2_GMODE_MASK_AC131)) {
    sub BGE_PHYCFG2_GMODE_MASK_AC131 () {	0x1c0000;}
}
unless(defined(&BGE_PHYCFG2_GMODE_MASK_50610)) {
    sub BGE_PHYCFG2_GMODE_MASK_50610 () {	0x100000;}
}
unless(defined(&BGE_PHYCFG2_GMODE_MASK_RT8211)) {
    sub BGE_PHYCFG2_GMODE_MASK_RT8211 () {	0x;}
}
unless(defined(&BGE_PHYCFG2_GMODE_MASK_RT8201)) {
    sub BGE_PHYCFG2_GMODE_MASK_RT8201 () {	0x1c0000;}
}
unless(defined(&BGE_PHYCFG2_GMODE_COMP_MASK)) {
    sub BGE_PHYCFG2_GMODE_COMP_MASK () {	0xe00000;}
}
unless(defined(&BGE_PHYCFG2_GMODE_COMP_AC131)) {
    sub BGE_PHYCFG2_GMODE_COMP_AC131 () {	0xe00000;}
}
unless(defined(&BGE_PHYCFG2_GMODE_COMP_50610)) {
    sub BGE_PHYCFG2_GMODE_COMP_50610 () {	0x;}
}
unless(defined(&BGE_PHYCFG2_GMODE_COMP_RT8211)) {
    sub BGE_PHYCFG2_GMODE_COMP_RT8211 () {	0x200000;}
}
unless(defined(&BGE_PHYCFG2_GMODE_COMP_RT8201)) {
    sub BGE_PHYCFG2_GMODE_COMP_RT8201 () {	0x;}
}
unless(defined(&BGE_PHYCFG2_ACT_MASK_MASK)) {
    sub BGE_PHYCFG2_ACT_MASK_MASK () {	0x3000000;}
}
unless(defined(&BGE_PHYCFG2_ACT_MASK_AC131)) {
    sub BGE_PHYCFG2_ACT_MASK_AC131 () {	0x3000000;}
}
unless(defined(&BGE_PHYCFG2_ACT_MASK_50610)) {
    sub BGE_PHYCFG2_ACT_MASK_50610 () {	0x1000000;}
}
unless(defined(&BGE_PHYCFG2_ACT_MASK_RT8211)) {
    sub BGE_PHYCFG2_ACT_MASK_RT8211 () {	0x3000000;}
}
unless(defined(&BGE_PHYCFG2_ACT_MASK_RT8201)) {
    sub BGE_PHYCFG2_ACT_MASK_RT8201 () {	0x1000000;}
}
unless(defined(&BGE_PHYCFG2_ACT_COMP_MASK)) {
    sub BGE_PHYCFG2_ACT_COMP_MASK () {	0xc000000;}
}
unless(defined(&BGE_PHYCFG2_ACT_COMP_AC131)) {
    sub BGE_PHYCFG2_ACT_COMP_AC131 () {	0x;}
}
unless(defined(&BGE_PHYCFG2_ACT_COMP_50610)) {
    sub BGE_PHYCFG2_ACT_COMP_50610 () {	0x;}
}
unless(defined(&BGE_PHYCFG2_ACT_COMP_RT8211)) {
    sub BGE_PHYCFG2_ACT_COMP_RT8211 () {	0x;}
}
unless(defined(&BGE_PHYCFG2_ACT_COMP_RT8201)) {
    sub BGE_PHYCFG2_ACT_COMP_RT8201 () {	0x8000000;}
}
unless(defined(&BGE_PHYCFG2_QUAL_MASK_MASK)) {
    sub BGE_PHYCFG2_QUAL_MASK_MASK () {	0x30000000;}
}
unless(defined(&BGE_PHYCFG2_QUAL_MASK_AC131)) {
    sub BGE_PHYCFG2_QUAL_MASK_AC131 () {	0x30000000;}
}
unless(defined(&BGE_PHYCFG2_QUAL_MASK_50610)) {
    sub BGE_PHYCFG2_QUAL_MASK_50610 () {	0x30000000;}
}
unless(defined(&BGE_PHYCFG2_QUAL_MASK_RT8211)) {
    sub BGE_PHYCFG2_QUAL_MASK_RT8211 () {	0x30000000;}
}
unless(defined(&BGE_PHYCFG2_QUAL_MASK_RT8201)) {
    sub BGE_PHYCFG2_QUAL_MASK_RT8201 () {	0x30000000;}
}
unless(defined(&BGE_PHYCFG2_QUAL_COMP_MASK)) {
    sub BGE_PHYCFG2_QUAL_COMP_MASK () {	0xc0000000;}
}
unless(defined(&BGE_PHYCFG2_QUAL_COMP_AC131)) {
    sub BGE_PHYCFG2_QUAL_COMP_AC131 () {	0x;}
}
unless(defined(&BGE_PHYCFG2_QUAL_COMP_50610)) {
    sub BGE_PHYCFG2_QUAL_COMP_50610 () {	0x;}
}
unless(defined(&BGE_PHYCFG2_QUAL_COMP_RT8211)) {
    sub BGE_PHYCFG2_QUAL_COMP_RT8211 () {	0x;}
}
unless(defined(&BGE_PHYCFG2_QUAL_COMP_RT8201)) {
    sub BGE_PHYCFG2_QUAL_COMP_RT8201 () {	0x;}
}
unless(defined(&BGE_PHYCFG2_50610_LED_MODES)) {
    sub BGE_PHYCFG2_50610_LED_MODES () {	( &BGE_PHYCFG2_EMODE_MASK_50610 |  &BGE_PHYCFG2_EMODE_COMP_50610 |  &BGE_PHYCFG2_FMODE_MASK_50610 |  &BGE_PHYCFG2_FMODE_COMP_50610 |  &BGE_PHYCFG2_GMODE_MASK_50610 |  &BGE_PHYCFG2_GMODE_COMP_50610 |  &BGE_PHYCFG2_ACT_MASK_50610 |  &BGE_PHYCFG2_ACT_COMP_50610 |  &BGE_PHYCFG2_QUAL_MASK_50610 |  &BGE_PHYCFG2_QUAL_COMP_50610);}
}
unless(defined(&BGE_PHYCFG2_AC131_LED_MODES)) {
    sub BGE_PHYCFG2_AC131_LED_MODES () {	( &BGE_PHYCFG2_EMODE_MASK_AC131 |  &BGE_PHYCFG2_EMODE_COMP_AC131 |  &BGE_PHYCFG2_FMODE_MASK_AC131 |  &BGE_PHYCFG2_FMODE_COMP_AC131 |  &BGE_PHYCFG2_GMODE_MASK_AC131 |  &BGE_PHYCFG2_GMODE_COMP_AC131 |  &BGE_PHYCFG2_ACT_MASK_AC131 |  &BGE_PHYCFG2_ACT_COMP_AC131 |  &BGE_PHYCFG2_QUAL_MASK_AC131 |  &BGE_PHYCFG2_QUAL_COMP_AC131);}
}
unless(defined(&BGE_PHYCFG2_RTL8211C_LED_MODES)) {
    sub BGE_PHYCFG2_RTL8211C_LED_MODES () {	( &BGE_PHYCFG2_EMODE_MASK_RT8211 |  &BGE_PHYCFG2_EMODE_COMP_RT8211 |  &BGE_PHYCFG2_FMODE_MASK_RT8211 |  &BGE_PHYCFG2_FMODE_COMP_RT8211 |  &BGE_PHYCFG2_GMODE_MASK_RT8211 |  &BGE_PHYCFG2_GMODE_COMP_RT8211 |  &BGE_PHYCFG2_ACT_MASK_RT8211 |  &BGE_PHYCFG2_ACT_COMP_RT8211 |  &BGE_PHYCFG2_QUAL_MASK_RT8211 |  &BGE_PHYCFG2_QUAL_COMP_RT8211);}
}
unless(defined(&BGE_PHYCFG2_RTL8201E_LED_MODES)) {
    sub BGE_PHYCFG2_RTL8201E_LED_MODES () {	( &BGE_PHYCFG2_EMODE_MASK_RT8201 |  &BGE_PHYCFG2_EMODE_COMP_RT8201 |  &BGE_PHYCFG2_FMODE_MASK_RT8201 |  &BGE_PHYCFG2_FMODE_COMP_RT8201 |  &BGE_PHYCFG2_GMODE_MASK_RT8201 |  &BGE_PHYCFG2_GMODE_COMP_RT8201 |  &BGE_PHYCFG2_ACT_MASK_RT8201 |  &BGE_PHYCFG2_ACT_COMP_RT8201 |  &BGE_PHYCFG2_QUAL_MASK_RT8201 |  &BGE_PHYCFG2_QUAL_COMP_RT8201);}
}
unless(defined(&BGE_RGMII_MODE_TX_ENABLE)) {
    sub BGE_RGMII_MODE_TX_ENABLE () {	0x1;}
}
unless(defined(&BGE_RGMII_MODE_TX_LOWPWR)) {
    sub BGE_RGMII_MODE_TX_LOWPWR () {	0x2;}
}
unless(defined(&BGE_RGMII_MODE_TX_RESET)) {
    sub BGE_RGMII_MODE_TX_RESET () {	0x4;}
}
unless(defined(&BGE_RGMII_MODE_RX_INT_B)) {
    sub BGE_RGMII_MODE_RX_INT_B () {	0x100;}
}
unless(defined(&BGE_RGMII_MODE_RX_QUALITY)) {
    sub BGE_RGMII_MODE_RX_QUALITY () {	0x200;}
}
unless(defined(&BGE_RGMII_MODE_RX_ACTIVITY)) {
    sub BGE_RGMII_MODE_RX_ACTIVITY () {	0x400;}
}
unless(defined(&BGE_RGMII_MODE_RX_ENG_DET)) {
    sub BGE_RGMII_MODE_RX_ENG_DET () {	0x800;}
}
unless(defined(&BGE_SGDIGCFG_PAUSE_CAP)) {
    sub BGE_SGDIGCFG_PAUSE_CAP () {	0x800;}
}
unless(defined(&BGE_SGDIGCFG_ASYM_PAUSE)) {
    sub BGE_SGDIGCFG_ASYM_PAUSE () {	0x1000;}
}
unless(defined(&BGE_SGDIGCFG_SEND)) {
    sub BGE_SGDIGCFG_SEND () {	0x40000000;}
}
unless(defined(&BGE_SGDIGCFG_AUTO)) {
    sub BGE_SGDIGCFG_AUTO () {	0x80000000;}
}
unless(defined(&BGE_SGDIGSTS_PAUSE_CAP)) {
    sub BGE_SGDIGSTS_PAUSE_CAP () {	0x80000;}
}
unless(defined(&BGE_SGDIGSTS_ASYM_PAUSE)) {
    sub BGE_SGDIGSTS_ASYM_PAUSE () {	0x100000;}
}
unless(defined(&BGE_SGDIGSTS_DONE)) {
    sub BGE_SGDIGSTS_DONE () {	0x2;}
}
unless(defined(&BGE_MICOMM_DATA)) {
    sub BGE_MICOMM_DATA () {	0xffff;}
}
unless(defined(&BGE_MICOMM_REG)) {
    sub BGE_MICOMM_REG () {	0x1f0000;}
}
unless(defined(&BGE_MICOMM_PHY)) {
    sub BGE_MICOMM_PHY () {	0x3e00000;}
}
unless(defined(&BGE_MICOMM_CMD)) {
    sub BGE_MICOMM_CMD () {	0xc000000;}
}
unless(defined(&BGE_MICOMM_READFAIL)) {
    sub BGE_MICOMM_READFAIL () {	0x10000000;}
}
unless(defined(&BGE_MICOMM_BUSY)) {
    sub BGE_MICOMM_BUSY () {	0x20000000;}
}
unless(defined(&BGE_MIREG)) {
    sub BGE_MIREG {
	my($x) = @_;
	eval q((($x & 0x1f) << 16));
    }
}
unless(defined(&BGE_MIPHY)) {
    sub BGE_MIPHY {
	my($x) = @_;
	eval q((($x & 0x1f) << 21));
    }
}
unless(defined(&BGE_MICMD_WRITE)) {
    sub BGE_MICMD_WRITE () {	0x4000000;}
}
unless(defined(&BGE_MICMD_READ)) {
    sub BGE_MICMD_READ () {	0x8000000;}
}
unless(defined(&BGE_MISTS_LINK)) {
    sub BGE_MISTS_LINK () {	0x1;}
}
unless(defined(&BGE_MISTS_10MBPS)) {
    sub BGE_MISTS_10MBPS () {	0x2;}
}
unless(defined(&BGE_MIMODE_SHORTPREAMBLE)) {
    sub BGE_MIMODE_SHORTPREAMBLE () {	0x2;}
}
unless(defined(&BGE_MIMODE_AUTOPOLL)) {
    sub BGE_MIMODE_AUTOPOLL () {	0x10;}
}
unless(defined(&BGE_MIMODE_500KHZ_CONST)) {
    sub BGE_MIMODE_500KHZ_CONST () {	0x8000;}
}
unless(defined(&BGE_MIMODE_CLKCNT)) {
    sub BGE_MIMODE_CLKCNT () {	0x1f0000;}
}
unless(defined(&BGE_MIMODE_BASE)) {
    sub BGE_MIMODE_BASE () {	0xc0000;}
}
unless(defined(&BGE_SDI_MODE)) {
    sub BGE_SDI_MODE () {	0xc00;}
}
unless(defined(&BGE_SDI_STATUS)) {
    sub BGE_SDI_STATUS () {	0xc04;}
}
unless(defined(&BGE_SDI_STATS_CTL)) {
    sub BGE_SDI_STATS_CTL () {	0xc08;}
}
unless(defined(&BGE_SDI_STATS_ENABLE_MASK)) {
    sub BGE_SDI_STATS_ENABLE_MASK () {	0xc0c;}
}
unless(defined(&BGE_SDI_STATS_INCREMENT_MASK)) {
    sub BGE_SDI_STATS_INCREMENT_MASK () {	0xc10;}
}
unless(defined(&BGE_ISO_PKT_TX)) {
    sub BGE_ISO_PKT_TX () {	0xc20;}
}
unless(defined(&BGE_LOCSTATS_COS0)) {
    sub BGE_LOCSTATS_COS0 () {	0xc80;}
}
unless(defined(&BGE_LOCSTATS_COS1)) {
    sub BGE_LOCSTATS_COS1 () {	0xc84;}
}
unless(defined(&BGE_LOCSTATS_COS2)) {
    sub BGE_LOCSTATS_COS2 () {	0xc88;}
}
unless(defined(&BGE_LOCSTATS_COS3)) {
    sub BGE_LOCSTATS_COS3 () {	0xc8c;}
}
unless(defined(&BGE_LOCSTATS_COS4)) {
    sub BGE_LOCSTATS_COS4 () {	0xc90;}
}
unless(defined(&BGE_LOCSTATS_COS5)) {
    sub BGE_LOCSTATS_COS5 () {	0xc84;}
}
unless(defined(&BGE_LOCSTATS_COS6)) {
    sub BGE_LOCSTATS_COS6 () {	0xc98;}
}
unless(defined(&BGE_LOCSTATS_COS7)) {
    sub BGE_LOCSTATS_COS7 () {	0xc9c;}
}
unless(defined(&BGE_LOCSTATS_COS8)) {
    sub BGE_LOCSTATS_COS8 () {	0xca0;}
}
unless(defined(&BGE_LOCSTATS_COS9)) {
    sub BGE_LOCSTATS_COS9 () {	0xca4;}
}
unless(defined(&BGE_LOCSTATS_COS10)) {
    sub BGE_LOCSTATS_COS10 () {	0xca8;}
}
unless(defined(&BGE_LOCSTATS_COS11)) {
    sub BGE_LOCSTATS_COS11 () {	0xcac;}
}
unless(defined(&BGE_LOCSTATS_COS12)) {
    sub BGE_LOCSTATS_COS12 () {	0xcb0;}
}
unless(defined(&BGE_LOCSTATS_COS13)) {
    sub BGE_LOCSTATS_COS13 () {	0xcb4;}
}
unless(defined(&BGE_LOCSTATS_COS14)) {
    sub BGE_LOCSTATS_COS14 () {	0xcb8;}
}
unless(defined(&BGE_LOCSTATS_COS15)) {
    sub BGE_LOCSTATS_COS15 () {	0xcbc;}
}
unless(defined(&BGE_LOCSTATS_DMA_RQ_FULL)) {
    sub BGE_LOCSTATS_DMA_RQ_FULL () {	0xcc0;}
}
unless(defined(&BGE_LOCSTATS_DMA_HIPRIO_RQ_FULL)) {
    sub BGE_LOCSTATS_DMA_HIPRIO_RQ_FULL () {	0xcc4;}
}
unless(defined(&BGE_LOCSTATS_SDC_QUEUE_FULL)) {
    sub BGE_LOCSTATS_SDC_QUEUE_FULL () {	0xcc8;}
}
unless(defined(&BGE_LOCSTATS_NIC_SENDPROD_SET)) {
    sub BGE_LOCSTATS_NIC_SENDPROD_SET () {	0xccc;}
}
unless(defined(&BGE_LOCSTATS_STATS_UPDATED)) {
    sub BGE_LOCSTATS_STATS_UPDATED () {	0xcd0;}
}
unless(defined(&BGE_LOCSTATS_IRQS)) {
    sub BGE_LOCSTATS_IRQS () {	0xcd4;}
}
unless(defined(&BGE_LOCSTATS_AVOIDED_IRQS)) {
    sub BGE_LOCSTATS_AVOIDED_IRQS () {	0xcd8;}
}
unless(defined(&BGE_LOCSTATS_TX_THRESH_HIT)) {
    sub BGE_LOCSTATS_TX_THRESH_HIT () {	0xcdc;}
}
unless(defined(&BGE_SDIMODE_RESET)) {
    sub BGE_SDIMODE_RESET () {	0x1;}
}
unless(defined(&BGE_SDIMODE_ENABLE)) {
    sub BGE_SDIMODE_ENABLE () {	0x2;}
}
unless(defined(&BGE_SDIMODE_STATS_OFLOW_ATTN)) {
    sub BGE_SDIMODE_STATS_OFLOW_ATTN () {	0x4;}
}
unless(defined(&BGE_SDISTAT_STATS_OFLOW_ATTN)) {
    sub BGE_SDISTAT_STATS_OFLOW_ATTN () {	0x4;}
}
unless(defined(&BGE_SDISTATSCTL_ENABLE)) {
    sub BGE_SDISTATSCTL_ENABLE () {	0x1;}
}
unless(defined(&BGE_SDISTATSCTL_FASTER)) {
    sub BGE_SDISTATSCTL_FASTER () {	0x2;}
}
unless(defined(&BGE_SDISTATSCTL_CLEAR)) {
    sub BGE_SDISTATSCTL_CLEAR () {	0x4;}
}
unless(defined(&BGE_SDISTATSCTL_FORCEFLUSH)) {
    sub BGE_SDISTATSCTL_FORCEFLUSH () {	0x8;}
}
unless(defined(&BGE_SDISTATSCTL_FORCEZERO)) {
    sub BGE_SDISTATSCTL_FORCEZERO () {	0x10;}
}
unless(defined(&BGE_SDC_MODE)) {
    sub BGE_SDC_MODE () {	0x1000;}
}
unless(defined(&BGE_SDC_STATUS)) {
    sub BGE_SDC_STATUS () {	0x1004;}
}
unless(defined(&BGE_SDCMODE_RESET)) {
    sub BGE_SDCMODE_RESET () {	0x1;}
}
unless(defined(&BGE_SDCMODE_ENABLE)) {
    sub BGE_SDCMODE_ENABLE () {	0x2;}
}
unless(defined(&BGE_SDCMODE_ATTN)) {
    sub BGE_SDCMODE_ATTN () {	0x4;}
}
unless(defined(&BGE_SDCMODE_CDELAY)) {
    sub BGE_SDCMODE_CDELAY () {	0x10;}
}
unless(defined(&BGE_SDCSTAT_ATTN)) {
    sub BGE_SDCSTAT_ATTN () {	0x4;}
}
unless(defined(&BGE_SRS_MODE)) {
    sub BGE_SRS_MODE () {	0x1400;}
}
unless(defined(&BGE_SRS_STATUS)) {
    sub BGE_SRS_STATUS () {	0x1404;}
}
unless(defined(&BGE_SRS_HWDIAG)) {
    sub BGE_SRS_HWDIAG () {	0x1408;}
}
unless(defined(&BGE_SRS_LOC_NIC_CONS0)) {
    sub BGE_SRS_LOC_NIC_CONS0 () {	0x1440;}
}
unless(defined(&BGE_SRS_LOC_NIC_CONS1)) {
    sub BGE_SRS_LOC_NIC_CONS1 () {	0x1444;}
}
unless(defined(&BGE_SRS_LOC_NIC_CONS2)) {
    sub BGE_SRS_LOC_NIC_CONS2 () {	0x1448;}
}
unless(defined(&BGE_SRS_LOC_NIC_CONS3)) {
    sub BGE_SRS_LOC_NIC_CONS3 () {	0x144c;}
}
unless(defined(&BGE_SRS_LOC_NIC_CONS4)) {
    sub BGE_SRS_LOC_NIC_CONS4 () {	0x1450;}
}
unless(defined(&BGE_SRS_LOC_NIC_CONS5)) {
    sub BGE_SRS_LOC_NIC_CONS5 () {	0x1454;}
}
unless(defined(&BGE_SRS_LOC_NIC_CONS6)) {
    sub BGE_SRS_LOC_NIC_CONS6 () {	0x1458;}
}
unless(defined(&BGE_SRS_LOC_NIC_CONS7)) {
    sub BGE_SRS_LOC_NIC_CONS7 () {	0x145c;}
}
unless(defined(&BGE_SRS_LOC_NIC_CONS8)) {
    sub BGE_SRS_LOC_NIC_CONS8 () {	0x1460;}
}
unless(defined(&BGE_SRS_LOC_NIC_CONS9)) {
    sub BGE_SRS_LOC_NIC_CONS9 () {	0x1464;}
}
unless(defined(&BGE_SRS_LOC_NIC_CONS10)) {
    sub BGE_SRS_LOC_NIC_CONS10 () {	0x1468;}
}
unless(defined(&BGE_SRS_LOC_NIC_CONS11)) {
    sub BGE_SRS_LOC_NIC_CONS11 () {	0x146c;}
}
unless(defined(&BGE_SRS_LOC_NIC_CONS12)) {
    sub BGE_SRS_LOC_NIC_CONS12 () {	0x1470;}
}
unless(defined(&BGE_SRS_LOC_NIC_CONS13)) {
    sub BGE_SRS_LOC_NIC_CONS13 () {	0x1474;}
}
unless(defined(&BGE_SRS_LOC_NIC_CONS14)) {
    sub BGE_SRS_LOC_NIC_CONS14 () {	0x1478;}
}
unless(defined(&BGE_SRS_LOC_NIC_CONS15)) {
    sub BGE_SRS_LOC_NIC_CONS15 () {	0x147c;}
}
unless(defined(&BGE_SRSMODE_RESET)) {
    sub BGE_SRSMODE_RESET () {	0x1;}
}
unless(defined(&BGE_SRSMODE_ENABLE)) {
    sub BGE_SRSMODE_ENABLE () {	0x2;}
}
unless(defined(&BGE_SRSMODE_ATTN)) {
    sub BGE_SRSMODE_ATTN () {	0x4;}
}
unless(defined(&BGE_SRSSTAT_ERROR)) {
    sub BGE_SRSSTAT_ERROR () {	0x4;}
}
unless(defined(&BGE_SRSHWDIAG_STATE)) {
    sub BGE_SRSHWDIAG_STATE () {	0xf;}
}
unless(defined(&BGE_SRSHWDIAG_CURRINGNUM)) {
    sub BGE_SRSHWDIAG_CURRINGNUM () {	0xf0;}
}
unless(defined(&BGE_SRSHWDIAG_STAGEDRINGNUM)) {
    sub BGE_SRSHWDIAG_STAGEDRINGNUM () {	0xf00;}
}
unless(defined(&BGE_SRSHWDIAG_RINGNUM_IN_MBX)) {
    sub BGE_SRSHWDIAG_RINGNUM_IN_MBX () {	0xf000;}
}
unless(defined(&BGE_SBDI_MODE)) {
    sub BGE_SBDI_MODE () {	0x1800;}
}
unless(defined(&BGE_SBDI_STATUS)) {
    sub BGE_SBDI_STATUS () {	0x1804;}
}
unless(defined(&BGE_SBDI_LOC_NIC_PROD0)) {
    sub BGE_SBDI_LOC_NIC_PROD0 () {	0x1808;}
}
unless(defined(&BGE_SBDI_LOC_NIC_PROD1)) {
    sub BGE_SBDI_LOC_NIC_PROD1 () {	0x180c;}
}
unless(defined(&BGE_SBDI_LOC_NIC_PROD2)) {
    sub BGE_SBDI_LOC_NIC_PROD2 () {	0x1810;}
}
unless(defined(&BGE_SBDI_LOC_NIC_PROD3)) {
    sub BGE_SBDI_LOC_NIC_PROD3 () {	0x1814;}
}
unless(defined(&BGE_SBDI_LOC_NIC_PROD4)) {
    sub BGE_SBDI_LOC_NIC_PROD4 () {	0x1818;}
}
unless(defined(&BGE_SBDI_LOC_NIC_PROD5)) {
    sub BGE_SBDI_LOC_NIC_PROD5 () {	0x181c;}
}
unless(defined(&BGE_SBDI_LOC_NIC_PROD6)) {
    sub BGE_SBDI_LOC_NIC_PROD6 () {	0x1820;}
}
unless(defined(&BGE_SBDI_LOC_NIC_PROD7)) {
    sub BGE_SBDI_LOC_NIC_PROD7 () {	0x1824;}
}
unless(defined(&BGE_SBDI_LOC_NIC_PROD8)) {
    sub BGE_SBDI_LOC_NIC_PROD8 () {	0x1828;}
}
unless(defined(&BGE_SBDI_LOC_NIC_PROD9)) {
    sub BGE_SBDI_LOC_NIC_PROD9 () {	0x182c;}
}
unless(defined(&BGE_SBDI_LOC_NIC_PROD10)) {
    sub BGE_SBDI_LOC_NIC_PROD10 () {	0x1830;}
}
unless(defined(&BGE_SBDI_LOC_NIC_PROD11)) {
    sub BGE_SBDI_LOC_NIC_PROD11 () {	0x1834;}
}
unless(defined(&BGE_SBDI_LOC_NIC_PROD12)) {
    sub BGE_SBDI_LOC_NIC_PROD12 () {	0x1838;}
}
unless(defined(&BGE_SBDI_LOC_NIC_PROD13)) {
    sub BGE_SBDI_LOC_NIC_PROD13 () {	0x183c;}
}
unless(defined(&BGE_SBDI_LOC_NIC_PROD14)) {
    sub BGE_SBDI_LOC_NIC_PROD14 () {	0x1840;}
}
unless(defined(&BGE_SBDI_LOC_NIC_PROD15)) {
    sub BGE_SBDI_LOC_NIC_PROD15 () {	0x1844;}
}
unless(defined(&BGE_SBDIMODE_RESET)) {
    sub BGE_SBDIMODE_RESET () {	0x1;}
}
unless(defined(&BGE_SBDIMODE_ENABLE)) {
    sub BGE_SBDIMODE_ENABLE () {	0x2;}
}
unless(defined(&BGE_SBDIMODE_ATTN)) {
    sub BGE_SBDIMODE_ATTN () {	0x4;}
}
unless(defined(&BGE_SBDISTAT_ERROR)) {
    sub BGE_SBDISTAT_ERROR () {	0x4;}
}
unless(defined(&BGE_SBDC_MODE)) {
    sub BGE_SBDC_MODE () {	0x1c00;}
}
unless(defined(&BGE_SBDC_STATUS)) {
    sub BGE_SBDC_STATUS () {	0x1c04;}
}
unless(defined(&BGE_SBDCMODE_RESET)) {
    sub BGE_SBDCMODE_RESET () {	0x1;}
}
unless(defined(&BGE_SBDCMODE_ENABLE)) {
    sub BGE_SBDCMODE_ENABLE () {	0x2;}
}
unless(defined(&BGE_SBDCMODE_ATTN)) {
    sub BGE_SBDCMODE_ATTN () {	0x4;}
}
unless(defined(&BGE_SBDCSTAT_ATTN)) {
    sub BGE_SBDCSTAT_ATTN () {	0x4;}
}
unless(defined(&BGE_RXLP_MODE)) {
    sub BGE_RXLP_MODE () {	0x2000;}
}
unless(defined(&BGE_RXLP_STATUS)) {
    sub BGE_RXLP_STATUS () {	0x2004;}
}
unless(defined(&BGE_RXLP_SEL_LIST_LOCK)) {
    sub BGE_RXLP_SEL_LIST_LOCK () {	0x2008;}
}
unless(defined(&BGE_RXLP_SEL_NON_EMPTY_BITS)) {
    sub BGE_RXLP_SEL_NON_EMPTY_BITS () {	0x200c;}
}
unless(defined(&BGE_RXLP_CFG)) {
    sub BGE_RXLP_CFG () {	0x2010;}
}
unless(defined(&BGE_RXLP_STATS_CTL)) {
    sub BGE_RXLP_STATS_CTL () {	0x2014;}
}
unless(defined(&BGE_RXLP_STATS_ENABLE_MASK)) {
    sub BGE_RXLP_STATS_ENABLE_MASK () {	0x2018;}
}
unless(defined(&BGE_RXLP_STATS_INCREMENT_MASK)) {
    sub BGE_RXLP_STATS_INCREMENT_MASK () {	0x201c;}
}
unless(defined(&BGE_RXLP_HEAD0)) {
    sub BGE_RXLP_HEAD0 () {	0x2100;}
}
unless(defined(&BGE_RXLP_TAIL0)) {
    sub BGE_RXLP_TAIL0 () {	0x2104;}
}
unless(defined(&BGE_RXLP_COUNT0)) {
    sub BGE_RXLP_COUNT0 () {	0x2108;}
}
unless(defined(&BGE_RXLP_HEAD1)) {
    sub BGE_RXLP_HEAD1 () {	0x2110;}
}
unless(defined(&BGE_RXLP_TAIL1)) {
    sub BGE_RXLP_TAIL1 () {	0x2114;}
}
unless(defined(&BGE_RXLP_COUNT1)) {
    sub BGE_RXLP_COUNT1 () {	0x2118;}
}
unless(defined(&BGE_RXLP_HEAD2)) {
    sub BGE_RXLP_HEAD2 () {	0x2120;}
}
unless(defined(&BGE_RXLP_TAIL2)) {
    sub BGE_RXLP_TAIL2 () {	0x2124;}
}
unless(defined(&BGE_RXLP_COUNT2)) {
    sub BGE_RXLP_COUNT2 () {	0x2128;}
}
unless(defined(&BGE_RXLP_HEAD3)) {
    sub BGE_RXLP_HEAD3 () {	0x2130;}
}
unless(defined(&BGE_RXLP_TAIL3)) {
    sub BGE_RXLP_TAIL3 () {	0x2134;}
}
unless(defined(&BGE_RXLP_COUNT3)) {
    sub BGE_RXLP_COUNT3 () {	0x2138;}
}
unless(defined(&BGE_RXLP_HEAD4)) {
    sub BGE_RXLP_HEAD4 () {	0x2140;}
}
unless(defined(&BGE_RXLP_TAIL4)) {
    sub BGE_RXLP_TAIL4 () {	0x2144;}
}
unless(defined(&BGE_RXLP_COUNT4)) {
    sub BGE_RXLP_COUNT4 () {	0x2148;}
}
unless(defined(&BGE_RXLP_HEAD5)) {
    sub BGE_RXLP_HEAD5 () {	0x2150;}
}
unless(defined(&BGE_RXLP_TAIL5)) {
    sub BGE_RXLP_TAIL5 () {	0x2154;}
}
unless(defined(&BGE_RXLP_COUNT5)) {
    sub BGE_RXLP_COUNT5 () {	0x2158;}
}
unless(defined(&BGE_RXLP_HEAD6)) {
    sub BGE_RXLP_HEAD6 () {	0x2160;}
}
unless(defined(&BGE_RXLP_TAIL6)) {
    sub BGE_RXLP_TAIL6 () {	0x2164;}
}
unless(defined(&BGE_RXLP_COUNT6)) {
    sub BGE_RXLP_COUNT6 () {	0x2168;}
}
unless(defined(&BGE_RXLP_HEAD7)) {
    sub BGE_RXLP_HEAD7 () {	0x2170;}
}
unless(defined(&BGE_RXLP_TAIL7)) {
    sub BGE_RXLP_TAIL7 () {	0x2174;}
}
unless(defined(&BGE_RXLP_COUNT7)) {
    sub BGE_RXLP_COUNT7 () {	0x2178;}
}
unless(defined(&BGE_RXLP_HEAD8)) {
    sub BGE_RXLP_HEAD8 () {	0x2180;}
}
unless(defined(&BGE_RXLP_TAIL8)) {
    sub BGE_RXLP_TAIL8 () {	0x2184;}
}
unless(defined(&BGE_RXLP_COUNT8)) {
    sub BGE_RXLP_COUNT8 () {	0x2188;}
}
unless(defined(&BGE_RXLP_HEAD9)) {
    sub BGE_RXLP_HEAD9 () {	0x2190;}
}
unless(defined(&BGE_RXLP_TAIL9)) {
    sub BGE_RXLP_TAIL9 () {	0x2194;}
}
unless(defined(&BGE_RXLP_COUNT9)) {
    sub BGE_RXLP_COUNT9 () {	0x2198;}
}
unless(defined(&BGE_RXLP_HEAD10)) {
    sub BGE_RXLP_HEAD10 () {	0x21a0;}
}
unless(defined(&BGE_RXLP_TAIL10)) {
    sub BGE_RXLP_TAIL10 () {	0x21a4;}
}
unless(defined(&BGE_RXLP_COUNT10)) {
    sub BGE_RXLP_COUNT10 () {	0x21a8;}
}
unless(defined(&BGE_RXLP_HEAD11)) {
    sub BGE_RXLP_HEAD11 () {	0x21b0;}
}
unless(defined(&BGE_RXLP_TAIL11)) {
    sub BGE_RXLP_TAIL11 () {	0x21b4;}
}
unless(defined(&BGE_RXLP_COUNT11)) {
    sub BGE_RXLP_COUNT11 () {	0x21b8;}
}
unless(defined(&BGE_RXLP_HEAD12)) {
    sub BGE_RXLP_HEAD12 () {	0x21c0;}
}
unless(defined(&BGE_RXLP_TAIL12)) {
    sub BGE_RXLP_TAIL12 () {	0x21c4;}
}
unless(defined(&BGE_RXLP_COUNT12)) {
    sub BGE_RXLP_COUNT12 () {	0x21c8;}
}
unless(defined(&BGE_RXLP_HEAD13)) {
    sub BGE_RXLP_HEAD13 () {	0x21d0;}
}
unless(defined(&BGE_RXLP_TAIL13)) {
    sub BGE_RXLP_TAIL13 () {	0x21d4;}
}
unless(defined(&BGE_RXLP_COUNT13)) {
    sub BGE_RXLP_COUNT13 () {	0x21d8;}
}
unless(defined(&BGE_RXLP_HEAD14)) {
    sub BGE_RXLP_HEAD14 () {	0x21e0;}
}
unless(defined(&BGE_RXLP_TAIL14)) {
    sub BGE_RXLP_TAIL14 () {	0x21e4;}
}
unless(defined(&BGE_RXLP_COUNT14)) {
    sub BGE_RXLP_COUNT14 () {	0x21e8;}
}
unless(defined(&BGE_RXLP_HEAD15)) {
    sub BGE_RXLP_HEAD15 () {	0x21f0;}
}
unless(defined(&BGE_RXLP_TAIL15)) {
    sub BGE_RXLP_TAIL15 () {	0x21f4;}
}
unless(defined(&BGE_RXLP_COUNT15)) {
    sub BGE_RXLP_COUNT15 () {	0x21f8;}
}
unless(defined(&BGE_RXLP_LOCSTAT_COS0)) {
    sub BGE_RXLP_LOCSTAT_COS0 () {	0x2200;}
}
unless(defined(&BGE_RXLP_LOCSTAT_COS1)) {
    sub BGE_RXLP_LOCSTAT_COS1 () {	0x2204;}
}
unless(defined(&BGE_RXLP_LOCSTAT_COS2)) {
    sub BGE_RXLP_LOCSTAT_COS2 () {	0x2208;}
}
unless(defined(&BGE_RXLP_LOCSTAT_COS3)) {
    sub BGE_RXLP_LOCSTAT_COS3 () {	0x220c;}
}
unless(defined(&BGE_RXLP_LOCSTAT_COS4)) {
    sub BGE_RXLP_LOCSTAT_COS4 () {	0x2210;}
}
unless(defined(&BGE_RXLP_LOCSTAT_COS5)) {
    sub BGE_RXLP_LOCSTAT_COS5 () {	0x2214;}
}
unless(defined(&BGE_RXLP_LOCSTAT_COS6)) {
    sub BGE_RXLP_LOCSTAT_COS6 () {	0x2218;}
}
unless(defined(&BGE_RXLP_LOCSTAT_COS7)) {
    sub BGE_RXLP_LOCSTAT_COS7 () {	0x221c;}
}
unless(defined(&BGE_RXLP_LOCSTAT_COS8)) {
    sub BGE_RXLP_LOCSTAT_COS8 () {	0x2220;}
}
unless(defined(&BGE_RXLP_LOCSTAT_COS9)) {
    sub BGE_RXLP_LOCSTAT_COS9 () {	0x2224;}
}
unless(defined(&BGE_RXLP_LOCSTAT_COS10)) {
    sub BGE_RXLP_LOCSTAT_COS10 () {	0x2228;}
}
unless(defined(&BGE_RXLP_LOCSTAT_COS11)) {
    sub BGE_RXLP_LOCSTAT_COS11 () {	0x222c;}
}
unless(defined(&BGE_RXLP_LOCSTAT_COS12)) {
    sub BGE_RXLP_LOCSTAT_COS12 () {	0x2230;}
}
unless(defined(&BGE_RXLP_LOCSTAT_COS13)) {
    sub BGE_RXLP_LOCSTAT_COS13 () {	0x2234;}
}
unless(defined(&BGE_RXLP_LOCSTAT_COS14)) {
    sub BGE_RXLP_LOCSTAT_COS14 () {	0x2238;}
}
unless(defined(&BGE_RXLP_LOCSTAT_COS15)) {
    sub BGE_RXLP_LOCSTAT_COS15 () {	0x223c;}
}
unless(defined(&BGE_RXLP_LOCSTAT_FILTDROP)) {
    sub BGE_RXLP_LOCSTAT_FILTDROP () {	0x2240;}
}
unless(defined(&BGE_RXLP_LOCSTAT_DMA_WRQ_FULL)) {
    sub BGE_RXLP_LOCSTAT_DMA_WRQ_FULL () {	0x2244;}
}
unless(defined(&BGE_RXLP_LOCSTAT_DMA_HPWRQ_FULL)) {
    sub BGE_RXLP_LOCSTAT_DMA_HPWRQ_FULL () {	0x2248;}
}
unless(defined(&BGE_RXLP_LOCSTAT_OUT_OF_BDS)) {
    sub BGE_RXLP_LOCSTAT_OUT_OF_BDS () {	0x224c;}
}
unless(defined(&BGE_RXLP_LOCSTAT_IFIN_DROPS)) {
    sub BGE_RXLP_LOCSTAT_IFIN_DROPS () {	0x2250;}
}
unless(defined(&BGE_RXLP_LOCSTAT_IFIN_ERRORS)) {
    sub BGE_RXLP_LOCSTAT_IFIN_ERRORS () {	0x2254;}
}
unless(defined(&BGE_RXLP_LOCSTAT_RXTHRESH_HIT)) {
    sub BGE_RXLP_LOCSTAT_RXTHRESH_HIT () {	0x2258;}
}
unless(defined(&BGE_RXLPMODE_RESET)) {
    sub BGE_RXLPMODE_RESET () {	0x1;}
}
unless(defined(&BGE_RXLPMODE_ENABLE)) {
    sub BGE_RXLPMODE_ENABLE () {	0x2;}
}
unless(defined(&BGE_RXLPMODE_CLASS0_ATTN)) {
    sub BGE_RXLPMODE_CLASS0_ATTN () {	0x4;}
}
unless(defined(&BGE_RXLPMODE_MAPOUTRANGE_ATTN)) {
    sub BGE_RXLPMODE_MAPOUTRANGE_ATTN () {	0x8;}
}
unless(defined(&BGE_RXLPMODE_STATSOFLOW_ATTN)) {
    sub BGE_RXLPMODE_STATSOFLOW_ATTN () {	0x10;}
}
unless(defined(&BGE_RXLPSTAT_CLASS0_ATTN)) {
    sub BGE_RXLPSTAT_CLASS0_ATTN () {	0x4;}
}
unless(defined(&BGE_RXLPSTAT_MAPOUTRANGE_ATTN)) {
    sub BGE_RXLPSTAT_MAPOUTRANGE_ATTN () {	0x8;}
}
unless(defined(&BGE_RXLPSTAT_STATSOFLOW_ATTN)) {
    sub BGE_RXLPSTAT_STATSOFLOW_ATTN () {	0x10;}
}
unless(defined(&BGE_RDBDI_MODE)) {
    sub BGE_RDBDI_MODE () {	0x2400;}
}
unless(defined(&BGE_RDBDI_STATUS)) {
    sub BGE_RDBDI_STATUS () {	0x2404;}
}
unless(defined(&BGE_RX_JUMBO_RCB_HADDR_HI)) {
    sub BGE_RX_JUMBO_RCB_HADDR_HI () {	0x2440;}
}
unless(defined(&BGE_RX_JUMBO_RCB_HADDR_LO)) {
    sub BGE_RX_JUMBO_RCB_HADDR_LO () {	0x2444;}
}
unless(defined(&BGE_RX_JUMBO_RCB_MAXLEN_FLAGS)) {
    sub BGE_RX_JUMBO_RCB_MAXLEN_FLAGS () {	0x2448;}
}
unless(defined(&BGE_RX_JUMBO_RCB_NICADDR)) {
    sub BGE_RX_JUMBO_RCB_NICADDR () {	0x244c;}
}
unless(defined(&BGE_RX_STD_RCB_HADDR_HI)) {
    sub BGE_RX_STD_RCB_HADDR_HI () {	0x2450;}
}
unless(defined(&BGE_RX_STD_RCB_HADDR_LO)) {
    sub BGE_RX_STD_RCB_HADDR_LO () {	0x2454;}
}
unless(defined(&BGE_RX_STD_RCB_MAXLEN_FLAGS)) {
    sub BGE_RX_STD_RCB_MAXLEN_FLAGS () {	0x2458;}
}
unless(defined(&BGE_RX_STD_RCB_NICADDR)) {
    sub BGE_RX_STD_RCB_NICADDR () {	0x245c;}
}
unless(defined(&BGE_RX_MINI_RCB_HADDR_HI)) {
    sub BGE_RX_MINI_RCB_HADDR_HI () {	0x2460;}
}
unless(defined(&BGE_RX_MINI_RCB_HADDR_LO)) {
    sub BGE_RX_MINI_RCB_HADDR_LO () {	0x2464;}
}
unless(defined(&BGE_RX_MINI_RCB_MAXLEN_FLAGS)) {
    sub BGE_RX_MINI_RCB_MAXLEN_FLAGS () {	0x2468;}
}
unless(defined(&BGE_RX_MINI_RCB_NICADDR)) {
    sub BGE_RX_MINI_RCB_NICADDR () {	0x246c;}
}
unless(defined(&BGE_RDBDI_JUMBO_RX_CONS)) {
    sub BGE_RDBDI_JUMBO_RX_CONS () {	0x2470;}
}
unless(defined(&BGE_RDBDI_STD_RX_CONS)) {
    sub BGE_RDBDI_STD_RX_CONS () {	0x2474;}
}
unless(defined(&BGE_RDBDI_MINI_RX_CONS)) {
    sub BGE_RDBDI_MINI_RX_CONS () {	0x2478;}
}
unless(defined(&BGE_RDBDI_RETURN_PROD0)) {
    sub BGE_RDBDI_RETURN_PROD0 () {	0x2480;}
}
unless(defined(&BGE_RDBDI_RETURN_PROD1)) {
    sub BGE_RDBDI_RETURN_PROD1 () {	0x2484;}
}
unless(defined(&BGE_RDBDI_RETURN_PROD2)) {
    sub BGE_RDBDI_RETURN_PROD2 () {	0x2488;}
}
unless(defined(&BGE_RDBDI_RETURN_PROD3)) {
    sub BGE_RDBDI_RETURN_PROD3 () {	0x248c;}
}
unless(defined(&BGE_RDBDI_RETURN_PROD4)) {
    sub BGE_RDBDI_RETURN_PROD4 () {	0x2490;}
}
unless(defined(&BGE_RDBDI_RETURN_PROD5)) {
    sub BGE_RDBDI_RETURN_PROD5 () {	0x2494;}
}
unless(defined(&BGE_RDBDI_RETURN_PROD6)) {
    sub BGE_RDBDI_RETURN_PROD6 () {	0x2498;}
}
unless(defined(&BGE_RDBDI_RETURN_PROD7)) {
    sub BGE_RDBDI_RETURN_PROD7 () {	0x249c;}
}
unless(defined(&BGE_RDBDI_RETURN_PROD8)) {
    sub BGE_RDBDI_RETURN_PROD8 () {	0x24a0;}
}
unless(defined(&BGE_RDBDI_RETURN_PROD9)) {
    sub BGE_RDBDI_RETURN_PROD9 () {	0x24a4;}
}
unless(defined(&BGE_RDBDI_RETURN_PROD10)) {
    sub BGE_RDBDI_RETURN_PROD10 () {	0x24a8;}
}
unless(defined(&BGE_RDBDI_RETURN_PROD11)) {
    sub BGE_RDBDI_RETURN_PROD11 () {	0x24ac;}
}
unless(defined(&BGE_RDBDI_RETURN_PROD12)) {
    sub BGE_RDBDI_RETURN_PROD12 () {	0x24b0;}
}
unless(defined(&BGE_RDBDI_RETURN_PROD13)) {
    sub BGE_RDBDI_RETURN_PROD13 () {	0x24b4;}
}
unless(defined(&BGE_RDBDI_RETURN_PROD14)) {
    sub BGE_RDBDI_RETURN_PROD14 () {	0x24b8;}
}
unless(defined(&BGE_RDBDI_RETURN_PROD15)) {
    sub BGE_RDBDI_RETURN_PROD15 () {	0x24bc;}
}
unless(defined(&BGE_RDBDI_HWDIAG)) {
    sub BGE_RDBDI_HWDIAG () {	0x24c0;}
}
unless(defined(&BGE_RDBDIMODE_RESET)) {
    sub BGE_RDBDIMODE_RESET () {	0x1;}
}
unless(defined(&BGE_RDBDIMODE_ENABLE)) {
    sub BGE_RDBDIMODE_ENABLE () {	0x2;}
}
unless(defined(&BGE_RDBDIMODE_JUMBO_ATTN)) {
    sub BGE_RDBDIMODE_JUMBO_ATTN () {	0x4;}
}
unless(defined(&BGE_RDBDIMODE_GIANT_ATTN)) {
    sub BGE_RDBDIMODE_GIANT_ATTN () {	0x8;}
}
unless(defined(&BGE_RDBDIMODE_BADRINGSZ_ATTN)) {
    sub BGE_RDBDIMODE_BADRINGSZ_ATTN () {	0x10;}
}
unless(defined(&BGE_RDBDISTAT_JUMBO_ATTN)) {
    sub BGE_RDBDISTAT_JUMBO_ATTN () {	0x4;}
}
unless(defined(&BGE_RDBDISTAT_GIANT_ATTN)) {
    sub BGE_RDBDISTAT_GIANT_ATTN () {	0x8;}
}
unless(defined(&BGE_RDBDISTAT_BADRINGSZ_ATTN)) {
    sub BGE_RDBDISTAT_BADRINGSZ_ATTN () {	0x10;}
}
unless(defined(&BGE_RDC_MODE)) {
    sub BGE_RDC_MODE () {	0x2800;}
}
unless(defined(&BGE_RDCMODE_RESET)) {
    sub BGE_RDCMODE_RESET () {	0x1;}
}
unless(defined(&BGE_RDCMODE_ENABLE)) {
    sub BGE_RDCMODE_ENABLE () {	0x2;}
}
unless(defined(&BGE_RDCMODE_ATTN)) {
    sub BGE_RDCMODE_ATTN () {	0x4;}
}
unless(defined(&BGE_RBDI_MODE)) {
    sub BGE_RBDI_MODE () {	0x2c00;}
}
unless(defined(&BGE_RBDI_STATUS)) {
    sub BGE_RBDI_STATUS () {	0x2c04;}
}
unless(defined(&BGE_RBDI_NIC_JUMBO_BD_PROD)) {
    sub BGE_RBDI_NIC_JUMBO_BD_PROD () {	0x2c08;}
}
unless(defined(&BGE_RBDI_NIC_STD_BD_PROD)) {
    sub BGE_RBDI_NIC_STD_BD_PROD () {	0x2c0c;}
}
unless(defined(&BGE_RBDI_NIC_MINI_BD_PROD)) {
    sub BGE_RBDI_NIC_MINI_BD_PROD () {	0x2c10;}
}
unless(defined(&BGE_RBDI_MINI_REPL_THRESH)) {
    sub BGE_RBDI_MINI_REPL_THRESH () {	0x2c14;}
}
unless(defined(&BGE_RBDI_STD_REPL_THRESH)) {
    sub BGE_RBDI_STD_REPL_THRESH () {	0x2c18;}
}
unless(defined(&BGE_RBDI_JUMBO_REPL_THRESH)) {
    sub BGE_RBDI_JUMBO_REPL_THRESH () {	0x2c1c;}
}
unless(defined(&BGE_STD_REPL_LWM)) {
    sub BGE_STD_REPL_LWM () {	0x2d00;}
}
unless(defined(&BGE_JUMBO_REPL_LWM)) {
    sub BGE_JUMBO_REPL_LWM () {	0x2d04;}
}
unless(defined(&BGE_RBDIMODE_RESET)) {
    sub BGE_RBDIMODE_RESET () {	0x1;}
}
unless(defined(&BGE_RBDIMODE_ENABLE)) {
    sub BGE_RBDIMODE_ENABLE () {	0x2;}
}
unless(defined(&BGE_RBDIMODE_ATTN)) {
    sub BGE_RBDIMODE_ATTN () {	0x4;}
}
unless(defined(&BGE_RBDISTAT_ATTN)) {
    sub BGE_RBDISTAT_ATTN () {	0x4;}
}
unless(defined(&BGE_RBDC_MODE)) {
    sub BGE_RBDC_MODE () {	0x3000;}
}
unless(defined(&BGE_RBDC_STATUS)) {
    sub BGE_RBDC_STATUS () {	0x3004;}
}
unless(defined(&BGE_RBDC_JUMBO_BD_PROD)) {
    sub BGE_RBDC_JUMBO_BD_PROD () {	0x3008;}
}
unless(defined(&BGE_RBDC_STD_BD_PROD)) {
    sub BGE_RBDC_STD_BD_PROD () {	0x300c;}
}
unless(defined(&BGE_RBDC_MINI_BD_PROD)) {
    sub BGE_RBDC_MINI_BD_PROD () {	0x3010;}
}
unless(defined(&BGE_RBDCMODE_RESET)) {
    sub BGE_RBDCMODE_RESET () {	0x1;}
}
unless(defined(&BGE_RBDCMODE_ENABLE)) {
    sub BGE_RBDCMODE_ENABLE () {	0x2;}
}
unless(defined(&BGE_RBDCMODE_ATTN)) {
    sub BGE_RBDCMODE_ATTN () {	0x4;}
}
unless(defined(&BGE_RBDCSTAT_ERROR)) {
    sub BGE_RBDCSTAT_ERROR () {	0x4;}
}
unless(defined(&BGE_RXLS_MODE)) {
    sub BGE_RXLS_MODE () {	0x3400;}
}
unless(defined(&BGE_RXLS_STATUS)) {
    sub BGE_RXLS_STATUS () {	0x3404;}
}
unless(defined(&BGE_RXLSMODE_RESET)) {
    sub BGE_RXLSMODE_RESET () {	0x1;}
}
unless(defined(&BGE_RXLSMODE_ENABLE)) {
    sub BGE_RXLSMODE_ENABLE () {	0x2;}
}
unless(defined(&BGE_RXLSMODE_ATTN)) {
    sub BGE_RXLSMODE_ATTN () {	0x4;}
}
unless(defined(&BGE_RXLSSTAT_ERROR)) {
    sub BGE_RXLSSTAT_ERROR () {	0x4;}
}
unless(defined(&BGE_MBCF_MODE)) {
    sub BGE_MBCF_MODE () {	0x3800;}
}
unless(defined(&BGE_MBCF_STATUS)) {
    sub BGE_MBCF_STATUS () {	0x3804;}
}
unless(defined(&BGE_MBCFMODE_RESET)) {
    sub BGE_MBCFMODE_RESET () {	0x1;}
}
unless(defined(&BGE_MBCFMODE_ENABLE)) {
    sub BGE_MBCFMODE_ENABLE () {	0x2;}
}
unless(defined(&BGE_MBCFMODE_ATTN)) {
    sub BGE_MBCFMODE_ATTN () {	0x4;}
}
unless(defined(&BGE_MBCFSTAT_ERROR)) {
    sub BGE_MBCFSTAT_ERROR () {	0x4;}
}
unless(defined(&BGE_HCC_MODE)) {
    sub BGE_HCC_MODE () {	0x3c00;}
}
unless(defined(&BGE_HCC_STATUS)) {
    sub BGE_HCC_STATUS () {	0x3c04;}
}
unless(defined(&BGE_HCC_RX_COAL_TICKS)) {
    sub BGE_HCC_RX_COAL_TICKS () {	0x3c08;}
}
unless(defined(&BGE_HCC_TX_COAL_TICKS)) {
    sub BGE_HCC_TX_COAL_TICKS () {	0x3c0c;}
}
unless(defined(&BGE_HCC_RX_MAX_COAL_BDS)) {
    sub BGE_HCC_RX_MAX_COAL_BDS () {	0x3c10;}
}
unless(defined(&BGE_HCC_TX_MAX_COAL_BDS)) {
    sub BGE_HCC_TX_MAX_COAL_BDS () {	0x3c14;}
}
unless(defined(&BGE_HCC_RX_COAL_TICKS_INT)) {
    sub BGE_HCC_RX_COAL_TICKS_INT () {	0x3c18;}
}
unless(defined(&BGE_HCC_TX_COAL_TICKS_INT)) {
    sub BGE_HCC_TX_COAL_TICKS_INT () {	0x3c1c;}
}
unless(defined(&BGE_HCC_RX_MAX_COAL_BDS_INT)) {
    sub BGE_HCC_RX_MAX_COAL_BDS_INT () {	0x3c20;}
}
unless(defined(&BGE_HCC_TX_MAX_COAL_BDS_INT)) {
    sub BGE_HCC_TX_MAX_COAL_BDS_INT () {	0x3c24;}
}
unless(defined(&BGE_HCC_STATS_TICKS)) {
    sub BGE_HCC_STATS_TICKS () {	0x3c28;}
}
unless(defined(&BGE_HCC_STATS_ADDR_HI)) {
    sub BGE_HCC_STATS_ADDR_HI () {	0x3c30;}
}
unless(defined(&BGE_HCC_STATS_ADDR_LO)) {
    sub BGE_HCC_STATS_ADDR_LO () {	0x3c34;}
}
unless(defined(&BGE_HCC_STATUSBLK_ADDR_HI)) {
    sub BGE_HCC_STATUSBLK_ADDR_HI () {	0x3c38;}
}
unless(defined(&BGE_HCC_STATUSBLK_ADDR_LO)) {
    sub BGE_HCC_STATUSBLK_ADDR_LO () {	0x3c3c;}
}
unless(defined(&BGE_HCC_STATS_BASEADDR)) {
    sub BGE_HCC_STATS_BASEADDR () {	0x3c40;}
}
unless(defined(&BGE_HCC_STATUSBLK_BASEADDR)) {
    sub BGE_HCC_STATUSBLK_BASEADDR () {	0x3c44;}
}
unless(defined(&BGE_FLOW_ATTN)) {
    sub BGE_FLOW_ATTN () {	0x3c48;}
}
unless(defined(&BGE_HCC_JUMBO_BD_CONS)) {
    sub BGE_HCC_JUMBO_BD_CONS () {	0x3c50;}
}
unless(defined(&BGE_HCC_STD_BD_CONS)) {
    sub BGE_HCC_STD_BD_CONS () {	0x3c54;}
}
unless(defined(&BGE_HCC_MINI_BD_CONS)) {
    sub BGE_HCC_MINI_BD_CONS () {	0x3c58;}
}
unless(defined(&BGE_HCC_RX_RETURN_PROD0)) {
    sub BGE_HCC_RX_RETURN_PROD0 () {	0x3c80;}
}
unless(defined(&BGE_HCC_RX_RETURN_PROD1)) {
    sub BGE_HCC_RX_RETURN_PROD1 () {	0x3c84;}
}
unless(defined(&BGE_HCC_RX_RETURN_PROD2)) {
    sub BGE_HCC_RX_RETURN_PROD2 () {	0x3c88;}
}
unless(defined(&BGE_HCC_RX_RETURN_PROD3)) {
    sub BGE_HCC_RX_RETURN_PROD3 () {	0x3c8c;}
}
unless(defined(&BGE_HCC_RX_RETURN_PROD4)) {
    sub BGE_HCC_RX_RETURN_PROD4 () {	0x3c90;}
}
unless(defined(&BGE_HCC_RX_RETURN_PROD5)) {
    sub BGE_HCC_RX_RETURN_PROD5 () {	0x3c94;}
}
unless(defined(&BGE_HCC_RX_RETURN_PROD6)) {
    sub BGE_HCC_RX_RETURN_PROD6 () {	0x3c98;}
}
unless(defined(&BGE_HCC_RX_RETURN_PROD7)) {
    sub BGE_HCC_RX_RETURN_PROD7 () {	0x3c9c;}
}
unless(defined(&BGE_HCC_RX_RETURN_PROD8)) {
    sub BGE_HCC_RX_RETURN_PROD8 () {	0x3ca0;}
}
unless(defined(&BGE_HCC_RX_RETURN_PROD9)) {
    sub BGE_HCC_RX_RETURN_PROD9 () {	0x3ca4;}
}
unless(defined(&BGE_HCC_RX_RETURN_PROD10)) {
    sub BGE_HCC_RX_RETURN_PROD10 () {	0x3ca8;}
}
unless(defined(&BGE_HCC_RX_RETURN_PROD11)) {
    sub BGE_HCC_RX_RETURN_PROD11 () {	0x3cac;}
}
unless(defined(&BGE_HCC_RX_RETURN_PROD12)) {
    sub BGE_HCC_RX_RETURN_PROD12 () {	0x3cb0;}
}
unless(defined(&BGE_HCC_RX_RETURN_PROD13)) {
    sub BGE_HCC_RX_RETURN_PROD13 () {	0x3cb4;}
}
unless(defined(&BGE_HCC_RX_RETURN_PROD14)) {
    sub BGE_HCC_RX_RETURN_PROD14 () {	0x3cb8;}
}
unless(defined(&BGE_HCC_RX_RETURN_PROD15)) {
    sub BGE_HCC_RX_RETURN_PROD15 () {	0x3cbc;}
}
unless(defined(&BGE_HCC_TX_BD_CONS0)) {
    sub BGE_HCC_TX_BD_CONS0 () {	0x3cc0;}
}
unless(defined(&BGE_HCC_TX_BD_CONS1)) {
    sub BGE_HCC_TX_BD_CONS1 () {	0x3cc4;}
}
unless(defined(&BGE_HCC_TX_BD_CONS2)) {
    sub BGE_HCC_TX_BD_CONS2 () {	0x3cc8;}
}
unless(defined(&BGE_HCC_TX_BD_CONS3)) {
    sub BGE_HCC_TX_BD_CONS3 () {	0x3ccc;}
}
unless(defined(&BGE_HCC_TX_BD_CONS4)) {
    sub BGE_HCC_TX_BD_CONS4 () {	0x3cd0;}
}
unless(defined(&BGE_HCC_TX_BD_CONS5)) {
    sub BGE_HCC_TX_BD_CONS5 () {	0x3cd4;}
}
unless(defined(&BGE_HCC_TX_BD_CONS6)) {
    sub BGE_HCC_TX_BD_CONS6 () {	0x3cd8;}
}
unless(defined(&BGE_HCC_TX_BD_CONS7)) {
    sub BGE_HCC_TX_BD_CONS7 () {	0x3cdc;}
}
unless(defined(&BGE_HCC_TX_BD_CONS8)) {
    sub BGE_HCC_TX_BD_CONS8 () {	0x3ce0;}
}
unless(defined(&BGE_HCC_TX_BD_CONS9)) {
    sub BGE_HCC_TX_BD_CONS9 () {	0x3ce4;}
}
unless(defined(&BGE_HCC_TX_BD_CONS10)) {
    sub BGE_HCC_TX_BD_CONS10 () {	0x3ce8;}
}
unless(defined(&BGE_HCC_TX_BD_CONS11)) {
    sub BGE_HCC_TX_BD_CONS11 () {	0x3cec;}
}
unless(defined(&BGE_HCC_TX_BD_CONS12)) {
    sub BGE_HCC_TX_BD_CONS12 () {	0x3cf0;}
}
unless(defined(&BGE_HCC_TX_BD_CONS13)) {
    sub BGE_HCC_TX_BD_CONS13 () {	0x3cf4;}
}
unless(defined(&BGE_HCC_TX_BD_CONS14)) {
    sub BGE_HCC_TX_BD_CONS14 () {	0x3cf8;}
}
unless(defined(&BGE_HCC_TX_BD_CONS15)) {
    sub BGE_HCC_TX_BD_CONS15 () {	0x3cfc;}
}
unless(defined(&BGE_HCCMODE_RESET)) {
    sub BGE_HCCMODE_RESET () {	0x1;}
}
unless(defined(&BGE_HCCMODE_ENABLE)) {
    sub BGE_HCCMODE_ENABLE () {	0x2;}
}
unless(defined(&BGE_HCCMODE_ATTN)) {
    sub BGE_HCCMODE_ATTN () {	0x4;}
}
unless(defined(&BGE_HCCMODE_COAL_NOW)) {
    sub BGE_HCCMODE_COAL_NOW () {	0x8;}
}
unless(defined(&BGE_HCCMODE_MSI_BITS)) {
    sub BGE_HCCMODE_MSI_BITS () {	0x70;}
}
unless(defined(&BGE_HCCMODE_STATBLK_SIZE)) {
    sub BGE_HCCMODE_STATBLK_SIZE () {	0x180;}
}
unless(defined(&BGE_STATBLKSZ_FULL)) {
    sub BGE_STATBLKSZ_FULL () {	0x;}
}
unless(defined(&BGE_STATBLKSZ_64BYTE)) {
    sub BGE_STATBLKSZ_64BYTE () {	0x80;}
}
unless(defined(&BGE_STATBLKSZ_32BYTE)) {
    sub BGE_STATBLKSZ_32BYTE () {	0x100;}
}
unless(defined(&BGE_HCCSTAT_ERROR)) {
    sub BGE_HCCSTAT_ERROR () {	0x4;}
}
unless(defined(&BGE_FLOWATTN_MB_LOWAT)) {
    sub BGE_FLOWATTN_MB_LOWAT () {	0x40;}
}
unless(defined(&BGE_FLOWATTN_MEMARB)) {
    sub BGE_FLOWATTN_MEMARB () {	0x80;}
}
unless(defined(&BGE_FLOWATTN_HOSTCOAL)) {
    sub BGE_FLOWATTN_HOSTCOAL () {	0x8000;}
}
unless(defined(&BGE_FLOWATTN_DMADONE_DISCARD)) {
    sub BGE_FLOWATTN_DMADONE_DISCARD () {	0x10000;}
}
unless(defined(&BGE_FLOWATTN_RCB_INVAL)) {
    sub BGE_FLOWATTN_RCB_INVAL () {	0x20000;}
}
unless(defined(&BGE_FLOWATTN_RXDATA_CORRUPT)) {
    sub BGE_FLOWATTN_RXDATA_CORRUPT () {	0x40000;}
}
unless(defined(&BGE_FLOWATTN_RDBDI)) {
    sub BGE_FLOWATTN_RDBDI () {	0x80000;}
}
unless(defined(&BGE_FLOWATTN_RXLS)) {
    sub BGE_FLOWATTN_RXLS () {	0x100000;}
}
unless(defined(&BGE_FLOWATTN_RXLP)) {
    sub BGE_FLOWATTN_RXLP () {	0x200000;}
}
unless(defined(&BGE_FLOWATTN_RBDC)) {
    sub BGE_FLOWATTN_RBDC () {	0x400000;}
}
unless(defined(&BGE_FLOWATTN_RBDI)) {
    sub BGE_FLOWATTN_RBDI () {	0x800000;}
}
unless(defined(&BGE_FLOWATTN_SDC)) {
    sub BGE_FLOWATTN_SDC () {	0x8000000;}
}
unless(defined(&BGE_FLOWATTN_SDI)) {
    sub BGE_FLOWATTN_SDI () {	0x10000000;}
}
unless(defined(&BGE_FLOWATTN_SRS)) {
    sub BGE_FLOWATTN_SRS () {	0x20000000;}
}
unless(defined(&BGE_FLOWATTN_SBDC)) {
    sub BGE_FLOWATTN_SBDC () {	0x40000000;}
}
unless(defined(&BGE_FLOWATTN_SBDI)) {
    sub BGE_FLOWATTN_SBDI () {	0x80000000;}
}
unless(defined(&BGE_MARB_MODE)) {
    sub BGE_MARB_MODE () {	0x4000;}
}
unless(defined(&BGE_MARB_STATUS)) {
    sub BGE_MARB_STATUS () {	0x4004;}
}
unless(defined(&BGE_MARB_TRAPADDR_HI)) {
    sub BGE_MARB_TRAPADDR_HI () {	0x4008;}
}
unless(defined(&BGE_MARB_TRAPADDR_LO)) {
    sub BGE_MARB_TRAPADDR_LO () {	0x400c;}
}
unless(defined(&BGE_MARBMODE_RESET)) {
    sub BGE_MARBMODE_RESET () {	0x1;}
}
unless(defined(&BGE_MARBMODE_ENABLE)) {
    sub BGE_MARBMODE_ENABLE () {	0x2;}
}
unless(defined(&BGE_MARBMODE_TX_ADDR_TRAP)) {
    sub BGE_MARBMODE_TX_ADDR_TRAP () {	0x4;}
}
unless(defined(&BGE_MARBMODE_RX_ADDR_TRAP)) {
    sub BGE_MARBMODE_RX_ADDR_TRAP () {	0x8;}
}
unless(defined(&BGE_MARBMODE_DMAW1_TRAP)) {
    sub BGE_MARBMODE_DMAW1_TRAP () {	0x10;}
}
unless(defined(&BGE_MARBMODE_DMAR1_TRAP)) {
    sub BGE_MARBMODE_DMAR1_TRAP () {	0x20;}
}
unless(defined(&BGE_MARBMODE_RXRISC_TRAP)) {
    sub BGE_MARBMODE_RXRISC_TRAP () {	0x40;}
}
unless(defined(&BGE_MARBMODE_TXRISC_TRAP)) {
    sub BGE_MARBMODE_TXRISC_TRAP () {	0x80;}
}
unless(defined(&BGE_MARBMODE_PCI_TRAP)) {
    sub BGE_MARBMODE_PCI_TRAP () {	0x100;}
}
unless(defined(&BGE_MARBMODE_DMAR2_TRAP)) {
    sub BGE_MARBMODE_DMAR2_TRAP () {	0x200;}
}
unless(defined(&BGE_MARBMODE_RXQ_TRAP)) {
    sub BGE_MARBMODE_RXQ_TRAP () {	0x400;}
}
unless(defined(&BGE_MARBMODE_RXDI1_TRAP)) {
    sub BGE_MARBMODE_RXDI1_TRAP () {	0x800;}
}
unless(defined(&BGE_MARBMODE_RXDI2_TRAP)) {
    sub BGE_MARBMODE_RXDI2_TRAP () {	0x1000;}
}
unless(defined(&BGE_MARBMODE_DC_GRPMEM_TRAP)) {
    sub BGE_MARBMODE_DC_GRPMEM_TRAP () {	0x2000;}
}
unless(defined(&BGE_MARBMODE_HCOAL_TRAP)) {
    sub BGE_MARBMODE_HCOAL_TRAP () {	0x4000;}
}
unless(defined(&BGE_MARBMODE_MBUF_TRAP)) {
    sub BGE_MARBMODE_MBUF_TRAP () {	0x8000;}
}
unless(defined(&BGE_MARBMODE_TXDI_TRAP)) {
    sub BGE_MARBMODE_TXDI_TRAP () {	0x10000;}
}
unless(defined(&BGE_MARBMODE_SDC_DMAC_TRAP)) {
    sub BGE_MARBMODE_SDC_DMAC_TRAP () {	0x20000;}
}
unless(defined(&BGE_MARBMODE_TXBD_TRAP)) {
    sub BGE_MARBMODE_TXBD_TRAP () {	0x40000;}
}
unless(defined(&BGE_MARBMODE_BUFFMAN_TRAP)) {
    sub BGE_MARBMODE_BUFFMAN_TRAP () {	0x80000;}
}
unless(defined(&BGE_MARBMODE_DMAW2_TRAP)) {
    sub BGE_MARBMODE_DMAW2_TRAP () {	0x100000;}
}
unless(defined(&BGE_MARBMODE_XTSSRAM_ROFLO_TRAP)) {
    sub BGE_MARBMODE_XTSSRAM_ROFLO_TRAP () {	0x200000;}
}
unless(defined(&BGE_MARBMODE_XTSSRAM_RUFLO_TRAP)) {
    sub BGE_MARBMODE_XTSSRAM_RUFLO_TRAP () {	0x400000;}
}
unless(defined(&BGE_MARBMODE_XTSSRAM_WOFLO_TRAP)) {
    sub BGE_MARBMODE_XTSSRAM_WOFLO_TRAP () {	0x800000;}
}
unless(defined(&BGE_MARBMODE_XTSSRAM_WUFLO_TRAP)) {
    sub BGE_MARBMODE_XTSSRAM_WUFLO_TRAP () {	0x1000000;}
}
unless(defined(&BGE_MARBMODE_XTSSRAM_PERR_TRAP)) {
    sub BGE_MARBMODE_XTSSRAM_PERR_TRAP () {	0x2000000;}
}
unless(defined(&BGE_MARBSTAT_TX_ADDR_TRAP)) {
    sub BGE_MARBSTAT_TX_ADDR_TRAP () {	0x4;}
}
unless(defined(&BGE_MARBSTAT_RX_ADDR_TRAP)) {
    sub BGE_MARBSTAT_RX_ADDR_TRAP () {	0x8;}
}
unless(defined(&BGE_MARBSTAT_DMAW1_TRAP)) {
    sub BGE_MARBSTAT_DMAW1_TRAP () {	0x10;}
}
unless(defined(&BGE_MARBSTAT_DMAR1_TRAP)) {
    sub BGE_MARBSTAT_DMAR1_TRAP () {	0x20;}
}
unless(defined(&BGE_MARBSTAT_RXRISC_TRAP)) {
    sub BGE_MARBSTAT_RXRISC_TRAP () {	0x40;}
}
unless(defined(&BGE_MARBSTAT_TXRISC_TRAP)) {
    sub BGE_MARBSTAT_TXRISC_TRAP () {	0x80;}
}
unless(defined(&BGE_MARBSTAT_PCI_TRAP)) {
    sub BGE_MARBSTAT_PCI_TRAP () {	0x100;}
}
unless(defined(&BGE_MARBSTAT_DMAR2_TRAP)) {
    sub BGE_MARBSTAT_DMAR2_TRAP () {	0x200;}
}
unless(defined(&BGE_MARBSTAT_RXQ_TRAP)) {
    sub BGE_MARBSTAT_RXQ_TRAP () {	0x400;}
}
unless(defined(&BGE_MARBSTAT_RXDI1_TRAP)) {
    sub BGE_MARBSTAT_RXDI1_TRAP () {	0x800;}
}
unless(defined(&BGE_MARBSTAT_RXDI2_TRAP)) {
    sub BGE_MARBSTAT_RXDI2_TRAP () {	0x1000;}
}
unless(defined(&BGE_MARBSTAT_DC_GRPMEM_TRAP)) {
    sub BGE_MARBSTAT_DC_GRPMEM_TRAP () {	0x2000;}
}
unless(defined(&BGE_MARBSTAT_HCOAL_TRAP)) {
    sub BGE_MARBSTAT_HCOAL_TRAP () {	0x4000;}
}
unless(defined(&BGE_MARBSTAT_MBUF_TRAP)) {
    sub BGE_MARBSTAT_MBUF_TRAP () {	0x8000;}
}
unless(defined(&BGE_MARBSTAT_TXDI_TRAP)) {
    sub BGE_MARBSTAT_TXDI_TRAP () {	0x10000;}
}
unless(defined(&BGE_MARBSTAT_SDC_DMAC_TRAP)) {
    sub BGE_MARBSTAT_SDC_DMAC_TRAP () {	0x20000;}
}
unless(defined(&BGE_MARBSTAT_TXBD_TRAP)) {
    sub BGE_MARBSTAT_TXBD_TRAP () {	0x40000;}
}
unless(defined(&BGE_MARBSTAT_BUFFMAN_TRAP)) {
    sub BGE_MARBSTAT_BUFFMAN_TRAP () {	0x80000;}
}
unless(defined(&BGE_MARBSTAT_DMAW2_TRAP)) {
    sub BGE_MARBSTAT_DMAW2_TRAP () {	0x100000;}
}
unless(defined(&BGE_MARBSTAT_XTSSRAM_ROFLO_TRAP)) {
    sub BGE_MARBSTAT_XTSSRAM_ROFLO_TRAP () {	0x200000;}
}
unless(defined(&BGE_MARBSTAT_XTSSRAM_RUFLO_TRAP)) {
    sub BGE_MARBSTAT_XTSSRAM_RUFLO_TRAP () {	0x400000;}
}
unless(defined(&BGE_MARBSTAT_XTSSRAM_WOFLO_TRAP)) {
    sub BGE_MARBSTAT_XTSSRAM_WOFLO_TRAP () {	0x800000;}
}
unless(defined(&BGE_MARBSTAT_XTSSRAM_WUFLO_TRAP)) {
    sub BGE_MARBSTAT_XTSSRAM_WUFLO_TRAP () {	0x1000000;}
}
unless(defined(&BGE_MARBSTAT_XTSSRAM_PERR_TRAP)) {
    sub BGE_MARBSTAT_XTSSRAM_PERR_TRAP () {	0x2000000;}
}
unless(defined(&BGE_BMAN_MODE)) {
    sub BGE_BMAN_MODE () {	0x4400;}
}
unless(defined(&BGE_BMAN_STATUS)) {
    sub BGE_BMAN_STATUS () {	0x4404;}
}
unless(defined(&BGE_BMAN_MBUFPOOL_BASEADDR)) {
    sub BGE_BMAN_MBUFPOOL_BASEADDR () {	0x4408;}
}
unless(defined(&BGE_BMAN_MBUFPOOL_LEN)) {
    sub BGE_BMAN_MBUFPOOL_LEN () {	0x440c;}
}
unless(defined(&BGE_BMAN_MBUFPOOL_READDMA_LOWAT)) {
    sub BGE_BMAN_MBUFPOOL_READDMA_LOWAT () {	0x4410;}
}
unless(defined(&BGE_BMAN_MBUFPOOL_MACRX_LOWAT)) {
    sub BGE_BMAN_MBUFPOOL_MACRX_LOWAT () {	0x4414;}
}
unless(defined(&BGE_BMAN_MBUFPOOL_HIWAT)) {
    sub BGE_BMAN_MBUFPOOL_HIWAT () {	0x4418;}
}
unless(defined(&BGE_BMAN_RXCPU_MBALLOC_REQ)) {
    sub BGE_BMAN_RXCPU_MBALLOC_REQ () {	0x441c;}
}
unless(defined(&BGE_BMAN_RXCPU_MBALLOC_RESP)) {
    sub BGE_BMAN_RXCPU_MBALLOC_RESP () {	0x4420;}
}
unless(defined(&BGE_BMAN_TXCPU_MBALLOC_REQ)) {
    sub BGE_BMAN_TXCPU_MBALLOC_REQ () {	0x4424;}
}
unless(defined(&BGE_BMAN_TXCPU_MBALLOC_RESP)) {
    sub BGE_BMAN_TXCPU_MBALLOC_RESP () {	0x4428;}
}
unless(defined(&BGE_BMAN_DMA_DESCPOOL_BASEADDR)) {
    sub BGE_BMAN_DMA_DESCPOOL_BASEADDR () {	0x442c;}
}
unless(defined(&BGE_BMAN_DMA_DESCPOOL_LEN)) {
    sub BGE_BMAN_DMA_DESCPOOL_LEN () {	0x4430;}
}
unless(defined(&BGE_BMAN_DMA_DESCPOOL_LOWAT)) {
    sub BGE_BMAN_DMA_DESCPOOL_LOWAT () {	0x4434;}
}
unless(defined(&BGE_BMAN_DMA_DESCPOOL_HIWAT)) {
    sub BGE_BMAN_DMA_DESCPOOL_HIWAT () {	0x4438;}
}
unless(defined(&BGE_BMAN_RXCPU_DMAALLOC_REQ)) {
    sub BGE_BMAN_RXCPU_DMAALLOC_REQ () {	0x443c;}
}
unless(defined(&BGE_BMAN_RXCPU_DMAALLOC_RESP)) {
    sub BGE_BMAN_RXCPU_DMAALLOC_RESP () {	0x4440;}
}
unless(defined(&BGE_BMAN_TXCPU_DMAALLOC_REQ)) {
    sub BGE_BMAN_TXCPU_DMAALLOC_REQ () {	0x4444;}
}
unless(defined(&BGE_BMAN_TXCPU_DMALLLOC_RESP)) {
    sub BGE_BMAN_TXCPU_DMALLLOC_RESP () {	0x4448;}
}
unless(defined(&BGE_BMAN_HWDIAG_1)) {
    sub BGE_BMAN_HWDIAG_1 () {	0x444c;}
}
unless(defined(&BGE_BMAN_HWDIAG_2)) {
    sub BGE_BMAN_HWDIAG_2 () {	0x4450;}
}
unless(defined(&BGE_BMAN_HWDIAG_3)) {
    sub BGE_BMAN_HWDIAG_3 () {	0x4454;}
}
unless(defined(&BGE_BMANMODE_RESET)) {
    sub BGE_BMANMODE_RESET () {	0x1;}
}
unless(defined(&BGE_BMANMODE_ENABLE)) {
    sub BGE_BMANMODE_ENABLE () {	0x2;}
}
unless(defined(&BGE_BMANMODE_ATTN)) {
    sub BGE_BMANMODE_ATTN () {	0x4;}
}
unless(defined(&BGE_BMANMODE_TESTMODE)) {
    sub BGE_BMANMODE_TESTMODE () {	0x8;}
}
unless(defined(&BGE_BMANMODE_LOMBUF_ATTN)) {
    sub BGE_BMANMODE_LOMBUF_ATTN () {	0x10;}
}
unless(defined(&BGE_BMANSTAT_ERRO)) {
    sub BGE_BMANSTAT_ERRO () {	0x4;}
}
unless(defined(&BGE_BMANSTAT_LOWMBUF_ERROR)) {
    sub BGE_BMANSTAT_LOWMBUF_ERROR () {	0x10;}
}
unless(defined(&BGE_RDMA_MODE)) {
    sub BGE_RDMA_MODE () {	0x4800;}
}
unless(defined(&BGE_RDMA_STATUS)) {
    sub BGE_RDMA_STATUS () {	0x4804;}
}
unless(defined(&BGE_RDMAMODE_RESET)) {
    sub BGE_RDMAMODE_RESET () {	0x1;}
}
unless(defined(&BGE_RDMAMODE_ENABLE)) {
    sub BGE_RDMAMODE_ENABLE () {	0x2;}
}
unless(defined(&BGE_RDMAMODE_PCI_TGT_ABRT_ATTN)) {
    sub BGE_RDMAMODE_PCI_TGT_ABRT_ATTN () {	0x4;}
}
unless(defined(&BGE_RDMAMODE_PCI_MSTR_ABRT_ATTN)) {
    sub BGE_RDMAMODE_PCI_MSTR_ABRT_ATTN () {	0x8;}
}
unless(defined(&BGE_RDMAMODE_PCI_PERR_ATTN)) {
    sub BGE_RDMAMODE_PCI_PERR_ATTN () {	0x10;}
}
unless(defined(&BGE_RDMAMODE_PCI_ADDROFLOW_ATTN)) {
    sub BGE_RDMAMODE_PCI_ADDROFLOW_ATTN () {	0x20;}
}
unless(defined(&BGE_RDMAMODE_PCI_FIFOOFLOW_ATTN)) {
    sub BGE_RDMAMODE_PCI_FIFOOFLOW_ATTN () {	0x40;}
}
unless(defined(&BGE_RDMAMODE_PCI_FIFOUFLOW_ATTN)) {
    sub BGE_RDMAMODE_PCI_FIFOUFLOW_ATTN () {	0x80;}
}
unless(defined(&BGE_RDMAMODE_PCI_FIFOOREAD_ATTN)) {
    sub BGE_RDMAMODE_PCI_FIFOOREAD_ATTN () {	0x100;}
}
unless(defined(&BGE_RDMAMODE_LOCWRITE_TOOBIG)) {
    sub BGE_RDMAMODE_LOCWRITE_TOOBIG () {	0x200;}
}
unless(defined(&BGE_RDMAMODE_ALL_ATTNS)) {
    sub BGE_RDMAMODE_ALL_ATTNS () {	0x3fc;}
}
unless(defined(&BGE_RDMAMODE_BD_SBD_CRPT_ATTN)) {
    sub BGE_RDMAMODE_BD_SBD_CRPT_ATTN () {	0x800;}
}
unless(defined(&BGE_RDMAMODE_MBUF_RBD_CRPT_ATTN)) {
    sub BGE_RDMAMODE_MBUF_RBD_CRPT_ATTN () {	0x1000;}
}
unless(defined(&BGE_RDMAMODE_MBUF_SBD_CRPT_ATTN)) {
    sub BGE_RDMAMODE_MBUF_SBD_CRPT_ATTN () {	0x2000;}
}
unless(defined(&BGE_RDMAMODE_FIFO_SIZE_128)) {
    sub BGE_RDMAMODE_FIFO_SIZE_128 () {	0x20000;}
}
unless(defined(&BGE_RDMAMODE_FIFO_LONG_BURST)) {
    sub BGE_RDMAMODE_FIFO_LONG_BURST () {	0x30000;}
}
unless(defined(&BGE_RDMAMODE_MULT_DMA_RD_DIS)) {
    sub BGE_RDMAMODE_MULT_DMA_RD_DIS () {	0x1000000;}
}
unless(defined(&BGE_RDMASTAT_PCI_TGT_ABRT_ATTN)) {
    sub BGE_RDMASTAT_PCI_TGT_ABRT_ATTN () {	0x4;}
}
unless(defined(&BGE_RDMASTAT_PCI_MSTR_ABRT_ATTN)) {
    sub BGE_RDMASTAT_PCI_MSTR_ABRT_ATTN () {	0x8;}
}
unless(defined(&BGE_RDMASTAT_PCI_PERR_ATTN)) {
    sub BGE_RDMASTAT_PCI_PERR_ATTN () {	0x10;}
}
unless(defined(&BGE_RDMASTAT_PCI_ADDROFLOW_ATTN)) {
    sub BGE_RDMASTAT_PCI_ADDROFLOW_ATTN () {	0x20;}
}
unless(defined(&BGE_RDMASTAT_PCI_FIFOOFLOW_ATTN)) {
    sub BGE_RDMASTAT_PCI_FIFOOFLOW_ATTN () {	0x40;}
}
unless(defined(&BGE_RDMASTAT_PCI_FIFOUFLOW_ATTN)) {
    sub BGE_RDMASTAT_PCI_FIFOUFLOW_ATTN () {	0x80;}
}
unless(defined(&BGE_RDMASTAT_PCI_FIFOOREAD_ATTN)) {
    sub BGE_RDMASTAT_PCI_FIFOOREAD_ATTN () {	0x100;}
}
unless(defined(&BGE_RDMASTAT_LOCWRITE_TOOBIG)) {
    sub BGE_RDMASTAT_LOCWRITE_TOOBIG () {	0x200;}
}
unless(defined(&BGE_WDMA_MODE)) {
    sub BGE_WDMA_MODE () {	0x4c00;}
}
unless(defined(&BGE_WDMA_STATUS)) {
    sub BGE_WDMA_STATUS () {	0x4c04;}
}
unless(defined(&BGE_WDMAMODE_RESET)) {
    sub BGE_WDMAMODE_RESET () {	0x1;}
}
unless(defined(&BGE_WDMAMODE_ENABLE)) {
    sub BGE_WDMAMODE_ENABLE () {	0x2;}
}
unless(defined(&BGE_WDMAMODE_PCI_TGT_ABRT_ATTN)) {
    sub BGE_WDMAMODE_PCI_TGT_ABRT_ATTN () {	0x4;}
}
unless(defined(&BGE_WDMAMODE_PCI_MSTR_ABRT_ATTN)) {
    sub BGE_WDMAMODE_PCI_MSTR_ABRT_ATTN () {	0x8;}
}
unless(defined(&BGE_WDMAMODE_PCI_PERR_ATTN)) {
    sub BGE_WDMAMODE_PCI_PERR_ATTN () {	0x10;}
}
unless(defined(&BGE_WDMAMODE_PCI_ADDROFLOW_ATTN)) {
    sub BGE_WDMAMODE_PCI_ADDROFLOW_ATTN () {	0x20;}
}
unless(defined(&BGE_WDMAMODE_PCI_FIFOOFLOW_ATTN)) {
    sub BGE_WDMAMODE_PCI_FIFOOFLOW_ATTN () {	0x40;}
}
unless(defined(&BGE_WDMAMODE_PCI_FIFOUFLOW_ATTN)) {
    sub BGE_WDMAMODE_PCI_FIFOUFLOW_ATTN () {	0x80;}
}
unless(defined(&BGE_WDMAMODE_PCI_FIFOOREAD_ATTN)) {
    sub BGE_WDMAMODE_PCI_FIFOOREAD_ATTN () {	0x100;}
}
unless(defined(&BGE_WDMAMODE_LOCREAD_TOOBIG)) {
    sub BGE_WDMAMODE_LOCREAD_TOOBIG () {	0x200;}
}
unless(defined(&BGE_WDMAMODE_ALL_ATTNS)) {
    sub BGE_WDMAMODE_ALL_ATTNS () {	0x3fc;}
}
unless(defined(&BGE_WDMAMODE_RX_ACCEL)) {
    sub BGE_WDMAMODE_RX_ACCEL () {	0x400;}
}
unless(defined(&BGE_WDMAMODE_STATUS_TAG_FIX)) {
    sub BGE_WDMAMODE_STATUS_TAG_FIX () {	0x20000000;}
}
unless(defined(&BGE_WDMAMODE_BURST_ALL_DATA)) {
    sub BGE_WDMAMODE_BURST_ALL_DATA () {	0xc0000000;}
}
unless(defined(&BGE_WDMASTAT_PCI_TGT_ABRT_ATTN)) {
    sub BGE_WDMASTAT_PCI_TGT_ABRT_ATTN () {	0x4;}
}
unless(defined(&BGE_WDMASTAT_PCI_MSTR_ABRT_ATTN)) {
    sub BGE_WDMASTAT_PCI_MSTR_ABRT_ATTN () {	0x8;}
}
unless(defined(&BGE_WDMASTAT_PCI_PERR_ATTN)) {
    sub BGE_WDMASTAT_PCI_PERR_ATTN () {	0x10;}
}
unless(defined(&BGE_WDMASTAT_PCI_ADDROFLOW_ATTN)) {
    sub BGE_WDMASTAT_PCI_ADDROFLOW_ATTN () {	0x20;}
}
unless(defined(&BGE_WDMASTAT_PCI_FIFOOFLOW_ATTN)) {
    sub BGE_WDMASTAT_PCI_FIFOOFLOW_ATTN () {	0x40;}
}
unless(defined(&BGE_WDMASTAT_PCI_FIFOUFLOW_ATTN)) {
    sub BGE_WDMASTAT_PCI_FIFOUFLOW_ATTN () {	0x80;}
}
unless(defined(&BGE_WDMASTAT_PCI_FIFOOREAD_ATTN)) {
    sub BGE_WDMASTAT_PCI_FIFOOREAD_ATTN () {	0x100;}
}
unless(defined(&BGE_WDMASTAT_LOCREAD_TOOBIG)) {
    sub BGE_WDMASTAT_LOCREAD_TOOBIG () {	0x200;}
}
unless(defined(&BGE_RXCPU_MODE)) {
    sub BGE_RXCPU_MODE () {	0x5000;}
}
unless(defined(&BGE_RXCPU_STATUS)) {
    sub BGE_RXCPU_STATUS () {	0x5004;}
}
unless(defined(&BGE_RXCPU_PC)) {
    sub BGE_RXCPU_PC () {	0x501c;}
}
unless(defined(&BGE_RXCPUMODE_RESET)) {
    sub BGE_RXCPUMODE_RESET () {	0x1;}
}
unless(defined(&BGE_RXCPUMODE_SINGLESTEP)) {
    sub BGE_RXCPUMODE_SINGLESTEP () {	0x2;}
}
unless(defined(&BGE_RXCPUMODE_P0_DATAHLT_ENB)) {
    sub BGE_RXCPUMODE_P0_DATAHLT_ENB () {	0x4;}
}
unless(defined(&BGE_RXCPUMODE_P0_INSTRHLT_ENB)) {
    sub BGE_RXCPUMODE_P0_INSTRHLT_ENB () {	0x8;}
}
unless(defined(&BGE_RXCPUMODE_WR_POSTBUF_ENB)) {
    sub BGE_RXCPUMODE_WR_POSTBUF_ENB () {	0x10;}
}
unless(defined(&BGE_RXCPUMODE_DATACACHE_ENB)) {
    sub BGE_RXCPUMODE_DATACACHE_ENB () {	0x20;}
}
unless(defined(&BGE_RXCPUMODE_ROMFAIL)) {
    sub BGE_RXCPUMODE_ROMFAIL () {	0x40;}
}
unless(defined(&BGE_RXCPUMODE_WATCHDOG_ENB)) {
    sub BGE_RXCPUMODE_WATCHDOG_ENB () {	0x80;}
}
unless(defined(&BGE_RXCPUMODE_INSTRCACHE_PRF)) {
    sub BGE_RXCPUMODE_INSTRCACHE_PRF () {	0x100;}
}
unless(defined(&BGE_RXCPUMODE_INSTRCACHE_FLUSH)) {
    sub BGE_RXCPUMODE_INSTRCACHE_FLUSH () {	0x200;}
}
unless(defined(&BGE_RXCPUMODE_HALTCPU)) {
    sub BGE_RXCPUMODE_HALTCPU () {	0x400;}
}
unless(defined(&BGE_RXCPUMODE_INVDATAHLT_ENB)) {
    sub BGE_RXCPUMODE_INVDATAHLT_ENB () {	0x800;}
}
unless(defined(&BGE_RXCPUMODE_MADDRTRAPHLT_ENB)) {
    sub BGE_RXCPUMODE_MADDRTRAPHLT_ENB () {	0x1000;}
}
unless(defined(&BGE_RXCPUMODE_RADDRTRAPHLT_ENB)) {
    sub BGE_RXCPUMODE_RADDRTRAPHLT_ENB () {	0x2000;}
}
unless(defined(&BGE_RXCPUSTAT_HW_BREAKPOINT)) {
    sub BGE_RXCPUSTAT_HW_BREAKPOINT () {	0x1;}
}
unless(defined(&BGE_RXCPUSTAT_HLTINSTR_EXECUTED)) {
    sub BGE_RXCPUSTAT_HLTINSTR_EXECUTED () {	0x2;}
}
unless(defined(&BGE_RXCPUSTAT_INVALID_INSTR)) {
    sub BGE_RXCPUSTAT_INVALID_INSTR () {	0x4;}
}
unless(defined(&BGE_RXCPUSTAT_P0_DATAREF)) {
    sub BGE_RXCPUSTAT_P0_DATAREF () {	0x8;}
}
unless(defined(&BGE_RXCPUSTAT_P0_INSTRREF)) {
    sub BGE_RXCPUSTAT_P0_INSTRREF () {	0x10;}
}
unless(defined(&BGE_RXCPUSTAT_INVALID_DATAACC)) {
    sub BGE_RXCPUSTAT_INVALID_DATAACC () {	0x20;}
}
unless(defined(&BGE_RXCPUSTAT_INVALID_INSTRFTCH)) {
    sub BGE_RXCPUSTAT_INVALID_INSTRFTCH () {	0x40;}
}
unless(defined(&BGE_RXCPUSTAT_BAD_MEMALIGN)) {
    sub BGE_RXCPUSTAT_BAD_MEMALIGN () {	0x80;}
}
unless(defined(&BGE_RXCPUSTAT_MADDR_TRAP)) {
    sub BGE_RXCPUSTAT_MADDR_TRAP () {	0x100;}
}
unless(defined(&BGE_RXCPUSTAT_REGADDR_TRAP)) {
    sub BGE_RXCPUSTAT_REGADDR_TRAP () {	0x200;}
}
unless(defined(&BGE_RXCPUSTAT_DATAACC_STALL)) {
    sub BGE_RXCPUSTAT_DATAACC_STALL () {	0x1000;}
}
unless(defined(&BGE_RXCPUSTAT_INSTRFETCH_STALL)) {
    sub BGE_RXCPUSTAT_INSTRFETCH_STALL () {	0x2000;}
}
unless(defined(&BGE_RXCPUSTAT_MA_WR_FIFOOFLOW)) {
    sub BGE_RXCPUSTAT_MA_WR_FIFOOFLOW () {	0x8000000;}
}
unless(defined(&BGE_RXCPUSTAT_MA_RD_FIFOOFLOW)) {
    sub BGE_RXCPUSTAT_MA_RD_FIFOOFLOW () {	0x10000000;}
}
unless(defined(&BGE_RXCPUSTAT_MA_DATAMASK_OFLOW)) {
    sub BGE_RXCPUSTAT_MA_DATAMASK_OFLOW () {	0x20000000;}
}
unless(defined(&BGE_RXCPUSTAT_MA_REQ_FIFOOFLOW)) {
    sub BGE_RXCPUSTAT_MA_REQ_FIFOOFLOW () {	0x40000000;}
}
unless(defined(&BGE_RXCPUSTAT_BLOCKING_READ)) {
    sub BGE_RXCPUSTAT_BLOCKING_READ () {	0x80000000;}
}
unless(defined(&BGE_VCPU_STATUS)) {
    sub BGE_VCPU_STATUS () {	0x5100;}
}
unless(defined(&BGE_VCPU_EXT_CTRL)) {
    sub BGE_VCPU_EXT_CTRL () {	0x6890;}
}
unless(defined(&BGE_VCPU_STATUS_INIT_DONE)) {
    sub BGE_VCPU_STATUS_INIT_DONE () {	0x4000000;}
}
unless(defined(&BGE_VCPU_STATUS_DRV_RESET)) {
    sub BGE_VCPU_STATUS_DRV_RESET () {	0x8000000;}
}
unless(defined(&BGE_VCPU_EXT_CTRL_HALT_CPU)) {
    sub BGE_VCPU_EXT_CTRL_HALT_CPU () {	0x400000;}
}
unless(defined(&BGE_VCPU_EXT_CTRL_DISABLE_WOL)) {
    sub BGE_VCPU_EXT_CTRL_DISABLE_WOL () {	0x20000000;}
}
unless(defined(&BGE_TXCPU_MODE)) {
    sub BGE_TXCPU_MODE () {	0x5400;}
}
unless(defined(&BGE_TXCPU_STATUS)) {
    sub BGE_TXCPU_STATUS () {	0x5404;}
}
unless(defined(&BGE_TXCPU_PC)) {
    sub BGE_TXCPU_PC () {	0x541c;}
}
unless(defined(&BGE_TXCPUMODE_RESET)) {
    sub BGE_TXCPUMODE_RESET () {	0x1;}
}
unless(defined(&BGE_TXCPUMODE_SINGLESTEP)) {
    sub BGE_TXCPUMODE_SINGLESTEP () {	0x2;}
}
unless(defined(&BGE_TXCPUMODE_P0_DATAHLT_ENB)) {
    sub BGE_TXCPUMODE_P0_DATAHLT_ENB () {	0x4;}
}
unless(defined(&BGE_TXCPUMODE_P0_INSTRHLT_ENB)) {
    sub BGE_TXCPUMODE_P0_INSTRHLT_ENB () {	0x8;}
}
unless(defined(&BGE_TXCPUMODE_WR_POSTBUF_ENB)) {
    sub BGE_TXCPUMODE_WR_POSTBUF_ENB () {	0x10;}
}
unless(defined(&BGE_TXCPUMODE_DATACACHE_ENB)) {
    sub BGE_TXCPUMODE_DATACACHE_ENB () {	0x20;}
}
unless(defined(&BGE_TXCPUMODE_ROMFAIL)) {
    sub BGE_TXCPUMODE_ROMFAIL () {	0x40;}
}
unless(defined(&BGE_TXCPUMODE_WATCHDOG_ENB)) {
    sub BGE_TXCPUMODE_WATCHDOG_ENB () {	0x80;}
}
unless(defined(&BGE_TXCPUMODE_INSTRCACHE_PRF)) {
    sub BGE_TXCPUMODE_INSTRCACHE_PRF () {	0x100;}
}
unless(defined(&BGE_TXCPUMODE_INSTRCACHE_FLUSH)) {
    sub BGE_TXCPUMODE_INSTRCACHE_FLUSH () {	0x200;}
}
unless(defined(&BGE_TXCPUMODE_HALTCPU)) {
    sub BGE_TXCPUMODE_HALTCPU () {	0x400;}
}
unless(defined(&BGE_TXCPUMODE_INVDATAHLT_ENB)) {
    sub BGE_TXCPUMODE_INVDATAHLT_ENB () {	0x800;}
}
unless(defined(&BGE_TXCPUMODE_MADDRTRAPHLT_ENB)) {
    sub BGE_TXCPUMODE_MADDRTRAPHLT_ENB () {	0x1000;}
}
unless(defined(&BGE_TXCPUSTAT_HW_BREAKPOINT)) {
    sub BGE_TXCPUSTAT_HW_BREAKPOINT () {	0x1;}
}
unless(defined(&BGE_TXCPUSTAT_HLTINSTR_EXECUTED)) {
    sub BGE_TXCPUSTAT_HLTINSTR_EXECUTED () {	0x2;}
}
unless(defined(&BGE_TXCPUSTAT_INVALID_INSTR)) {
    sub BGE_TXCPUSTAT_INVALID_INSTR () {	0x4;}
}
unless(defined(&BGE_TXCPUSTAT_P0_DATAREF)) {
    sub BGE_TXCPUSTAT_P0_DATAREF () {	0x8;}
}
unless(defined(&BGE_TXCPUSTAT_P0_INSTRREF)) {
    sub BGE_TXCPUSTAT_P0_INSTRREF () {	0x10;}
}
unless(defined(&BGE_TXCPUSTAT_INVALID_DATAACC)) {
    sub BGE_TXCPUSTAT_INVALID_DATAACC () {	0x20;}
}
unless(defined(&BGE_TXCPUSTAT_INVALID_INSTRFTCH)) {
    sub BGE_TXCPUSTAT_INVALID_INSTRFTCH () {	0x40;}
}
unless(defined(&BGE_TXCPUSTAT_BAD_MEMALIGN)) {
    sub BGE_TXCPUSTAT_BAD_MEMALIGN () {	0x80;}
}
unless(defined(&BGE_TXCPUSTAT_MADDR_TRAP)) {
    sub BGE_TXCPUSTAT_MADDR_TRAP () {	0x100;}
}
unless(defined(&BGE_TXCPUSTAT_REGADDR_TRAP)) {
    sub BGE_TXCPUSTAT_REGADDR_TRAP () {	0x200;}
}
unless(defined(&BGE_TXCPUSTAT_DATAACC_STALL)) {
    sub BGE_TXCPUSTAT_DATAACC_STALL () {	0x1000;}
}
unless(defined(&BGE_TXCPUSTAT_INSTRFETCH_STALL)) {
    sub BGE_TXCPUSTAT_INSTRFETCH_STALL () {	0x2000;}
}
unless(defined(&BGE_TXCPUSTAT_MA_WR_FIFOOFLOW)) {
    sub BGE_TXCPUSTAT_MA_WR_FIFOOFLOW () {	0x8000000;}
}
unless(defined(&BGE_TXCPUSTAT_MA_RD_FIFOOFLOW)) {
    sub BGE_TXCPUSTAT_MA_RD_FIFOOFLOW () {	0x10000000;}
}
unless(defined(&BGE_TXCPUSTAT_MA_DATAMASK_OFLOW)) {
    sub BGE_TXCPUSTAT_MA_DATAMASK_OFLOW () {	0x20000000;}
}
unless(defined(&BGE_TXCPUSTAT_MA_REQ_FIFOOFLOW)) {
    sub BGE_TXCPUSTAT_MA_REQ_FIFOOFLOW () {	0x40000000;}
}
unless(defined(&BGE_TXCPUSTAT_BLOCKING_READ)) {
    sub BGE_TXCPUSTAT_BLOCKING_READ () {	0x80000000;}
}
unless(defined(&BGE_LPMBX_IRQ0_HI)) {
    sub BGE_LPMBX_IRQ0_HI () {	0x5800;}
}
unless(defined(&BGE_LPMBX_IRQ0_LO)) {
    sub BGE_LPMBX_IRQ0_LO () {	0x5804;}
}
unless(defined(&BGE_LPMBX_IRQ1_HI)) {
    sub BGE_LPMBX_IRQ1_HI () {	0x5808;}
}
unless(defined(&BGE_LPMBX_IRQ1_LO)) {
    sub BGE_LPMBX_IRQ1_LO () {	0x580c;}
}
unless(defined(&BGE_LPMBX_IRQ2_HI)) {
    sub BGE_LPMBX_IRQ2_HI () {	0x5810;}
}
unless(defined(&BGE_LPMBX_IRQ2_LO)) {
    sub BGE_LPMBX_IRQ2_LO () {	0x5814;}
}
unless(defined(&BGE_LPMBX_IRQ3_HI)) {
    sub BGE_LPMBX_IRQ3_HI () {	0x5818;}
}
unless(defined(&BGE_LPMBX_IRQ3_LO)) {
    sub BGE_LPMBX_IRQ3_LO () {	0x581c;}
}
unless(defined(&BGE_LPMBX_GEN0_HI)) {
    sub BGE_LPMBX_GEN0_HI () {	0x5820;}
}
unless(defined(&BGE_LPMBX_GEN0_LO)) {
    sub BGE_LPMBX_GEN0_LO () {	0x5824;}
}
unless(defined(&BGE_LPMBX_GEN1_HI)) {
    sub BGE_LPMBX_GEN1_HI () {	0x5828;}
}
unless(defined(&BGE_LPMBX_GEN1_LO)) {
    sub BGE_LPMBX_GEN1_LO () {	0x582c;}
}
unless(defined(&BGE_LPMBX_GEN2_HI)) {
    sub BGE_LPMBX_GEN2_HI () {	0x5830;}
}
unless(defined(&BGE_LPMBX_GEN2_LO)) {
    sub BGE_LPMBX_GEN2_LO () {	0x5834;}
}
unless(defined(&BGE_LPMBX_GEN3_HI)) {
    sub BGE_LPMBX_GEN3_HI () {	0x5828;}
}
unless(defined(&BGE_LPMBX_GEN3_LO)) {
    sub BGE_LPMBX_GEN3_LO () {	0x582c;}
}
unless(defined(&BGE_LPMBX_GEN4_HI)) {
    sub BGE_LPMBX_GEN4_HI () {	0x5840;}
}
unless(defined(&BGE_LPMBX_GEN4_LO)) {
    sub BGE_LPMBX_GEN4_LO () {	0x5844;}
}
unless(defined(&BGE_LPMBX_GEN5_HI)) {
    sub BGE_LPMBX_GEN5_HI () {	0x5848;}
}
unless(defined(&BGE_LPMBX_GEN5_LO)) {
    sub BGE_LPMBX_GEN5_LO () {	0x584c;}
}
unless(defined(&BGE_LPMBX_GEN6_HI)) {
    sub BGE_LPMBX_GEN6_HI () {	0x5850;}
}
unless(defined(&BGE_LPMBX_GEN6_LO)) {
    sub BGE_LPMBX_GEN6_LO () {	0x5854;}
}
unless(defined(&BGE_LPMBX_GEN7_HI)) {
    sub BGE_LPMBX_GEN7_HI () {	0x5858;}
}
unless(defined(&BGE_LPMBX_GEN7_LO)) {
    sub BGE_LPMBX_GEN7_LO () {	0x585c;}
}
unless(defined(&BGE_LPMBX_RELOAD_STATS_HI)) {
    sub BGE_LPMBX_RELOAD_STATS_HI () {	0x5860;}
}
unless(defined(&BGE_LPMBX_RELOAD_STATS_LO)) {
    sub BGE_LPMBX_RELOAD_STATS_LO () {	0x5864;}
}
unless(defined(&BGE_LPMBX_RX_STD_PROD_HI)) {
    sub BGE_LPMBX_RX_STD_PROD_HI () {	0x5868;}
}
unless(defined(&BGE_LPMBX_RX_STD_PROD_LO)) {
    sub BGE_LPMBX_RX_STD_PROD_LO () {	0x586c;}
}
unless(defined(&BGE_LPMBX_RX_JUMBO_PROD_HI)) {
    sub BGE_LPMBX_RX_JUMBO_PROD_HI () {	0x5870;}
}
unless(defined(&BGE_LPMBX_RX_JUMBO_PROD_LO)) {
    sub BGE_LPMBX_RX_JUMBO_PROD_LO () {	0x5874;}
}
unless(defined(&BGE_LPMBX_RX_MINI_PROD_HI)) {
    sub BGE_LPMBX_RX_MINI_PROD_HI () {	0x5878;}
}
unless(defined(&BGE_LPMBX_RX_MINI_PROD_LO)) {
    sub BGE_LPMBX_RX_MINI_PROD_LO () {	0x587c;}
}
unless(defined(&BGE_LPMBX_RX_CONS0_HI)) {
    sub BGE_LPMBX_RX_CONS0_HI () {	0x5880;}
}
unless(defined(&BGE_LPMBX_RX_CONS0_LO)) {
    sub BGE_LPMBX_RX_CONS0_LO () {	0x5884;}
}
unless(defined(&BGE_LPMBX_RX_CONS1_HI)) {
    sub BGE_LPMBX_RX_CONS1_HI () {	0x5888;}
}
unless(defined(&BGE_LPMBX_RX_CONS1_LO)) {
    sub BGE_LPMBX_RX_CONS1_LO () {	0x588c;}
}
unless(defined(&BGE_LPMBX_RX_CONS2_HI)) {
    sub BGE_LPMBX_RX_CONS2_HI () {	0x5890;}
}
unless(defined(&BGE_LPMBX_RX_CONS2_LO)) {
    sub BGE_LPMBX_RX_CONS2_LO () {	0x5894;}
}
unless(defined(&BGE_LPMBX_RX_CONS3_HI)) {
    sub BGE_LPMBX_RX_CONS3_HI () {	0x5898;}
}
unless(defined(&BGE_LPMBX_RX_CONS3_LO)) {
    sub BGE_LPMBX_RX_CONS3_LO () {	0x589c;}
}
unless(defined(&BGE_LPMBX_RX_CONS4_HI)) {
    sub BGE_LPMBX_RX_CONS4_HI () {	0x58a0;}
}
unless(defined(&BGE_LPMBX_RX_CONS4_LO)) {
    sub BGE_LPMBX_RX_CONS4_LO () {	0x58a4;}
}
unless(defined(&BGE_LPMBX_RX_CONS5_HI)) {
    sub BGE_LPMBX_RX_CONS5_HI () {	0x58a8;}
}
unless(defined(&BGE_LPMBX_RX_CONS5_LO)) {
    sub BGE_LPMBX_RX_CONS5_LO () {	0x58ac;}
}
unless(defined(&BGE_LPMBX_RX_CONS6_HI)) {
    sub BGE_LPMBX_RX_CONS6_HI () {	0x58b0;}
}
unless(defined(&BGE_LPMBX_RX_CONS6_LO)) {
    sub BGE_LPMBX_RX_CONS6_LO () {	0x58b4;}
}
unless(defined(&BGE_LPMBX_RX_CONS7_HI)) {
    sub BGE_LPMBX_RX_CONS7_HI () {	0x58b8;}
}
unless(defined(&BGE_LPMBX_RX_CONS7_LO)) {
    sub BGE_LPMBX_RX_CONS7_LO () {	0x58bc;}
}
unless(defined(&BGE_LPMBX_RX_CONS8_HI)) {
    sub BGE_LPMBX_RX_CONS8_HI () {	0x58c0;}
}
unless(defined(&BGE_LPMBX_RX_CONS8_LO)) {
    sub BGE_LPMBX_RX_CONS8_LO () {	0x58c4;}
}
unless(defined(&BGE_LPMBX_RX_CONS9_HI)) {
    sub BGE_LPMBX_RX_CONS9_HI () {	0x58c8;}
}
unless(defined(&BGE_LPMBX_RX_CONS9_LO)) {
    sub BGE_LPMBX_RX_CONS9_LO () {	0x58cc;}
}
unless(defined(&BGE_LPMBX_RX_CONS10_HI)) {
    sub BGE_LPMBX_RX_CONS10_HI () {	0x58d0;}
}
unless(defined(&BGE_LPMBX_RX_CONS10_LO)) {
    sub BGE_LPMBX_RX_CONS10_LO () {	0x58d4;}
}
unless(defined(&BGE_LPMBX_RX_CONS11_HI)) {
    sub BGE_LPMBX_RX_CONS11_HI () {	0x58d8;}
}
unless(defined(&BGE_LPMBX_RX_CONS11_LO)) {
    sub BGE_LPMBX_RX_CONS11_LO () {	0x58dc;}
}
unless(defined(&BGE_LPMBX_RX_CONS12_HI)) {
    sub BGE_LPMBX_RX_CONS12_HI () {	0x58e0;}
}
unless(defined(&BGE_LPMBX_RX_CONS12_LO)) {
    sub BGE_LPMBX_RX_CONS12_LO () {	0x58e4;}
}
unless(defined(&BGE_LPMBX_RX_CONS13_HI)) {
    sub BGE_LPMBX_RX_CONS13_HI () {	0x58e8;}
}
unless(defined(&BGE_LPMBX_RX_CONS13_LO)) {
    sub BGE_LPMBX_RX_CONS13_LO () {	0x58ec;}
}
unless(defined(&BGE_LPMBX_RX_CONS14_HI)) {
    sub BGE_LPMBX_RX_CONS14_HI () {	0x58f0;}
}
unless(defined(&BGE_LPMBX_RX_CONS14_LO)) {
    sub BGE_LPMBX_RX_CONS14_LO () {	0x58f4;}
}
unless(defined(&BGE_LPMBX_RX_CONS15_HI)) {
    sub BGE_LPMBX_RX_CONS15_HI () {	0x58f8;}
}
unless(defined(&BGE_LPMBX_RX_CONS15_LO)) {
    sub BGE_LPMBX_RX_CONS15_LO () {	0x58fc;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD0_HI)) {
    sub BGE_LPMBX_TX_HOST_PROD0_HI () {	0x5900;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD0_LO)) {
    sub BGE_LPMBX_TX_HOST_PROD0_LO () {	0x5904;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD1_HI)) {
    sub BGE_LPMBX_TX_HOST_PROD1_HI () {	0x5908;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD1_LO)) {
    sub BGE_LPMBX_TX_HOST_PROD1_LO () {	0x590c;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD2_HI)) {
    sub BGE_LPMBX_TX_HOST_PROD2_HI () {	0x5910;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD2_LO)) {
    sub BGE_LPMBX_TX_HOST_PROD2_LO () {	0x5914;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD3_HI)) {
    sub BGE_LPMBX_TX_HOST_PROD3_HI () {	0x5918;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD3_LO)) {
    sub BGE_LPMBX_TX_HOST_PROD3_LO () {	0x591c;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD4_HI)) {
    sub BGE_LPMBX_TX_HOST_PROD4_HI () {	0x5920;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD4_LO)) {
    sub BGE_LPMBX_TX_HOST_PROD4_LO () {	0x5924;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD5_HI)) {
    sub BGE_LPMBX_TX_HOST_PROD5_HI () {	0x5928;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD5_LO)) {
    sub BGE_LPMBX_TX_HOST_PROD5_LO () {	0x592c;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD6_HI)) {
    sub BGE_LPMBX_TX_HOST_PROD6_HI () {	0x5930;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD6_LO)) {
    sub BGE_LPMBX_TX_HOST_PROD6_LO () {	0x5934;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD7_HI)) {
    sub BGE_LPMBX_TX_HOST_PROD7_HI () {	0x5938;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD7_LO)) {
    sub BGE_LPMBX_TX_HOST_PROD7_LO () {	0x593c;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD8_HI)) {
    sub BGE_LPMBX_TX_HOST_PROD8_HI () {	0x5940;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD8_LO)) {
    sub BGE_LPMBX_TX_HOST_PROD8_LO () {	0x5944;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD9_HI)) {
    sub BGE_LPMBX_TX_HOST_PROD9_HI () {	0x5948;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD9_LO)) {
    sub BGE_LPMBX_TX_HOST_PROD9_LO () {	0x594c;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD10_HI)) {
    sub BGE_LPMBX_TX_HOST_PROD10_HI () {	0x5950;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD10_LO)) {
    sub BGE_LPMBX_TX_HOST_PROD10_LO () {	0x5954;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD11_HI)) {
    sub BGE_LPMBX_TX_HOST_PROD11_HI () {	0x5958;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD11_LO)) {
    sub BGE_LPMBX_TX_HOST_PROD11_LO () {	0x595c;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD12_HI)) {
    sub BGE_LPMBX_TX_HOST_PROD12_HI () {	0x5960;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD12_LO)) {
    sub BGE_LPMBX_TX_HOST_PROD12_LO () {	0x5964;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD13_HI)) {
    sub BGE_LPMBX_TX_HOST_PROD13_HI () {	0x5968;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD13_LO)) {
    sub BGE_LPMBX_TX_HOST_PROD13_LO () {	0x596c;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD14_HI)) {
    sub BGE_LPMBX_TX_HOST_PROD14_HI () {	0x5970;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD14_LO)) {
    sub BGE_LPMBX_TX_HOST_PROD14_LO () {	0x5974;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD15_HI)) {
    sub BGE_LPMBX_TX_HOST_PROD15_HI () {	0x5978;}
}
unless(defined(&BGE_LPMBX_TX_HOST_PROD15_LO)) {
    sub BGE_LPMBX_TX_HOST_PROD15_LO () {	0x597c;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD0_HI)) {
    sub BGE_LPMBX_TX_NIC_PROD0_HI () {	0x5980;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD0_LO)) {
    sub BGE_LPMBX_TX_NIC_PROD0_LO () {	0x5984;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD1_HI)) {
    sub BGE_LPMBX_TX_NIC_PROD1_HI () {	0x5988;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD1_LO)) {
    sub BGE_LPMBX_TX_NIC_PROD1_LO () {	0x598c;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD2_HI)) {
    sub BGE_LPMBX_TX_NIC_PROD2_HI () {	0x5990;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD2_LO)) {
    sub BGE_LPMBX_TX_NIC_PROD2_LO () {	0x5994;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD3_HI)) {
    sub BGE_LPMBX_TX_NIC_PROD3_HI () {	0x5998;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD3_LO)) {
    sub BGE_LPMBX_TX_NIC_PROD3_LO () {	0x599c;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD4_HI)) {
    sub BGE_LPMBX_TX_NIC_PROD4_HI () {	0x59a0;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD4_LO)) {
    sub BGE_LPMBX_TX_NIC_PROD4_LO () {	0x59a4;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD5_HI)) {
    sub BGE_LPMBX_TX_NIC_PROD5_HI () {	0x59a8;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD5_LO)) {
    sub BGE_LPMBX_TX_NIC_PROD5_LO () {	0x59ac;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD6_HI)) {
    sub BGE_LPMBX_TX_NIC_PROD6_HI () {	0x59b0;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD6_LO)) {
    sub BGE_LPMBX_TX_NIC_PROD6_LO () {	0x59b4;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD7_HI)) {
    sub BGE_LPMBX_TX_NIC_PROD7_HI () {	0x59b8;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD7_LO)) {
    sub BGE_LPMBX_TX_NIC_PROD7_LO () {	0x59bc;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD8_HI)) {
    sub BGE_LPMBX_TX_NIC_PROD8_HI () {	0x59c0;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD8_LO)) {
    sub BGE_LPMBX_TX_NIC_PROD8_LO () {	0x59c4;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD9_HI)) {
    sub BGE_LPMBX_TX_NIC_PROD9_HI () {	0x59c8;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD9_LO)) {
    sub BGE_LPMBX_TX_NIC_PROD9_LO () {	0x59cc;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD10_HI)) {
    sub BGE_LPMBX_TX_NIC_PROD10_HI () {	0x59d0;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD10_LO)) {
    sub BGE_LPMBX_TX_NIC_PROD10_LO () {	0x59d4;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD11_HI)) {
    sub BGE_LPMBX_TX_NIC_PROD11_HI () {	0x59d8;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD11_LO)) {
    sub BGE_LPMBX_TX_NIC_PROD11_LO () {	0x59dc;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD12_HI)) {
    sub BGE_LPMBX_TX_NIC_PROD12_HI () {	0x59e0;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD12_LO)) {
    sub BGE_LPMBX_TX_NIC_PROD12_LO () {	0x59e4;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD13_HI)) {
    sub BGE_LPMBX_TX_NIC_PROD13_HI () {	0x59e8;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD13_LO)) {
    sub BGE_LPMBX_TX_NIC_PROD13_LO () {	0x59ec;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD14_HI)) {
    sub BGE_LPMBX_TX_NIC_PROD14_HI () {	0x59f0;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD14_LO)) {
    sub BGE_LPMBX_TX_NIC_PROD14_LO () {	0x59f4;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD15_HI)) {
    sub BGE_LPMBX_TX_NIC_PROD15_HI () {	0x59f8;}
}
unless(defined(&BGE_LPMBX_TX_NIC_PROD15_LO)) {
    sub BGE_LPMBX_TX_NIC_PROD15_LO () {	0x59fc;}
}
unless(defined(&BGE_FTQ_RESET)) {
    sub BGE_FTQ_RESET () {	0x5c00;}
}
unless(defined(&BGE_FTQRESET_DMAREAD)) {
    sub BGE_FTQRESET_DMAREAD () {	0x2;}
}
unless(defined(&BGE_FTQRESET_DMAHIPRIO_RD)) {
    sub BGE_FTQRESET_DMAHIPRIO_RD () {	0x4;}
}
unless(defined(&BGE_FTQRESET_DMADONE)) {
    sub BGE_FTQRESET_DMADONE () {	0x10;}
}
unless(defined(&BGE_FTQRESET_SBDC)) {
    sub BGE_FTQRESET_SBDC () {	0x20;}
}
unless(defined(&BGE_FTQRESET_SDI)) {
    sub BGE_FTQRESET_SDI () {	0x40;}
}
unless(defined(&BGE_FTQRESET_WDMA)) {
    sub BGE_FTQRESET_WDMA () {	0x80;}
}
unless(defined(&BGE_FTQRESET_DMAHIPRIO_WR)) {
    sub BGE_FTQRESET_DMAHIPRIO_WR () {	0x100;}
}
unless(defined(&BGE_FTQRESET_TYPE1_SOFTWARE)) {
    sub BGE_FTQRESET_TYPE1_SOFTWARE () {	0x200;}
}
unless(defined(&BGE_FTQRESET_SDC)) {
    sub BGE_FTQRESET_SDC () {	0x400;}
}
unless(defined(&BGE_FTQRESET_HCC)) {
    sub BGE_FTQRESET_HCC () {	0x800;}
}
unless(defined(&BGE_FTQRESET_TXFIFO)) {
    sub BGE_FTQRESET_TXFIFO () {	0x1000;}
}
unless(defined(&BGE_FTQRESET_MBC)) {
    sub BGE_FTQRESET_MBC () {	0x2000;}
}
unless(defined(&BGE_FTQRESET_RBDC)) {
    sub BGE_FTQRESET_RBDC () {	0x4000;}
}
unless(defined(&BGE_FTQRESET_RXLP)) {
    sub BGE_FTQRESET_RXLP () {	0x8000;}
}
unless(defined(&BGE_FTQRESET_RDBDI)) {
    sub BGE_FTQRESET_RDBDI () {	0x10000;}
}
unless(defined(&BGE_FTQRESET_RDC)) {
    sub BGE_FTQRESET_RDC () {	0x20000;}
}
unless(defined(&BGE_FTQRESET_TYPE2_SOFTWARE)) {
    sub BGE_FTQRESET_TYPE2_SOFTWARE () {	0x40000;}
}
unless(defined(&BGE_MSI_MODE)) {
    sub BGE_MSI_MODE () {	0x6000;}
}
unless(defined(&BGE_MSI_STATUS)) {
    sub BGE_MSI_STATUS () {	0x6004;}
}
unless(defined(&BGE_MSI_FIFOACCESS)) {
    sub BGE_MSI_FIFOACCESS () {	0x6008;}
}
unless(defined(&BGE_MSIMODE_RESET)) {
    sub BGE_MSIMODE_RESET () {	0x1;}
}
unless(defined(&BGE_MSIMODE_ENABLE)) {
    sub BGE_MSIMODE_ENABLE () {	0x2;}
}
unless(defined(&BGE_MSIMODE_PCI_TGT_ABRT_ATTN)) {
    sub BGE_MSIMODE_PCI_TGT_ABRT_ATTN () {	0x4;}
}
unless(defined(&BGE_MSIMODE_PCI_MSTR_ABRT_ATTN)) {
    sub BGE_MSIMODE_PCI_MSTR_ABRT_ATTN () {	0x8;}
}
unless(defined(&BGE_MSIMODE_PCI_PERR_ATTN)) {
    sub BGE_MSIMODE_PCI_PERR_ATTN () {	0x10;}
}
unless(defined(&BGE_MSIMODE_MSI_FIFOUFLOW_ATTN)) {
    sub BGE_MSIMODE_MSI_FIFOUFLOW_ATTN () {	0x20;}
}
unless(defined(&BGE_MSIMODE_MSI_FIFOOFLOW_ATTN)) {
    sub BGE_MSIMODE_MSI_FIFOOFLOW_ATTN () {	0x40;}
}
unless(defined(&BGE_MSISTAT_PCI_TGT_ABRT_ATTN)) {
    sub BGE_MSISTAT_PCI_TGT_ABRT_ATTN () {	0x4;}
}
unless(defined(&BGE_MSISTAT_PCI_MSTR_ABRT_ATTN)) {
    sub BGE_MSISTAT_PCI_MSTR_ABRT_ATTN () {	0x8;}
}
unless(defined(&BGE_MSISTAT_PCI_PERR_ATTN)) {
    sub BGE_MSISTAT_PCI_PERR_ATTN () {	0x10;}
}
unless(defined(&BGE_MSISTAT_MSI_FIFOUFLOW_ATTN)) {
    sub BGE_MSISTAT_MSI_FIFOUFLOW_ATTN () {	0x20;}
}
unless(defined(&BGE_MSISTAT_MSI_FIFOOFLOW_ATTN)) {
    sub BGE_MSISTAT_MSI_FIFOOFLOW_ATTN () {	0x40;}
}
unless(defined(&BGE_DMAC_MODE)) {
    sub BGE_DMAC_MODE () {	0x6400;}
}
unless(defined(&BGE_DMACMODE_RESET)) {
    sub BGE_DMACMODE_RESET () {	0x1;}
}
unless(defined(&BGE_DMACMODE_ENABLE)) {
    sub BGE_DMACMODE_ENABLE () {	0x2;}
}
unless(defined(&BGE_MODE_CTL)) {
    sub BGE_MODE_CTL () {	0x6800;}
}
unless(defined(&BGE_MISC_CFG)) {
    sub BGE_MISC_CFG () {	0x6804;}
}
unless(defined(&BGE_MISC_LOCAL_CTL)) {
    sub BGE_MISC_LOCAL_CTL () {	0x6808;}
}
unless(defined(&BGE_CPU_EVENT)) {
    sub BGE_CPU_EVENT () {	0x6810;}
}
unless(defined(&BGE_EE_ADDR)) {
    sub BGE_EE_ADDR () {	0x6838;}
}
unless(defined(&BGE_EE_DATA)) {
    sub BGE_EE_DATA () {	0x683c;}
}
unless(defined(&BGE_EE_CTL)) {
    sub BGE_EE_CTL () {	0x6840;}
}
unless(defined(&BGE_MDI_CTL)) {
    sub BGE_MDI_CTL () {	0x6844;}
}
unless(defined(&BGE_EE_DELAY)) {
    sub BGE_EE_DELAY () {	0x6848;}
}
unless(defined(&BGE_FASTBOOT_PC)) {
    sub BGE_FASTBOOT_PC () {	0x6894;}
}
unless(defined(&BGE_NVRAM_CMD)) {
    sub BGE_NVRAM_CMD () {	0x7000;}
}
unless(defined(&BGE_NVRAM_STAT)) {
    sub BGE_NVRAM_STAT () {	0x7004;}
}
unless(defined(&BGE_NVRAM_WRDATA)) {
    sub BGE_NVRAM_WRDATA () {	0x7008;}
}
unless(defined(&BGE_NVRAM_ADDR)) {
    sub BGE_NVRAM_ADDR () {	0x700c;}
}
unless(defined(&BGE_NVRAM_RDDATA)) {
    sub BGE_NVRAM_RDDATA () {	0x7010;}
}
unless(defined(&BGE_NVRAM_CFG1)) {
    sub BGE_NVRAM_CFG1 () {	0x7014;}
}
unless(defined(&BGE_NVRAM_CFG2)) {
    sub BGE_NVRAM_CFG2 () {	0x7018;}
}
unless(defined(&BGE_NVRAM_CFG3)) {
    sub BGE_NVRAM_CFG3 () {	0x701c;}
}
unless(defined(&BGE_NVRAM_SWARB)) {
    sub BGE_NVRAM_SWARB () {	0x7020;}
}
unless(defined(&BGE_NVRAM_ACCESS)) {
    sub BGE_NVRAM_ACCESS () {	0x7024;}
}
unless(defined(&BGE_NVRAM_WRITE1)) {
    sub BGE_NVRAM_WRITE1 () {	0x7028;}
}
unless(defined(&BGE_NVRAMCMD_RESET)) {
    sub BGE_NVRAMCMD_RESET () {	0x1;}
}
unless(defined(&BGE_NVRAMCMD_DONE)) {
    sub BGE_NVRAMCMD_DONE () {	0x8;}
}
unless(defined(&BGE_NVRAMCMD_START)) {
    sub BGE_NVRAMCMD_START () {	0x10;}
}
unless(defined(&BGE_NVRAMCMD_WR)) {
    sub BGE_NVRAMCMD_WR () {	0x20;}
}
unless(defined(&BGE_NVRAMCMD_ERASE)) {
    sub BGE_NVRAMCMD_ERASE () {	0x40;}
}
unless(defined(&BGE_NVRAMCMD_FIRST)) {
    sub BGE_NVRAMCMD_FIRST () {	0x80;}
}
unless(defined(&BGE_NVRAMCMD_LAST)) {
    sub BGE_NVRAMCMD_LAST () {	0x100;}
}
unless(defined(&BGE_NVRAM_READCMD)) {
    sub BGE_NVRAM_READCMD () {	( &BGE_NVRAMCMD_FIRST| &BGE_NVRAMCMD_LAST|  &BGE_NVRAMCMD_START| &BGE_NVRAMCMD_DONE);}
}
unless(defined(&BGE_NVRAM_WRITECMD)) {
    sub BGE_NVRAM_WRITECMD () {	( &BGE_NVRAMCMD_FIRST| &BGE_NVRAMCMD_LAST|  &BGE_NVRAMCMD_START| &BGE_NVRAMCMD_DONE| &BGE_NVRAMCMD_WR);}
}
unless(defined(&BGE_NVRAMSWARB_SET0)) {
    sub BGE_NVRAMSWARB_SET0 () {	0x1;}
}
unless(defined(&BGE_NVRAMSWARB_SET1)) {
    sub BGE_NVRAMSWARB_SET1 () {	0x2;}
}
unless(defined(&BGE_NVRAMSWARB_SET2)) {
    sub BGE_NVRAMSWARB_SET2 () {	0x3;}
}
unless(defined(&BGE_NVRAMSWARB_SET3)) {
    sub BGE_NVRAMSWARB_SET3 () {	0x4;}
}
unless(defined(&BGE_NVRAMSWARB_CLR0)) {
    sub BGE_NVRAMSWARB_CLR0 () {	0x10;}
}
unless(defined(&BGE_NVRAMSWARB_CLR1)) {
    sub BGE_NVRAMSWARB_CLR1 () {	0x20;}
}
unless(defined(&BGE_NVRAMSWARB_CLR2)) {
    sub BGE_NVRAMSWARB_CLR2 () {	0x40;}
}
unless(defined(&BGE_NVRAMSWARB_CLR3)) {
    sub BGE_NVRAMSWARB_CLR3 () {	0x80;}
}
unless(defined(&BGE_NVRAMSWARB_GNT0)) {
    sub BGE_NVRAMSWARB_GNT0 () {	0x100;}
}
unless(defined(&BGE_NVRAMSWARB_GNT1)) {
    sub BGE_NVRAMSWARB_GNT1 () {	0x200;}
}
unless(defined(&BGE_NVRAMSWARB_GNT2)) {
    sub BGE_NVRAMSWARB_GNT2 () {	0x400;}
}
unless(defined(&BGE_NVRAMSWARB_GNT3)) {
    sub BGE_NVRAMSWARB_GNT3 () {	0x800;}
}
unless(defined(&BGE_NVRAMSWARB_REQ0)) {
    sub BGE_NVRAMSWARB_REQ0 () {	0x1000;}
}
unless(defined(&BGE_NVRAMSWARB_REQ1)) {
    sub BGE_NVRAMSWARB_REQ1 () {	0x2000;}
}
unless(defined(&BGE_NVRAMSWARB_REQ2)) {
    sub BGE_NVRAMSWARB_REQ2 () {	0x4000;}
}
unless(defined(&BGE_NVRAMSWARB_REQ3)) {
    sub BGE_NVRAMSWARB_REQ3 () {	0x8000;}
}
unless(defined(&BGE_NVRAMACC_ENABLE)) {
    sub BGE_NVRAMACC_ENABLE () {	0x1;}
}
unless(defined(&BGE_NVRAMACC_WRENABLE)) {
    sub BGE_NVRAMACC_WRENABLE () {	0x2;}
}
unless(defined(&BGE_TLP_CONTROL_REG)) {
    sub BGE_TLP_CONTROL_REG () {	0x7c00;}
}
unless(defined(&BGE_TLP_DATA_FIFO_PROTECT)) {
    sub BGE_TLP_DATA_FIFO_PROTECT () {	0x2000000;}
}
unless(defined(&BGE_PHY_TEST_CTRL_REG)) {
    sub BGE_PHY_TEST_CTRL_REG () {	0x7e2c;}
}
unless(defined(&BGE_PHY_PCIE_SCRAM_MODE)) {
    sub BGE_PHY_PCIE_SCRAM_MODE () {	0x20;}
}
unless(defined(&BGE_PHY_PCIE_LTASS_MODE)) {
    sub BGE_PHY_PCIE_LTASS_MODE () {	0x40;}
}
unless(defined(&BGE_MODECTL_INT_SNDCOAL_ONLY)) {
    sub BGE_MODECTL_INT_SNDCOAL_ONLY () {	0x1;}
}
unless(defined(&BGE_MODECTL_BYTESWAP_NONFRAME)) {
    sub BGE_MODECTL_BYTESWAP_NONFRAME () {	0x2;}
}
unless(defined(&BGE_MODECTL_WORDSWAP_NONFRAME)) {
    sub BGE_MODECTL_WORDSWAP_NONFRAME () {	0x4;}
}
unless(defined(&BGE_MODECTL_BYTESWAP_DATA)) {
    sub BGE_MODECTL_BYTESWAP_DATA () {	0x10;}
}
unless(defined(&BGE_MODECTL_WORDSWAP_DATA)) {
    sub BGE_MODECTL_WORDSWAP_DATA () {	0x20;}
}
unless(defined(&BGE_MODECTL_NO_FRAME_CRACKING)) {
    sub BGE_MODECTL_NO_FRAME_CRACKING () {	0x200;}
}
unless(defined(&BGE_MODECTL_NO_RX_CRC)) {
    sub BGE_MODECTL_NO_RX_CRC () {	0x400;}
}
unless(defined(&BGE_MODECTL_RX_BADFRAMES)) {
    sub BGE_MODECTL_RX_BADFRAMES () {	0x800;}
}
unless(defined(&BGE_MODECTL_NO_TX_INTR)) {
    sub BGE_MODECTL_NO_TX_INTR () {	0x2000;}
}
unless(defined(&BGE_MODECTL_NO_RX_INTR)) {
    sub BGE_MODECTL_NO_RX_INTR () {	0x4000;}
}
unless(defined(&BGE_MODECTL_FORCE_PCI32)) {
    sub BGE_MODECTL_FORCE_PCI32 () {	0x8000;}
}
unless(defined(&BGE_MODECTL_STACKUP)) {
    sub BGE_MODECTL_STACKUP () {	0x10000;}
}
unless(defined(&BGE_MODECTL_HOST_SEND_BDS)) {
    sub BGE_MODECTL_HOST_SEND_BDS () {	0x20000;}
}
unless(defined(&BGE_MODECTL_TX_NO_PHDR_CSUM)) {
    sub BGE_MODECTL_TX_NO_PHDR_CSUM () {	0x100000;}
}
unless(defined(&BGE_MODECTL_RX_NO_PHDR_CSUM)) {
    sub BGE_MODECTL_RX_NO_PHDR_CSUM () {	0x800000;}
}
unless(defined(&BGE_MODECTL_TX_ATTN_INTR)) {
    sub BGE_MODECTL_TX_ATTN_INTR () {	0x1000000;}
}
unless(defined(&BGE_MODECTL_RX_ATTN_INTR)) {
    sub BGE_MODECTL_RX_ATTN_INTR () {	0x2000000;}
}
unless(defined(&BGE_MODECTL_MAC_ATTN_INTR)) {
    sub BGE_MODECTL_MAC_ATTN_INTR () {	0x4000000;}
}
unless(defined(&BGE_MODECTL_DMA_ATTN_INTR)) {
    sub BGE_MODECTL_DMA_ATTN_INTR () {	0x8000000;}
}
unless(defined(&BGE_MODECTL_FLOWCTL_ATTN_INTR)) {
    sub BGE_MODECTL_FLOWCTL_ATTN_INTR () {	0x10000000;}
}
unless(defined(&BGE_MODECTL_4X_SENDRING_SZ)) {
    sub BGE_MODECTL_4X_SENDRING_SZ () {	0x20000000;}
}
unless(defined(&BGE_MODECTL_FW_PROCESS_MCASTS)) {
    sub BGE_MODECTL_FW_PROCESS_MCASTS () {	0x40000000;}
}
unless(defined(&BGE_MISCCFG_RESET_CORE_CLOCKS)) {
    sub BGE_MISCCFG_RESET_CORE_CLOCKS () {	0x1;}
}
unless(defined(&BGE_MISCCFG_TIMER_PRESCALER)) {
    sub BGE_MISCCFG_TIMER_PRESCALER () {	0xfe;}
}
unless(defined(&BGE_MISCCFG_BOARD_ID_5788)) {
    sub BGE_MISCCFG_BOARD_ID_5788 () {	0x10000;}
}
unless(defined(&BGE_MISCCFG_BOARD_ID_5788M)) {
    sub BGE_MISCCFG_BOARD_ID_5788M () {	0x18000;}
}
unless(defined(&BGE_MISCCFG_BOARD_ID_MASK)) {
    sub BGE_MISCCFG_BOARD_ID_MASK () {	0x1e000;}
}
unless(defined(&BGE_MISCCFG_EPHY_IDDQ)) {
    sub BGE_MISCCFG_EPHY_IDDQ () {	0x200000;}
}
unless(defined(&BGE_MISCCFG_KEEP_GPHY_POWER)) {
    sub BGE_MISCCFG_KEEP_GPHY_POWER () {	0x4000000;}
}
unless(defined(&BGE_32BITTIME_66MHZ)) {
    sub BGE_32BITTIME_66MHZ () {	(0x41 << 1);}
}
unless(defined(&BGE_MLC_INTR_STATE)) {
    sub BGE_MLC_INTR_STATE () {	0x1;}
}
unless(defined(&BGE_MLC_INTR_CLR)) {
    sub BGE_MLC_INTR_CLR () {	0x2;}
}
unless(defined(&BGE_MLC_INTR_SET)) {
    sub BGE_MLC_INTR_SET () {	0x4;}
}
unless(defined(&BGE_MLC_INTR_ONATTN)) {
    sub BGE_MLC_INTR_ONATTN () {	0x8;}
}
unless(defined(&BGE_MLC_MISCIO_IN0)) {
    sub BGE_MLC_MISCIO_IN0 () {	0x100;}
}
unless(defined(&BGE_MLC_MISCIO_IN1)) {
    sub BGE_MLC_MISCIO_IN1 () {	0x200;}
}
unless(defined(&BGE_MLC_MISCIO_IN2)) {
    sub BGE_MLC_MISCIO_IN2 () {	0x400;}
}
unless(defined(&BGE_MLC_MISCIO_OUTEN0)) {
    sub BGE_MLC_MISCIO_OUTEN0 () {	0x800;}
}
unless(defined(&BGE_MLC_MISCIO_OUTEN1)) {
    sub BGE_MLC_MISCIO_OUTEN1 () {	0x1000;}
}
unless(defined(&BGE_MLC_MISCIO_OUTEN2)) {
    sub BGE_MLC_MISCIO_OUTEN2 () {	0x2000;}
}
unless(defined(&BGE_MLC_MISCIO_OUT0)) {
    sub BGE_MLC_MISCIO_OUT0 () {	0x4000;}
}
unless(defined(&BGE_MLC_MISCIO_OUT1)) {
    sub BGE_MLC_MISCIO_OUT1 () {	0x8000;}
}
unless(defined(&BGE_MLC_MISCIO_OUT2)) {
    sub BGE_MLC_MISCIO_OUT2 () {	0x10000;}
}
unless(defined(&BGE_MLC_EXTRAM_ENB)) {
    sub BGE_MLC_EXTRAM_ENB () {	0x20000;}
}
unless(defined(&BGE_MLC_SRAM_SIZE)) {
    sub BGE_MLC_SRAM_SIZE () {	0x1c0000;}
}
unless(defined(&BGE_MLC_BANK_SEL)) {
    sub BGE_MLC_BANK_SEL () {	0x200000;}
}
unless(defined(&BGE_MLC_SSRAM_TYPE)) {
    sub BGE_MLC_SSRAM_TYPE () {	0x400000;}
}
unless(defined(&BGE_MLC_SSRAM_CYC_DESEL)) {
    sub BGE_MLC_SSRAM_CYC_DESEL () {	0x800000;}
}
unless(defined(&BGE_MLC_AUTO_EEPROM)) {
    sub BGE_MLC_AUTO_EEPROM () {	0x1000000;}
}
unless(defined(&BGE_SSRAMSIZE_256KB)) {
    sub BGE_SSRAMSIZE_256KB () {	0x;}
}
unless(defined(&BGE_SSRAMSIZE_512KB)) {
    sub BGE_SSRAMSIZE_512KB () {	0x40000;}
}
unless(defined(&BGE_SSRAMSIZE_1MB)) {
    sub BGE_SSRAMSIZE_1MB () {	0x80000;}
}
unless(defined(&BGE_SSRAMSIZE_2MB)) {
    sub BGE_SSRAMSIZE_2MB () {	0xc0000;}
}
unless(defined(&BGE_SSRAMSIZE_4MB)) {
    sub BGE_SSRAMSIZE_4MB () {	0x100000;}
}
unless(defined(&BGE_SSRAMSIZE_8MB)) {
    sub BGE_SSRAMSIZE_8MB () {	0x140000;}
}
unless(defined(&BGE_SSRAMSIZE_16M)) {
    sub BGE_SSRAMSIZE_16M () {	0x180000;}
}
unless(defined(&BGE_EEADDR_ADDRESS)) {
    sub BGE_EEADDR_ADDRESS () {	0xfffc;}
}
unless(defined(&BGE_EEADDR_HALFCLK)) {
    sub BGE_EEADDR_HALFCLK () {	0x1ff0000;}
}
unless(defined(&BGE_EEADDR_START)) {
    sub BGE_EEADDR_START () {	0x2000000;}
}
unless(defined(&BGE_EEADDR_DEVID)) {
    sub BGE_EEADDR_DEVID () {	0x1c000000;}
}
unless(defined(&BGE_EEADDR_RESET)) {
    sub BGE_EEADDR_RESET () {	0x20000000;}
}
unless(defined(&BGE_EEADDR_DONE)) {
    sub BGE_EEADDR_DONE () {	0x40000000;}
}
unless(defined(&BGE_EEADDR_RW)) {
    sub BGE_EEADDR_RW () {	0x80000000;}
}
unless(defined(&BGE_EEDEVID)) {
    sub BGE_EEDEVID {
	my($x) = @_;
	eval q((($x & 7) << 26));
    }
}
unless(defined(&BGE_EEHALFCLK)) {
    sub BGE_EEHALFCLK {
	my($x) = @_;
	eval q((($x & 0x1ff) << 16));
    }
}
unless(defined(&BGE_HALFCLK_384SCL)) {
    sub BGE_HALFCLK_384SCL () {	0x60;}
}
unless(defined(&BGE_EE_READCMD)) {
    sub BGE_EE_READCMD () {	( &BGE_EEHALFCLK( &BGE_HALFCLK_384SCL)| &BGE_EEDEVID(0)|  &BGE_EEADDR_START| &BGE_EEADDR_RW| &BGE_EEADDR_DONE);}
}
unless(defined(&BGE_EE_WRCMD)) {
    sub BGE_EE_WRCMD () {	( &BGE_EEHALFCLK( &BGE_HALFCLK_384SCL)| &BGE_EEDEVID(0)|  &BGE_EEADDR_START| &BGE_EEADDR_DONE);}
}
unless(defined(&BGE_EECTL_CLKOUT_TRISTATE)) {
    sub BGE_EECTL_CLKOUT_TRISTATE () {	0x1;}
}
unless(defined(&BGE_EECTL_CLKOUT)) {
    sub BGE_EECTL_CLKOUT () {	0x2;}
}
unless(defined(&BGE_EECTL_CLKIN)) {
    sub BGE_EECTL_CLKIN () {	0x4;}
}
unless(defined(&BGE_EECTL_DATAOUT_TRISTATE)) {
    sub BGE_EECTL_DATAOUT_TRISTATE () {	0x8;}
}
unless(defined(&BGE_EECTL_DATAOUT)) {
    sub BGE_EECTL_DATAOUT () {	0x10;}
}
unless(defined(&BGE_EECTL_DATAIN)) {
    sub BGE_EECTL_DATAIN () {	0x20;}
}
unless(defined(&BGE_MDI_DATA)) {
    sub BGE_MDI_DATA () {	0x1;}
}
unless(defined(&BGE_MDI_DIR)) {
    sub BGE_MDI_DIR () {	0x2;}
}
unless(defined(&BGE_MDI_SEL)) {
    sub BGE_MDI_SEL () {	0x4;}
}
unless(defined(&BGE_MDI_CLK)) {
    sub BGE_MDI_CLK () {	0x8;}
}
unless(defined(&BGE_MEMWIN_START)) {
    sub BGE_MEMWIN_START () {	0x8000;}
}
unless(defined(&BGE_MEMWIN_END)) {
    sub BGE_MEMWIN_END () {	0xffff;}
}
unless(defined(&BGE_MEMWIN_READ)) {
    sub BGE_MEMWIN_READ {
	my($pc, $tag, $x, $val) = @_;
	eval q( &do {  &pci_conf_write($pc, $tag,  &BGE_PCI_MEMWIN_BASEADDR, (0xffff0000 & $x)); $val =  &CSR_READ_4( &sc,  &BGE_MEMWIN_START + ($x & 0xffff)); }  &while(0));
    }
}
unless(defined(&BGE_MEMWIN_WRITE)) {
    sub BGE_MEMWIN_WRITE {
	my($pc, $tag, $x, $val) = @_;
	eval q( &do {  &pci_conf_write($pc, $tag,  &BGE_PCI_MEMWIN_BASEADDR, (0xffff0000 & $x));  &CSR_WRITE_4( &sc,  &BGE_MEMWIN_START + ($x & 0xffff), $val); }  &while(0));
    }
}
unless(defined(&BGE_MAGIC_NUMBER)) {
    sub BGE_MAGIC_NUMBER () {	0x4b657654;}
}
unless(defined(&BGE_HOSTADDR)) {
    sub BGE_HOSTADDR {
	my($x,$y) = @_;
	eval q( &do { ($x). &bge_addr_lo = (( &u_int64_t) ($y) & 0xffffffff);  &if ($sizeof{ &bus_addr_t} == 8) ($x). &bge_addr_hi = (( &u_int64_t) ($y) >> 32);  &else ($x). &bge_addr_hi = 0; }  &while(0));
    }
}
unless(defined(&RCB_WRITE_4)) {
    sub RCB_WRITE_4 {
	my($sc, $rcb, $offset, $val) = @_;
	eval q( &bus_space_write_4( ($sc->{bge_btag}),  ($sc->{bge_bhandle}), $rcb +  &offsetof('struct bge_rcb', $offset), $val));
    }
}
unless(defined(&RCB_WRITE_2)) {
    sub RCB_WRITE_2 {
	my($sc, $rcb, $offset, $val) = @_;
	eval q( &bus_space_write_2( ($sc->{bge_btag}),  ($sc->{bge_bhandle}), $rcb +  &offsetof('struct bge_rcb', $offset), $val));
    }
}
unless(defined(&BGE_RCB_MAXLEN_FLAGS)) {
    sub BGE_RCB_MAXLEN_FLAGS {
	my($maxlen, $flags) = @_;
	eval q((($maxlen) << 16| ($flags)));
    }
}
unless(defined(&BGE_RCB_FLAG_USE_EXT_RX_BD)) {
    sub BGE_RCB_FLAG_USE_EXT_RX_BD () {	0x1;}
}
unless(defined(&BGE_RCB_FLAG_RING_DISABLED)) {
    sub BGE_RCB_FLAG_RING_DISABLED () {	0x2;}
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : undef)) {
} else {
}
unless(defined(&BGE_TXBDFLAG_TCP_UDP_CSUM)) {
    sub BGE_TXBDFLAG_TCP_UDP_CSUM () {	0x1;}
}
unless(defined(&BGE_TXBDFLAG_IP_CSUM)) {
    sub BGE_TXBDFLAG_IP_CSUM () {	0x2;}
}
unless(defined(&BGE_TXBDFLAG_END)) {
    sub BGE_TXBDFLAG_END () {	0x4;}
}
unless(defined(&BGE_TXBDFLAG_IP_FRAG)) {
    sub BGE_TXBDFLAG_IP_FRAG () {	0x8;}
}
unless(defined(&BGE_TXBDFLAG_JMB_PKT)) {
    sub BGE_TXBDFLAG_JMB_PKT () {	0x8;}
}
unless(defined(&BGE_TXBDFLAG_IP_FRAG_END)) {
    sub BGE_TXBDFLAG_IP_FRAG_END () {	0x10;}
}
unless(defined(&BGE_TXBDFLAG_VLAN_TAG)) {
    sub BGE_TXBDFLAG_VLAN_TAG () {	0x40;}
}
unless(defined(&BGE_TXBDFLAG_COAL_NOW)) {
    sub BGE_TXBDFLAG_COAL_NOW () {	0x80;}
}
unless(defined(&BGE_TXBDFLAG_CPU_PRE_DMA)) {
    sub BGE_TXBDFLAG_CPU_PRE_DMA () {	0x100;}
}
unless(defined(&BGE_TXBDFLAG_CPU_POST_DMA)) {
    sub BGE_TXBDFLAG_CPU_POST_DMA () {	0x200;}
}
unless(defined(&BGE_TXBDFLAG_INSERT_SRC_ADDR)) {
    sub BGE_TXBDFLAG_INSERT_SRC_ADDR () {	0x1000;}
}
unless(defined(&BGE_TXBDFLAG_CHOOSE_SRC_ADDR)) {
    sub BGE_TXBDFLAG_CHOOSE_SRC_ADDR () {	0x6000;}
}
unless(defined(&BGE_TXBDFLAG_NO_CRC)) {
    sub BGE_TXBDFLAG_NO_CRC () {	0x8000;}
}
unless(defined(&BGE_NIC_TXRING_ADDR)) {
    sub BGE_NIC_TXRING_ADDR {
	my($ringno, $size) = @_;
	eval q( &BGE_SEND_RING_1_TO_4 + (($ringno * $sizeof{'struct bge_tx_bd'} * $size) / 4));
    }
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : undef)) {
} else {
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : undef)) {
} else {
}
unless(defined(&BGE_RXBDFLAG_END)) {
    sub BGE_RXBDFLAG_END () {	0x4;}
}
unless(defined(&BGE_RXBDFLAG_JUMBO_RING)) {
    sub BGE_RXBDFLAG_JUMBO_RING () {	0x20;}
}
unless(defined(&BGE_RXBDFLAG_VLAN_TAG)) {
    sub BGE_RXBDFLAG_VLAN_TAG () {	0x40;}
}
unless(defined(&BGE_RXBDFLAG_ERROR)) {
    sub BGE_RXBDFLAG_ERROR () {	0x400;}
}
unless(defined(&BGE_RXBDFLAG_MINI_RING)) {
    sub BGE_RXBDFLAG_MINI_RING () {	0x800;}
}
unless(defined(&BGE_RXBDFLAG_IP_CSUM)) {
    sub BGE_RXBDFLAG_IP_CSUM () {	0x1000;}
}
unless(defined(&BGE_RXBDFLAG_TCP_UDP_CSUM)) {
    sub BGE_RXBDFLAG_TCP_UDP_CSUM () {	0x2000;}
}
unless(defined(&BGE_RXBDFLAG_TCP_UDP_IS_TCP)) {
    sub BGE_RXBDFLAG_TCP_UDP_IS_TCP () {	0x4000;}
}
unless(defined(&BGE_RXERRFLAG_BAD_CRC)) {
    sub BGE_RXERRFLAG_BAD_CRC () {	0x1;}
}
unless(defined(&BGE_RXERRFLAG_COLL_DETECT)) {
    sub BGE_RXERRFLAG_COLL_DETECT () {	0x2;}
}
unless(defined(&BGE_RXERRFLAG_LINK_LOST)) {
    sub BGE_RXERRFLAG_LINK_LOST () {	0x4;}
}
unless(defined(&BGE_RXERRFLAG_PHY_DECODE_ERR)) {
    sub BGE_RXERRFLAG_PHY_DECODE_ERR () {	0x8;}
}
unless(defined(&BGE_RXERRFLAG_MAC_ABORT)) {
    sub BGE_RXERRFLAG_MAC_ABORT () {	0x10;}
}
unless(defined(&BGE_RXERRFLAG_RUNT)) {
    sub BGE_RXERRFLAG_RUNT () {	0x20;}
}
unless(defined(&BGE_RXERRFLAG_TRUNC_NO_RSRCS)) {
    sub BGE_RXERRFLAG_TRUNC_NO_RSRCS () {	0x40;}
}
unless(defined(&BGE_RXERRFLAG_GIANT)) {
    sub BGE_RXERRFLAG_GIANT () {	0x80;}
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : undef)) {
} else {
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : undef)) {
} else {
}
unless(defined(&BGE_TX_CONSIDX)) {
    sub BGE_TX_CONSIDX {
	my($x, $i) = @_;
	eval q( ($x->{bge_idx[$i]}->{bge_tx_considx}));
    }
}
unless(defined(&BGE_RX_PRODIDX)) {
    sub BGE_RX_PRODIDX {
	my($x, $i) = @_;
	eval q( ($x->{bge_idx[$i]}->{bge_rx_prodidx}));
    }
}
unless(defined(&BGE_STATFLAG_UPDATED)) {
    sub BGE_STATFLAG_UPDATED () {	0x1;}
}
unless(defined(&BGE_STATFLAG_LINKSTATE_CHANGED)) {
    sub BGE_STATFLAG_LINKSTATE_CHANGED () {	0x2;}
}
unless(defined(&BGE_STATFLAG_ERROR)) {
    sub BGE_STATFLAG_ERROR () {	0x4;}
}
unless(defined(&SK_SUBSYSID_9D41)) {
    sub SK_SUBSYSID_9D41 () {	0x4441;}
}
unless(defined(&DELL_VENDORID)) {
    sub DELL_VENDORID () {	0x1028;}
}
unless(defined(&BGE_EE_MAC_OFFSET)) {
    sub BGE_EE_MAC_OFFSET () {	0x7c;}
}
unless(defined(&BGE_EE_MAC_OFFSET_5906)) {
    sub BGE_EE_MAC_OFFSET_5906 () {	0x10;}
}
unless(defined(&BGE_EE_HWCFG_OFFSET)) {
    sub BGE_EE_HWCFG_OFFSET () {	0xc8;}
}
unless(defined(&BGE_HWCFG_VOLTAGE)) {
    sub BGE_HWCFG_VOLTAGE () {	0x3;}
}
unless(defined(&BGE_HWCFG_PHYLED_MODE)) {
    sub BGE_HWCFG_PHYLED_MODE () {	0xc;}
}
unless(defined(&BGE_HWCFG_MEDIA)) {
    sub BGE_HWCFG_MEDIA () {	0x30;}
}
unless(defined(&BGE_HWCFG_ASF)) {
    sub BGE_HWCFG_ASF () {	0x80;}
}
unless(defined(&BGE_VOLTAGE_1POINT3)) {
    sub BGE_VOLTAGE_1POINT3 () {	0x;}
}
unless(defined(&BGE_VOLTAGE_1POINT8)) {
    sub BGE_VOLTAGE_1POINT8 () {	0x1;}
}
unless(defined(&BGE_PHYLEDMODE_UNSPEC)) {
    sub BGE_PHYLEDMODE_UNSPEC () {	0x;}
}
unless(defined(&BGE_PHYLEDMODE_TRIPLELED)) {
    sub BGE_PHYLEDMODE_TRIPLELED () {	0x4;}
}
unless(defined(&BGE_PHYLEDMODE_SINGLELED)) {
    sub BGE_PHYLEDMODE_SINGLELED () {	0x8;}
}
unless(defined(&BGE_MEDIA_UNSPEC)) {
    sub BGE_MEDIA_UNSPEC () {	0x;}
}
unless(defined(&BGE_MEDIA_COPPER)) {
    sub BGE_MEDIA_COPPER () {	0x10;}
}
unless(defined(&BGE_MEDIA_FIBER)) {
    sub BGE_MEDIA_FIBER () {	0x20;}
}
unless(defined(&BGE_TICKS_PER_SEC)) {
    sub BGE_TICKS_PER_SEC () {	1000000;}
}
unless(defined(&BGE_EVENT_RING_CNT)) {
    sub BGE_EVENT_RING_CNT () {	256;}
}
unless(defined(&BGE_CMD_RING_CNT)) {
    sub BGE_CMD_RING_CNT () {	64;}
}
unless(defined(&BGE_STD_RX_RING_CNT)) {
    sub BGE_STD_RX_RING_CNT () {	512;}
}
unless(defined(&BGE_JUMBO_RX_RING_CNT)) {
    sub BGE_JUMBO_RX_RING_CNT () {	256;}
}
unless(defined(&BGE_MINI_RX_RING_CNT)) {
    sub BGE_MINI_RX_RING_CNT () {	1024;}
}
unless(defined(&BGE_RETURN_RING_CNT)) {
    sub BGE_RETURN_RING_CNT () {	1024;}
}
unless(defined(&BGE_RETURN_RING_CNT_5705)) {
    sub BGE_RETURN_RING_CNT_5705 () {	512;}
}
unless(defined(&BGE_TX_RING_CNT_128)) {
    sub BGE_TX_RING_CNT_128 () {	128;}
}
unless(defined(&BGE_TX_RING_BASE_128)) {
    sub BGE_TX_RING_BASE_128 () {	0x3800;}
}
unless(defined(&BGE_TX_RING_CNT_256)) {
    sub BGE_TX_RING_CNT_256 () {	256;}
}
unless(defined(&BGE_TX_RING_BASE_256)) {
    sub BGE_TX_RING_BASE_256 () {	0x3000;}
}
unless(defined(&BGE_TX_RING_CNT_512)) {
    sub BGE_TX_RING_CNT_512 () {	512;}
}
unless(defined(&BGE_TX_RING_BASE_512)) {
    sub BGE_TX_RING_BASE_512 () {	0x2000;}
}
unless(defined(&BGE_TX_RING_CNT)) {
    sub BGE_TX_RING_CNT () {	 &BGE_TX_RING_CNT_512;}
}
unless(defined(&BGE_TX_RING_BASE)) {
    sub BGE_TX_RING_BASE () {	 &BGE_TX_RING_BASE_512;}
}
unless(defined(&BGE_JUMBO_FRAMELEN)) {
    sub BGE_JUMBO_FRAMELEN () {	9022;}
}
unless(defined(&BGE_JUMBO_MTU)) {
    sub BGE_JUMBO_MTU () {	( &BGE_JUMBO_FRAMELEN -  &ETHER_HDR_LEN -  &ETHER_CRC_LEN -  &ETHER_VLAN_ENCAP_LEN);}
}
unless(defined(&BGE_PAGE_SIZE)) {
    sub BGE_PAGE_SIZE () {	 &PAGE_SIZE;}
}
unless(defined(&BGE_INC)) {
    sub BGE_INC {
	my($x, $y) = @_;
	eval q(($x) = ($x + 1) % $y);
    }
}
unless(defined(&BGE_VPD_FLAG)) {
    sub BGE_VPD_FLAG () {	0x8000;}
}
unless(defined(&VPD_RES_ID)) {
    sub VPD_RES_ID () {	0x82;}
}
unless(defined(&VPD_RES_READ)) {
    sub VPD_RES_READ () {	0x90;}
}
unless(defined(&VPD_RES_WRITE)) {
    sub VPD_RES_WRITE () {	0x81;}
}
unless(defined(&VPD_RES_END)) {
    sub VPD_RES_END () {	0x78;}
}
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4( ($sc->{bge_btag}),  ($sc->{bge_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_4( ($sc->{bge_btag}),  ($sc->{bge_bhandle}), $reg));
    }
}
unless(defined(&BGE_SETBIT)) {
    sub BGE_SETBIT {
	my($sc, $reg, $x) = @_;
	eval q( &CSR_WRITE_4($sc, $reg, ( &CSR_READ_4($sc, $reg) | ($x))));
    }
}
unless(defined(&BGE_CLRBIT)) {
    sub BGE_CLRBIT {
	my($sc, $reg, $x) = @_;
	eval q( &CSR_WRITE_4($sc, $reg, ( &CSR_READ_4($sc, $reg) & ~($x))));
    }
}
unless(defined(&PCI_SETBIT)) {
    sub PCI_SETBIT {
	my($pc, $tag, $reg, $x) = @_;
	eval q( &pci_conf_write($pc, $tag, $reg, ( &pci_conf_read($pc, $tag, $reg) | ($x))));
    }
}
unless(defined(&PCI_CLRBIT)) {
    sub PCI_CLRBIT {
	my($pc, $tag, $reg, $x) = @_;
	eval q( &pci_conf_write($pc, $tag, $reg, ( &pci_conf_read($pc, $tag, $reg) & ~($x))));
    }
}
unless(defined(&BGE_SSLOTS)) {
    sub BGE_SSLOTS () {	256;}
}
unless(defined(&BGE_MSLOTS)) {
    sub BGE_MSLOTS () {	256;}
}
unless(defined(&BGE_JSLOTS)) {
    sub BGE_JSLOTS () {	384;}
}
unless(defined(&BGE_JRAWLEN)) {
    sub BGE_JRAWLEN () {	( &BGE_JUMBO_FRAMELEN +  &ETHER_ALIGN);}
}
unless(defined(&BGE_JLEN)) {
    sub BGE_JLEN () {	( &BGE_JRAWLEN + ($sizeof{ &u_int64_t} - ( &BGE_JRAWLEN % $sizeof{ &u_int64_t})));}
}
unless(defined(&BGE_RING_DMA_ADDR)) {
    sub BGE_RING_DMA_ADDR {
	my($sc, $offset) = @_;
	eval q((($sc)-> ($bge_ring_map->{dm_segs[0]}->{ds_addr}) +  &offsetof('struct bge_ring_data', $offset)));
    }
}
if(defined(&__LP64__)) {
    eval 'sub BGE_NTXSEG () {30;}' unless defined(&BGE_NTXSEG);
} else {
    eval 'sub BGE_NTXSEG () {31;}' unless defined(&BGE_NTXSEG);
}
unless(defined(&BGE_TIMEOUT)) {
    sub BGE_TIMEOUT () {	100000;}
}
unless(defined(&BGE_TXCONS_UNSET)) {
    sub BGE_TXCONS_UNSET () {	0xffff;}
}
unless(defined(&ASF_ENABLE)) {
    sub ASF_ENABLE () {	1;}
}
unless(defined(&ASF_NEW_HANDSHAKE)) {
    sub ASF_NEW_HANDSHAKE () {	2;}
}
unless(defined(&ASF_STACKUP)) {
    sub ASF_STACKUP () {	4;}
}
unless(defined(&BGE_TXRING_VALID)) {
    sub BGE_TXRING_VALID () {	0x1;}
}
unless(defined(&BGE_RXRING_VALID)) {
    sub BGE_RXRING_VALID () {	0x2;}
}
unless(defined(&BGE_JUMBO_RXRING_VALID)) {
    sub BGE_JUMBO_RXRING_VALID () {	0x4;}
}
unless(defined(&BGE_RX_ALIGNBUG)) {
    sub BGE_RX_ALIGNBUG () {	0x8;}
}
unless(defined(&BGE_NO_3LED)) {
    sub BGE_NO_3LED () {	0x10;}
}
unless(defined(&BGE_PCIX)) {
    sub BGE_PCIX () {	0x20;}
}
unless(defined(&BGE_PCIE)) {
    sub BGE_PCIE () {	0x40;}
}
unless(defined(&BGE_ASF_MODE)) {
    sub BGE_ASF_MODE () {	0x80;}
}
unless(defined(&BGE_NO_EEPROM)) {
    sub BGE_NO_EEPROM () {	0x100;}
}
unless(defined(&BGE_JUMBO_CAPABLE)) {
    sub BGE_JUMBO_CAPABLE () {	0x200;}
}
unless(defined(&BGE_10_100_ONLY)) {
    sub BGE_10_100_ONLY () {	0x400;}
}
unless(defined(&BGE_PHY_FIBER_TBI)) {
    sub BGE_PHY_FIBER_TBI () {	0x800;}
}
unless(defined(&BGE_PHY_FIBER_MII)) {
    sub BGE_PHY_FIBER_MII () {	0x1000;}
}
unless(defined(&BGE_PHY_CRC_BUG)) {
    sub BGE_PHY_CRC_BUG () {	0x2000;}
}
unless(defined(&BGE_PHY_ADC_BUG)) {
    sub BGE_PHY_ADC_BUG () {	0x4000;}
}
unless(defined(&BGE_PHY_5704_A0_BUG)) {
    sub BGE_PHY_5704_A0_BUG () {	0x8000;}
}
unless(defined(&BGE_PHY_JITTER_BUG)) {
    sub BGE_PHY_JITTER_BUG () {	0x10000;}
}
unless(defined(&BGE_PHY_BER_BUG)) {
    sub BGE_PHY_BER_BUG () {	0x20000;}
}
unless(defined(&BGE_PHY_ADJUST_TRIM)) {
    sub BGE_PHY_ADJUST_TRIM () {	0x40000;}
}
unless(defined(&BGE_NO_ETH_WIRE_SPEED)) {
    sub BGE_NO_ETH_WIRE_SPEED () {	0x80000;}
}
unless(defined(&BGE_IS_5788)) {
    sub BGE_IS_5788 () {	0x100000;}
}
unless(defined(&BGE_5705_PLUS)) {
    sub BGE_5705_PLUS () {	0x200000;}
}
unless(defined(&BGE_5750_PLUS)) {
    sub BGE_5750_PLUS () {	0x400000;}
}
unless(defined(&BGE_5755_PLUS)) {
    sub BGE_5755_PLUS () {	0x800000;}
}
unless(defined(&BGE_5714_FAMILY)) {
    sub BGE_5714_FAMILY () {	0x1000000;}
}
unless(defined(&BGE_5700_FAMILY)) {
    sub BGE_5700_FAMILY () {	0x2000000;}
}
unless(defined(&BGE_STS_LINK)) {
    sub BGE_STS_LINK () {	0x1;}
}
unless(defined(&BGE_STS_LINK_EVT)) {
    sub BGE_STS_LINK_EVT () {	0x2;}
}
unless(defined(&BGE_STS_AUTOPOLL)) {
    sub BGE_STS_AUTOPOLL () {	0x4;}
}
unless(defined(&BGE_STS_BIT)) {
    sub BGE_STS_BIT {
	my($sc, $x) = @_;
	eval q((($sc)-> &bge_sts & ($x)));
    }
}
unless(defined(&BGE_STS_SETBIT)) {
    sub BGE_STS_SETBIT {
	my($sc, $x) = @_;
	eval q((($sc)-> &bge_sts |= ($x)));
    }
}
unless(defined(&BGE_STS_CLRBIT)) {
    sub BGE_STS_CLRBIT {
	my($sc, $x) = @_;
	eval q((($sc)-> &bge_sts &= ~($x)));
    }
}
1;
